define(['backbone'],
function (Backbone) {
   var Setting = Backbone.Model.extend({
    defaults: {
      outputFolder: '',
	  fnameFormat: FILEFORMAT,
	  toolOrder: TOOLS,
	  selectedTools: ''
    },
	initialize: function(){
		
		_.bindAll(this, 'getOutputFolder', 'setOutputFolder','getFileFormat','setFileFormat','getToolOrder','setToolOrder','getSelectedTools','setSelectedTools');
	},
	getOutputFolder : function(){
		var outputFolder = localStorage.getItem('outputFolder');
		if(outputFolder == "" || outputFolder == null){
			outputFolder = 'pictures';
			localStorage.setItem("outputFolder", outputFolder);	
		}
		return outputFolder;
	},
	setOutputFolder : function(outputFolder) {
		this.set({outputFolder: outputFolder});
		localStorage.setItem("outputFolder", outputFolder);	
	},	
	
	getFileFormat : function() {
		var fileFormat = localStorage.getItem('fnameFormat');
		if(fileFormat == "" || fileFormat == null){
			fileFormat = FILEFORMAT;
			localStorage.setItem("fnameFormat", fileFormat);
		}
		return fileFormat;
	},
	setFileFormat : function(fileFormat) {
		this.set({fnameFormat: fileFormat});
		localStorage.setItem("fnameFormat", fileFormat);
	},
	getToolOrder : function() {
		var toolsList = localStorage.getItem('toolOrder');
		if(toolsList == "" || toolsList == null){
			toolsList = TOOLS;
            localStorage.setItem("toolOrder", toolsList);
		}
		return toolsList;
	},
	setToolOrder : function(order) {
		this.set({toolOrder: order});
		localStorage.setItem("toolOrder", order);
	},
	getSelectedTools : function() {
		return localStorage.getItem('selectedTools');
	},
	setSelectedTools : function(selectValues){
		this.set({selectedTools: selectValues});
		localStorage.setItem("selectedTools", selectValues);
	}
  });
  

  return Setting;
});