define(['underscore', 'backbone','views/ViewSetting'],
    function(_, Backbone ,ViewSetting) {
        var ViewFileFormat = Backbone.View.extend({
            el: '#view-fileFormat',
            events: {
                'click #fileFormatBack': 'showSettingsView',
                'click #divFileFormat': 'showFileFormat'
            },
            initialize: function() {
                this.$task = this.$('#task');
            },
            render: function() {
                this.$el.removeAttr('aria-hidden').removeClass('slide-down-out').addClass('slide-up-in');
                this.$task.val('');
                this.showFileFormat();
                return this;
            },
            showSettingsView: function() {
                this.$el.hide();
            },
            showFileFormat: function() {
                this.$el.show();
                var pageFile=this.$el;
                var that = this;
                var formatname = this.model.getFileFormat();
                var obj = ["yyMMdd_hhmmss", "yyyyMMdd_hhmmss", "yyddMM_hhmmss", "yyyyddMM_hhmmss", "ddMMyy_hhmmss",
                "ddMMyyyy_hhmmss", "MMddyy_hhmmss", "MMddyyyy_hhmmss",
                "yy-MM-dd_hh-mm-ss", "yyyy-MM-dd_hh-mm-ss", "yy-dd-MM-hh_mm-ss", "yyyy-dd-MM_hh-mm-ss",
                "dd-MM-yy_hh-mm-ss", "dd-MM-yyyy_hh-mm-ss", "MM-dd-yy_hh-mm-ss", "MM-dd-yyyy_hh-mm-ss"];
                $('#fileformatData').html('');
						
                $.each(obj, function(key, value) {
                    var optionsElem = "<div class='borderBottom'><label class='listItem left'>" + value + "</label><input class='right' type='radio' name='fileFormatVal' id='" + value + "' value='" + value + "' ><div class='clr'></div>";
                    $('#fileformatData').append(optionsElem);
					
                });
						
                if (formatname ==='' || formatname === null || formatname === 'undefined') {
                    $("input[name=fileFormatVal][value="+FILEFORMAT+"]").attr('checked', 'checked');
                }
                else {
                    $("input[name=fileFormatVal][value="+formatname+"]").attr('checked', 'checked');
                }
                $('input[name="fileFormatVal"]').iCheck({
                    radioClass: 'iradio_square-blue  right'
                });
						
                $('input[name="fileFormatVal"]').on('ifChecked', function(event){
                    fileFormat = $('input[name="fileFormatVal"]:checked').val();
                    if (window.localStorage) {
                        that.model.setFileFormat(fileFormat);
                    }
                    pageFile.hide();
							
                //$('#fileFormatDesc').html(fileFormat);
							
                });
            },
            cancel: function() {
                this.$el.removeClass('slide-up-in').addClass('slide-down-out');
            },
            hideView: function(e) {
                var $target = $(e.target);

                if (e.animationName === 'slide-down-out') {
                    $target.attr('aria-hidden', 'true');
                }
            }
        });

        return ViewFileFormat;
    });