define(['underscore', 'backbone', 'localytics','views/ViewSetting','views/ViewImageDetails', 'models/Home', 'models/Setting','collections/list'],
    function(_, Backbone, Localytics ,ViewSetting, ViewImageDetails, Home, Setting, List) {

        var ViewHome = Backbone.View.extend({
            el: '#view-home',
            events: {
                'click #settingBtn': 'showSettingsView',
                'click #shareBtn': 'showShare',
                'click #pickBtn': 'pickImage',
                'click #cameraBtn': 'openCamera',
                'click #editBtn ': 'editSelected',
                'click .slide-content': 'editSelected',
					
                'touchstart #settingBtn, #shareBtn, #feedbackBtn, #cameraBtn, #editBtn, #pickBtn': 'changeBg',
                'touchend #settingBtn, #shareBtn, #feedbackBtn, #cameraBtn, #editBtn, #pickBtn': 'removeBg'
            },
            initialize: function() {
                _.bindAll(this, 'pickImage','showSettingsView');
                this.viewSetting = this.viewSetting || new ViewSetting({
                    model: this.model
                });
                this.render();
               
            },
              
            render: function() {
                this.$el.removeAttr('aria-hidden');
                return this;
            },
            changeBg: function(event){
                var currentId= $(event.currentTarget).attr("id");
                $(event.currentTarget).addClass(currentId+"ChangeBg");
                $(event.currentTarget).removeClass(currentId+"Bg");
            },
            removeBg: function(event){
                var currentId= $(event.currentTarget).attr("id");
                $(event.currentTarget).removeClass(currentId+"ChangeBg");
                $(event.currentTarget).addClass(currentId+"Bg");
            },
            showSettingsView: function() {
                // console.log('showSettingsView');
			
                $('#view-setting').show();
                this.viewSetting.render();
                this.delegateEvents();
				localyticsSession.tagEvent("Change Settings.");
                localyticsSession.upload();
                //localyticsSession.close();
            },
            editSelected: function() {
                var homeScreen = $('#homeScreen');
                homeScreen.css('visibility','hidden');
                if(APP.viewSplash.gallery){
                    var pos =  APP.viewSplash.gallery.getIndex();
						   
                    var imageSrc = $('div.slide[data-index="'+pos+'"] img').attr('src');
                    $('#selImage').attr('src',imageSrc);
                    $('#avpw_holder').show();
                    var toollist = this.model.getSelectedTools();
					
                    if(toollist == null){
                        toollist = TOOLS;
                    }
				
                    featherEditor.launch({
                        image: selImage,
                        tools: toollist
                    });
                //this.checkNetwork();
                
                    localyticsSession.tagEvent("Edit this photo.");
                    localyticsSession.upload();
                    //localyticsSession.close();
                }else{
                    homeScreen.css('visibility','visible');
                }
				
            },
            pickImage: function() {
                var that = this;
                var pickImageActivity = new MozActivity({
                    name: "pick",
                    data: {
                        type: ["image/png", "image/jpg", "image/jpeg"]
                    }
                });
                    
                pickImageActivity.onsuccess = function() {
                    //Create the element via jQuery
                        
                    $('#selImage').attr('src',window.URL.createObjectURL(this.result.blob));
                    $('#avpw_holder').show();
                    var toollist = that.model.getSelectedTools();
                    if(toollist == null){
                        toollist = TOOLS;
                    }
                    featherEditor.launch({
                        image: selImage,
                        tools: toollist
                    });

                };

                pickImageActivity.onerror = function(event) {
                //console.log(event);
                };

            },
            openCamera: function() {
				
                var pickImageActivity = new MozActivity({
                    name: "record",
                    data: {
                        type: "photos"
                    }
                });

                pickImageActivity.onsuccess = function() {
					
                    //Create the element via jQuery
                    $('#selImage').attr('src',window.URL.createObjectURL(this.result.blob));
                    $('#avpw_holder').show();
                    var toollist = this.model.getSelectedTools();
						
                    if(toollist == null){
                        toollist = TOOLS;
                    }
                    featherEditor.launch({
                        image: selImage,
                        tools: toollist
                    });
                };

                pickImageActivity.onerror = function(event) {
                    console.log(event);
                };
            },
            showShare: function() {
                var pos =  APP.viewSplash.gallery.getIndex();
                imgToShare = document.querySelector('div.slide[data-index="'+pos+'"] img');
                if (imgToShare.naturalWidth > 0) {
                    name = imgToShare.title;
                    // Create dummy canvas
                    var blobCanvas = document.createElement("canvas");
                    blobCanvas.width = imgToShare.naturalWidth;
                    blobCanvas.height = imgToShare.naturalHeight;
                    ;
                    // Get context and draw image
                    var blobCanvasContext = blobCanvas.getContext("2d");
                    blobCanvasContext.drawImage(imgToShare, 0, 0);

                    // Export to blob and share through a Web Activitiy
                    
                    blobCanvas.toBlob(function(blob) {
                   
                        var a = new MozActivity({
                            name: 'share',
                            data: {
                                type: "image/*",
                                number: 1,
                                blobs: [blob],
                                filenames: [name],
                                filepaths: [name]
                            }
                        });
                        
                         var request = window.navigator.mozApps.getSelf();
                       
                        request.onerror = function() {
                            console("Error: " + request.error.name);
                        };
                        a.onerror = function(e) {
                            if (a.error.name === 'NO_PROVIDER') {
                                var msg = navigator.mozL10n.get('share-noprovider');
                            }
                            else {
                               
                                request.result.launch();

                                console.warn('share activity error:', a.error.name);
                             
                            }
                        };
                        
                        /* a.onsuccess = function() {

                                request.result.launch();
                        }; */
                    });

                    localyticsSession.tagEvent("Share this photo.");
                    localyticsSession.upload();
                    //localyticsSession.close();
                }
                else {
                    msg = this.$el.children('p#shareFail').html();
                    alert(msg);
                }

            }
        /*checkNetwork: function() {
					var condition = navigator.onLine ? "online" : "offline";
					 if(condition == "offline"){
						var msg = this.$el.children().find('#conString').html()
                        alert(msg);
					 } 
				},*/
          
        });

        return ViewHome;
    });
        
        