define(['underscore', 'backbone','localytics','views/ViewHome','views/ViewImageInfo'],
    function(_, Backbone ,Localytics,ViewHome,ViewImageInfo) {
        var ViewImageDetails = Backbone.View.extend({
            el: '#view-imageDetails',
			imgPosition : '',
            events: {
                'click #shareDiv': 'showShare',
                'click #editDiv': 'editSelected',
                'click #detailDiv': 'showImageInfo',
                'click #deleteDiv' : 'deleteConfirm',
                'click #cancelBtn' : 'showHomeView'

            },
            initialize: function() {
                console.log("ViewImageDetails initialize");
                this.$el.unbind();
                //$('.swiper-container').hide();
                _.bindAll(this, 'adjustGalleryAfterDelete', 'deleteConfirm');
				this.collection.off("onAdjustGallery");
                this.collection.on("onAdjustGallery", this.adjustGalleryAfterDelete, this);
            },
            render: function() {
                this.$el.removeAttr('aria-hidden').removeClass('slide-down-out').addClass('slide-up-in');
                
                return this;
            },
            showShare: function() {
                localyticsSession.tagEvent("Share this photo.");
                localyticsSession.upload();
                this.$el.hide();
                var pos =  APP.viewSplash.gallery.getIndex();
                imgToShare = document.querySelector('div.slide[data-index="'+pos+'"] img');
                //  imgToShare = document.querySelector("div.swiper-slide-active img");
                if (imgToShare.naturalWidth > 0) {
                    name = imgToShare.title;
                    // Create dummy canvas
                    var blobCanvas = document.createElement("canvas");
                    blobCanvas.width = imgToShare.naturalWidth;
                    blobCanvas.height = imgToShare.naturalHeight;
                    ;
                    // Get context and draw image
                    var blobCanvasContext = blobCanvas.getContext("2d");
                    blobCanvasContext.drawImage(imgToShare, 0, 0);

                    // Export to blob and share through a Web Activitiy
                    
                    blobCanvas.toBlob(function(blob) {
                   
                        var a = new MozActivity({
                            name: 'share',
                            data: {
                                type: "image/*",
                                number: 1,
                                blobs: [blob],
                                filenames: [name],
                                filepaths: [name]
                            }
                        });

                        var request = window.navigator.mozApps.getSelf();
                       
                        a.onerror = function(e) {
                            if (a.error.name === 'NO_PROVIDER') {
                                var msg = navigator.mozL10n.get('share-noprovider');
                            }
                            else {
                               
                                request.result.launch();
                                console.warn('share activity error:', a.error.name);
                            }
                        };
                     /*   a.onsuccess = function() {
                            request.result.launch();
                        }; */
                    });
                }
                else {
                    msg = this.$el.children('p#shareFail').html();
                    alert(msg);
                }
                this.$el.hide();
            },
            editSelected: function() {
                this.$el.hide();
                var pos =  APP.viewSplash.gallery.getIndex();               
                APP.viewHome.editSelected();

            },
            showImageInfo: function() {
                localyticsSession.tagEvent("View image details.");
                localyticsSession.upload();
                this.$el.hide();
                this.viewImageInfo = this.viewImageInfo || new ViewImageInfo();
                this.viewImageInfo.render();


                //Remove existing events and reattach then
                //using this.events hash
                this.delegateEvents();

            },
            deleteConfirm : function(event){
                localyticsSession.tagEvent("Delete this photo.");
                localyticsSession.upload();
                this.$el.hide();
                var deleteFoto = confirm(this.$el.children('p#deleteConfirm').html());
                if (deleteFoto) {
                   
                    event.preventDefault();
                    event.stopPropagation();
                    var pos =  APP.viewSplash.gallery.getIndex();
                    console.log("pos", pos);
					this.imgPosition = pos;
                    this.collection.deleteImg(pos);
                    //this.adjustGalleryAfterDelete(pos);
                }
                else{
                    //  $('.swiper-container').show();
                    $('#view-imageDetails').hide();

                }
                
            },

            adjustGalleryAfterDelete: function(){
                if(this.collection.models.length > 1){
                    //var prevLength  =  APP.viewSplash.carouselLinks.length + 1;

                    var prevLength  = this.collection.models.length;
                    var deletedLast = this.imgPosition == prevLength;
                    var deletedInBetween = this.imgPosition <= prevLength - 1;
                    if(deletedLast){
                        //move to new last
                        APP.viewSplash.gallery.slide( this.collection.models.length - 1 );
                    }else if(deletedInBetween){
                        //move to next ie. new slide at same position
                        APP.viewSplash.gallery.slide( this.imgPosition );
                    }
                }
            },

            showHomeView: function() {
                this.$el.hide();
            },
            cancel: function() {
                this.$el.removeClass('slide-up-in').addClass('slide-down-out');
            },
            hideView: function(e) {
                var $target = $(e.target);

                if (e.animationName === 'slide-down-out') {
                    $target.attr('aria-hidden', 'true');
                }
            }
            
        });

        return ViewImageDetails;
    });
 