define(['underscore', 'backbone','views/ViewSetting'],
    function(_, Backbone ,ViewSetting) {
        var ViewImageInfo = Backbone.View.extend({
            el: '#view-imageInfo',
            events: {
                'click #imageInfoCancel': 'showHomeView',
                'click #divOutputFolder': 'showOutputFolder'
            },
            initialize: function() {
                this.$task = this.$('#task');
                this.$el.on('animationend', this.hideView);
						
            },
            render: function() {
                this.$el.removeAttr('aria-hidden').removeClass('slide-down-out').addClass('slide-up-in');
                this.$task.val('');
                this.showOutputFolder();
                return this;
            },			
            showHomeView: function() {
                //console.log('showHomeView');
					
                this.$el.hide();
						
            },
					
            showOutputFolder: function() {
                this.$el.show();
						
                var pos =  APP.viewSplash.gallery.getIndex();
                imageData = document.querySelector('div.slide[data-index="'+pos+'"] img');
                //imageData = document.querySelector("div.swiper-slide-active img");
                var dimension = imageData.naturalWidth+"x"+imageData.naturalHeight;
                var imagetitle = $(imageData).attr('title');
                var size = formatSizeUnits(APP.viewSplash.collection.at(pos).attributes.size);
                var datetime = APP.viewSplash.collection.at(pos).attributes.datetime;
                        
                $('#imgTitle').html(imagetitle);
                $('#imgSize').html(size);
                $('#imgDateTime').html(datetime);
                $('#imgDim').html(dimension);
						
                                                
                function formatSizeUnits(bytes)
                {
                   if     (bytes>=1073741824) {bytes=(bytes/1073741824).toFixed(2)+' GB';}
				  else if (bytes>=1048576)    {bytes=(bytes/1048576).toFixed(2)+' MB';}
				  else if (bytes>=1024)       {bytes=(bytes/1024).toFixed(2)+' KB';}
				  else if (bytes>1)           {bytes=bytes+' bytes';}
				  else if (bytes==1)          {bytes=bytes+' byte';}
				  else                        {bytes='0 byte';}
				  return bytes;
                }
            },
            cancel: function() {
                this.$el.removeClass('slide-up-in').addClass('slide-down-out');
            },
            hideView: function(e) {
                var $target = $(e.target);

                if (e.animationName === 'slide-down-out') {
                    $target.attr('aria-hidden', 'true');
                }
            }
        });

        return ViewImageInfo;
    });