define(['underscore', 'backbone','views/ViewSetting'],
    function(_, Backbone ,ViewSetting) {
        var ViewOutputFolder = Backbone.View.extend({
            el: '#view-outputFolder',
            events: {
                'click #outputCancel': 'showSettingsView',
                'click #divOutputFolder': 'showOutputFolder',
            },
            initialize: function() {
                this.$task = this.$('#task');
                this.$el.on('animationend', this.hideView);
						
            },
            render: function() {
						
                this.$el.removeAttr('aria-hidden').removeClass('slide-down-out').addClass('slide-up-in');
                this.$task.val('');
                this.showOutputFolder();
                return this;
            },			
            showSettingsView: function() {
                this.$el.hide();
            },					
            showOutputFolder: function() {
					 
                this.$el.show();
                var outFolder = this.model.getOutputFolder();
                var that = this;
                if (outFolder === '' || outFolder === null || outFolder === 'undefined') {
                    $("input[name=storage][value=pictures]").attr('checked', 'checked');							
                }
                else {
                    $("input[name=storage][value=" + outFolder + "]").attr('checked', 'checked');
                }
                $('input').iCheck({
                    radioClass: 'iradio_square-blue  right'
                });
							
                $('input').on('ifChecked', function(event){
                    outputFolder = $('input[name="storage"]:checked').val();
                    if (window.localStorage) {
                        that.model.setOutputFolder(outputFolder);
                        that.$el.hide();
                    }
														   
                });
		
            },
            cancel: function() {
                this.$el.removeClass('slide-up-in').addClass('slide-down-out');
            },
            hideView: function(e) {
                var $target = $(e.target);

                if (e.animationName === 'slide-down-out') {
                    $target.attr('aria-hidden', 'true');
                }
            }
        });

        return ViewOutputFolder;
    });