define(['backbone','views/ViewToolOrder','views/ViewFileFormat','views/ViewOutputFolder','collections/list', 'models/Setting'],
    function(Backbone,ViewToolOrder, ViewFileFormat, ViewOutputFolder, List, Setting) {
        var ViewSetting = Backbone.View.extend({
            el: '#view-setting',
            events: {
                'click #btn-add-done': 'saveSetting',
                'click .btn.del': 'cancel',
                'click #settingsBack': 'showHomeView',
                'keyup #task': 'setAddBtnDisabled',
                'click #divToolOrder': 'showToolOrder',
                'click #divOutputFolder': 'showOutputFolder',
                'click #fclose': 'saveFileFormat',
                'click #divFileName': 'showFileFormat',
                'touchstart #divToolOrder , #divOutputFolder, #divFileName, #divVibration,#divReview, #divHelp, #divDeveloper': 'changeBgColor',
                'touchend #divToolOrder , #divOutputFolder, #divFileName, #divVibration,#divReview, #divHelp, #divDeveloper': 'removeBgColor'
            },
            initialize: function() {
                this.$task = this.$('#task');
                this.$btnAdd = this.$('#btn-add-done');
                this.$btnDelete = this.$('#btn-delete');
                this.$el.on('animationend', this.hideView);
                var outputFolder = this.model.getOutputFolder();
                changeOutFolder(outputFolder);
                function changeOutFolder(outputFolder)
                {
                    if(outputFolder === "pictures"){
                        $('#folderDescPic').css("display","block");
                        $('#folderDescSD').css("display","none");
                    }
                    else{
                        $('#folderDescSD').css("display","block");
                        $('#folderDescPic').css("display","none");
                    }
                }
                this.model.on('change:outputFolder', function(model, outputFolder) {
                    changeOutFolder(outputFolder);
                });
				
                var fileFormat = this.model.getFileFormat();
                $('#fileFormatDesc').html(fileFormat);
                this.model.on('change:fnameFormat', function(model, fnameFormat) {
                    $('#fileFormatDesc').html(fnameFormat);
                });
				
                $('#chkVibration').iCheck({
                    checkboxClass: 'icheckbox_square-blue right',
                });
               

                if (localStorage.getItem("vibration") != null){
                  
                    if(localStorage.getItem("vibration") == "true"){
                        $('#chkVibration').iCheck('check');
                    }
                    else{
                        $('#chkVibration').iCheck('uncheck');
                    }


                }
                else{
                    localStorage.setItem("vibration", true)
                    $('#chkVibration').iCheck('check');
                }


                $('#chkVibration').on('ifChanged', function(event){
                    
                    if(localStorage.getItem("vibration") == "true"){
                        localStorage.setItem("vibration", false);
                    }
                    else{
                        localStorage.setItem("vibration", true);
                    }
                    var curTarget = $("#divVibration");
                    curTarget.css("background","none");
                    curTarget.find('a').css("color","#fff");
                    curTarget.find('span.desc').css("color","#706E6E");
                });

            },
            render: function() {
                this.$el.removeAttr('aria-hidden').removeClass('slide-down-out').addClass('slide-up-in');
                this.$task.val('');
                this.$btnAdd.attr('disabled', 'disabled');
                this.$btnDelete.removeAttr('disabled')
                return this;
            },
            changeBgColor: function(event){
                var curTarget = $(event.currentTarget);
                curTarget.css("background","#006699");
                curTarget.find('a').css("color","#000");
                curTarget.find('span.desc').css("color","#000");
            },
            removeBgColor: function(event){
                var curTarget = $(event.currentTarget);
                curTarget.css("background","none");
                curTarget.find('a').css("color","#fff");
                curTarget.find('span.desc').css("color","#706E6E");
            },
            showHomeView: function(){		
                this.$el.hide();
            },
            showToolOrder: function() {
                localyticsSession.tagEvent("Show Tool Order.");
                localyticsSession.upload();
                this.viewToolOrder = this.viewToolOrder || new ViewToolOrder({
                    model : this.model
                });
                this.viewToolOrder.render();

                //Remove existing events and reattach then
                //using this.events hash
                this.delegateEvents();
                    
            },
            showFileFormat: function() {
                this.viewFileFormat = this.viewFileFormat || new ViewFileFormat({
                    model : this.model
                });
                this.viewFileFormat.render();

                //Remove existing events and reattach then
                //using this.events hash
                this.delegateEvents();
                    

            },
            showOutputFolder: function() {
                this.viewOutputFolder = this.viewOutputFolder || new ViewOutputFolder({
                    model : this.model
                });
                this.viewOutputFolder.render();
                this.delegateEvents();

            },
           
            saveOutputFolder: function() {
                outFolder = $('input[name="storage"]:checked').val();
                if (window.localStorage) {
                    localStorage.setItem("outputFolder", outFolder);
                }

            },
            saveFileFormat: function() {
                outFolder = $('input[name="fnameFormat"]:checked').val();
                if (window.localStorage) {
                    localStorage.setItem("fnameFormat", outFolder);
                }

            },
            
            setAddBtnDisabled: function() {
                var taskLen = this.$task.val().length;

                taskLen ? this.$btnAdd.removeAttr('disabled')
                : this.$btnAdd.attr('disabled', 'disabled');
            },
            saveSetting: function(e) {
                var task = this.$task.val();
            },
			
            cancel: function() {
                this.$el.removeClass('slide-up-in').addClass('slide-down-out');
            },
            hideView: function(e) {
                var $target = $(e.target);

                if (e.animationName === 'slide-down-out') {
                    $target.attr('aria-hidden', 'true');
                }
            }
        });

        return ViewSetting;
    });
 