define(['underscore', 'backbone','views/ViewHome','views/ViewImageDetails', 'models/Home','models/Setting', 'collections/list'],
    function(_, Backbone ,ViewHome, ViewImageDetails,Home,Setting, List) {
        var ViewSplash = Backbone.View.extend({
            el: '#view-splash',
            gallery : null,
            initialize: function() {			
                _.bindAll(this, 'render', 'applyGallery', 'imageLongPress','addSlide');
                this.collection.on("onImageLoad", this.applyGallery, this);
            },
            render: function() {
                // to render view home after an interval of time.
                setTimeout(function() {
                    this.$el.hide();
                    var settingObject = settingObject || new Setting();
                    this.viewHomes = this.viewHomes || new ViewHome({
                            model: settingObject
                        });
                    //this.viewHomes.render();
                    if(!APP.viewHome){
                        APP.viewHome = this.viewHomes;
                    }
                    this.collection.addImages();
                }.bind(this), 1500); 
                return this;
            },           
            applyGallery: function(){
                var galleryLength = 0;
                var arrayImages =  this.collection.models.map(function(elm, idx){
                    return elm.attributes;
                });

                /*for (var i = 0; i < arrayImages.length; i++){
                    for (var j = 0; j < arrayImages.length; j++){
                        if (i != j){
                            if (arrayImages[i].name == arrayImages[j].name){
                                 var removeIndex =  arrayImages[i].size >=  arrayImages[j].size ?  j :  i;
                                 arrayImages.splice(removeIndex, 1);
                             }
                        }
                    }
                }*/

                galleryLength =  arrayImages.length;
                console.log("gallery Length", galleryLength);

                if(galleryLength === 0){
                    $('#divNoPics').removeClass('hidden');
                    $('#blueimp-image-carousel').css('display','none');
					$('#homeArrow').css('display','none');
                    $('.slides').html('');
					$('#editBtn').prop('disabled', true);
					$('#editBtn span').css('color','#7e7e7e');
					$('#editBtn img').attr('src','img/icon_editor_disable.png');
                }
                else{
                    $('#blueimp-image-carousel').css('display','block');
					$('#homeArrow').css('display','block');
                    $('#divNoPics').addClass('hidden');
					$("#editBtn").prop('disabled', false);
					$('#editBtn span').css('color','#fff');
					$('#editBtn img').attr('src','img/icon_editor.png');
						
                    this.gallery = blueimp.Gallery(arrayImages, {
                        container: '#blueimp-image-carousel',
                        carousel: true,
                        continuous: false,
                        preloadRange: 2,
                        startSlideshow: false
                    });
                    this.imageLongPress();
                }
						
                       
            },	
            imageLongPress: function(image){
                var that = this;
                if(!image){
                    image = $("#blueimp-image-carousel");
                }
                image.longpress(function(){
                    $('#view-imageDetails').show();
                    // var list = new List();
                    that.viewImageDetails =  that.ViewImageDetails || new ViewImageDetails({
                        collection:that.collection
                        });
                    that.viewImageDetails.render(); 			
                //that.gallery.prev();
                },function(){},1000);
            },
            addSlide: function(name,outputFolder){
                $('#blueimp-image-carousel').css('display','block');
				$('#homeArrow').css('display','block');
                $('#divNoPics').addClass('hidden');   
                this.collection.addSlide(name,outputFolder);
				$("#editBtn").prop('disabled', false);
				$('#editBtn span').css('color','#fff');
				$('#editBtn img').attr('src','img/icon_editor.png');
            }
        });

        return ViewSplash;
    });
        
        