define(['underscore', 'backbone','views/ViewSetting'],
    function(_, Backbone ,ViewSetting) {
        var ViewToolOrder = Backbone.View.extend({
            el: '#view-toolOrder',
            events: {
                'click #toolBack': 'showSettingsView',
                'click #divToolOrder': 'showToolOrder'
            },
            initialize: function() {
                this.$task = this.$('#task');
                this.$el.on('animationend', this.hideView);                
            },
            render: function() {
                this.$el.removeAttr('aria-hidden').removeClass('slide-down-out').addClass('slide-up-in');
                this.$task.val('');
                this.showToolOrder();
                return this;
            },
            showSettingsView: function() {
                var data = $("#toolList li").map(function() {
                    return $(this).find('input[type="checkbox"]').val();
                                    
                }).get();
                var order = data.join(",") 
                //localStorage.setItem("toolOrder", data.join(","));
                this.model.setToolOrder(order);
                localStorage.setItem("toolOrderIcon", data.join(","));
                var values = $('input:checkbox:checked').map(function () {
                    return this.value;
                }).get();
                var selectValues = values.join(",");
                this.model.setSelectedTools(selectValues);
                //localStorage.setItem("selectedTools", values.join(","));

                this.$el.hide();
            },
				
            showToolOrder: function() {
                //localStorage.clear();
                this.$el.show();
                var that = this;
                var toolsList = this.model.getToolOrder();
                var selectedTools = this.model.getSelectedTools();
              
                toolsArr = toolsList.split(',');
                var diff = [];
                if(selectedTools != null){
                       
                    seltoolsArr = selectedTools.split(',');
                    diff = $(toolsArr).not(seltoolsArr).get();
                }
               
                
                $.each(toolsArr, function(key, value) {
                    checked = "checked='checked'"
                    var index = $.inArray( value, diff);
                    if( index != -1 ) {
                        checked = "";
                    }
                    var labelVal = $('#lang_'+value).html();
                    var optionsElem = "<li><div class='dragArea left'><span class='bgDrag'></span></div><span class='itemIcon left' id="+ value +"></span><label class='listItem left' data-l10n-id='lang_"+value+"'>" + labelVal + "</label><input class='toolCheck right' type='checkbox' name='toolOrder' " + checked + " value='" + value + "'><div class='clr'></div></li>";
                    if (key == 0) {
                        $('#toolList').html(optionsElem);
                    } else {
                        $('#toolList').append(optionsElem);
                            
                            
                    }
                    if(key == toolsArr.length-1){
                        $('#toolList').sortable({
                            handle: '.dragArea',
                            axis: 'y',
                            zIndex: 999,
                            containment: '#toolList' ,
                            tolerance: 'pointer' ,
                            start: function( event, ui ) {
                                ui.item.css("background","#006699");
                            },
                            stop: function( event, ui ) {
                                ui.item.css("background","#141619");
                            }
                        }).bind('sortupdate', function() {
                            saveOrder();
                        });
                        $('input').iCheck({
                            checkboxClass: 'icheckbox_square-blue right',
                        });
                    }
                })
                $('type="checkbox"').on('ifChanged', function(event){
                    saveOrder();
					
                });
                $('input').on('ifUnchecked', function(event){
                    if($("input[name='toolOrder']:checked").length == 0){
						var noToolSelected = that.$el.children('p#noToolSelected').html();
                        alert(noToolSelected);
                        if($(this).is($("input[name='toolOrder']:first"))){
							$("input[name='toolOrder']").eq(1).iCheck('check');
						}
						else{
							$("input[name='toolOrder']:first").iCheck('check');
						}
                    }
					
                }); 
				
                function saveOrder(){
                    var data = $("#toolList li").map(function() {
                        return $(this).find('input[type="checkbox"]').val();
                                    
                    }).get();
                    var order = data.join(",")
                    that.model.setToolOrder(order);
                    var values = $('input:checkbox:checked').map(function () {
                        return this.value;
                    }).get();
                    var selectValues = values.join(",");
                    that.model.setSelectedTools(selectValues);
                //localStorage.setItem("selectedTools", values.join(","));
						
                }
                  

            },
            cancel: function() {
                this.$el.removeClass('slide-up-in').addClass('slide-down-out');
            },
            hideView: function(e) {
                var $target = $(e.target);

                if (e.animationName === 'slide-down-out') {
                    $target.attr('aria-hidden', 'true');
                }
            }
        });

        return ViewToolOrder;
    });
 