// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
angular.module('starter', ['ionic', 'ngCordova', 'starter.controllers', 'starter.factories'])

.run(function($ionicPlatform) {
  $ionicPlatform.ready(function($rootScope) {
    // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
    // for form inputs)
    if(window.cordova && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
    }
    if(window.StatusBar) {
      StatusBar.styleDefault();
    }
  });
})
.config(function($stateProvider, $urlRouterProvider) {

  // Ionic uses AngularUI Router which uses the concept of states
  // Learn more here: https://github.com/angular-ui/ui-router
  // Set up the various states which the app can be in.
  // Each state's controller can be found in controllers.js
  $stateProvider

  // setup an abstract state for the tabs directive
    .state('checklogin', {
    url: "/checklogin",
    templateUrl: "templates/checklogin.html",
    controller: 'checkloginctrl'
  })
  .state('home', {
    url: "/home",
    templateUrl: "templates/home.html",
    controller: 'homeCtrl'
  })
   .state('awordedLogin', {
    url: "/aw_login",
    templateUrl: "templates/signin_aworded.html",
    controller: 'awordedLoginCtrl'
  })
  .state('menu', {
    url: "/menu",
    abstract: true,
    templateUrl: "templates/menu.html",
    controller: 'menuCtrl'
  })
  .state('menu.dashboard', {
      url: "/dashboard",
      views: {
        'menuContent': {
          templateUrl: "templates/dashboard.html",
	  controller: 'dashboardCtrl'
        }
      }
    })
	.state('menu.chat', {
    url: "/chat/:param1/:param2",
	views: {
        'menuContent': {
          templateUrl: "templates/chat.html",
		  controller: 'gamechatCtrl'
        }
      }	
  })
  .state('menu.profile', {
      url: "/profile",
      views: {
        'menuContent': {
          templateUrl: "templates/profile.html",
		  controller: 'userProfileCtrl'
        }
      }
    })
    .state('menu.shop', {
      url: "/shop",
      views: {
        'menuContent': {
          templateUrl: "templates/shop.html"
        }
      }
    })
    .state('menu.settings', {
      url: "/settings",
      views: {
        'menuContent': {
          templateUrl: "templates/settings.html",
	  controller: 'settingsCtrl'
        }
      }
    })
   .state('menu.help', {
      url: "/help",
      views: {
        'menuContent': {
          templateUrl: "templates/help.html",
		  controller: 'helpCtrl'  //$
        }
      }
    })
   .state('menu.newgame', {
    url: "/newgame",
	views: {
        'menuContent': {
		  templateUrl: "templates/newgame.html",
		  controller: 'newGameCtrl'
        }
      }
  })
   .state('menu.board', {
    url: "/board",
	views: {
        'menuContent': {
          templateUrl: "templates/board.html",
		  controller: 'gameBoardCtrl'
        }
      }
  })
  
  .state('draggable', {
    url: "/draggable",
    templateUrl: "templates/draggable.html",
    controller: 'MainCtrl'
  })
  .state('test', {
    url: "/test",
    templateUrl: "templates/test.html",
    controller: 'testCtrl'
  })
  .state('menu.account', { //$
    url: "/account",
	views: {
        'menuContent': {
          templateUrl: "templates/account.html"		 
        }
      }
  })
  .state('menu.shopandextras', { //$
    url: "/Shop&Extras",
	views: {
        'menuContent': {
          templateUrl: "templates/shop&extras.html"		 
        }
      }
  })
  ;

  // if none of the above states are matched, use this as the fallback
  $urlRouterProvider.otherwise('/checklogin');

});
