/**
 * Notification
 */
define(['offline', 'helpers/events'], function(Offline, Events){
	'use strict';
	
	var NotificationManagerSingleton = (function(){
		var _instance = false;
		
		var LISTENER_STATUS_ENABLE = 'enable';
		var LISTENER_STATUS_DISABLE = 'disable';
		
		function NotificationManager(){
			var _booted = false;
			
			var _listeners = {
				connectivityStatus: {
					status: LISTENER_STATUS_DISABLE,
					
					enable: function(){
						Offline.on('up', function(){
							if ('Notification' in window) {
								// Firefox OS 1.1 and higher
								if (Notification.permission !== 'denied') {
									Notification.requestPermission(function(permission){
										if(!('permission' in Notification)) {
											Notification.permission = permission;
										}
									});
								}
								
								if (Notification.permission === 'granted') {
									var notify = new Notification(NOTIFICATION_TITLE, {
										icon: NOTIFICATION_ICON,
										body: NOTIFICATION_BODY
									});
									
									notify.onclick = function(e){
										var activity = new MozActivity({
											name: 'com.aynid.home'
										});
										
										activity.onsuccess = function(){
											if (this.result) {
												console.log('Aynid activity started!');
											}
										};
										
										activity.onerror = function(){
											var requete = window.navigator.mozApps.getSelf();
											requete.onsuccess = function(){
												this.result.launch();
												console.log(this.result.manifest.name + ' activity started!');
											};
											requete.onerror = function(){
												console.log('Erreur : ' + this.error.name);
											};
										};
										// Close Notification
										setTimeout(this.close.bind(this), 3000);
									};
								}
							} else {
								// Firefox OS 1.0
								var notify = navigator.mozNotification.createNotification(
									NOTIFICATION_TITLE,
									NOTIFICATION_BODY
								);
								notify.show();
							}
							
							window.navigator.vibrate(1000);
						}, window);
						console.log('Network status notification enabled.');
					},
					
					disable: function(){
						console.log('Network status notification disabled.');
						Offline.off('up');
					}
				}
			};
						
			this.isBooted = function(){
				return _booted;
			};
			
			this.boot = function(){
				if (!this.isBooted()) {
					_booted = true;
					console.log('Notification manager booted.');
					for (var i in _listeners) {
						this.enalbeListener(i);
					}
				} else {
					console.log('Notification manager is already booted.');
				}
			};
			
			this.addListener = function(listenerName, enableCallback, disableCallback){
				if (_listeners[listenerName] == undefined) {
					_listeners[listenerName] = {
						enable: enableCallback,
						disable: disableCallback,
						status: LISTENER_STATUS_DISABLE
					};
				}
			};
			
			this.removeListener = function(listenerName){
				if (_listeners[listenerName] !== undefined) {
					delete _listeners[listenerName];
				}
			};
			
			this.enalbeListener = function(listenerName){
				if (_listeners[listenerName] !== undefined && _listeners[listenerName].status == LISTENER_STATUS_DISABLE) {
					_listeners[listenerName].enable();
					_listeners[listenerName].status = LISTENER_STATUS_ENABLE;
				}
			};
			
			this.disableListener = function(listenerName){
				if (_listeners[listenerName] !== undefined && _listeners[listenerName].status == LISTENER_STATUS_ENABLE) {
					_listeners[listenerName].disable();
					_listeners[listenerName].status = LISTENER_STATUS_DISABLE;
				}
			};
			
			this.boot();
		};
		
		return {
			getInstance: function(){
				if (!_instance) {
					_instance = new NotificationManager();
					console.log('Notification manager Singleton instance create!');
				}
				
				return _instance;
			}
		};
	})();
	
	return NotificationManagerSingleton.getInstance();
});