$(window).resize(function(){
	$('th.col1').width($('td.repere1').width());
	$('th.col2').width($('td.repere2').width());
});

/*VARIABLES STATIQUES*/
var now=new Date();
var month=['Jan', 'Fev', 'Mar', 'Avr', 'Mai', 'Juin', 'Jul', 'Août', 'Sept', 'Oct', 'Nov', 'Dec'];

/*==============================*/
$(document).ready(function(){
	fill_temp();
	sel_data();
	$('select').material_select();
	refresh();
	$('th.col1').width($('td.repere1').width());
	$('th.col2').width($('td.repere2').width());
	/*Bouton de collapse*/
	$(".button-collapse").sideNav();
	$('.collapsible').collapsible();

	//Call the modal

	$('.modal-trigger').leanModal();
	$('#mois').val(now.getMonth());
	if (localStorage.getItem('cycle_actif')==null)
	{
		$('#nom_cycle').text("");
	}

	else
	{
		$('#nom_cycle').text(localStorage.getItem('cycle_actif'));
	}
});

$('#save').click(function(){
	if ($('#daty').val()==="" || $('#temp').val()==="")
	{
		alert("Vous devez spécifier une date et une température");
	}

	else if (localStorage.getItem('cycle_actif')===null)
	{
		alert("Vous devez créer un cycle");
	}

	else
	{
		Materialize.toast('Température enregistré', 2000);
		if (localStorage.getItem('last_cycle_date')===null)
		{
			localStorage.setItem('last_cycle_date', 0);
		}

		else
		{
			var next=parseInt(localStorage.getItem('last_cycle_date'))+1;
			localStorage.setItem('last_cycle_date', next);
		}	 

		var id=localStorage.getItem('cycle_actif')+'*'+localStorage.getItem('last_cycle_date');
		var valeur=$('#daty').val()+'/'+$('#mois').val()+'/'+$('#annee').val()+'*'+$('#temp').val();
		localStorage.setItem(id, valeur);
		localStorage.setItem(localStorage.getItem('cycle_actif')+'*length', localStorage.getItem('last_cycle_date'));
		refresh();
		set_start();
	}
});

function fill_temp()
{
	for (var i=36.0; i<=38.1; i+=0.1)
	{
		$('#temp').append('<option value='+i.toFixed(1)+'>'+i.toFixed(1)+'</option>');
	}
}

function set_start()
{
	var d=localStorage.getItem(localStorage.getItem('cycle_actif')+'*0');
	var g=d.split('*');
	localStorage.setItem('mens_debut_cycle', g[0]);
}

$('#new_cycle').click(function(e){
	e.preventDefault();
	$('#new_modal').trigger('click');
});

$('.modal-close').click(function(){
	if (localStorage.getItem('last_cycle')===null)
	{
		localStorage.setItem('last_cycle', 0);
	}

	else
	{
		var next=parseInt(localStorage.getItem('last_cycle'))+1;
		localStorage.setItem('last_cycle', next);
	}	 

	localStorage.setItem('cycle'+localStorage.getItem('last_cycle'), $('#cycle_id').val());
 //Enregistrement d'un nouveau cycle
//Efface le nom du dernier cycle à afficher
localStorage.setItem('cycle_actif',  $('#cycle_id').val());

if (localStorage.getItem('last_cycle_date')!=null)
{
	localStorage.removeItem('last_cycle_date');
}
Materialize.toast('Nouveau cycle crée', 2000);
if (localStorage.getItem('cycle_actif')==null)
{
	$('#nom_cycle').text("");
}

else
{
	$('#nom_cycle').text(localStorage.getItem('cycle_actif'));
}
});

function load_cycle()
{
	entete();
	for (var i=0; i<last_cycle+1; i++)
	{
		$('#recap').append('');
	}
}

function entete()
{
	$('#recap').append('<table class="centered"><tr class="fixed red lighten-3 white-text"><th class="center col1">Date</th><th class="center col2">Température</th></tr><tr><td></td></tr></table>');
}

function fill_table()

{
	var splitter; 
	for (var i=0; i<=localStorage.getItem('last_cycle_date'); i++)
	{
		var tosplit=localStorage.getItem(localStorage.getItem('cycle_actif')+'*'+i);
		if (tosplit===null)
		{
			break;	
		}

		else
		{
			splitter=tosplit.split('*');
			var d=splitter[0].split('/');
			var jour=d[0];
			var mois=d[1];
			var annee=d[2];
			$('table').append('<tr><td class="repere1">'+jour+' '+month[mois]+' '+annee+'</td><td class="repere2">'+splitter[1]+'</td></tr>');
		}
	}	
}

function refresh()
{
	$('select').material_select();
	$('table').remove();
	entete();
	fill_table();
	$('th.col1').width($('td.repere1').width());
	$('th.col2').width($('td.repere2').width());
	$(".button-collapse").sideNav();
	$('#mois').val(now.getMonth());
	if (localStorage.getItem('cycle_actif')==null)
	{
		$('#nom_cycle').text("");
	}

	else
	{
		$('#nom_cycle').text(localStorage.getItem('cycle_actif'));
	}
}

function removeAllDataCycle()
{
	localStorage.removeItem();
}

function sel_data()
{
	for (var i=1; i<=check_last($('#mois').val(), $('#annee').val()); i++)
	{
		$('#daty').append('<option value='+i+' class="jour">'+i+'</option>');
	}	
}

function check_last(mois, annee)
{
	var ch=0;
	var fin=new Date(annee, mois, 28+ch);
	var jour=fin.getDate();
	var fin_mois=fin.getMonth();

	for (var i=0; i<5;i++)
	{
		var fin=new Date(annee, mois, 28+i);
		var fin_mois=fin.getMonth();
		if (fin_mois==mois)
		{
			//Nothing-rien-nada
		}

		else
		{
			var plus=i;
			break;
		}
	}

	var fin_du_mois=plus+27;
	return fin_du_mois;
}

$('#mois').change(function(){
sel_data();
});