﻿	$('.disabled').click(function(event){
		event.preventDefault();
	});

	var ind=0;

	var state={
		desc:'Etat comparatif',

		datasets:[{
			label:"ovulation",
			data:[36.3, 36.2, 36.3, 36.3, 36.4, 36.3, 36.4, 36.4, 36.3, 36.3, 36.4, 36.3, 36.2, 36.2, 36.4, 36.5, 36.6, 36.6, 36.7, 36.6, 36.7, 36.7, 36.6, 36.7, 36.8, 36.7, 36.7, 36.6, 36.7, 36.5, 36.3],
			description:""
		}, 

		{
			label:"dysovulation",
			data:[36.3, 36.5, 36.3, 36.4, 36.6, 36.2, 36.6, 36.3, 36.2, 36.5, 36.6, 36.6, 36.4, 36.4, 36.6, 36.8, 36.7, 36.7, 36.6, 36.7, 36.7, 36.6, 36.5, 36.4, 36.3, 36.3, 36.4, 36.3, 36.3, 36.2]
		},

		{
			label:"anovulation",
			data:[36.3, 36.5, 36.3, 36.4, 36.6, 36.2, 36.6, 36.3, 36.2, 36.5, 36.6, 36.6, 36.4, 36.4, 36.4, 36.5, 36.4, 36.6, 36.4, 36.5, 36.4, 36.6, 36.4, 36.6, 36.6, 36.4, 36.3, 36.5, 36.2]
		},

		{
			label:"Grossesse débutante",
			data:[36.5, 36.6, 36.6, 36.7, 36.4, 36.5, 36.4, 36.4, 36.6, 36.5, 36.3, 36.3, 36.4, 36.4, 36.1, 36.3, 36.4, 36.4, 36.5, 36.6, 36.7, 36.7, 36.7, 36.9, 37, 36.9, 36.9, 37, 36.9, 37.1, 37.1]
		},
	]
};
	var labels=["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31" ];

var data = {
	labels:labels,
	datasets: [
		{
			label: "Ma courbe ménothermique",
			fillColor: "rgba(220,220,220,0.2)",
			strokeColor: "rgba(220,220,220,1)",
			pointColor: "rgba(220,220,220,1)",
			pointStrokeColor: "fff",
			pointHighlightFill: "#fff",
			pointHighlightStroke: "rgba(220,220,220,1)",
			data: null
		},

		 {
            label: null,
            fillColor: "rgba(151,187,205,0.2)",
            strokeColor: "rgba(151,187,205,1)",
            pointColor: "rgba(151,187,205,1)",
            pointStrokeColor: "#fff",
            pointHighlightFill: "#fff",
            pointHighlightStroke: "rgba(151,187,205,1)",
            data:null
        },
	]
};

function create_array(cycle)
{
	var cycle_array=[];
	var cycle_temp=[];
	var f=cycle.split('*');
	var debut=localStorage.getItem(f[0]+'*'+'0');
	var splitter=debut.split('*');
	var daty=splitter[0];
	var daty2=daty.split('/');
	var jour_debut=daty2[0];
	var mois_debut=daty2[1];
	var annee_debut=daty2[2];

	//Fin
	var fin=localStorage.getItem(cycle+'*'+localStorage.getItem(f[0]+'*length'));
	var splitter=fin.split('*');
	var daty=splitter[0];
	var daty2=daty.split('/');
	var jour_fin=daty2[0];
	var mois_fin=daty2[1];
	var annee_fin=daty2[1];

	for (var i=0; i<=localStorage.getItem(cycle+'*length'); i++)
	{
		var debut=localStorage.getItem(f[0]+'*'+i);
		var splitter=debut.split('*');
		var daty=splitter[0];
		var temp=splitter[1];
		var daty2=daty.split('/');
		var jour=daty2[0];
		cycle_array.push(jour);
		cycle_temp.push(temp);
	}

	data.labels=cycle_array;
	data.datasets[0].data=cycle_temp;
}

function get_fin(mois, annee)
{
	var ch=0;
	var fin=new Date(annee, mois, 28+ch);
	var jour=fin.getDate();
	var fin_mois=fin.getMonth();

	for (var i=0; i<5;i++)
	{
		var fin=new Date(annee, mois, 28+i);
		var fin_mois=fin.getMonth();

		if (fin_mois==mois)
		{
			
		}

		else
		{
			var plus=i;
			break;
		}
	}

	var fin_du_mois=plus+27;
	return fin_du_mois;
}

function next()
{
	if (ind>2)
	{
		ind=0;
	}

	else
	{
		ind=ind+1;
	}

	data.datasets[1].label=state.datasets[ind].label;
	data.datasets[1].data=state.datasets[ind].data;
	var titre='Comparé à une '+data.datasets[1].label;
	$('.titre').text(titre);
}

function prev()
{
	if (ind<1)
	{
		ind=2;
	}

	else
	{
		ind=ind-1;
	}

	data.datasets[1].label=state.datasets[ind].label;
	data.datasets[1].data=state.datasets[ind].data;
	var titre='Comparé à une '+data.datasets[1].label;
	$('.titre').text(titre);
}

var title={
	titre:["Ovulation", "Dysovulation", "Anovulation", "Grossesse débutante"],
	definition:["", "Une courbe dont l’ascension thermique est tardive, associée à un plateau thermique court, évoque une dysovulation (ovulation de mauvaise qualité).", "Une courbe plate, sans ascension thermique, évoque une anovulation (absence d’ovulation).", "On constate un retard de règles associé à un plateau thermique qui se prolonge au delà de 16 jours parallèlement au retard des règles. Un plateau thermique de 21 jours permet d’affirmer avec certitude une grossesse débutante. A l’inverse, malgré un retard de règles, on peut affirmer l’absence de grossesse s’il n’y a pas de plateau thermique. De même, au cours des premières semaines de grossesse, une chute de la température en dessous de 37°C, témoigne l’arrêt de la gestation."]
};

$(document).ready(function(){
create_array(localStorage.getItem('courbe'));
});

$('#compare').click(function(){
		data.datasets[1].label=state.datasets[ind].label;
		data.datasets[1].data=state.datasets[ind].data;
		var titre='Comparé à une '+data.datasets[1].label;
		$('.titre').text(titre);
		draw();
});

$('#next').click(function(e){
e.preventDefault();
next();
draw();
});

$('#prev').click(function(e){
e.preventDefault();
prev();
draw();
});

window.onload = function(){
	draw();
}

function draw()
{
	var ctx = document.getElementById("canvas").getContext("2d");
		window.myLine = new Chart(ctx).Line(data, {
			responsive: true
		});
}