/*MES FONCTIONS*/
function fill_hour()
{
	for (var i=0; i<24; i++)
	{
		if (i<10)
		{
			i='0'+i;
		}
		$('#hour').append('<option value='+i+'>'+i+'</option>');
	}
}

function fill_minute()
{
	for (var i=0; i<60; i++)
	{
		if (i<10)
		{
			i='0'+i;
		}

		$('#minute').append('<option value='+i+'>'+i+'</option>');
	}
}

function change_mdp(ancien, nouveau, confirm)
{
	if (ancien==localStorage.getItem('mdp'))
	{
		if (nouveau==confirm)
		{
			Materialize.toast('Mot de passe mis à jour', 3000);
			localStorage.setItem('mdp', nouveau);
		}

		else
		{
			alert("Veuillez verifier les caractères que vous avez entrés.");
		}
	}

	else
	{
		alert("Mot de passe incorrect.");
	}
}


function loading_settings()
{
	if (localStorage.getItem('settingLength')==null)
	{
		localStorage.setItem('settingLength', 0);
	}

	for (var i=0; i<localStorage.getItem('settingLength'); i++)
	{
		for (var j=0; j<$(':checkbox').length; j++)
		{
			if (localStorage.getItem('setting'+i)==$(':checkbox:nth('+j+')').data('attr'))
			{
				$(':checkbox:nth('+j+')').attr('checked', 'checked');
			}
		}
	}
}

function save()
{
	for (var i=0; i<$(':checkbox:checked').length; i++)
	{
		localStorage.setItem('setting'+i, $(':checkbox:checked:nth('+i+')').data('attr'))
		action(localStorage.getItem('setting'+i));
	}

	localStorage.setItem('settingLength', $(':checkbox:checked').length);
}

function action(setting)
{
	if (setting=='ovulation')
	{
		setAlarm(date_to_alarm(localStorage.getItem('mens_periode_ovulation'), $('#hour').val()+':'+$('#minute').val()), "Aujourd'hui est la date présumée de votre ovulation.");
		notify_save(localStorage.getItem('mens_periode_ovulation'), $('#hour').val()+':'+$('#minute').val(), "Aujourd'hui est la date présumée de votre ovulation.");
	}

	else if (setting=='fertilite')
	{
		setAlarm(date_to_alarm(localStorage.getItem('mens_periode_ovulation1'), $('#hour').val()+':'+$('#minute').val()), "Votre taux de fertilité est très forte à partir d'aujourd'hui.");
		notify_save(localStorage.getItem('mens_periode_ovulation1'), $('#hour').val()+':'+$('#minute').val(), "Votre taux de fertilité est très forte à partir d'aujourd'hui.");
	}

	else if (setting=='debut_cycle')
	{
		setAlarm(date_to_alarm(localStorage.getItem('mens_debut_cycle')), "Aujourd'hui est la date du premier jour de votre cycle.");
		notify_save(localStorage.getItem('mens_debut_cycle'), $('#hour').val()+':'+$('#minute').val(), "Aujourd'hui est la date du premier jour de votre cycle.");
	}

	else if (setting=='temp')
	{
		setAlarm(date_to_alarm(localStorage.getItem('temp')), "C'est l'heure de prendre votre température.");
		notify_save(localStorage.getItem('temp'), $('#hour').val()+':'+$('#minute').val(), "C'est l'heure de prendre votre température.");
	}
}

function date_to_alarm(daty, heure)
{
	if (daty==null)
	{
		alert("Cette date n'est pas encore paramétré dans le calendrier.");
	}

	else
	{
		var dat=daty;
		var eclate=dat.split('/');
		var jour=eclate[0];
		var mois=eclate[1];
		var annee=eclate[2];
		var month=['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
		var resultat=month[mois]+' '+jour+', '+annee+' '+heure+':00';
		return resultat;
	}
}

function notify_save(daty, heure, texte)
{
	if (localStorage.getItem('notify_length')==null)
	{
		localStorage.setItem('notify_length', 0);
		localStorage.setItem('notify0', daty+'*'+heure+'*'+texte);
	}

	else
	{
		var next=parseInt(localStorage.getItem('notify_length'))+1;
		localStorage.setItem('notify_length', next);
		localStorage.setItem('notify'+localStorage.getItem('notify_length'), daty+'*'+heure+'*'+texte);
	}
}


function setAlarm(daty, data_task)
{
	if (navigator.mozAlarms)
	{
		var alarmdate=new Date(daty);
		var data={
			task:data_task
		}

		var request=navigator.mozAlarms.add(alarmdate, 'ignoreTimezone', data);
		request.onsuccess=function()
		{
			
		}

		request.onerror=function(){
			alert(this.error.name);
		}

		if(navigator.mozSetMessageHandler) {
			navigator.mozSetMessageHandler("alarm", function (alarm) {
      // only launch a notification if the Alarm is of the right type for this app
      if(alarm.data.task) {
        // Create a notification when the alarm is due
        new Notification("B-Voka: " + alarm.data.task);
        updateNotified(alarm.data.task);
    }
});
		}
	}
}
function readAllData()
{
	for (i=0; i<=localStorage.length-1; i++)  
	{  
		key = localStorage.key(i);  
		val = localStorage.getItem(key);
		alert(key+'='+val);
	};
}

function getAllAlarm()
{
	var request = navigator.mozAlarms.getAll();
	request.onsuccess = function () {
		this.result.forEach(function (alarm) {
			alert('date: ' + alarm.date);
			alert('data: ' + JSON.stringify(alarm.data));
		});
	};
}


/*MES ACTIONS*/

$(document).ready(function(){
	$('.collapsible').collapsible({
      accordion : false	
  });
	fill_minute();
	fill_hour();
	$('select').material_select();
	loading_settings();

});

$('#remove').click(function(){
	var request = navigator.mozAlarms.getAll();
	request.onsuccess = function () {
		this.result.forEach(function (alarm) {
			navigator.mozAlarms.remove(alarm.id);
		});
};
	alert("Alarmes effacées");
});

$('#erase_all').click(function(){
	localStorage.clear();
	Materialize.toast('Tous les données ont été effacées', 3000);
});

$('#save').click(function(){
	save();
	Materialize.toast('Paramètres enregistrés', 3000);
});

$('#get').click(function(){
	getAllAlarm();
});

$('#confirm_pass').click(function(){
	var last=$('#last_pass').val();
	var neww=$('#new_pass').val();
	var conf=$('#confirm_pass').val();
	change_mdp(last, neww, conf);
});