﻿var DESIGN_FPS = 60;
var ANIM_SCALE = 1.5 * 59 / 60;

var apiInstance;
var splashScreenData;

var needTutorial = true;
var needScrollMap = true;
var needShowSplash = false;
var needMusic = true;
var needApi = true;

var analytics;

function getInt(n) {
    return Math.floor(Math.random() * 100000) % n;
}

function setReg(s, x, y) {
    s.regX = s.getBounds().width * x;
    s.regY = s.getBounds().height * y;
}

function distanceBetweenPoints(x1, y1, x2, y2) {
    return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
}

function removeClip(s) {
    if (s && s.parent)
        s.parent.removeChild(s);
}

function cjp(x, y) {    return new createjs.Point(x, y);
}

function isMobile() {
    var a = navigator.userAgent || navigator.vendor;
    return /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|android|ipad|playbook|silk|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4));
}

var testPoint = new createjs.Point(0, 0);
function getPoint(x, y) {
    if (typeof x === "undefined") { x = 0; }
    if (typeof y === "undefined") { y = 0; }
    testPoint.x = x;
    testPoint.y = y;
    return testPoint;
}

function createSpriteFromSpritesheet(s, atlas) {
    if (typeof atlas === "undefined") { atlas = 0; }
    if (!App.game.atlases[atlas].getAnimation(s)) {
        if (atlas == 0)
            return createSpriteFromSpritesheet(s, 2);
        else
            return null;
    }

    var sp = new createjs.Sprite(App.game.atlases[atlas], s);
    sp.gotoAndStop(s);
    sp.framerate = 30;
    return sp;
}

function addChild(s, c) {
    c.addChild(s);
    //App.game.stage.addChild(s);
}

function createBitmap(s) {
    var sp = new createjs.Bitmap(App.game.preloader.loader.getResult(s));
    return sp;
}

function limitDt(dt) {
    //dt = fmin(dt, 2.0 / DESIGN_FPS);
    return dt;
}

function limit(value, min, max) {
    if (value < min)
        value = min;
    if (value > max)
        value = max;
    return value;
}

function lerp(min, max, ratio) {
    return min + ratio * (max - min);
}

function lerpAngle(start, end, ratio) {
    var difference = Math.abs(end - start);
    if (difference > 180) {
        if (end > start)
            start += 360;
        else
            end += 360;
    }
    var value = (start + ((end - start) * ratio));
    return normalizeAngle(value);
}

function normalizeAngle(a, min, max) {
    if (typeof min === "undefined") { min = 0; }
    if (typeof max === "undefined") { max = 360; }
    while (a > max)
        a -= 360;
    while (a < min)
        a += 360;
    return a;
}

function sign(n) {
    return n > 0 ? 1 : -1;
}

function rotatePoint(p, a) {
    a *= Math.PI / 180;
    var sinA = Math.sin(a);
    var cosA = Math.cos(a);
    var x = p.x * cosA - p.y * sinA;
    var y = p.x * sinA + p.y * cosA;
    p.x = x;
    p.y = y;
}

function createAnimation(animationName, frameName, startFrame, endFrame, speed, next, addAmount) {
    if (typeof speed === "undefined") { speed = 1; }
    if (typeof next === "undefined") { next = null; }
    if (typeof addAmount === "undefined") { addAmount = 0; }
    var res = [];
    var less = startFrame <= endFrame;
    for (var i = startFrame; (less && i <= endFrame) || (!less && i >= endFrame); less ? ++i : --i) {
        var f = spriteSheetInfo.animations[frameName + (i <= 9 ? "000" : "00") + i][0];
        if (f == undefined || f == null || isNaN(f))
            console.log("ERROR");
        var amount = 1 + (i == endFrame ? addAmount : 0);
        for (var j = 0; j < amount; ++j)
            res.push(f);
    }

    //res.push(name);
    spriteSheetInfo.animations[animationName] = { frames: res, next: next ? next : animationName, speed: speed };
}

function createFontFrames(info) {
    var s = "abcdefghijklmnopqrstuvwxyz1234567890!-./:%";
    for (var i = 0; i < s.length; ++i) {
        var code = s.charCodeAt(i);
        var char = s.charAt(i);
        if (info.animations[code.toString()])
            info.animations[char] = info.animations[char.toUpperCase()] = info.animations[code.toString()];
    }
}

var textSize = new createjs.Point();
function getTextSize(t) {
    var len = t.text.length;
    var ls = t.letterSpacing;
    var w = 0;
    var h = 0;
    for (var i = 0; i < len; ++i) {
        var c = t.text.charAt(i);
        var f = t._getFrame(c, t.spriteSheet);
        if (c == " ")
            w += t.spaceWidth;
        else {
            h = Math.max(h, f.rect.height);
            w += f.rect.width + (i == 0 ? 0 : ls);
        }
    }
    textSize.x = w;
    textSize.y = h;
    return textSize;
}

function traceChildren(c, lvl) {
    if (typeof lvl === "undefined") { lvl = 0; }
    var b = c.getBounds();
    var cont = c instanceof createjs.Container ? c : null;
    console.log(lvl, c.x, c.y, b ? b.width : "null", b ? b.height : "null", cont != null);
    if (Math.abs(c.x) > 2000 || Math.abs(c.y) > 2000)
        console.log("error!");
    if (cont) {
        for (var i = 0; i < cont.getNumChildren(); ++i)
            traceChildren(cont.getChildAt(i), lvl + 1);
    }
}

var spriteSheetInfo;

var jellyAnimation = [
    [0, 0, 1, 1, 0, 0],
    [0, -0.2, 0.990325927734375, 1.0163421630859375, 0, 0],
    [0, -0.85, 0.9597015380859375, 1.0679931640625, 0, 0],
    [0, -2, 0.90777587890625, 1.1556243896484375, 0, 0],
    [0, -3.45, 0.839111328125, 1.271484375, 0, 0],
    [0, -5.05, 0.7647552490234375, 1.3969268798828125, 0, 0],
    [0, -6.5, 0.6983184814453125, 1.5090484619140625, 0, 0],
    [0, -7.55, 0.6492462158203125, 1.591827392578125, 0, 0],
    [0, -8.15, 0.6207122802734375, 1.639984130859375, 0, 0],
    [0, -8.25, 0.611724853515625, 1.6551513671875, 0, 0],
    [],
    [0, 0, 1, 1, 0, 0],
    [4.6, 4.65, 1.26666259765625, 0.8162329058533069, 8.740893609188799, 0],
    [9.2, 9.25, 1.5333251953125, 0.6334487873339344, 13.372745413697926, 0],
    [1.4, 5.8, 1.357635498046875, 0.7792788568603103, 3.1569680758932535, 0],
    [-6.45, 2.35, 1.1819305419921875, 0.925467115184136, -12.10069098267475, 0],
    [-3.2, -0.95, 1.01348876953125, 1.0567754423261255, -6.882207890731568, 0],
    [0, -4.25, 0.8450469970703125, 1.1888885498046875, 0, 0],
    [3.1, -2.7, 0.916717529296875, 1.1285485952784342, 5.112697122078025, 0],
    [6.15, -1.2, 0.9883880615234375, 1.0687622833051502, 9.867820180727541, 0],
    [4.15, 0.75, 1.0811309814453125, 0.9769953841175838, 5.89778638603597, 0],
    [2.05, 2.75, 1.17388916015625, 0.8857241411063542, 2.6769970225381177, 0],
    [0, 4.65, 1.26666259765625, 0.7944488525390625, 0, 0],
    [-1.05, 3.6, 1.2183380126953125, 0.8434575932408014, -1.9242555344893524, 0],
    [-2.1, 2.5, 1.1699981689453125, 0.8924740830067877, -4.237558644102631, 0],
    [-3.15, 1.45, 1.1216888427734375, 0.9418679675355531, -6.704732255337957, 0],
    [-2.15, 0.4, 1.0753631591796875, 0.9839297937141035, -4.672067958342162, 0],
    [-1.05, -0.6, 1.029022216796875, 1.0264039447029814, -2.343028092881174, 0],
    [0, -1.6, 0.982696533203125, 1.0688934326171875, 0, 0],
    [0.35, -1.4, 0.98492431640625, 1.0602445053925167, 0.810442926157033, 0],
    [0.65, -1.15, 0.9871673583984375, 1.0516431573527776, 1.6060233606801182, 0],
    [1, -1, 0.9893951416015625, 1.0431331771009533, 2.519629464061024, 0],
    [0.8, -0.8, 0.99151611328125, 1.0343828507167612, 1.8578114542434683, 0],
    [0.6, -0.6, 0.994110107421875, 1.0238889971616911, 1.304402206932355, 0],
    [0.3, -0.3, 0.996612548828125, 1.013729485673602, 0.7658554512551897, 0],
    [0.15, -0.15, 0.9985198974609375, 1.005977596469548, 0.2745189631211525, 0],
    [0.05, -0.05, 0.9996490478515625, 1.0014191343430145, 0.02098234113027917, 0],
    [0, 0, 1, 1, 0, 0],
    [],
    [0, 0, 1, 1, 0, 0],
    [-3.1, 4.7, 1.2722930908203125, 0.8187573190593543, -9.991091434867933, 0],
    [-6.05, 9.25, 1.5333251953125, 0.6460869700694191, -15.22880833951387, 0],
    [-3.4, 7.5, 1.4423065185546875, 0.7204993841632751, -9.856454745948641, 0],
    [4.45, 2.35, 1.1819305419921875, 0.9355071077774614, 14.413994092288029, 0],
    [1.1, -2.6, 0.9299468994140625, 1.124781958325034, 4.266409363156765, 0],
    [0, -4.25, 0.8450469970703125, 1.1888885498046875, 0, 0],
    [-1.55, -3.5, 0.8802642822265625, 1.1655771151376606, -4.3905548815109166, 0],
    [-6.65, -1.2, 0.9883880615234375, 1.0949985387914987, -16.844448606545367, 0],
    [-3.2, 1.9, 1.131103515625, 0.9404279496175882, -7.057060733483895, 0],
    [-0.8, 4, 1.23388671875, 0.8297270091149772, -1.4696381433333037, 0],
    [0, 4.65, 1.26666259765625, 0.7944488525390625, 0, 0],
    [0.3, 4.3, 1.2503662109375, 0.8108758237352302, 0.608487892778096, 0],
    [1.15, 3.15, 1.1992034912109375, 0.8624714277595207, 2.6105529422922333, 0],
    [2.45, 1.45, 1.1216888427734375, 0.9409700566331797, 6.277217054808519, 0],
    [1.15, -0.2, 1.0460205078125, 1.0104446895887182, 3.0424394638904797, 0],
    [0.25, -1.25, 0.9978179931640625, 1.0549051829487366, 0.5875055516478168, 0],
    [0, -1.6, 0.982696533203125, 1.0688934326171875, 0, 0],
    [-0.1, -1.55, 0.9834136962890625, 1.066086335325182, -0.060324230749552614, 0],
    [-0.4, -1.35, 0.9857177734375, 1.0571861051189553, -0.8454134947074983, 0],
    [-0.85, -1, 0.9893951416015625, 1.0429154773788731, -2.2040200828930745, 0],
    [-0.6, -0.75, 0.9922332763671875, 1.0313194037738669, -1.5596873573507517, 0],
    [-0.45, -0.55, 0.99493408203125, 1.0204045992999402, -1.0228891301011096, 0],
    [-0.25, -0.25, 0.9971923828125, 1.011363047612536, -0.5219357356156944, 0],
    [-0.1, -0.1, 0.9987640380859375, 1.0049139140583043, -0.06207275917707588, 0],
    [0, -0.05, 0.9997100830078125, 1.0011749644321115, -0.01573675584770938, 0],
    [0, 0, 1, 1, 0, 0],
    [],
    [0, 0, 1, 1, 0, 0],
    [0, 2.55, 1.126678466796875, 0.8877716064453125, 0, 0],
    [0, 8.3, 1.4143829345703125, 0.6329193115234375, 0, 0],
    [0, 10.65, 1.5333251953125, 0.527557373046875, 0, 0],
    [0, 9.25, 1.4581298828125, 0.5888671875, 0, 0],
    [0, 4.95, 1.2271728515625, 0.77716064453125, 0, 0],
    [0, -0.65, 0.9223480224609375, 1.0257110595703125, 0, 0],
    [0, -4.7, 0.70281982421875, 1.2047119140625, 0, 0],
    [0, -5.9, 0.632843017578125, 1.2617645263671875, 0, 0],
    [0, -5.55, 0.6529541015625, 1.2469329833984375, 0, 0],
    [0, -4.45, 0.7166595458984375, 1.1999664306640625, 0, 0],
    [0, -2.75, 0.822998046875, 1.1215667724609375, 0, 0],
    [0, -0.55, 0.9564361572265625, 1.0231781005859375, 0, 0],
    [0, 1.65, 1.087371826171875, 0.9266510009765625, 0, 0],
    [0, 3.3, 1.1884765625, 0.8520965576171875, 0, 0],
    [0, 4.3, 1.24798583984375, 0.8082275390625, 0, 0],
    [0, 4.65, 1.26666259765625, 0.7944488525390625, 0, 0],
    [0, 4.45, 1.2573394775390625, 0.803497314453125, 0, 0],
    [0, 3.8, 1.2279052734375, 0.8321685791015625, 0, 0],
    [0, 2.7, 1.177947998046875, 0.88079833984375, 0, 0],
    [0, 1.25, 1.1118927001953125, 0.9450836181640625, 0, 0],
    [0, -0.35, 1.040374755859375, 1.0146942138671875, 0, 0],
    [0, -1.75, 0.9764556884765625, 1.0768890380859375, 0, 0],
    [0, -2.8, 0.92926025390625, 1.122833251953125, 0, 0],
    [0, -3.35, 0.9018096923828125, 1.1495513916015625, 0, 0],
    [0, -3.6, 0.893157958984375, 1.157958984375, 0, 0],
    [0, -3.55, 0.894927978515625, 1.1553497314453125, 0, 0],
    [0, -3.35, 0.9004974365234375, 1.147125244140625, 0, 0],
    [0, -3.05, 0.910064697265625, 1.13299560546875, 0, 0],
    [0, -2.6, 0.9233245849609375, 1.11334228515625, 0, 0],
    [0, -2.05, 0.9392852783203125, 1.089752197265625, 0, 0],
    [0, -1.5, 0.956085205078125, 1.0649566650390625, 0, 0],
    [0, -0.95, 0.971588134765625, 1.0419921875, 0, 0],
    [0, -0.6, 0.984222412109375, 1.0233154296875, 0, 0],
    [0, -0.25, 0.993194580078125, 1.01007080078125, 0, 0],
    [0, -0.05, 0.9983673095703125, 1.002410888671875, 0, 0],
    [0, 0, 1, 1, 0, 0],
    [],
    [0, 0, 1, 1, 0, 0],
    [0, 2.5, 1.0222930908203125, 0.8951416015625, 0, 0],
    [0, 9.6, 1.0860595703125, 0.59515380859375, 0, 0],
    [0, 16.35, 0.95220947265625, 0.3123931884765625, 0, 0],
    [0, 18.6, 0.9071044921875, 0.2171173095703125, 0, 0],
    [],
    [0, -13.65, 0.226776123046875, 0.465667724609375, 0, 0],
    [0, -11.85, 0.4876556396484375, 0.5403594970703125, 0, 0],
    [0, -8.25, 1.02252197265625, 0.6934967041015625, 0, 0],
    [0, -4.15, 1.0112762451171875, 0.8467559814453125, 0, 0],
    [0, 0, 1, 1, 0, 0],
    [],
    [0, 0, 1, 1, 0, 0],
    [0, -5.25, 0.894622802734375, 1.2215728759765625, 0, 0],
    [0, -6.35, 0.872650146484375, 1.2677764892578125, 0, 0],
    [0, -6.6, 0.86700439453125, 1.2796630859375, 0, 0],
    [0, -5.75, 0.890960693359375, 1.2445526123046875, 0, 0],
    [0, -2.9, 0.972991943359375, 1.1243743896484375, 0, 0],
    [0, 0.4, 1.0673065185546875, 0.9862213134765625, 0, 0],
    [0, 2.15, 1.1177215576171875, 0.912384033203125, 0, 0],
    [0, 2.55, 1.131134033203125, 0.892730712890625, 0, 0],
    [0, 2.45, 1.1253662109375, 0.897430419921875, 0, 0],
    [0, 2.05, 1.10516357421875, 0.9139862060546875, 0, 0],
    [0, 1.4, 1.071136474609375, 0.9418182373046875, 0, 0],
    [0, 0.7, 1.0371856689453125, 0.9695587158203125, 0, 0],
    [0, 0.3, 1.0146484375, 0.988037109375, 0, 0],
    [0, 0.05, 1.0032196044921875, 0.997344970703125, 0, 0],
    [0, 0, 1, 1, 0, 0],
    []
];

var mapButtons = [
    [
        [125.1, 2883.75, true, 1, 1],
        [173.35, 2846, false, 1, 1],
        [244.45, 2838.65, false, 1, 1],
        [314.7, 2830.6, false, 1, 1],
        [350.4, 2797.2, false, 1, 1],
        [331.8, 2754.8, true, 1, 1],
        [281.75, 2718.5, false, 1, 1],
        [268.55, 2684.2, false, 1, 1],
        [303.6, 2650.8, false, 1, 1],
        [358.6, 2630, false, 1, 1],
        [433.1, 2605.55, true, 1, 1],
        [501.7, 2590.45, false, 1, 1],
        [554.55, 2567.65, false, 1, 1],
        [568.75, 2528.7, false, 1, 1],
        [546, 2492.5, false, 1, 1],
        [509, 2455.3, true, 1, 1],
        [434.65, 2415.3, false, 1, 1],
        [373.9, 2398.3, false, 1, 1],
        [307, 2382.8, false, 1, 1],
        [244.45, 2367.7, false, 1, 1],
        [163.2, 2338.4, true, 1, 1],
        [112.25, 2300.5, false, 1, 1],
        [74.05, 2249.75, false, 1, 1],
        [63.45, 2189.7, false, 1, 1],
        [64.65, 2122.25, false, 1, 1],
        [86.75, 2062.45, true, 1, 1],
        [150.95, 2024.3, false, 1, 1],
        [226.75, 2022.6, false, 1, 1],
        [284.95, 2054.7, false, 1, 1],
        [317.05, 2103.25, false, 1, 1],
        [366.2, 2147.25, true, 1, 1],
        [432.05, 2178.1, false, 1, 1],
        [508.55, 2173.6, false, 1, 1],
        [551.3, 2120.1, false, 1, 1],
        [538.7, 2058.6, false, 1, 1],
        [520.1, 2008.45, true, 1, 1],
        [503.4, 1948.85, false, 1, 1],
        [458.9, 1888.95, false, 1, 1],
        [411, 1833.05, false, 1, 1],
        [377.05, 1744.4, false, 1, 1],
        [366.55, 1638.4, false, 1, 1],
        [366.55, 1515, false, 1, 1],
        [361.9, 1397.45, true, 1, 1],
        [353.35, 1345.4, false, 1, 1],
        [383.85, 1293.3, false, 1, 1],
        [466, 1269.55, false, 1, 1],
        [527.1, 1240, false, 1, 1],
        [552.9, 1183, true, 1, 1],
        [532.3, 1128.85, false, 1, 1],
        [487.05, 1080.65, false, 1, 1],
        [428.9, 1033.8, false, 1, 1],
        [366.55, 1004.2, false, 1, 1],
        [283.05, 981.05, true, 1, 1],
        [189.45, 950.25, false, 1, 1],
        [154.5, 892.45, false, 1, 1],
        [202.2, 854.45, false, 1, 1],
        [267.9, 827.55, false, 1, 1],
        [318.9, 789.55, false, 1, 1],
        [336.75, 733.05, false, 1, 1],
        [338.45, 668.2, true, 1.20001220703125, 1.20001220703125]
    ],
    [
        [184, 1934, true, 1, 1],
        [268, 1885, false, 1, 1],
        [328, 1830, false, 1, 1],
        [369, 1773, false, 1, 1],
        [369, 1714, true, 1, 1],
        [359, 1666, false, 1, 1],
        [313, 1629, false, 1, 1],
        [265, 1589, false, 1, 1],
        [207, 1564, false, 1, 1],
        [141, 1530, true, 1, 1],
        [172, 1480, false, 1, 1],
        [249, 1467, false, 1, 1],
        [340, 1449, false, 1, 1],
        [336, 1391, false, 1, 1],
        [307, 1330, true, 1, 1],
        [333, 1282, false, 1, 1],
        [387, 1255, false, 1, 1],
        [453, 1241, false, 1, 1],
        [523, 1212, false, 1, 1],
        [546, 1160, true, 1, 1],
        [535, 1111, false, 1, 1],
        [493, 1079, false, 1, 1],
        [431, 1050, false, 1, 1],
        [371, 1030, false, 1, 1],
        [289, 1016, true, 1, 1],
        [181, 997, false, 1, 1],
        [123, 980, false, 1, 1],
        [90, 934, false, 1, 1],
        [104, 881, false, 1, 1],
        [313, 805, true, 1, 1],
        [413, 806, false, 1, 1],
        [505, 789, false, 1, 1],
        [567, 741, false, 1, 1],
        [552, 678, false, 1, 1],
        [513, 622, true, 1, 1]
    ],
    [
        [510, 1931, true, 1, 1],
        [453, 1887, false, 1, 1],
        [404, 1845, false, 1, 1],
        [378, 1787, false, 1, 1],
        [373, 1717, true, 1, 1],
        [356, 1668, false, 1, 1],
        [354, 1606, false, 1, 1],
        [356, 1550, false, 1, 1],
        [359, 1492, false, 1, 1],
        [370, 1438, true, 1, 1],
        [362, 1395, false, 1, 1],
        [334, 1353, false, 1, 1],
        [336, 1315, false, 1, 1],
        [372, 1282, false, 1, 1],
        [420, 1246, true, 1, 1],
        [484, 1227, false, 1, 1],
        [532, 1211, false, 1, 1],
        [563, 1185, false, 1, 1],
        [571, 1147, false, 1, 1],
        [545, 1111, true, 1, 1],
        [520, 1075, false, 1, 1],
        [478, 1051, false, 1, 1],
        [419, 1032, false, 1, 1],
        [374, 1019, false, 1, 1],
        [323, 998, true, 1, 1],
        [264, 985, false, 1, 1],
        [201, 961, false, 1, 1],
        [146, 902, false, 1, 1],
        [175, 860, false, 1, 1],
        [228, 826, true, 1, 1],
        [301, 802, false, 1, 1],
        [356, 780, false, 1, 1],
        [400, 738, false, 1, 1],
        [373, 693, false, 1, 1],
        [349, 651, true, 1, 1]
    ],
    [
        [154, 1952, true, 1, 1],
        [201, 1905, false, 1, 1],
        [234, 1862, false, 1, 1],
        [228, 1809, false, 1, 1],
        [201, 1759, true, 1, 1],
        [189, 1651, false, 1, 1],
        [336, 1625, false, 1, 1],
        [394, 1597, false, 1, 1],
        [430, 1550, false, 1, 1],
        [409, 1498, true, 1, 1],
        [391, 1451, false, 1, 1],
        [339, 1411, false, 1, 1],
        [278, 1378, false, 1, 1],
        [221, 1353, false, 1, 1],
        [163, 1311, true, 1, 1],
        [121, 1265, false, 1, 1],
        [102, 1225, false, 1, 1],
        [99, 1178, false, 1, 1],
        [124, 1133, false, 1, 1],
        [163, 1096, true, 1, 1],
        [211, 1054, false, 1, 1],
        [276, 1039, false, 1, 1],
        [339, 1039, false, 1, 1],
        [391, 1061, false, 1, 1],
        [453, 1088, true, 1, 1],
        [525, 1060, false, 1, 1],
        [567, 1022, false, 1, 1],
        [572, 968, false, 1, 1],
        [541, 916, false, 1, 1],
        [486, 873, true, 1, 1],
        [418, 854, false, 1, 1],
        [364, 845, false, 1, 1],
        [314, 823, false, 1, 1],
        [280, 792, false, 1, 1],
        [252, 747, true, 1, 1],
        [207, 707, false, 1, 1],
        [193, 666, false, 1, 1],
        [211, 621, false, 1, 1],
        [263, 589, false, 1, 1],
        [267, 508, true, 1, 1]
    ],
    [
        [350, 1759, true, 1, 1],
        [365, 1702, false, 1, 1],
        [339, 1640, false, 1, 1],
        [284, 1599, false, 1, 1],
        [274, 1543, true, 1, 1],
        [289, 1492, false, 1, 1],
        [330, 1458, false, 1, 1],
        [360, 1416, false, 1, 1],
        [368, 1373, false, 1, 1],
        [358, 1324, true, 1, 1],
        [350, 1281, false, 1, 1],
        [333, 1240, false, 1, 1],
        [306, 1204, false, 1, 1],
        [273, 1170, false, 1, 1],
        [241, 1135, true, 1, 1],
        [202, 1092, false, 1, 1],
        [158, 1059, false, 1, 1],
        [117, 1015, false, 1, 1],
        [96, 969, false, 1, 1],
        [86, 924, true, 1, 1],
        [87, 872, false, 1, 1],
        [105, 833, false, 1, 1],
        [134, 796, false, 1, 1],
        [172, 768, false, 1, 1],
        [234, 744, true, 1, 1],
        [306, 739, false, 1, 1],
        [355, 752, false, 1, 1],
        [394, 782, false, 1, 1],
        [417, 816, false, 1, 1],
        [454, 852, true, 1, 1],
        [516, 822, false, 1, 1],
        [558, 790, false, 1, 1],
        [566, 747, false, 1, 1],
        [530, 707, false, 1, 1],
        [481, 660, true, 1, 1],
        [417, 645, false, 1, 1],
        [362, 632, false, 1, 1],
        [322, 607, false, 1, 1],
        [310, 574, false, 1, 1],
        [316, 530, true, 1, 1]
    ]
];

var chocolateAnimation = [
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [0.25, 7.95, 1.0039005430129848, 0.699927374019762, -0.17572710696608806, -0.25091382934958845],
    [3.8, -4.95, 1.0038854851040966, 1.2380742511507645, 6.807021168348068, -0.2535366219908733],
    [4.5, -7.85, 1.0039464525279238, 1.3537655276458822, 9.460413057114621, -0.25266235777711166],
    [4.35, -7.2, 1.003915868334578, 1.3241753768006752, 8.27053946218504, -0.2517880935633501],
    [3.05, -4.6, 1.00394651966743, 1.2140809866924238, 4.8547891790183435, -0.2535366219908733],
    [1.05, -0.5, 1.00394651966743, 1.0416668224831305, 0.26577632098353615, -0.2535366219908733],
    [-0.2, 2.15, 1.0039463189446443, 0.9305971429037946, -1.6331255513067289, -0.25091382934958845],
    [-0.65, 2.9, 1.0039617783082746, 0.9014960891165206, -2.2573501999325343, -0.2535366219908733],
    [-0.7, 2.75, 1.0039007437449232, 0.9070135007285188, -2.0449039959884576, -0.2535366219908733],
    [-0.45, 2.2, 1.0039160023857543, 0.9272775244194382, -1.8551886616021833, -0.2535366219908733],
    [-0.1, 1.25, 1.0039007437449232, 0.9672864986624109, -1.2091074076323372, -0.2535366219908733],
    [0.3, -0.1, 1.0039007437449232, 1.0213470514835623, -0.006119849496331425, -0.2535366219908733],
    [0.7, -1.2, 1.0039005430129848, 1.0656385857259325, 0.5359239630358805, -0.25091382934958845],
    [0.95, -1.8, 1.0039617783082746, 1.0889113756160236, 1.0902074745607553, -0.2535366219908733],
    [0.9, -1.95, 1.0039617783082746, 1.0954154635915763, 1.3717205513920008, -0.2535366219908733],
    [1, -1.9, 1.004404278894728, 1.0924377524526732, 1.0972015882708483, -0.2535366219908733],
    [0.8, -1.65, 1.005930009232166, 1.0820333567101321, 0.8156885114396027, -0.2517880935633501],
    [0.5, -1.15, 1.0089207700117937, 1.0617778590746851, 0.5333011703945956, -0.25266235777711166],
    [0.2, -0.5, 1.013254291411833, 1.0325164835511558, -0.005245585282569793, -0.2535366219908733],
    [-0.15, 0.2, 1.017633588756538, 1.0029243879540377, -0.7536157522625269, -0.2544108862046349],
    [-0.55, 0.7, 1.0206243495245952, 0.9825950781765579, -1.2292154845488548, -0.25528515041839656],
    [-0.6, 0.95, 1.022104638554016, 0.9721506455878783, -1.459146972768164, -0.25790794305968145],
    [-0.6, 0.95, 1.022562397788656, 0.9693138886996874, -1.4600212369819257, -0.25790794305968145],
    [-0.6, 0.9, 1.0225318134485322, 0.9696474640905179, -1.4556499159131175, -0.2570336788459198],
    [-0.6, 0.85, 1.0225775225481866, 0.9710515903599366, -1.4573984443406407, -0.2561594146321582],
    [-0.65, 0.8, 1.0225318134485322, 0.9737895249508317, -1.2204728424112385, -0.2570336788459198],
    [-0.5, 0.65, 1.0225318134485322, 0.9779399248554523, -1.2230956350525233, -0.2570336788459198],
    [-0.35, 0.5, 1.0225318134485322, 0.9836256009660826, -0.9870442973368827, -0.2570336788459198],
    [-0.3, 0.35, 1.0225318134485322, 0.9899384747296486, -0.7457473743386722, -0.2570336788459198],
    [-0.2, 0.2, 1.022592848017418, 0.9956742417743323, -0.5000791302716536, -0.2570336788459198],
    [-0.1, 0.05, 1.0225318805062231, 0.9998420130925026, -0.2544108862046349, -0.25790794305968145],
    [-0.05, 0.05, 1.0225318805062231, 1.0025581185311385, -0.25528515041839656, -0.25790794305968145],
    [0, -0.05, 1.0225166218650132, 1.0039160697592193, -0.2544108862046349, -0.25790794305968145],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [-4.95, 4.95, 0.8221209239039776, 0.8075028768730291, -0.20282929759269866, -0.2063263544477452],
    [4.45, 2.4, 1.0651355428279108, 1.0526053914937243, 7.359556151445419, 7.179457723410523],
    [6.15, 2.05, 1.1117451627787787, 1.0997111120343914, 9.331021953477899, 9.148300732801719],
    [5.5, 2.1, 1.098345966191465, 1.086053619184093, 8.400804830035524, 8.223329194641911],
    [3.1, 2.35, 1.0491655333572734, 1.0361683650213676, 5.183512523392717, 5.2438367541422695],
    [-0.6, 2.7, 0.9720646930531768, 0.9580630322727205, 0.9608163709240337, 1.2178500497699536],
    [-2.9, 2.85, 0.9224593152678693, 0.9075696957648599, -1.3647264376819077, -0.9267200665873301],
    [-3.55, 2.8, 0.9092719223857227, 0.8942654708860472, -2.0204245980031317, -1.5981549827562636],
    [-3.45, 2.7, 0.9137060212029187, 0.898580964700096, -2.0212988622168933, -1.3743433440332857],
    [-2.85, 2.45, 0.9298031891739947, 0.9142763267758027, -1.60165203961131, -1.1653941969442556],
    [-1.85, 1.85, 0.9611147752409256, 0.9449379440981887, -0.945953879290086, -0.24391971563949535],
    [-0.35, 1.2, 1.001137079650242, 0.9842834473838991, -0.0008742642137616321, 0.5027019229129385],
    [0.75, 0.65, 1.0321535440583613, 1.0146439312870608, 0.7614841301863816, 1.294785300580977],
    [1.25, 0.3, 1.0480835172156715, 1.0303100435931216, 1.0360030933075342, 1.8385776415407125],
    [1.5, 0.3, 1.052631370148809, 1.0346716430224374, 1.297408093222262, 2.11047381202058],
    [1.4, 0.25, 1.0511528337726959, 1.0333013768388621, 1.0395001501625807, 1.8455717552508055],
    [1.25, 0.3, 1.04626623689208, 1.0285087130519324, 1.0325060364524876, 1.8342063204719041],
    [0.85, 0.4, 1.0369920934798935, 1.019265698533553, 0.5149416219056013, 1.3017794142910701],
    [0.25, 0.5, 1.0232816644181146, 1.0056762724252062, 0.004371321068808161, 0.7702267723239979],
    [-0.3, 0.5, 1.0097448704955132, 0.9920445780665013, -0.25091382934958845, 0.2544108862046349],
    [-0.75, 0.6, 1.000244140741387, 0.9825526554756191, -0.7405017890561024, -0.0008742642137616321],
    [-0.95, 0.65, 0.9954223651524609, 0.9776889717519495, -0.9809244478405512, -0.0034970568550465285],
    [-1.05, 0.7, 0.9940741121885188, 0.9763621965264736, -0.9826729762680745, -0.25266235777711166],
    [-1.1, 0.65, 0.9943944087405023, 0.9766202190746489, -0.9783016551992664, -0.25091382934958845],
    [-1.05, 0.65, 0.9955388740738401, 0.9778104894976429, -0.979175919413028, -0.2517880935633501],
    [-0.9, 0.6, 0.9977513769796691, 0.9799737418066933, -0.7387532606285792, -0.2517880935633501],
    [-0.9, 0.5, 1.0011541211421617, 0.9832850140334063, -0.7405017890561024, -0.25266235777711166],
    [-0.65, 0.45, 1.0057471065689487, 0.9878014269752817, -0.741376053269864, -0.2544108862046349],
    [-0.5, 0.25, 1.010874077120794, 0.9929278998081399, -0.5009533944854152, -0.25528515041839656],
    [-0.3, 0.15, 1.01545173664096, 0.9974616655283957, -0.2544108862046349, -0.2561594146321582],
    [-0.2, 0.15, 1.0188392221618545, 1.0007270141384723, -0.2544108862046349, -0.2570336788459198],
    [-0.1, 0.1, 1.0210668501926183, 1.0028782806296468, -0.2517880935633501, -0.25528515041839656],
    [-0.05, 0.05, 1.022196190400626, 1.003977104318493, -0.2544108862046349, -0.25790794305968145],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [-8.4, 0.05, 0.6871405658940057, 1.0043432443308542, -0.2535366219908733, -0.17485284275232643],
    [5.05, 3.2, 1.2342607790124183, 1.0044042117858207, -0.25266235777711166, 6.170556820729599],
    [8.1, 3.85, 1.3517578417433938, 1.004343379252283, -0.25528515041839656, 8.449763626006174],
    [7.35, 3.55, 1.3229537946083092, 1.0043890875954882, -0.2544108862046349, 7.601727338657391],
    [4.75, 2.4, 1.2154999467923961, 1.0043431772178686, -0.25266235777711166, 4.257666721019149],
    [0.55, 0.6, 1.047302250095414, 1.0043890202537529, -0.2535366219908733, 0.005245585282569793],
    [-2.1, -0.6, 0.9389472623538925, 1.0043890202537529, -0.2535366219908733, -1.647113778726915],
    [-2.8, -0.95, 0.9105671550614853, 1.004404413807958, -0.25528515041839656, -2.2783325410628135],
    [-2.7, -0.85, 0.9165731153944815, 1.0043431103367024, -0.2517880935633501, -2.0667606013324984],
    [-2.1, -0.6, 0.9385645705546704, 1.0044043462354404, -0.2544108862046349, -1.64449098608563],
    [-1.05, -0.2, 0.9813770285855344, 1.0043888196193989, -0.25091382934958845, -0.7370047322010559],
    [0.35, 0.4, 1.0361116894322508, 1.004343311675659, -0.2544108862046349, 0.5210614714019327],
    [1.35, 0.9, 1.0785422565100558, 1.004343311675659, -0.2544108862046349, 1.6217601165278277],
    [1.9, 1.15, 1.1004508292239867, 1.004404278894728, -0.2535366219908733, 2.2057686113205976],
    [2.05, 1.25, 1.106694519600252, 1.0044042117858207, -0.25266235777711166, 2.4986471229307448],
    [2, 1.25, 1.1035141422675308, 1.0044041449087187, -0.2517880935633501, 2.48553315972432],
    [1.7, 1.1, 1.092829612608209, 1.0043890202537529, -0.2535366219908733, 2.186534798617842],
    [1.25, 0.9, 1.0720852065385242, 1.0043432443308542, -0.2535366219908733, 1.611268945962688],
    [0.45, 0.55, 1.0420053898172483, 1.0043431103367024, -0.2517880935633501, 0.7824664713166608],
    [-0.3, 0.2, 1.0119018583449015, 1.0043890875954882, -0.2544108862046349, 0.004371321068808161],
    [-0.8, 0, 0.9910376431340779, 1.004327985689897, -0.2535366219908733, -0.25266235777711166],
    [-1, -0.1, 0.9803539361828861, 1.004404278894728, -0.2535366219908733, -0.4930850165615605],
    [-1.1, -0.2, 0.9772886677002749, 1.004404413807958, -0.25528515041839656, -0.5035761871267002],
    [-1.15, -0.15, 0.9778209408729562, 1.0044043462354404, -0.2544108862046349, -0.4922107523477989],
    [-1.05, -0.15, 0.9796215425499742, 1.0044043462354404, -0.2544108862046349, -0.4930850165615605],
    [-0.95, -0.1, 0.9831158045756578, 1.0044043462354404, -0.2544108862046349, -0.49395928077532214],
    [-0.75, -0.15, 0.9885327341725995, 1.004404078263422, -0.25091382934958845, -0.4957078092028454],
    [-0.65, -0.1, 0.9958572065929132, 1.0044043462354404, -0.2544108862046349, -0.49920486605789194],
    [-0.4, -0.05, 1.0039773078180232, 1.004343311675659, -0.2544108862046349, -0.2570336788459198],
    [-0.2, -0.05, 1.0112862631446558, 1.004343311675659, -0.2544108862046349, -0.25790794305968145],
    [-0.1, -0.05, 1.016672630281168, 1.0043431772178686, -0.25266235777711166, -0.2587822072734431],
    [0, 0, 1.0201515999733455, 1.0043431103367024, -0.2517880935633501, -0.2587822072734431],
    [0.05, 0, 1.0219826367470022, 1.004343311675659, -0.2544108862046349, -0.2587822072734431],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [-5.05, -4.5, 0.8221209239039776, 0.8075028768730291, -0.20282929759269866, -0.2063263544477452],
    [-1.6, 2.95, 1.0651355428279108, 1.0526053914937243, 7.359556151445419, 7.179457723410523],
    [-1.05, 4.45, 1.1117451627787787, 1.0997111120343914, 9.331021953477899, 9.148300732801719],
    [-1.15, 3.9, 1.0981433212405909, 1.0858034740087847, 8.397307773180476, 8.220706402000626],
    [-1.6, 2, 1.047912427573485, 1.0349542025874106, 5.1747698812551, 5.239465433073462],
    [-2.2, -1.2, 0.9693021779654367, 0.9553010805619381, 0.9590678424965104, 1.214352992914907],
    [-2.65, -3.15, 0.9187056957977933, 0.903875537559088, -1.3586065881855762, -0.9249715381598068],
    [-2.65, -3.75, 0.9052722564656641, 0.890325146656128, -2.010807691651754, -1.5911608690461705],
    [-2.6, -3.55, 0.9098448755384902, 0.894733322970929, -2.0134304842930386, -1.3699720229644776],
    [-2.4, -3.05, 0.9263999583960307, 0.9108728754048542, -1.597280718542502, -1.161897140089209],
    [-1.7, -2.1, 0.9585818411706041, 0.9423745927056884, -0.9450796150763243, -0.24391971563949535],
    [-1.15, -0.85, 0.9996721584322529, 0.9828033448450149, -0.0008742642137616321, 0.5018276586991769],
    [-0.6, 0.2, 1.031619948891686, 1.0140952629959594, 0.7641069228276665, 1.2956595647947389],
    [-0.35, 0.7, 1.0479148151730404, 1.030218772884307, 1.0368773575212957, 1.836829113113189],
    [-0.25, 0.95, 1.052631370148809, 1.0346716430224374, 1.297408093222262, 2.11047381202058],
    [-0.25, 0.85, 1.0511528337726959, 1.0333013768388621, 1.0395001501625807, 1.8455717552508055],
    [-0.35, 0.75, 1.04626623689208, 1.0285087130519324, 1.0325060364524876, 1.8342063204719041],
    [-0.55, 0.3, 1.0369920934798935, 1.019265698533553, 0.5149416219056013, 1.3017794142910701],
    [-0.65, -0.25, 1.0232816644181146, 1.0056762724252062, 0.004371321068808161, 0.7702267723239979],
    [-0.75, -0.75, 1.0097448704955132, 0.9920445780665013, -0.25091382934958845, 0.2544108862046349],
    [-0.9, -1.2, 1.000244140741387, 0.9825526554756191, -0.7405017890561024, -0.0008742642137616321],
    [-1, -1.4, 0.9954223651524609, 0.9776889717519495, -0.9809244478405512, -0.0034970568550465285],
    [-1.05, -1.4, 0.9940741121885188, 0.9763621965264736, -0.9826729762680745, -0.25266235777711166],
    [-1.1, -1.45, 0.9943944087405023, 0.9766202190746489, -0.9783016551992664, -0.25091382934958845],
    [-1.05, -1.3, 0.9955388740738401, 0.9778104894976429, -0.979175919413028, -0.2517880935633501],
    [-0.9, -1.2, 0.9977513769796691, 0.9799737418066933, -0.7387532606285792, -0.2517880935633501],
    [-0.85, -1.1, 1.0011541211421617, 0.9832850140334063, -0.7405017890561024, -0.25266235777711166],
    [-0.7, -0.85, 1.0057471065689487, 0.9878014269752817, -0.741376053269864, -0.2544108862046349],
    [-0.45, -0.6, 1.010874077120794, 0.9929278998081399, -0.5009533944854152, -0.25528515041839656],
    [-0.25, -0.35, 1.01545173664096, 0.9974616655283957, -0.2544108862046349, -0.2561594146321582],
    [-0.2, -0.15, 1.0188392221618545, 1.0007270141384723, -0.2544108862046349, -0.2570336788459198],
    [-0.1, -0.05, 1.0210668501926183, 1.0028782806296468, -0.2517880935633501, -0.25528515041839656],
    [-0.1, 0, 1.022196190400626, 1.003977104318493, -0.2544108862046349, -0.25790794305968145],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [0.25, -7.6, 1.0039005430129848, 0.699927374019762, -0.17572710696608806, -0.25091382934958845],
    [-3.5, 5.05, 1.0038854851040966, 1.2380742511507645, 6.807021168348068, -0.2535366219908733],
    [-4.2, 7.6, 1.0039464525279238, 1.3537655276458822, 9.460413057114621, -0.25266235777711166],
    [-3.85, 7, 1.003915868334578, 1.3241753768006752, 8.27053946218504, -0.2517880935633501],
    [-2.8, 4.5, 1.00394651966743, 1.2140809866924238, 4.8547891790183435, -0.2535366219908733],
    [-1.1, 0.35, 1.00394651966743, 1.0416668224831305, 0.26577632098353615, -0.2535366219908733],
    [0.05, -2.25, 1.0039463189446443, 0.9305971429037946, -1.6331255513067289, -0.25091382934958845],
    [0.25, -2.9, 1.0039617783082746, 0.9014960891165206, -2.2573501999325343, -0.2535366219908733],
    [0.2, -2.75, 1.0039007437449232, 0.9070135007285188, -2.0449039959884576, -0.2535366219908733],
    [0.15, -2.3, 1.0039160023857543, 0.9272775244194382, -1.8551886616021833, -0.2535366219908733],
    [-0.05, -1.35, 1.0039007437449232, 0.9672864986624109, -1.2091074076323372, -0.2535366219908733],
    [-0.25, -0.05, 1.0039007437449232, 1.0213470514835623, -0.006119849496331425, -0.2535366219908733],
    [-0.45, 1, 1.0039005430129848, 1.0656385857259325, 0.5359239630358805, -0.25091382934958845],
    [-0.5, 1.5, 1.0039617783082746, 1.0889113756160236, 1.0902074745607553, -0.2535366219908733],
    [-0.6, 1.7, 1.0039617783082746, 1.0954154635915763, 1.3717205513920008, -0.2535366219908733],
    [-0.6, 1.6, 1.004404278894728, 1.0924377524526732, 1.0972015882708483, -0.2535366219908733],
    [-0.4, 1.4, 1.005930009232166, 1.0820333567101321, 0.8156885114396027, -0.2517880935633501],
    [-0.35, 1.05, 1.0089207700117937, 1.0617778590746851, 0.5333011703945956, -0.25266235777711166],
    [-0.1, 0.4, 1.013254291411833, 1.0325164835511558, -0.005245585282569793, -0.2535366219908733],
    [0, -0.15, 1.017633588756538, 1.0029243879540377, -0.7536157522625269, -0.2544108862046349],
    [0.15, -0.6, 1.0206243495245952, 0.9825950781765579, -1.2292154845488548, -0.25528515041839656],
    [0.25, -0.75, 1.022104638554016, 0.9721506455878783, -1.459146972768164, -0.25790794305968145],
    [0.35, -0.9, 1.022562397788656, 0.9693138886996874, -1.4600212369819257, -0.25790794305968145],
    [0.3, -0.9, 1.0225318134485322, 0.9696474640905179, -1.4556499159131175, -0.2570336788459198],
    [0.3, -0.85, 1.0225775225481866, 0.9710515903599366, -1.4573984443406407, -0.2561594146321582],
    [0.3, -0.8, 1.0225318134485322, 0.9737895249508317, -1.2204728424112385, -0.2570336788459198],
    [0.2, -0.7, 1.0225318134485322, 0.9779399248554523, -1.2230956350525233, -0.2570336788459198],
    [0.2, -0.5, 1.0225318134485322, 0.9836256009660826, -0.9870442973368827, -0.2570336788459198],
    [0.15, -0.35, 1.0225318134485322, 0.9899384747296486, -0.7457473743386722, -0.2570336788459198],
    [0.1, -0.25, 1.022592848017418, 0.9956742417743323, -0.5000791302716536, -0.2570336788459198],
    [0.05, -0.15, 1.0225318805062231, 0.9998420130925026, -0.2544108862046349, -0.25790794305968145],
    [0, -0.1, 1.0225318805062231, 1.0025581185311385, -0.25528515041839656, -0.25790794305968145],
    [0, -0.05, 1.0225166218650132, 1.0039160697592193, -0.2544108862046349, -0.25790794305968145],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [4.7, -4.6, 0.8221209239039776, 0.8075028768730291, -0.20282929759269866, -0.2063263544477452],
    [-3.95, -1.9, 1.0651355428279108, 1.0526053914937243, 7.359556151445419, 7.179457723410523],
    [-5.85, -1.25, 1.1117451627787787, 1.0997111120343914, 9.331021953477899, 9.148300732801719],
    [-5.15, -1.35, 1.0975847586881637, 1.0853134826307793, 8.394684980539191, 8.214586552504295],
    [-2.75, -1.8, 1.04551983295406, 1.0325669339405066, 5.164278710689961, 5.2254772056532754],
    [0.9, -2.3, 0.9638836003174799, 0.9500044218553747, 0.9503252003588941, 1.2064846149910524],
    [3.35, -2.6, 0.9113949157728896, 0.8967011711350861, -1.347241153406675, -0.9153546318084288],
    [3.85, -2.85, 0.8974707276554361, 0.882659158349247, -1.9933224073765212, -1.5762983774122228],
    [3.75, -2.75, 0.9022739171020677, 0.8873271337296574, -1.9968194642315678, -1.3586065881855762],
    [3.1, -2.55, 0.9196986143396627, 0.9043534201457577, -1.5841667553360774, -1.150531705310308],
    [2.1, -2.05, 0.9535921308581294, 0.9374759364268401, -0.9407082940075162, -0.2421711872119721],
    [0.4, -1.4, 0.9968190088979388, 0.9801025391812788, -0.0008742642137616321, 0.5027019229129385],
    [-0.75, -0.9, 1.0304449700210259, 1.0129660095839816, 0.7632326586139049, 1.294785300580977],
    [-1.5, -0.7, 1.0477170107908167, 1.0299430864436254, 1.0333803006662492, 1.8377033773269507],
    [-1.4, -0.6, 1.052631370148809, 1.0346716430224374, 1.297408093222262, 2.11047381202058],
    [-1.5, -0.6, 1.0511528337726959, 1.0333013768388621, 1.0395001501625807, 1.8455717552508055],
    [-1.2, -0.7, 1.04626623689208, 1.0285087130519324, 1.0325060364524876, 1.8342063204719041],
    [-0.85, -0.75, 1.0369920934798935, 1.019265698533553, 0.5149416219056013, 1.3017794142910701],
    [-0.2, -0.8, 1.0232816644181146, 1.0056762724252062, 0.004371321068808161, 0.7702267723239979],
    [0.45, -1, 1.0097448704955132, 0.9920445780665013, -0.25091382934958845, 0.2544108862046349],
    [0.8, -1.1, 1.000244140741387, 0.9825526554756191, -0.7405017890561024, -0.0008742642137616321],
    [1.05, -1.15, 0.9954223651524609, 0.9776889717519495, -0.9809244478405512, -0.0034970568550465285],
    [1.05, -1.1, 0.9940741121885188, 0.9763621965264736, -0.9826729762680745, -0.25266235777711166],
    [1, -1.15, 0.9943944087405023, 0.9766202190746489, -0.9783016551992664, -0.25091382934958845],
    [0.95, -1.1, 0.9955388740738401, 0.9778104894976429, -0.979175919413028, -0.2517880935633501],
    [0.9, -1, 0.9977513769796691, 0.9799737418066933, -0.7387532606285792, -0.2517880935633501],
    [0.8, -0.85, 1.0011541211421617, 0.9832850140334063, -0.7405017890561024, -0.25266235777711166],
    [0.55, -0.7, 1.0057471065689487, 0.9878014269752817, -0.741376053269864, -0.2544108862046349],
    [0.4, -0.45, 1.010874077120794, 0.9929278998081399, -0.5009533944854152, -0.25528515041839656],
    [0.2, -0.3, 1.01545173664096, 0.9974616655283957, -0.2544108862046349, -0.2561594146321582],
    [0.1, -0.15, 1.0188392221618545, 1.0007270141384723, -0.2544108862046349, -0.2570336788459198],
    [-0.05, -0.05, 1.0210668501926183, 1.0028782806296468, -0.2517880935633501, -0.25528515041839656],
    [-0.1, 0, 1.022196190400626, 1.003977104318493, -0.2544108862046349, -0.25790794305968145],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [8.65, 0.05, 0.6871405658940057, 1.0043432443308542, -0.2535366219908733, -0.17485284275232643],
    [-5.15, -2.8, 1.2342607790124183, 1.0044042117858207, -0.25266235777711166, 6.170556820729599],
    [-7.85, -3.5, 1.3517578417433938, 1.004343379252283, -0.25528515041839656, 8.449763626006174],
    [-7.3, -3.2, 1.3229537946083092, 1.0043890875954882, -0.2544108862046349, 7.601727338657391],
    [-4.5, -2.1, 1.2154999467923961, 1.0043431772178686, -0.25266235777711166, 4.257666721019149],
    [-0.45, -0.45, 1.047302250095414, 1.0043890202537529, -0.2535366219908733, 0.005245585282569793],
    [2.1, 0.6, 0.9389472623538925, 1.0043890202537529, -0.2535366219908733, -1.647113778726915],
    [2.95, 0.9, 0.9105671550614853, 1.004404413807958, -0.25528515041839656, -2.2783325410628135],
    [2.9, 0.8, 0.9165731153944815, 1.0043431103367024, -0.2517880935633501, -2.0667606013324984],
    [2.25, 0.55, 0.9385645705546704, 1.0044043462354404, -0.2544108862046349, -1.64449098608563],
    [1.2, 0.05, 0.9813770285855344, 1.0043888196193989, -0.25091382934958845, -0.7370047322010559],
    [-0.1, -0.55, 1.0361116894322508, 1.004343311675659, -0.2544108862046349, 0.5210614714019327],
    [-1.3, -1.05, 1.0785422565100558, 1.004343311675659, -0.2544108862046349, 1.6217601165278277],
    [-1.8, -1.35, 1.1004508292239867, 1.004404278894728, -0.2535366219908733, 2.2057686113205976],
    [-2.05, -1.35, 1.106694519600252, 1.0044042117858207, -0.25266235777711166, 2.4986471229307448],
    [-2, -1.3, 1.1035141422675308, 1.0044041449087187, -0.2517880935633501, 2.48553315972432],
    [-1.75, -1.2, 1.092829612608209, 1.0043890202537529, -0.2535366219908733, 2.186534798617842],
    [-1.2, -1, 1.0720852065385242, 1.0043432443308542, -0.2535366219908733, 1.611268945962688],
    [-0.45, -0.65, 1.0420053898172483, 1.0043431103367024, -0.2517880935633501, 0.7824664713166608],
    [0.2, -0.3, 1.0119018583449015, 1.0043890875954882, -0.2544108862046349, 0.004371321068808161],
    [0.7, -0.1, 0.9910376431340779, 1.004327985689897, -0.2535366219908733, -0.25266235777711166],
    [1, 0, 0.9803539361828861, 1.004404278894728, -0.2535366219908733, -0.4930850165615605],
    [1.05, 0, 0.9772886677002749, 1.004404413807958, -0.25528515041839656, -0.5035761871267002],
    [1.1, 0, 0.9778209408729562, 1.0044043462354404, -0.2544108862046349, -0.4922107523477989],
    [1.05, 0, 0.9796215425499742, 1.0044043462354404, -0.2544108862046349, -0.4930850165615605],
    [0.95, 0, 0.9831158045756578, 1.0044043462354404, -0.2544108862046349, -0.49395928077532214],
    [0.85, 0, 0.9885327341725995, 1.004404078263422, -0.25091382934958845, -0.4957078092028454],
    [0.65, 0, 0.9958572065929132, 1.0044043462354404, -0.2544108862046349, -0.49920486605789194],
    [0.5, 0, 1.0039773078180232, 1.004343311675659, -0.2544108862046349, -0.2570336788459198],
    [0.3, 0, 1.0112862631446558, 1.004343311675659, -0.2544108862046349, -0.25790794305968145],
    [0.2, 0, 1.016672630281168, 1.0043431772178686, -0.25266235777711166, -0.2587822072734431],
    [0.1, -0.05, 1.0201515999733455, 1.0043431103367024, -0.2517880935633501, -0.2587822072734431],
    [0.05, -0.05, 1.0219826367470022, 1.004343311675659, -0.2544108862046349, -0.2587822072734431],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    [],
    [],
    [5, 4.4, 0.8221209239039776, 0.8075028768730291, -0.20282929759269866, -0.2063263544477452],
    [3.55, -3.85, 1.0651355428279108, 1.0526053914937243, 7.359556151445419, 7.179457723410523],
    [3.2, -5.3, 1.1117451627787787, 1.0997111120343914, 9.331021953477899, 9.148300732801719],
    [3.2, -4.7, 1.0975847586881637, 1.0853134826307793, 8.394684980539191, 8.214586552504295],
    [3.25, -2.55, 1.04551983295406, 1.0325669339405066, 5.164278710689961, 5.2254772056532754],
    [3.4, 0.9, 0.9638836003174799, 0.9500044218553747, 0.9503252003588941, 1.2064846149910524],
    [3.5, 3.05, 0.9113949157728896, 0.8967011711350861, -1.347241153406675, -0.9153546318084288],
    [3.55, 3.55, 0.8974707276554361, 0.882659158349247, -1.9933224073765212, -1.5762983774122228],
    [3.35, 3.45, 0.9022739171020677, 0.8873271337296574, -1.9968194642315678, -1.3586065881855762],
    [3.05, 2.85, 0.9196986143396627, 0.9043534201457577, -1.5841667553360774, -1.150531705310308],
    [2.35, 1.75, 0.9535921308581294, 0.9374759364268401, -0.9407082940075162, -0.2421711872119721],
    [1.65, 0.5, 0.9968190088979388, 0.9801025391812788, -0.0008742642137616321, 0.5027019229129385],
    [0.95, -0.6, 1.0304449700210259, 1.0129660095839816, 0.7632326586139049, 1.294785300580977],
    [0.8, -1.2, 1.0477170107908167, 1.0299430864436254, 1.0333803006662492, 1.8377033773269507],
    [0.75, -1.25, 1.052631370148809, 1.0346716430224374, 1.297408093222262, 2.11047381202058],
    [0.7, -1.25, 1.0511528337726959, 1.0333013768388621, 1.0395001501625807, 1.8455717552508055],
    [0.75, -1, 1.04626623689208, 1.0285087130519324, 1.0325060364524876, 1.8342063204719041],
    [0.65, -0.7, 1.0369920934798935, 1.019265698533553, 0.5149416219056013, 1.3017794142910701],
    [0.75, -0.15, 1.0232816644181146, 1.0056762724252062, 0.004371321068808161, 0.7702267723239979],
    [0.85, 0.3, 1.0097448704955132, 0.9920445780665013, -0.25091382934958845, 0.2544108862046349],
    [0.9, 0.65, 1.000244140741387, 0.9825526554756191, -0.7405017890561024, -0.0008742642137616321],
    [0.9, 0.75, 0.9954223651524609, 0.9776889717519495, -0.9809244478405512, -0.0034970568550465285],
    [0.85, 0.9, 0.9940741121885188, 0.9763621965264736, -0.9826729762680745, -0.25266235777711166],
    [0.85, 0.85, 0.9943944087405023, 0.9766202190746489, -0.9783016551992664, -0.25091382934958845],
    [0.75, 0.8, 0.9955388740738401, 0.9778104894976429, -0.979175919413028, -0.2517880935633501],
    [0.75, 0.75, 0.9977513769796691, 0.9799737418066933, -0.7387532606285792, -0.2517880935633501],
    [0.6, 0.6, 1.0011541211421617, 0.9832850140334063, -0.7405017890561024, -0.25266235777711166],
    [0.5, 0.5, 1.0057471065689487, 0.9878014269752817, -0.741376053269864, -0.2544108862046349],
    [0.25, 0.3, 1.010874077120794, 0.9929278998081399, -0.5009533944854152, -0.25528515041839656],
    [0.1, 0.15, 1.01545173664096, 0.9974616655283957, -0.2544108862046349, -0.2561594146321582],
    [0.05, 0.1, 1.0188392221618545, 1.0007270141384723, -0.2544108862046349, -0.2570336788459198],
    [0, 0.05, 1.0210668501926183, 1.0028782806296468, -0.2517880935633501, -0.25528515041839656],
    [0, 0, 1.022196190400626, 1.003977104318493, -0.2544108862046349, -0.25790794305968145],
    [0, 0, 1.0225318805062231, 1.004343379252283, -0.25528515041839656, -0.25790794305968145],
    []
];

var waterAnimation = [
    [0, 0.45, 0.773773193359375, 0.773773193359375, 0, 0, 0],
    [0, -1.3, 0.7805633544921875, 0.7798309326171875, 0, 0, 0],
    [0, -7.9, 0.805877685546875, 0.8024139404296875, 0, 0, 0],
    [0, -14.5, 0.8311614990234375, 0.824981689453125, 0, 0, 0],
    [0, -16.25, 0.8379669189453125, 0.8310546875, 0, 0, 0],
    [0, -13.05, 0.8698883056640625, 0.8643646240234375, 0, 0, 0.1953125],
    [0, -9.2, 0.908111572265625, 0.904205322265625, 0, 0, 0.43359375],
    [0, -5.45, 0.945526123046875, 0.943206787109375, 0, 0, 0.6640625],
    [0, -2.45, 0.9754486083984375, 0.974395751953125, 0, 0, 0.84765625],
    [0, -0.6, 0.9939422607421875, 0.993682861328125, 0, 0, 0.9609375],
    [0, 0, 1, 1, 0, 0, 1],
    [],
    [0, 0, 1, 1, 0, 0, 1],
    [0, -6.6, 0.9950408935546875, 0.8957366943359375, 0, 0, 1],
    [0, -12, 0.990966796875, 0.810150146484375, 0, 0, 1],
    [0, -14.75, 0.9889068603515625, 0.76690673828125, 0, 0, 1],
    [0, -15.45, 0.988372802734375, 0.7557830810546875, 0, 0, 1],
    [0, -14.3, 0.960479736328125, 0.76629638671875, 0, 0, 0.9296875],
    [0.05, -9.95, 0.8547515869140625, 0.806121826171875, 0, 0, 0.69140625],
    [0, -3.1, 0.689361572265625, 0.8684234619140625, 0, 0, 0.30859375],
    [0, 1.25, 0.583648681640625, 0.9082489013671875, 0, 0, 0.0703125],
    [0, 2.4, 0.5557403564453125, 0.91876220703125, 0, 0, 0],
    []
];

var tempObjectData = {
    fillZoneCheck: new Array(),
    fillZoneRes: new Array()
};
//////////////////////FIELD OBJECT////////////////////////
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var GameObject = (function () {
    function GameObject() {
        this.sprite = null;
        this.isDestroyed = false;
        this.isWaitingForDestruction = false;
        this.isLocked = false;
        this.stage = App.game.stage;
        this.level = Match3Level.instance;
    }
    GameObject.prototype.canBeVisible = function (s) {
        return true;
    };

    GameObject.prototype.update = function (dt) {
    };

    GameObject.prototype.destroy = function () {
        removeClip(this.sprite);
        this.sprite = null;
        this.isDestroyed = true;
    };
    return GameObject;
})();

//////////////////////POOL////////////////////////
var ObjectPool = (function () {
    function ObjectPool() {
        this.fieldObjects = new Array();
        this.destroyAnimations = [];
        this.scores = {};
        var amount = 90;
        for (var i = 0; i < 5; ++i) {
            if (i == 4)
                amount = 15;
            var v = [];
            for (var j = 0; j < amount; ++j) {
                v.push(new FieldObject(i));
            }
            if (i <= 3) {
                this.destroyAnimations.push([]);
                for (var j = 0; j < amount; ++j)
                    this.destroyAnimations[i].push(new GemDestroyAnimation(i));
            }
            this.fieldObjects.push(v);
        }

        for (var i = 3; i < 20; ++i) {
            var t1 = this.getText((i * CellObject.BASE_SCORE).toString(), null, 0, 0, 0);
            var t2 = this.getText((i * CellObject.BASE_SCORE).toString(), null, 0, 0, 0);
            this.returnText(t1);
            this.returnText(t2);
        }
    }
    ObjectPool.prototype.getText = function (s, c, type, x, y) {
        if (typeof x === "undefined") { x = -1; }
        if (typeof y === "undefined") { y = -1; }
        var a = this.scores[s];
        if (!a) {
            a = [];
            this.scores[s] = a;
        }
        var text = a.length > 0 ? a.splice(0, 1)[0] : new JumpText(s, type);
        text.init(x > 0 || !c ? x : c.pos.x, y > 0 || !c ? y : c.pos.y, c);
        return text;
    };

    ObjectPool.prototype.returnText = function (text) {
        var s = text.text;
        var a = this.scores[s];
        if (!a) {
            a = [];
            this.scores[s] = a;
        }
        text.release();
        a.push(text);
    };

    ObjectPool.prototype.getObject = function (c, posX, posY, max, exact) {
        if (typeof exact === "undefined") { exact = -1; }
        if (exact > Match3Level.instance.assetNumber)
            exact = -1;
        while (true) {
            var t = exact >= 0 ? exact : getInt(Math.min(max, this.fieldObjects.length));
            if (this.fieldObjects[t].length > 0) {
                var f = this.fieldObjects[t].splice(0, 1)[0];
                return f.init(c, posX, posY);
            }
            exact = -1;
        }

        return null;
    };

    ObjectPool.prototype.returnObject = function (f) {
        f.release();
        this.fieldObjects[f.colorType].push(f);
    };

    ObjectPool.prototype.getDestroyAnimation = function (color, x, y, cell) {
        var g = this.destroyAnimations[color].splice(0, 1)[0];
        g.init(x, y, cell);
        return g;
    };

    ObjectPool.prototype.returnGemDestroy = function (g) {
        this.destroyAnimations[g.color].push(g);
        g.release();
    };
    return ObjectPool;
})();

var TweenData = (function () {
    function TweenData() {
        this.initPos = new createjs.Point();
        this.endPos = new createjs.Point();
        this.currentTime = 0;
        this.totalTime = 0;
        this.corner = false;
    }
    TweenData.prototype.init = function (x1, y1, x2, y2, t, c) {
        this.initPos.x = x1;
        this.initPos.y = y1;
        this.endPos.x = x2;
        this.endPos.y = y2;
        this.totalTime = t;
        this.currentTime = 0;
        this.corner = c;
    };

    TweenData.prototype.update = function (dt, f) {
        this.currentTime += dt;
        var end = false;
        if (this.currentTime >= this.totalTime) {
            this.currentTime = this.totalTime;
            end = true;
        }
        var p = this.currentTime / this.totalTime;
        if (!this.corner)
            p *= p * p;
        f.pos.x = this.initPos.x + (this.endPos.x - this.initPos.x) * p;
        f.pos.y = this.initPos.y + (this.endPos.y - this.initPos.y) * p;
        if (end)
            f.stopMove();
    };
    return TweenData;
})();

var AnimationObject = (function (_super) {
    __extends(AnimationObject, _super);
    function AnimationObject(frames, s) {
        if (typeof s === "undefined") { s = null; }
        _super.call(this);
        this.frameTime = 1 / 30;
        this.animPos = new createjs.Point(0, 0);
        this.currentFrame = 0;
        this.isPlaying = false;
        this.animationPower = 1;
        this.animationSpeed = 1;
        this.stopSpeed = 0;
        this.resetFrame = -1;
        this.resetStopFrame = false;
        this.destroyOnReset = false;
        this.playAnimationIn = -1;
        this.animationToPlay = 0;
        this.handlePos = false;
        this.initSpritePos = cjp(0, 0);
        this.stopFrame = -1;

        if (s) {
            this.sprite = s;
            this.initSpritePos = cjp(s.x, s.y);
        }

        this.animationFrames = frames;
        this.animationLen = frames.length;
    }
    AnimationObject.prototype.initAnim = function () {
        this.animPos.x = this.animPos.y = 0;
        this.animationPower = 1;
        this.animationSpeed = 1;
    };

    AnimationObject.prototype.setFrame = function (n, apply) {
        if (typeof apply === "undefined") { apply = true; }
        var len = this.animationLen;
        var a = n < 0 || n >= len ? null : this.animationFrames[n];
        var a2 = n + 1 < 0 || n + 1 >= len ? null : this.animationFrames[n + 1];
        var aLen = a == null ? 0 : a.length;
        var a2Len = a2 == null ? 0 : a2.length;
        var reset = a == null || aLen <= 0;
        var inter = !reset && a2 != null && a2Len > 0;
        var ratio = this.currentFrame - n;
        var f = this.animationPower;
        if (reset) {
            if (this.resetFrame > 0) {
                this.setFrame(this.resetFrame);
                this.isPlaying = false;
                return;
            } else if (this.resetStopFrame) {
                this.setFrame(n - 1);
                this.isPlaying = false;
                return;
            } else if (this.destroyOnReset) {
                this.destroy();
                return;
            }

            this.animPos.x = 0;
            this.animPos.y = 0;
            this.sprite.scaleX = 1;
            this.sprite.scaleY = 1;
            this.sprite.skewX = 0;
            this.sprite.skewY = 0;
            this.sprite.alpha = 1;
        } else if (apply) {
            var notInter = !inter;
            this.animPos.x = Match3Level.TILE_SIZE_FACTOR * (notInter ? a[0] * f : f * (a[0] + ratio * (a2[0] - a[0])));
            this.animPos.y = Match3Level.TILE_SIZE_FACTOR * (notInter ? a[1] * f : f * (a[1] + ratio * (a2[1] - a[1])));
            this.sprite.scaleX = (notInter ? (1 + (a[2] - 1) * f) : (1 + ((a[2] + ratio * (a2[2] - a[2])) - 1) * f));
            this.sprite.scaleY = (notInter ? (1 + (a[3] - 1) * f) : (1 + ((a[3] + ratio * (a2[3] - a[3])) - 1) * f));
            this.sprite.skewX = notInter ? a[4] * f : f * (a[4] + ratio * (a2[4] - a[4]));
            this.sprite.skewY = notInter ? a[5] * f : f * (a[5] + ratio * (a2[5] - a[5]));

            if (aLen >= 7 && a2Len >= 7)
                this.sprite.alpha = (notInter ? (1 + (a[6] - 1) * f) : (1 + ((a[6] + ratio * (a2[6] - a[6])) - 1) * f));
            //this.sprite.skewX *= 1;
            //this.sprite.skewY *= 1;
        }

        //this.sprite.scaleX = this.sprite.scaleY = 5;
        if (reset) {
            this.isPlaying = false;
            this.currentFrame = 0;
        }
    };

    AnimationObject.prototype.playAnimation = function (n, power, speed) {
        if (typeof power === "undefined") { power = 1; }
        if (typeof speed === "undefined") { speed = 1; }
        this.animationPower = power;
        this.animationSpeed = speed;
        this.currentFrame = n;
        this.isPlaying = true;
        this.setFrame(n);
    };

    AnimationObject.prototype.prepareToPlayAnimation = function (delay, anim) {
        this.playAnimationIn = delay;
        this.animationToPlay = anim;
    };

    AnimationObject.prototype.update = function (dt) {
        if (this.isDestroyed)
            return;

        if (this.sprite) {
            if (this.isPlaying) {
                var t = dt * this.animationSpeed;
                while (t > 0 && (this.stopFrame < 0 || (~~this.currentFrame) != this.stopFrame) && this.isPlaying) {
                    this.currentFrame += (t >= this.frameTime ? 1 : t / this.frameTime);
                    t -= this.frameTime;
                    this.setFrame((~~this.currentFrame), t <= this.frameTime);
                }
            }

            if (this.isDestroyed)
                return;

            if (this.playAnimationIn > 0) {
                this.playAnimationIn -= dt;
                if (this.playAnimationIn <= 0) {
                    this.sprite.visible = true;
                    this.playAnimation(this.animationToPlay, 1, 1);
                }
            }
        }

        if (this.handlePos) {
            this.sprite.x = this.initSpritePos.x + this.animPos.x;
            this.sprite.y = this.initSpritePos.y + this.animPos.y;
        }
    };
    return AnimationObject;
})(GameObject);
/// <reference path="../src/GameObject.ts" />
var FieldBonusType;
(function (FieldBonusType) {
    FieldBonusType[FieldBonusType["kBonusNone"] = 0] = "kBonusNone";
    FieldBonusType[FieldBonusType["kHorizontalLize"] = 1] = "kHorizontalLize";
    FieldBonusType[FieldBonusType["kVerticalLine"] = 2] = "kVerticalLine";
    FieldBonusType[FieldBonusType["kBombBonus"] = 3] = "kBombBonus";
    FieldBonusType[FieldBonusType["kColorBonus"] = 4] = "kColorBonus";
    FieldBonusType[FieldBonusType["kCrossBonus"] = 5] = "kCrossBonus";
    FieldBonusType[FieldBonusType["kThickCrossBonus"] = 6] = "kThickCrossBonus";
    FieldBonusType[FieldBonusType["kLargeBombBonus"] = 7] = "kLargeBombBonus";
    FieldBonusType[FieldBonusType["kColorLineBonus"] = 8] = "kColorLineBonus";
    FieldBonusType[FieldBonusType["kColorBombBonus"] = 9] = "kColorBombBonus";
    FieldBonusType[FieldBonusType["kColorColorBonus"] = 10] = "kColorColorBonus";
})(FieldBonusType || (FieldBonusType = {}));

var FieldObject = (function (_super) {
    __extends(FieldObject, _super);
    function FieldObject(colorType) {
        _super.call(this, jellyAnimation);
        this.isMoving = true;
        this.SPEED = 200;
        this.lastTarget = new createjs.Point(0, 0);
        this.currentTile = 6;
        this.bonusType = 0 /* kBonusNone */;
        this.isActive = false;
        this.isCustom = false;
        this.moveCornerCount = 0;
        this.timeSinceStop = 0;
        this.isMovedAfterCorner = false;
        this.rowMoveAfterConterCount = 0;
        this.nextIdleTime = 0;
        this.timeSinceAnim = 0;
        this.isCached = false;
        this.playBonusAnimationIn = -1;
        this.isHighValue = false;
        this.highValueIn = -1;
        this.pos = new createjs.Point(0, 0);
        this.tween = new TweenData();
        this.prevNeighbours = [null, null, null, null];

        this.colorType = colorType;
        this.sprite = createSpriteFromSpritesheet(this.getFileName());
        this.sprite.gotoAndStop(this.getFileName());

        //this.sprite = new createjs.Bitmap(App.game.testCanvas);// new createjs.Bitmap(<HTMLImageElement> App.game.loader.getResult("tilex"));//TilePool.getInstance().tiles["tiles" + (colorType + 1) + "-1-0"].cacheCanvas);
        // this.sprite.scaleX = this.sprite.scaleY = App.level.tileSize / (1 * FieldObject.TILE_SIZE);
        //this.sprite.scaleX = this.sprite.scaleY = 0.96;
        var bounds = this.sprite.getBounds();
        this.sprite.regX = bounds.width / 2;
        this.sprite.regY = bounds.height / 2;

        this.stopFrame = 9;
    }
    FieldObject.prototype.setNextIdleTime = function () {
        this.nextIdleTime = 1 + Math.random() * 78;
        this.timeSinceAnim = 0;
    };

    FieldObject.prototype.getFileName = function () {
        if (this.isPushable)
            return "cupcake";

        if (this.bonusType == 4 /* kColorBonus */)
            return "bonus color";

        var name = FieldObject.assetNames[this.colorType] + FieldObject.bonusNames[this.bonusType];
        if (!this.isBonus && this.isHighValue)
            name += " bonus";
        return name;
    };

    FieldObject.prototype.setHighValue = function () {
        if (this.isBonus)
            return;

        this.isHighValue = true;
        this.sprite.gotoAndStop(this.getFileName());
        this.playJellyAnimation(1, 1);
    };

    FieldObject.prototype.setHighValueIn = function (n) {
        this.highValueIn = n;
    };

    Object.defineProperty(FieldObject.prototype, "isPushable", {
        get: function () {
            return this.colorType == 4;
        },
        enumerable: true,
        configurable: true
    });

    FieldObject.prototype.init = function (c, posX, posY) {
        _super.prototype.initAnim.call(this);
        this.cell = c;
        c.object = this;
        this.isHighValue = false;
        createjs.Tween.removeTweens(this.pos);
        createjs.Tween.removeTweens(this.sprite);
        this.level = Match3Level.instance;
        addChild(this.sprite, this.level.gemLayer);
        this.pos.x = posX;
        this.pos.y = posY;
        this.sprite.x = posX;
        this.sprite.y = posY;
        this.isMoving = false;
        this.isWaitingForDestruction = false;
        this.isPlaying = false;
        this.currentFrame = 0;
        this.isMoving = false;
        this.sprite.visible = true;
        this.stopSpeed = 1;
        this.setNextIdleTime();
        this.isCached = false;
        this.playBonusAnimationIn = -1;
        this.bonusType = 0 /* kBonusNone */;
        this.sprite.gotoAndStop(this.getFileName());
        this.setFrame(-1, true);
        var bounds = this.sprite.getBounds();
        this.sprite.regX = bounds.width / 2;
        this.sprite.regY = bounds.height / 2;
        this.highValueIn = -1;
        if (!this.isActive) {
            FieldObject.activeCount++;
            this.isActive = true;
        }
        return this;
    };

    FieldObject.prototype.release = function () {
        removeClip(this.sprite);
        this.sprite.visible = false;
        this.highValueIn = -1;
        createjs.Tween.removeTweens(this.pos);
        createjs.Tween.removeTweens(this.sprite);
        this.isMoving = false;
        this.isWaitingForDestruction = false;
        this.animPos.x = this.animPos.y = 0;
        this.setFrame(-1);
        this.isHighValue = false;
        this.isPlaying = false;
        this.currentFrame = 0;
        this.playBonusAnimationIn = -1;
        this.isMoving = false;
        this.animationPower = 1;
        this.stopSpeed = 1;
        this.animationSpeed = 1;
        this.isCached = false;
        this.bonusType = 0 /* kBonusNone */;
        if (this.isActive) {
            FieldObject.activeCount--;
            this.isActive = false;
        }
        return this;
    };

    Object.defineProperty(FieldObject.prototype, "isBonus", {
        get: function () {
            return this.bonusType != 0 /* kBonusNone */;
        },
        enumerable: true,
        configurable: true
    });

    FieldObject.prototype.setBonusType = function (b) {
        if (this.bonusType != b) {
            this.isHighValue = false;
            this.bonusType = b;
            var frameIndex = b == 4 /* kColorBonus */ ? 4 : b == 3 /* kBombBonus */ ? 5 : b == 1 /* kHorizontalLize */ ? 2 : 3;
            this.sprite.gotoAndStop(this.getFileName());
            var bounds = this.sprite.getBounds();
            this.sprite.regX = bounds.width / 2;
            this.sprite.regY = bounds.height / 2;
            this.playJellyAnimation(1, 1);
        }
    };

    FieldObject.prototype.onSpellExplosion = function (delay) {
        if (typeof delay === "undefined") { delay = -1; }
        this.sprite.visible = false;
    };

    FieldObject.prototype.isSwapable = function () {
        return true;
    };

    FieldObject.prototype.moveTo = function (x, y, fast, delay, corner) {
        if (typeof fast === "undefined") { fast = false; }
        if (typeof delay === "undefined") { delay = 0; }
        if (typeof corner === "undefined") { corner = false; }
        this.isMoving = true;

        var coef = fast ? 0.5 : 1;
        this.lastTarget.x = x;
        this.lastTarget.y = y;

        this.timeSinceStop = 0;

        if (!corner && this.isMovedAfterCorner) {
            this.rowMoveAfterConterCount++;
            if (this.rowMoveAfterConterCount > 1) {
                this.rowMoveAfterConterCount = 0;
                this.isMovedAfterCorner = false;
            }
        } else
            this.rowMoveAfterConterCount = 0;

        // = (corner || this.isMovedAfterCorner) ? (this.moveCornerCount + 1) : 0;
        this.isMovedAfterCorner = false;
        var time = 300 * Math.pow(0.6, limit(this.moveCornerCount, 0, 4));
        this.moveCornerCount++;
        var distance = distanceBetweenPoints(x, y, this.pos.x, this.pos.y);
        if (distance < 1)
            time = 10;

        if (corner) {
            //console.log(corner, this.moveCornerCount, time);
            var posX = this.level.stageToGridX(this.sprite.x);
            var posY = this.level.stageToGridY(this.sprite.y);
            posX = Math.floor(posX);
            posY = Math.floor(posY);
            for (var ny = posY - 1; ny >= 0; --ny)
                if (this.validatePos(posX, ny)) {
                    var c = this.level.cells[posX][ny];
                    if (c && c.object && !c.object.isMoving)
                        c.object.isMovedAfterCorner = true;
                }
        }

        this.tween.init(this.pos.x, this.pos.y, x, y, time / 1000, corner);

        //createjs.Tween.get(this.pos, { loop: false }).to({ x: x, y: y }, time, corner ? createjs.Ease.none : createjs.Ease.cubicIn).call(() => this.stopMove());
        if (!this.isPushable && distance > 10) {
            this.stopSpeed = 0.7 + Math.random() * 0.3; //distance < 50 ? 0.1 : distance > 700 ? 1 : (0.1 + (distance - 50) / (700 - 50) * 0.9);
            this.playAnimation(0, 0.6);
        }
    };

    FieldObject.prototype.setPos = function (x, y) {
        this.pos.x = x;
        this.pos.y = y;
    };

    FieldObject.prototype.setFrame = function (n, apply) {
        if (typeof apply === "undefined") { apply = true; }
        _super.prototype.setFrame.call(this, n, apply);

        if (n == 110 && this.teleportTarget) {
            var prevCell = this.cell.teleportCellStart;
            this.cell.teleportSprite.gotoAndPlay("teleport_out");
            SoundsManager.instance.playTeleport(); // playSound("teleport" + (getInt(3) + 1));
            this.setPos(this.cell.pos.x, this.cell.pos.y);
            var needMove = this.teleportTarget != this.cell;
            prevCell.object = this.cell.object = null;
            this.isMoving = false;

            if (needMove) {
                this.moveTo(this.teleportTarget.pos.x, this.teleportTarget.pos.y, false, 0.05);
            } else {
                //this.playAnimation(111, 1, 1);
                //console.log("");
                this.playJellyAnimation(this.stopSpeed, 0.75 + Math.random() * 0.5);
            }
            this.teleportTarget.setObject(this);
            this.teleportTarget = null;
        }
    };

    FieldObject.prototype.playJellyAnimation = function (p, s) {
        var i = getInt(3);
        this.playAnimation(i == 0 ? 11 : i == 1 ? 39 : 67, p, s);
    };

    FieldObject.prototype.stopMove = function () {
        var _this = this;
        if (this.teleportTarget == null)
            this.isMoving = false;
        this.timeSinceStop = 0;

        if (!this.isPushable && this.isPlaying) {
            this.playJellyAnimation(this.stopSpeed, 0.75 + Math.random() * 0.5);
        }

        if (this.isPushable && this.cell.y == this.level.fieldHeight - 1) {
            this.level.objects.push(Match3Level.pool.getText("100", this.cell, 0));
            var posX = this.level.gridToStageX(this.cell.x);
            var posY = this.level.gridToStageY(this.level.fieldHeight);
            createjs.Tween.get(this.pos, { loop: false }).wait(0).to({ x: posX, y: posY }, 300, createjs.Ease.cubicIn).call(function () {
                return _this.pushDown();
            });
            SoundsManager.instance.playSound("cake_down");
        } else
            SoundsManager.instance.playSound("stop_move");
    };

    FieldObject.prototype.pushDown = function () {
        this.cell.object = null;
        (this.level.target).onTargetPush();
        Match3Level.pool.returnObject(this);
    };

    FieldObject.prototype.update = function (dt) {
        //this.sprite.visible = false;
        if (!this.isMoving) {
            this.timeSinceStop += dt;
            if (this.timeSinceStop >= 0.5)
                this.moveCornerCount = 0;
        }

        this.isMoving = this.isMoving || this.teleportTarget != null;

        if (this.sprite) {
            if (this.isPlaying)
                _super.prototype.update.call(this, dt);
            else {
                this.timeSinceAnim += dt;
                if (this.timeSinceAnim >= this.nextIdleTime) {
                    //this.playJellyAnimation(0.2 + Math.random() * 0.2, 0.25 + Math.random() * 0.25);
                    this.setNextIdleTime();
                }
            }

            if (this.isMoving && this.teleportTarget == null)
                this.tween.update(dt, this);

            if (this.playBonusAnimationIn >= 0) {
                this.playBonusAnimationIn -= dt;
                if (this.isBonus && this.playBonusAnimationIn < 0) {
                    this.playBonusAnimation();
                }
            }

            if (this.highValueIn >= 0) {
                this.highValueIn -= dt;
                if (this.highValueIn < 0)
                    this.setHighValue();
            }

            this.sprite.x = this.pos.x + this.animPos.x;
            this.sprite.y = this.pos.y + this.animPos.y;
        }
    };

    FieldObject.prototype.playBonusAnimation = function () {
        if (this.bonusType == 4 /* kColorBonus */)
            this.level.objects.push(new SinglePlayObject(this.sprite.x, this.sprite.y, "color bonus", 37, this.level.gemDestroyLayer, 67, 61, ANIM_SCALE));
        else {
            this.level.objects.push(new BonusDestroyAnimation(this.sprite.x, this.sprite.y, this.getFileName(), this.cell));
        }
        this.sprite.visible = false;
    };

    FieldObject.prototype.validatePos = function (x, y) {
        return x >= 0 && y >= 0 && x < App.level.fieldWidth && y < App.level.fieldHeight;
    };

    FieldObject.prototype.getNeighbourObject = function (dx, dy, id) {
        var tx = this.cell.x + dx;
        var ty = this.cell.y + dy;

        if (tx < 0 || tx >= App.level.fieldWidth)
            return null;

        if (!this.isMoving) {
            if (!this.validatePos(tx, ty))
                return null;
            f = App.level.cells[tx][ty].object;
            if (f && !f.isMoving && f.colorType == this.colorType)
                return f;
            else
                return null;
        } else {
            for (var y = -1; y < App.level.fieldHeight; y++) {
                if (y != -1 && !this.validatePos(tx, y))
                    continue;

                var f = y == -1 ? this.prevNeighbours[id] : App.level.cells[tx][y].object;
                if (f && !f.isDestroyed && f.colorType == this.colorType) {
                    var checkX = Math.abs(f.sprite.x - (this.sprite.x + dx * App.level.tileSize)) < 0.5;
                    var checkY = Math.abs(f.sprite.y - (this.sprite.y + dy * App.level.tileSize)) < 0.5;
                    if (checkX && checkY) {
                        //if (this.cell.x == 3 && this.cell.y == 5)
                        //console.log(Math.random(), y, this.prevNeighbours[id] ? this.prevNeighbours[id].cell.x : -1, this.prevNeighbours[id] ? this.prevNeighbours[id].cell.y : -1, f.cell.x, f.cell.y);
                        return f;
                    }
                }
            }
        }

        return null;
    };
    FieldObject.TILE_SIZE = 35;

    FieldObject.destroyCount = 0;
    FieldObject.GEM_SCALE = 1;
    FieldObject.GEM_KILL_DELAY = 0.07;
    FieldObject.assetNames = ["blue", "green", "purple", "orange"];
    FieldObject.bonusNames = ["", " horizontal", " vertical", " bomb", " bomb"];
    FieldObject.activeCount = 0;
    return FieldObject;
})(AnimationObject);
var Match3Level = (function (_super) {
    __extends(Match3Level, _super);
    function Match3Level() {
        _super.call(this);
        this.isPaused = false;
        this.currentMove = 0;
        this.isGenerated = false;
        this.isLocked = false;
        this._isHardLocked = false;
        this.isEnded = false;
        this.score = 0;
        this.pushPositions = [];
        this.objects = [];
        this.customMatches = new Array();
        this.comboAmount = 0;
        this.maxCombo = 0;
        this.comboTimer = Match3Level.COMBO_TIME;
        this.turnedOff = false;
        this.isSelectBlocked = false;
        this.fieldCount = 5;
        this.fpsText = null;
        this.timeSinceLastAction = 0;
        this.timeSinceLastComboRemove = 0;
        this.movesLeft = 0;
        this.showWinMenuIn = -1;
        this.playLoseIn = 1.3;
        this.isStuck = false;
        this.cellData = null;
        this.needToUpdateGemCache = false;
        this.cachedSprites = {};
        this.showTargetIn = -1;
        this.needToUpdateBack = true;
        this.waterRemoveMove = 0;
        this.backLayer = new createjs.Container();
        this.markLayer = new createjs.Container();
        this.underGemLayer = new createjs.Container();
        this.gemLayer = new createjs.Container();
        this.blockLayer = new createjs.Container();
        this.gemDestroyLayer = new createjs.Container();
        this.blockDestroyLayer = new createjs.Container();
        this.bonusLayer = new createjs.Container();
        this.bonusIndicatorLayer = new createjs.Container();
        this.hudLayer = new createjs.Container();
        this.isUpdatingAfterMatch = false;
        Match3Level.instance = this;

        var names = [
            "blue bomb", "blue horizontal", "blue vertical", "blue", "green bomb", "green horizontal",
            "green vertical", "green", "orange bomb", "orange horizontal", "orange vertical", "orange", "purple bomb", "purple horizontal",
            "purple vertical", "purple"];
        for (var i = 0; i < names.length; ++i) {
            var s = createSpriteFromSpritesheet(names[i]);
            var b = s.getBounds();
            s.cache(b.x, b.y, b.width, b.height);
            this.cachedSprites[names[i]] = s;
        }

        this.addChild(this.backLayer);
        this.addChild(this.markLayer);
        this.addChild(this.underGemLayer);
        this.addChild(this.gemLayer);
        this.addChild(this.blockLayer);
        this.addChild(this.gemDestroyLayer);
        this.addChild(this.blockDestroyLayer);
        this.addChild(this.bonusLayer);
        this.addChild(this.bonusIndicatorLayer);
        this.addChild(this.hudLayer);

        this.setFieldProps(Match3Level.TILE_SIZE, 26, 104, Match3Level.LEVEL_W, Match3Level.LEVEL_H);

        this.cells = new Array();
        for (var i = 0; i < this.fieldWidth; i++) {
            var v = new Array();
            for (var j = 0; j < this.fieldHeight; j++) {
                var c = new CellObject(i, j);
                v.push(c);
            }
            this.cells.push(v);
        }

        var back = createBitmap("back");
        back.x = -1;
        back.y = -1 + 80 + App.SHIFT_H;
        this.back = back;
        this.backLayer.addChildAt(this.back, 0);

        App.level = this;

        var t = new createjs.Text("20fps", "30px Arial Black", "#000000");
        t.x = 0;
        t.alpha = 0.3;
        t.y = App.SCREEN_H + App.SHIFT_H - 20;
        addChild(t, this.hudLayer);
        this.fpsText = t;

        this.hud = new Hud();
    }
    Match3Level.prototype.pause = function () {
        if (this.isPaused || this.isEnded)
            return;

        var b = this.getBounds();
        this.cache(0, 0, App.SCREEN_W, App.FULL_SCREEN_H);
        this.isPaused = true;
        MenuManager.instance.show(MenuManager.instance.pause, false);
    };

    Match3Level.prototype.unpause = function () {
        this.isPaused = false;
        this.uncache();
        if (MenuManager.instance.current == MenuManager.instance.pause)
            MenuManager.instance.closeCurrent();
    };

    Object.defineProperty(Match3Level.prototype, "isActive", {
        get: function () {
            return this.parent != null;
        },
        enumerable: true,
        configurable: true
    });

    Match3Level.prototype.init = function (i) {
        this.reset();
        this.showTargetIn = 0.3;
        this.timeSinceLastComboRemove = 10;

        CellObject.waterCells = [];
        this.waterRemoveMove = 0;

        removeClip(this.fpsText);
        this.isUpdatingAfterMatch = false;

        this.showWinMenuIn = -1;
        this.uncache();
        SoundsManager.instance.reset();

        //if (!data)
        //data = null;// "=000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000-0-1-1";
        App.game.stage.addChild(this);
        this.isEnded = false;

        var targetData = 0;
        var customData = 0;
        var customData2 = 0;

        targetData = -1; //temp
        customData = 0; //temp
        customData2 = 0; //temp
        this.movesLeft = 99; //temp
        var stars = [500, 1500, 3000];

        var customStringData = null;
        var url = window.location.href;
        if (url.indexOf("lvl") != -1) {
            url = url.split("lvl")[1];
            customStringData = url;
        }
        var levelData = customStringData ? new LevelData(i, customStringData) : LevelManager.instance.data[i];
        this.levelData = levelData;
        this.cellData = levelData.cellData;
        targetData = levelData.targetData;
        customData = levelData.customData;
        customData2 = levelData.customData2;
        this.movesLeft = levelData.movesLeft;
        stars = levelData.starValues;

        switch (targetData) {
            case 0:
                this.target = new BlockClearTarget();
                break;
            case 1:
                this.target = new ClearMarkTarget();
                break;
            case 2:
                this.target = new PushDownTarget(customData);
                break;
            case 3:
                this.target = new ColorTarget(customData, customData2);
                break;
            case 4:
                this.target = new ScoreTarget(customData);
                break;
            case 5:
                this.target = new WaterClearTarget();
                break;
            case 6:
                this.target = new BushClearTarget();
                break;
            case -1:
                this.target = new InfiniteTarget();
                break;
        }
        this.target.scores = stars;

        this.score = 0;
        this.generate();
        this.needToUpdateGemCache = true;

        this.hud.show();
        this.needToUpdateBack = true;

        this.update(0);
    };

    Match3Level.prototype.starMoveAwardMode = function () {
        if (this.isEnded || this.isHardLocked)
            return;

        this.isEnded = true;

        //if (this.movesLeft <= 0) {
        //    this.showWinMenuIn = 1.5;
        //    return;
        //}
        var bonusable = [];
        for (var x = 0; x < this.fieldWidth; ++x) {
            for (var y = 0; y < this.fieldHeight; ++y) {
                var c = this.cells[x][y];
                if (c && c.object && !c.object.isMoving && !c.object.isBonus && !c.object.isPushable) {
                    bonusable.push(c);
                }
            }
        }

        this.objects.push(Match3Level.pool.getText('amazing!', null, 3, App.SCREEN_W / 2, App.SHIFT_H + 400));

        var spawnX = this.hud.movesText.x;
        var spawnY = this.hud.movesText.y - 20;
        var hasMovesLeft = this.movesLeft > 0;

        var bonused = [];
        var bonuses = [];
        var delays = [];

        for (var x = 0; x < this.fieldWidth; ++x)
            for (var y = 0; y < this.fieldHeight; ++y) {
                var c = this.cells[x][y];
                if (c && c.object && c.object.isBonus) {
                    bonused.push(c);
                    bonuses.push(c.getBonusType());
                    delays.push(!hasMovesLeft ? 0 : 0.5);
                }
            }

        var len = bonusable.length;
        var i = 0;
        var maxTime = -1;
        var movesLeft = this.movesLeft;

        while (movesLeft > 0) {
            if (len <= 0) {
                this.objects.push(Match3Level.pool.getText("100", null, 0, spawnX, spawnY));
                this.movesLeft--;
            } else {
                c = bonusable.splice(getInt(len), 1)[0];
                var delay = 0.6 + i * 0.065;
                var bonusType = 1 + getInt(3);
                bonuses.push(bonusType);
                var indicator = new EndBonusIndicator(spawnX, spawnY, c, delay, bonusType);
                this.objects.push(indicator);
                bonused.push(c);
                maxTime = Math.max(maxTime, indicator.totalTime);
                delays.push(indicator.totalTime);

                ++i;
            }
            --len;
            movesLeft--;
        }

        var cleared = [];
        maxTime += 0.2;
        var maxDelay = -1;
        len = bonused.length;
        for (var i = 0; i < len; ++i) {
            c = bonused[i];
            var m = this.getBonusGroup(c, bonuses[i]);

            //if (m.indexOf(c) == -1)
            //    m.push(c);
            delay = delays[i];
            var len2 = m.length;
            for (var j = 0; j < len2; ++j) {
                var cx = m[j];
                var distance = this.getDistance(c, cx, false);
                var totalDelay = (!hasMovesLeft ? 1 : 1.5) + delay + distance * FieldObject.GEM_KILL_DELAY + BonusDestroyAnimation.TIME;
                maxDelay = Math.max(totalDelay, maxDelay);
                if (cx == c || bonused.indexOf(cx) == -1)
                    cx.prepareToClear(totalDelay, bonuses[i], -1, cx == c);
                cleared.push(cx);
            }
            c.scoreToAdd = this.getBonusScore(bonuses[i], 0);
        }

        len = cleared.length;
        maxDelay += FieldObject.GEM_KILL_DELAY;
        for (i = 0; i < len; ++i)
            cleared[i].setTempBlock(true, maxDelay);

        this.showWinMenuIn = 1.6;
    };

    Match3Level.prototype.getStarAmount = function () {
        var res = 0;
        for (var i = 1; i <= 3; ++i) {
            var s = this.target.scores[i - 1];
            if (this.score >= s)
                res = i;
        }
        return res;
    };

    Match3Level.prototype.destroyObjects = function () {
        var len = this.objects.length;
        for (var i = 0; i < len; ++i)
            this.objects[i].destroy();
        this.objects = [];
    };

    Match3Level.prototype.onWin = function () {
        if (this.isEnded)
            return;

        this.hud.logo.setVisible(false);

        this.isEnded = true;
        this.destroyObjects();

        var b = this.getBounds();
        this.cache(0, 0, App.SCREEN_W, App.FULL_SCREEN_H); // b.x, b.y, b.width, b.height);

        var len = this.objects.length;
        for (var i = 0; i < len; ++i) {
            var o = this.objects[i];
            if (o && o.isDestroyed && o instanceof JumpText) {
                var j = o;
                j.finishMovement();
                j.destroy();
            }
        }

        var stars = this.getStarAmount();

        //MenuManager.instance.show(MenuManager.instance.winMenu, false);
        this.hud.forceFullUpdate();
        LevelManager.instance.onLevelComplete(stars, this.score);
        var menu = this.levelData.levelNumber == LevelManager.LEVEL_AMOUNT - 1 ? MenuManager.instance.result : MenuManager.instance.winMenu;
        MenuManager.instance.show(menu, false);
    };

    Match3Level.prototype.onLose = function () {
        if (this.isEnded)
            return;

        this.hud.logo.setVisible(false);

        this.isEnded = true;
        this.destroyObjects();

        var b = this.getBounds();
        this.cache(0, 0, App.SCREEN_W, App.FULL_SCREEN_H); // b.x, b.y, b.width, b.height);

        MenuManager.instance.show(MenuManager.instance.loseMenu, false);
    };

    Match3Level.prototype.trySpawnBonus = function (m) {
        if (m == null)
            return;

        var n = m.length;
        if (n < Match3Level.MIN_LINE_SIZE)
            return;

        var i = 0;
        var j = 0;
        var x = 0;
        var y = 0;
        var c = null;

        var m2 = [];
        for (i = 0; i < n; ++i)
            m2.push(m[i]);
        m = m2;

        while (true) {
            n = m.length;
            if (n < Match3Level.MIN_LINE_SIZE)
                return;

            var hCheck = [];
            for (i = 0; i < n; ++i)
                hCheck[i] = false;

            var vCheck = [];
            for (i = 0; i < n; ++i)
                vCheck[i] = false;

            var groups = [];
            var points = [];
            var currentLen = 0;
            var currentGroup = [];

            for (i = 0; i < n; ++i) {
                var type = m[i].getType();

                if (type < 0)
                    continue;

                x = m[i].x;
                y = m[i].y;

                //line h
                j = currentLen = 0;
                currentGroup = [];
                if (!hCheck[i] && !(x - 1 >= 0 && this.cells[x - 1][y].getType() == type)) {
                    while (true) {
                        c = x + j < this.fieldWidth ? this.cells[x + j][y] : null;
                        var index = m.indexOf(c);
                        if (c && c.getType() == type && index != -1) {
                            ++currentLen;
                            currentGroup.push(c);
                            hCheck[index] = true;
                        } else {
                            if (currentLen >= Match3Level.MIN_LINE_SIZE) {
                                groups.push(currentGroup);
                                points.push(currentLen);
                            }
                            break;
                        }
                        ++j;
                    }
                }

                //line v
                j = currentLen = 0;
                currentGroup = [];
                if (!vCheck[i] && !(y - 1 >= 0 && this.cells[x][y - 1].getType() == type)) {
                    while (true) {
                        c = y + j < this.fieldHeight ? this.cells[x][y + j] : null;
                        var index = m.indexOf(c);
                        if (c && c.getType() == type && index != -1) {
                            ++currentLen;
                            currentGroup.push(c);
                            vCheck[index] = true;
                        } else {
                            if (currentLen >= Match3Level.MIN_LINE_SIZE) {
                                groups.push(currentGroup);
                                points.push(currentLen);
                            }
                            break;
                        }
                        ++j;
                    }
                }
            }

            //update points
            var len = groups.length;
            for (i = 0; i < len; ++i) {
                currentGroup = groups[i];
                var cLen = currentGroup.length;
                for (j = 0; j < cLen; ++j) {
                    c = currentGroup[j];
                    for (var k = 0; k < len; k++) {
                        if (i != k) {
                            var checkGroup = groups[k];
                            index = checkGroup.indexOf(c);
                            if (index != -1) {
                                var totalLen = checkGroup.length;
                                var p1Len = index;
                                if (p1Len < Match3Level.MIN_LINE_SIZE)
                                    p1Len = 0;
                                var p2Len = totalLen - (index + 1);
                                if (p2Len < Match3Level.MIN_LINE_SIZE)
                                    p2Len = 0;
                                points[i] -= (totalLen - (p1Len + p2Len)) * 1.1;
                            }
                        }
                    }
                }
            }

            //find best
            var maxPoints = -1;
            var maxIndex = -1;
            for (i = 0; i < len; ++i) {
                var p = points[i];
                if (p > maxPoints || maxIndex == -1) {
                    maxPoints = p;
                    maxIndex = i;
                }
            }

            //remove best
            if (maxPoints != -1 && maxIndex != -1) {
                currentGroup = groups[maxIndex];
                cLen = currentGroup.length;
                for (i = 0; i < cLen; ++i) {
                    index = m.indexOf(currentGroup[i]);
                    m.splice(index, 1);
                }

                //spawn
                var bonusType = this.getBonusByMatch(cLen);
                var lastCellNumber = cLen <= 4 ? 3 : cLen <= 5 ? 4 : 5;
                this.spawnBonus(bonusType, currentGroup[0], currentGroup[lastCellNumber]);
            }

            //check exit
            if (len <= 1 || m.length < Match3Level.MIN_LINE_SIZE)
                break;
        }
    };

    Match3Level.prototype.getBonusByMatch = function (cLen) {
        return cLen >= 6 ? 4 /* kColorBonus */ : cLen <= 4 ? (Math.random() > 0.5 ? 1 /* kHorizontalLize */ : 2 /* kVerticalLine */) : 3 /* kBombBonus */;

        return 10 /* kColorColorBonus */;

        var r = Math.random();
        return r < 0.15 ? 1 /* kHorizontalLize */ : r < 0.3 ? 2 /* kVerticalLine */ : r < 0.7 ? 3 /* kBombBonus */ : 4 /* kColorBonus */;
    };

    Match3Level.prototype.combinateBonuses = function (m) {
        var bonusCells = [];
        var i = 0;
        var n = m.length;
        for (i = 0; i < n; ++i) {
            if (m[i].object && m[i].object.isBonus)
                bonusCells.push(m[i]);
        }
        if (bonusCells.length > 1) {
            bonusCells = bonusCells.sort(function (a, b) {
                return a.getBonusType() == b.getBonusType() ? 0 : a.getBonusType() > b.getBonusType() ? -1 : 1;
            });
            var c1 = bonusCells[0];
            var c2 = bonusCells[1];
            var b1 = c1.getBonusType();
            var b2 = c2.getBonusType();
            var l1 = b1 == 1 /* kHorizontalLize */ || b1 == 2 /* kVerticalLine */;
            var l2 = b2 == 1 /* kHorizontalLize */ || b2 == 2 /* kVerticalLine */;
            var tutorialCell = MenuManager.instance.isOnTutorial() ? Tutorial.instance.getBonusComboCell(c1, c2) : null;
            var rc = tutorialCell ? tutorialCell : Math.random() > 0.5 ? c1 : c2;
            if (l1 && l2) {
                c1.object.setBonusType(5 /* kCrossBonus */);
                c2.object.setBonusType(5 /* kCrossBonus */);
            } else if ((l1 || l2) && (b1 == 3 /* kBombBonus */ || b2 == 3 /* kBombBonus */)) {
                rc.object.setBonusType(6 /* kThickCrossBonus */);
            } else if (b1 == 3 /* kBombBonus */ && b2 == 3 /* kBombBonus */) {
                rc.object.setBonusType(7 /* kLargeBombBonus */);
            } else if ((l1 || l2) && (b1 == 4 /* kColorBonus */ || b2 == 4 /* kColorBonus */)) {
                rc.object.setBonusType(8 /* kColorLineBonus */);
            } else if ((b1 == 4 /* kColorBonus */ || b2 == 4 /* kColorBonus */) && (b1 == 3 /* kBombBonus */ || b2 == 3 /* kBombBonus */)) {
                rc.object.setBonusType(9 /* kColorBombBonus */);
            } else if ((b1 == 4 /* kColorBonus */ || b2 == 4 /* kColorBonus */) && (b1 == 4 /* kColorBonus */ || b2 == 4 /* kColorBonus */)) {
                rc.object.setBonusType(10 /* kColorColorBonus */);
            }
            this.objects.push(Match3Level.pool.getText("combo!", c1, 2, (c1.pos.x + c2.pos.x) / 2, (c1.pos.y + c2.pos.y) / 2));
        }
    };

    Match3Level.prototype.spawnBonus = function (bonusType, c1, c2, b) {
        if (typeof b === "undefined") { b = null; }
        var i;
        var x;
        var y;
        var c;

        var tutorialCell = MenuManager.instance.isOnTutorial() ? Tutorial.instance.getBonusSpawnCell() : null;
        for (i = 0; i < 80; ++i) {
            x = getInt(this.fieldWidth);
            y = getInt(this.fieldHeight);
            c = tutorialCell ? tutorialCell : this.cells[x][y];
            var isInCustom = false;
            if (c.object && !c._isBlock && !c.object.isBonus && !c.object.isWaitingForDestruction && !c.object.isMoving && !c.isWaitingForClear && !c.object.isPushable && !c.object.isHighValue) {
                for (var xm = 0; xm < this.customMatches.length; ++xm)
                    if (this.customMatches[xm].indexOf(c) != -1) {
                        isInCustom = true;
                        break;
                    }

                if (!isInCustom) {
                    if (b == null)
                        this.objects.push(new BonusIndicator(c1, c2, c, bonusType));
                    else
                        b.updateTarget(c);
                    return;
                }
            }
        }

        if (b)
            b.destroy();
    };

    Match3Level.prototype.getBonusGroup = function (c, forceBonus, match) {
        if (typeof forceBonus === "undefined") { forceBonus = 0 /* kBonusNone */; }
        if (typeof match === "undefined") { match = null; }
        var bonusType = forceBonus != 0 /* kBonusNone */ ? forceBonus : c.getBonusType();
        var m = [];
        switch (bonusType) {
            case 1 /* kHorizontalLize */:
                for (var x = 0; x < this.fieldWidth; ++x) {
                    var cx = this.cells[x][c.y];
                    if (cx.isStable() || cx.isBreakable)
                        m.push(cx);
                }
                break;
            case 2 /* kVerticalLine */:
                for (var y = 0; y < this.fieldHeight; ++y) {
                    var cy = this.cells[c.x][y];
                    if (cy.isStable() || cy.isBreakable)
                        m.push(cy);
                }
                break;
            case 3 /* kBombBonus */:
                for (x = -2; x <= 2; ++x) {
                    for (y = -2; y <= 2; ++y) {
                        var nx = c.x + x;
                        var ny = c.y + y;
                        if (nx >= 0 && ny >= 0 && ny < this.fieldHeight && nx < this.fieldWidth) {
                            var cn = this.cells[nx][ny];
                            if (cn.isStable() || cn.isBreakable)
                                m.push(cn);
                        }
                    }
                }
                break;
            case 4 /* kColorBonus */:
                var color = this.getMatchColor(c, match);
                var left = 200;
                var colored = [];
                for (x = 0; x < this.fieldWidth; ++x)
                    for (y = 0; y < this.fieldHeight; ++y) {
                        if (this.cells[x][y] && (this.cells[x][y].isStable() || this.cells[x][y].isBreakable) && this.cells[x][y].getType() == color && !this.cells[x][y].isWaterBlock)
                            colored.push(this.cells[x][y]);
                    }
                var attempts = 70;
                var colorLen = colored.length;
                while (attempts > 0 && left > 0 && colorLen > 0) {
                    var j = getInt(colorLen);
                    --colorLen;
                    cn = colored[j];
                    m.push(cn);
                    colored.splice(j, 1);
                    attempts--;
                    left--;
                }

                break;
            case 5 /* kCrossBonus */:
                for (x = 0; x < this.fieldWidth; ++x) {
                    cx = this.cells[x][c.y];
                    if (cx.isStable() || cx.isBreakable)
                        m.push(cx);
                }
                for (y = 0; y < this.fieldHeight; ++y) {
                    cy = this.cells[c.x][y];
                    if (cy.isStable() || cx.isBreakable)
                        m.push(cy);
                }
                break;
            case 6 /* kThickCrossBonus */:
                for (x = 0; x < this.fieldWidth; ++x) {
                    for (y = c.y - 1; y <= c.y + 1; ++y) {
                        if (x >= 0 && x < this.fieldWidth && y >= 0 && y < this.fieldHeight) {
                            cx = this.cells[x][y];
                            if (cx.isStable() || cx.isBreakable)
                                m.push(cx);
                        }
                    }
                }
                for (x = c.x - 1; x <= c.x + 1; ++x) {
                    for (y = 0; y < this.fieldHeight; ++y) {
                        if (x >= 0 && x < this.fieldWidth && y >= 0 && y < this.fieldHeight) {
                            cx = this.cells[x][y];
                            if (cx.isStable() || cx.isBreakable)
                                m.push(cx);
                        }
                    }
                }
                break;
            case 7 /* kLargeBombBonus */:
                for (x = -4; x <= 4; ++x) {
                    for (y = -4; y <= 4; ++y) {
                        var nx = c.x + x;
                        var ny = c.y + y;
                        if (nx >= 0 && ny >= 0 && ny < this.fieldHeight && nx < this.fieldWidth) {
                            var cn = this.cells[nx][ny];
                            if (cn.isStable() || cn.isBreakable)
                                m.push(cn);
                        }
                    }
                }
                break;
            case 8 /* kColorLineBonus */:
                var color = this.getMatchColor(c, match);
                left = 10;
                var colored = [];
                for (x = 0; x < this.fieldWidth; ++x)
                    for (y = 0; y < this.fieldHeight; ++y) {
                        cn = this.cells[x][y];
                        if (cn && cn.object && this.cells[x][y].getType() == color && !cn._isBlock && !cn.object.isBonus && !cn.object.isMoving)
                            colored.push(cn);
                    }
                var attempts = 70;
                var colorLen = colored.length;
                while (attempts > 0 && left > 0 && colorLen > 0) {
                    var j = getInt(colorLen);
                    --colorLen;
                    cn = colored[j];
                    m.push(cn);
                    if (cn != c)
                        cn.object.setBonusType(Math.random() > 0.5 ? 1 /* kHorizontalLize */ : 2 /* kVerticalLine */);
                    colored.splice(j, 1);
                    attempts--;
                    left--;
                }
                break;
            case 9 /* kColorBombBonus */:
                var color = this.getMatchColor(c, match);
                left = 10;
                var colored = [];
                for (x = 0; x < this.fieldWidth; ++x)
                    for (y = 0; y < this.fieldHeight; ++y) {
                        cn = this.cells[x][y];
                        if (cn && cn.object && this.cells[x][y].getType() == color && !cn._isBlock && !cn.object.isBonus && !cn.object.isMoving)
                            colored.push(cn);
                    }
                var attempts = 70;
                var colorLen = colored.length;
                while (attempts > 0 && left > 0 && colorLen > 0) {
                    var j = getInt(colorLen);
                    --colorLen;
                    cn = colored[j];
                    m.push(cn);
                    if (cn != c)
                        cn.object.setBonusType(3 /* kBombBonus */);
                    colored.splice(j, 1);
                    attempts--;
                    left--;
                }
                break;
            case 10 /* kColorColorBonus */:
                for (x = 0; x < this.fieldWidth; ++x)
                    for (y = 0; y < this.fieldHeight; ++y) {
                        cn = this.cells[x][y];
                        if (cn.isStable() || cn.isBreakable)
                            m.push(cn);
                    }
                break;
        }
        return m;
    };

    Match3Level.prototype.trySpawnHighValue = function (m) {
        var len = m.length;

        var realLen = 0;
        var toCheck = [];
        for (var i = 0; i < len; ++i) {
            toCheck.push(m[i]);
            if (!m[i].object.isHighValue)
                ++realLen;
        }

        var toSpawn = Math.floor(realLen / 6);
        for (var i = 0; i < toSpawn; ++i) {
            var isSuccess = false;
            while (len > 0) {
                var j = getInt(len);
                len--;

                var c = toCheck.splice(j, 1)[0];
                for (var k = 0; k < 4; ++k) {
                    var x = c.x + (k == 0 ? -1 : k == 1 ? 1 : 0);
                    var y = c.y + (k == 2 ? -1 : k == 3 ? 1 : 0);
                    if (x >= 0 && y >= 0 && x < this.fieldWidth && y < this.fieldHeight) {
                        var cx = this.cells[x][y];
                        var tutorialCheck = !MenuManager.instance.isOnTutorial() || Tutorial.instance.checkHighValueCell(cx);
                        if (tutorialCheck && cx.object && !cx.object.isMoving && !cx.isWaitingForClear && !cx.object.isBonus && !cx.object.isHighValue && !cx.object.isPushable && !cx.isWaitingForDestruction && !cx.isBlock() && !cx.object.isWaitingForDestruction) {
                            isSuccess = true;
                            var minClear = c.minClearIn;
                            cx.object.setHighValueIn(minClear > 0 ? minClear : 0.1);
                            break;
                        }
                    }
                }
                if (isSuccess)
                    break;
            }
        }
    };

    //time since bonus activation to its destruction
    Match3Level.prototype.getBonusDelay = function (bonus) {
        var d = 0;
        if (bonus == 4 /* kColorBonus */)
            d += 20 / 30;
        else if (bonus != 0 /* kBonusNone */ && bonus < 8 /* kColorLineBonus */)
            d += BonusDestroyAnimation.TIME;
        return d;
    };

    //time since wave from main bonus (c1) comes to current one (c2)
    Match3Level.prototype.getDistanceDelay = function (c1, c2, bonus, gen) {
        var distance = (bonus == 8 /* kColorLineBonus */ || bonus == 9 /* kColorBombBonus */) ? 1 : bonus == 4 /* kColorBonus */ ? 2 : this.getDistance(c1, c2, false);
        return FieldObject.GEM_KILL_DELAY * distance * Math.pow(0.75, gen);
    };

    Match3Level.prototype.getMatchColor = function (c, m) {
        if (!m)
            return c.getType();

        var amounts = [0, 0, 0, 0, 0, 0];
        var len = amounts.length;
        for (var i = 0; i < len; ++i) {
            var t = m[i].getType();
            if (t >= 0) {
                amounts[t]++;
                if (amounts[t] >= 2)
                    return t;
            }
        }
        return c.getType();
    };

    Match3Level.prototype.onHudDown = function (x, y) {
        if (this.hud)
            this.hud.onDown(x, y);
    };

    Object.defineProperty(Match3Level.prototype, "hasComboRecently", {
        get: function () {
            return this.timeSinceLastComboRemove < 0.2;
        },
        enumerable: true,
        configurable: true
    });

    Match3Level.prototype.onMouseDown = function (x, y) {
        if (!this.isActive || this.hasComboRecently)
            return;

        if (this.hud)
            this.hud.onDown(x, y);

        if (this.isHardLocked || this.movesLeft <= 0 || this.isPaused || this.isWaitingForTarget)
            return;

        var initPosX = this.stageToGridX(x);
        var initPosY = this.stageToGridY(y);
        var posx = Math.floor(initPosX);
        var posy = Math.floor(initPosY);
        var match = this.getFillZone(posx, posy);

        if (match && match.length >= 3) {
            this.isLocked = true;
            ++this.currentMove;
            this.timeSinceLastComboRemove = 0;
            --this.movesLeft;
            LevelManager.instance.moves++;
            this.combinateBonuses(match);

            for (var x = 0; x < this.fieldWidth; ++x)
                for (var y = 0; y < this.fieldHeight; ++y)
                    this.cells[x][y].isTeleportLocked = false;

            var toCheck = [{ match: match, mains: [this.cells[posx][posy]], delay: 0.15, bonus: 0 /* kBonusNone */, gen: 0, prevBonus: 0 /* kBonusNone */ }];
            var current = 0;
            var maxDelay = -1;
            var first = true;

            this.isUpdatingAfterMatch = true;

            while (current < toCheck.length) {
                var currentMatch = toCheck[current].match;
                var mains = toCheck[current].mains;
                var baseDelay = toCheck[current].delay;
                var bonus = toCheck[current].bonus;
                var generation = toCheck[current].gen;
                var prevBonus = toCheck[current].prevBonus;

                ++current;

                this.customMatches.push(currentMatch);

                var cLen = currentMatch.length;
                for (var i = 0; i < cLen; ++i) {
                    var bestMain = mains[0];
                    var c = currentMatch[i];

                    var delay = baseDelay + this.getDistanceDelay(bestMain, c, bonus, generation) + this.getBonusDelay(c.getBonusType());

                    //bonus check
                    if (c && c.object && c.object.isBonus && !c.object.isMoving && !c.isWaitingForClear) {
                        var isLine = c.object.bonusType == 1 /* kHorizontalLize */ || c.object.bonusType == 2 /* kVerticalLine */;
                        var bonusType = bonus == c.object.bonusType && isLine ? (bonus == 1 /* kHorizontalLize */ ? 2 /* kVerticalLine */ : 1 /* kHorizontalLize */) : c.object.bonusType;
                        c.object.bonusType = bonusType;
                        var m = this.getBonusGroup(c, 0 /* kBonusNone */, currentMatch);

                        if (m.length > 0) {
                            toCheck.push({ match: m, mains: [c], delay: delay, bonus: bonusType, gen: generation + 1, prevBonus: bonus });
                        }
                    }

                    if (c.object && c.object.isHighValue)
                        c.scoreToAdd = this.getHighValueCellScore() + (c.scoreToAdd >= 0 ? c.scoreToAdd : 0);

                    maxDelay = Math.max(maxDelay, delay);
                    c.prepareToClear(delay, bonus);
                }

                if (first) {
                    var score = this.getComboScore(cLen);
                    var maxDelay = -1;
                    var maxCell = null;
                    for (var i = 0; i < cLen; ++i) {
                        var c = currentMatch[i];
                        var minClear = c.minClearIn;
                        if (c.object && !c.object.isBonus && c.isWaitingForClear && minClear > maxDelay) {
                            maxDelay = minClear;
                            maxCell = c;
                        }
                    }
                    if (maxCell) {
                        maxCell.scoreToAdd = score + (c.scoreToAdd >= 0 ? c.scoreToAdd : 0);
                        ;
                        maxCell.bonusComboCount = current;
                    }
                } else {
                    if (bestMain.object && bestMain.object.isBonus) {
                        bestMain.scoreToAdd = this.getBonusScore(bonus, generation - 1, prevBonus) + (bestMain.scoreToAdd >= 0 ? bestMain.scoreToAdd : 0);
                        ;
                        bestMain.bonusComboCount = current;
                    }
                }

                first = false;
            }

            maxDelay += FieldObject.GEM_KILL_DELAY * (this.customMatches.length <= 1 ? 3 : 7);
            if (needTutorial && App.episode == 3 && this.currentMove == 2 && this.levelData.levelNumber == 1)
                maxDelay += 1;
            for (i = 0; i < this.customMatches.length; ++i)
                for (var j = 0; j < this.customMatches[i].length; ++j)
                    this.customMatches[i][j].setTempBlock(true, maxDelay);

            this.customMatches = [];
            this.trySpawnBonus(match);
            this.trySpawnHighValue(match);
        } else {
            if (posx < 0 || posy < 0 || posx >= this.fieldWidth || posy >= this.fieldHeight)
                return;

            var c = this.cells[posx][posy];
            if (c && c.object && this.isGoodForClick(c))
                c.object.playJellyAnimation(1, 1);
        }
    };

    Match3Level.prototype.getBonusScore = function (bonus, gen, prevBonus) {
        if (typeof prevBonus === "undefined") { prevBonus = -1; }
        if (prevBonus >= 8 /* kColorLineBonus */ && prevBonus <= 9 /* kColorBombBonus */)
            return -1;

        var score = Match3Level.bonusScores[bonus] * Math.pow(1.2, gen);
        score = Math.round(score / 10);
        score *= 10;
        return score;
    };

    Match3Level.prototype.getHighValueCellScore = function () {
        return 30;
    };

    Match3Level.prototype.getComboScore = function (n) {
        return n * CellObject.BASE_SCORE;
    };

    Match3Level.prototype.getDistance = function (c1, c2, skipBorder) {
        if (typeof skipBorder === "undefined") { skipBorder = false; }
        var dx = Math.abs(c1.x - c2.x);
        if (skipBorder)
            dx = Math.min(dx, Math.abs(dx - this.fieldWidth));

        var dy = Math.abs(c1.y - c2.y);
        if (skipBorder)
            dy = Math.min(dy, Math.abs(dy - this.fieldHeight));

        return dx + dy;
    };

    Match3Level.prototype.onBeforeSwap = function (colorType) {
    };

    Match3Level.prototype.onExit = function () {
    };

    Match3Level.prototype.onWrongMove = function () {
    };

    Match3Level.prototype.onSuccessMove = function (x1, x2, y1, y2) {
    };

    Match3Level.prototype.handleCombo = function () {
    };

    Match3Level.prototype.canSwap = function (c1, c2) {
        if (c1.isBlock() || c2.isBlock())
            return { colorType: -1, color: -1 };

        return { colorType: 0, color: 0 };

        var l = c1.x - 2;
        var r = c1.x + 2;
        var t = c1.y - 2;
        var b = c1.y + 2;
        l = l < 0 ? 0 : l >= this.fieldWidth ? this.fieldWidth - 1 : l;
        t = t < 0 ? 0 : t >= this.fieldHeight ? this.fieldHeight - 1 : t;
        r = r < 0 ? 0 : r >= this.fieldWidth ? this.fieldWidth - 1 : r;
        b = b < 0 ? 0 : b >= this.fieldHeight ? this.fieldHeight - 1 : b;

        //CHECK HORIZONTAL
        var currentType = -1;
        var currentLen = 0;
        var j = c1.y;
        for (var i = l; i <= r; i++) {
            var colorType = this.cells[i][j] == c2 ? c1.getType() : this.cells[i][j] == c1 ? c2.getType() : this.cells[i][j].getType();
            if (colorType == this.assetNumber) {
                var next = i + 1 <= r ? this.cells[i + 1][j] : null;
                var nextType = !next ? -2 : next == c1 ? c2.getType() : next == c2 ? c1.getType() : next.getType();
                if (currentLen == 0 && next) {
                    currentType = nextType;
                    currentLen = 1;
                } else if (currentLen == 2) {
                    return { colorType: 0, color: currentType };
                } else if (currentLen == 1 && next) {
                    if (currentType == nextType || nextType == this.assetNumber) {
                        return { colorType: 0, color: currentType };
                    } else {
                        currentType = nextType;
                        currentLen = 2;
                        i++;
                    }
                }
            } else if (colorType == -1) {
                currentType = -1;
                currentLen = 0;
            } else if (currentType == -1 || colorType != currentType) {
                currentType = colorType;
                currentLen = 1;
            } else if (currentType == colorType) {
                currentLen++;
                if (currentLen >= 3) {
                    return { colorType: 0, color: currentType };
                }
            }
        }

        //CHECK VERTICAL
        currentType = -1;
        currentLen = 0;
        i = c1.x;
        for (j = t; j <= b; j++) {
            colorType = this.cells[i][j] == c2 ? c1.getType() : this.cells[i][j] == c1 ? c2.getType() : this.cells[i][j].getType();

            if (colorType == this.assetNumber) {
                next = j + 1 <= b ? this.cells[i][j + 1] : null;
                nextType = !next ? -2 : next == c1 ? c2.getType() : next == c2 ? c1.getType() : next.getType();
                if (currentLen == 0 && next) {
                    currentType = nextType;
                    currentLen = 1;
                } else if (currentLen == 2) {
                    return { colorType: 1, color: currentType };
                } else if (currentLen == 1 && next) {
                    if (currentType == nextType || nextType == this.assetNumber) {
                        return { colorType: 1, color: currentType };
                    } else {
                        currentType = nextType;
                        currentLen = 2;
                        j++;
                    }
                }
            } else if (colorType == -1) {
                currentType = -1;
                currentLen = 0;
            } else if (currentType == -1 || colorType != currentType) {
                currentType = colorType;
                currentLen = 1;
            } else if (currentType == colorType) {
                currentLen++;
                if (currentLen >= 3) {
                    return { colorType: 1, color: currentType };
                }
            }
        }

        //CHECK EMPTY
        if ((c1.object == null || c2.object == null) && !(c1.object == null && c2.object == null)) {
            var emptyCell = c1.object == null ? c1 : c2;
            var nonEmptyCell = c1.object == null ? c2 : c1;

            currentType = -1;
            currentLen = 0;

            i = nonEmptyCell.x;
            for (j = this.fieldHeight - 1; j >= 0; j--) {
                if (j == nonEmptyCell.y)
                    continue;

                colorType = this.cells[i][j].getType();

                if (colorType == this.assetNumber) {
                    var nJ = j - 1 == nonEmptyCell.y ? j - 2 : j - 1;
                    next = nJ >= 0 ? this.cells[i][nJ] : null;
                    nextType = !next ? -2 : next.getType();
                    if (currentLen == 0 && next) {
                        currentType = nextType;
                        currentLen = 1;
                    } else if (currentLen == 2) {
                        return { colorType: 2, color: currentType };
                    } else if (currentLen == 1 && next) {
                        if (currentType == nextType || nextType == this.assetNumber) {
                            return { colorType: 2, color: currentType };
                        } else {
                            currentType = nextType;
                            currentLen = 2;
                            j++;
                        }
                    }
                } else if (colorType == -1) {
                    currentType = -1;
                    currentLen = 0;
                } else if (currentType == -1 || colorType != currentType) {
                    currentType = colorType;
                    currentLen = 1;
                } else if (currentType == colorType) {
                    currentLen++;
                    if (currentLen >= 3) {
                        return { colorType: 2, color: currentType };
                    }
                }
            }
        }

        return { colorType: -1, color: -1 };
    };

    Match3Level.prototype.getCustomMatchesAmount = function () {
        var res = 0;
        for (var v in this.customMatches)
            for (var c in this.customMatches[v])
                res++;
        return res;
    };

    Object.defineProperty(Match3Level.prototype, "isHardLocked", {
        get: function () {
            return this.isLocked || this._isHardLocked;
        },
        enumerable: true,
        configurable: true
    });

    Match3Level.prototype.update = function (dt) {
        //if (MenuManager.instance.current == MenuManager.instance.target)
        //    return;
        if (!this.isGenerated)
            return;

        if (this.comboTimer > 0) {
            this.comboTimer--;
            if (this.comboTimer == 0) {
                if (this.comboAmount > this.maxCombo)
                    this.maxCombo = this.comboAmount;
                this.handleCombo();
                this.comboAmount = 0;
                this.setCombo();
            }
        }

        this.timeSinceLastComboRemove += dt;

        var empties = 0;
        this._isHardLocked = false;
        this.isLocked = this.hasComboRecently || this.isUpdatingAfterMatch || this.isStuck;
        for (var x = 0; x < this.fieldWidth; ++x)
            for (var y = 0; y < this.fieldHeight; ++y) {
                var c = this.cells[x][y];
                c.update(dt);
                if (c.object == null && !c.isBlock())
                    ++empties;
                this.isLocked = this.isLocked || (c.object && (c.object.isMoving || c.object.isWaitingForDestruction)) || c.isWaitingForClear || c.isChangingType;
                this._isHardLocked = this._isHardLocked || this.isLocked || (c.isTempBlock && !c._isBlock);
            }

        var len = this.objects.length;
        for (var i = 0; i < len; ++i) {
            var o = this.objects[i];
            if (o && !o.isDestroyed) {
                o.update(dt);
                this.isLocked = this.isLocked || (o.isLocked && !o.isDestroyed);
            } else {
                this.objects.splice(i, 1);
                i--;
                len--;
            }
        }
        this.isUpdatingAfterMatch = false;

        if (empties > 0) {
            var addCount = this.addObjects();
            addCount += this.pushObjects();
            this.isLocked = this.isLocked || addCount > 0;
        }

        if (this.isHardLocked || this.isEnded)
            this.timeSinceLastAction = 0;
        else {
            this.timeSinceLastAction += dt;
            if (this.timeSinceLastAction > 3 && !MenuManager.instance.isOnTutorial())
                this.playHint();
            if (!this.isHardLocked)
                this.checkIfComboExists();
        }

        if (this.showWinMenuIn > 0 && !this.isHardLocked) {
            this.showWinMenuIn -= dt;
            if (this.showWinMenuIn <= 0) {
                this.isEnded = false;
                this.onWin();
            }
        }
        this.isLocked = this.isLocked || this.isEnded;

        if (!this.isPaused && (!this.isHardLocked || this.isStuck) && !this.isEnded && !this.target.isCompleted && (this.movesLeft <= 0 || this.isStuck) && this.playLoseIn > 0 && !MenuManager.instance.target.isMenuActive) {
            this.playLoseIn -= dt;
            if (this.playLoseIn <= 0)
                this.onLose();
        }

        if (this.isWaitingForTarget && !this.isHardLocked && !this.isPaused) {
            this.showTargetIn -= dt;
            if (!this.isWaitingForTarget) {
                if (!Tutorial.instance.hasTutorial(this.levelData.levelNumber) || !needTutorial)
                    MenuManager.instance.show(MenuManager.instance.target, false);
                else
                    MenuManager.instance.show(MenuManager.instance.tutorial, false);
            }
        }

        var waterAmount = CellObject.waterCells.length;
        if (waterAmount > 0 && this.waterRemoveMove < this.currentMove && !this.isHardLocked) {
            this.placeNewWater();
        }

        if (this.needToUpdateBack) {
            this.needToUpdateBack = false;
            if (this.markLayer.cacheCanvas)
                this.markLayer.updateCache();
            else
                this.markLayer.cache(0, 0, App.SCREEN_W, App.FULL_SCREEN_H);
        }

        this.hud.update(dt);
        this.fpsText.text = createjs.Ticker.getMeasuredFPS().toFixed(1);
    };

    Match3Level.prototype.placeNewWater = function () {
        var water = CellObject.waterCells.concat();
        var len = water.length;
        var directions = [0, 1, 2, 3];
        while (len > 0) {
            var i = getInt(len);
            var c = water.splice(i, 1)[0];
            len--;
            if (!c.isWaterBlock)
                console.log("ERROR! CELL MUST BE WATER BLOCKED");

            var dLen = directions.length;
            while (dLen > 0) {
                var dir = directions.splice(getInt(dLen), 1)[0];
                dLen--;

                var x = c.x + (dir == 0 ? -1 : dir == 1 ? 1 : 0);
                var y = c.y + (dir == 2 ? -1 : dir == 3 ? 1 : 0);

                if (x >= 0 && y >= 0 && x < this.fieldWidth && y < this.fieldHeight) {
                    var cw = this.cells[x][y];
                    if (cw && !cw.isWaitingForClear && cw.object && !cw.isBlock() && this.isGoodForClick(cw)) {
                        cw.setBlock(6 /* kWaterBomb */);
                        this.waterRemoveMove = this.currentMove;
                        return;
                    }
                }
            }

            directions.push(0, 1, 2, 3);
        }
    };

    Match3Level.prototype.updateFpsText = function () {
        this.fpsText.text = createjs.Ticker.getMeasuredFPS().toFixed(1);
    };

    Match3Level.prototype.checkIfComboExists = function () {
        if (this.hud.isShuffleActive() || this.isWaitingForTarget || MenuManager.instance.current == MenuManager.instance.target || this.isStuck)
            return;

        for (var y = 0; y < this.fieldHeight; ++y) {
            for (var x = 0; x < this.fieldWidth; ++x) {
                var c = this.cells[x][y];
                var zone = this.getFillZone(x, y, 3);
                if (zone && zone.length >= 3) {
                    return;
                }
            }
        }

        var all = [];
        for (var x = 0; x < this.fieldWidth; ++x)
            for (var y = 0; y < this.fieldHeight; ++y)
                if (this.isGoodForClick(this.cells[x][y]))
                    all.push(this.cells[x][y]);
        var len = all.length;

        this.isLocked = true;
        var attempts = 80;
        var canHasCombo = false;
        var time = 0.6;
        while (attempts >= 0 && !canHasCombo) {
            attempts--;
            var i = getInt(len);
            var c = all[i];
            if (!c.object.isPushable) {
                var neigh = [c];
                for (var j = 0; j < 4; ++j) {
                    x = c.x + (j == 0 ? 1 : j == 1 ? -1 : 0);
                    y = c.y + (j == 2 ? 1 : j == 3 ? -1 : 0);
                    if (x >= 0 && y >= 0 && x < this.fieldWidth && y < this.fieldHeight) {
                        var c1 = this.cells[x][y];
                        if (this.isGoodForClick(c1)) {
                            neigh.push(c1);
                            if (neigh.length >= 3) {
                                var type = (c.getType() + 1) % this.assetNumber;
                                canHasCombo = true;
                                for (var k = 0; k < neigh.length; ++k) {
                                    neigh[k].prepareToChangeType(time + lerp(0, 0.2, Math.random()), type);
                                    i = all.indexOf(neigh[k]);
                                    if (i != -1) {
                                        all.splice(i, 1);
                                        len--;
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }

        if (!canHasCombo) {
            this.isStuck = true;
            this.playLoseIn /= 1.5;
            return;
        }

        while (len > 0) {
            var i = getInt(len);
            len--;
            var c = all.splice(i, 1)[0];
            c.prepareToChangeType(time + lerp(0, 0.2, Math.random()));
        }

        this.hud.playShuffleAnimation();
    };

    Match3Level.prototype.playHint = function () {
        var all = [];
        for (var x = 0; x < this.fieldWidth; ++x)
            for (var y = 0; y < this.fieldHeight; ++y)
                all.push(this.cells[x][y]);

        var attempts = 15;
        var len = all.length;

        while (--attempts > 0 && len > 0) {
            var i = getInt(len);
            len--;
            var c = all.splice(i, 1)[0];

            if (!this.isGoodForClick(c))
                continue;

            var zone = this.getFillZone(c.x, c.y, 3);
            if (zone && zone.length >= 3) {
                this.timeSinceLastAction = -Math.random() * 4;
                zone[getInt(zone.length)].object.playJellyAnimation(0.2 + Math.random() * 0.2, 0.25 + Math.random() * 0.25);
                return;
            }
        }
    };

    Match3Level.prototype.setCombo = function () {
    };

    Match3Level.prototype.isGoodForClick = function (c) {
        return c.object && c.object.colorType != -1 && !c.object.isMoving && !c.isWaitingForClear && !c.isObjectBlocked && c.object.colorType != 4 && !c.isChangingType;
    };

    Match3Level.prototype.getFillZone = function (x, y, maxLen) {
        if (typeof maxLen === "undefined") { maxLen = -1; }
        if (x < 0 || y < 0 || x >= this.fieldWidth || y >= this.fieldHeight)
            return null;

        var res = tempObjectData.fillZoneRes;
        res.length = 0;
        var toCheck = tempObjectData.fillZoneCheck;
        toCheck.length = 0;
        var initCell = this.cells[x][y];

        if (!this.isGoodForClick(initCell))
            return res;

        var color = initCell.object.colorType;
        toCheck.push(initCell);
        var current = 0;
        var len = toCheck.length;
        while (current < len && (maxLen < 0 || current < maxLen)) {
            var c = toCheck[current];
            res.push(c);
            ++current;

            for (var i = 0; i < 4; ++i) {
                var tx = c.x + (i == 0 ? -1 : i == 1 ? 1 : 0);
                var ty = c.y + (i == 2 ? -1 : i == 3 ? 1 : 0);
                if (tx >= 0 && ty >= 0 && tx < this.fieldWidth && ty < this.fieldHeight) {
                    var checkCell = this.cells[tx][ty];
                    if (checkCell.object && (checkCell.object.colorType == color || checkCell.object.bonusType == 4 /* kColorBonus */) && !checkCell.object.isMoving && !checkCell.isWaterBlock && toCheck.indexOf(checkCell) == -1) {
                        toCheck.push(checkCell);
                        ++len;
                    }
                }
            }
        }
        return res;
    };

    Match3Level.prototype.onGroupRemove = function (n, o) {
    };

    Match3Level.prototype.pushObjects = function () {
        var count = 0;
        count += this.pushBaseObjects();
        count += this.pushHoles();
        return count;
        //this.pushBaseObjects(x, y);
    };

    Match3Level.prototype.pushBaseObjects = function () {
        var count = 0;
        for (var x = 0; x < this.fieldWidth; x++) {
            for (var y = this.fieldHeight - 1; y >= 0; y--) {
                var c = this.cells[x][y];
                var isBlock = c._isBlock || c.isTempBlock;
                if (isBlock)
                    continue;

                if (c.object == null && !isBlock) {
                    //move up to find non-empty cell to put down
                    var nonEmpty = -1;
                    var hasBlock = false;
                    var findX = x;
                    var isTeleport = false;

                    for (var findY = y; findY >= 0; findY--) {
                        var checkCell = this.cells[findX][findY];
                        var isCheckBlock = checkCell._isBlock || checkCell.isTempBlock;

                        if ((isCheckBlock || checkCell.isWaitingForClear) && findY != y) {
                            hasBlock = true;
                            break;
                        } else if (checkCell.object != null && !isCheckBlock && !checkCell.object.isMoving && findY != y) {
                            nonEmpty = findY;
                            break;
                        } else {
                            var teleportCell = checkCell.teleportCellStart;
                            var teleportCellCheck = teleportCell != null && teleportCell.object != null && !teleportCell._isBlock && !teleportCell.isTempBlock && !teleportCell.object.isMoving && !teleportCell.isTeleportLocked;

                            if (teleportCellCheck) {
                                for (var teleportY = findY + 1; teleportY < this.fieldHeight; ++teleportY) {
                                    var c2 = this.cells[findX][teleportY];
                                    if (c2 && c2.object && c2.object.isMoving) {
                                        teleportCellCheck = false;
                                        break;
                                    }
                                }

                                if (teleportCellCheck) {
                                    nonEmpty = teleportCell.y;

                                    //teleportCell.object.setPos(checkCell.pos.x, checkCell.pos.y);
                                    checkCell = teleportCell;
                                    isTeleport = true;
                                    break;
                                }
                            }
                        }
                    }

                    if (nonEmpty != -1 && !hasBlock) {
                        if (!isTeleport) {
                            checkCell.object.moveTo(c.pos.x, c.pos.y, false, 0.05);
                            c.setObject(checkCell.object);
                            checkCell.object = null;
                        } else
                            checkCell.prepareToTeleport(c);
                        ++count;
                    }
                }
            }
        }
        return count;
    };

    Match3Level.prototype.pushHoles = function () {
        var count = 0;
        for (var i = 0; i < this.fieldWidth; ++i) {
            var isUnderBlock = this.isEnded;
            for (var j = 0; j < this.fieldHeight; ++j) {
                var c = this.cells[i][j];
                var isTrueBlock = c._isBlock || c.isTempBlock;
                var isBlock = isTrueBlock || !c.isPushEnabled;
                var isTeleportEnabled = c.teleportCellStart != null && !c.teleportCellStart.isBlock() && c.teleportCellStart.object != null && !c.teleportCellStart.isBlock();
                if (isTeleportEnabled && !isTrueBlock) {
                    isUnderBlock = false;
                    continue;
                }
                if (isBlock) {
                    isUnderBlock = true;
                    if (isTrueBlock)
                        continue;
                }
                if (c.object == null && isUnderBlock) {
                    if (c.blockWasRemovedRecently)
                        continue;

                    var typeA = Math.random() > 0.5;
                    for (var k = 0; k < 2; k++) {
                        var p = ((typeA && k == 0) || (!typeA && k == 1)) ? getPoint(i - 1, j - 1) : getPoint(i + 1, j - 1);

                        if (!(p.x >= 0 && p.y >= 0 && p.x < this.fieldWidth && p.y < this.fieldHeight))
                            continue;

                        var cx = this.cells[p.x][p.y];
                        if (cx.isStable() && cx.object != null && !cx.isWaitingForClear && !cx.isTempBlock && !cx.isObjectBlocked) {
                            var pos = c.pos;
                            cx.object.moveTo(pos.x, pos.y, false, 0.05, true);
                            c.setObject(cx.object);
                            cx.object = null;
                            ++count;
                            break;
                        }
                    }
                } else if (c.object != null && isUnderBlock) {
                    isUnderBlock = false;
                }
            }
        }
        return count;
    };

    Match3Level.prototype.addObjects = function (x, y) {
        if (typeof x === "undefined") { x = -1; }
        if (typeof y === "undefined") { y = -1; }
        if (this.isEnded)
            return 0;

        var addCount = 0;
        for (var i = 0; i < this.fieldWidth; i++) {
            if (x != -1 && i != x)
                continue;
            var isOnBlock = false;
            for (var j = 0; j < this.fieldHeight; j++) {
                if (y != -1 && j != y)
                    continue;
                if (this.cells[i][j].object || this.cells[i][j].isBlock() || !this.cells[i][j].isPushEnabled) {
                    if (this.isGenerated)
                        break;
                    else
                        isOnBlock = true;
                } else {
                    var stageX = this.gridToStageX(i);

                    var spawnPos = -1;

                    if (isOnBlock) {
                        if (this.getCellDataColor(i, j) <= 0)
                            continue;
                        else
                            spawnPos = j;
                    }

                    var type = this.getObjectType(i, j);

                    var fo = Match3Level.pool.getObject(this.cells[i][j], stageX, this.gridToStageY(spawnPos), this.assetNumber, type);

                    //this.add.existingSprite(fo);
                    if (spawnPos != j)
                        fo.moveTo(stageX, this.gridToStageY(j));
                    this.cells[i][j].setObject(fo);
                    ++addCount;
                }
            }
        }
        return addCount;
    };

    Match3Level.prototype.getObjectType = function (x, y) {
        if (!this.isGenerated) {
            var i = this.getCellDataColor(x, y);
            return i - 1;
        }

        return this.target.getExactType(x, y);
    };

    Match3Level.getCellDataType = function (data, x, y) {
        if (!data)
            return "";
        return data.charAt(2 * (y + x * Match3Level.LEVEL_H) + 1);
    };

    Match3Level.prototype.getCellDataColor = function (x, y) {
        if (!this.cellData)
            return -1;
        return parseInt(this.cellData.charAt(2 * (y + x * this.fieldHeight) + 2));
    };

    Match3Level.prototype.generateCells = function () {
        for (var i = 0; i < this.fieldWidth; i++) {
            for (var j = 0; j < this.fieldHeight; j++) {
                var c = this.cells[i][j];
                var type = Match3Level.getCellDataType(this.cellData, i, j);

                switch (type) {
                    case "0":
                    case "":
                        break;
                    case "1":
                        c.setBlock(0 /* kFullBlockType */);
                        break;
                    case "2":
                        c.setBlock(1 /* kSingleBlockType */);
                        break;
                    case "3":
                        c.setBlock(2 /* kDoubleBlockType */);
                        break;
                    case "4":
                        c.setBlock(4 /* kColorBlock */);
                        break;
                    case "5":
                        c.setMark(1);
                        break;
                    case "6":
                        c.setMark(2);
                        break;
                    case "7":
                        c.setBlock(5 /* kBombBlock */);
                        break;
                    case "8":
                        c.setBlock(6 /* kWaterBomb */);
                        break;
                    case "9":
                        c.setMark(3);
                        break;
                    case "a":
                        c.setBlock(3 /* kTripleBlockType */);
                        break;
                    case "b":
                        c.setBlock(7 /* kPlantBomb */);
                        break;
                }

                //if (Math.random() < 0.05)
                //    c.setMark(1);
                var color = this.getCellDataColor(i, j);
                if (color == 5)
                    c.setBlock(4 /* kColorBlock */);
                else if (color == 6)
                    c.setBlock(7 /* kPlantBomb */);
            }
        }

        if (this.levelData.jellyPushPositions) {
            for (var i = 0; i < this.fieldWidth; ++i)
                this.cells[i][0].isPushEnabled = this.levelData.jellyPushPositions[i];
        }

        var teleportData = [];
        var maxTeleportAmount = 18;
        for (var i = 0; i < maxTeleportAmount; ++i)
            teleportData.push([null, null]);
        var len = this.levelData.teleportData.length;
        for (var i = 0; i < len; ++i) {
            var tData = this.levelData.teleportData[i];
            teleportData[tData[3]][tData[2]] = this.cells[tData[0]][tData[1]];
        }

        for (i = 0; i < maxTeleportAmount; ++i) {
            if (teleportData[i][0] && teleportData[i][1]) {
                teleportData[i][0].setTeleport(true, teleportData[i][1]);
                teleportData[i][1].setTeleport(false, teleportData[i][0]);
            }
        }
    };

    Match3Level.prototype.generateField = function () {
        this.addObjects();
        this.target.onLevelGenerated();

        if (this.levelData.levelNumber == 1) {
            this.cells[App.episode <= 1 ? 1 : App.episode <= 2 ? 4 : App.episode == 3 ? 5 : 3][App.episode <= 1 ? 4 : App.episode == 2 ? 5 : App.episode == 3 ? 3 : 7].object.setBonusType(3 /* kBombBonus */);
            this.cells[App.episode <= 1 ? 2 : App.episode <= 2 ? 3 : App.episode == 3 ? 2 : 5][App.episode <= 1 ? 7 : App.episode == 2 ? 7 : App.episode == 3 ? 4 : 1].object.setBonusType(1 /* kHorizontalLize */);
        }
        /*
        this.cells[1][3].object.setBonusType(FieldBonusType.kVerticalLine);
        this.cells[1][7].object.setBonusType(FieldBonusType.kHorizontalLize);
        this.cells[8][7].object.setBonusType(FieldBonusType.kVerticalLine);
        this.cells[8][1].object.setBonusType(FieldBonusType.kHorizontalLize);
        */
        //this.hudLayer.addChild(this.fpsText);
    };

    Match3Level.prototype.generate = function () {
        this.assetNumber = 4;
        this.generateCells();
        this.generateField();
        this.isGenerated = true;

        this.needToUpdateBack = true;
    };

    Match3Level.prototype.getRandomType = function () {
        this.fieldCount++;
        var colorType = getInt(1000);
        var res = colorType % this.assetNumber;
        return res;
    };

    Match3Level.prototype.getChangeType = function () {
        return getInt(1000) % this.assetNumber;
    };

    Match3Level.prototype.setBackground = function (s) {
        this.background = s;
        //this.addChild(s);
        //this.add.existing(s);
    };

    Match3Level.prototype.setFieldProps = function (t, dx, dy, w, h) {
        this.tileSize = t;
        this.offsetX = dx;
        this.offsetY = dy + App.SHIFT_H;
        this.fieldWidth = w;
        this.fieldHeight = h;
    };

    /*
    setAssets(v:Array<Class>): void
    {
    assets = v;
    assetNumber = v.length;
    }
    */
    Match3Level.prototype.gridToStageX = function (x) {
        return this.offsetX + (x + 0.5) * this.tileSize;
    };

    Match3Level.prototype.gridToStageY = function (y) {
        return this.offsetY + (y + 0.5) * this.tileSize;
    };

    Match3Level.prototype.stageToGridX = function (x) {
        return (x - this.offsetX) / this.tileSize;
    };

    Match3Level.prototype.stageToGridY = function (y) {
        return (y - this.offsetY) / this.tileSize;
    };

    Match3Level.prototype.getCellCenterCoordinatesX = function (x) {
        return this.offsetX + (x + 0.5) * this.tileSize;
    };

    Match3Level.prototype.getCellCenterCoordinatesY = function (x, y) {
        return this.offsetY + (y + 0.5) * this.tileSize;
    };

    Object.defineProperty(Match3Level.prototype, "isWaitingForTarget", {
        get: function () {
            return this.showTargetIn > 0;
        },
        enumerable: true,
        configurable: true
    });

    Match3Level.prototype.reset = function () {
        if (this.isActive) {
            removeClip(this);
            this.isEnded = false;
            this.currentMove = 0;
            this.playLoseIn = 1.3;
            this.isStuck = false;
            this.uncache();
            this.isPaused = false;
            this._isHardLocked = false;
            this.showTargetIn = 0.3;
            this.isGenerated = false;

            this.showWinMenuIn = -1;
            var index = 0;
            var row = 0;
            for (var x = 0; x < this.fieldWidth; ++x) {
                for (var y = 0; y < this.fieldHeight; ++y)
                    this.cells[x][y].reset();
            }

            var len = this.objects.length;
            for (var i = 0; i < len; ++i)
                this.objects[i].destroy();
            this.objects = [];

            this.target = null;
            this.hud.reset();

            //removeClip(this.back);
            this.needToUpdateBack = true;
            //Match3Level.instance = App.level = null;
        }
    };
    Match3Level.bonusScores = [0, 80, 80, 100, 150, 110, 180, 180, 250, 280, 500];

    Match3Level.COMBO_TIME = 70;

    Match3Level.OLD_TILE_SIZE = 50;
    Match3Level.TILE_SIZE = 59;
    Match3Level.LEVEL_W = 10;
    Match3Level.LEVEL_H = 10;
    Match3Level.TILE_SIZE_FACTOR = Match3Level.TILE_SIZE / Match3Level.OLD_TILE_SIZE;
    Match3Level.MIN_LINE_SIZE = 4;
    return Match3Level;
})(createjs.Container);
/// <reference path="../lib/createjs.d.ts" />
/// <reference path="../lib/easeljs.d.ts" />
/// <reference path="../lib/spil.d.ts" />
/// <reference path="../lib/preloadjs.d.ts" />
/// <reference path="../lib/soundjs.d.ts" />
/// <reference path="../lib/spil.d.ts" />
var App = (function () {
    function App() {
        var _this = this;
        this.atlases = [];
        this.musicPlayed = false;
        this.gameTime = 0;
        this.isPaused = false;
        this.timeSinceAds = 0;
        this.visibilityState = null;
        this.isPlayingOnMobile = false;
        App.game = this;

        this.isPlayingOnMobile = isMobile();

        try  {
            if (window.top != window) {
                document.getElementById("header").style.display = "none";
            }
            try  {
                if (navigator.appVersion.indexOf("Win") != -1) {
                    var body = document.getElementsByTagName('body')[0];
                    body.style.overflow = 'hidden';
                }
            } catch (e) {
            }
        } catch (ex) {
        }

        this.stage = new createjs.Stage("canvas");
        createjs.Touch.enable(this.stage, true);

        this.preloader = new Preloader();

        setTimeout(function () {
            window.scrollTo(0, 1);
        }, 1000);

        //window.onresize = () => this.resize();
        if (viewporter && viewporter.ACTIVE) {
            window.addEventListener("viewportready", function () {
                return _this.resize();
            }, true);
            window.addEventListener("viewportchange", function () {
                return _this.resize();
            }, true);
        } else
            window.addEventListener("resize", function () {
                return _this.resize();
            }, true);
        this.resize();

        document.addEventListener("touchmove", touchHandlerDummy, false);
        window.addEventListener("touchmove", touchHandlerDummy, false);
        window.addEventListener("touchstart", function () {
        });

        createjs.Ticker.setFPS(320);
        createjs.Ticker.addEventListener("tick", function (e) {
            _this.update(e);
        });

        this.stage.addEventListener("stagemousedown", function (e) {
            _this.onPreloaderDown(e);
        });
    }

    //LABS
    App.prototype.loadApi = function () {
        // GameAPI.loadAPI((api: any) => this.onApiLoaded(api));
        //console.log(apiInstance.Branding.getLink('more_games').error);// ('more_games'));
        App.game.onLoadComplete();
    };

    App.prototype.showAds = function () {
        var _this = this;
        var t = this.timeSinceAds / 60;
        if ((t >= 5 || true) && apiInstance) {
            console.log("show ads");
            apiInstance.GameBreak.request(function () {
                return _this.pauseGame();
            }, function () {
                return _this.resumeGame();
            });
        }
    };

    App.prototype.pauseGame = function () {
        this.isPaused = true;
        SoundsManager.instance.pauseMusic();
        this.timeSinceAds = 0;
    };

    App.prototype.resumeGame = function () {
        this.isPaused = false;
        SoundsManager.instance.resumeMusic();
        this.timeSinceAds = 0;
    };

    /*
    onApiLoaded(api: any): void {
    apiInstance = api;
    
    App.game.onLoadComplete();
    }*/
    App.prototype.onLoadComplete = function () {
        var _this = this;
        if (this.levelManager)
            return;

        //createjs.Touch.enable(this.stage, true);
        //createjs.Touch.disable(this.backStage);
        this.timeSinceAds = 0;
        this.resize();
        this.levelManager = new LevelManager();
        var info = this.preloader.loader.getResult("artJson");
        info.images[0] = this.preloader.loader.getResult("art.png"); //createjs.SpriteSheetUtils.mergeAlpha(<HTMLImageElement> this.preloader.loader.getResult("art.jpg"), <HTMLImageElement> this.preloader.loader.getResult("art_alpha.png"));//
        spriteSheetInfo = info;

        //this.stage.snapToPixelEnabled = true;
        createAnimation("chocolate white destr", "chocolate white destr", 1, 18, 1, null, 50);
        createAnimation("color bonus", "color bonus", 1, 37, 1, null, 50);
        createAnimation("bonus blink", "color bonus", 30, 37, 1, null, 50);
        createAnimation("chocolate destroy", "chocolate destroy", 1, 15, 1, null, 50);
        createAnimation("color wall", "color wall", 1, 18, 1, null, 50);
        createAnimation("bluex", "blue", 1, 16, 1, null, 50);
        createAnimation("greenx", "green", 1, 13, 1, null, 50);
        createAnimation("orangex", "orange", 1, 17, 1, null, 50);
        createAnimation("purplex", "purple", 1, 16, 1, null, 50);
        createAnimation("mine", "mine", 1, 15, 1, null, 50);
        createAnimation("water_splash", "water_splash", 1, 14, 1, null, 50);
        createAnimation("teleport_in", "teleport_in", 1, 11, 1, null, 50);
        createAnimation("teleport_out", "teleport_out", 1, 11, 1, null, 50);
        createAnimation("bush_anim", "bush_anim", 1, 19, 1, null, 50);
        createAnimation("bush_anim_reverse", "bush_anim", 19, 1, 1, null, 50);
        createFontFrames(info);
        this.atlases.push(new createjs.SpriteSheet(info)); //0 - usual

        this.animationManager = new AnimationManager();
        this.animationManager.putAnimation("logo", this.preloader.loader.getResult("logo text"), 0);
        this.animationManager.putAnimation("button", this.preloader.loader.getResult("button text"), 0);
        this.animationManager.putAnimation("Char", this.preloader.loader.getResult("Char win"), 0);
        this.animationManager.putAnimation("Char lose", this.preloader.loader.getResult("Char lose"), 0);
        this.animationManager.putAnimation("gloss anim", this.preloader.loader.getResult("gloss anim"), 0);
        this.animationManager.putAnimation("pointer", this.preloader.loader.getResult("pointer"), 0);
        this.animationManager.putAnimation("buttons anim", this.preloader.loader.getResult("buttons pause anim"), 0);

        info = this.preloader.loader.getResult("font2Json");
        info.images[0] = this.preloader.loader.getResult("font2.png");
        createFontFrames(info);
        this.atlases.push(new createjs.SpriteSheet(info)); //1 - font

        info = this.preloader.loader.getResult("artEpisodeJson");
        info.images[0] = this.preloader.loader.getResult("artEpisode");
        this.atlases.push(new createjs.SpriteSheet(info)); //2 - episode

        if (!Match3Level.pool)
            Match3Level.pool = new ObjectPool();
        Match3Level.instance = new Match3Level();
        this.soundManager = new SoundsManager();

        this.stage.removeAllEventListeners();
        this.stage.addEventListener("stagemousedown", function (e) {
            _this.onDown(e);
        });
        this.stage.addEventListener("stagemouseup", function (e) {
            _this.onUp(e);
        });
        this.menuManager = new MenuManager();

        //this.menuManager.show(this.menuManager.map);
        splashScreenData = apiInstance ? apiInstance.Branding.getSplashScreen() : null;
        this.preloader.disable();

        this.menuManager.show(this.menuManager.mainMenu, true);

        //this.menuManager.show(this.menuManager.loseMenu, false);
        this.resize();

        // this.loadLevel();
        //this.soundManager.playMusic();
        this.setVisibilityListener();
    };

    App.prototype.update = function (event) {
        if (this.isPaused)
            return;

        //try {
        this.stage.update(event);

        //console.log(this.stage.getNumChildren());
        if (App.level && App.level.isActive)
            App.level.update(event.delta / 1000);

        //App.level.updateFpsText();
        if (this.menuManager)
            this.menuManager.update(event.delta / 1000);

        if (this.preloader)
            this.preloader.update(event.delta / 1000);
        if (this.soundManager)
            this.soundManager.update(event.delta / 1000);

        this.gameTime += event.delta / 1000;
        this.timeSinceAds += event.delta / 1000;
        //}
        //catch (Error) {
        //    alert("main loop error " + Error);
        //}
    };

    App.prototype.onPreloaderDown = function (event) {
        this.preloader.onDown(event.stageX, event.stageY);

        event.nativeEvent && event.preventDefault && event.preventDefault() && event.stopPropagation();
    };

    App.prototype.onDown = function (event) {
        if (this.isPaused)
            return;

        //alert(createjs.Sound.activePlugin.toString());
        this.soundManager.playMusic();
        //var activeMenu = MenuManager.instance.credits.isMenuActive ? MenuManager.instance.credits : MenuManager.instance.promotionMenu;
       var current = MenuManager.instance.credits.isMenuActive  && MenuManager.instance.mainMenu.isMenuActive ? MenuManager.instance.credits : MenuManager.instance.current;
        current = MenuManager.instance.lockMenu.isMenuActive && MenuManager.instance.mainMenu.isMenuActive ? MenuManager.instance.lockMenu : current;
      var wasTarget = current == this.menuManager.target;
        if (current)
            current.onDown(event.stageX, event.stageY);

        var isTutorialLocked = current == Tutorial.instance && !Tutorial.instance.tapAllowed;
        if (App.level && !wasTarget && !isTutorialLocked)
            App.level.onMouseDown(event.stageX, event.stageY);
        else if (isTutorialLocked)
            App.level.onHudDown(event.stageX, event.stageY);

        event.nativeEvent && event.preventDefault && event.preventDefault() && event.stopPropagation();
    };

    App.prototype.onUp = function (event) {
        if (this.isPaused)
            return;

        this.soundManager.playMusic();
        //var activeMenu = MenuManager.instance.credits.isMenuActive ? MenuManager.instance.credits : MenuManager.instance.promotionMenu;
       var current = MenuManager.instance.credits.isMenuActive  ? MenuManager.instance.credits : MenuManager.instance.current;
        current = MenuManager.instance.lockMenu.isMenuActive  ? MenuManager.instance.lockMenu : current;
        if (current)
        if (current)
            current.onUp(event.stageX, event.stageY);

        event.nativeEvent && event.preventDefault && event.preventDefault() && event.stopPropagation();
    };

    App.prototype.resize = function () {
        //return;
        //window.scrollTo(0, 1);
        var fixedSize = !this.isPlayingOnMobile;
        var factor = 1;
        var fixedW = App.SCREEN_W * factor;
        var fixedH = App.FULL_SCREEN_H * factor;
        fixedSize = fixedSize && window.innerWidth > fixedW && window.innerHeight > fixedH;

        var windowWidth = fixedSize ? fixedW : window.innerWidth, windowHeight = fixedSize ? fixedH : window.innerHeight;
        var stage = this.stage;
        var f = windowWidth, g = windowHeight;
        var lock = document.getElementById("portraitLock");

        if (isOrientationLocked()) {
            lock.style.display = "block";
            stage.canvas.style.display = "none";
        } else {
            lock.style.display = "none";
            stage.canvas.style.display = "block";

            var canvasWidth = stage.canvas.width, canvasHeight = stage.canvas.height, wFactor = windowWidth / canvasWidth, hFactor = windowHeight / App.SCREEN_H, minFactor = Math.min(wFactor, hFactor);

            //console.log(canvasWidth, windowWidth);
            var newWidth = canvasWidth * minFactor, newHeight = canvasHeight * minFactor;
            stage.canvas.style.width = newWidth + "px";
            stage.canvas.style.height = newHeight + "px";
            App.ACTUAL_H = limit(App.SCREEN_H * hFactor / minFactor, App.SCREEN_H, App.FULL_SCREEN_H);

            //console.log(App.ACTUAL_H);
            var o = (windowHeight - newHeight) / 2, p = stage.canvas.parentElement;

            //App.SHIFT_H = (windowHeight - newHeight) / 2;
            App.CURRENT_SHIFT = o / minFactor;

            //this.stage.canvas.parentElement.style.top = 100 + "px";
            //0 > o ? (stage.canvas.style.top = o + "px", p.style.height = newHeight + 2 * o + "px") : (stage.canvas.style.top = "0px", p.style.height = newHeight + "px"), p.style.width = newWidth + "px";
            stage.canvas.style.top = o + "px";

            //this.backStage.canvas.parentElement.style.top = this.stage.canvas.parentElement.style.top;
            this.stage.canvas.style.left = (window.innerWidth - newWidth) / 2 + "px";
            if (fixedSize)
                this.stage.canvas.style.top = (window.innerHeight - newHeight) / 2 + "px";
            //p.style.left = q + "px", p.style.top = o > 0 ? o + "px" : "0px"
        }

        if (this.menuManager)
            this.menuManager.onResize();

        if (this.preloader)
            this.preloader.onResize();
    };

    App.prototype.setVisibilityListener = function () {
        var _this = this;
        var hidden = "hidden";
        var callback = function () {
            return _this.onVisibilityChange();
        };
        if (hidden in document) {
            document.addEventListener("visibilitychange", callback);
            this.visibilityState = "visibilityState";
        } else if ((hidden = "mozHidden") in document) {
            document.addEventListener("mozvisibilitychange", callback);
            this.visibilityState = "mozVisibilityState";
        } else if ((hidden = "webkitHidden") in document) {
            document.addEventListener("webkitvisibilitychange", callback);
            this.visibilityState = "webkitVisibilityState";
        } else if ((hidden = "msHidden") in document) {
            document.addEventListener("msvisibilitychange", callback);
            this.visibilityState = "msVisibilityState";
        } else if ('onfocusin' in document)
            document.onfocusin = document.onfocusout = callback;
        else
            window.onpageshow = window.onpagehide = window.onfocus = window.onblur = callback;
    };

    App.prototype.onVisibilityChange = function () {
        var hidden = this.visibilityState && document[this.visibilityState] && document[this.visibilityState] == "hidden";
        if (SoundsManager.instance.musicPaused && !hidden)
            SoundsManager.instance.resumeMusic();
        else if (hidden && !SoundsManager.instance.musicPaused)
            SoundsManager.instance.pauseMusic();
    };
    App.SCREEN_W = 640;
    App.SCREEN_H = 712 + 30;
    App.FULL_SCREEN_H = 960;
    App.ACTUAL_H = App.SCREEN_H;
    App.SHIFT_H = (App.FULL_SCREEN_H - App.SCREEN_H) / 2;
    App.CURRENT_SHIFT = 0;

    var currentEpisode = localStorage.getItem("current_episode");

    if(currentEpisode != undefined){
        App.episode = currentEpisode;
    }else{
        App.episode = 1;
    }
    
    return App;
})();

function touchHandlerDummy(e) {
    e.preventDefault();
    return false;
}
var ActionType;
(function (ActionType) {
    ActionType[ActionType["ACTION_STOP"] = 0] = "ACTION_STOP";
    ActionType[ActionType["ACTION_GOTO_AND_PLAY"] = 1] = "ACTION_GOTO_AND_PLAY";
    ActionType[ActionType["ACTION_GOTO_AND_STOP"] = 2] = "ACTION_GOTO_AND_STOP";
})(ActionType || (ActionType = {}));
;

var FrameSelector = (function () {
    function FrameSelector(o) {
        this.object = o;
        this.names = new Array();
        this.values = new Array();
    }
    FrameSelector.prototype.getFrame = function (s, l) {
        return 0;
    };
    FrameSelector.prototype.testLayer = function (name) {
        return true;
    };
    return FrameSelector;
})();
;

var SingleFlameSelector = (function (_super) {
    __extends(SingleFlameSelector, _super);
    function SingleFlameSelector(n) {
        _super.call(this, null);
        this.frame = n;
    }
    SingleFlameSelector.prototype.getFrame = function (s, l) {
        return this.frame;
    };
    return SingleFlameSelector;
})(FrameSelector);

var AnimatedNode = (function (_super) {
    __extends(AnimatedNode, _super);
    function AnimatedNode(d, f, fs) {
        _super.call(this);

        this.animation = d;
        this.parts = new Array();
        this.isPlaying = true;
        this.actions = new Array();
        this.hasCycle = false;
        this.owner = null;
        this.skins = new Array();
        this.frameSelector = fs;
        this.initFrameDelay = f;

        this.initParts();
        this.mouseChildren = false;
        //createjs.Ticker.addEventListener("tick", this.update.bind(this));
    }
    AnimatedNode.prototype.createUsualSprite = function (name) {
        return createSpriteFromSpritesheet(name);
    };

    AnimatedNode.prototype.initParts = function () {
        this.setFrameDelay(this.animation.forceFrameDelay > 0 ? this.animation.forceFrameDelay : Math.abs(this.initFrameDelay) < 1e-10 ? 1 / DESIGN_FPS : this.initFrameDelay);
        this.totalFrames = 1;
        for (var i = 0; i < this.animation.layers.length; i++) {
            var layerData = this.animation.layers[i];

            if (this.frameSelector && !this.frameSelector.testLayer(this.animation.name))
                continue;
            this.totalFrames = Math.max(this.totalFrames, layerData.frames.length);

            var skin = this.frameSelector ? this.frameSelector.getFrame(this, layerData) : 0;

            if (skin != -1) {
                this.skins.push(skin);
                var c = new createjs.Container();
                var s = null;
                var clipData = layerData.getClipData(skin);
                s = this.createUsualSprite(clipData.name);
                s.regX = s.getBounds().width * clipData.anchor.x;
                s.regY = s.getBounds().height * (1 - clipData.anchor.y);
                c.addChild(s);
                this.parts.push(c);
                this.addChild(c);
            } else {
                this.skins.push(-1);
                this.parts.push(null);
            }
        }

        this.gotoAndPlay(0);
        if (this.animation.transform)
            this.animation.transform.applyTransform(this);

        if (this.totalFrames <= 1)
            this.stop();

        if (this.frameSelector) {
            this.frameSelector = null;
        }

        if (this.animation && this.animation.isAdd) {
            //GameUtils::setRecursiveAddBlending(this);
        }

        if (this.animation && this.animation.isOverlay) {
            // GameUtils::setRecursiveOverlayBlending(this);
        }
    };

    AnimatedNode.prototype.getFrameByPartIndex = function (i) {
        var data = this.animation;
        var frameAt = i;
        var frame = data.layers[frameAt].frames[this.currentFrame];
        return frame;
    };

    AnimatedNode.prototype.disableLayer = function (name) {
        var p = this.getPartByFlashName(name);
        if (p)
            removeClip(p);
    };

    AnimatedNode.prototype.update = function (dt) {
        //var dt: number = event.delta / 1000;
        limitDt(dt);

        if (this.isPlaying) {
            this.currentDelay -= dt;
            while (this.currentDelay <= 0) {
                this.gotoAndPlay(this.currentFrame + 1);
                for (var i = 0; i < this.actions.length; i++)
                    this.actions[i].checkAction();
                this.currentDelay += this.frameDelay;
                if (this.currentFrame == 0)
                    this.hasCycle = true;
            }
        }
    };

    AnimatedNode.prototype.setRandomFrame = function () {
        var frame = getInt(this.totalFrames);
        if (this.isPlaying)
            this.gotoAndPlay(frame);
        else
            this.gotoAndStop(frame);
    };

    AnimatedNode.prototype.setFrameDelay = function (delay) {
        this.currentDelay = this.frameDelay = delay;
    };

    AnimatedNode.prototype.setFps = function (fps) {
        this.setFrameDelay(1 / fps);
    };

    AnimatedNode.prototype.isOnLastFrame = function () {
        return this.currentFrame == this.totalFrames - 1;
    };

    AnimatedNode.prototype.setOwner = function (g) {
        this.owner = g;
    };
    AnimatedNode.prototype.getOwner = function () {
        return this.owner;
    };

    AnimatedNode.prototype.gotoAndPlay = function (frame) {
        this.play();
        this.currentFrame = Math.max(0, frame);
        this.currentFrame = this.currentFrame % this.totalFrames;
        for (var i = 0; i < this.parts.length; i++) {
            var s = this.parts[i];
            if (s) {
                var data = this.animation;
                var frameAt = i;
                var fd = data.layers[frameAt].frames[this.currentFrame];
                fd.applyTransform(s);
                if (this.owner)
                    s.visible = s.visible && this.owner.canBeVisible(s);
            }
        }

        var prevFrame = this.currentFrame;
        for (i = 0; i < this.actions.length; i++) {
            this.actions[i].checkAction();
            if (this.currentFrame != prevFrame)
                return;
        }
    };

    AnimatedNode.prototype.gotoAndStop = function (f) {
        this.gotoAndPlay(f);
        this.stop();
    };

    AnimatedNode.prototype.play = function () {
        if (!this.isPlaying)
            this.resetFrameDelay();
        this.isPlaying = true;
    };

    AnimatedNode.prototype.stop = function () {
        this.isPlaying = false;
        this.resetFrameDelay();
    };

    AnimatedNode.prototype.resetFrameDelay = function () {
        this.currentDelay = this.frameDelay;
    };

    AnimatedNode.prototype.getCurrentDelay = function () {
        return this.currentDelay;
    };
    AnimatedNode.prototype.setCurrentDelay = function (f) {
        this.currentDelay = this.frameDelay * f;
    };

    AnimatedNode.prototype.getFloatFrame = function () {
        return this.currentFrame + limit((this.frameDelay - this.currentDelay) / this.frameDelay, 0, 1);
    };

    AnimatedNode.prototype.setPartSkin = function (flashName, skin, shift) {
        if (typeof shift === "undefined") { shift = false; }
        var i = this.animation.getLayerByFlashName(flashName);
        var s = this.parts[i].getChildAt(0);
        var ld = this.animation.layers[i];
        if (shift)
            skin = ld.clipDatas.length + skin;
        this.skins[i] = skin;
        var clipData = ld.getClipData(skin);

        s.gotoAndStop(clipData.name);
        s.regX = s.getBounds().width * clipData.anchor.x;
        s.regY = s.getBounds().height * (1 - clipData.anchor.y);
    };

    AnimatedNode.prototype.getPart = function (i) {
        return this.parts[i];
    };
    AnimatedNode.prototype.getPartByFlashName = function (name) {
        return this.getPart(this.animation.getLayerByFlashName(name));
    };

    AnimatedNode.prototype.getPartSkin = function (i) {
        return this.skins[i];
    };
    AnimatedNode.prototype.getPartSkinByName = function (part) {
        return this.getPartSkin(this.animation.getLayerByFlashName(part));
    };
    AnimatedNode.prototype.getSkinByFlashName = function (name) {
        return this.getPartSkin(this.animation.getLayerByFlashName(name));
    };

    AnimatedNode.prototype.updateOwnerVisibility = function () {
        for (var i = 0; i < this.parts.length; i++) {
            var s = this.parts[i];
            if (s && this.owner)
                s.visible = s.visible && this.owner.canBeVisible(s);
        }
    };

    AnimatedNode.prototype.destroy = function () {
        this.skins = null;
        this.frameSelector = null;

        for (var i = 0; i < this.parts.length; i++) {
            if (this.parts[i])
                removeClip(this.parts[i]);
        }

        this.owner = null;
        this.parts = null;
        this.actions = null;
    };

    AnimatedNode.prototype.addAction = function (frame, type, data, p) {
        if (typeof data === "undefined") { data = -1; }
        if (typeof p === "undefined") { p = 1; }
        var a = new AnimationAction(frame, type, this, data, p);
        this.actions.push(a);
        return a;
    };
    return AnimatedNode;
})(createjs.Container);
;

var FrameData = (function () {
    function FrameData(v, a, r, _x, _y, scX, scY, skX, skY) {
        if (typeof a === "undefined") { a = 100; }
        if (typeof r === "undefined") { r = 0; }
        if (typeof _x === "undefined") { _x = 0; }
        if (typeof _y === "undefined") { _y = 0; }
        if (typeof scX === "undefined") { scX = 1; }
        if (typeof scY === "undefined") { scY = 1; }
        if (typeof skX === "undefined") { skX = 0; }
        if (typeof skY === "undefined") { skY = 0; }
        this.visible = v;
        this.alpha = a;
        this.rotation = r;
        this.x = _x;
        this.y = _y;
        this.scaleX = scX;
        this.scaleY = scY;
        this.skewX = skX;
        this.skewY = skY;
    }
    FrameData.prototype.clone = function () {
        return new FrameData(this.visible, this.alpha, this.rotation, this.x, this.y, this.scaleX, this.scaleY);
    };
    FrameData.prototype.applyTransform = function (s) {
        s.visible = this.visible;

        if (!s.visible)
            return;

        s.alpha = this.alpha;
        s.rotation = this.rotation;
        s.x = this.x;
        s.y = this.y;
        s.scaleX = this.scaleX;
        s.scaleY = this.scaleY;
        s.skewX = this.skewX;
        s.skewY = this.skewY;
    };

    FrameData.getEmptyData = function () {
        if (!FrameData.empty)
            FrameData.empty = new FrameData(false, 0, 0, 0, 0, 0, 0);
        return FrameData.empty;
    };
    return FrameData;
})();
;

var ClipLayerData = (function () {
    function ClipLayerData(_name, tl) {
        this.name = _name.split(".")[0];
        this.anchor = tl;
    }
    return ClipLayerData;
})();
;

var LayerData = (function () {
    function LayerData(n, _flashName, mark) {
        this.isMark = mark;
        this.frames = new Array();
        this.name = n;
        this.flashName = _flashName;
        this.clipDatas = new Array();
    }
    LayerData.prototype.addFrame = function (f) {
        this.frames.push(f);
    };
    LayerData.prototype.addClipData = function (c) {
        this.clipDatas.push(c);
    };
    LayerData.prototype.getClipData = function (i) {
        return name == "none" ? null : i < this.clipDatas.length ? this.clipDatas[i] : this.clipDatas[this.clipDatas.length - 1];
    };
    LayerData.prototype.clone = function () {
        var res = new LayerData(this.name, this.flashName, false);
        for (var i = 0; i < this.clipDatas.length; i++)
            res.addClipData(new ClipLayerData(this.clipDatas[i].name, this.clipDatas[i].anchor));
        for (i = 0; i < this.frames.length; i++)
            res.addFrame(frames[i].clone());
        return res;
    };
    return LayerData;
})();
;

var AnimationData = (function () {
    function AnimationData(_name, f) {
        this.layerNameMap = {};
        this.layers = new Array();
        this.animationDatas = new Array();
        this.name = _name;
        this.transform = f;
        this.isAdd = false;
        this.forceFrameDelay = -1;
        this.isOverlay = false;
    }
    AnimationData.prototype.setAdd = function () {
        this.isAdd = true;
        return this;
    };

    AnimationData.prototype.setScale = function (scaleFactor, newScale) {
    };

    AnimationData.prototype.shift = function (x, y) {
        return this;
    };

    AnimationData.prototype.addLayer = function (f) {
        var i = this.layers.length;
        this.layerNameMap[f.flashName] = i;
        this.layers.push(f);
    };
    AnimationData.prototype.addData = function (d) {
        this.animationDatas.push(d);
    };
    AnimationData.prototype.getLayerByFlashName = function (name) {
        return this.layerNameMap[name];
    };
    AnimationData.prototype.connectLayers = function (layerNames) {
        return this;
    };

    AnimationData.prototype.makeTheSameAmountOfFramesInAllLayers = function () {
        var totalFrames = 0;
        for (var i = 0; i < this.layers.length; ++i)
            totalFrames = Math.max(totalFrames, this.layers[i].frames.length);

        for (i = 0; i < this.layers.length; ++i) {
            var layer = this.layers[i];
            while (layer.frames.length < totalFrames)
                layer.addFrame(FrameData.getEmptyData());
        }
    };
    AnimationData.prototype.cloneLayer = function (from, to) {
        var fromLayerIndex = this.getLayerByFlashName(from);
        var toLayerIndex = this.getLayerByFlashName(to);
        this.layers[toLayerIndex].frames = this.layers[fromLayerIndex].frames;
    };
    return AnimationData;
})();
;

var AnimationManager = (function () {
    function AnimationManager() {
        this.data = {};
        AnimationManager.instance = this;
        this.data = {};
        //this.putAnimation("Char", charAnim, 0);
    }
    AnimationManager.prototype.putAnimation = function (name, o, shift) {
        var a = this.parseAnimation(o, shift);
        this.data[name] = a;
        return a;
    };

    AnimationManager.prototype.parseAnimation = function (o, shift) {
        var animation = new AnimationData(o.name, null);

        var totalFrames = 0;
        var lsize = o.l.length == undefined ? 1 : o.l.length;
        for (var lIndex = 0; lIndex < lsize; ++lIndex) {
            var lData = lsize == 1 ? o.l : o.l[lIndex];
            var flashName = lData.flashName;
            var isMark = lData.isMark != undefined;
            var layer = new LayerData(lData.name, flashName ? flashName : "", isMark);

            var cSize = lData.d.length == undefined ? 1 : lData.d.length;
            for (var cIndex = 0; cIndex < cSize; ++cIndex) {
                var cData = cSize == 1 ? lData.d : lData.d[cIndex];
                var path = cData.name;
                var pathParts = path.split("/");
                var dataName = pathParts[pathParts.length - 1];
                var originalAnchorX = parseFloat(cData.anchorX);
                var originalAnchorY = parseFloat(cData.anchorY);
                var cDataX = new ClipLayerData(dataName, new createjs.Point(originalAnchorX, originalAnchorY > 0 ? 1 - originalAnchorY : 1 - originalAnchorY));
                layer.addClipData(cDataX);
            }

            for (var i = 0; i < shift; i++)
                layer.addFrame(FrameData.getEmptyData());

            var fSize = lData.f.length == undefined ? 1 : lData.f.length;
            for (var frameNumber = 0; frameNumber < fSize; ++frameNumber) {
                var frame = null;
                var frameNode = fSize == 1 ? lData.f : lData.f[frameNumber];
                var visible = frameNode.v != undefined && frameNode.v != null ? frameNode.v : true;

                if (!visible) {
                    frame = FrameData.getEmptyData();
                } else {
                    var alpha = visible ? (frameNode.a != undefined ? parseFloat(frameNode.a) : 100) : 0;
                    alpha /= 100;
                    var rotation = visible ? parseFloat(frameNode.r) : 0;
                    var x = visible ? parseFloat(frameNode.x) : 0;
                    var y = visible ? parseFloat(frameNode.y) : 0;
                    var scaleX = visible ? parseFloat(frameNode.scX) : 0;
                    var scaleY = visible ? parseFloat(frameNode.scY) : 0;
                    var skewX = visible ? parseFloat(frameNode.skX) : 0;
                    var skewY = visible ? parseFloat(frameNode.skY) : 0;
                    frame = new FrameData(visible, alpha, rotation, x, y, scaleX, scaleY, skewX, skewY);
                }
                layer.addFrame(frame);
            }
            animation.addLayer(layer);
            totalFrames = Math.max(totalFrames, frameNumber);
        }

        animation.makeTheSameAmountOfFramesInAllLayers();

        return animation;
    };

    AnimationManager.prototype.getAnimation = function (s) {
        return this.data[s];
    };
    return AnimationManager;
})();
;

var AnimationAction = (function () {
    function AnimationAction(f, t, a, d, p) {
        this.frame = f;
        this.type = t;
        this.animation = a;
        this.data = d;
        this.probability = p;
        this.isEnabled = true;
        this.frameSelector = null;
    }
    AnimationAction.prototype.checkAction = function () {
        if (this.isEnabled && this.animation.currentFrame == this.frame && this.animation.isPlaying && Math.random() <= this.probability) {
            switch (this.type) {
                case 0 /* ACTION_STOP */:
                    this.animation.stop();
                    break;
                case 1 /* ACTION_GOTO_AND_PLAY */:
                    this.animation.gotoAndPlay(this.calcNextFrame());
                    break;
                case 2 /* ACTION_GOTO_AND_STOP */:
                    this.animation.gotoAndStop(this.data);
                    break;
            }
        }
    };
    AnimationAction.prototype.calcNextFrame = function () {
        var res = !this.frameSelector ? this.data : this.frameSelector.selectFrame(this.frame);
        if (res == -1)
            res = this.data;
        return res;
    };

    AnimationAction.prototype.setSelector = function (f) {
        this.frameSelector = f;
    };
    AnimationAction.prototype.setEnabled = function (e) {
        this.isEnabled = e;
    };
    AnimationAction.prototype.getEnabled = function () {
        return this.isEnabled;
    };
    return AnimationAction;
})();
;

function getButtonAnimation(frame) {
    var a = new AnimatedNode(App.game.animationManager.getAnimation("buttons anim"), 1 / 30, new SingleFlameSelector(frame));
    a.addAction(a.totalFrames - 1, 0 /* ACTION_STOP */);
    return a;
}
var Hud = (function (_super) {
    __extends(Hud, _super);
    function Hud() {
        var _this = this;
        _super.call(this);
        this.sprites = [];
        this.currentPercent = 0;
        this.barScale = 0.9;
        this.currentMoves = -1;
        this.currentTarget = "";
        this.currentScore = 0;
        this.starScales = [0.4, 0.75, 1];
        this.stars = [];
        this.clickables = [];
        this.starsEarned = [false, false, false];
        this.shuffleText = new createjs.Container();
        var sprite = new createjs.Container();
        this.sprite = sprite;
        addChild(this.sprite, this.level.hudLayer);
        var s = this.sprite;

        var names = ["border_down", "border_top", "border_left", "border_right", "border"];
        var positions = [cjp(0, 762 - 37), cjp(0, 0), cjp(0, 103), cjp(App.SCREEN_W, 103), cjp(0, 0)];
        var regs = [cjp(0, 58), cjp(0, 0), cjp(0, 0), cjp(35, 0), cjp(0, 0)];
        for (var i = 0; i < 4; ++i) {
            var border = createSpriteFromSpritesheet(names[i]);
            border.x = positions[i].x;
            border.y = positions[i].y + App.SHIFT_H;
            if (App.episode == 3 || App.episode == 4)
                border.x -= 1;

            //if (App.episode == 4 && i == 0)
            //    border.x -= 1;
            border.regX = regs[i].x;
            border.regY = regs[i].y;
            s.addChild(border);
        }

        //var b1: createjs.Sprite = createSpriteFromSpritesheet("progressbar bpttom");
        var b2 = new createjs.Bitmap(App.game.preloader.loader.getResult("bar"));

        //var b3: createjs.Sprite = createSpriteFromSpritesheet("moves");
        var b4 = createBitmap(App.episode == 3 ? "logo down" : "logo top");
        var b5 = createBitmap("logo top");

        //if (App.episode != 4)
        //     addChild(b1, sprite);
        addChild(b2, sprite);

        //if (App.episode != 4)
        //   addChild(b3, sprite);
        this.barRect = b2.getBounds().clone();
        this.bar = b2;

        b2.x = 326 + 78 - 7 - 25 + 27 - 5 - 2;
        b2.y = -5 + App.SHIFT_H + 5 + 15 + 2 - 2;
        b2.scaleX = b2.scaleY = this.barScale;

        b4.x = 0;
        if (App.episode == 3) {
            b4.y = App.FULL_SCREEN_H - b4.getBounds().height + 50;
        } else {
            b4.regX = 640;
            b4.y = App.FULL_SCREEN_H - b4.getBounds().height - 105 + App.SHIFT_H + 120 - 3 + 21;
            b4.scaleX = -1;
            b4.scaleY = -1;
        }

        b5.x = 0;
        b5.y = App.SHIFT_H - b5.getBounds().height + 2;

        this.sprites.push(b5, this.sprite, null, b2, null, b4);

        var t = new createjs.BitmapText("xxx", App.game.atlases[1]);
        t.letterSpacing = -11;
        t.scaleX = t.scaleY = 0.9;
        this.movesText = t;
        sprite.addChild(this.movesText);

        var t = new createjs.BitmapText("1", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.scaleX = t.scaleY = 1;
        this.targetText = t;
        sprite.addChild(this.targetText);

        var t = new createjs.BitmapText("score", App.game.atlases[0]);
        t.letterSpacing = -10;
        this.scoreText = t;
        t.x = 100;
        t.getBounds();
        t.x = 1000;
        var rx = t.getBounds();
        sprite.addChild(this.scoreText);

        var t = new createjs.BitmapText("x", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.scaleX = t.scaleY = 0.6;
        t.x = 240 - 15;
        t.y = App.SHIFT_H + 2 + 10;
        this.targetXText = t;
        sprite.addChild(this.targetXText);

        var m = createSpriteFromSpritesheet("cookie");
        m.x = 210 - 15;
        m.y = App.SHIFT_H + 45;
        sprite.addChild(m);
        this.targetIcon = m;

        for (var i = 0; i < 3; ++i) {
            m = createSpriteFromSpritesheet("progressbar star");
            m.regX = m.getBounds().width / 2;
            m.regY = m.getBounds().height * 1.25;
            var minX = b2.x + 5 - 25;
            var maxX = b2.x + b2.getTransformedBounds().width - 3;
            m.y = App.SHIFT_H + 9 + m.regY;
            sprite.addChild(m);
            m.x = lerp(minX, maxX, this.starScales[i]);
            this.stars.push(m);
        }

        this.pauseButton = createSpriteFromSpritesheet("pause button");
        this.pauseButton.scaleX = -1;
        this.pauseButton.x = App.SCREEN_W + 10;
        this.pauseButton.y = App.SHIFT_H - 0.5;
        sprite.addChild(this.pauseButton);

        var bc = new ClickableObject(this.pauseButton);
        bc.setCircle(85, 0, 0);
        bc.callback = function () {
            _this.pauseLevel();
        };
        this.clickables.push(bc);

        this.logo = new LogoObject(sprite, 80, 830 - 3, 0.8);
        this.clickables.push(this.logo);

        for (var i = 0; i < 2; ++i) {
            var t = new createjs.BitmapText(i == 0 ? "no possible" : "moves!", App.game.atlases[1]);
            t.letterSpacing = -10;
            t.spaceWidth = 25;
            t.x = i == 0 ? -220 : -125;
            t.y = i == 0 ? 0 : 65;
            this.shuffleText.addChild(t);
        }

        //sprite.addChild(this.shuffleText);
        //this.shuffleText.x = App.SCREEN_W / 2;
        //this.shuffleText.y = App.SHIFT_H + 400;
        this.update(0);
    }
    Hud.prototype.playShuffleAnimation = function () {
        var _this = this;
        this.sprite.addChild(this.shuffleText);
        this.shuffleText.x = App.SCREEN_W / 2;
        this.shuffleText.y = App.SHIFT_H + 400;
        this.shuffleText.alpha = 0;

        createjs.Tween.get(this.shuffleText, { loop: false }).to({ alpha: 1, y: this.shuffleText.y - 200 }, 400, createjs.Ease.quadInOut).wait(300).to({ alpha: 0, y: this.shuffleText.y - 400 }, 400, createjs.Ease.quadIn).call(function () {
            return _this.stopShuffle();
        });
    };

    Hud.prototype.onDown = function (x, y) {
        var len = this.clickables.length;
        for (var i = 0; i < len; ++i) {
            var c = this.clickables[i];
            if (c && c.checkClick(x, y)) {
                c.onClick();
                break;
            }
        }
    };

    Hud.prototype.onHudUp = function (x, y) {
    };

    Hud.prototype.stopShuffle = function () {
        removeClip(this.shuffleText);
    };

    Hud.prototype.isShuffleActive = function () {
        return this.shuffleText.parent != null;
    };

    Hud.prototype.show = function () {
        this.currentMoves = -1;
        this.currentTarget = "";
        this.currentScore = -1;
        this.currentPercent = 0;
        this.bar.sourceRect = new createjs.Rectangle(0, 0, limit(this.barRect.width * 0, 1, this.barRect.width), this.barRect.height);

        for (var i = 0; i < 3; ++i)
            this.starsEarned[i] = false;

        addChild(this.sprites[0], this.level.backLayer); // this.level.hudLayer);
        addChild(this.sprites[5], this.level.backLayer); //this.level.hudLayer);
        this.level.needToUpdateBack = true;

        this.scores = Match3Level.instance.target.scores;

        var texts = Match3Level.instance.target.getText();
        this.targetIcon.gotoAndStop(texts[2]);
        this.targetIcon.regX = this.targetIcon.getBounds().width / 2;
        this.targetIcon.regY = this.targetIcon.getBounds().height / 2;
        this.targetIcon.scaleX = this.targetIcon.scaleY = 55 / this.targetIcon.getBounds().width; //Math.max(this.targetIcon.getBounds().width, this.targetIcon.getBounds().height);

        removeClip(this.shuffleText);
        this.logo.setVisible(true);

        this.update(0);
    };

    Hud.prototype.pauseLevel = function () {
        if (MenuManager.instance.target.sprite.parent || (Match3Level.instance.isWaitingForTarget && !Match3Level.instance.isHardLocked) || MenuManager.instance.current == MenuManager.instance.tutorial)
            return;

        this.level.pause();
        SoundsManager.instance.playSound("pause");
    };

    Hud.prototype.updateBar = function (dt) {
        var p = Match3Level.instance.score / this.scores[2];
        p = limit(p, 0, 1);
        var dp = p - this.currentPercent;
        var modulo = 0.005 * 60 * dt;
        if (Math.abs(dp) <= modulo)
            this.currentPercent = p;
        else
            this.currentPercent += modulo * dp / Math.abs(dp);

        //convert progress to scale
        var len = this.scores.length;
        var scale = 1;
        for (var i = 0; i < len; ++i) {
            var min = i == 0 ? 0 : this.scores[i - 1] / this.scores[2];
            var max = this.scores[i] / this.scores[2];
            if (this.currentPercent >= min && this.currentPercent <= max) {
                //if (i != 0)
                //trace();
                scale = lerp(i == 0 ? 0 : this.starScales[i - 1], this.starScales[i], (this.currentPercent - min) / (max - min));
                break;
            }
        }
        this.bar.sourceRect = new createjs.Rectangle(0, 0, limit(this.barRect.width * scale, 1, this.barRect.width), this.barRect.height);

        var earned = i - 1;
        if (earned >= 0 && !this.starsEarned[earned]) {
            this.starsEarned[earned] = true;
            this.stars[earned].scaleY = 2.5;
            this.stars[earned].scaleX = 2;
            createjs.Tween.get(this.stars[earned], { loop: false }).wait(0).to({ scaleY: 1, scaleX: 1 }, 400, createjs.Ease.quadOut);
        }
    };

    Hud.prototype.forceFullUpdate = function () {
        this.updateBar(10);
        this.scoreText.text = Match3Level.instance.score.toString();
    };

    Object.defineProperty(Hud.prototype, "starEarnedAmount", {
        get: function () {
            var res = 0;
            for (var i = 0; i < 3; ++i)
                if (this.starsEarned[i])
                    res++;
            return res;
        },
        enumerable: true,
        configurable: true
    });

    Hud.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        //this.sprite.visible = false;
        //removeClip(Match3Level.instance.fpsText);
        //Match3Level.instance.addChild(Match3Level.instance.fpsText);
        if (Match3Level.instance && this.scores)
            this.updateBar(dt);

        if (this.level.target && this.level.target.isCompleted && (!this.level.target.isScoreTarget || this.level.movesLeft <= 0))
            //this.level.onWin();
            this.level.starMoveAwardMode();

        //console.log(this.level.hudLayer.getBounds().width, this.level.hudLayer.getBounds().height, this.sprite.getBounds().width, this.sprite.getBounds().height, this.scoreText.getBounds().x);
        var moves = Match3Level.instance.movesLeft;
        if (this.currentMoves != moves) {
            createjs.Tween.removeTweens(this.movesText);
            this.currentMoves = moves;
            this.movesText.text = moves.toString();
            this.movesText.scaleX = this.movesText.scaleY = 0.9;
            var size = getTextSize(this.movesText);
            this.movesText.regX = size.x / 2;
            this.movesText.regY = 62;
            this.movesText.x = 117 - 10;
            this.movesText.y = App.SHIFT_H + 2 + 77 - 22;
            this.movesText.scaleY = 1.5;
            createjs.Tween.get(this.movesText, { loop: false }).wait(0).to({ scaleY: 1 }, 200, createjs.Ease.quadOut);
        }

        if (Match3Level.instance && Match3Level.instance.target) {
            var target = Match3Level.instance.target.getTargetText();
            if (target != this.currentTarget) {
                createjs.Tween.removeTweens(this.targetText);
                this.currentTarget = target;
                var isX = target.charAt(0) == "x";
                this.targetXText.visible = isX;
                var text = isX ? target.substr(1, target.length - 1) : target;
                this.targetText.text = text;

                var size = getTextSize(this.targetText);
                this.targetText.regX = 0;
                this.targetText.regY = size.y * 1.5;

                this.targetText.x = isX ? (this.targetXText.x + 32 - 5) : this.targetXText.x;
                this.targetText.y = App.SHIFT_H + 1 + 59 + 2;
                this.targetText.scaleY = 2;
                createjs.Tween.get(this.targetText, { loop: false }).wait(0).to({ scaleY: 1 }, 200, createjs.Ease.quadOut);
            }
        }

        var score = Match3Level.instance.score;
        if (this.currentScore != score) {
            createjs.Tween.removeTweens(this.scoreText);
            this.currentScore = score;
            this.scoreText.text = score.toString();

            var size = getTextSize(this.scoreText);
            this.scoreText.regX = size.x / 2;
            this.scoreText.regY = size.y * 1.5;

            this.scoreText.x = 508 - 25;
            this.scoreText.y = App.SHIFT_H + 2 + 122 - 37 - 0;
            this.scoreText.scaleY = 1 * 2;
            createjs.Tween.get(this.scoreText, { loop: false }).wait(0).to({ scaleY: 1 }, 200, createjs.Ease.quadOut);
        }
    };

    Hud.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };

    Hud.prototype.reset = function () {
        this.currentPercent = 0;
        removeClip(this.sprite);
        addChild(this.sprite, this.level.hudLayer);
    };
    return Hud;
})(GameObject);

var Menu = (function (_super) {
    __extends(Menu, _super);
    function Menu() {
        _super.call(this);
        this.animatedButtons = [];
        this.clickables = [];
        this.isMenuActive = false;
        this.lastClickCount = 0;
    }
    Menu.prototype.show = function () {
        if (this.sprite)
            this.stage.addChild(this.sprite);

        for (var i = 0; i < this.animatedButtons.length; ++i)
            this.animatedButtons[i].onShow();

        this.isMenuActive = true;
    };

    Menu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        var len = this.animatedButtons.length;
        for (var i = 0; i < len; ++i)
            this.animatedButtons[i].update(dt);
    };

    Menu.prototype.hide = function () {
        removeClip(this.sprite);

        this.isMenuActive = false;

        for (var i = 0; i < this.animatedButtons.length; ++i)
            this.animatedButtons[i].onHide();
    };

    Menu.prototype.onResize = function () {
    };

    Menu.prototype.onDown = function (x, y) {
    };

    Menu.prototype.checkClick = function (x, y) {
        this.lastClickCount = 0;
        var len = this.clickables.length;
        for (var i = 0; i < len; ++i) {
            var c = this.clickables[i];
            if (c && c.checkClick(x, y)) {
                c.onClick();
                ++this.lastClickCount;
                break;
            }
        }
    };

    Menu.prototype.onUp = function (x, y) {
        this.checkClick(x, y);
    };

    Menu.prototype.restartLevel = function (e) {
        if (typeof e === "undefined") { e = null; }
        LevelManager.instance.restartLevel();
        if (e)
            e.nativeEvent && e.preventDefault && e.preventDefault();
    };

    Menu.prototype.loadMainMenu = function (e) {
        if (typeof e === "undefined") { e = null; }
        MenuManager.instance.show(MenuManager.instance.map);
        if (e)
            e.preventDefault();
    };
    return Menu;
})(GameObject);

var MenuManager = (function () {
    function MenuManager() {
        this.menus = [];
        this.map = new MapMenu();
        this.mainMenu = new MainMenu();
        this.transition = new TransitionMenu();
        this.winMenu = new WinMenu();
        this.loseMenu = new LoseMenu();
        this.target = new TargetMenu();
        this.pause = new PauseMenu();
        this.result = new ResultMenu();
        this.tutorial = new Tutorial();
        this.credits = new CreditsMenu();
        this.splashMenu = new SplashScreen();
        this.promotionMenu = new PromotionsMenu();
        this.reviewMenu = new ReviewMenu();
        this.lockMenu = new LockMenu();

        this.menus.push(this.map, this.mainMenu, this.transition, this.winMenu, this.loseMenu, this.target, this.pause, this.result, this.credits, this.splashMenu, this.promotionMenu, this.reviewMenu, this.lockMenu);

        MenuManager.instance = this;
    }
    MenuManager.prototype.isOnTutorial = function () {
        return this.current == this.tutorial;
    };

    MenuManager.prototype.traceActive = function () {
        var res = "";
        for (var i = 0; i < this.menus.length; ++i)
            res += " " + (this.menus[i].sprite.parent && this.menus[i].sprite.visible);
        console.log(res);
    };

    MenuManager.prototype.show = function (m, transition) {
        if (typeof transition === "undefined") { transition = true; }
        try  {
            if (transition)
                this.transition.play(m);
            else {
                this.closeCurrent();
                this.current = m;
                this.current.show();
                this.current.update(0);
            }
        } catch (Error) {
            alert("Menu manger show error " + Error);
            this.closeCurrent();
            this.current = m;
            this.current.show();
            this.transition.stopMove();
            alert("Error in menu show: " + Error);
        }
    };
    //LABS
    MenuManager.prototype.update = function (dt) {
        if (this.credits.isMenuActive)
            this.credits.update(dt);
        else if (this.current && !(this.current == this.map && this.transition.isActive && this.transition.menuToShow == null && !this.transition.hasDoneAction))
            this.current.update(dt);
        if (this.transition.isActive)
            this.transition.update(dt);
        //this.traceActive();
        //console.log(this.current, this.transition, this.transition.sprite, this.transition.sprite.parent, this.transition.sprite.visible);
    };

    MenuManager.prototype.closeCurrent = function () {
        if (this.current)
            this.current.hide();
        this.current = null;
    };

    MenuManager.prototype.onResize = function () {
        if (this.current)
            this.current.onResize();
    };
    return MenuManager;
})();

var MapMenu = (function (_super) {
    __extends(MapMenu, _super);
    function MapMenu() {
        var _this = this;
        _super.call(this);
        this.firstShow = true;
        this.isMoving = false;
        this.height = 0;
        this.pointerIsMoving = false;
        this.currentLevel = 0;
        this.downPos = new createjs.Point();
        this.speed = 0;
        this.isDown = false;
        this.dragSpeed = 0;
        this.lastSpeed = 0;
        this.mainSprites = [];
        this.buttons = [];
        this.levelToUnlock = -1;
        this.isLevelUnlocking = false;
        this.isPlayPressed = false;
        this.pointerSprites = [];

        MapMenu.BUTTON_RADIUS = App.episode == 2 ? 25 : 30;

        this.sprite = new createjs.Container();
        this.scrollSprite = new createjs.Container();
        this.sprite.addChild(this.scrollSprite);

        var currentY = 0;
        var shifts = [[0, -10, -20], [0, -42, -44], [0, -39, -48], [0, -39 - 4, -48 + 4], [0, -39 - 4, -48 + 4]];
        for (var i = 1; i <= 3; ++i) {
            var s = new createjs.Bitmap(App.game.preloader.loader.getResult("map" + i));
            var dy = shifts[App.episode][i - 1];
            s.y = currentY + dy;
            this.height += s.getBounds().height + dy;
            this.scrollSprite.addChild(s);
            currentY += s.getBounds().height + dy;
            this.mainSprites.push(s);
        }
        this.rect = this.scrollSprite.getBounds();

        for (i = 0; i < LevelManager.LEVEL_AMOUNT; ++i) {
            var data = mapButtons[App.episode][i];
            var m = createSpriteFromSpritesheet(App.episode <= 1 ? (data[2] ? "point big orange" : "point small orange") : App.episode == 2 ? (data[2] ? (i <= 8 ? "point big orange" : "point big pinc") : (i <= 8 ? "point small orange" : "point small pinc")) : App.episode == 3 ? (data[2] ? (i <= 5 ? "point big pinc" : "point big blue") : (i <= 5 ? "point small pinc" : "point small blue")) : (data[2] ? "point big green" : "point small green"));
            m.x = data[0];
            m.y = data[1];
            if (App.episode == 4) {
                //m.y -= 50;
                //MapMenu.buttonPositions[App.episode][i][1] -= 50;
            }
            var b = m.getBounds();
            m.regX = b.width / 2;
            m.regY = b.height / 2;
            m.scaleX = data[3];
            m.scaleY = data[4];
            this.scrollSprite.addChild(m);
            this.buttons.push(m);
        }

        var a = new AnimatedNode(App.game.animationManager.getAnimation("pointer"), 1 / 30, null);
        a.stop();
        a.x = MapMenu.buttonPositions[App.episode][0][0];
        a.y = MapMenu.buttonPositions[App.episode][0][1];
        this.scrollSprite.addChild(a);
        a.addAction(a.totalFrames - 1, 0 /* ACTION_STOP */);
        a.mouseChildren = a.mouseEnabled = true;
        this.pointer = a;

        var t = new createjs.BitmapText("99", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.y = -75 - 6;
        this.pointer.getPart(0).addChild(t);
        this.pointerSprites.push(t);

        for (var i = 0; i < 3; ++i) {
            var m = createSpriteFromSpritesheet("star");
            this.pointer.getPart(0).addChild(m);
            m.regX = m.getBounds().width / 2;
            m.regY = m.getBounds().height / 2;
            m.scaleX = m.scaleY = 0.36 + i * 0.08;
            m.x = i == 0 ? -47 : i == 1 ? 0 : 52;
            m.y = -110 + (i == 1 ? -11 : i == 0 ? 5 : 0);
            m.rotation = (i - 1) * 25;
            this.pointerSprites.push(m);
        }

        m = createSpriteFromSpritesheet("cookie");
        this.pointer.getPart(0).addChild(m);
        this.pointerSprites.push(m);
        m.y = -11;

        this.scrollSprite.y = 0;

        for (var i = 0; i < this.pointerSprites.length; ++i)
            this.pointerSprites[i].mouseEnabled = false;

        var bc = new ClickableObject(this.pointer);
        bc.setCircle(85, -2, -192);
        bc.callback = function (e) {
            _this.onPointerDown();
        };
        this.clickables.push(bc);

        var bo = new SoundButton(true, this.sprite, 570, 115 - 50);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new SoundButton(false, this.sprite, 570, 215 - 50);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new ButtonObject(6, function (e) {
            _this.loadMain(e);
        }, this.sprite, 350 + 35, 115 - 10);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        this.brandLogo = new LogoObject(this.sprite, App.SCREEN_W / 2, 0, 1);
        this.clickables.push(this.brandLogo);

        this.onResize();
    }
    MapMenu.prototype.onResize = function () {
        _super.prototype.onResize.call(this);

        for (var i = 1; i <= 3; ++i) {
            this.clickables[i].sprite.x = 525 + (i - 2) * 75;
            this.clickables[i].sprite.y = 40 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + (i == 3 ? -2 : 0);
            this.clickables[i].sprite.scaleX = this.clickables[i].sprite.scaleY = i == 3 ? 0.55 : 0.75;
            this.clickables[i].updateRectScale();
        }

        if (this.brandLogo.sprite)
            this.brandLogo.sprite.y = App.ACTUAL_H - 30 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2;
    };

    MapMenu.prototype.loadMain = function (e) {
        MenuManager.instance.show(MenuManager.instance.mainMenu);
    };

    MapMenu.prototype.updatePointerData = function () {
        var data = LevelManager.instance.data[this.currentLevel];
        var stars = data.stars;
        var target = data.targetSpriteName;

        var t = this.pointerSprites[0];
        t.text = (data.levelNumber + 1).toString();
        t.regX = t.getBounds().width / 2;
        t.regY = t.getBounds().height / 2;

        for (var i = 0; i < 3; ++i) {
            var s = this.pointerSprites[i + 1];
            s.visible = i < stars;
        }

        s = this.pointerSprites[4];
        s.gotoAndStop(target);
        s.regX = s.getBounds().width / 2;
        s.regY = s.getBounds().height / 2;
        s.scaleX = s.scaleY = Math.min(45 / s.getBounds().width, 45 / s.getBounds().height);
    };

    MapMenu.prototype.show = function () {
        var _this = this;
        _super.prototype.show.call(this);

        this.onResize();

        this.isLevelUnlocking = this.levelToUnlock > 0;
        this.isPlayPressed = false;

        this.isMoving = false;
        this.pointerIsMoving = false;
        this.speed = 0;
        this.isDown = false;

        this.update(0);

        this.sprite.addEventListener("mousedown", function (e) {
            _this.onMouseDown(e);
        });
        this.sprite.addEventListener("pressup", function (e) {
            _this.onPressUp(e);
        });
        this.sprite.addEventListener("click", function (e) {
            _this.onClick(e);
        });
        this.sprite.addEventListener("pressmove", function (e) {
            _this.onPressMove(e);
        });

        // this.pointer.getPart(0).addEventListener("click", (e: createjs.MouseEvent) => { this.onPointerDown(e); });
        this.firstShow = LevelManager.instance.isFirstLoad && needScrollMap;
        if (this.firstShow) {
            LevelManager.instance.isFirstLoad = false;
            this.firstShow = false;
            this.scrollSprite.y = 0;
            var tFactor = 1;
            this.scroll(App.ACTUAL_H - this.rect.height, 4000 / tFactor, 1000 / tFactor);
        } else if (this.isLevelUnlocking) {
            var button = this.buttons[this.levelToUnlock];
            createjs.Tween.get(button, { loop: false }).wait(650).to({ scaleX: button.scaleX * 1.4, scaleY: button.scaleY * 1.4, alpha: 0.1 }, 500, createjs.Ease.cubicOut).call(function () {
                return _this.onButtonHide();
            });
        } else {
            this.movePoinPointerToButton(LevelManager.instance.lastOpened);
        }

        this.updatePointerData();
    };

    MapMenu.prototype.fastUnlock = function (l) {
        this.levelToUnlock = -1;
        this.buttons[l].visible = false;
        removeClip(this.buttons[l]);
    };

    MapMenu.prototype.onButtonHide = function () {
        this.movePoinPointerToButton(this.levelToUnlock);
    };

    MapMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);
        this.sprite.removeAllEventListeners();
        this.pointer.getPart(0).removeAllEventListeners();
    };

    MapMenu.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };

    MapMenu.prototype.onMouseDown = function (event) {
        if (this.isLevelUnlocking)
            return;

        this.downPos = this.scrollSprite.globalToLocal(event.stageX, event.stageY);
        this.isDown = true;
        this.dragSpeed = 0;
        event.nativeEvent && event.preventDefault && event.preventDefault();
    };

    MapMenu.prototype.onPressUp = function (event) {
        if (this.isLevelUnlocking)
            return;

        this.isDown = false;
        this.speed = this.lastSpeed;
        var s = sign(this.speed);
        this.speed = s * limit(Math.abs(this.speed), 0, 15);
        createjs.Tween.get(this, { loop: false }).wait(0).to({ speed: 0 }, 600, createjs.Ease.cubicOut);
        event.nativeEvent && event.preventDefault && event.preventDefault();
    };

    MapMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        if (!this.isDown)
            this.scrollSprite.y = this.limitY(this.scrollSprite.y + this.speed);

        for (var i = 0; i < 3; ++i) {
            var s = this.mainSprites[i];
            //var b: createjs.Rectangle = s.getBounds();
            //var p: createjs.Point = s.localToGlobal(0, 0);
            //s.visible = !(p.y > App.ACTUAL_H + 100 || p.y + b.height < -100);
        }

        for (var i = 0; i < LevelManager.LEVEL_AMOUNT; ++i) {
            var m = this.buttons[i];
            var p = m.localToGlobal(0, 0);
            m.visible = i == this.levelToUnlock || (LevelManager.instance.data[i].state == LevelData.CLOSED_STATE && !(p.y > App.ACTUAL_H + 200 || p.y < -200));
        }

        this.pointer.update(dt);
    };

    MapMenu.prototype.onClick = function (event) {
        if (this.isLevelUnlocking || this.isPlayPressed)
            return;

        if (!this.isMoving && !this.pointerIsMoving) {
            var p = this.scrollSprite.globalToLocal(event.stageX, event.stageY);
            var len = MapMenu.buttonPositions[App.episode].length;
            for (var i = 0; i < len; ++i) {
                var a = MapMenu.buttonPositions[App.episode][i];
                if (distanceBetweenPoints(p.x, p.y, a[0], a[1]) < MapMenu.BUTTON_RADIUS) {
                    if (LevelManager.instance.data[i].state == LevelData.CLOSED_STATE )//&& false)// Unlock levels LABS
                        return;

                    this.movePoinPointerToButton(i);

                    break;
                }
            }
        }
        event.nativeEvent && event.preventDefault && event.preventDefault();
    };

    MapMenu.prototype.movePoinPointerToButton = function (i) {
        var _this = this;
        var a = MapMenu.buttonPositions[App.episode][i];
        this.pointerIsMoving = true;
        this.currentLevel = i;
        this.pointer.gotoAndPlay(0);
        createjs.Tween.get(this.pointer, { loop: false }).wait(0).to({ x: a[0], y: a[1] }, 300 * 1.4 * 0.7, createjs.Ease.cubicInOut).call(function () {
            return _this.stopPointerMove();
        });

        var topY = a[1] - (275 + 50);
        var bottomY = a[1] + 50;
        if (this.scrollSprite.y + topY < 0)
            this.scroll(-topY + 100, 300, 0);
        else if (this.scrollSprite.y + bottomY > App.SCREEN_H + App.SHIFT_H)
            this.scroll(App.SCREEN_H + App.SHIFT_H - bottomY - 100, 300, 0);
        this.updatePointerData();

        SoundsManager.instance.playSound("pointer_sound");
    };

    MapMenu.prototype.scroll = function (y, t, d) {
        var _this = this;
        if (typeof d === "undefined") { d = 0; }
        if (this.isMoving)
            return;

        this.isMoving = true;
        createjs.Tween.removeTweens(this.scrollSprite);
        this.speed = 0;
        createjs.Tween.get(this.scrollSprite, { loop: false }).wait(d).to({ x: 0, y: this.limitY(y) }, t, createjs.Ease.cubicInOut).call(function () {
            return _this.stopMove();
        });
        ;
    };

    MapMenu.prototype.onPressMove = function (event) {
        if (this.isLevelUnlocking)
            return;
        if (this.isMoving)
            return;

        var p = this.scrollSprite.localToGlobal(this.downPos.x, this.downPos.y);

        var prevPos = this.scrollSprite.y;
        this.scrollSprite.y = this.limitY(this.scrollSprite.y + event.stageY - p.y);
        this.lastSpeed = this.scrollSprite.y - prevPos;
        event.nativeEvent && event.preventDefault && event.preventDefault();
    };

    MapMenu.prototype.limitY = function (y) {
        var b = this.rect;
        var shift = (App.ACTUAL_H - App.FULL_SCREEN_H) / 2;
        var min = -shift;
        var max = -shift + App.ACTUAL_H;
        if (y + b.height < max)
            y = max - b.height;
        else if (y > min)
            y = min;
        return y;
    };

    MapMenu.prototype.onPointerDown = function () {
        if (this.isLevelUnlocking || this.isPlayPressed)
            return;

        if (!this.pointerIsMoving) {
            this.pointer.gotoAndPlay(0);
            var p = this.pointer.localToGlobal(this.pointer.getBounds().width / 2, 88);

            //if (distanceBetweenPoints(p.x, p.y, event.stageX, event.stageY) < 85) {
            //App.game.loadLevel(this.currentLevel);
            LevelManager.instance.prepareToLoadLevel(this.currentLevel);
            SoundsManager.instance.playSound("play_button");
            this.isPlayPressed = true;
            return;
            //}
        }
    };

    MapMenu.prototype.stopPointerMove = function () {
        this.pointerIsMoving = false;
        this.isLevelUnlocking = false;
        this.levelToUnlock = -1;
        if (!this.pointer.isPlaying)
            this.pointer.gotoAndPlay(0);
    };

    MapMenu.prototype.stopMove = function () {
        this.isMoving = false;
    };
    MapMenu.buttonPositions = [
        null,
        [
            [184, 1921], [268, 1880], [328, 1826], [370, 1769], [372, 1702], [360, 1659], [313, 1623], [265, 1584], [207, 1558],
            [140, 1519], [171, 1473], [248, 1461], [340, 1443], [337, 1385], [305, 1319], [332, 1276], [386, 1249], [454, 1236],
            [522, 1206], [546, 1149], [535, 1103], [492, 1073], [432, 1043], [372, 1023], [289, 1006], [182, 993], [124, 976], [92, 928],
            [103, 875], [314, 793], [413, 802], [505, 783], [568, 735], [552, 674], [514, 610]],
        [
            [509, 1918], [453, 1882], [404, 1841], [377, 1782], [371, 1708], [356, 1660], [354, 1600], [356, 1544], [359, 1487], [371, 1429],
            [362, 1390], [336, 1349], [336, 1310], [371, 1278], [421, 1236], [485, 1221], [532, 1206], [564, 1181], [571, 1142], [548, 1102],
            [519, 1070], [477, 1048], [421, 1028], [376, 1015], [324, 987], [264, 980], [203, 959], [147, 898], [176, 856], [229, 813], [301, 797],
            [356, 775], [400, 734], [374, 689], [348, 637]],
        [
            [155, 1937], [201, 1901], [236, 1860], [228, 1804], [201, 1743], [190, 1645], [335, 1618], [394, 1592], [430, 1545], [409, 1482],
            [391, 1444], [340, 1407], [278, 1375], [221, 1348], [163, 1297], [119, 1264], [99, 1224], [99, 1174], [124, 1130], [160, 1085],
            [213, 1052], [274, 1037], [337, 1038], [389, 1056], [452, 1076], [524, 1056], [567, 1019], [571, 965], [542, 914], [486, 860],
            [419, 850], [365, 841], [313, 820], [280, 787], [251, 735], [206, 705], [191, 663], [210, 617], [263, 587], [263, 493]],
        [
            [353, 1747], [365, 1697], [338, 1636], [285, 1594], [273, 1528], [290, 1487], [332, 1455], [361, 1411], [368, 1369], [358, 1315],
            [352, 1276], [333, 1235], [308, 1200], [274, 1165], [240, 1122], [202, 1088], [159, 1055], [118, 1012], [96, 967], [85, 910],
            [86, 866], [104, 828], [135, 793], [172, 762], [233, 729], [306, 735], [356, 751], [394, 778], [418, 814], [450, 839], [517, 820],
            [558, 786], [565, 743], [530, 701], [480, 648], [415, 639], [361, 628], [324, 605], [311, 571], [315, 516]]
    ];

    MapMenu.BUTTON_RADIUS = 30;
    return MapMenu;
})(Menu);

var CharMenu = (function (_super) {
    __extends(CharMenu, _super);
    function CharMenu() {
        _super.call(this);

        this.char = new AnimatedNode(App.game.animationManager.getAnimation("Char"), 1 / 30, null);
        this.char.visible = false;
        this.char.addAction(106, 1 /* ACTION_GOTO_AND_PLAY */, 49);
        this.char.addAction(48, 1 /* ACTION_GOTO_AND_PLAY */, 49);
        this.char.addAction(114, 0 /* ACTION_STOP */, -1);
        this.char.addAction(159, 0 /* ACTION_STOP */, -1);
        this.char.addAction(239, 0 /* ACTION_STOP */, -1);
        this.char.addAction(352, 0 /* ACTION_STOP */, -1);
        this.char.addAction(198, 1 /* ACTION_GOTO_AND_PLAY */, 49);
        this.char.addAction(285, 1 /* ACTION_GOTO_AND_PLAY */, 49);
        this.char.addAction(429, 1 /* ACTION_GOTO_AND_PLAY */, 49);
    }
    CharMenu.prototype.onCharDown = function (e) {
        var f = this.char.currentFrame;
        if (this.char.visible && !(f >= 106 && f <= 114)) {
            this.char.gotoAndPlay(107);
            this.lookBackIn = -1;
            this.charLookIn = -1;
            this.setCharIn = lerp(0, 3, Math.random());
            SoundsManager.instance.playSound("hero_hide");
        }
        e.nativeEvent && e.preventDefault && e.preventDefault();
    };

    CharMenu.prototype.setCharLookTime = function (init) {
        if (typeof init === "undefined") { init = false; }
        this.charLookIn = lerp(init ? 0.01 : 1, init ? 6 : 10, Math.random());
    };

    CharMenu.prototype.show = function () {
        var _this = this;
        _super.prototype.show.call(this);

        this.char.visible = false;
        this.setCharIn = 0.5;
        this.isInitHeroShow = true;

        this.char.addEventListener("click", function (e) {
            _this.onCharDown(e);
        });
    };

    CharMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);

        this.char.removeAllEventListeners();
    };

    CharMenu.prototype.getHeroPosData = function (init) {
        return null;
    };

    CharMenu.prototype.showHero = function (init) {
        if (typeof init === "undefined") { init = false; }
        var data = this.getHeroPosData(init);
        this.char.x = data[0];
        this.char.rotation = data[2];

        var y = this.getCharY(data[1]);
        this.char.y = y;
        this.char.visible = true;
        this.char.gotoAndPlay(0);

        this.setCharLookTime(init);
        this.lookBackIn = -1;
        SoundsManager.instance.playSound("hero_show");
    };

    CharMenu.prototype.getCharY = function (y) {
        return y;
    };

    CharMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        if (this.char.visible)
            this.char.update(dt);

        if (this.setCharIn > 0 && (!this.char.isPlaying || !this.char.visible)) {
            this.setCharIn -= dt;
            if (this.setCharIn <= 0) {
                this.showHero(this.isInitHeroShow);
                this.isInitHeroShow = false;
            }
        }

        if (this.char.currentFrame == 114)
            this.char.visible = false;

        if (this.lookBackIn > 0) {
            this.lookBackIn -= dt;
            if (this.lookBackIn <= 0) {
                if (!this.char.isPlaying) {
                    this.char.gotoAndPlay(this.lookId == 0 ? 161 : this.lookId == 1 ? 241 : 354);
                    this.setCharLookTime();
                } else
                    this.lookBackIn = 0.01;
            }
        } else {
            this.charLookIn -= dt;
            var f = this.char.currentFrame;
            if (this.charLookIn <= 0 && ((f >= 49 && f <= 51) || (f <= 105 && f >= 103))) {
                var i = this.lookId;
                while (i == this.lookId)
                    i = getInt(3);
                this.char.gotoAndPlay(i == 0 ? 115 : i == 1 ? 199 : 286);
                this.lookBackIn = lerp(1.5, 3.5, Math.random());
                this.lookId = i;
            }
        }
    };
    return CharMenu;
})(Menu);

var MainMenu = (function (_super) {
    __extends(MainMenu, _super);
    function MainMenu() {
        var _this = this;
        _super.call(this);
        this.heroPositions = [[129, 983, 0], [665, 698, -44], [659, 239, -119], [165, -16, -180], [-17, 389, 118], [-17, 735, 69]];
        this.blinks = [];
        this.blinksDelays = [];
        this.prevHeroId = -1;
        this.crossButtons = [];
        this.playCrossIn = 0;
        this.episodeCross = [[1, 2, 3], [0, 2, 3], [0, 1, 3], [0, 1, 2]];
        this.crossLinks = ["1", "2", "3", "4"];
        this.openEpisodes = [1, 2, 3, 4];
        this.blinkData = [
            [392.6, 441.1, 1, 1],
            [422.4, 369.55, 1.1253662109375, 1.1253662109375],
            [480.35, 505.1, 1.0650634765625, 1.0650634765625],
            [496.1, 545.5, 1.0650634765625, 1.0650634765625],
            [372, 543.9, 1.499755859375, 1.499755859375],
            [339.5, 505.7, 1.002532958984375, 1.002532958984375],
            [282.35, 531.05, 1.3023529052734375, 1.3023529052734375],
            [584.75, 547.8, 1.3023529052734375, 1.3023529052734375],
            [524.35, 522.6, 0.9369049072265625, 0.9369049072265625],
            [440.6, 477.95, 0.9369049072265625, 0.9369049072265625],
            [376.25, 596.65, 1.0650634765625, 1.0650634765625],
            [439.35, 636.85, 1.0650634765625, 1.0650634765625],
            [435.65, 593.3, 0.72271728515625, 0.72271728515625],
            [198.05, 605.65, 1.0650634765625, 1.0650634765625],
            [274, 416, 1.0650634765625, 1.0650634765625],
            [588.45, 478, 0.7136383056640625, 0.7136383056640625],
            [459.05, -135.35, 1, 1]
        ];

        var s = new createjs.Container();
        this.sprite = s;

        this.back = createBitmap("main menu");
        s.addChild(this.back);

       

        var len = App.episode <= 4 ? this.blinkData.length : 0;
        for (var i = 0; i < len; ++i) {
            var data = this.blinkData[i];
            var b = new AnimatedNode(App.game.animationManager.getAnimation("gloss anim"), 1 / 30, null);
            s.addChild(b);
            b.mouseChildren = b.mouseEnabled = false;
            b.x = data[0];
            b.scaleX = data[2];
            b.scaleY = data[3];
            this.blinks.push(b);
            b.visible = false;
            b.stop();
            b.addAction(b.totalFrames - 1, 0 /* ACTION_STOP */, -1);
            this.blinksDelays.push(this.getBlinkDelay(true));
        }
        
        //LABS Load Web Episodes
        this.loadEpisodes(s); 

        this.logo = new AnimatedNode(App.game.animationManager.getAnimation("logo"), 1 / 30, null);

        if (App.episode <= 2) {
            var logoText = createSpriteFromSpritesheet("logo");
            logoText.x = 30;
            logoText.y = 65;
            this.logo.getPart(0).addChild(logoText);
        }
        this.logo.scaleX = this.logo.scaleY = 0.9;

        //s.addChild(this.logo);
        s.addChild(this.char);

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        s.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        var bc = new ClickableObject(this.button);
        bc.setCircle(120, 120, 120);
        bc.callback = function () {
            _this.onPlayDown();
        };
        this.clickables.push(bc);

        var bo = new SoundButton(true, s, 570, 115 - 50);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new SoundButton(false, s, 570, 215 - 50);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new ButtonObject(4, function (e) {
            _this.loadCredits(e);
        }, this.sprite, 350 + 35, 115 - 10);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        //LAbS
        // var mobileButton = new createjs.Bitmap("/assets/mobileIcon.png");
        // mobileButton.x = 10;
        // mobileButton.y = 120;


        // mobileButton.addEventListener("click", function(event) { 
        //     MenuManager.instance.promotionMenu.show();
        //     //MenuManager.instance.reviewMenu.show();
        // });

        // s.addChild(mobileButton);    


        s.addChild(this.logo);

        this.brandLogo = new LogoObject(s, App.SCREEN_W / 2, 0, 1);
        this.clickables.push(this.brandLogo);

        this.moreGames = new MoreGamesButton(s, App.SCREEN_W / 2, 0, 1);
        this.clickables.push(this.moreGames);

        if (this.crossButtons) {
            for (var i = 0; i < this.crossButtons.length; ++i) {
                var bc = new ClickableObject(this.crossButtons[i]);
                bc.setRect(0, 0, 180, 140);
                if (i == 0)
                    bc.callback = function () {
                        _this.onCrossButtonDown1();
                    };
                else if (i == 1)
                    bc.callback = function () {
                        _this.onCrossButtonDown2();
                    };
                else if (i == 2)
                    bc.callback = function () {
                        _this.onCrossButtonDown3();
                    };
                this.clickables.push(bc);
            }
        }

        removeClip(this.char);
        s.addChild(this.char);

        

        this.onResize();
    }


 MainMenu.prototype.loadEpisodes = function (container){
        //LABS
        //For crosspromoting different episodes
        for (var i = 0; i < 3; ++i) {   
            var episodeToPlay = this.episodeCross[App.episode - 1][i] + 1;       
            var s1;
            if(episodeToPlay < App.episode) {
                s1 = createSpriteFromSpritesheet("play episode" + episodeToPlay);
            }else if(LevelManager.instance.isLevelCompleted(LevelManager.LEVEL_AMOUNT) && this.openEpisodes[App.episode-1] == (i+1)){
                s1 = createSpriteFromSpritesheet("play episode" + this.openEpisodes[i+1]);
            }else{
                s1 = new createjs.Bitmap("/assets/ep"+episodeToPlay+"_locked.png");    
                s1.name = "locked";            
            }
              
            container.addChild(s1);
            s1.regX = 91;
            s1.regY = 70;
            this.crossButtons.push(s1);
            //} 
        }
    };

    MainMenu.prototype.onCrossButtonDown1 = function () {
        this.onCrossButtonDown(0);
    };

    MainMenu.prototype.onCrossButtonDown2 = function () {
        this.onCrossButtonDown(1);
    };

    MainMenu.prototype.onCrossButtonDown3 = function () {
        this.onCrossButtonDown(2);
    };
    //LABS
    MainMenu.prototype.onCrossButtonDown = function (id) {
        if (this.crossButtons && !MenuManager.instance.credits.isMenuActive) {
            var s = this.crossButtons[id];
            createjs.Tween.get(s, { loop: false }).wait(0).to({ scaleX: 1.15, scaleY: 1.15 }, 150, createjs.Ease.quadOut).to({ scaleX: 1, scaleY: 1 }, 150, createjs.Ease.quadIn);
            var link = (this.episodeCross[App.episode - 1][id] + 1)
            console.log("cross", id, link);
            try  {
                //var data = apiInstance.Branding.getLink(App.episode == 1 ? "back-to-candyland-episode-2" : "episode_1");
                //link = data && (data.error == undefined) ? data : link;
                if(s.name!="locked"){
                    localStorage.setItem("current_episode", link);
                    location.reload();
                    analytics.sendEvent("Game","Change","Ep"+link);
                }else{
                     MenuManager.instance.lockMenu.show(link-1);
                }
                
                //apiInstance.Branding.getLink(link).action();
            } catch (e) {
            }
            //window.open(link, '_blank');
        }
    };

    //LABS
    MainMenu.prototype.loadCredits = function (e) {
        //MenuManager.instance.promotionMenu.show();
        MenuManager.instance.credits.show();
    };

    MainMenu.prototype.getCharY = function (y) {
        if (y < 650)
            y = y + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2;
        else
            y = y - 978 + App.ACTUAL_H + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2;
        return y;
    };

    MainMenu.prototype.getHeroPosData = function (init) {
        var i = this.prevHeroId;
        if (init)
            i = 0;
        else {
            while (i == this.prevHeroId)
                i = getInt(this.heroPositions.length);
        }
        this.prevHeroId = i;
        var data = this.heroPositions[i];
        this.lastHeroData = data;
        return data;
    };

    MainMenu.prototype.getBlinkDelay = function (init) {
        if (typeof init === "undefined") { init = false; }
        return lerp(init ? 0 : 6, 16, Math.random());
    };

    MainMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            MenuManager.instance.show(MenuManager.instance.map);
            SoundsManager.instance.playSound("play_button");
        } catch (Error) {
            alert("play down " + Error);
        }
    };

    MainMenu.prototype.onResize = function () {
        _super.prototype.onResize.call(this);

        this.logo.x = 22;
        this.logo.y = 0 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - 5;

        this.button.x = 401;
        this.button.y = App.ACTUAL_H - 235 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2;

        var minY = App.ACTUAL_H - App.FULL_SCREEN_H;
        this.back.y = Math.max(this.logo.y - 50, minY);

        var len = this.blinks.length;
        for (var i = 0; i < len; ++i) {
            var b = this.blinks[i];
            b.y = this.blinkData[i][1]; // + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2;
        }

        for (var i = 1; i <= 3; ++i) {
            this.clickables[i].sprite.x = 525 + (i - 2) * 75;
            this.clickables[i].sprite.y = 40 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + (i == 3 ? 0 : 0);
            this.clickables[i].sprite.scaleX = this.clickables[i].sprite.scaleY = i == 3 ? 0.75 : 0.75;
            this.clickables[i].updateRectScale();
        }

        if (this.brandLogo.sprite)
            this.brandLogo.sprite.y = App.ACTUAL_H - 30 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2;

        if (this.moreGames.sprite) {
            this.moreGames.sprite.x = this.button.x + 115 - 390;
            this.moreGames.sprite.y = this.button.y - 50 - 20;
        }

        if (this.crossButtons) {
            var crossPositions = [
                [340, App.ACTUAL_H + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - 140],
                [390, App.ACTUAL_H + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - 270], [540, App.ACTUAL_H + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - 320]];
            for (var i = 0; i < this.crossButtons.length; ++i) {
                this.crossButtons[i].x = crossPositions[i][0];
                this.crossButtons[i].y = crossPositions[i][1];
            }
        }

        if (this.char && this.lastHeroData) {
            var data = this.lastHeroData;
            this.char.x = data[0];
            this.char.rotation = data[2];
            this.char.y = this.getCharY(data[1]);
        }
    };

    MainMenu.prototype.show = function () {
        _super.prototype.show.call(this);

        this.onResize();
        this.button.gotoAndPlay(0);
        this.button.visible = true;
        this.button.alpha = 1;
        this.setPlayButtonTime(true);

        //this.showHero(true);
        this.playCrossIn = 1;

        
    };

    MainMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);
    };

    MainMenu.prototype.setPlayButtonTime = function (init) {
        if (typeof init === "undefined") { init = false; }
        if (this.button.currentFrame != 106)
            this.button.gotoAndPlay(init ? 130 : 0);
        this.playButtonIn = lerp(5, 12, Math.random());
    };

    MainMenu.prototype.setCrossTime = function () {
        this.playCrossIn = lerp(3, 9, Math.random());
        var cross = this.crossButtons[getInt(this.crossButtons.length)];
        var y = cross.y;
        var dy = 6;
        createjs.Tween.get(cross, { loop: false }).to({ y: y + dy }, 100).to({ y: y }, 100).to({ y: y + dy }, 100).to({ y: y }, 100).to({ y: y + dy }, 100).to({ y: y }, 100);
    };

    MainMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.logo.update(dt);
        this.button.update(dt);

        this.playButtonIn -= dt;
        if (this.playButtonIn <= 0 && !this.button.isPlaying)
            this.setPlayButtonTime();

        var len = this.blinks.length;
        for (var i = 0; i < len; ++i) {
            var b = this.blinks[i];
            if (!b.isPlaying) {
                this.blinksDelays[i] -= dt;
                if (this.blinksDelays[i] <= 0) {
                    this.blinksDelays[i] = this.getBlinkDelay();
                    b.gotoAndPlay(0);
                }
            } else
                b.update(dt);
            b.visible = b.isPlaying;
        }

        this.playCrossIn -= dt;
        if (this.playCrossIn < 0)
            this.setCrossTime();
    };
    return MainMenu;
})(CharMenu);

var MoveDirection;
(function (MoveDirection) {
    MoveDirection[MoveDirection["LEFT"] = 0] = "LEFT";
    MoveDirection[MoveDirection["RIGHT"] = 1] = "RIGHT";
    MoveDirection[MoveDirection["UP"] = 2] = "UP";
    MoveDirection[MoveDirection["DOWN"] = 3] = "DOWN";
})(MoveDirection || (MoveDirection = {}));

var TransitionMenu = (function (_super) {
    __extends(TransitionMenu, _super);
    function TransitionMenu() {
        _super.call(this);
        this.isActive = false;
        this.direction = 2 /* UP */;
        this.moveProgress = -1;
        this.radius = 450 * 0.7;
        this.angleSpeed = 0;
        this.levelToLoad = -1;
        this.hasDoneAction = false;
        this.firstUpdate = false;

        var s = createSpriteFromSpritesheet("menu transfer");
        s.regX = TransitionMenu.WIDTH / 2;
        s.regY = TransitionMenu.HEIGHT / 2;
        s.y = App.FULL_SCREEN_H / 2;
        this.sprite = s;
    }
    TransitionMenu.prototype.onResize = function () {
    };

    TransitionMenu.prototype.play = function (menu, level) {
        if (typeof menu === "undefined") { menu = null; }
        if (typeof level === "undefined") { level = -1; }
        this.hasDoneAction = false;
        this.menuToShow = menu;
        this.levelToLoad = level;
        this.isActive = true;
        this.stage.addChild(this.sprite);

        var r = this.direction;
        while (r == this.direction)
            r = getInt(2);
        this.direction = r;
        this.moveProgress = 0;
        createjs.Tween.removeTweens(this);

        this.angleSpeed = 300 * (r == 1 /* RIGHT */ || r == 2 /* UP */ ? 1 : -1);

        this.update(0);
        this.firstUpdate = true;
        SoundsManager.instance.playSound("transition");
    };

    TransitionMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        if (!this.isActive)
            return;

        if (this.firstUpdate) {
            this.firstUpdate = false;
            dt = 1 / 60;
        }
        this.moveProgress += dt / 0.7;
        var isEnded = this.moveProgress >= 1;
        this.moveProgress = limit(this.moveProgress, 0, 1);

        if (this.moveProgress >= 0.5 && (this.menuToShow || this.levelToLoad >= 0) && !this.hasDoneAction) {
            this.doAction();
        }

        var actualRadius = Math.sqrt(App.ACTUAL_H * App.ACTUAL_H + App.SCREEN_W * App.SCREEN_W);
        this.sprite.scaleX = this.sprite.scaleY = actualRadius / this.radius;
        this.sprite.rotation += this.angleSpeed * dt;
        var hr = actualRadius / 2;

        switch (this.direction) {
            case 1 /* RIGHT */:
                this.sprite.x = lerp(-hr, App.SCREEN_W + hr, this.moveProgress);
                this.sprite.y = App.FULL_SCREEN_H / 2;
                break;
            case 0 /* LEFT */:
                this.sprite.x = lerp(App.SCREEN_W + hr, -hr, this.moveProgress);
                this.sprite.y = App.FULL_SCREEN_H / 2;
                break;
            case 2 /* UP */:
                this.sprite.x = App.SCREEN_W / 2;
                this.sprite.y = lerp(App.ACTUAL_H + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + hr, (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - hr, this.moveProgress);
                break;
            case 3 /* DOWN */:
                this.sprite.x = App.SCREEN_W / 2;
                this.sprite.y = lerp(App.ACTUAL_H + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + hr, (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - hr, 1 - this.moveProgress);
                break;
        }

        var num = this.stage.getNumChildren() - 1;
        this.stage.setChildIndex(this.sprite, num);

        if (isEnded)
            this.stopMove();
    };

    TransitionMenu.prototype.doAction = function () {
        if (!this.hasDoneAction) {
            this.hasDoneAction = true;
            if (App.game.preloader.isActive())
                App.game.preloader.disable();
            if (this.menuToShow) {
                if ((this.menuToShow == MenuManager.instance.map || this.menuToShow == MenuManager.instance.mainMenu) && Match3Level.instance.isActive)
                    Match3Level.instance.reset();
                MenuManager.instance.show(this.menuToShow, false);
            } else {
                MenuManager.instance.closeCurrent();
                LevelManager.instance.loadLevel(this.levelToLoad);
                var levelToTrack = this.levelToLoad+1;
                analytics.sendEvent("Game","Start","Ep:"+App.episode+"-Lev:"+levelToTrack);
            }
            this.levelToLoad = -1;
            this.menuToShow = null;
        }
    };

    TransitionMenu.prototype.stopMove = function () {
        if (!this.hasDoneAction)
            this.doAction();

        createjs.Tween.removeTweens(this);
        removeClip(this.sprite);
        this.isActive = false;
    };
    TransitionMenu.WIDTH = 330;
    TransitionMenu.HEIGHT = 328;
    return TransitionMenu;
})(Menu);

///RESULT
var WinMenu = (function (_super) {
    __extends(WinMenu, _super);
    function WinMenu() {
        var _this = this;
        _super.call(this);
        this.stars = [];
        this.starAmount = 3;
        this.starsShowedAmount = 0;
        this.shines = [];
        this.starData = [[234, 199, 6.8, 0.82], [350, 208, 0, 1], [492, 204, -8, 1.25]];
        this.starShowLeft = 0;

        var sprite = new createjs.Container();
        this.sprite = sprite;
        sprite.y = 300;

        var s = createSpriteFromSpritesheet("gray");
        var rect = s.getBounds();
        s.scaleX = (100 + App.SCREEN_W) / rect.width;
        s.scaleY = (80 + App.SCREEN_H) / rect.height;
        s.y = -sprite.y + App.SHIFT_H - 40;
        s.x = -50;
        this.grayBack = s;
        sprite.addChild(s);

        var b = createBitmap("menu back");
        b.x = b.y = 0;
        sprite.addChild(b);

        var s = createSpriteFromSpritesheet("Victory");
        var rect = s.getBounds();
        s.regX = rect.width / 2;
        s.regY = rect.height / 2;
        s.x = 347;
        s.y = 18;
        sprite.addChild(s);

        var s = createSpriteFromSpritesheet("star back");
        s.x = 159;
        s.y = 116;
        sprite.addChild(s);

        for (var i = 0; i < this.starData.length; ++i) {
            s = createSpriteFromSpritesheet("star glow");
            var data = this.starData[i];
            s.x = data[0];
            s.y = data[1];
            s.scaleX = s.scaleY = 1.4 * data[3] / 0.82;
            var rect = s.getBounds();
            s.regX = rect.width / 2;
            s.regY = rect.height / 2;
            sprite.addChild(s);
            this.shines.push(s);
        }

        for (var i = 0; i < this.starData.length; ++i) {
            s = createSpriteFromSpritesheet("star");
            var data = this.starData[i];
            s.x = data[0];
            s.y = data[1];
            s.rotation = data[2];
            s.scaleX = s.scaleY = data[3];
            var rect = s.getBounds();
            s.regX = rect.width / 2;
            s.regY = rect.height / 2;
            sprite.addChild(s);
            this.stars.push(s);
        }

        sprite.addChild(this.char);

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        sprite.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.x = 470;
        this.button.y = 370;
        this.button.scaleX = this.button.scaleY = 0.75;
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        var bc = new ClickableObject(this.button);
        bc.setCircle(120 * this.button.scaleX, 120 * this.button.scaleX, 120 * this.button.scaleX);
        bc.callback = function () {
            _this.onPlayDown();
        };
        this.clickables.push(bc);

        var bo = new ButtonObject(5, function (e) {
            _this.restarAndUnlock(e);
        }, sprite, App.SCREEN_W / 2, 465);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        this.clickables.push(new LogoObject(sprite, 95, 480, 1));
    }
    WinMenu.prototype.restarAndUnlock = function (e) {
        LevelManager.instance.restartLoadNextLevel();
        this.restartLevel(e);
    };

    WinMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            if (!MenuManager.instance)
                new MenuManager();

            //MenuManager.instance.show(MenuManager.instance.map);
            //LevelManager.instance.prepareToLoadLevel(0);
            LevelManager.instance.loadNextLevel();
            SoundsManager.instance.playSound("pause");
        } catch (Error) {
            alert("play down2 " + Error);
        }
    };

    WinMenu.prototype.setStarData = function (n) {
        this.starAmount = n;
    };

    WinMenu.prototype.getHeroPosData = function (init) {
        return [100, 300, 0];
    };

    WinMenu.prototype.show = function () {
        var _this = this;
        _super.prototype.show.call(this);
        this.starsShowedAmount = 0;

        this.grayBack.alpha = 0;
        createjs.Tween.get(this.grayBack, { loop: false }).wait(0).to({ alpha: 1 }, 300, createjs.Ease.none);

        for (var i = 0; i < this.stars.length; ++i) {
            var s = this.stars[i];
            s.visible = false;
            this.shines[i].visible = false;
            createjs.Tween.removeTweens(s);
            createjs.Tween.removeTweens(this.shines[i]);
        }

        this.starShowLeft = this.starAmount;
        for (var i = 0; i < this.starAmount; ++i) {
            s = this.stars[i];
            s.visible = true;
            s.alpha = 0;
            s.scaleX = s.scaleY = 2;
            var scale = this.starData[i][3];
            var delay = 500 + i * 500;
            createjs.Tween.get(s, { loop: false }).wait(delay).to({ alpha: 1, scaleX: scale, scaleY: scale }, 200, createjs.Ease.none).call(function () {
                return _this.stopStarMove();
            });
            if (s.visible) {
                SoundsManager.instance.playSound("star" + (i + 1), delay);
            }
        }

        removeClip(this.scoreText);
        this.scoreText = new createjs.BitmapText(this.level.score.toString(), App.game.atlases[0]);
        var size = getTextSize(this.scoreText);
        this.scoreText.regX = 0;
        this.sprite.addChild(this.scoreText);
        this.scoreText.x = 350;
        this.scoreText.y = 40;
        this.scoreText.letterSpacing = -10;

        this.setCharIn = 0.1;
        this.setPlayButtonTime(true);
        this.button.gotoAndPlay(0);

        SoundsManager.instance.pauseMusic();
        SoundsManager.instance.playSound("win");
    };

    WinMenu.prototype.setPlayButtonTime = function (init) {
        if (typeof init === "undefined") { init = false; }
        if (this.button.currentFrame != 106)
            this.button.gotoAndPlay(init ? 130 : 0);
        this.playButtonIn = lerp(5, 12, Math.random());
    };

    WinMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);
        SoundsManager.instance.resumeMusic();
    };

    WinMenu.prototype.stopStarMove = function () {
        var s = this.shines[this.starsShowedAmount];
        s.visible = true;
        s.rotation = 0;
        s.alpha = 1;

        createjs.Tween.get(s, { loop: false }).wait(0).to({ alpha: 0, rotation: 90 }, 600, createjs.Ease.none);

        this.starsShowedAmount++;
        this.starShowLeft--;

        if (this.starShowLeft <= 0)
            App.game.showAds();
    };

    WinMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);

        this.playButtonIn -= dt;
        if (this.playButtonIn <= 0 && !this.button.isPlaying)
            this.setPlayButtonTime();
    };
    return WinMenu;
})(CharMenu);

var PauseLikeMenu = (function (_super) {
    __extends(PauseLikeMenu, _super);
    function PauseLikeMenu(brandShift) {
        if (typeof brandShift === "undefined") { brandShift = 0; }
        _super.call(this);
        this.showDelay = 0;
        this.targetPos = 350;

        var sprite = new createjs.Container();
        this.sprite = sprite;
        sprite.y = 0;

        var baseSprite = new createjs.Container();

        var s = createSpriteFromSpritesheet("gray");
        var rect = s.getBounds();
        s.scaleX = (100 + App.SCREEN_W) / rect.width;
        s.scaleY = (80 + App.FULL_SCREEN_H) / rect.height;
        s.y = -sprite.y - 40;
        s.x = -50;
        this.grayBack = s;
        sprite.addChild(s);

        var b = createBitmap("menu back");
        baseSprite.addChild(b);
        this.backSprite = b;

        sprite.addChild(baseSprite);
        this.baseSprite = baseSprite;

        this.brandLogo = new LogoObject(sprite, App.SCREEN_W - 90, App.CURRENT_SHIFT + App.SCREEN_H - 30 + brandShift, 1);
        if (this.brandLogo.sprite)
            this.brandLogo.sprite.y = App.ACTUAL_H - 40 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + brandShift;

        this.moreGames = new MoreGamesButton(sprite, 90, App.CURRENT_SHIFT + App.SCREEN_H - 30 + brandShift, 1);
        if (this.moreGames.sprite)
            this.moreGames.sprite.y = App.ACTUAL_H - 60 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + brandShift;
    }
    PauseLikeMenu.prototype.show = function () {
        _super.prototype.show.call(this);

        createjs.Tween.removeTweens(this.baseSprite);
        createjs.Tween.removeTweens(this.grayBack);
        this.grayBack.alpha = 0;
        this.baseSprite.y = -250;
        createjs.Tween.get(this.grayBack, { loop: false }).wait(this.showDelay).to({ alpha: 1 }, 200 * 1.3, createjs.Ease.cubicInOut);
        createjs.Tween.get(this.baseSprite, { loop: false }).wait(this.showDelay).to({ y: this.targetPos }, 1000 * 1.3, createjs.Ease.elasticOut);

        if (this.clickables.indexOf(this.brandLogo) == -1)
            this.clickables.push(this.brandLogo);
        if (this.clickables.indexOf(this.moreGames) == -1)
            this.clickables.push(this.moreGames);

        if (this.brandLogo.sprite)
            this.brandLogo.sprite.visible = true;
        if (this.moreGames.sprite)
            this.moreGames.sprite.visible = true;
    };

    PauseLikeMenu.prototype.hide = function () {
        var _this = this;
        if (this.needToHideInstantly()) {
            _super.prototype.hide.call(this);
            return;
        }

        createjs.Tween.removeTweens(this.baseSprite);
        createjs.Tween.removeTweens(this.grayBack);
        this.grayBack.alpha = 1;
        this.baseSprite.y = 350;
        createjs.Tween.get(this.grayBack, { loop: false }).wait(0).to({ alpha: 0 }, 750, createjs.Ease.cubicInOut);
        createjs.Tween.get(this.baseSprite, { loop: false }).wait(0).to({ y: -550 }, 750, createjs.Ease.elasticInOut).call(function () {
            return _super.prototype.hide.call(_this);
        });

        if (this.brandLogo.sprite)
            this.brandLogo.sprite.visible = false;
        if (this.moreGames.sprite)
            this.moreGames.sprite.visible = false;
    };

    PauseLikeMenu.prototype.needToHideInstantly = function () {
        return MenuManager.instance.transition.menuToShow == null && MenuManager.instance.transition.isActive;
    };
    return PauseLikeMenu;
})(Menu);

var TargetMenu = (function (_super) {
    __extends(TargetMenu, _super);
    function TargetMenu() {
        _super.call(this, -30);
        this.targetTexts = [];
        this.targetSprites = [];

        this.showDelay = 150;

        var sprite = this.sprite;
        var s;

        var t = new createjs.BitmapText("OBJECTIVE", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.x = App.SCREEN_W / 2 - t.getBounds().width / 2;
        t.y = -40;
        this.baseSprite.addChild(t);

        var t = new createjs.BitmapText("tap to continue...", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.scaleX = t.scaleY = 0.5;
        t.x = App.SCREEN_W / 2 - t.scaleX * t.getBounds().width / 2;
        t.y = App.FULL_SCREEN_H - 175 - sprite.y + 10;
        sprite.addChild(t);
        this.continueText = t;

        for (var i = 2; i >= 0; --i) {
            s = createSpriteFromSpritesheet("cookie");
            s.y = 300 + i * 30 - 210;
            s.rotation = i * -30;
            this.baseSprite.addChild(s);
            this.targetSprites.push(s);
        }

        for (var i = 0; i < 2; ++i) {
            var t = new createjs.BitmapText(" ", App.game.atlases[0]);
            t.letterSpacing = -8.5;
            t.spaceWidth = 25;
            t.scaleX = t.scaleY = 0.9;
            this.baseSprite.addChild(t);
            this.targetTexts.push(t);
        }

        this.onResize();
    }
    TargetMenu.prototype.onResize = function () {
        _super.prototype.onResize.call(this);

        //this.brandLogo.sprite.y = App.ACTUAL_H - 40 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 + brandShift;
        this.continueText.y = App.ACTUAL_H - 40 + (App.FULL_SCREEN_H - App.ACTUAL_H) / 2 - this.sprite.y - 15;
    };

    TargetMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        var texts = Match3Level.instance.target.getText();
        var right = -1;
        for (var i = 0; i < this.targetTexts.length; ++i) {
            var t = this.targetTexts[i];
            t.text = texts[i];
            t.x = App.SCREEN_W / 2 - t.getTransformedBounds().width / 2 - 40 + 10;
            t.y = -40 + 85 + i * 55;
            var b = t.getTransformedBounds();
            right = App.SCREEN_W - 150; // Math.max(right, b.x + b.width);
        }

        for (var i = 0; i < 3; ++i) {
            var s = this.targetSprites[i];
            var frameName = texts[2];
            s.gotoAndStop(frameName);
            s.scaleX = s.scaleY = frameName == "star" ? 66 / 100 : 1;
            s.x = right + 15 - (i == 2 ? 0 : i == 1 ? 25 : 19) + 45 + 10;
            s.regX = s.getBounds().width / 2;
            s.regY = s.getBounds().height / 2;
        }

        this.continueText.visible = true;
        Match3Level.instance.hud.logo.setVisible(false);
    };

    TargetMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);
        this.continueText.visible = false;
        Match3Level.instance.hud.logo.setVisible(true);
    };

    TargetMenu.prototype.onDown = function (x, y) {
        _super.prototype.onDown.call(this, x, y);
    };

    TargetMenu.prototype.onUp = function (x, y) {
        _super.prototype.onUp.call(this, x, y);

        if (this == MenuManager.instance.current && this.lastClickCount == 0) {
            MenuManager.instance.closeCurrent();
            if (Match3Level.instance.isPaused)
                Match3Level.instance.unpause();
        }
    };
    return TargetMenu;
})(PauseLikeMenu);

var PauseMenu = (function (_super) {
    __extends(PauseMenu, _super);
    function PauseMenu() {
        var _this = this;
        _super.call(this);

        var sprite = this.sprite;
        var s;

        var t = new createjs.BitmapText("pause", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.x = App.SCREEN_W / 2 - t.getBounds().width / 2;
        t.y = -40;
        this.baseSprite.addChild(t);

        var bo = new ButtonObject(6, function (e) {
            _this.loadMainMenu(e);
        }, this.baseSprite, 350 + 35, 115 - 10);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new ButtonObject(5, function (e) {
            _this.restartLevel(e);
        }, this.baseSprite, 210 + 35, 115 - 10);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new SoundButton(true, this.baseSprite, 570, 115 - 50);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new SoundButton(false, this.baseSprite, 570, 215 - 50);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        this.targetPos = 290;

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        this.baseSprite.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.x = App.SCREEN_W / 2 - 85;
        this.button.y = 210 - 40;
        this.button.scaleX = this.button.scaleY = 0.75;
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        var bc = new ClickableObject(this.button);
        bc.setCircle(120 * this.button.scaleX, 120 * this.button.scaleX, 120 * this.button.scaleX);
        bc.callback = function () {
            _this.onPlayDown();
        };
        this.clickables.push(bc);
    }
    PauseMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        this.button.gotoAndPlay(0);
    };

    PauseMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            Match3Level.instance.unpause();
            SoundsManager.instance.playSound("pause");
        } catch (Error) {
            alert("play downXX " + Error);
        }
    };

    PauseMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);
    };
    return PauseMenu;
})(PauseLikeMenu);

//LABS 
var LockMenu = (function (_super) {
    __extends(LockMenu, _super);
    function LockMenu() {
        var _this = this;
        _super.call(this);
        this.dataTexts = [];

        t = new createjs.BitmapText("Locked", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.regX = t.getBounds().width / 2;
        t.x = App.SCREEN_W / 2;
        t.y = -45;
        this.baseSprite.addChild(t);

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        this.baseSprite.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.x = App.SCREEN_W / 2 - 85;
        this.button.y = 170;
        this.button.scaleX = this.button.scaleY = 0.75;
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        this.button.addEventListener("click", function(event){
            _this.onPlayDown();
        });


    }
    LockMenu.prototype.show = function (episode_to_click) {
        var inText = new createjs.BitmapText("This episode is locked until\n\n   you finish Episode "+episode_to_click, App.game.atlases[1]);
        inText.letterSpacing = -10;
        inText.spaceWidth = 25;
        inText.regX = inText.getBounds().width / 2;
        inText.x = App.SCREEN_W / 2;
        inText.y = 50;
        inText.scaleX = inText.scaleY = 0.5
        this.baseSprite.addChild(inText);

     _super.prototype.show.call(this);
        this.button.gotoAndPlay(0);   
    };

    LockMenu.prototype.hide = function () {
        this.isMenuActive = false;
        _super.prototype.hide.call(this);
    };

    LockMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            this.hide();
        } catch (Error) {
            alert("play downXXt " + Error);
        }
    };

    LockMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);
    };
    return LockMenu;
})(PauseLikeMenu);

var LoseMenu = (function (_super) {
    __extends(LoseMenu, _super);
    function LoseMenu() {
        var _this = this;
        _super.call(this);

        this.showDelay = 0;
        var s = createSpriteFromSpritesheet("lose");
        var rect = s.getBounds();
        s.regX = rect.width / 2;
        s.regY = rect.height / 2;
        s.x = 347;
        s.y = 18;
        this.baseSprite.addChild(s);

        this.char = new AnimatedNode(App.game.animationManager.getAnimation("Char lose"), 1 / 30, null);
        this.char.x = 100;
        this.char.y = 300;

        this.baseSprite.addChild(this.char);

        var bo = new ButtonObject(6, function (e) {
            _this.loadMainMenu(e);
        }, this.baseSprite, 500, 140);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);

        var bo = new ButtonObject(5, function (e) {
            _this.restartLevel(e);
        }, this.baseSprite, 340, 140);
        this.animatedButtons.push(bo);
        this.clickables.push(bo);
    }
    LoseMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        SoundsManager.instance.playSound("fail");
        SoundsManager.instance.pauseMusic();
    };

    LoseMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);
        SoundsManager.instance.resumeMusic();
    };

    LoseMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.char.update(dt);
    };
    return LoseMenu;
})(PauseLikeMenu);

var ResultMenu = (function (_super) {
    __extends(ResultMenu, _super);
    function ResultMenu() {
        var _this = this;
        _super.call(this);
        this.dataTexts = [];

        t = new createjs.BitmapText("game complete!", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.regX = t.getBounds().width / 2;
        t.x = App.SCREEN_W / 2;
        t.y = -45;
        t.scaleX = t.scaleY = 0.7
        this.baseSprite.addChild(t);

        //LABS New episode unlocked MOBILE VERSION
        var newEpisodeText = new createjs.BitmapText("new episode available", App.game.atlases[1]);
        newEpisodeText.letterSpacing = -10;
        newEpisodeText.spaceWidth = 25;
        newEpisodeText.regX = newEpisodeText.getBounds().width / 2;
        newEpisodeText.x = App.SCREEN_W / 2;
        newEpisodeText.y = 450;
        newEpisodeText.scaleX = newEpisodeText.scaleY = 0.7

        if(App.episode == 1){
            this.baseSprite.addChild(newEpisodeText);
        }
        

        this.backSprite.scaleY = 1.5;
        var data = ["stars earned:", "total moves:", "total score:", "bonuses used:"];
        for (var i = 0; i < data.length; ++i) {
            for (var j = 0; j < 2; j++) {
                if (j == 1)
                    continue;

                var t = new createjs.BitmapText(j == 0 ? data[i] : getInt(1000000).toString(), j == 0 ? App.game.atlases[1] : App.game.atlases[0]);
                t.letterSpacing = -10;
                t.spaceWidth = 25;
                t.regX = j == 0 ? 0 : t.getBounds().width / 2;
                t.x = j == 0 ? 30 : 520;
                t.y = 60 + i * 55 + (j == 0 ? 0 : -20);
                t.scaleX = t.scaleY = j == 0 ? 0.7 : 1;
                this.baseSprite.addChild(t);
            }
        }

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        this.baseSprite.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.x = App.SCREEN_W / 2 - 85;
        this.button.y = 310 - 25;
        this.button.scaleX = this.button.scaleY = 0.75;
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        var bc = new ClickableObject(this.button);
        bc.setCircle(120, 120, 120);
        bc.callback = function () {
            _this.onPlayDown();
        };
        this.clickables.push(bc);

        this.targetPos -= 60;



    }
    ResultMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        this.button.gotoAndPlay(0);

        for (var i = 0; i < this.dataTexts.length; ++i)
            removeClip(this.dataTexts[i]);
        this.dataTexts = [];

        var data = [
            LevelManager.instance.totalStars + "/" + 180, LevelManager.instance.moves.toString(),
            LevelManager.instance.totalScores.toString(), LevelManager.instance.bonuses.toString()];
        for (var i = 0; i < data.length; ++i) {
            for (var j = 0; j < 2; j++) {
                if (j == 0)
                    continue;

                var t = new createjs.BitmapText(data[i], j == 0 ? App.game.atlases[1] : App.game.atlases[0]);
                t.letterSpacing = -10;
                t.spaceWidth = 25;
                t.regX = j == 0 ? 0 : t.getBounds().width / 2;
                t.x = j == 0 ? 30 : 520;
                t.y = 60 + i * 55 + (j == 0 ? 0 : -20);
                t.scaleX = t.scaleY = j == 0 ? 0.7 : 1;
                this.dataTexts.push(t);
                this.baseSprite.addChild(t);
            }
        }

        SoundsManager.instance.pauseMusic();
        SoundsManager.instance.playSound("win");

        //LABS
        analytics.sendEvent("Game","Ended","Ep:"+App.episode);
    };

    ResultMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);

        SoundsManager.instance.resumeMusic();
    };

    ResultMenu.prototype.onPlayDown = function () {
        try  {
            //this.button.gotoAndPlay(99);
            //this.loadMainMenu();
            location.reload();
        } catch (Error) {
            alert("play downXXt " + Error);
        }
    };

    ResultMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);
    };
    return ResultMenu;
})(PauseLikeMenu);

var CreditsMenu = (function (_super) {
    __extends(CreditsMenu, _super);
    function CreditsMenu() {
        var _this = this;
        _super.call(this);
        this.dataTexts = [];

        t = new createjs.BitmapText("Credits", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.regX = t.getBounds().width / 2;
        t.x = App.SCREEN_W / 2;
        t.y = -45;
        this.baseSprite.addChild(t);

        this.backSprite.scaleY = 1.8;
        var data = ["art:", "code:", "sound:", "thanks\nto:"];
        for (var i = 0; i < data.length; ++i) {
            for (var j = 0; j < 2; j++) {
                if (j == 1)
                    continue;

                var t = new createjs.BitmapText(j == 0 ? data[i] : getInt(1000000).toString(), j == 0 ? App.game.atlases[1] : App.game.atlases[0]);
                t.letterSpacing = -10;
                t.spaceWidth = 25;
                t.regX = j == 0 ? 0 : t.getBounds().width / 2;
                t.x = j == 0 ? 10 : 520;
                t.y = 60 + i * 55 + (j == 0 ? 0 : -20);
                t.scaleX = t.scaleY = 0.65;
                this.baseSprite.addChild(t);
            }
        }

        this.dataTexts = [];

        var data = ["Alexey Testov", "Andriy Vinchkovskiy", "alexander ahura", "           sergey batishchev\n         konstantin boronenkov\n  all flashgamedev.ru testers!"];
        for (var i = 0; i < data.length; ++i) {
            for (var j = 0; j < 2; j++) {
                if (j == 0)
                    continue;

                var t = new createjs.BitmapText(data[i], j == 0 ? App.game.atlases[1] : App.game.atlases[0]);
                t.letterSpacing = -10;
                t.spaceWidth = 25;
                t.regX = j == 0 ? 0 : t.getBounds().width / 2;
                t.x = 390 + (i == 3 ? -50 : 0);
                t.y = 70 + i * 55 + (j == 0 ? 0 : -20) + (i == 3 ? 10 : 0);
                t.scaleX = t.scaleY = i == 3 ? 0.6 : 0.75;
                this.dataTexts.push(t);
                this.baseSprite.addChild(t);
            }
        }

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        this.baseSprite.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.x = App.SCREEN_W / 2 - 85;
        this.button.y = 335;
        this.button.scaleX = this.button.scaleY = 0.75;
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        var bc = new ClickableObject(this.button);
        bc.setCircle(120, 120, 120);
        bc.callback = function () {
            _this.onPlayDown();
        };
        this.clickables.push(bc);

        var brandLogo = new LogoObject(this.baseSprite, App.SCREEN_W / 2 + 200, 370, 1);
        this.clickables.push(brandLogo);

        this.targetPos -= 120;
    }
    CreditsMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        this.button.gotoAndPlay(0);
    };

    CreditsMenu.prototype.hide = function () {
        this.isMenuActive = false;
        _super.prototype.hide.call(this);
    };

    CreditsMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            this.hide();
        } catch (Error) {
            alert("play downXXt " + Error);
        }
    };

    CreditsMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);
    };
    return CreditsMenu;
})(PauseLikeMenu);

//LABS
var PromotionsMenu = (function (_super) {
    __extends(PromotionsMenu, _super);
    function PromotionsMenu() {
        var _this = this;
        _super.call(this);

        this.backSprite.scaleY = 1.8;   

        t = new createjs.BitmapText("Did you know...", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.regX = t.getBounds().width / 2;
        t.x = App.SCREEN_W / 2;
        t.y = -45;
        this.baseSprite.addChild(t);

        var inText = new createjs.BitmapText("...you can also play this game on:", App.game.atlases[1]);
        inText.letterSpacing = -10;
        inText.spaceWidth = 25;
        inText.regX = inText.getBounds().width / 2;
        inText.x = App.SCREEN_W / 2;
        inText.y = 50;
        inText.scaleX = inText.scaleY = 0.4
        this.baseSprite.addChild(inText);

        var inText = new createjs.BitmapText("Check our website for more:", App.game.atlases[1]);
        inText.letterSpacing = -10;
        inText.spaceWidth = 25;
        inText.regX = inText.getBounds().width / 2;
        inText.x = App.SCREEN_W / 2;
        inText.y = 200;
        inText.scaleX = inText.scaleY = 0.4
        this.baseSprite.addChild(inText);

        var webStore = new createjs.Bitmap("/assets/logo_no_background.png");
        webStore.x = 100;
        webStore.y = 250;
        webStore.scaleX = 0.5;
        webStore.scaleY = 0.5;


        webStore.addEventListener("click", function(event) { 
            window.open("http://backtocandyland.com/", "_blank");
            analytics.sendEvent("Menu","Click","Website");
        });
            
        this.baseSprite.addChild(webStore);



        var googlePlay = new createjs.Bitmap("/assets/en_generic_rgb_wo_60.png");
        googlePlay.x = 100;
        googlePlay.y = 100;
        googlePlay.scaleX = 1;
        googlePlay.scaleY = 1;

        googlePlay.addEventListener("click", function(event) { 
             //apiInstance.Branding.getLink('more_games').action;
             window.open("https://play.google.com/store/apps/details?id=com.spilgames.backtocandyland&referrer=utm_source%3Dportal%26utm_medium%3Din_game_ad", "_blank");
             analytics.sendEvent("Menu","Click","GooglePlay");
        });

        this.baseSprite.addChild(googlePlay);  


        var appStore = new createjs.Bitmap("/assets/app_store_icon.gif");
        appStore.x = 350;
        appStore.y = 100;
        appStore.scaleX = 1;
        appStore.scaleY = 1;

        appStore.addEventListener("click", function(event) { 
            window.open("https://itunes.apple.com/us/app/back-to-candyland/id899480528?mt=8&referrer=utm_source%3Dportal%26utm_medium%3Din_game_ad&ign-mpt=uo%3D4", "_blank");
            analytics.sendEvent("Menu","Click","Apple");
        });

        this.baseSprite.addChild(appStore);     

        this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
        this.baseSprite.addChild(this.button);
        this.button.addAction(97, 0 /* ACTION_STOP */, 0);
        this.button.addAction(106, 0 /* ACTION_STOP */, -1);
        this.button.x = App.SCREEN_W / 2 - 85;
        this.button.y = 330;
        this.button.scaleX = this.button.scaleY = 0.75;
        this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

        var backButton = new ClickableObject(this.button);
        backButton.setCircle(120, 120, 120);
        backButton.callback = function () {
            _this.onPlayDown();
        };
        this.clickables.push(backButton);

    

        this.targetPos -= 120;
    }
    PromotionsMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        this.button.gotoAndPlay(0);
    };

    PromotionsMenu.prototype.hide = function () {
        this.isMenuActive = false;
        _super.prototype.hide.call(this);
    };

    PromotionsMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            this.hide();
        } catch (Error) {
            alert("play downXXt " + Error);
        }
    };

    PromotionsMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);
    };
    return PromotionsMenu;
})(PauseLikeMenu);

var ReviewMenu = (function (_super) {
    __extends(ReviewMenu, _super);
    function ReviewMenu() {
        var _this = this;
        _super.call(this);

        this.backSprite.scaleY = 1.8;   

        t = new createjs.BitmapText("Review", App.game.atlases[1]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.regX = t.getBounds().width / 2;
        t.x = App.SCREEN_W / 2;
        t.y = -45;
        this.baseSprite.addChild(t);

        var inText = new createjs.BitmapText("Do you like this game?", App.game.atlases[1]);
        inText.letterSpacing = -10;
        inText.spaceWidth = 25;
        inText.regX = inText.getBounds().width / 2;
        inText.x = App.SCREEN_W / 2;
        inText.y = 50;
        inText.scaleX = inText.scaleY = 0.7;
        this.baseSprite.addChild(inText);

        var noText = new createjs.BitmapText("No", App.game.atlases[1]);
        noText.letterSpacing = -10;
        noText.spaceWidth = 25;
        noText.regX = noText.getBounds().width / 2;
        noText.x = App.SCREEN_W /1.5;
        noText.y = 200;
        noText.scaleX = noText.scaleY = 0.8;
        this.baseSprite.addChild(noText);

        noText.addEventListener("click", function(event) { 
            window.open("https://play.google.com/store/apps/details?id=com.spilgames.backtocandyland&referrer=utm_source%3Dportal%26utm_medium%3Din_game_add", "_blank");
        });

         var yesText = new createjs.BitmapText("Yes", App.game.atlases[1]);
        yesText.letterSpacing = -10;
        yesText.spaceWidth = 25;
        yesText.regX = yesText.getBounds().width / 2;
        yesText.x = App.SCREEN_W / 3;
        yesText.y = 200;
        yesText.scaleX = yesText.scaleY = 0.8;
        this.baseSprite.addChild(yesText);

        yesText.addEventListener("click", function(event) { 
            window.open("market://details?id=com.spilgames.backtocandyland", "_blank");
        });
       
       // this.button = new AnimatedNode(App.game.animationManager.getAnimation("button"), 1 / 30, null);
       //  this.baseSprite.addChild(this.button);
       //  this.button.addAction(97, 0 /* ACTION_STOP */, 0);
       //  this.button.addAction(106, 0 /* ACTION_STOP */, -1);
       //  this.button.x = App.SCREEN_W / 2 - 85;
       //  this.button.y = 330;
       //  this.button.scaleX = this.button.scaleY = 0.75;
       //  this.button.addAction(this.button.totalFrames - 1, 1 /* ACTION_GOTO_AND_PLAY */, 0);

       //  var backButton = new ClickableObject(this.button);
       //  backButton.setCircle(120, 120, 120);
       //  backButton.callback = function () {
       //      _this.onPlayDown();
       //  };
       //  this.clickables.push(backButton);

    

        this.targetPos -= 120;
    }
    ReviewMenu.prototype.show = function () {
        _super.prototype.show.call(this);
        this.button.gotoAndPlay(0);
    };

    ReviewMenu.prototype.hide = function () {
        this.isMenuActive = false;
        _super.prototype.hide.call(this);
    };

    ReviewMenu.prototype.onPlayDown = function () {
        try  {
            this.button.gotoAndPlay(99);
            this.hide();
        } catch (Error) {
            alert("play downXXt " + Error);
        }
    };

    ReviewMenu.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        this.button.update(dt);
    };
    return ReviewMenu;
})(PauseLikeMenu);

var SplashScreen = (function (_super) {
    __extends(SplashScreen, _super);
    function SplashScreen() {
        _super.call(this);

        var s = new createjs.Container();

        var m = createSpriteFromSpritesheet("white");
        m.scaleX = (100 + App.SCREEN_W) / 50;
        m.scaleY = (100 + App.FULL_SCREEN_H) / 50;
        m.x = m.y = -50;
        m.regX = 0;
        m.regY = 0;
        s.addChild(m);
        this.sprite = s;

    }
    SplashScreen.prototype.show = function () {
        var _this = this;
        _super.prototype.show.call(this);

        createjs.Tween.removeTweens(this.logo);
        this.logo.scaleX = this.logo.scaleY = 0.85;
        createjs.Tween.get(this.logo, { loop: false }).wait(100).to({ scaleX: 1, scaleY: 1 }, 300, createjs.Ease.circOut).wait(0).to({ scaleX: this.logo.scaleX, scaleY: this.logo.scaleY }, 400, createjs.Ease.quadIn).wait(1200).call(function () {
            return _this.onAnimEnd();
        });
    };

    SplashScreen.prototype.onAnimEnd = function () {
        MenuManager.instance.show(MenuManager.instance.mainMenu, true);
    };

    SplashScreen.prototype.onDown = function (x, y) {
        _super.prototype.onDown.call(this, x, y);

        console.log("splash down");
        splashScreenData.action();
    };
    return SplashScreen;
})(Menu);
var LevelTarget = (function () {
    function LevelTarget() {
        this.scores = [500, 1500, 3000];
        this.isScoreTarget = false;
        this.isBlockTarget = false;
    }
    Object.defineProperty(LevelTarget.prototype, "progress", {
        get: function () {
            return 0;
        },
        enumerable: true,
        configurable: true
    });

    Object.defineProperty(LevelTarget.prototype, "isCompleted", {
        get: function () {
            return this.progress >= 1 - 1e-10;
        },
        enumerable: true,
        configurable: true
    });

    LevelTarget.prototype.getExactType = function (x, y) {
        return -1;
    };

    LevelTarget.prototype.getText = function () {
        return [];
    };

    LevelTarget.prototype.onLevelGenerated = function () {
    };

    LevelTarget.prototype.onMarkRemoved = function () {
    };

    LevelTarget.prototype.onBlockRemoved = function () {
    };

    LevelTarget.prototype.onObjectRemove = function (f) {
    };

    LevelTarget.prototype.getTargetText = function () {
        return "";
    };

    LevelTarget.prototype.onBushRemoved = function () {
    };
    return LevelTarget;
})();

var PushDownTarget = (function (_super) {
    __extends(PushDownTarget, _super);
    function PushDownTarget(n) {
        _super.call(this);
        this.targetsToPush = 0;
        this.targetsPushed = 0;
        this.pushCakeIn = 0;
        this.pushLeft = 0;
        this.pushQueue = 0;
        this.targetsToPush = n;
        this.setPushTime();
    }
    PushDownTarget.prototype.setPushTime = function () {
        this.pushCakeIn = Match3Level.instance.currentMove + getInt(3);

        if (this.needToPush) {
            return;
        }

        this.pushLeft = Math.random() < 0.02 && (this.pushQueue + 2 <= this.targetsToPush) ? 2 : 1;
        this.pushQueue += this.pushLeft;
        if (this.pushQueue > this.targetsToPush)
            this.pushLeft = -1;
    };

    Object.defineProperty(PushDownTarget.prototype, "needToPush", {
        get: function () {
            return this.pushLeft > 0;
        },
        enumerable: true,
        configurable: true
    });

    Object.defineProperty(PushDownTarget.prototype, "progress", {
        get: function () {
            return this.targetsPushed / this.targetsToPush;
        },
        enumerable: true,
        configurable: true
    });

    PushDownTarget.prototype.onTargetPush = function () {
        ++this.targetsPushed;
        if (!this.isCompleted)
            this.setPushTime();
    };

    PushDownTarget.prototype.getTargetText = function () {
        return "x" + limit(this.targetsToPush - this.targetsPushed, 0, 1e10);
    };

    PushDownTarget.prototype.getExactType = function (x, y) {
        //if (y == 0)
        //    console.log(this.isCompleted, this.needToPush, this.pushCakeIn, Match3Level.instance.currentMove, x, Match3Level.instance.pushPositions.indexOf(x));
        if (y == 0 && !this.isCompleted && this.needToPush && Match3Level.instance.currentMove >= this.pushCakeIn && Match3Level.instance.levelData.pushPositions.indexOf(x) != -1) {
            this.pushLeft--;
            if (this.needToPush)
                this.setPushTime();
            return Match3Level.instance.assetNumber;
        }

        return -1;
    };

    PushDownTarget.prototype.getText = function () {
        return ["drop " + this.targetsToPush + " cakes", "to the bottom!", "cupcake"];
    };
    return PushDownTarget;
})(LevelTarget);

var ClearMarkTarget = (function (_super) {
    __extends(ClearMarkTarget, _super);
    function ClearMarkTarget() {
        _super.call(this);
        this.marksToRemove = 1;
        this.marksRemoved = 0;
    }
    Object.defineProperty(ClearMarkTarget.prototype, "progress", {
        get: function () {
            return this.marksRemoved / this.marksToRemove;
        },
        enumerable: true,
        configurable: true
    });

    ClearMarkTarget.prototype.getTargetText = function () {
        return "x" + limit(this.marksToRemove - this.marksRemoved, 0, 1e10);
    };

    ClearMarkTarget.prototype.onLevelGenerated = function () {
        this.marksToRemove = 0;
        for (var x = 0; x < App.level.fieldWidth; ++x)
            for (var y = 0; y < App.level.fieldHeight; ++y) {
                var c = App.level.cells[x][y];
                if (c.isMarked)
                    ++this.marksToRemove;
            }
    };

    ClearMarkTarget.prototype.getText = function () {
        return ["remove all", "cookies!", "cookie"];
    };

    ClearMarkTarget.prototype.onMarkRemoved = function () {
        this.marksRemoved++;
    };
    return ClearMarkTarget;
})(LevelTarget);

var BlockClearTarget = (function (_super) {
    __extends(BlockClearTarget, _super);
    function BlockClearTarget() {
        _super.call(this);
        this.blocksToRemove = 1;
        this.blocksRemoved = 0;

        this.isBlockTarget = true;
    }
    BlockClearTarget.prototype.getTargetText = function () {
        return "x" + limit(this.blocksToRemove - this.blocksRemoved, 0, 1e10);
    };

    BlockClearTarget.prototype.getText = function () {
        var ld = Match3Level.instance.levelData;
        var sprite = ld.hasBomb ? "chocolate+mine ico" : ld.hasBlackChoco && ld.hasWhiteChoco ? "chocolate ico" : ld.hasWhiteChoco ? "chocolate white" : "chocolate black";
        return ["remove all", "obstacles!", sprite];
    };

    Object.defineProperty(BlockClearTarget.prototype, "progress", {
        get: function () {
            return this.blocksRemoved / this.blocksToRemove;
        },
        enumerable: true,
        configurable: true
    });

    BlockClearTarget.prototype.onLevelGenerated = function () {
        this.blocksToRemove = 0;
        for (var x = 0; x < App.level.fieldWidth; ++x)
            for (var y = 0; y < App.level.fieldHeight; ++y) {
                var c = App.level.cells[x][y];
                if ((c.isBreakable || c.isBombBlocked) && !c.isObjectBlocked)
                    ++this.blocksToRemove;
            }
    };

    BlockClearTarget.prototype.onBlockRemoved = function () {
        this.blocksRemoved++;
    };
    return BlockClearTarget;
})(LevelTarget);

var BushClearTarget = (function (_super) {
    __extends(BushClearTarget, _super);
    function BushClearTarget() {
        _super.call(this);
        this.bushToRemove = 1;
        this.bushRemoved = 0;
    }
    BushClearTarget.prototype.getTargetText = function () {
        return "x" + limit(this.bushToRemove - this.bushRemoved, 0, 1e10);
    };

    BushClearTarget.prototype.getText = function () {
        return ["remove all", "dangerous plants!", "bush"];
    };

    Object.defineProperty(BushClearTarget.prototype, "progress", {
        get: function () {
            return this.bushRemoved / this.bushToRemove;
        },
        enumerable: true,
        configurable: true
    });

    BushClearTarget.prototype.onLevelGenerated = function () {
        this.bushToRemove = 0;
        for (var x = 0; x < App.level.fieldWidth; ++x)
            for (var y = 0; y < App.level.fieldHeight; ++y) {
                var c = App.level.cells[x][y];
                if (c.isPlantBlock)
                    ++this.bushToRemove;
            }
    };

    BushClearTarget.prototype.onBushRemoved = function () {
        this.bushRemoved++;
    };
    return BushClearTarget;
})(LevelTarget);

var WaterClearTarget = (function (_super) {
    __extends(WaterClearTarget, _super);
    //waterToRemove: number = 1;
    //waterRemoved: number = 0;
    function WaterClearTarget() {
        _super.call(this);
    }
    WaterClearTarget.prototype.getTargetText = function () {
        return "x" + CellObject.waterCells.length;
    };

    WaterClearTarget.prototype.getText = function () {
        return ["remove all", "water obstacles!", "water"];
    };

    Object.defineProperty(WaterClearTarget.prototype, "progress", {
        get: function () {
            return CellObject.waterCells.length == 0 ? 1 : 0;
        },
        enumerable: true,
        configurable: true
    });

    WaterClearTarget.prototype.onLevelGenerated = function () {
        /*
        this.waterToRemove = 0;
        for (var x: number = 0; x < App.level.fieldWidth; ++x)
        for (var y: number = 0; y < App.level.fieldHeight; ++y) {
        var c: CellObject = App.level.cells[x][y];
        if (c.isBlock() && c.isWaterBlock)
        ++this.waterToRemove;
        }
        */
    };
    return WaterClearTarget;
})(LevelTarget);

var ColorTarget = (function (_super) {
    __extends(ColorTarget, _super);
    function ColorTarget(n, c) {
        _super.call(this);
        this.colorsToRemove = 0;
        this.colorsRemoved = 0;
        this.colorType = 0;
        this.colorsToRemove = n;
        this.colorType = c;
    }
    ColorTarget.prototype.getTargetText = function () {
        return "x" + limit(this.colorsToRemove - this.colorsRemoved, 0, 1e10);
    };

    ColorTarget.prototype.getText = function () {
        return ["remove " + this.colorsToRemove + " " + FieldObject.assetNames[this.colorType], "jellies!", FieldObject.assetNames[this.colorType]];
    };

    Object.defineProperty(ColorTarget.prototype, "progress", {
        get: function () {
            return this.colorsRemoved / this.colorsToRemove;
        },
        enumerable: true,
        configurable: true
    });

    ColorTarget.prototype.onObjectRemove = function (f) {
        if (f.colorType == this.colorType)
            this.colorsRemoved++;
    };
    return ColorTarget;
})(LevelTarget);

var ScoreTarget = (function (_super) {
    __extends(ScoreTarget, _super);
    function ScoreTarget(n) {
        _super.call(this);
        this.targetScore = 0;
        this.targetScore = n;
        this.isScoreTarget = true;
    }
    ScoreTarget.prototype.getTargetText = function () {
        var p = Math.floor(100 * limit(Match3Level.instance.score / this.targetScore, 0, 1));
        return p + "%";
    };

    ScoreTarget.prototype.getText = function () {
        return ["collect " + this.targetScore, "points!", "star"];
    };

    Object.defineProperty(ScoreTarget.prototype, "progress", {
        get: function () {
            return Match3Level.instance.score / this.targetScore;
        },
        enumerable: true,
        configurable: true
    });
    return ScoreTarget;
})(LevelTarget);

var InfiniteTarget = (function (_super) {
    __extends(InfiniteTarget, _super);
    function InfiniteTarget() {
        _super.call(this);
    }
    InfiniteTarget.prototype.getTargetText = function () {
        return "xxx%";
    };

    InfiniteTarget.prototype.getText = function () {
        return ["reach xxx", "points!", "star"];
    };

    Object.defineProperty(InfiniteTarget.prototype, "progress", {
        get: function () {
            return 0;
        },
        enumerable: true,
        configurable: true
    });
    return InfiniteTarget;
})(LevelTarget);
var BonusIndicator = (function (_super) {
    __extends(BonusIndicator, _super);
    function BonusIndicator(c1, c2, target, bonusType) {
        var _this = this;
        _super.call(this);
        this.borders = [];
        this.isMovingToTarget = false;
        this.isHiding = false;
        this.horizontal = false;

        this.target = target;

        //this.bonusType = FieldBonusType.kColorBonus;// bonusType;
        this.bonusType = bonusType;

        var p1X = App.level.gridToStageX(c1.x);
        var p1Y = App.level.gridToStageY(c1.y);
        var p2X = App.level.gridToStageX(c2.x);
        var p2Y = App.level.gridToStageY(c2.y);

        var con = new createjs.Container();
        var tweenTime = 250;
        this.horizontal = c1.y == c2.y;

        for (var i = 0; i < 2; ++i) {
            var s = createSpriteFromSpritesheet("bonus line side");
            var b = s.getBounds();
            s.regX = b.width;
            s.regY = b.height / 2;
            s.scaleX = s.scaleY = Match3Level.TILE_SIZE_FACTOR;

            var c = i == 0 ? c1 : c2;
            s.x = i == 0 ? p1X : p2X;
            s.y = i == 0 ? p1Y : p2Y;
            s.rotation = c1.y == c2.y ? (((i == 0 && c1.x < c2.x) || (i == 1 && c2.x < c1.x)) ? 0 : 180) : (((i == 0 && c1.y < c2.y) || (i == 1 && c2.y < c1.y)) ? 90 : -90);
            con.addChild(s);

            this.borders.push(s);
            createjs.Tween.get(s, { loop: false }).to({ x: (p1X + p2X) / 2, y: (p1Y + p2Y) / 2 }, tweenTime, createjs.Ease.cubicIn); //.call(this.stopMove.bind(this));
        }

        s = createSpriteFromSpritesheet("bonus line center");
        b = s.getBounds();
        var scale = (distanceBetweenPoints(p1X, p1Y, p2X, p2Y) + 0.3) / (b.width - 2.9);
        s.scaleX = scale; // * Match3Level.TILE_SIZE_FACTOR;
        s.scaleY = Match3Level.TILE_SIZE_FACTOR;
        con.addChildAt(s, 0);
        s.x = (p1X + p2X) / 2;
        s.y = (p1Y + p2Y) / 2;
        s.regX = b.width / 2;
        s.regY = b.height / 2;
        createjs.Tween.get(s, { loop: false }).to({ scaleX: 0 }, tweenTime, createjs.Ease.cubicIn).call(function () {
            return _this.moveToTarget();
        });
        s.rotation = c1.y == c2.y ? 0 : 90;
        this.borders.push(s);

        s = createSpriteFromSpritesheet("bonus new"); //bonusType == FieldBonusType.kBombBonus ? "bonus_icon_3" : bonusType == FieldBonusType.kColorBonus ? "bonus_icon_3" :

        //bonusType == FieldBonusType.kHorizontalLize ? "bonus_icon_1" : "bonus_icon_2");
        con.addChild(s);
        s.x = (p1X + p2X) / 2;
        s.y = (p1Y + p2Y) / 2;
        s.scaleX = 0.3;
        s.scaleY = 0.3;
        s.alpha = 0.3;
        b = s.getBounds();
        s.regX = b.width / 2;
        s.regY = b.height / 2;
        this.borders.push(s);
        createjs.Tween.get(s, { loop: false }).wait(0).to({ alpha: 1, scaleX: 1, scaleY: 1 }, tweenTime, createjs.Ease.cubicIn);

        this.sprite = con;
        addChild(this.sprite, this.level.bonusIndicatorLayer);

        target.setTempBlock(true, 0.1);
        SoundsManager.instance.playSound("bonus_show");
    }
    BonusIndicator.prototype.moveToTarget = function () {
        var _this = this;
        this.borders[0].visible = this.borders[1].visible = false;
        this.isMovingToTarget = true;
        var pX = App.level.gridToStageX(this.target.x);
        var pY = App.level.gridToStageY(this.target.y);
        var r = this.sprite.getBounds();
        pX -= r.x + r.width / 2;
        pY -= r.y + r.height / 2;
        createjs.Tween.get(this.sprite).to({ x: pX, y: pY }, 500, createjs.Ease.cubicIn).call(function () {
            return _this.hide();
        });
        this.isHiding = true;
        //this.borders[3].visible = true;
        //console.log("move", p.x, p.y, this.target.x, this.target.y);
    };

    BonusIndicator.prototype.hide = function () {
        var _this = this;
        if (this.isDestroyed)
            return;

        if (this.target && this.target.object) {
            this.target.object.setBonusType(this.bonusType);
            this.target.setTempBlock(false, -1);
            SoundsManager.instance.playSound("bonus_set");
        }
        createjs.Tween.get(this.borders[3]).to({ alpha: 0, scaleX: 0, scaleY: 0 }, 800, createjs.Ease.cubicOut).call(function () {
            return _this.destroy();
        });
    };

    BonusIndicator.prototype.updateTarget = function (c) {
        this.target = c;
        createjs.Tween.removeTweens(this.sprite);
        createjs.Tween.removeTweens(this.borders[3]);
        this.moveToTarget();
    };

    BonusIndicator.prototype.checkTargetObject = function () {
        if (this.isMovingToTarget && (!this.target.object || this.target.object.isMoving || this.target.isWaitingForClear)) {
            this.target = null;
            this.level.spawnBonus(this.bonusType, null, null, this);
        }
    };

    BonusIndicator.prototype.update = function (dt) {
        if (!this.isMovingToTarget) {
            var c = this.borders[2];
            var w = c.scaleX * 25 - 2;
            for (var i = 0; i < 2; ++i) {
                var s = this.borders[i];
                s.x = c.x + (this.horizontal ? (i == 1 ? 1 : -1) * w / 2 : 0);
                s.y = c.y + (!this.horizontal ? (i == 1 ? 1 : -1) * w / 2 : 0);
            }
        }

        this.checkTargetObject();

        if (!this.isDestroyed)
            this.target.setTempBlock(true, 0.1);
        //console.log(this.sprite.x, this.sprite.y);
    };

    BonusIndicator.prototype.destroy = function () {
        if (this.isDestroyed)
            return;

        createjs.Tween.removeTweens(this.borders[3]);
        createjs.Tween.removeTweens(this.sprite);
        this.isMovingToTarget = true;

        for (var i = 0; i < this.borders.length; ++i)
            removeClip(this.borders[i]);
        this.borders = null;

        _super.prototype.destroy.call(this);
    };
    return BonusIndicator;
})(GameObject);
var GemDestroyAnimation = (function (_super) {
    __extends(GemDestroyAnimation, _super);
    function GemDestroyAnimation(color) {
        _super.call(this);
        this.totalFrames = 0;
        this.playedScore = false;

        this.color = color;
        this.totalFrames = GemDestroyAnimation.animLen[color];

        this.fileName = FieldObject.assetNames[this.color] + "x";
        this.sprite = new createjs.Sprite(App.game.atlases[0], this.fileName);
        this.sprite.framerate = 30;

        var p = GemDestroyAnimation.regPoints[this.color];
        this.sprite.scaleX = this.sprite.scaleY = 1.5;
        this.sprite.regX = p.x / this.sprite.scaleX; // - data[5];
        this.sprite.regY = p.y / this.sprite.scaleY; // - data[6];
        this.sprite.scaleX = this.sprite.scaleY = this.sprite.scaleX * Match3Level.TILE_SIZE_FACTOR;
    }
    GemDestroyAnimation.prototype.destroy = function () {
        if (!this.isDestroyed) {
            //super.destroy();
            Match3Level.pool.returnGemDestroy(this);
        }
    };

    GemDestroyAnimation.prototype.update = function (dt) {
        if (this.isDestroyed)
            return;

        var f = this.sprite.currentAnimationFrame;
        if (!this.playedScore && f > this.totalFrames / 2) {
            this.cell.tryPlayScoreAnimation();
            this.playedScore = true;
        }
        if (f > this.totalFrames) {
            Match3Level.pool.returnGemDestroy(this);
        }
    };

    GemDestroyAnimation.prototype.init = function (x, y, cell) {
        this.cell = cell;
        this.level = Match3Level.instance;
        addChild(this.sprite, this.level.gemDestroyLayer);
        this.sprite.gotoAndPlay(this.fileName);
        this.sprite.x = x;
        this.sprite.y = y;
        this.level.objects.push(this);
        this.isDestroyed = false;
        this.playedScore = false;

        if (Match3Level.instance && this.color < Match3Level.instance.assetNumber) {
            SoundsManager.instance.playSound("remove" + (getInt(4) + 1));
        }
    };

    GemDestroyAnimation.prototype.release = function () {
        this.sprite.stop();
        removeClip(this.sprite);
        this.isDestroyed = true;
    };
    GemDestroyAnimation.animLen = [16, 13, 16, 17];
    GemDestroyAnimation.animSizes = [cjp(98, 135), cjp(133, 96), cjp(110, 114), cjp(83, 118)];
    GemDestroyAnimation.regPoints = [cjp(54, 74), cjp(66, 62), cjp(52, 60), cjp(42, 38)];
    return GemDestroyAnimation;
})(GameObject);
var BonusLineSprite = (function (_super) {
    __extends(BonusLineSprite, _super);
    function BonusLineSprite(t, x, y) {
        _super.call(this);
        this.sprites = [];
        this.speeds = [];

        this.type = t;

        var amount;
        var angles;
        var shift;

        switch (t) {
            case 1 /* kHorizontalLize */:
                amount = 2;
                angles = [90, -90];
                shift = [cjp(0, 0), cjp(0, 0)];
                break;
            case 2 /* kVerticalLine */:
                amount = 2;
                angles = [0, 180];
                shift = [cjp(0, 0), cjp(0, 0)];
                break;
            case 5 /* kCrossBonus */:
                amount = 4;
                angles = [90, -90, 0, 180];
                shift = [cjp(0, 0), cjp(0, 0), cjp(0, 0), cjp(0, 0)];
                break;
            case 6 /* kThickCrossBonus */:
                amount = 12;
                angles = [0, 0, 0, 90, 90, 90, 180, 180, 180, -90, -90, -90];
                shift = [
                    cjp(-1, -1), cjp(0, -1), cjp(1, -1),
                    cjp(1, -1), cjp(1, 0), cjp(1, 1),
                    cjp(-1, 1), cjp(0, 1), cjp(1, 1),
                    cjp(-1, -1), cjp(-1, 0), cjp(-1, 1)];
                break;
        }

        var v = Match3Level.TILE_SIZE / FieldObject.GEM_KILL_DELAY;
        for (var i = 0; i < amount; ++i) {
            var s = createSpriteFromSpritesheet("explosion line");
            s.x = x + shift[i].x * Match3Level.TILE_SIZE;
            s.y = y + shift[i].y * Match3Level.TILE_SIZE;
            this.sprites.push(s);
            addChild(s, this.level.bonusLayer);
            s.regX = 25;
            s.regY = 65;
            s.rotation = angles[i];
            this.speeds.push(cjp(s.rotation == 90 ? v : s.rotation == -90 ? -v : 0, s.rotation == 0 ? -v : s.rotation == 180 ? v : 0));
        }

        this.level.objects.push(this);
    }
    BonusLineSprite.prototype.update = function (dt) {
        var visibleCount = 0;
        var len = this.sprites.length;
        for (var i = 0; i < len; ++i) {
            var s = this.sprites[i];
            if (s.visible) {
                visibleCount++;

                s.x += this.speeds[i].x * dt;
                s.y += this.speeds[i].y * dt;

                var b = s.getBounds();
                if (b.x + s.x > App.SCREEN_W + 100 || b.y + s.y > App.ACTUAL_H + 100 || b.x + b.width + s.x < -100 || b.y + b.height + s.y < -100) {
                    s.visible = false;
                    removeClip(s);
                }
            }
        }

        if (visibleCount == 0)
            this.destroy();
    };

    BonusLineSprite.prototype.destroy = function () {
        if (this.isDestroyed || !this.sprites)
            return;

        _super.prototype.destroy.call(this);

        var len = this.sprites.length;
        for (var i = 0; i < len; ++i)
            removeClip(this.sprites[i]);

        this.sprites = null;
        this.speeds = null;
    };
    return BonusLineSprite;
})(GameObject);
var BonusBombSprite = (function (_super) {
    __extends(BonusBombSprite, _super);
    function BonusBombSprite(t, x, y) {
        var _this = this;
        _super.call(this);
        this.progress = 0;
        this.maxScale = 0;

        var radius = t == 3 /* kBombBonus */ ? 2.5 : 4;
        this.maxScale = 1.75 * radius * FieldObject.TILE_SIZE / 65;

        createjs.Tween.get(this).wait(100).to({ progress: 1 }, 1.6 * radius * 1000 * FieldObject.GEM_KILL_DELAY, createjs.Ease.cubicOut).call(function () {
            return _this.destroy();
        });

        this.sprite = createSpriteFromSpritesheet("explosion bomb");
        this.sprite.x = x;
        this.sprite.y = y;
        this.sprite.regX = this.sprite.regY = 135 / 2;
        addChild(this.sprite, this.level.bonusLayer);

        this.level.objects.push(this);
    }
    BonusBombSprite.prototype.update = function (dt) {
        this.sprite.scaleX = this.sprite.scaleY = lerp(0.1, this.maxScale, this.progress);
        this.sprite.alpha = this.progress < 0.6 ? lerp(0.3, 1, this.progress / 0.6) : lerp(1, 0, (this.progress - 0.6) / 0.4);
    };
    return BonusBombSprite;
})(GameObject);
var LevelManager = (function () {
    function LevelManager() {
        this.data = [];
        this.currentLevel = 0;
        this.version = 0.924;
        this.isFirstLoad = true;
        this.lastOpened = 0;
        this.moves = 0;
        this.bonuses = 0;
        this.version += App.episode * 10;

        LevelManager.LEVEL_AMOUNT = App.episode == 0 ? 60 : App.episode <= 2 ? 35 : 40;
        LevelManager.instance = this;
        var datas = LevelManager.levelDatas[App.episode];
        for (var i = 0; i < LevelManager.LEVEL_AMOUNT; ++i) {
            var d = i < datas.length ? "=" + datas[i] : null;
            this.data.push(new LevelData(i, d, i == 0 ? LevelData.OPENED_STATE : LevelData.CLOSED_STATE));
        }

        this.load();
    }
    Object.defineProperty(LevelManager.prototype, "totalScores", {
        get: function () {
            var len = this.data.length;
            var res = 0;
            for (var i = 0; i < len; ++i)
                res += this.data[i].score;
            return res;
        },
        enumerable: true,
        configurable: true
    });

    Object.defineProperty(LevelManager.prototype, "totalStars", {
        get: function () {
            var len = this.data.length;
            var res = 0;
            for (var i = 0; i < len; ++i)
                res += this.data[i].stars;
            return res;
        },
        enumerable: true,
        configurable: true
    });


    LevelManager.prototype.isLevelCompleted = function(level){
        console.log(this.data[level - 1])
        return this.data[level - 1].state == LevelData.COMPLETED_STATE;
    }

    LevelManager.prototype.loadLevel = function (n) {
        MenuManager.instance.closeCurrent();
        this.currentLevel = n;
        App.level.init(n);
    };

    LevelManager.prototype.loadNextLevel = function () {
        this.data[this.currentLevel].state = LevelData.COMPLETED_STATE;

        if (this.currentLevel < LevelManager.LEVEL_AMOUNT - 1) {
            this.currentLevel++;
            var prevState = this.data[this.currentLevel].state;
            this.data[this.currentLevel].state = Math.max(LevelData.OPENED_STATE, this.data[this.currentLevel].state);
            this.lastOpened = Math.max(this.lastOpened, this.currentLevel);
            if (prevState == LevelData.CLOSED_STATE)
                MenuManager.instance.map.levelToUnlock = this.currentLevel;
            MenuManager.instance.show(MenuManager.instance.map);
        }
        this.save();
    };

    LevelManager.prototype.restartLoadNextLevel = function () {
        this.data[this.currentLevel].state = LevelData.COMPLETED_STATE;

        if (this.currentLevel < LevelManager.LEVEL_AMOUNT - 1) {
            var prevState = this.data[this.currentLevel + 1].state;
            this.data[this.currentLevel + 1].state = Math.max(LevelData.OPENED_STATE, this.data[this.currentLevel + 1].state);
            this.lastOpened = Math.max(this.lastOpened, this.currentLevel + 1);
            if (prevState == LevelData.CLOSED_STATE)
                MenuManager.instance.map.fastUnlock(this.currentLevel + 1);
        }
        this.save();
    };

    LevelManager.prototype.onLevelComplete = function (stars, score) {
        MenuManager.instance.winMenu.setStarData(stars);
        this.data[this.currentLevel].state = LevelData.COMPLETED_STATE;
        this.data[this.currentLevel].stars = Math.max(stars, this.data[this.currentLevel].stars);
        this.data[this.currentLevel].score = Math.max(score, this.data[this.currentLevel].score);
        this.save();
    };

    LevelManager.prototype.prepareToLoadLevel = function (n) {
        MenuManager.instance.transition.play(null, n);
    };

    LevelManager.prototype.restartLevel = function () {
        this.prepareToLoadLevel(this.currentLevel);
    };

    LevelManager.prototype.save = function () {
        if (!this.isLocalStorageAvailable)
            return;

        var res = { version: this.version, moves: this.moves, bonuses: this.bonuses };
        var levelData = [];
        for (var i = 0; i < this.data.length; ++i) {
            var ld = this.data[i];
            levelData.push({ c: ld.state, s: ld.stars, p: ld.score });
        }
        res.levels = levelData;
        if(App.episode==1){
           localStorage.setItem('save', JSON.stringify(res)); 
        }else{
            localStorage.setItem('save'+App.episode, JSON.stringify(res)); 
        }
        
    };

    LevelManager.prototype.load = function () {
        if (!this.isLocalStorageAvailable)
            return;

        var res;
        if(App.episode==1){
           res = localStorage.getItem('save');
        }else{
           res = localStorage.getItem('save'+App.episode);
        }

        if (!res)
            return;

        res = JSON.parse(res);
        var levelData = res.levels;

        if (!levelData)
            return;

        if (this.version != res.version) {
            localStorage.clear();
            return;
        }

        this.moves = Math.max(this.moves, res.moves);
        this.bonuses = Math.max(this.bonuses, res.bonuses);
        for (var i = 0; i < levelData.length; ++i) {
            this.data[i].state = levelData[i].c;
            this.data[i].stars = levelData[i].s;
            this.data[i].score = levelData[i].p;
            if (this.data[i].state >= LevelData.OPENED_STATE)
                this.lastOpened = Math.max(this.lastOpened, i);
        }
        this.isFirstLoad = false;
    };

    Object.defineProperty(LevelManager.prototype, "isLocalStorageAvailable", {
        get: function () {
            try  {
                localStorage.setItem("test", "test");
                localStorage.removeItem("test");
                return 'localStorage' in window && window['localStorage'] !== null;
            } catch (e) {
                return false;
            }
        },
        enumerable: true,
        configurable: true
    });
    LevelManager.LEVEL_AMOUNT = App.episode == 0 ? 60 : App.episode <= 2 ? 35 : 40;

    LevelManager.levelDatas = [
        [
            "00030202040000000000000403020100000000000000040203000003020000000303010001040403000201040303020401000301010103010404040200020101030204040300000004020402010402000000000001000001000000000000000000000000-4-800-1-800-900-1000-17-1111111111"
        ],
        [
            "00030202040000000000000403020100000000000000040203000003020000000303010001040403000201040303020401000301010103010404040200020101030204040300000004020402010402000000000001000001000000000000000000000000-4-800-1-800-900-1000-17-1111111111",
            "00000001020401040000000000040202020301000000000301020202030410101010020203020201000000101004030202010000000010100401040300000000001010101010000000000000000000000000000000000000000000000000000000000000-4-1300-1-1300-1500-1700-25-1111111111",
            "00000000000000020102000000000000000102010000001010101002010200000010000010010201000000000000000201020000000000000001020100000010000010020102000000101010100102010000000000000002010200000000000000010201-3-45-1-1400-1900-2600-42-1111111111",
            "00002000002000002000000020000020000020000000200000200000200000032000002000002000000320000020000020000003200000200000200000032000002000002000000020000020000020000000200000200000200000002000002000002000-4-1500-0-1500-1700-1900-25-1111111111",
            "00000000000000002020000000000000000000200000200000000020000000000020202020000000000000200404200000000000002004042000000000000020202020000000000020000000002000000000000000000000002000000000000000002020-0-1500-1-1500-2500-3500-38-1111111111",
            "00000000000000000000000000002010101010000000000020202020100000000000202020200000000000002020202000000000000020202020000000000000202020200000000000002020202010000000000020101010100000000000000000000000-0-1500-1-1400-2000-3200-38-1111111111",
            "00030220000000000000000204200000000000000004032000000000000000030220000000000000202020202020202020202020202020202020202000000000020120000000000000000403200000000000000002012000000000000000010420000000-3-35-1-1500-1800-2100-30-1111111111",
            "00002000200020002010000010200020002000200000200020002000201000001020002000200020000020002000200020100000102000200020002000002000200020002010000010200020002000200000200020002000201000001020002000200020-0-1500-1-2500-3000-3900-65-1111111111",
            "10202020202020202010001020202020202010000000002020202000000000000000202000000000000000000000000000000000000000000000000000000000202000000000000000202020200000000010202020202020100010202020202020202010-3-65-0-2000-2500-3200-50-1111111111",
            "00000010001000000000000000001000000000000000001000100000000000000000100000000000000000100010000000000000000010000000000000000010001000000000000000001000000000000000001000100000000000000000100000000000-2-2-1-1600-2400-3700-45-0101010101",
            "00000000202020000000000000000020202000000000000000002020200000000000002020200000000000002020200000000000000000202020000000000000000020202000000000000000002020200000000000000000202000000000000000202020-2-2-1-2700-3800-4900-60-1111111111",
            "00000000000000000000002020000000200000000020201000000020000000001020200000002000000000202010000000202000000010202000000000200000002020100000000020000000102020000000002000000020200000000000000000000000-0-2500-1-2500-3100-3700-45-1111111111",
            "00000000202000000000000000002020000000000000000020200000000000000000202000000000101010102020202020201010101020202020202000000000202000000000000000002020000000000000000020200000000000000000202000000000-2-2-1-2200-3200-4100-55-0110000110",
            "00000000000000000000000000002020000000000000001020201000000000000000202000002020000000000000001020200000000000000010202000000000202000002020000000102020100000000000000020200000000000000000000000000000-3-70-3-2000-2800-3400-48-1111111111",
            "00000000000000000000000000000000000000001010101010101010101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000-2-2-1-3500-4500-5500-62-1100000000",
            "00000000000000000000000000000000000000000000201010101010101000002020505050505051000020205000000000510000202050000000005100002020505050505051000020101010101010100000000000000000000000000000000000000000-1-1-1-1800-2500-3300-30-1100000000",
            "20200000000020205050202000000000202050500000000000002020202000000000000020202020000000000000000000002020202020000000000020202020200000000000505050202000002020205050502020000020202050505020200000202050-1-1-1-1400-2700-3500-35-1111111111",
            "10511052105310541051105110521053105410512020202020202020202000000000000000000000000000000000000000000000000000000000000000000000000000000000202020202020202020201051105210531054105110511052105310541051-1-1-1-3000-3900-4800-55-1111111111",
            "10101010101010101010101020202020202020201020000000000000000000200020002000200020200020002000200020000020002000200020002020002000200020002000102000000000000000001010202020202020202010101010101010101010-2-3-1-3500-4500-5900-55-0001111000",
            "00000000000000000000000000105020001050200000001050200010502000105020001050200000001050200010502000000000001050200010502000000010502000105020001050200010502000000010502000105020000000000000000000000000-1-1-1-2300-3200-4500-55-0001111000",
            "00000000000000001054000000000000000010530000000000000000105100000000000000001052000000000000000010140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000-1-1-1-2700-3600-4900-50-1111111111",
            "00105010501050100010005050505050505050000000000000000000501000000000000000005050000000000000000050100000000000000000501000000000000000005050000000000000000050100050505050505050500000105010501050100010-1-1-1-3800-4500-5900-55-1111111111",
            "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010101010101010101010501010505050501010505050505050505050505050505050101050505050-1-1-1-2500-3200-3800-40-1111111111",
            "00202010000000000020002020102000000000200020202020200000002000202010202020002020002020202020200020200020202020202000202000202010202020002020002020202020000000200020201020000000002000202010000000000020-0-2500-1-2300-3100-4300-48-1111111111",
            "04042050202020502020100420202050202020501010205020202050202010001020205020202050100000102020205020201000000010502020205010000000001020502020100000000000102020501000000000000010202010101010101010101050-1-1-1-2900-3500-4300-45-1111111111",
            "10000010505050500000100010505050505000001010505050505050000010202010101010100000000000000000000000000000000000000000000010202010101010100000101050505050505000001000105050505050000010000010505050500000-1-1-1-2500-3400-4300-45-1111111111",
            "00000000000000000000000000000000000000000000000000303030303000000000002020202030000000000020202020300000000000202020203000000000002020202030000000000030303030300000000000000000000000000000000000000000-0-1-1-2200-2800-4000-48-1111111111",
            "00000000000000302050000000000000003020500000000000000030205000003030303030303050000000000000000000500000000000000000005000003030303030303050000000000000003020500000000000000030205000000000000000302050-1-1-1-2000-3100-4100-42-1111111111",
            "50505020000020205050505020200000205050505050502000002020505050502020000020505050505050200000202050505050202000002050505050505020000020205050505020200000205050505050502000002020505050502020000020505050-1-1-1-2500-3300-4200-40-0110000110",
            "00000000000000000000000000005555555500000000000055606030000000000000556060300000000000005555555500000000000000000000000000555555550055555555005560603000556060300055606030005560603000555555550055555555-1-1-1-2500-3300-4500-60-1111111111",
            "30303020000020300000000030200000203000000000302000002030000030303020202020303030202020303030302020200000203000003020000000002030000030200000202020303030302020203030302020202030303000003020000020300000-2-1-1-2600-3600-4400-58-0110011000",
            "00003053300000000000000030303000000000000000000000000000000000000000000000101010000000000000001051100000000000000010101000000020202000000000000000205220000000000000002020200000000000000000000000000000-1-1-1-1600-2000-2600-25-1111111111",
            "00000000000000000000000000000000000000000000000000000000000020302030203020302030501050501050501050505010505010505010505030203020302030203020000000000000000000000000000000000000000000000000000000000000-1-2000-1-2800-3600-4500-52-1111111111",
            "00000000000000000401000000303030303030040000300303030303300100300303030303300104003003033003030330010030030303030330010400300303300303033001000030030303033001040000003030303030300100000000000000000104-3-50-3-2000-2600-3000-21-1111111111",
            "30300201040304010230003030020402010330300000303030033030300000000000303030000000000000000000000000000000000000000000002020200000000000202020042020200020202003040302042020200103020101020301020402040301-4-2200-1-2000-2600-3400-23-1111111111" // LABS 100 por 2200
        ],
        [
            "00040103030310000000000002030104100000000000020104031010101000000402030304010000000104040303030200000403010102020301000004020404040404020000010302020101101010100000000002011000000000000000040110000000-4-1000-1-800-1100-1400-20-1111111111",
            "00000000000000021010000000001000040403101010101010100101020300000000100203010102000000000401010401010000000002010401010200000000100101010304101010101010030202030000000010020104041000000000000002011010-4-1100-1-1000-1300-1500-25-1111111111",
            "00101000000000000000100000100000000000101000001000000000100000101000000000001000000000000000000000100000000000101000000000000000100000100000000000001000001000001000000000101000000000100000000000000000-3-33-2-1600-1900-2200-35-1111111111",
            "00000000000003032020000000000000000320200000000000000000202000000000000000002020000000000000000020200000000000000000202000000000000000002020000000000000000020200000000000000004202000000000000004042020-0-1500-1-1800-2300-2500-40-1111111111",
            "00000020000000200000000000002000200000000000000000200000000020000000200020000000002000200000002000200000200000000000200000200020000000200020200000002000200000000000000000200000000000000000200020000000-2-2-1-2700-3500-4800-65-1111111111",
            "00000000000000200000002010001000001000000000000020000000002000100000000020100010002000000000000000000000001020000010000010200000000000200000000000002000000000100020000010001020002000100000000000000000-4-1700-1-1700-1900-2200-35-1111111111",
            "10000000000000000000000020505000205050000000205050002050500200002050500020505401100020505000205351011000205050002051510100002050500020535101000020505000205054010000205050002050500210000000000000000000-1-1-1-2000-2600-3600-38-1111111111",
            "00000000000000000000100010001000100010001000100010001000100000000000000000000000001020001020001020000020200020200020200000202000202000202000002020002020002020000010200010200010200000000000000000000000-3-50-1-2000-2500-3000-50-1111111111",
            "00000000000000000000000000000000000000000000505050505050000000005000000000500000000050005050005000000000500050500050000000005000000000500000000050505050505000000000000000000000000000000000000000000000-1-1-1-1800-2100-2700-26-1111111111",
            "00000020000000101010000000202000000010100000000020200000001000000000002020000050101010101010502000501010101010105020005000000000002020000050000000002020000000100000002020000000101000000020000000101010-1-2000-1-1000-1900-2700-45-1111111111",
            "00000000000000000000000030303000202020000000305050002050500000003030300020505000000000000000202020000000202020000000000000002050500030303000000020505000305050000000202020003030300000000000000000000000-1-1-1-2100-3000-3400-35-1111111111",
            "00300000300000300000200030000030000030000020003000003000003000002000300000300000200000200030000030000020000020003000003000002000002000300000200000200000200030000020000020000020003000002000002000002000-0-1-1-2000-3000-3600-40-1111111111",
            "00000000000000000000000000000000000000300000000000000000301000000000000000301050000000000000301050500000000000303050505000000000000030105050000000000000003010500000000000000000301000000000000000000030-1-2000-1-3500-4200-4700-45-1111111111",
            "00000000000000000000000030303010303030000000305050005050300000003050500050503000000010000000000010000000100000000000100000003050500050503000000030505000505030000000303030103030300000000000000000000000-1-1-1-2000-2700-3700-50-1111111111",
            "00200000000505000000200020000005050000000020000000050500000020002000000505000000002000000005050000002000200000050500000000200000000505000000200020000005050000000020000000050500000020002000000505000000-2-2-1-3200-4200-5500-60-1111111111",
            "00000040000000400050000000400000004000500000004000000040005000000040000000400050000000101010101000501010101000000010101000000040000000400050000000400000004000500000004000000040005000000040000000400050-1-3-1-2800-3400-4500-62-1111111111",
            "00000000301055105510000000003020505050550000000030200000501000000000302000005055000000003020000050100000000030200000501000000000302000005055000000003020000050100000000030205050505500000000301055105510-1-1-1-3500-4300-5900-68-1100000000",
            "00000020550000000000000000205500000000000000002055000000100000000020550000101010000000205500005555550000002055000055555500000020550000101010000000205500000010000000002055000000000000000020550000000000-1-1-1-3500-4200-5300-55-1100000000",
            "00000000000000000000000000000000000000000005050505050505050020002010200000000000102010201020000000202010200020102000201000000000002010201020000000000000201020000005050505050505050000000000000000000000-3-50-0-2200-3000-3700-45-1111111111",
            "00000020050000000000000000200505000000000000000020050000000000000000200500000000000000002005050000000000000000200500000000000000002005000000000000000020050500000000000000002005000000000000000020050000-2-3-1-4000-4500-5700-55-1111111111",
            "00000000000000000000000000000000000000000000050500000505000000400555505055050000004000505555500000000040005055555000000000400555505055050000000005050000050500000000000000000000000000000000000000000000-1-1-1-1400-2100-2600-30-1100000000",
            "00002020202020205030000055555555555550300000553030303030503000005555555555555030000020202020202050300000202020202020503000005555555555555030000055303030303050300000555555555555503000002020202020205030-1-1-1-4000-4600-5600-65-1100000000",
            "00004000000000200040002000300000000030000000000000000000000000000030003000000030000020000000400020000000004000200000004040000000000000000000002000002000000030003000004000300020000000000000000000004000-4-3400-1-3300-3800-4200-35-1111111111",
            "00000060000000000030000000500000000000306050000050000000003000500000005050000030000050500000005050306050005000505050503000000050505050500030505050000050000000306000000050600000003000000060000000000030-1-3400-1-2500-3100-4100-38-1111111111",
            "00000000000010101010000000000000100060500000000000004000005000000000000010101010000000000000100000500000000000004000605000000000000010000050000000000000101010100000000000004000005000000000000010006050-1-3400-1-5000-6500-7500-90-1111111111",
            "00000000202060505050000000000020206050500000000000002020605000000000000000202060000000000000000020200000000000000000002000000000000000000030000000000000000030300000000000000030305000000000000030305050-1-3400-1-3000-3500-3900-45-1111111111",
            "00000000000000000010000000000000000010600000000000000010605000000000000010605050000000000000001050500000000000001060505000000000000000106050000000000000000010600000000000000000001000000000000000000010-1-3400-1-4000-5200-6200-65-1111111111",
            "00000000002020300040000000000020200030000000000000202030004000000000002020003000000000000020203000400000000000202000300000000000002020300040000000000020200030000000000000202030004000000000002020003000-2-3-1-4500-6200-7500-75-0011111100",
            "00000000000020100000000000000000203010000000000000002030501000000000000020305060000000000000203050600000000000002030506000000000000020305060000000000000203050100000000000002030100000000000000020100000-1-3400-1-3800-4500-5300-55-1111111111",
            "10101010101010101010005050505050505050100050606060606060501000506050505050605010005060506060506050100050605060605060501000506050505050605010005060606060606050100050505050505050501010101010101010101010-1-1-1-2500-4000-5000-50-1111111111",
            "00000000000000000000004040404040404040000040303030303030400000404040404040304000000000002020403040000000000020204030400000202020000040304000002020200000403040000020202000004040400000000000000000000000-3-65-2-3000-4500-5600-48-1111111111",
            "50501010101010105050505050503030505050500050502020202050501000502020303020205010003020303030302030100030203030303020301000502020303020205010005050202020205050105050505030305050505050501010101010105050-1-1-1-2900-4000-5400-65-1111111111",
            "30302020200000000000003030202020000000000000303020202000000000000030302020200000000000003020202000000000000030202020000000000030302020200000000030302020200000000030302020200000000030302020200000000000-0-1-1-2500-3800-4500-48-1111111111",
            "00000000000000000000030201020304101010100104032020203030303003020201020330405050010401202020304050500402032020203040505002010402030430405050040103202020303030300102020401031010101000000000000000000000-1-2000-1-2200-2700-3700-45-1111111111",
            "00000000000000203010000000000000203010500000000000203010505000000000203010505000000000203010505000100000203010505000101000203010505000101000203010505000101000003010505000101000000010505000101000000000-1-1-1-1800-2900-3800-70-1111111111"
        ],
        [
            "00001000030404100000001000100103100310010000030401030404030400030303040201010401000003030402010104030000010402030101010300000104010403020300000003040301040301040010001003041003100000001000000100100000-4-200-1-200-300-400-10-1111111111--1111111111",
            "00000000000400000000000000020102011010101010100103040301010100040103030403101010000001030203030302030000040303030203030310101002010201020401000000000000041010101010100000000000000000000000000000000000-4-550-1-550-650-820-12-1111111111--1111111111",
            "00000000000000002020000000000000000000200000000000000000000000000020202020200203000020208004202020040000202004802020200300000020202020200102000000030202010200000000000104048304022000000003040402012020-0-800-1-900-1400-1800-33-1111111111--1111111111",
            "00000000000000000000000020002020002000000000200020200020000000000000000000000000202020202020202020202020202020202020202000000000000000000000000020002020002000000000200020200020000000000000000000000000-0-800-1-1200-2000-2500-45-1111111111-09006010190170112902801239039013-1111110000",
            "10100000000000001010100000000000000000100000000020200000000000000020202020000000000020303020203000000000203030202030000000000030303030000000000000003030000000001000000000000000001010100000000000001010-0-800-1-1500-2500-3500-50-1111111111--0011111100",
            "00000000202000000000000000002020200000000000202000003030000000002020200030302000202000203030000020202020000030302000202000203030002020200000000030300000202000000000002020200000000000000000202000000000-0-800-1-1500-2500-3500-50-1111111111--1111111111",
            "00000000000000208080000000000000002010800000000000000000202000000000000000002080000000000000000020800000000000000000208000000000000000002080000000000000000020200000000000000020108000000000000000208080-4-2700-1-2700-3200-3500-50-1111111111--1111111111",
            "00000000008020300000000000000080302000000000000000802030000000000000008030200000000000000080203000000000000000803020000000000000008020300000000000000080302000000000000000802030000000000000008030200000-0-2700-1-2700-3500-4000-50-1111111111--1111111111",
            "00000000000000000000201020202010200000001010102010101000000020102020201020000000000000008000800000000000008000800000000000000020102020201020000000101010201010100000002010202020102000000000000000000000-0-2700-1-2700-3500-4000-50-1111111111--1111111111",
            "00000000000000000000202020202020300000002020002020300030000020202020202030000000000000000000000000800000000000000000008000000030202020202020000030003020200020200000003020202020202000000000000000000000-0-2700-1-2700-3500-4000-50-1111111111--1111111111",
            "00002020203030300000000020505050305000000000205050505050000000002020203000000000000000000000000000000000000000000000000000000000302020200000000050505050502000000000503050505020000000003030302020200000-1-2700-1-2000-2500-3000-35-1111111111--1111111111",
            "20202020202020202020205050505050505050002050505050505000000020505050000000000000000000000000000000000000000000000000000020505050000000000000205050505050500000002050505050505050500020202020202020202020-1-2700-1-2000-2500-3000-35-1111111111--1111111111",
            "00000000000000000000000000000000000000000000303030303030300300003001020401023004000030023030300330030000300330803003300100003004020130023001000030303030300030020000000000000000000000000000000000000000-5-2700-1-2000-2500-3000-40-1111111111--1111111111",
            "00000010000010000000000000100000105050500000001000001050605000000010000010505050000000101010100000000000002000002000000000000020000020000000000000200000200000000000002000002000000000000020000020000000-1-2700-1-2000-2500-3000-40-1111111111-02005010120160112202701232038013420490145905071569061716790727178908371899094719-1111100000",
            "00000000000000000000000000000000000000000010101010101010202000100000000000202020001000000000202020200010000000002020202000100000000000202020001010101010101020200000000000000000000000000000000000000000-0-2700-1-1800-2500-3000-35-1111111111-09003210190142118902521299036213-1111111111",
            "00000000308030505050000000308020803050500000000030803000005000000000003000000050000000000000000000500000000000000000005000000000003000000050000000003080300000500000003080208030505000000000308030505050-1-2700-1-1800-2500-3000-45-1111111111--1111111111",
            "10100000000000001010100000000000000000100000000060608000000000000060505060800000000060506060506000000000605060605060000000000060505060800000000000006060800000001000000000000000001010100000000000001010-1-2700-1-1800-2500-3000-40-1111111111--1111111111",
            "00000000000000000000000000000000000000001010103030303030303000000020200020200000000000202000202000000000002020002020000000000020200020200000101010303030303030300000000000000000000000000000000000000000-3-60-1-1800-2500-3000-40-0001111000-39000010490110115902801269039013-0001111000",
            "00000000000000209090000000000000209090900000000000209090902000000000209090902000000000209090902000000000209090902000000000209090902000000000209090902000000000009090902000000000000090902000000000000000-1-60-1-2300-3200-4000-55-1111111111--1111111111",
            "10000000000000000010101010101010101010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000308030803080308030801080108010801080108010101010101010101010-5-60-1-2800-4000-5000-50-1111111111--0011111100",
            "00000010000010000000005090105090105090005090005090005090000000509010509010509000000000100000100000000000001000001000000000509010509010509000509000509000509000000050901050901050900000000010000010000000-1-60-1-2000-3500-4000-60-1111111111-4200441052015411450247125503571302040414050507159206941695079717-1111111111",
            "00000000002000000000000000000020101010100000000000202080808000000000002010101010000000000020202020200000000000202020202000000000002010101010000000000020208080800000000000201010101000000000002000000000-0-60-1-2500-3500-4000-50-1111111111--1111111111",
            "10000000004090909000100000000040909000001040404040409000000000000000000000000000000000000000000000000000000000000000000000000000000000000000104040404040900000001000000000409090000010000000004090909000-1-60-1-2500-3500-4300-55-1111111111-39000110490111115902811269039113-1111111111",
            "00000010101000000000001010100000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000010101000000000000000000010101000000000-3-80-0-3000-5000-7000-50-1111111111-4900301059016011390222126903721329041414790584151906061689079617-0000110000",
            "00000000000020000030004040404020000080000040303040202000000000404030404040200020000040403030402020010000004040304040400100000000404030304002000000000040403040030000000000004040400400000000000000000003-0-80-0-3000-4000-4500-50-1111111111--1111111111",
            "10101010101010101010000000001000000050500000000010000050509000000000100000505090000000001000005090800000000010000050908000000000100000505090000000001000005050900000000010000000505010101010101010101010-1-80-0-3000-4000-4500-55-1111111111-1300851023017511330265124303551353044514630535157306251683071517-1111111111",
            "00000000001000000000000000000010000000000000000000100000000000000000001000000000101010101010101010101010101010101010101000000000100000000000002020201000202020000020202010002020200000000000100000000000-0-80-0-3000-4000-4500-55-1111111111-04006510140175112402851234039513690406147905161589062616990736170908601819097019290a801a390b901b-1111000000",
            "00000000000000000000404040404040404040403030303030303030303040404040404040404040000000000000000000000000000000000000000040404040404040404040303030303030303030304040404040404040404000000000000000000000-0-80-0-2700-3200-3500-40-1111111111-39000010490110115902801269039013-0001111000",
            "00000040808080808080000000408080808080800000004040404040408000000040202020204080000000402030302040800000004020303020408000000040202020204080000000404040404040800000004080808080808000000040808080808080-5-80-0-3000-3500-4000-50-1111111111--1111111111",
            "00401000000000000000004010000000000000000040100000000000000000401010101000000000004040404010000000000000000040100000000000000000401010108080000000004040401080800000000000004010808000000000000040108080-5-80-0-4000-5000-6000-60-1111111111-01000310110113112102231231033613440446145405561564066816760778178608881896099819-1111111111",
            "00100000100000100090001000001000001000904040400010000010009000004040404040404095505050505050505050905050505050505050509000004040404040404095404040001000001000900010000010000010009000100000100000100090-1-2700-1-1800-2500-3000-40-1111111111-00008210100192110302751213038513230495140605781516068816260798178008021890091219730a051a830b151b930c251c760d081d860e181e960f281f-1111111111",
            "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001010101010303030303000000080101020202020000000008010102020200000000000801010202000000000000080101020-5-80-0-4000-5000-6000-60-1111111111-69006010790170118902801299039013-1111100000",
            "00000000000010101010003030303040001010100030202020204000101000302030303030400010003020302020202040000040203020303030400010004030203020202040101000402030203030401010100040402030208010101010000040408080-3-80-1-3500-4500-5000-60-1111111111--1111111111",
            "00501000000000000000005010000000000000000050100000000000000010101010101010000000102020909090202020202020202090909020201000000010101010101010000000000000001050000000000000000010500000000000000000105000-1-60-1-4000-5000-6000-60-1111111111-01007810110188112102981279030313890413149905231509066016190770172908801839099019-1110000000",
            "80808080808080808080202020202020202020200000000000000000000000100010001000100000102020201020202010101020202010202020101000100010001000100000000000000000000000002020202020202020202080808080808080808080-5-60-1-3000-5500-7000-70-1111111111-29000010390110116902801279039013-0011111100",
            "00000000101010108060000000001010108060600000000010108060609000000000108060609090000000000060609090900000000000606090909000000000108060609090000000001010806060900000000010101080606000000000101010108060-1-1-1-3000-4500-5000-50-1111111111--1111111111",
            "00000000000000000000000020202020202000000020303030303030200020303080808080303020203080808080808030202030808080808080302020303080808080303020002030303030303020000000202020202020000000000000000000000000-5-1-1-2000-2700-3200-50-1111111111--1111111111",
            "00000000000000000000101010101010101010100000000000000000000010101010101010101010000000000000000000001010101010101010101010101010101010101010009090909090909090900090909090909090909000909090909090909090-1-1-1-2500-3700-4200-50-1111111111-090020102901401149028012-1000000000",
            "00000000000000000030000000000000000030300000000000003030303000000010101010303030000000102000005050500000001020000050505000000010101010303030000000000000303030300000000000000000303000000000000000000030-1-1-1-2500-3700-4200-50-1111111111-4200441052015411-1111111111",
            "00000010200020009090000000100020002090900000001020002000909020101010101010109090201000505050505090902010005050505050909020101010101010109090000000102000200090900000001000200020909000000010200020009090-1-1-1-2500-3700-4200-50-1111111111-12001410400142115002521282038413-1111111111"
        ],
[
            "10202020202020202010000000000103010101030000010102020303040100000302030101020401000001040403040201030000020304020302040300000302020101020302000000000103040104040000000000000000000010202020202020202010-4-500-1-400-550-750-14-1111111111--1111111111", //1
            "00000000000000000000000000000000000000000000000003020402020000000202040101010300020402010101040302000301010102040200000002040303040000000000202020202020202020200000000000000000000000000000000000000000-4-800-1-800-1100-1500-18-1111111111-0900801019019011-1111111100", //2
            "00000000000000000000000000001010101010000000000020000000200000000000200070002000000000002000000020000000000020000001200000000000200070012000000000002000000120000000000010101010100000000000000000000000-0-1300-1-2000-2800-3500-50-1111111111--1111111111", //3
            "00000000000000000000000040404040404040400000402020302030304000004020203020303040000040303030202020400000402020203030304000004030302030202040000040303020302020400000404040404040404000000000000000000000-0-1300-1-2500-3200-3800-55-1111111111--1111111111", //4
            "00000000000000000000000000002020202000000000000020b0b02000000000000020b0b020000000000000202020200000000000002020202000000000000020b0b02000000000000020b0b02000000000000020202020000000000000000000000000-6-1300-1-3000-4500-5000-60-1111111111--1111111111", //5
            "00000000000030208080000000000000302020800000000000003030202000000000000000303030000000000000000000000000000000000000000000000000000000303030000000000000303020200000000000003020208000000000000030208080-5-1300-1-2500-3500-4500-60-1111111111--1111111111", //6
            "00000000202020000000000020204040402020000020404040504040402000204050505050504020002040909050909040200020409090509090402000204050505050504020002040404050404040200000202040404020200000000000202020000000-1-1300-1-2000-2800-3300-40-1111111111--1111111111", //7
            "00000000002030a0a0a00010101000002030a0a0000010101000002030a000000010101000002030000000001010100000202000000000101010000030200000000010101000a0302000000000101000a0a03020000000001000a0a0a030200000000000-3-60-2-3000-3500-4000-60-1111111111--1111111111", //8
            "00000000000000000000200000000000000000002020001000201000002010200010002010000020101000100020100000201010001000201000002010200010002010000020202000100020100000202000000000000000000000000000000000000000-0-1300-1-3000-3800-4500-60-1111111111-22012711320237124203471352045714620567157206771629092419390a341a490b441b590c541c690d641d790e741e-1110000111", //9
            "40200000000000000000404020000000700070002040402000000000000000204040200070007000000020404020000000000000002040402000000000000000204040200000000000000020404020000000000000002040402000000000000000204040-0-1300-1-3000-3800-4500-60-1111111111--1111111111", //10
            "00000000101010100000000010005050105000000000000010101010000000001000505010500000000000001010101000000000100050501050000000000000101010100000000010005050505050500000000050505050505000001000505050505050-1-1300-1-3000-3800-4500-60-1111111111-150017103501371155025712-1111111111", //11-36
            "00200020002000200020000020002000200020000020002000200020002000002000200010101001002000200020108302030000200020001084010400200020002010101003000020002000200020000020002000200020002000002000200020002000-4-5000-1-5000-6000-6500-70-1111111111--1111111111", //12-37
            "101010101010101010101020302030203020301010302030203020302010102030203020302030101010101010101010101000000000a0a0a0a0a00000000000a006a006a00000000000a0a0a0a0a00000000000a006a006a00000000000a0a0a0a0a000-6-5000-1-3000-4000-4500-70-1111111111--0000011111", //13-38
            "00000000000000000000000000000000000000001010000000100000001050501060601090909090505010606010909090905050106060109090909050501060601090909090101000000010000000100000000000000000000000000000000000000000-1-5000-1-3000-4000-5500-75-1111111111-09003010190140118902501299036013310433144105431551065316610763173408361844094619540a561a640b661b-1100000011", //14-39
            "2020202020202020202030303030303030303030101010101010101010100000000000000000000000b0b000b0b000b0b00000b0b000b0b000b0b00000000000000000000000101010101010101010103030303030303030303020202020202020202020-6-5000-1-2500-3500-4000-60-1111111111--0001111000", ///15-40
            "00000000000050505050101010101010105050500000000000a0101010500000000000a0a02010100000000000a0302090600000000000a0302090600000000000a0a02010100000000000a0101010501010101010101050505000000000000050505050-1-5000-1-3000-4000-5000-75-1111111111-090020101901301129024012790350138904601499057015-1000000001", //16-41
            "00505050505050505050005050505050505050501010101010101010101000000000000000000080000000000010100000800000007000001010008000000000000000101080000000000000000010100000007000007000000000000000000000000000-1-5000-1-3000-4000-4500-70-1111111111-8900001099011011-0001111111", //17-42
            "0000000000000000000000b0b0b0b0b02020200000b0202020b02080200000b0208020b02020200000b0202020b0b0b0b00000b0b0b0b0202020b00000202020b0208020b00000208020b0202020b00000202020b0b0b0b0b00000000000000000000000-5-5000-1-3000-4500-5500-70-1111111111--1111111111", //18-43
            "70000000000000000070000040404040404000000040000000000000400000400070303070004000004000303030300040000040003030303000400000400070303070004000004000000000000040000000404040404040000070000000000000000070-0-5000-1-4000-4500-5000-60-1111111111--1111111111", //19-44
            "000000a0a00000a0a0000000a0a00000a0a0000000a0a00000a0a00000a0a0a00000a0a00000a0a0a00000a0a00000a0a0800000a0a00000a0a0808000a0a00000a0a08080a0a0a00000a0a08080a0a0a00000a0a08080a0a0000000a0a08080a0a00000-3-80-0-3500-4500-5000-60-1111111111--1111111111", //20-45
            "00000070001050505050000000700010506060500000007000105060605000000070001050606050000000700010506060500000007000105060605000000070001050606050000000700010506060500000007000105060605000000070001050505050-1-80-0-4500-5500-6500-85-1111111111-04009610140186112402761234036613440456145405461564063616740726178408161894090619-1111111111", //21-46
            "10101010101010101010101010101010101060601010101010606010606000106060106060106060001060601060601060600010606010606010606000106060106060100000001060601000000000000010000000000000000000000000000000000000-1-80-0-3500-4500-5000-70-1111111111-30003210400142115002521260036213700472143305251543063516530745176308551873096519260a181a360b281b460c381c560d481d660e581e-0001111111", //22-47
            "000000002020202020200000000020b0b0a0b0b00000000020b0b0a0b0b000000000202020202020000000000000a0b0b020000000000000a0b0b020000000002020202020200000000020b0b0a0b0b00000000020b0b0a0b0b000000000202020202020-6-80-0-5000-6000-7000-75-1111111111--1111111111", //23-48
            "2020202020202020202020b0b020b0b020b0b02020b0b020b0b020b0b020202020202020202020202020202020202020202020202020202020202020a0a0a0a0a0a0a0a0a0a0000000000000000000000000000000000000000000000000000000000000-6-80-0-4000-5000-6000-80-1111111111--1111111111", //24-49
            "00001000000000100000000010000000001000000000100000000010000000001000000000100000101010000000000000001010100000000000000010101000000000007070101010000000007070701010100000000070707010101000000000007070-0-80-0-4000-5000-6000-80-1111111111-0100081011011811210228123103381309050315190613162907231739083318060b631b160c731c260d831d360e931e-1111100000", //25-50
            "0000002070b000506090000000b00020705060900000002070b000506090000000b00020705060900000002070b000506090000000b00020705060900000002070b000506090000000b00020705060900000002070b000506090000000b0002070506090-1-80-0-5000-6000-7000-80-1111111111--1111111111", //26-51
            "00000000000000000000101010101010101010100090900010100090900000909000101000909000101010101010101010101010101010101010101000909000101000909000009090001010009090001010101010101010101000000000000000000000-1-80-0-5000-6000-7200-82-1111111111-6300261073013611290220123903301323046614330576159906701609076017-1000000001", //27-52
            "70700000000000000000707070000000000000000070707000000000000000007070700000000000000000707070000000000000000070707000000000000000007070700000000000000000707070000000000000000070707000000000000000007070-3-80-3-4000-5000-6000-70-1111111111--1111111111", //28-53
            "0000000000000000000000a0a02020a0a020200200a0a02020a0a0202001002020a0a02020a0a003002020a0a02020a0a08000a0a02020a0a020208000a0a02020a0a0202003002020a0a02020a0a001002020a0a02020a0a00200000000000000000000-0-80-3-4000-5000-6000-80-1111111111--1111111111", //29-54
            "00004040404040404040000040a040b040a040b0000040b040a040b040a0000040a040b040a040b0000040b040a040b040a0000040a040b040a040b0000040b040a040b040a0000040a040b040a040b0000040b040a040b040a000004040404040404040-0-80-3-5000-6500-7500-80-1111111111--1111111111", //30-55
            "20200000000000002020200000a0a0a0a00000200000a000000000a0000000a0000010100000a00000a0001020201000a00000a0001020201000a00000a0000010100000a0000000a000000000a00000200000a0a0a0a000002020200000000000002020-0-80-3-3000-4500-5500-70-1111111111--1111111111", //31-56
            "00000000007000000070100000000000007000001010000000700000007000101000000000700000000010100070000000700000001010101010101000000000101010101010000000000010101010100000000000001010101000000000000000101010-0-80-3-3000-4500-5500-70-1111111111-96000010-0001111111", //32-57
            "000000a0000050101010000000a0005050101000000000a000501010000010101010101010000000000000000000000000000000000000000000000010101010101010000000000000a0005010100000000000a0005050101000000000a0000050101010-1-80-3-3000-4500-5500-80-1111111111-190000102901101139022012690370137904801489059015-0000110000", //33-58
            "00000000a0a0a0a0808000000000a0a0a000808000000000a0a0000000a00000003030000000a0a000002030000000a0a0a000202000000030a0a0a000000000003030000000000000002020000000000000000020000000000000000000000000000000-5-80-3-5000-6500-7500-85-1111111111--1111111111", //34-59
            "00000010505050505050101010105050505050500000001010101010101010101010000000105050000000101010101050501010101000000010505000000010101010105050101010100000001050505050501010101010505050505010000000101010-1-80-3-5000-6500-7500-50-1111111111-02004010220160114202741262039413760434149605541536068016560790178208041892091419090a381a190b481b390c581c490d681d590e781e690f881f-1010000000", //35-60
            "00000000000000a0a0a000000000000000a0a0a000000000202020a0a0a00000002020102020000000000020101010200000002020202010202000002020102020202000000020101010200000b0b0b020201020200000b070b000202020000000b0b0b0-6-80-3-4000-5500-6000-85-1111111111--1111111111", //36-59
            "000000000000000000000000a0404040404040400000a0404040404040400070a0b040b040b040b00000a0404040404040400000a0404040404040400070a0b040b040b040b00000a0404040404040400000a04040404040404000000000000000000000-6-80-3-4000-5500-6000-70-1111111111--1111111111", //37-59
            "00001000001010105050000010000010105090900000100000105090909000001000001050909090100010100010109090901000101000101090909000001000001050909090000010000010509090900000100000101050909000001000001010105050-1-80-3-3500-4500-5000-70-1111111111-01006010110170112102801231039013610463147105731581068316910793176408031874091319840a231a940b331b040c261c140d361d240e661e340f761f-1111000000", //38-59
            "0000001000a0001000200000001000a0001000200000001000a0001000200000001000a0001000200000001000a00010002000000000000000000000b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b020202020202020202020-0-1-1-4000-5000-6000-70-1111111111-0200041012011411220224123203341306040814160518152606281636073817-1111111111", //39-59
            "90909090909090909090901000a0a070b0709090901000a0a0b070b09090901000a0a070b0709090901000a0a0b070b09090901000a0a070b0709090901000a0a0b070b09090901000a0a070b0709090901000a0a0b070b0909090909090909090909090-1-1-1-6000-8000-9500-100-1111111111-1000121020012211300232124003421350045214600562157006721680078217-1111111111" //40-59
        ]
    ];
    return LevelManager;
})();

var LevelData = (function () {
    function LevelData(n, data, s) {
        if (typeof s === "undefined") { s = 0; }
        this.state = 0;
        this.levelNumber = 0;
        this.stars = 0;
        this.score = 0;
        this.pushPositions = [];
        this.hasWhiteChoco = false;
        this.hasBlackChoco = false;
        this.hasBomb = false;
        this.teleportData = [];
        this.data = data;
        if (!this.data)
            this.data = LevelData.defaultData;

        //this.data = "00000000000000000000000000000000000000000000000000202020000000000000002003200000000000000020202000000000000000000000000000003030300000000000000030033000000000000000303030000000000000000000000000000000-0-1-1-500-1500-3000-40";
        this.state = s;
        this.levelNumber = n;
        this.stars = 0;

        for (var x = 0; x < Match3Level.LEVEL_W; ++x)
            this.pushPositions.push(x);

        var splits = this.data.split("-");
        this.cellData = splits[0];
        this.targetData = parseInt(splits[1]);
        this.customData = parseInt(splits[2]);
        this.customData2 = parseInt(splits[3]);
        this.movesLeft = parseInt(splits[7]);
        this.starValues = [parseInt(splits[4]), parseInt(splits[5]), parseInt(splits[6])];

        if (splits.length > 8) {
            this.pushPositions = [];
            var pushData = splits[8];
            for (var i = 0; i < pushData.length && i < Match3Level.LEVEL_W; ++i)
                if (parseInt(pushData.charAt(i)) == 1)
                    this.pushPositions.push(i);
        }

        if (splits.length > 9) {
            var tData = splits[9];
            for (var i = 0; i < tData.length; i += 4) {
                var tDataX = [];
                for (var j = 0; j < 4; j++)
                    tDataX.push(j < 3 ? parseInt(tData[i + j]) : LevelData.cellCodes.indexOf(tData[i + j]));
                this.teleportData.push(tDataX);
            }
        }

        if (splits.length > 10) {
            this.jellyPushPositions = [];
            pushData = splits[10];
            for (i = 0; i < pushData.length && i < Match3Level.LEVEL_W; ++i)
                this.jellyPushPositions.push(parseInt(pushData.charAt(i)) == 1);
        }

        for (var x = 0; x < Match3Level.LEVEL_W; ++x) {
            for (var y = 0; y < Match3Level.LEVEL_H; ++y) {
                var t = Match3Level.getCellDataType(this.cellData, x, y);
                if (t == "2")
                    this.hasWhiteChoco = true;
                if (t == "3")
                    this.hasBlackChoco = true;
                if (t == "7")
                    this.hasBomb = true;
            }
        }

        switch (this.targetData) {
            case 0:
                this.targetSpriteName = "chocolate white";
                break;
            case 1:
                this.targetSpriteName = "cookie";
                break;
            case 2:
                this.targetSpriteName = "cupcake";
                break;
            case 3:
                this.targetSpriteName = FieldObject.assetNames[this.customData2];
                break;
            case 4:
                this.targetSpriteName = "star";
                break;
            case 5:
                this.targetSpriteName = "water";
                break;
            case 6:
                this.targetSpriteName = "bush";
                break;
            case -1:
                this.targetSpriteName = "star";
                break;
        }
    }
    LevelData.prototype.getCakeSpawnPos = function () {
        var id = getInt(this.pushPositions.length);
        return this.pushPositions[id];
    };
    LevelData.CLOSED_STATE = 0;
    LevelData.OPENED_STATE = 1;
    LevelData.COMPLETED_STATE = 2;

    LevelData.defaultData = "=00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000-4-99999-1-500-1500-3000-99";

    LevelData.cellCodes = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h"];
    return LevelData;
})();
var SinglePlayObject = (function (_super) {
    __extends(SinglePlayObject, _super);
    function SinglePlayObject(x, y, name, frame, parent, regX, regY, scale) {
        if (typeof scale === "undefined") { scale = 1; }
        _super.call(this);

        var s = createSpriteFromSpritesheet(name);
        s.play();
        s.scaleX = s.scaleY = scale;
        s.regX = regX / scale;
        s.regY = regY / scale;
        s.x = x;
        s.y = y;
        this.lastFrame = frame;

        this.sprite = s;
        addChild(this.sprite, parent);
    }
    SinglePlayObject.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        var s = this.sprite;
        if (s.currentAnimationFrame >= this.lastFrame) {
            s.stop();
            this.destroy();
        }
    };
    return SinglePlayObject;
})(GameObject);
var BlockType;
(function (BlockType) {
    BlockType[BlockType["kFullBlockType"] = 0] = "kFullBlockType";
    BlockType[BlockType["kSingleBlockType"] = 1] = "kSingleBlockType";
    BlockType[BlockType["kDoubleBlockType"] = 2] = "kDoubleBlockType";
    BlockType[BlockType["kTripleBlockType"] = 3] = "kTripleBlockType";
    BlockType[BlockType["kColorBlock"] = 4] = "kColorBlock";
    BlockType[BlockType["kBombBlock"] = 5] = "kBombBlock";
    BlockType[BlockType["kWaterBomb"] = 6] = "kWaterBomb";
    BlockType[BlockType["kPlantBomb"] = 7] = "kPlantBomb";
})(BlockType || (BlockType = {}));

var ClearData = (function () {
    function ClearData(d, clickColor) {
        if (typeof clickColor === "undefined") { clickColor = false; }
        this.delay = d;
        this.clickOrColor = clickColor;
    }
    return ClearData;
})();

var CellObject = (function (_super) {
    __extends(CellObject, _super);
    function CellObject(x, y) {
        _super.call(this);
        this._isBlock = false;
        this.isTempBlock = false;
        this.tempBlockTime = -1;
        this.breakCountLeft = 0;
        this.marksLeft = 0;
        this.mark = null;
        this.block = null;
        this.blockTop = null;
        this.colorBlock = -1;
        this.bonusComboCount = -1;
        this.scoreToAdd = -1;
        this.breakMatchId = -1;
        this.changeTypeIn = -1;
        this.typeToChange = -1;
        this.clearsIn = [];
        this.removeBlockIn = -1;
        this.isBombBlocked = false;
        this.timeSinceBlockRemove = 100;
        this.teleportCellStart = null;
        this.teleportCellEnd = null;
        this.isTeleportLocked = false;
        this.lastBlockSet = -1;
        this.removeBlockLock = -1;
        this.fullClearsIn = [];
        this.isWaterBlock = false;
        this.isPlantBlock = false;
        this.plantBreaksLeft = -1;
        this.dontRemoveMark = false;
        this.prevMarkAlpha = 1;
        this.isPushEnabled = true;
        this.teleports = [];
        this.lastTeleportMove = -1;
        this.timeSinceLastTypeChange = 0;

        this.x = x;
        this.y = y;

        this.pos = cjp(Match3Level.instance.gridToStageX(x), Match3Level.instance.gridToStageY(y));
        var tSize = this.level.tileSize;
        this.rect = new createjs.Rectangle(this.pos.x - tSize / 2, this.pos.y - tSize / 2, tSize, tSize);
    }
    Object.defineProperty(CellObject.prototype, "isChangingType", {
        get: function () {
            return this.changeTypeIn >= 0;
        },
        enumerable: true,
        configurable: true
    });

    Object.defineProperty(CellObject.prototype, "isObjectBlocked", {
        get: function () {
            return this.colorBlock >= 0 || this.isWaterBlock || (this.isPlantBlock && this.plantBreaksLeft == 2);
        },
        enumerable: true,
        configurable: true
    });

    CellObject.prototype.prepareToChangeType = function (time, type) {
        if (typeof type === "undefined") { type = -1; }
        while (type < 0) {
            type = getInt(this.level.assetNumber);
        }

        this.changeTypeIn = time;
        this.typeToChange = type;
    };

    CellObject.prototype.setMark = function (n) {
        if (typeof n === "undefined") { n = 1; }
        if (n == this.marksLeft)
            return;

        this.prevMarkAlpha = 1;
        this.level.needToUpdateBack = true;

        var prevMark = this.marksLeft;
        this.marksLeft = n;
        this.level.needToUpdateBack = true;

        if (prevMark > 0 && n < prevMark && this.mark && n >= 0)
            this.level.objects.push(new CookieTweenSprite(this.mark.x, this.mark.y, n));

        if (this.marksLeft <= 0) {
            removeClip(this.mark);
            this.mark = null;
            this.level.target.onMarkRemoved();
            return;
        }

        var name = n == 1 ? "cookie" : n == 2 ? "cookie honey" : "cookie x3";
        var s = this.mark ? this.mark : createSpriteFromSpritesheet(name);
        s.gotoAndStop(name);

        //s.scaleX = s.scaleY = App.level.tileSize / FieldObject.TILE_SIZE;
        s.x = App.level.offsetX + this.x * App.level.tileSize;
        s.y = App.level.offsetY + this.y * App.level.tileSize;
        s.regX = s.regY = 4;
        if (s.parent == null)
            App.level.markLayer.addChild(s);
        this.mark = s;
    };

    CellObject.prototype.reset = function () {
        removeClip(this.block);
        removeClip(this.mark);
        removeClip(this.blockTop);
        this.blockTop = null;
        this.removeBlockLock = -1;
        this.isTeleportLocked = false;
        this.block = null;
        this.mark = null;
        this.isPushEnabled = true;
        this.lastBlockSet = CellObject.lastBombRemove = -1;
        if (this.object) {
            Match3Level.pool.returnObject(this.object);
            this.object = null;
        }
        this._isBlock = false;
        this.isTempBlock = false;
        this.tempBlockTime = -1;
        this.breakCountLeft = 0;
        this.marksLeft = 0;
        this.colorBlock = -1;
        this.breakMatchId = -1;
        this.clearsIn.length = 0;
        this.removeBlockIn = -1;
        this.timeSinceBlockRemove = 100;
        this.lastBlockSet = -1;
        this.scoreToAdd = -1;
        this.bonusComboCount = -1;
        this.teleportCellStart = null;
        this.dontRemoveMark = false;
        this.teleportCellEnd = null;
        if (this.blockAnimation) {
            this.blockAnimation.destroy();
            this.blockAnimation = null;
        }
        this.teleports.length = 0;
        this.lastTeleportMove = -1;
        removeClip(this.teleportSprite);
        this.teleportSprite = null;
        this.teleportCellEnd = this.teleportCellStart = null;
        this.changeTypeIn = -1;
        this.isBombBlocked = false;
        this.fullClearsIn.length = 0;
        this.timeSinceLastTypeChange = 0;
        this.isWaterBlock = false;
        CellObject.waterRemoveMove = -1;
        this.isPlantBlock = false;
        this.plantBreaksLeft = -1;
    };

    CellObject.prototype.onTeleport = function (f) {
        if (this.isTeleportLocked)
            return;

        if (this.level.currentMove > this.lastTeleportMove) {
            this.teleports.length = 0;
            this.lastTeleportMove = this.level.currentMove;
        }

        if (this.teleports.indexOf(f) != -1)
            this.isTeleportLocked = true;
        else
            this.teleports.push(f);
    };

    CellObject.prototype.setTeleport = function (startCell, cell) {
        if (startCell)
            this.teleportCellEnd = cell;
        else
            this.teleportCellStart = cell;

        removeClip(this.teleportSprite);
        this.teleportSprite = createSpriteFromSpritesheet(startCell ? "teleport_in" : "teleport_out");
        this.level.bonusLayer.addChild(this.teleportSprite);

        this.teleportSprite.regX = this.teleportSprite.getBounds().width * 0.5;
        this.teleportSprite.regY = startCell ? 54 : 6;
        this.teleportSprite.x = this.pos.x;
        this.teleportSprite.y = this.pos.y + this.level.tileSize * (!startCell ? -0.5 : 0.5);
        //this.teleportSprite.play();
    };

    CellObject.prototype.prepareToTeleport = function (target) {
        this.teleportSprite.gotoAndPlay(this.teleportCellEnd ? "teleport_in" : "teleport_out");
        this.object.isMoving = true;
        target.setObject(this.object);
        this.teleportCellEnd.setObject(this.object);
        this.object.playAnimation(105, 1, 1);
        this.object.teleportTarget = target;
        this.onTeleport(this.object);
    };

    Object.defineProperty(CellObject.prototype, "isMarked", {
        get: function () {
            return this.marksLeft > 0;
        },
        enumerable: true,
        configurable: true
    });

    Object.defineProperty(CellObject.prototype, "isColorBlocked", {
        get: function () {
            return this.colorBlock >= 0;
        },
        enumerable: true,
        configurable: true
    });

    CellObject.prototype.setBlock = function (blockType, animFrame) {
        if (typeof animFrame === "undefined") { animFrame = -1; }
        //return;
        var breaks = blockType == 1 /* kSingleBlockType */ ? 1 : blockType == 2 /* kDoubleBlockType */ ? 2 : blockType == 3 /* kTripleBlockType */ ? 3 : 0;
        var color = blockType == 4 /* kColorBlock */;
        var bomb = blockType == 5 /* kBombBlock */;
        var water = blockType == 6 /* kWaterBomb */;
        var plant = blockType == 7 /* kPlantBomb */;

        if (this.isWaterBlock || this.isPlantBlock || this._isBlock)
            return;

        this.lastBlockSet = breaks;
        this.breakCountLeft = color ? 0 : breaks;
        this._isBlock = true;
        this.colorBlock = color ? getInt(this.level.assetNumber) : -1;

        this.isBombBlocked = this.isBombBlocked || bomb;

        if ((color || water || plant) && !this.level.isGenerated) {
            this.setObject(Match3Level.pool.getObject(this, this.level.gridToStageX(this.x), this.level.gridToStageY(this.y), this.level.assetNumber, this.colorBlock));
            this.object.isMoving = false;
        }

        if (water) {
            this.isWaterBlock = true;
            if (this.level.isGenerated) {
                this.level.objects.push(new SinglePlayObject(this.pos.x - 32, this.pos.y - 30, "water_splash", 15, this.level.blockDestroyLayer, 10, 17, 1));
                SoundsManager.instance.playSound("water_set");
            }
            CellObject.waterCells.push(this);
            this.setTempBlock(true, Math.max(0.5, this.tempBlockTime));
            if (this.object && this.level.isGenerated)
                this.object.playAnimation(117, 1, 1);
        }

        if (plant) {
            this.isPlantBlock = true;
            this.plantBreaksLeft = 2;

            this.prevMarkAlpha = 1;
            this.level.needToUpdateBack = true;
            var name = "bush root";
            var s = this.mark ? this.mark : createSpriteFromSpritesheet(name);
            s.gotoAndStop(name);
            s.regX = s.regY = 30;
            s.x = App.level.offsetX + (this.x + 0.5) * App.level.tileSize;
            s.y = App.level.offsetY + (this.y + 0.5) * App.level.tileSize;
            if (s.parent == null)
                App.level.markLayer.addChild(s);
            this.mark = s;
        }

        var s = new createjs.Sprite(App.game.atlases[0], plant ? "bush" : water ? "water" : bomb ? "mine_sprite_x" : color ? "wall color" : breaks == 0 ? "chocolate nuts" : breaks == 1 ? "chocolate white" : breaks == 2 ? "chocolate black" : "chocolate black x3 full");

        //s.scaleX = s.scaleY = App.level.tileSize / FieldObject.TILE_SIZE;
        //s.scaleX = s.scaleY = 0.96;
        if (!bomb) {
            setReg(s, 0.5, 0.5);
            s.x = App.level.offsetX + (this.x + 0.5) * App.level.tileSize;
            s.y = App.level.offsetY + (this.y + 0.5) * App.level.tileSize;
        } else {
            s.regX = 32;
            s.regY = 31;
            s.x = App.level.offsetX + (this.x + 0.5) * App.level.tileSize;
            s.y = App.level.offsetY + (this.y + 0.5) * App.level.tileSize;
        }
        addChild(s, animFrame >= 0 ? this.level.blockDestroyLayer : this.level.blockLayer);
        this.block = s;

        if ((!color && !bomb && animFrame >= 0) || water) {
            if (this.blockAnimation)
                this.blockAnimation.destroy();
            if (!water)
                this.removeBlockLock = this.level.currentMove;
            this.blockAnimation = new AnimationObject(water ? waterAnimation : chocolateAnimation, s);
            this.blockAnimation.resetStopFrame = !water;
            this.blockAnimation.sprite.visible = water;

            if (!water) {
                var delay = animFrame / 30 + 0.001;
                this.fullClearsIn.push(new ClearData((animFrame + 3) / 30 + 0.001, false));
                if (this.isMarked)
                    this.dontRemoveMark = true;
                var frameNumber = CellObject.blockAnimationFrames[animFrame] - 1;
                this.blockAnimation.prepareToPlayAnimation(delay, frameNumber);
                this.setTempBlock(true, Math.max(this.tempBlockTime, 1));
            } else {
                if (this.level.isGenerated)
                    this.blockAnimation.playAnimation(0, 1, 1);
                else
                    this.blockAnimation.setFrame(11, true);
            }

            this.blockAnimation.handlePos = true;
        }
    };

    CellObject.prototype.changeObjectType = function (type) {
        if (type != this.getType()) {
            var wasBonus = this.object.isBonus;
            var bonus = this.object.bonusType;

            this.timeSinceLastTypeChange = 0;

            //this.level.target.onObjectRemove(this.object);
            Match3Level.pool.returnObject(this.object);

            this.setObject(Match3Level.pool.getObject(this, this.level.gridToStageX(this.x), this.level.gridToStageY(this.y), 3, type));
            this.object.playJellyAnimation(1, 1);

            if (wasBonus)
                this.object.setBonusType(bonus);
        }
    };

    CellObject.prototype.removeBlock = function () {
        if (!this.isObjectBlocked && (!this.isBreakable || (this.breakMatchId == App.level.currentMove)) && !this.isBombBlocked && !this.isPlantBlock)
            return;

        if (this.removeBlockLock >= 0 && this.removeBlockLock >= this.level.currentMove)
            return;

        if (this.isBombBlocked && CellObject.lastBombRemove >= this.level.currentMove)
            return;

        var wasBlock = this.block != null;
        if (this.clearsIn.length == 0 && this.fullClearsIn.length == 0)
            this.breakMatchId = App.level.currentMove;
        var prevBreaksLeft = this.breakCountLeft;
        this.breakCountLeft--;
        this.timeSinceBlockRemove = 0;

        var wasColorBlocked = this.isColorBlocked;
        if (this.isColorBlocked) {
            //this.isColorBlocked = false;
            this.colorBlock = -1;
            this.setTempBlock(true, Math.max(this.tempBlockTime, 0.15));
            removeClip(this.blockTop);
            this.blockTop = null;
        }

        if (this.mark) {
            createjs.Tween.removeTweens(this.mark);
            if (this.mark.alpha < 1)
                createjs.Tween.get(this.mark, { loop: false }).to({ alpha: 1 }, 150, createjs.Ease.quadInOut);
        }

        var wasWaterBlock = this.isWaterBlock;
        if (this.isWaterBlock) {
            CellObject.waterRemoveMove = this.level.currentMove;
            var i = CellObject.waterCells.indexOf(this);
            while (i >= 0) {
                CellObject.waterCells.splice(i, 1);
                i = CellObject.waterCells.indexOf(this);
            }
            this.isWaterBlock = false;
            this.level.waterRemoveMove = this.level.currentMove;
            this.setTempBlock(true, Math.max(0.5, this.tempBlockTime));
            if (this.object)
                this.object.playAnimation(117, 1, 1);
            SoundsManager.instance.playSound("water_remove");
        }

        var wasBombBlocked = this.isBombBlocked;
        if (this.isBombBlocked) {
            CellObject.lastBombRemove = this.level.currentMove;
            this.isBombBlocked = false;
            var len = CellObject.blockAnimationShifts.length;
            for (var i = 0; i < len; ++i) {
                var x = this.x + CellObject.blockAnimationShifts[i].x;
                var y = this.y + CellObject.blockAnimationShifts[i].y;
                if (x >= 0 && y >= 0 && x < this.level.fieldWidth && y < this.level.fieldHeight) {
                    var c = this.level.cells[x][y];
                    if (c.isWaterBlock)
                        c.removeBlock();
                    if (!c._isBlock) {
                        if (this.level.target.isBlockTarget)
                            this.level.target.blocksToRemove++;
                        c.setBlock(1 /* kSingleBlockType */, i);
                    }
                }
            }
            this.setTempBlock(true, Math.max(this.tempBlockTime, 1.1));
        }

        var wasPlantBlocked = this.isPlantBlock;
        if (this.isPlantBlock) {
            this.plantBreaksLeft--;
            SoundsManager.instance.playSound(this.plantBreaksLeft == 0 ? "root_remove" : "bush_remove");
            this.isPlantBlock = this.plantBreaksLeft > 0;
            this._isBlock = this.plantBreaksLeft == 2;
            if (this.plantBreaksLeft <= 0)
                this.level.target.onBushRemoved();
        }

        if (this.level.isActive && !wasPlantBlocked && !wasWaterBlock)
            SoundsManager.instance.playSound(wasBombBlocked ? "chocolate_bomb" : wasColorBlocked ? "color_crash" : "choco_crash");

        if (this.breakCountLeft <= 0 && !wasPlantBlocked) {
            if (wasColorBlocked)
                this.level.objects.push(new SinglePlayObject(this.block.x, this.block.y, "color wall", 18, this.level.blockDestroyLayer, 53, 53, ANIM_SCALE));
            else if (wasWaterBlock)
                this.level.objects.push(new SinglePlayObject(this.pos.x - 32, this.pos.y - 30, "water_splash", 15, this.level.blockDestroyLayer, 10, 17, 1));
            else if (wasBombBlocked)
                this.level.objects.push(new SinglePlayObject(App.level.offsetX + (this.x + 0.5) * App.level.tileSize, App.level.offsetY + (this.y + 0.5) * App.level.tileSize, "mine", 18, this.level.blockDestroyLayer, 43, 62, 1));
            else if (this.lastBlockSet >= 2)
                this.level.objects.push(new SinglePlayObject(this.block.x, this.block.y, "chocolate destroy", 15, this.level.blockDestroyLayer, 53, 65, ANIM_SCALE));
            else
                this.level.objects.push(new SinglePlayObject(this.block.x, this.block.y, "chocolate white destr", 18, this.level.blockDestroyLayer, 57, 58, ANIM_SCALE));
            this._isBlock = false;

            if (!wasWaterBlock || !this.blockAnimation) {
                removeClip(this.block);

                if (this.blockAnimation)
                    this.blockAnimation.destroy();
                this.blockAnimation = null;
            } else {
                this.blockAnimation.destroyOnReset = true;
                this.blockAnimation.playAnimation(13, 1, 1);
            }
            this.block = null;
        } else if (wasPlantBlocked) {
            if (this.plantBreaksLeft == 1) {
                this.block.gotoAndPlay("bush_anim");
                this.block.regX = this.block.regY = 35;
                this.block.framerate = 30;
                this.setTempBlock(true, Math.max(this.tempBlockTime, 20 / this.block.framerate));
            } else if (this.plantBreaksLeft <= 0) {
                this.plantBreaksLeft = -1;
                this.isPlantBlock = false;
                this.level.objects.push(new CookieTweenSprite(this.mark.x, this.mark.y, 5));
                removeClip(this.mark);
                this._isBlock = false;
                this.mark = null;
                this.level.needToUpdateBack = true;
                removeClip(this.block);
                this.block = null;
            }
        } else if (this.breakCountLeft == 2) {
            this.block.gotoAndStop("chocolate black");
            this.level.objects.push(new CookieTweenSprite(this.pos.x, this.pos.y, 10));
        } else if (this.breakCountLeft == 1) {
            this.block.gotoAndStop("chocolate black2");
            this.block.regX += 2;
            this.block.regY += 2;
        }

        if (wasBlock && this.block == null && (prevBreaksLeft > 0 || wasBombBlocked) && !wasWaterBlock && !wasColorBlocked && !wasPlantBlocked)
            this.level.target.onBlockRemoved();
    };

    CellObject.prototype.setTempBlock = function (v, t) {
        if (typeof t === "undefined") { t = -1; }
        this.isTempBlock = v;
        this.tempBlockTime = t;
    };

    CellObject.prototype.isBlock = function () {
        return this._isBlock || this.isTempBlock;
    };

    Object.defineProperty(CellObject.prototype, "isBreakable", {
        get: function () {
            return this._isBlock && this.breakCountLeft > 0;
        },
        enumerable: true,
        configurable: true
    });

    CellObject.prototype.setObject = function (value) {
        this.object = value;
        if (this.object)
            this.object.cell = this;
    };

    CellObject.prototype.getSprite = function () {
        return this.object ? this.object.sprite : null;
    };

    CellObject.prototype.getType = function () {
        return this.object == null ? -1 : this.object.colorType;
    };

    CellObject.prototype.getBonusType = function () {
        return this.object == null ? 0 /* kBonusNone */ : this.object.bonusType;
    };

    CellObject.prototype.clearCell = function (checkNeighbours, noAnim) {
        //if (this.x == 7 && this.y == 8)
        //    console.log("");
        if (typeof checkNeighbours === "undefined") { checkNeighbours = true; }
        if (typeof noAnim === "undefined") { noAnim = false; }
        var objectRemoved = false;
        if (this.object && (!this.object.isPushable || !this.level.isActive) && !this.isObjectBlocked) {
            if (this.level.isActive && !noAnim) {
                //if (this.object.bonusType == FieldBonusType.kColorBonus)
                //    this.level.objects.push(new SinglePlayObject(this.object.sprite.x, this.object.sprite.y, "color bonus",
                //        37, this.level.gemDestroyLayer, 67, 61, ANIM_SCALE));
                //else if (this.object.isBonus)
                //    this.level.objects.push(new BonusDestroyAnimation(this.object.sprite.x, this.object.sprite.y, this.object.getFileName()));
                if (!(this.object.bonusType >= 1 /* kHorizontalLize */ && this.object.bonusType <= 4 /* kColorBonus */))
                    Match3Level.pool.getDestroyAnimation(this.object.colorType, this.object.sprite.x, this.object.sprite.y, this);
                if (this.object.bonusType == 4 /* kColorBonus */)
                    this.tryPlayScoreAnimation();
                if (this.object.isBonus) {
                    var bType = this.object.bonusType;
                    if (bType == 1 /* kHorizontalLize */ || bType == 2 /* kVerticalLine */ || bType == 5 /* kCrossBonus */ || bType == 6 /* kThickCrossBonus */) {
                        SoundsManager.instance.playSound("bonus_line");
                        new BonusLineSprite(bType, this.object.sprite.x, this.object.sprite.y);
                    } else if (bType == 3 /* kBombBonus */ || bType == 7 /* kLargeBombBonus */) {
                        new BonusBombSprite(bType, this.object.sprite.x, this.object.sprite.y);
                        SoundsManager.instance.playSound("bonus_bomb");
                    } else if (bType == 4 /* kColorBonus */)
                        SoundsManager.instance.playSound("bonus_color");
                    LevelManager.instance.bonuses++;
                }
            }
            this.level.target.onObjectRemove(this.object);
            Match3Level.pool.returnObject(this.object);
            this.object = null;
            objectRemoved = true;
        }

        if (this.marksLeft > 0 && objectRemoved && !this.dontRemoveMark) {
            this.setMark(this.marksLeft - 1);
            SoundsManager.instance.playSound("cookie_crash");
        }
        if (this.dontRemoveMark) {
            this.dontRemoveMark = false;
            //if (this.mark)
            //    createjs.Tween.get(this.mark, { loop: false }).to({ alpha: 0 }, 150, createjs.Ease.quadInOut);
        }

        var wasBreakable = this.isBreakable;
        if (this.isBreakable || this.isObjectBlocked || this.isBombBlocked || (this.isPlantBlock && objectRemoved)) {
            this.removeBlock();
        }
        if (checkNeighbours && !wasBreakable) {
            for (var i = 0; i < 4; ++i) {
                var x1 = this.x + (i == 0 ? 1 : i == 1 ? -1 : 0);
                var y1 = this.y + (i == 2 ? 1 : i == 3 ? -1 : 0);
                if (x1 >= 0 && y1 >= 0 && x1 < this.level.fieldWidth && y1 < this.level.fieldHeight) {
                    var c = this.level.cells[x1][y1];
                    if (c && (c.isBreakable || c.isBombBlocked || c.isWaterBlock) && ((!c.isColorBlocked && !c.isPlantBlock) || c.colorBlock == this.getType())) {
                        //c.removeBlock();
                        c.removeBlockIn = 0.01;
                        var t = Math.max(this.tempBlockTime, c.tempBlockTime);

                        //t += t <= 0 ? 0.05 : 0.01;
                        if (t <= 0)
                            t = FieldObject.GEM_KILL_DELAY * 1.1;
                        if (t >= 0)
                            c.setTempBlock(true, Math.max(c.tempBlockTime, t));
                    }
                }
            }
        }
    };

    Object.defineProperty(CellObject.prototype, "blockWasRemovedRecently", {
        get: function () {
            return this.timeSinceBlockRemove < 0.5;
        },
        enumerable: true,
        configurable: true
    });

    CellObject.prototype.onSpellExplosion = function (delay) {
        if (typeof delay === "undefined") { delay = -1; }
        if (this.object && !this.object.isMoving) {
            this.object.onSpellExplosion(delay);
        }
    };

    CellObject.prototype.isStable = function () {
        return this.object == null || !this.object.isMoving;
    };

    CellObject.prototype.isStatic = function () {
        return !this.object.isMoving;
    };

    CellObject.prototype.tryPlayScoreAnimation = function () {
        if (this.scoreToAdd > 0) {
            var award = this.level.isEnded;
            if (award)
                this.scoreToAdd = 10 * Math.round(this.scoreToAdd * 1.25 / 10);

            this.level.objects.push(Match3Level.pool.getText(this.scoreToAdd.toString(), this, 0));
            this.scoreToAdd = -1;

            //if (this.bonusComboCount > 1)
            //    this.level.objects.push(Match3Level.pool.getText(this.bonusComboCount + "x", this, 1));
            this.bonusComboCount = -1;
        }
    };

    Object.defineProperty(CellObject.prototype, "minClearIn", {
        get: function () {
            var len = this.clearsIn.length;

            if (len == 0)
                return -1;

            var min = 1e10;
            for (var i = 0; i < len; ++i)
                min = Math.min(min, this.clearsIn[i].delay);

            return min;
        },
        enumerable: true,
        configurable: true
    });

    CellObject.prototype.prepareToClear = function (delay, bonus, score, forceBonus) {
        if (typeof delay === "undefined") { delay = -1; }
        if (typeof bonus === "undefined") { bonus = 0 /* kBonusNone */; }
        if (typeof score === "undefined") { score = -1; }
        if (typeof forceBonus === "undefined") { forceBonus = false; }
        var byClick = bonus == 0 /* kBonusNone */;
        var byColor = bonus == 4 /* kColorBonus */;

        /*
        if (this.object) {
        var oldScore: number = this.scoreToAdd;
        if (this.isClearedByClick && score > 0) //TODO if last is bonus
        this.scoreToAdd = score;
        else if (this.object.isBonus || !byClick)
        this.scoreToAdd = CellObject.BASE_SCORE * (this.object.isBonus ? CellObject.BONUS_CELL_SCORE_FACTOR : 1) *
        (byClick ? 1 : bonus == FieldBonusType.kColorBonus || bonus >= FieldBonusType.kColorLineBonus ? CellObject.BONUS_COLOR_SCORE_FACTOR : CellObject.BONUS_SCORE_FACTOR);
        this.scoreToAdd += Math.max(0, oldScore);
        }
        */
        //if (this.isWaitingForClear && delay >= this.clearIn)
        //    return;
        var currentClear = 0.01 + delay;
        this.clearsIn.push(new ClearData(currentClear, byClick || byColor));
        if (this.object && (this.object.isBonus || forceBonus)) {
            var bonusDelay = this.object.bonusType <= 3 /* kBombBonus */ || forceBonus ? BonusDestroyAnimation.TIME : this.object.bonusType == 4 /* kColorBonus */ ? 20 / 30 : -1;
            if (bonusDelay > 0) {
                var current = this.object.playBonusAnimationIn;
                this.object.playBonusAnimationIn = Math.min(current < 0 ? 1e10 : current, currentClear > bonusDelay ? currentClear - bonusDelay - 0.01 : -1);
            }
        }
    };

    Object.defineProperty(CellObject.prototype, "isWaitingForClear", {
        get: function () {
            return this.clearsIn.length > 0;
        },
        enumerable: true,
        configurable: true
    });

    CellObject.prototype.update = function (dt) {
        if (this.isTempBlock) {
            this.tempBlockTime -= dt;
            if (this.tempBlockTime < 0) {
                this.setTempBlock(false);
                this.isTempBlock = false;
            }
        }

        if (this.mark && this.mark.alpha != this.prevMarkAlpha) {
            this.prevMarkAlpha = this.mark.alpha;
            this.level.needToUpdateBack = true;
        }

        if (this.teleportSprite && this.teleportSprite.currentAnimationFrame >= 11)
            this.teleportSprite.gotoAndStop(this.teleportCellEnd ? "teleport_in" : "teleport_out");

        var len = this.clearsIn.length;
        for (var i = 0; i < len; ++i) {
            var clear = this.clearsIn[i];
            if (clear.delay > 0) {
                clear.delay -= dt;
                if (clear.delay <= 0) {
                    this.clearsIn.splice(i, 1);
                    i--;
                    len--;
                    this.clearCell(clear.clickOrColor);
                }
            } else {
                this.clearsIn.splice(i, 1);
                i--;
                len--;
            }
        }

        if (this.isPlantBlock) {
            if (this.block && this.block.visible && this.plantBreaksLeft <= 1 && this.block.currentAnimationFrame >= 19) {
                this.block.visible = false;
                this.block.stop();
            } else if (this.plantBreaksLeft == 1 && this.breakMatchId >= 0 && this.breakMatchId <= this.level.currentMove - 3 && !this.block.visible && !this.level.isHardLocked && this.object) {
                this.block.visible = true;
                this.block.gotoAndPlay("bush_anim_reverse");
                this.block.regX = this.block.regY = 35;
                this.plantBreaksLeft = 2;
                this._isBlock = true;
                this.block.framerate = 30;
                this.setTempBlock(true, Math.max(this.tempBlockTime, 20 / this.block.framerate));
            } else if (this.plantBreaksLeft == 2 && this.block.visible && this.block.currentAnimationFrame >= 19) {
                //this.block.gotoAndStop("bush");
                this.block.stop();
                //setReg(this.block, 0.5, 0.5);
            }
        }

        if (this.blockAnimation) {
            this.blockAnimation.update(dt);

            if (this.blockAnimation.isDestroyed || !this.blockAnimation.sprite)
                this.blockAnimation = null;
        }

        if (!this._isBlock || this.breakCountLeft <= 0)
            this.timeSinceBlockRemove += dt;

        var len = this.fullClearsIn.length;
        for (var i = 0; i < len; ++i) {
            var clear = this.fullClearsIn[i];
            if (clear.delay > 0) {
                clear.delay -= dt;
                if (clear.delay <= 0) {
                    this.fullClearsIn.splice(i, 1);
                    i--;
                    len--;
                    this.clearCell(false, true);
                }
            } else {
                this.fullClearsIn.splice(i, 1);
                i--;
                len--;
            }
        }

        if (this.removeBlockIn > 0) {
            this.removeBlockIn -= dt;
            if (this.removeBlockIn <= 0 && (this.isBreakable || this.isBombBlocked || this.isWaterBlock || this.isPlantBlock))
                this.removeBlock();
        }

        this.timeSinceLastTypeChange += dt;
        if (this.object) {
            if (!(this.object.cell && this.object.cell != this && this.object.teleportTarget))
                this.object.cell = this;
            this.object.update(dt);
        }

        if (this.changeTypeIn > 0) {
            this.changeTypeIn -= dt;
            if (this.changeTypeIn <= 0 && this.object) {
                this.changeObjectType(this.typeToChange);
            }
        }
    };

    CellObject.prototype.destroy = function () {
        this.clearCell(false);

        removeClip(this.mark);
        this.mark = null;

        removeClip(this.teleportSprite);
        this.teleportSprite = null;

        if (this.blockAnimation)
            this.blockAnimation.destroy();
        this.blockAnimation = null;

        removeClip(this.blockTop);
        this.blockTop = null;

        removeClip(this.block);
        this.block = null;

        _super.prototype.destroy.call(this);
    };
    CellObject.lastBombRemove = -1;
    CellObject.waterRemoveMove = -1;
    CellObject.waterCells = [];

    CellObject.BASE_SCORE = 10;
    CellObject.BONUS_CELL_SCORE_FACTOR = 5;
    CellObject.BONUS_SCORE_FACTOR = 2;
    CellObject.BONUS_COLOR_SCORE_FACTOR = 4;

    CellObject.CACHE_NONE = 0;
    CellObject.CACHE_CLEAR = 1;
    CellObject.CACHE_DRAW = 2;

    CellObject.blockAnimationFrames = [2, 37, 72, 107, 142, 177, 212, 248];
    CellObject.blockAnimationShifts = [cjp(0, -1), cjp(1, -1), cjp(1, 0), cjp(1, 1), cjp(0, 1), cjp(-1, 1), cjp(-1, 0), cjp(-1, -1)];
    return CellObject;
})(GameObject);
var Preloader = (function () {
    function Preloader() {
        this.sprites = [];
        this.mainLoadingStarted = false;
        this.shownButton = false;
        this.loadedMain = false;
        this.hasBrandLogo = false;
        this.hasMoreGames = false;
        Preloader.instance = this;

        this.loadApi();
    }
    Preloader.prototype.loadApi = function () {
        var _this = this;
        var spilData = {
            id: App.episode == 1 ? '576742227280291405' : '576742227280291406'
        };
        try  {
            if (GameAPI && GameAPI != undefined && needApi)
                GameAPI.loadAPI(function (api) {
                    return _this.onApiLoaded(api);
                }, spilData);
            else
                this.onApiLoaded(null);
        } catch (e) {
            this.onApiLoaded(null);
        }
    };

    Preloader.prototype.onApiLoaded = function (api) {
        var _this = this;
        apiInstance = api;
        if (api)
            console.log('GameAPI version ' + api.version + ' loaded!');

        var s = new createjs.Container();
        App.game.stage.addChild(s);
        this.sprite = s;

        var manifest = [
            { src: "assets/preloader/preloader back.jpg", id: "preloader back" },
            { src: "assets/preloader/circle.jpg", id: "preloader candy top" },
            { src: "assets/preloader/progressbar top.jpg", id: "preloader progress top" },
            { src: "assets/preloader/play.jpg", id: "play button" }
        ];

        var logoData = apiInstance ? apiInstance.Branding.getLogo() : null;
        var isError = !logoData || logoData.error != undefined;

        this.preLoader = new createjs.LoadQueue(true);
        this.preLoader.addEventListener("complete", function () {
            return _this.onPreLoadComplete();
        });
        this.preLoader.loadManifest(manifest);
    };

    Preloader.prototype.onPreLoadComplete = function () {
        var _this = this;
        if (this.mainLoadingStarted)
            return;

        this.mainLoadingStarted = true;

        var s = this.sprite;

        var b = new createjs.Bitmap(this.preLoader.getResult("preloader back"));
        s.addChild(b);
        this.sprites.push(b);

        b = new createjs.Bitmap(this.preLoader.getResult("preloader progress top")); //1
        s.addChild(b);
        b.regX = b.getBounds().width / 2;
        b.regY = b.getBounds().height / 2;
        this.barRect = b.getBounds().clone();
        this.sprites.push(b);

        b = new createjs.Bitmap(this.preLoader.getResult("preloader candy top")); //2
        s.addChild(b);
        b.regX = b.getBounds().width / 2;
        b.regY = b.getBounds().height / 2 + 3;
        this.sprites.push(b);

        b = new createjs.Bitmap(this.preLoader.getResult("play button")); //2
        s.addChild(b);
        b.regX = 78;
        b.regY = b.getBounds().height / 2 + 3;
        b.x = 430;
        b.y = 500;
        this.playButton = b;
        this.playButton.alpha = 0;
        this.playButton.visible = false;
        this.sprites.push(b);

        this.onResize();

        createjs.Sound.initializeDefaultPlugins();
        createjs.Sound.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin]);
        createjs.Sound.alternateExtensions = ["mp3"];

        var episode = App.episode;
        var episodePath = "assets/episode" + App.episode + "/";
        var tutorialPath = episodePath + "tutorial/";

        var manifest = [
            { src: "assets/preloader/zibbo_logo.png", id: "zibbo_logo" },
            { src: episodePath + "map1.jpg", id: "map3" },
            { src: episodePath + "map2.jpg", id: "map2" },
            { src: episodePath + "map3.jpg", id: "map1" },
            { src: "assets/bar.png", id: "bar" },
            { src: "assets/art.png", id: "art.png" },
            { src: "assets/art.txt", id: "artJson", type: createjs.LoadQueue.JSON },
            { src: "assets/font2.png", id: "font2.png" },
            { src: "assets/font2.txt", id: "font2Json", type: createjs.LoadQueue.JSON },
            { src: episodePath + "back.jpg", id: "back" },
            { src: episodePath + "main menu.jpg", id: "main menu" },
            { src: "assets/menu back.jpg", id: "menu back" },
            { src: episodePath + "logo top.jpg", id: "logo top" },
            { src: "assets/logo.txt", id: "logo text", type: createjs.LoadQueue.JSON },
            { src: "assets/button.txt", id: "button text", type: createjs.LoadQueue.JSON },
            { src: "assets/Char win.txt", id: "Char win", type: createjs.LoadQueue.JSON },
            { src: "assets/Char lose.txt", id: "Char lose", type: createjs.LoadQueue.JSON },
            { src: "assets/gloss anim.txt", id: "gloss anim", type: createjs.LoadQueue.JSON },
            { src: "assets/buttons pause anim.txt", id: "buttons pause anim", type: createjs.LoadQueue.JSON },
            { src: "assets/pointer.txt", id: "pointer", type: createjs.LoadQueue.JSON },
            { src: episodePath + "art.png", id: "artEpisode" },
            { src: episodePath + "art.txt", id: "artEpisodeJson", type: createjs.LoadQueue.JSON },
            { src: tutorialPath + "t1.png", id: "tutorial1" },
            { src: tutorialPath + "t2.png", id: "tutorial2" },
            { src: tutorialPath + "t3.png", id: "tutorial3" },
            { src: tutorialPath + "t4.png", id: "tutorial4" },
            { src: tutorialPath + "t5.png", id: "tutorial5" },
            { src: tutorialPath + "t6.png", id: "tutorial6" },
            { src: tutorialPath + "t7.png", id: "tutorial7" },
            { src: "assets/sound/music/btcl_main_music.ogg", id: "main_music", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/hero_show.ogg", id: "hero_show", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/hero_hide.ogg", id: "hero_hide", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/win.ogg", id: "win", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/fail.ogg", id: "fail", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/play_button.ogg", id: "play_button", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/button.ogg", id: "button", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/pause.ogg", id: "pause", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/transition.ogg", id: "transition", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/remove1.ogg", id: "remove1", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/remove2.ogg", id: "remove2", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/remove3.ogg", id: "remove3", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/remove4.ogg", id: "remove4", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/bonus_show.ogg", id: "bonus_show", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/bonus_set.ogg", id: "bonus_set", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/bonus_bomb.ogg", id: "bonus_bomb", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/bonus_line.ogg", id: "bonus_line", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/bonus_color.ogg", id: "bonus_color", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/star1.ogg", id: "star1", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/pointer.ogg", id: "pointer_sound", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/star2.ogg", id: "star2", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/star3.ogg", id: "star3", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/cookie_crash.ogg", id: "cookie_crash", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/choco_crash.ogg", id: "choco_crash", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/color_crash.ogg", id: "color_crash", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/cake_down.ogg", id: "cake_down", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/stop_move.ogg", id: "stop_move", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/water_set.ogg", id: "water_set", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/water_remove.ogg", id: "water_remove", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/teleport1.ogg", id: "teleport1", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/teleport2.ogg", id: "teleport2", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/teleport3.ogg", id: "teleport3", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/bush_remove.ogg", id: "bush_remove", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/root_remove.ogg", id: "root_remove", type: createjs.LoadQueue.SOUND },
            { src: "assets/sound/chocolate_bomb.ogg", id: "chocolate_bomb", type: createjs.LoadQueue.SOUND }
        ];

        if (App.episode == 3)
            manifest.push({ src: episodePath + "logo down.jpg", id: "logo down" }, { src: tutorialPath + "t8.png", id: "tutorial8" }, { src: tutorialPath + "t9.png", id: "tutorial9" });
        else if (App.episode == 4)
            manifest.push({ src: tutorialPath + "t8.png", id: "tutorial8" }, { src: tutorialPath + "t9.png", id: "tutorial9" });

        this.loader = new createjs.LoadQueue(true);
        this.loader.installPlugin(createjs.Sound);

        createjs.Sound.initializeDefaultPlugins();
        createjs.Sound.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin]);
        createjs.Sound.alternateExtensions = ["mp3"];

        this.loader.addEventListener("complete", function () {
            return _this.onLoadComplete();
        });
        this.loader.addEventListener("progress", function () {
            return _this.onProgress();
        });

        //this.loader.addEventListener("fileprogress", () => this.onProgress());
        this.loader.loadManifest(manifest);
    };

    Preloader.prototype.onLoadComplete = function () {
        this.onResize();
        this.onProgress();

        //return;
        //App.game.stage.removeChild(this.sprite);
        //App.game.stage.removeAllChildren();
        //App.game.onLoadComplete();
        //App.game.loadApi();
        //this.showButton();
        App.game.stage.removeAllChildren();
        App.game.loadApi();
        this.loadedMain = true;
       
    };

    Preloader.prototype.showButton = function () {
        if (!this.shownButton) {
            this.shownButton = true;
            this.playButton.scaleX = this.playButton.scaleY = 0.5;
            this.playButton.visible = true;
            this.sprites[2].visible = false;
            createjs.Tween.get(this.playButton, { loop: false }).wait(0).to({ scaleX: 1.2, scaleY: 1.2, alpha: 1 }, 150, createjs.Ease.circOut).wait(0).to({ scaleX: 1, scaleY: 1 }, 250, createjs.Ease.circIn);
        }
    };

    Preloader.prototype.onDown = function (x, y) {
        if (!this.loadedMain && this.playButton.visible) {
            var r = this.playButton.getTransformedBounds();
            if (x >= r.x && x <= r.x + r.width && y >= r.y && y <= r.y + r.height) {
                this.loadedMain = true;
                App.game.loadApi();
                createjs.Tween.get(this.playButton, { loop: false }).wait(0).to({ scaleX: 1.2, scaleY: 1.2, alpha: 1 }, 200, createjs.Ease.circOut).wait(0).to({ scaleX: 1, scaleY: 1 }, 200, createjs.Ease.circIn);
            }
        }
    };

    Preloader.prototype.isActive = function () {
        return this.sprite.parent != null;
    };

    Preloader.prototype.disable = function () {
        removeClip(this.sprite);
        for (var i = 0; i < this.sprites.length; ++i)
            removeClip(this.sprites[i]);
    };

    Preloader.prototype.onProgress = function () {
        if (this.sprites.length <= 0 || !this.barRect)
            return;

        var p = this.loader.progress;
        var r = new createjs.Rectangle(this.barRect.x, this.barRect.y, limit(this.barRect.width * p, 1, this.barRect.width), this.barRect.height);
        this.sprites[1].sourceRect = r;
    };

    Preloader.prototype.update = function (dt) {
        if (this.sprite && this.sprite.parent && this.sprites.length > 0) {
            this.sprites[2].rotation -= 400 * dt;
        }
    };

    Preloader.prototype.onResize = function () {
        if (!this.sprite || !this.sprite.parent || this.sprites.length <= 0)
            return;

        var bottom = App.ACTUAL_H - Math.min(App.CURRENT_SHIFT, 0);
        this.sprites[1].x = 280 + 13;
        this.sprites[2].x = 620 - 5;

        this.sprites[1].y = 620 - 1;
        this.sprites[2].y = 620 - 1;
    };
    return Preloader;
})();
var CookieTweenSprite = (function (_super) {
    __extends(CookieTweenSprite, _super);
    function CookieTweenSprite(x, y, type) {
        var _this = this;
        _super.call(this);

        var s = createSpriteFromSpritesheet(type == 5 ? "bush root" : type == 10 ? "chocolate black x3" : type == 0 ? "cookie" : type == 1 ? "cookie honey" : "cookie x3");
        if (type == 10 || type == 5) {
            setReg(s, 0.5, 0.5);
            s.x = x;
            s.y = y;
        } else {
            s.regX = s.regY = 4 + Match3Level.TILE_SIZE / 2;
            s.x = x + Match3Level.TILE_SIZE / 2;
            s.y = y + Match3Level.TILE_SIZE / 2;
        }

        this.sprite = s;
        var p = type == 10 ? this.level.blockDestroyLayer : this.level.underGemLayer;
        p.addChild(s);

        createjs.Tween.get(s, { loop: false }).wait(0).to({ alpha: 0, scaleX: (type == 0 || type == 10 || type == 5 ? 1.3 : 1), scaleY: (type == 0 || type == 10 || type == 5 ? 1.3 : 1) }, 135, createjs.Ease.quadOut).call(function () {
            return _this.onComplete();
        });
    }
    CookieTweenSprite.prototype.onComplete = function () {
        this.destroy();
    };
    return CookieTweenSprite;
})(GameObject);
var BonusDestroyAnimation = (function (_super) {
    __extends(BonusDestroyAnimation, _super);
    function BonusDestroyAnimation(x, y, file, cell) {
        var _this = this;
        _super.call(this);
        this.progress = 0;

        this.cell = cell;

        var s = createSpriteFromSpritesheet(file);
        s.regX = s.getBounds().width / 2;
        s.regY = s.getBounds().height / 2;
        s.x = x;
        s.y = y;
        this.level.gemLayer.addChild(s);
        this.sprite = s;

        var l = createSpriteFromSpritesheet("star glow");
        l.regX = l.getBounds().width / 2;
        l.regY = l.getBounds().height / 2;
        l.x = x;
        l.y = y;
        l.scaleX = l.scaleY = 0.15;
        l.alpha = 0;
        this.level.underGemLayer.addChild(l);
        this.glow = l;

        createjs.Tween.get(this, { loop: false }).to({ progress: 1 }, BonusDestroyAnimation.TIME * 1000, createjs.Ease.none).call(function () {
            return _this.setLight();
        });
    }
    BonusDestroyAnimation.prototype.setLight = function () {
        this.sprite.visible = this.glow.visible = false;
        this.light = createSpriteFromSpritesheet("bonus blink");
        this.light.x = this.sprite.x;
        this.light.y = this.sprite.y;
        this.light.scaleX = this.light.scaleY = ANIM_SCALE * 1.5;
        this.light.regX = 67 / ANIM_SCALE;
        this.light.regY = 61 / ANIM_SCALE;
        this.level.blockLayer.addChild(this.light);
        this.light.play();
    };

    BonusDestroyAnimation.prototype.update = function (dt) {
        if (this.sprite.visible) {
            this.sprite.scaleX = this.sprite.scaleY = lerp(1, 1.2, this.progress);
            this.glow.alpha = this.progress;
            this.glow.scaleX = this.glow.scaleY = lerp(0.15, 0.95, this.progress);
        }

        if (this.light && this.light.currentAnimationFrame >= 8) {
            if (this.cell)
                this.cell.tryPlayScoreAnimation();
            this.destroy();
        }
    };

    BonusDestroyAnimation.prototype.destroy = function () {
        _super.prototype.destroy.call(this);

        createjs.Tween.removeTweens(this);

        removeClip(this.glow);
        this.glow = null;

        removeClip(this.light);
        this.light = null;
    };
    BonusDestroyAnimation.TIME = 0.5;
    return BonusDestroyAnimation;
})(GameObject);
var JumpText = (function (_super) {
    __extends(JumpText, _super);
    function JumpText(text, type) {
        _super.call(this);
        this.speed = new createjs.Point();
        this.targetPos = new createjs.Point();
        this.diff = new createjs.Point();
        this.isHiding = false;
        this.isFinished = false;
        this.isScore = false;
        this.isBonusCombo = false;
        this.isEnding = false;
        this.score = 0;

        this.isScore = type == 0;
        this.isBonusCombo = type == 1;
        this.isEnding = type == 3;

        if (this.isScore)
            this.score = parseInt(text);

        var s = new createjs.BitmapText(text, type == 0 ? App.game.atlases[0] : App.game.atlases[1]);
        s.letterSpacing = -10;
        var size = getTextSize(s);
        s.mouseEnabled = false;
        s.scaleX = s.scaleY = this.isScore ? 0.85 : this.isBonusCombo ? 0.6 : this.isEnding ? 1 : 0.7;
        var b2 = s.getTransformedBounds();

        s.regX = Math.ceil(size.x / 2);
        s.regY = Math.ceil(size.y);
        this.sprite = s;

        this.text = text;
    }
    JumpText.prototype.init = function (x, y, c) {
        this.speed.x = this.speed.y = this.targetPos.x = this.targetPos.y = this.diff.x = this.diff.y = 0;
        this.isHiding = this.isFinished = false;
        this.sprite.alpha = 1;

        // this.sprite.scaleX = this.sprite.scaleY = 1;
        this.level = Match3Level.instance;
        if (this.level)
            this.level.hudLayer.addChild(this.sprite);
        this.sprite.x = x;
        this.sprite.y = y;
        this.sprite.visible = true;

        this.isDestroyed = false;

        //return;
        this.speedModulo = (this.isScore ? 11 : 15) * 60;
        this.speed.y = -this.speedModulo;
        var angle = 0;
        if (this.isScore)
            angle = c && c.x == 0 ? lerp(15, 30, Math.random()) : c && c.x == this.level.fieldWidth - 1 ? lerp(-30, -15, Math.random()) : lerp(-20, 20, Math.random());
        else if (this.isBonusCombo) {
            var modulo = c.y < 3 ? 110 : c.y > this.level.fieldHeight - 3 ? 70 : Math.random() > 0.5 ? 110 : 70;
            angle = lerp(-15, 15, Math.random()) + (c.x < 3 ? modulo : c.x > this.level.fieldWidth - 3 ? -modulo : Math.random() > 0.5 ? modulo : -modulo);
        } else
            angle = 0;
        rotatePoint(this.speed, angle);
        createjs.Tween.get(this, { loop: false }).to({ speedModulo: 0 }, 750, createjs.Ease.quadOut);
        this.targetPos.x = x;
        this.targetPos.y = y;

        return this;
    };

    JumpText.prototype.release = function () {
        createjs.Tween.removeTweens(this.sprite);
        createjs.Tween.removeTweens(this);
        removeClip(this.sprite);
        this.sprite.visible = false;
        this.isDestroyed = true;
    };

    JumpText.prototype.update = function (dt) {
        var _this = this;
        //return;
        //this.sprite.visible = false;
        if (this.isFinished) {
            //this.destroy();
            Match3Level.pool.returnText(this);
            return;
        }

        _super.prototype.update.call(this, dt);

        if (!this.isHiding) {
            this.sprite.x += this.speed.x * dt;
            this.sprite.y += this.speed.y * dt;

            this.diff.x = this.targetPos.x - this.sprite.x;
            this.diff.y = this.targetPos.y - this.sprite.y;
            var len = distanceBetweenPoints(0, 0, this.diff.x, this.diff.y);
            this.diff.x /= len;
            this.diff.y /= len;
            var accModulo = 0.8 * 60 * 60;
            this.diff.x *= accModulo;
            this.diff.y *= accModulo;

            //speedModulo -= 0.55f;
            if (this.speedModulo > 0) {
                this.speed.x += this.diff.x * dt;
                this.speed.y += this.diff.y * dt;
                var len = distanceBetweenPoints(0, 0, this.speed.x, this.speed.y);
                if (len > this.speedModulo) {
                    var factor = this.speedModulo / len;
                    this.speed.x *= factor;
                    this.speed.y *= factor;
                }
            } else
                this.speed.x = this.speed.y = 0;

            if (Math.abs(this.speedModulo) < 1e-5 && !this.isHiding) {
                this.isHiding = true;
                if (this.isScore)
                    createjs.Tween.get(this.sprite, { loop: false }).wait(0).to({ x: this.level.hud.scoreText.x, y: this.level.hud.scoreText.y, alpha: 0.2 }, 400, createjs.Ease.quartIn).call(function () {
                        return _this.finishMovement();
                    });
                else
                    createjs.Tween.get(this.sprite, { loop: false }).wait(0).to({ alpha: 0.2 }, 400, createjs.Ease.quartIn).call(function () {
                        return _this.finishMovement();
                    });
            }
        }
    };

    JumpText.prototype.finishMovement = function () {
        if (this.isFinished)
            return;

        if (this.isScore) {
            this.level.score += this.score;
        }
        this.isFinished = true;
    };

    JumpText.prototype.destroy = function () {
        Match3Level.pool.returnText(this);
        //super.destroy();
    };
    return JumpText;
})(GameObject);
var EndBonusIndicator = (function (_super) {
    __extends(EndBonusIndicator, _super);
    function EndBonusIndicator(x, y, c, d, b) {
        _super.call(this);
        this.delay = -1;
        this.cell = c;
        this.bonusType = b;
        var s = createSpriteFromSpritesheet("bonus new");
        s.regX = s.getBounds().width / 2;
        s.regY = s.getBounds().height / 2;
        s.x = x;
        s.y = y;
        s.visible = false;
        this.delay = d;
        this.sprite = s;
        addChild(this.sprite, this.level.hudLayer);
    }
    Object.defineProperty(EndBonusIndicator.prototype, "totalTime", {
        get: function () {
            return this.delay + EndBonusIndicator.MOVE_TIME;
        },
        enumerable: true,
        configurable: true
    });

    EndBonusIndicator.prototype.update = function (dt) {
        var _this = this;
        _super.prototype.update.call(this, dt);

        this.delay -= dt;
        if (this.delay <= 0 && !this.sprite.visible) {
            SoundsManager.instance.playSound("bonus_show");
            this.sprite.visible = true;
            this.sprite.alpha = 0.3;
            this.sprite.scaleX = this.sprite.scaleY = 0.3;
            createjs.Tween.get(this.sprite, { loop: false }).wait(0).to({ alpha: 1, scaleX: 1, scaleY: 1, x: this.cell.pos.x, y: this.cell.pos.y }, EndBonusIndicator.MOVE_TIME * 1000, createjs.Ease.cubicIn).call(function () {
                return _this.hide();
            });
            this.level.movesLeft = Math.max(0, this.level.movesLeft - 1);
        }
    };

    EndBonusIndicator.prototype.hide = function () {
        if (this.cell && this.cell.object) {
            this.cell.object.setBonusType(this.bonusType);
            this.cell.setTempBlock(false, -1);
        }
        this.destroy();
    };

    EndBonusIndicator.prototype.destroy = function () {
        _super.prototype.destroy.call(this);

        this.cell = null;
    };
    EndBonusIndicator.MOVE_TIME = 0.5;
    return EndBonusIndicator;
})(GameObject);
var SoundsManager = (function () {
    function SoundsManager() {
        this.lastPlays = {};
        this.delays = {};
        this.shifts = {};
        this.musicPlayed = false;
        this.isSoundEnabled = needMusic;
        this.isMusicEnabled = needMusic;
        this.musicPaused = false;
        this.lastTeleport = 0;
        this.teleportCount = 0;
        this.volumes = {};
        SoundsManager.instance = this;
        this.delays["remove1"] = this.delays["remove2"] = this.delays["remove3"] = this.delays["remove4"] = FieldObject.GEM_KILL_DELAY * 0.5;
        this.delays["cookie_crash"] = this.delays["choco_crash"] = this.delays["color_crash"] = this.delays["bush_remove"] = this.delays["root_remove"] = this.delays["water_remove"] = 0.05;
        this.delays["stop_move"] = 0.05;
        this.delays["bonus_show"] = 0.05;

        //this.shifts["hero_show"] = 0.04;
        //this.volumes["bonus_show"] = 0.7;
        this.volumes["bonus_set"] = 0.78;
        this.volumes["choco_crash"] = 1.6;
        this.volumes["cookie_crash"] = 1.6;
        this.volumes["color_crash"] = 1;
        this.volumes["water_remove"] = 0.75;
    }
    SoundsManager.prototype.update = function (dt) {
        this.time += dt;
    };

    SoundsManager.prototype.playTeleport = function () {
        if (App.game.gameTime - this.lastTeleport > 0.1)
            this.teleportCount = 0;

        if (App.game.gameTime > this.lastTeleport) {
            var i = this.teleportCount % 3;
            this.lastTeleport = App.game.gameTime + 0.05; // (i <= 1 ? 1.85 : 1.5);
            this.playSound("teleport" + (i + 1));
            ++this.teleportCount;
        }
    };

    SoundsManager.prototype.playSound = function (s, d) {
        if (typeof d === "undefined") { d = 0; }
        //return;
        if (!this.isSoundEnabled)
            return;

        //if (s == "hero_show")
        //    console.log("");
        var playDelay = this.delays[s];
        var playTime = this.lastPlays[s];
        var playShift = this.shifts[s];
        var delay = 0;
        var volume = this.volumes[s] ? this.volumes[s] : 1;

        if (playDelay) {
            if (!playShift) {
                if (playTime && Math.abs(this.time - playTime) < playDelay)
                    return;
                else
                    this.lastPlays[s] = this.time;
            } else {
                //var delay:number =
                if (!playTime || playTime < this.time)
                    this.lastPlays[s] = this.time;
                else {
                    if (playTime + playShift < this.time + playDelay) {
                        this.lastPlays[s] = playTime + playShift;
                        delay = (this.lastPlays[s] - this.time) * 1000;
                    } else
                        return;
                }
            }
        }

        //return;
        createjs.Sound.play(s, "none", delay + d, 0, 0, volume);
    };

    SoundsManager.prototype.playMusic = function () {
        if (!this.musicPlayed) {
            var hasMusic = this.music != null;
            if (!this.music)
                this.music = createjs.Sound.play("main_music", { interrupt: createjs.Sound.INTERRUPT_ANY, loop: -1, volume: 0.55 });
            else
                this.music.play(createjs.Sound.INTERRUPT_NONE, 0, 0, -1, 1);
            this.musicPlayed = this.music.playState == createjs.Sound.PLAY_SUCCEEDED;
            if (!this.isMusicEnabled)
                this.music.pause();
            //alert(this.musicPlayed + " " + this.isMusicEnabled + " " + createjs.HTMLAudioPlugin.isSupported() + " " + createjs.WebAudioPlugin.isSupported() + " " + hasMusic + " " + this.music.playState);
        }
    };

    SoundsManager.prototype.pauseMusic = function () {
        console.log("pause", App.game.gameTime);
        this.musicPaused = true;
        if (this.musicPlayed && this.music) {
            createjs.Tween.removeTweens(this.music);
            createjs.Tween.get(this.music, { loop: false }).wait(0).to({ volume: 0 }, 200, createjs.Ease.cubicIn);
        }
    };

    SoundsManager.prototype.resumeMusic = function () {
        console.log("resume", App.game.gameTime);
        this.musicPaused = false;
        if (this.musicPlayed && this.music) {
            createjs.Tween.removeTweens(this.music);
            createjs.Tween.get(this.music, { loop: false }).wait(0).to({ volume: 0.55 }, 200, createjs.Ease.cubicIn);
        }
    };

    SoundsManager.prototype.setSound = function (on) {
        if (typeof on === "undefined") { on = true; }
        this.isSoundEnabled = on;
    };

    SoundsManager.prototype.setMusic = function (on) {
        if (typeof on === "undefined") { on = true; }
        this.isMusicEnabled = on;
        if (this.music) {
            if (on)
                this.music.resume();
            else
                this.music.pause();
        }
    };

    SoundsManager.prototype.reset = function () {
        this.time = 0;
        this.lastPlays = {};
    };
    return SoundsManager;
})();
var ClickableObject = (function (_super) {
    __extends(ClickableObject, _super);
    function ClickableObject(s) {
        if (typeof s === "undefined") { s = null; }
        _super.call(this);
        this.shape = -1;
        this.radius = 0;
        this.shift = new createjs.Point();
        this.rect = new createjs.Rectangle();
        this.lastClickTime = -1;
        if (s)
            this.sprite = s;
    }
    ClickableObject.prototype.setCircle = function (r, sX, sY) {
        if (typeof sX === "undefined") { sX = 0; }
        if (typeof sY === "undefined") { sY = 0; }
        this.shape = ClickableObject.CIRCLE_SHAPE;
        this.radius = r;
        this.shift.x = sX;
        this.shift.y = sY;
    };

    ClickableObject.prototype.setRect = function (x, y, w, h) {
        this.shape = ClickableObject.RECT_SHAPE;
        this.rect.initialize(x, y, w, h);
    };

    ClickableObject.prototype.checkClick = function (x, y) {
        if (this.sprite && this.shape >= 0 && this.sprite.visible && this.sprite.parent && this.sprite.parent.visible) {
            var p = this.sprite.localToGlobal(0, 0);
            switch (this.shape) {
                case ClickableObject.CIRCLE_SHAPE:
                    return distanceBetweenPoints(p.x + this.shift.x, p.y + this.shift.y, x, y) <= this.radius;
                case ClickableObject.RECT_SHAPE:
                    return x >= p.x + this.rect.x && y >= p.y + this.rect.y && x <= p.x + this.rect.x + this.rect.width && y <= p.y + this.rect.y + this.rect.height;
            }
        }

        return false;
    };

    ClickableObject.prototype.onClick = function () {
        if (this.callback) {
            var t = App.game.gameTime;
            if (Math.abs(t - this.lastClickTime) > 0.3) {
                this.lastClickTime = t;
                this.callback();
            }
        }
    };

    ClickableObject.prototype.updateRectScale = function () {
        var rect = this.sprite.getBounds();
        this.setRect(rect.x * this.sprite.scaleX, rect.y * this.sprite.scaleY, rect.width * this.sprite.scaleX, rect.height * this.sprite.scaleY);
    };
    ClickableObject.CIRCLE_SHAPE = 0;
    ClickableObject.RECT_SHAPE = 1;
    return ClickableObject;
})(GameObject);

var LogoObject = (function (_super) {
    __extends(LogoObject, _super);
    function LogoObject(p, x, y, scale) {
        var _this = this;
        _super.call(this);

        this.initScale = scale;

        var s = App.game.preloader.hasBrandLogo ? new createjs.Bitmap(App.game.preloader.preLoader.getResult("brand logo")) : null;
        if (s) {
            s.scaleX = s.scaleY = scale;
            s.x = x;
            s.y = y;
            s.regX = s.getBounds().width / 2;
            s.regY = s.getBounds().height / 2;
            s.mouseEnabled = false;
            p.addChild(s);
            this.sprite = s;
            if (apiInstance && apiInstance.Branding.getLogo().action)
                this.callback = function () {
                    return _this.onLogoClick();
                };
        }
    }
    LogoObject.prototype.onLogoClick = function () {
        if (!this.sprite || !this.sprite.visible)
            return;

        if (apiInstance && apiInstance.Branding.getLogo().action)
            apiInstance.Branding.getLogo().action();

        createjs.Tween.get(this.sprite, { loop: false }).wait(0).to({ scaleX: 1.2 * this.initScale, scaleY: 1.2 * this.initScale, alpha: 1 }, 200, createjs.Ease.circOut).wait(0).to({ scaleX: this.initScale, scaleY: this.initScale }, 250, createjs.Ease.circIn);
    };

    LogoObject.prototype.setVisible = function (v) {
        if (this.sprite)
            this.sprite.visible = v;
    };

    LogoObject.prototype.checkClick = function (x, y) {
        if (this.sprite && this.sprite.visible) {
            var r = this.sprite.getBounds();
            var p = this.sprite.localToGlobal(0, 0);
            var w = this.initScale * r.width;
            var h = this.initScale * r.height;

            //console.log(x, y, p.x, p.y, w, h);
            return x >= p.x && x <= p.x + w && y >= p.y && y <= p.y + h;
        }

        return false;
    };
    return LogoObject;
})(ClickableObject);

var MoreGamesButton = (function (_super) {
    __extends(MoreGamesButton, _super);
    function MoreGamesButton(p, x, y, scale) {
        var _this = this;
        _super.call(this);

        this.initScale = scale;

        var s = App.game.preloader.hasMoreGames ? createSpriteFromSpritesheet("more") : null;
        if (s) {
            s.scaleX = s.scaleY = scale;
            s.x = x;
            s.y = y;
            s.regX = s.getBounds().width / 2;
            s.regY = s.getBounds().height / 2;
            s.mouseEnabled = false;
            p.addChild(s);
            this.sprite = s;
            if (apiInstance && apiInstance.Branding.getLink('more_games').action)
                this.callback = function () {
                    return _this.onLogoClick();
                };
        }
    }
    MoreGamesButton.prototype.onLogoClick = function () {
        if (!this.sprite)
            return;

        if (apiInstance && apiInstance.Branding.getLink('more_games').action)
            apiInstance.Branding.getLink('more_games').action();

        createjs.Tween.get(this.sprite, { loop: false }).wait(0).to({ scaleX: 1.2 * this.initScale, scaleY: 1.2 * this.initScale, alpha: 1 }, 200, createjs.Ease.circOut).wait(0).to({ scaleX: this.initScale, scaleY: this.initScale }, 250, createjs.Ease.circIn);
    };

    MoreGamesButton.prototype.checkClick = function (x, y) {
        if (this.sprite) {
            var r = this.sprite.getBounds();
            var p = this.sprite.localToGlobal(0, 0);
            var w = this.initScale * r.width;
            var h = this.initScale * r.height;

            //console.log(x, y, p.x, p.y, w, h);
            return x >= p.x && x <= p.x + w && y >= p.y && y <= p.y + h;
        }

        return false;
    };
    return MoreGamesButton;
})(ClickableObject);

var ButtonObject = (function (_super) {
    __extends(ButtonObject, _super);
    function ButtonObject(skin, call, p, x, y) {
        if (typeof x === "undefined") { x = 0; }
        if (typeof y === "undefined") { y = 0; }
        _super.call(this);
        this.playAnimIn = -1;
        this.callback = call;

        var button = getButtonAnimation(skin);
        this.anim = button;
        button.stop();
        button.x = x;
        button.y = y;
        p.addChild(button);

        this.sprite = button;

        var rect = this.sprite.getBounds();
        this.setRect(rect.x, rect.y, rect.width, rect.height);
    }
    ButtonObject.prototype.update = function (dt) {
        _super.prototype.update.call(this, dt);

        if (this.playAnimIn > 0) {
            this.playAnimIn -= dt;
            if (this.playAnimIn <= 0)
                this.playAnim();
        }

        this.anim.update(dt);
    };

    ButtonObject.prototype.playAnim = function () {
        var fps = 30 * lerp(1.3, 1.6, Math.random());
        this.anim.setFrameDelay(1 / fps);
        this.playAnimIn = -1;
        this.anim.gotoAndPlay(0);
    };

    ButtonObject.prototype.onClick = function () {
        _super.prototype.onClick.call(this);
        SoundsManager.instance.playSound("button");
        this.playAnim();
    };

    ButtonObject.prototype.onShow = function () {
        this.playAnimIn = lerp(1 / 60, 6 / 60, Math.random());
    };

    ButtonObject.prototype.onHide = function () {
    };
    return ButtonObject;
})(ClickableObject);

var SoundButton = (function (_super) {
    __extends(SoundButton, _super);
    function SoundButton(music, p, x, y) {
        var _this = this;
        var call = function (e) {
            _this.changeState(e);
        };
        this.isMusic = music;
        _super.call(this, music ? 2 : 0, call, p, x, y);
    }
    SoundButton.prototype.changeState = function (e) {
        var current = !(this.isMusic ? SoundsManager.instance.isMusicEnabled : SoundsManager.instance.isSoundEnabled);
        this.anim.setPartSkin("Layer 1", this.isMusic ? (current ? 2 : 3) : (current ? 0 : 1));
        this.isMusic ? SoundsManager.instance.setMusic(current) : SoundsManager.instance.setSound(current);
    };

    SoundButton.prototype.onShow = function () {
        _super.prototype.onShow.call(this);

        var current = this.isMusic ? SoundsManager.instance.isMusicEnabled : SoundsManager.instance.isSoundEnabled;
        this.anim.setPartSkin("Layer 1", this.isMusic ? (current ? 2 : 3) : (current ? 0 : 1));
    };
    return SoundButton;
})(ButtonObject);
var Tutorial = (function (_super) {
    __extends(Tutorial, _super);
    function Tutorial() {
        _super.call(this);
        this.pages = [];
        this.currentPage = 0;
        this.currentSequence = [];
        this.sequences = { "0": [0, 2, 3, 5], "1": [6, 1, 4] };
        this.tapAllowed = false;

        if (App.episode == 3)
            this.sequences["2"] = [8, 9];
        else if (App.episode == 4) {
            this.sequences["2"] = [10];
            this.sequences["4"] = [11];
        }

        Tutorial.instance = this;

        //0                             1                       2                       3
        this.pages.push(new FirstGroupTapTutorial(), new HighValueTapTutorial(), new LineTapTutorial(), new BonusTapTutorial(), new BonusInfoTutorial(), new ReachScoreTutorial(), new BonusComboTapTutorial(), new ComboInfoTutorial(), new InfectCellTutorial1(), new InfectCellTutorial2(), new ChocoBombTutorial(), new BushTutorial());
    }
    Tutorial.prototype.hasTutorial = function (n) {
        return this.sequences[n.toString()];
    };

    Tutorial.prototype.show = function () {
        var current = this.sequences[Match3Level.instance.levelData.levelNumber.toString()];
        this.currentSequence = [];
        for (var i = 0; i < current.length; ++i)
            this.currentSequence.push(this.pages[current[i]]);
        this.currentPage = 0;
        this.currentSequence[this.currentPage].show();
    };

    Tutorial.prototype.hide = function () {
    };

    Tutorial.prototype.getBonusComboCell = function (c1, c2) {
        return this.currentPage == 1 && this.currentSequence[this.currentPage] == this.pages[1] && Match3Level.instance.currentMove == 1 ? (App.episode <= 1 ? (c1.x < c2.x ? c1 : c2) : (c1.x < c2.x ? c2 : c1)) : null;
    };

    Tutorial.prototype.checkHighValueCell = function (c) {
        return this.currentPage == 1 && this.currentSequence[this.currentPage] == this.pages[1] && Match3Level.instance.currentMove == 1 && ((App.episode <= 1 && c.x == 3 && c.y == 6) || (App.episode == 2 && c.x == 6 && c.y == 8) || (App.episode == 3 && c.x == 3 && c.y == 5) || (App.episode == 4 && c.x == 3 && c.y == 4));
    };

    Tutorial.prototype.getBonusSpawnCell = function () {
        return this.currentPage == 2 && this.currentSequence[this.currentPage] == this.pages[3] ? (App.episode <= 1 ? Match3Level.instance.cells[2][3] : App.episode <= 2 ? Match3Level.instance.cells[1][3] : App.episode == 3 ? Match3Level.instance.cells[4][5] : Match3Level.instance.cells[1][6]) : null;
    };

    Tutorial.prototype.nextPage = function () {
        this.currentSequence[this.currentPage].hide();

        if (this.currentPage < this.currentSequence.length - 1) {
            ++this.currentPage;
            this.currentSequence[this.currentPage].show();
        } else {
            if (this == MenuManager.instance.current)
                MenuManager.instance.closeCurrent();
        }
    };

    Tutorial.prototype.allowTap = function (x, y) {
        return this.currentSequence[this.currentPage].allowTap(x, y);
    };

    Tutorial.prototype.onDown = function (x, y) {
        _super.prototype.onDown.call(this, x, y);

        this.tapAllowed = this.allowTap(x, y);
        this.currentSequence[this.currentPage].onDown(x, y);
    };
    return Tutorial;
})(Menu);

var TutorialPage = (function (_super) {
    __extends(TutorialPage, _super);
    function TutorialPage() {
        _super.call(this);
        this.tapCells = [];
        this.isHiding = false;
        this.isShowing = false;
        this.showDelay = 0;
        this.hideDelay = 0;
        this.tutorial = Tutorial.instance;
    }
    TutorialPage.prototype.init = function (s) {
        s.cache(0, 0, App.SCREEN_W, App.FULL_SCREEN_H);
        this.sprite = s;
    };

    TutorialPage.prototype.onDown = function (x, y) {
        if (this.checkHide(x, y))
            this.tutorial.nextPage();
    };

    TutorialPage.prototype.allowTap = function (x, y) {
        if (this.sprite.alpha < 0.5)
            return false;

        var len = this.tapCells.length;
        var posx = Match3Level.instance.stageToGridX(x);
        var posy = Match3Level.instance.stageToGridY(y);
        posx = Math.floor(posx);
        posy = Math.floor(posy);
        for (var i = 0; i < len; ++i) {
            var cellP = this.tapCells[i];
            if (cellP.x == posx && cellP.y == posy)
                return true;
        }
        return false;
    };

    TutorialPage.prototype.checkHide = function (x, y) {
        return this.allowTap(x, y);
    };

    TutorialPage.prototype.hide = function () {
        var _this = this;
        if (!this.isHiding) {
            this.isHiding = true;
            createjs.Tween.get(this.sprite, { loop: false }).wait(this.hideDelay * 1000).to({ alpha: 0 }, 300).call(function () {
                return _this.removeSprite();
            });
        }
    };

    TutorialPage.prototype.show = function () {
        this.isShowing = true;
        this.isHiding = false;
        if (!this.sprite.parent) {
            App.game.stage.addChild(this.sprite);
            this.sprite.y = App.episode <= 2 ? App.SHIFT_H : 0;
            this.sprite.alpha = 0;
            createjs.Tween.get(this.sprite, { loop: false }).wait(this.showDelay * 1000).to({ alpha: 1 }, 300);
        }
    };

    TutorialPage.prototype.removeSprite = function () {
        removeClip(this.sprite);
    };
    return TutorialPage;
})(GameObject);

var FirstGroupTapTutorial = (function (_super) {
    __extends(FirstGroupTapTutorial, _super);
    function FirstGroupTapTutorial() {
        _super.call(this);

        if (App.episode <= 1)
            this.tapCells.push(cjp(5, 1), cjp(5, 2), cjp(5, 3), cjp(4, 2), cjp(6, 2), cjp(6, 3));
        else if (App.episode <= 2)
            this.tapCells.push(cjp(2, 5), cjp(3, 4), cjp(3, 5), cjp(4, 4), cjp(4, 5), cjp(4, 6), cjp(5, 6));
        else if (App.episode <= 3)
            this.tapCells.push(cjp(3, 6), cjp(4, 6), cjp(5, 6), cjp(3, 7), cjp(4, 7), cjp(5, 7), cjp(5, 8));
        else if (App.episode <= 4)
            this.tapCells.push(cjp(4, 3), cjp(4, 4), cjp(5, 4));

        var s = new createjs.Container();

        var b = createBitmap("tutorial1");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        b.alpha = 0.8;
        s.addChild(b);

        var t = new createjs.BitmapText("Tap to remove\n     jellies", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.scaleX = t.scaleY = 0.9;
        t.x = 99 + 50 + (App.episode <= 1 ? 0 : App.episode <= 2 ? -85 : App.episode == 3 ? -60 : -45);
        t.y = 340 - 10 + (App.episode <= 1 ? 0 : App.episode <= 2 ? -120 : App.episode == 3 ? 90 : 150);
        s.addChild(t);

        this.hideDelay = 0.15;
        this.showDelay = 0.5;

        this.init(s);
    }
    return FirstGroupTapTutorial;
})(TutorialPage);

var HighValueTapTutorial = (function (_super) {
    __extends(HighValueTapTutorial, _super);
    function HighValueTapTutorial() {
        _super.call(this);

        var s = new createjs.Container();
        var dy = 124;

        var b = createBitmap("tutorial2");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        b.alpha = 0.8;
        s.addChild(b);

        var t = new createjs.BitmapText("Some jellies give\nadditional points", App.game.atlases[0]);
        t.scaleX = t.scaleY = 0.8;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 99 + (App.episode <= 1 ? 0 : App.episode <= 2 ? 90 : -50);
        t.y = 400 + (App.episode <= 1 ? 0 : App.episode <= 2 ? 50 : App.episode == 4 ? 80 : -80) + dy;
        s.addChild(t);

        var t = new createjs.BitmapText("Tap anywhere to continue", App.game.atlases[1]);
        t.scaleX = t.scaleY = 0.55;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 45;
        t.y = 675 + dy;
        s.addChild(t);

        this.hideDelay = 0.0;
        this.showDelay = 2.5;

        this.init(s);
    }
    HighValueTapTutorial.prototype.allowTap = function (x, y) {
        return false;
    };

    HighValueTapTutorial.prototype.checkHide = function (x, y) {
        return _super.prototype.checkHide.call(this, x, y) || this.sprite.alpha > 0.9;
    };
    return HighValueTapTutorial;
})(TutorialPage);

var LineTapTutorial = (function (_super) {
    __extends(LineTapTutorial, _super);
    function LineTapTutorial() {
        _super.call(this);

        if (App.episode <= 1)
            this.tapCells.push(cjp(3, 7), cjp(4, 7), cjp(5, 7), cjp(6, 7), cjp(7, 7));
        else if (App.episode <= 2)
            this.tapCells.push(cjp(6, 2), cjp(6, 3), cjp(6, 4), cjp(6, 5), cjp(6, 6));
        else if (App.episode == 3)
            this.tapCells.push(cjp(3, 7), cjp(4, 7), cjp(5, 7), cjp(6, 7));
        else
            this.tapCells.push(cjp(3, 7), cjp(4, 7), cjp(5, 7), cjp(6, 7));

        var s = new createjs.Container();

        var b = createBitmap("tutorial3");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        b.alpha = 0.8;
        s.addChild(b);

        var t = new createjs.BitmapText("   remove line\nto create bonus", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 130 + (App.episode <= 1 ? 0 : App.episode <= 2 ? 55 : -30);
        t.y = 340 + 50 + (App.episode <= 1 ? 0 : 85);
        t.scaleX = t.scaleY = 0.85;
        s.addChild(t);

        this.hideDelay = 0.15;
        this.showDelay = 2;

        this.init(s);
    }
    return LineTapTutorial;
})(TutorialPage);

var BonusTapTutorial = (function (_super) {
    __extends(BonusTapTutorial, _super);
    function BonusTapTutorial() {
        _super.call(this);

        if (App.episode <= 1)
            this.tapCells.push(cjp(0, 3), cjp(1, 3), cjp(2, 3), cjp(0, 2));
        else if (App.episode <= 2)
            this.tapCells.push(cjp(0, 3), cjp(0, 4), cjp(0, 4), cjp(1, 3));
        else if (App.episode == 3)
            this.tapCells.push(cjp(3, 5), cjp(4, 5), cjp(3, 6), cjp(4, 6));
        else
            this.tapCells.push(cjp(1, 6), cjp(1, 7), cjp(1, 8));

        var s = new createjs.Container();

        var b = createBitmap("tutorial4");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        b.alpha = 0.8;
        s.addChild(b);

        var t = new createjs.BitmapText("activate bonus", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 35 + (App.episode <= 1 ? 0 : App.episode <= 2 ? 45 : App.episode == 3 ? 55 : 10);
        t.y = 240 + 90 + (App.episode == 3 ? 100 : App.episode == 4 ? 160 : 0);
        t.scaleX = t.scaleY = 0.7;
        s.addChild(t);

        this.hideDelay = 0.15;
        this.showDelay = 1.5;

        this.init(s);
    }
    return BonusTapTutorial;
})(TutorialPage);

var BonusInfoTutorial = (function (_super) {
    __extends(BonusInfoTutorial, _super);
    function BonusInfoTutorial() {
        _super.call(this);

        var s = new createjs.Container();

        var b = createBitmap("tutorial5");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        b.alpha = 0.85;
        s.addChild(b);

        var ddy = App.episode >= 3 ? 124 : 0;

        var t = new createjs.BitmapText("line length determines\n       bonus power", App.game.atlases[0]);
        t.scaleX = t.scaleY = 0.85;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 25 - 20;
        t.y = 140 - 30 - 80 + ddy;
        s.addChild(t);

        var dx = -40;
        var dy = 0;

        for (var i = 0; i < 3; ++i) {
            var scale = 0.85;
            var yPos = 250 + i * 90 * scale;

            for (var j = 0; j < (4 + i); ++j) {
                var m = createSpriteFromSpritesheet("orange");
                m.scaleX = m.scaleY = scale;
                m.x = 100 + (j + (2 - i)) * 60 * m.scaleX + dx;
                m.y = yPos + dy + ddy;
                s.addChild(m);
            }

            var t = new createjs.BitmapText("-", App.game.atlases[1]);
            t.x = 340 + 100 - 15 - 5 + dx;
            t.y = yPos - 30 + 5 + dy + ddy;
            s.addChild(t);

            for (var j = 0; j < (i == 0 ? 2 : 1); ++j) {
                var m = createSpriteFromSpritesheet(i == 0 ? (j == 0 ? "orange horizontal" : "orange vertical") : i == 1 ? "orange bomb" : "bonus color");
                m.scaleX = m.scaleY = 1;
                m.regX = m.getBounds().width / 2;
                m.regY = m.getBounds().height / 2;
                m.x = 400 + j * 65 + 100 + dx;
                m.y = yPos + 20 + dy + ddy;
                s.addChild(m);
            }
        }

        var t = new createjs.BitmapText("Tap anywhere to continue", App.game.atlases[1]);
        t.scaleX = t.scaleY = 0.55;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 45;
        t.y = 660 + ddy;
        s.addChild(t);

        this.hideDelay = 0.0;
        this.showDelay = 0.5;

        this.init(s);
    }
    BonusInfoTutorial.prototype.allowTap = function (x, y) {
        return false;
    };

    BonusInfoTutorial.prototype.checkHide = function (x, y) {
        return _super.prototype.checkHide.call(this, x, y) || this.sprite.alpha > 0.9;
    };
    return BonusInfoTutorial;
})(TutorialPage);

var ReachScoreTutorial = (function (_super) {
    __extends(ReachScoreTutorial, _super);
    function ReachScoreTutorial() {
        _super.call(this);

        var s = new createjs.Container();

        var b = createBitmap("tutorial6");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        var dy = App.episode >= 3 ? 124 : 0;
        b.alpha = 0.8;
        s.addChild(b);

        var score = LevelManager.instance.data[0].customData;
        var t = new createjs.BitmapText("    Continue and\ncollect " + score + " points!", App.game.atlases[0]);
        t.scaleX = t.scaleY = 0.92;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 50;
        t.y = 240 - 100 + dy;
        s.addChild(t);

        var t = new createjs.BitmapText((LevelManager.instance.data[0].movesLeft - 3) + " moves left!", App.game.atlases[0]);
        t.scaleX = t.scaleY = 1;
        t.letterSpacing = -10;
        t.spaceWidth = 35;
        t.lineHeight = 60;
        t.x = 100;
        t.y = 240 + 66 + dy;
        s.addChild(t);

        var t = new createjs.BitmapText("Tap anywhere to continue", App.game.atlases[1]);
        t.scaleX = t.scaleY = 0.55;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 45;
        t.y = 660 + dy;
        s.addChild(t);

        this.hideDelay = 0.0;
        this.showDelay = 2.6;

        this.init(s);
    }
    ReachScoreTutorial.prototype.allowTap = function (x, y) {
        return false;
    };

    ReachScoreTutorial.prototype.checkHide = function (x, y) {
        return _super.prototype.checkHide.call(this, x, y) || this.sprite.alpha > 0.9;
    };
    return ReachScoreTutorial;
})(TutorialPage);

var BonusComboTapTutorial = (function (_super) {
    __extends(BonusComboTapTutorial, _super);
    function BonusComboTapTutorial() {
        _super.call(this);

        if (App.episode <= 1)
            this.tapCells.push(cjp(1, 4), cjp(1, 5), cjp(1, 6), cjp(2, 5), cjp(2, 6), cjp(2, 7), cjp(3, 4), cjp(3, 5), cjp(3, 7), cjp(3, 8), cjp(3, 9), cjp(4, 7), cjp(4, 8));
        else if (App.episode <= 2)
            this.tapCells.push(cjp(2, 6), cjp(2, 7), cjp(3, 7), cjp(3, 8), cjp(4, 5), cjp(4, 6), cjp(4, 8), cjp(4, 9), cjp(5, 5), cjp(5, 7), cjp(5, 8), cjp(6, 5), cjp(6, 6), cjp(6, 7));
        else if (App.episode == 3)
            this.tapCells.push(cjp(3, 3), cjp(4, 3), cjp(5, 3), cjp(2, 4), cjp(3, 4), cjp(5, 4), cjp(4, 5), cjp(5, 5), cjp(2, 6), cjp(3, 6), cjp(4, 6), cjp(4, 7), cjp(5, 7), cjp(5, 8), cjp(4, 9), cjp(5, 9));
        else
            this.tapCells.push(cjp(3, 7), cjp(3, 6), cjp(3, 5), cjp(4, 5), cjp(4, 4), cjp(4, 3), cjp(5, 3), cjp(5, 2), cjp(5, 1));

        var s = new createjs.Container();

        var b = createBitmap("tutorial7");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = App.episode <= 2 ? 3 - 9 : 0;
        b.alpha = 0.8;
        s.addChild(b);

        var t = new createjs.BitmapText("  Combine bonuses\nto enchance them!", App.game.atlases[0]);
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 210 + (App.episode <= 1 ? 0 : -90);
        t.y = 340 + 67 + (App.episode <= 1 ? 0 : App.episode == 4 ? -230 : -110);
        t.scaleX = t.scaleY = 0.7;
        s.addChild(t);

        this.hideDelay = 0.15;
        this.showDelay = 0.5;

        this.init(s);
    }
    return BonusComboTapTutorial;
})(TutorialPage);

var ComboInfoTutorial = (function (_super) {
    __extends(ComboInfoTutorial, _super);
    function ComboInfoTutorial() {
        _super.call(this);

        var s = new createjs.Container();

        var b = createBitmap("tutorial5");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.x = 0;
        b.y = 3 - 9;
        b.alpha = 0.85;
        s.addChild(b);

        var t = new createjs.BitmapText(" Combine bonuses\nto enchance them!", App.game.atlases[0]);
        t.scaleX = t.scaleY = 0.95;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 40;
        t.y = 140 - 30 - 80;
        s.addChild(t);

        var dx = -40;
        var dy = 0;

        for (var y = 0; y < 4; ++y) {
            for (var x = 0; x < y + 4; ++x) {
                var bonus = Math.random() < 0.25;
                var bonusType = getInt(3);
                var m = createSpriteFromSpritesheet(bonus ? (bonusType == 0 ? "blue horizontal" : bonusType == 1 ? "blue vertical" : "blue bomb") : "blue");
                m.x = 140 + x * 60;
                m.y = 250 + y * 60;
                s.addChild(m);
            }
        }

        var t = new createjs.BitmapText("Tap anywhere to continue", App.game.atlases[1]);
        t.scaleX = t.scaleY = 0.55;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 45;
        t.y = 660;
        s.addChild(t);

        this.hideDelay = 0.0;
        this.showDelay = 2.5;

        this.init(s);
    }
    ComboInfoTutorial.prototype.allowTap = function (x, y) {
        return false;
    };

    ComboInfoTutorial.prototype.checkHide = function (x, y) {
        return _super.prototype.checkHide.call(this, x, y) || this.sprite.alpha > 0.9;
    };
    return ComboInfoTutorial;
})(TutorialPage);

var InfectCellTutorial1 = (function (_super) {
    __extends(InfectCellTutorial1, _super);
    function InfectCellTutorial1() {
        _super.call(this);

        if (App.episode <= 3)
            this.tapCells.push(cjp(8, 4), cjp(9, 4), cjp(8, 5), cjp(9, 5));

        var s = new createjs.Container();

        var b = createBitmap("tutorial8");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.alpha = 0.8;
        s.addChild(b);

        var texts = ["remove group to", "free water cells"];
        for (var i = 0; i < 2; ++i) {
            var t = new createjs.BitmapText(texts[i], App.game.atlases[0]);
            t.letterSpacing = -10;
            t.spaceWidth = 25;
            t.lineHeight = 60;
            t.x = 235 + i * (-15);
            t.y = 335 + i * 50;
            t.scaleX = t.scaleY = 0.7;
            s.addChild(t);
        }

        this.hideDelay = 0.25;
        this.showDelay = 0.5;

        this.init(s);
    }
    return InfectCellTutorial1;
})(TutorialPage);

var InfectCellTutorial2 = (function (_super) {
    __extends(InfectCellTutorial2, _super);
    function InfectCellTutorial2() {
        _super.call(this);

        var s = new createjs.Container();

        var b = createBitmap("tutorial9");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.alpha = 0.8;
        s.addChild(b);

        var texts = [" water spreads", "on near cells"];
        for (var i = 0; i < 2; ++i) {
            var t = new createjs.BitmapText(texts[i], App.game.atlases[0]);
            t.letterSpacing = -10;
            t.spaceWidth = 25;
            t.lineHeight = 60;
            t.x = 90 + i * 55;
            t.y = 295 + i * 60;
            t.scaleX = t.scaleY = 0.8;
            s.addChild(t);
        }

        var t = new createjs.BitmapText("Tap anywhere to continue", App.game.atlases[1]);
        t.scaleX = t.scaleY = 0.55;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 45;
        t.y = 760;
        s.addChild(t);

        this.hideDelay = 0.25;
        this.showDelay = 1.2;

        this.init(s);
    }
    InfectCellTutorial2.prototype.allowTap = function (x, y) {
        return false;
    };

    InfectCellTutorial2.prototype.checkHide = function (x, y) {
        return _super.prototype.checkHide.call(this, x, y) || this.sprite.alpha > 0.9;
    };
    return InfectCellTutorial2;
})(TutorialPage);

var ChocoBombTutorial = (function (_super) {
    __extends(ChocoBombTutorial, _super);
    function ChocoBombTutorial() {
        _super.call(this);

        if (App.episode == 4)
            this.tapCells.push(cjp(5, 7), cjp(6, 7), cjp(7, 7));

        var s = new createjs.Container();

        var b = createBitmap("tutorial8");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.alpha = 0.8;
        s.addChild(b);

        var texts = ["tap to activate", "chocolate bomb"];
        for (var i = 0; i < 2; ++i) {
            var t = new createjs.BitmapText(texts[i], App.game.atlases[0]);
            t.letterSpacing = -10;
            t.spaceWidth = 25;
            t.lineHeight = 60;
            t.x = 225 + i * (-0);
            t.y = 435 + i * 50;
            t.scaleX = t.scaleY = 0.75;
            s.addChild(t);
        }

        this.hideDelay = 0.25;
        this.showDelay = 0.5;

        this.init(s);
    }
    return ChocoBombTutorial;
})(TutorialPage);

var BushTutorial = (function (_super) {
    __extends(BushTutorial, _super);
    function BushTutorial() {
        _super.call(this);

        var s = new createjs.Container();

        var b = createBitmap("tutorial9");
        b.scaleX = b.scaleY = 4;
        b.regX = 0;
        b.alpha = 0.8;
        s.addChild(b);

        var texts = ["poisonous plants need", "to be removed twice"];
        for (var i = 0; i < texts.length; ++i) {
            var t = new createjs.BitmapText(texts[i], App.game.atlases[0]);
            t.letterSpacing = -10;
            t.spaceWidth = 25;
            t.lineHeight = 60;
            t.x = 55 + i * 20;
            t.y = 385 + i * 55;
            t.scaleX = t.scaleY = 0.75;
            s.addChild(t);
        }

        var t = new createjs.BitmapText("Tap anywhere to continue", App.game.atlases[1]);
        t.scaleX = t.scaleY = 0.55;
        t.letterSpacing = -10;
        t.spaceWidth = 25;
        t.lineHeight = 60;
        t.x = 45;
        t.y = 760;
        s.addChild(t);

        this.hideDelay = 0.25;
        this.showDelay = 0.3;

        this.init(s);
    }
    BushTutorial.prototype.allowTap = function (x, y) {
        return false;
    };

    BushTutorial.prototype.checkHide = function (x, y) {
        return _super.prototype.checkHide.call(this, x, y) || this.sprite.alpha > 0.9;
    };
    return BushTutorial;
})(TutorialPage);
/// <reference path="lib/viewporter.d.ts" />
var viewporter;

window.onload = function () {

    analytics = new Analytics();
    analytics.sendPageView("Game Start");
    var game = new App();
};

function isOrientationLocked() {
    return false;

    if (!viewporter || !viewporter.ACTIVE) {
        return false;
    }
    var isLandscape = window.innerWidth > window.innerHeight && window.innerWidth <= 640;
    return isLandscape || viewporter.isLandscape();
}
