var map;
//////////////////
//iniciar el mapa
//////////////////
function initmap(mapaUrlOnline) {
    // set up the map
    map = new L.Map('mapa', {zoomControl: false});

    //atributos del mapa
    var osm = new L.TileLayer(mapaUrlOnline,
        {
            minZoom: 11,
            maxZoom: 17,
            attribution: '',
            reuseTiles: true,
            unloadInvisibleTiles: false
        });

    // setear las cordenadas en tandil
    map.setView(new L.LatLng(-38.71251965355759, -62.258908450000035), 13);
    map.addLayer(osm);

    //zoom a la izquierda
    new L.Control.Zoom({position: 'bottomleft'}).addTo(map);
}

/////////////////////////////////
///cambiar el mapa //////////////
/////////////////////////////////
function cambiarMapa(mapaUrl) {
    var capa = L.tileLayer(mapaUrl, {
        attribution: '',
        minZoom: 11,
        maxZoom: 17
    });
    map.addLayer(capa);
}

////////////////////////////
//calificar la app
////////////////////////////
function calificar(urlRecomendar) {
    window.open(urlRecomendar, '_system')
}

////////////////////////////
//calificar la app
////////////////////////////
function horarios() {
    window.open('http://www.bahiatransporte.com.ar/frecuencias', '_system')
}

//////////////////////////
//compartir funcion
//////////////////////////
function compartirApp(urlRecomendar) {
    return window.plugins.socialsharing.share('Consultá la aplicación \'Bahia Transporte\'', null, null, urlRecomendar)
}

///////////////////////
//chequear conexion
////////////////////////
function checkConnection2() {
    var networkState = navigator.connection.type;
    var states = {};
    states[Connection.UNKNOWN] = 'Conexión desconocida';
    states[Connection.ETHERNET] = 'Conexión ethernet';
    states[Connection.WIFI] = 'Conexión WiFi';
    states[Connection.CELL_2G] = 'Conexión movil 2G';
    states[Connection.CELL_3G] = 'Conexión movil 3G';
    states[Connection.CELL_4G] = 'Conexión movil 4G';
    states[Connection.NONE] = 'Sin conexión';

    if (states[networkState] === 'Sin conexión') {
        console.log('Red: ' + states[networkState]);
        //aviso que no tiene conexion
        var aviso = '<div class="aviso"><center><h4>Sin conexión a internet</h4></center></div>';
        $('body').after(aviso);
        $('.aviso').css({
            'text-transform': 'uppercase',
            'color': 'white',
            'position': 'absolute',
            'background': 'red',
            'top': '10%',
            'width': '100%',
            'z-index': '990',
            'height': 'auto'
        });
    } else {
        $('.aviso').remove();
    }
}

////////////////////
///avisar //////////
////////////////////
function aviso(mensaje) {
    $('body').after('<div class="aviso"><p>' + mensaje + '</p><div class="clear"></div></div>');

    $('.aviso').css({
        'text-transform': 'uppercase',
        'color': 'white',
        'position': 'absolute',
        'background': 'red',
        'top': '1%',
        'width': '100%',
        'z-index': '999',
        'height': 'auto'
    });

    setTimeout(function () {
        $('.aviso').remove();
    }, 1500);
}


//////////////////////////////
///quitar el aviso ///////////
//////////////////////////////
function quitarAviso(aviso) {
    $(aviso).remove();
}

//////////////////////
//salir de la app ////
//////////////////////
function salirApp() {

    if (abiertosub == 1) {
        cerrarSecundario();
    } else {
        menu();
    }

    if (abierto == 1) {
        menu();
    } else {
        navigator.app.exitApp();
    }
}

//////////////////
///////cargando///
//////////////////
function cargando() {

    if (cargate == 0) {
        //alert('Cargando...');
        var carga =
            '<div id="cargando">' +
            '<center>' +
            '<img src="img/loading.gif" alt="cargando"/>' +
            '<div class="clear"></div>' +
            '</center>' +
            '</div>';
        var alto = $(window).height();

        $('#loading').html(carga).css('display', 'block');
        centrar();
    }
}

////////////////////
///quitar cargando//
////////////////////
function cargandoQuit() {
    $('#loading').css('display', 'none');
}

////////////////////
//function cerrar
////////////////////
function cerrate(ventana) {
    $(ventana).css({
        'display': 'none'
    });
}

/////////////////////////
//// titulo de la linea//
////////////////////////
function lineaNombre(linea) {
    var tituloApp = $('#tituloLinea');
    var nombreFinal;

    if (linea == 'pv' || linea == 'v') {
        nombreFinal = 'Pos de recarga';
        console.log('Linea pedida: ' + nombreFinal);
    } else {
        var nombre = linea.slice(1);
        nombreFinal = 'Linea  ' + nombre.replace('_', ' ');
        console.log('Linea pedida: ' + nombreFinal);
    }
    if (linea === '2_5191') {
        nombreFinal = 'Linea 519 A';
        console.log('Linea pedida: ' + nombreFinal);
    }
    if (linea === '8_5131') {
        nombreFinal = 'Linea 513 EX';
        console.log('Linea pedida: ' + nombreFinal);
    }

    if (linea === 'rk' || linea === 'Rk' || linea === 'prk') {
        nombreFinal = 'Parquimetros';
        console.log('Linea pedida: ' + nombreFinal);
    }
    if (linea == 9 || linea == '9_9') {
        nombreFinal = 'Linea UNS';
        console.log('Linea pedida: ' + nombreFinal);
    }

    if (linea == 'Residuos') {
        nombreFinal = 'Residuos';
        console.log('Linea pedida: ' + nombreFinal);
    }


    tituloApp.text(nombreFinal);
}

/////////////////////
///Recardar numero //
/////////////////////
function recordar() {
    var valor = $('#numero').val();
    localStorage.setItem('n-tarjeta', valor);
    var numeroTarjeta = localStorage.getItem('n-tarjeta');
    console.log('Numero: ' + numeroTarjeta);
}

/////////////////////////
//recordar linea y ciudad
/////////////////////////
function recordarLinea() {
    var valor = $('#linea').val();
    localStorage.setItem('linea-frecuente', valor);
    console.log('Su linea frecuente: ' + valor);

    var valorCity = $('#city').val();
    valorCityF = valorCity.replace(/ /g, "_");
    localStorage.setItem('city-frecuente', valorCityF);
    console.log('Su ciudad frecuente: ' + valorCityF);
}

/////////////////////
///Recordar direccion
/////////////////////
function recordarDir() {
    var valor = $('#direccion').val();
    localStorage.setItem('direccion', valor);
    var direccionIng = localStorage.getItem('direccion');
    console.log('Dir: ' + direccionIng);
}

//////////////////////////
//solo numeros
//////////////////////////
function isNumberKey(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
}

///////////////////////////////
//maximo de numeros en tarjeta
//////////////////////////////
function maximo(campo, limite) {
    if (campo.value.length >= limite) {
        campo.value = campo.value.substring(0, limite);
    }
}

/////////////////////////
//consultas tiny y saldo
/////////////////////////
function consultar(form, tipo, resultado) {
    $(form).serializeArray();
    //resultado general
    var resultado = $(resultado);
    var resulMov = $('#movResultados');

    //borrar los resultados
    resultado.html('');
    resulMov.html('');

    //para la consulta de la linea
    if (tipo == 'tiny') {

        if ($('#direccion').val() === '') {
            resultado.html('<center><strong>ingrese una dirección</strong></center><br/>');
            return false;
        }

        //la linea consultada
        var linea = $('#linea').val();
        //la url de consulta
        var url = urlServer + '/ajax/ebus/get_smarth_info_app/';
        console.log(url);

        //los datos enviados
        var dataEnvio = {
            'direccion': $('#direccion').val(),
            'city': $('#city').val(),
            'linea': $('#linea').val()
        };

        //el tipo
        var typeG = 'POST';
        var before = cargando('#cerrarTiny');
    }

    //saldo variables
    if (tipo == 'saldo') {
        var numero = $('#numero').val(); //numero de tarjeta
        var movimientos = $('#selec-rango').val(); //movimientos
        var typeG = 'GET'; //el tipo
        var url = urlServer + '/movimientos/get_saldo_app/' + numero;


        if (numero.length < 7) {
            resultado.html('<center><strong>ingrese todos los dígitos de la tarjeta</strong></center><br/>');
            return false;
        }
        console.log('Saldo --> ' + url);

        //var before = cargando('#cerrarSaldo');
    }

    $.ajax({
        data: dataEnvio,
        url: url,
        type: typeG,
        beforeSend: function () {
            enviando();
        },


        success: function (response) {
            cargandoRemove();

            ////imprimo el resultado del saldo
            if (tipo == 'saldo') {
                resultado.html('<center><h3>Su saldo es $' + response + '</h3></center><hr>');
            } else {
                resultado.html('<center>' + response + '</center>');
            }

            ///imprimir movimientos
            if (tipo == 'saldo') {

                $.ajax({
                    data: '',
                    url: urlServer + '/movimientos/get_movimientos/' + numero + '/' + movimientos,
                    type: 'post',
                    beforeSend: function () {

                    },
                    success: function (msg) {


                        if (msg == 0) {
                            //$(".v_captcha_mov"  ).show();
                        } else {
                            if (msg == 1) {
                                resultado.html('Tarjeta invalida');
                                //$(".label_tarjeta_invalida").show();
                            } else {
                                if (msg == 2) {
                                    resultado.html('Sin movimientos');
                                    //$(".label_sin_mov").show();
                                } else {
                                    //mostrar resultados OK
                                    var e = eval('(' + msg + ')');
                                    console.log(e);

                                    //imprmir en pantalla
                                    var str = "";
                                    str = str + "<center><h3>Movimientos</h3></center>";
                                    for (var a in e) {
                                        str = str + "<div class='saldo-resul' '>";
                                        //str = str + "<div>" + e[a].transaccion + "</div>";
                                        str = str + "<div><strong>Tipo: </strong>" + e[a].tipo + "</div>";
                                        str = str + "<div><strong>Fecha: </strong>" + e[a].fecha + "</div>";
                                        str = str + "<div><strong>Hora: </strong>" + e[a].hora + "</div>";
                                        str = str + "<div><strong>Patente: </strong>" + e[a].linea + "</div>";
                                        //str = str + "<div><strong>Interno: </strong>" + e[a].unidad + "</div>";
                                        //str = str + "<div>" + e[a].boleto + "</div>";
                                        //str = str + "<div>" + e[a].cant_pasajes + "</div>";
                                        str = str + "<div><strong>Importe: </strong>" + e[a].importe + "</div>";
                                        str = str + "<div><strong>Saldo: </strong>" + e[a].saldo + "</div>";
                                        //str = str + "<div><strong></strong>" + e[a].saldo_viajes + "</div>";
                                        str = str + "<hr/>";
                                        str = str + "</div>";
                                    }
                                }
                                //imprimir los movimientos
                                console.log('Resultados de los movimientos');
                                //resulMov.html('<center>'+str+'</center>');
                                resulMov.html(str);
                            }
                        }
                    },
                    error: function () {
                        console.log('Error ajax consulta movimientos');
                    }
                });
                //////////// fin movimientos
            }
        },
        error: function () {
            console.log('error de ajax');
        }
    })
}

///////////////////
//mostrar enviando
///////////////////
function enviando() {
    $('form').after('<div id="enviando" style="text-align: center"><img src="img/load.gif"> Enviando</div>');
}

/////////////////////////
//borrar en el enviando
/////////////////////////
function cargandoRemove() {
    $('#enviando').remove();
    $('#cargas').hide();
}

////////////////////////////
///funcion mandar sugerencia
////////////////////////////
function sugerencia(form) {
    $(form).serializeArray();
    console.log($('#tipo').val());

    if ($('#tel').val() === '' || $('#nombre').val() === '' || $('#desc').val() === '') {
        $('#ok').html('<br><center>Complete todos los campos</center><br>');
        setTimeout(function () {
            $('#ok').html('');
        }, 2000);
        return false;
    }

    $.ajax({
        type: 'POST',
        url: urlServer + "/tiny/send_sugges_app",
        data: {
            'tel': $('#tel').val(),
            'tipo': $('#tipo_con').val(),
            'nombre': $('#nombre').val(),
            'descrip': $('#desc').val() + '<hr>' + $('#device').val()
        },

        beforeSend: function () {
            enviando()
        },
        success: function (response) {
            console.log(response);

            cargandoRemove();
            $('#enviando').remove();

            /*cartel de que se envio la sugerencia*/
            console.log('Enviada');
            $(':text, textarea').val('');

            $('#ok').html('<center>Enviado correctamente<br>Muchas Gracias<br></center>');

            setTimeout(function () {
                $('#tel').val('');
                $('#nombre').val('');
                $('#desc').val('');
                $('#ok').html('');
            }, 3000)
        },
        error: function () {
            console.log('Error ajax');
        }
    })

}

///////////////////////
//obtener la direccion
///////////////////////
$('#direccion_actual').hide();

function obtenerDireccion(latitud, longitud) {
    console.log('Lat:' + latitud);
    console.log('Long:' + longitud);
    $.ajax({
        dataType: "json",
        url: "http://nominatim.openstreetmap.org/reverse?format=json&lat=" + latitud + "&lon=" + longitud + "&addressdetails=1",
        type: "get",
        data: {format: "json", lat: latitud, lon: longitud}
    }).done(function (data) {
        dir = data.address.road;
        alt = data.address.house_number;
        ciudad = data.address.city;

        //crear la ventana
        $('#direccion_actual').show();
        $('#direccion_actual').html(dir + ' ' + alt + '<br>' + ciudad)
    });
}

//actualizar la ubicacione
function localizar() {
    navigator.geolocation.getCurrentPosition(onSuccess, onError);

    // onSuccess Geolocation
    function onSuccess(position) {

        map.removeLayer(marcador);

        var latitudUser = position.coords.latitude;
        var longitudUser = position.coords.longitude;

        //setear el mapa
        map.setView([latitudUser, longitudUser]);
        marcador = L.marker([latitudUser, longitudUser]).addTo(map);
        //marcador.bindPopup("Su ubicación").openPopup();

        //mostrarle la direccion
        obtenerDireccion(latitudUser, longitudUser);
    }

    // onError Callback receives a PositionError object
    function onError() {
        aviso('No se pudo obtener su ubicación, Verifique el GPS del dispositivo');
    }

}

/////////////////////////////
//funciones para parquimetros
/////////////////////////////
function parquimetrosOpc(tipo) {
    //mostrar menú completo
    if (tipo == 'ver') {
        $('#option-parq').show();
    }

    if (tipo == 'cerrar') {
        $('#option-parq').hide();
    }

}

///////////////////////////
///mostrar las referencias de parq
///////////////////////////
function mostrarRef(tipo) {

    if (tipo == 'tarifas') {
        $('#por-disponibilidad').hide('slow');
        $('#por-tarifas').show('slow');
    }

    if (tipo == 'disponibilidad') {
        $('#por-tarifas').hide('slow');
        $('#por-disponibilidad').show('slow');
    }
}

/////////////////////
/////mantener lineas
/////////////////////
//var sup_line;
function mantener() {
    sup_line = true;
}

//mostrar la info
function info() {
    menuOpciones('inc/menuInfo.html')
}

//alerta perzonalizada
function alerta(mensaje, titulo, boton) {
    function callBack() {
        console.log('salio');
    }

    navigator.notification.alert(mensaje, callBack, titulo, boton);
    navigator.vibrate(1000);
}

//enviar mensaje en pantalla
//function avisar(mensaje) {
//    var aviso = $('#avisar');
//    alerta(mensaje, 'Error', 'cerrar')
//}

//resaltar el error
function resaltar(iden) {
    $(iden).css({
        'background': 'red',
        'color': 'white !important'
    });
}

//funcion para registrar
var urlSMS;
var urlReintento;
function registro(form) {

    if (!$('#nombre').val() || !$('#apellido').val() || !$('#dni').val()) {
        aviso('Complete sus datos personales');
        resaltar('#nombre, #apellido, #dni');
        return false;
    }

    //domicilio  y numero
    if (!$('#dir').val()) {
        aviso('Ingrese su domicilio y altura de la calle');
        resaltar('#dir, #numero');
        return false;
    }

    //nombre de usuario
    if (!$('#usuario').val()) {
        aviso('ingrese un nombre de usuario');
        resaltar('#usuario');
        return false;
    }

    //verificacion de datos
    if ($('#mail').val().indexOf('@') == -1) {
        resaltar('#mail');
        aviso('Ingrese un mail valido con @');
        return false;
    }


    //contraseña
    if ($('#pass').val().length < 8) {
        resaltar('#pass');
        aviso('La contraseña debe tener como minimo 8 caracteres');
        return false;
    }


    //repetir contraseña
    if ($('#pass_c').val().length < 8) {
        resaltar('#pass_c');
        aviso('La contraseña debe tener como minimo 8 caracteres');
        return false;
    }

    if (!$('#cel_caract').val() || !$('#cel_number').val()) {
        resaltar('#cel_caract');
        resaltar('#cel_number');
        aviso('Complete su numero de telefono');
        return false;
    }

    //patente vehiculo
    if (!$('#patente_1').val()) {
        resaltar('#patente_1');
        aviso('Ingrese la patente del vehiculo 1');
        return false;
    }

    //marca
    if (!$('#marca_1').val()) {
        resaltar('#marca_1');
        aviso('Ingrese la marca del vehiculo 1');
        return false;
    }

    if (!$('#modelo_1').val()) {
        resaltar('#modelo_1');
        aviso('Ingrese el modelo del vehiculo 1');
        return false;
    }

    //color
    if (!$('#color_1').val()) {
        resaltar('#color_1');
        aviso('Ingrese el color del vehiculo 1');
        return false;
    }

    // vehiculo 2
    if ($('#patente_2').val()) {

        if (!$('#marca_2').val()) {
            resaltar('#marca_2');
            aviso('Ingrese la marca del vehiculo 2');
            return false;
        }

        if (!$('#modelo_2').val()) {
            resaltar('#modelo_2');
            aviso('Ingrese el modelo del vehiculo 2');
            return false;
        }
        if (!$('#color_2').val()) {
            resaltar('#color_2');
            aviso('Ingrese el color del vehiculo 2');
            return false;
        }
    }

    //vehiculo 3
    if ($('#patente_3').val()) {

        if (!$('#marca_3').val()) {
            resaltar('#marca_3');
            aviso('Ingrese la marca del vehiculo 3');
            return false;
        }
        if (!$('#modelo_3').val()) {
            resaltar('#modelo_3');
            aviso('Ingrese el modelo del vehiculo 3');
            return false;
        }
        if (!$('#color_3').val()) {
            resaltar('#color_3');
            aviso('Ingrese el color del vehiculo 3');
            return false;
        }
    }

    //sexo
    var sexo = 'F';
    if ($("#sexo").val() == "1") {
        sexo = 'M';
    }

    var celular_unico = $('#cel_caract').val() + $('#cel_number').val();
    console.log('Cel: ' + celular_unico);

    ///enviar el registro
    var datos = $(form).serializeArray();
    var url = urlServer + '/usuarios_app/registrar_btn';

    $.ajax({
        type: 'POST',
        data: datos,
        url: url,
        beforeSend: function () {
            enviando();
        },
        success: function (data) {
            cargandoRemove();

            //partir el string en array
            var respuesta = data.split('_');
            var codigoCel = respuesta[1];
            var hash = respuesta[2];


            //si se registra correctamente
            if (respuesta[0] == 'Usuario registrado correctamente') {

                var celCompleto = $('#cel_caract').val() + '-' + $('#cel_number').val();
                var celCompleto2 = celCompleto.replace('-', '');

                urlSMS = 'http://200.5.104.2/sms/testsend/send.php?cel=' + celCompleto2 + '&code=' + respuesta[1] + '&reintento=0';
                urlReintento = 'http://200.5.104.2/sms/testsend/send.php?cel=' + celCompleto2 + '&code=' + respuesta[1] + '&reintento=0';

                //enviar el mensajs de texto
                $.ajax({
                    type: 'GET',
                    data: {},
                    url: urlSMS,
                    beforeSend: function () {

                    },
                    success: function () {
                        cargandoRemove();

                        //le muestro la pantalla de confirmacion de SMS
                        setTimeout(function () {
                            //crear un storage para ver que completo el registro y pueda poner el codigo de vuelta

                            window.localStorage.setItem('registrado', 1);
                            window.localStorage.setItem('celV', celCompleto);
                            window.localStorage.setItem('hashV', hash);
                            window.localStorage.setItem('codigoV', codigoCel);
                            window.localStorage.setItem('mailV', $('#mail').val());

                            //ocultar
                            $('#confirm').show();
                            $('#registroV').hide();

                            //poner los valore en el area de confirmacion
                            //$('#celV').val($('#cel').val());
                            //$('#hashV').val(hash);
                            //$('#codigo_oculto').val(codigoCel);

                            $('#mailV').val(window.localStorage.getItem('mailV'));
                            $('#celV').val(window.localStorage.getItem('celV'));
                            $('#hashV').val(window.localStorage.getItem('hashV'));
                            $('#codigo_oculto').val(window.localStorage.getItem('codigoV'));

                        }, 1000);
                    }
                });

            } else {
                //avisar error de registro
                aviso(data);
                cargandoRemove();
                console.log(data)
            }

        },
        error: function () {
            aviso('Error al enviar los datos');
        }
    })
}

////funcion para reenvio //
function reenviar() {
    urlReintento = 'http://200.5.104.2/sms/testsend/send.php?cel=' + window.localStorage.getItem('celV') + '&code=' + window.localStorage.getItem('codigoV') + '&reintento=1';
    console.log(urlReintento);

    $.ajax({
        type: 'GET',
        data: {},
        url: urlSMS,
        beforeSend: function () {

        },
        success: function () {
            aviso('Mensaje enviado correctamente');
        },
        error: function () {
            aviso('Error al enviar mensaje. Vuelva a intentarlo');
        }
    })
}

////funcion para reenvio //
function reenviar2() {
    urlReintento = 'http://200.5.104.2/sms/testsend/send.php?cel=' + $('#nuevo_numero').val() + '&code=' + window.localStorage.getItem('codigoV') + '&reintento=1';
    console.log(urlReintento);

    $.ajax({
        type: 'GET',
        data: {},
        url: urlSMS,
        beforeSend: function () {

        },
        success: function () {
            aviso('Mensaje enviado correctamente');
        },
        error: function () {
            aviso('Error al enviar mensaje. Vuelva a intentarlo');
        }
    })
}

//verificar el codigo
function verificar() {
    var codeV = $('#codigoV').val();
    var code_oculto = $('#codigo_oculto').val();
    var hashV = $('#hashV').val();

    $.ajax({
        type: 'POST',
        url: urlServer + '/usuarios_app/consulta_code',
        data: 'code=' + codeV + '&hash=' + hashV,

        success: function (m) {
            var e = eval('(' + m + ')');

            console.log('------------->');
            console.log('M result: ' + m);
            console.log('E result: ' + e);
            console.log('E.result =' + e.result);
            console.log('------------->');

            switch (e.result) {
                //codigo invalido
                case '0':
                    aviso('Codigo Invalido');
                    break;

                //avisar de un registro correcto
                case '1':
                    //avisar
                    aviso('Registro completado correctamente');

                    //cerrar el menu
                    cerrarSecundario();

                    //borrar el cookie de registrado
                    window.localStorage.removeItem('registrado');
                    //window.localStorage.removeItem('celV');
                    //window.localStorage.removeItem('hashV');
                    //window.localStorage.removeItem('codigoV');
                    break;

                //arreglo del error
                case '2':
                    aviso('Su registro ya se completo');

                    //borrar el storage
                    window.localStorage.removeItem('registrado');

                    //cerrar la ventana
                    cerrarSecundario();
                    break;
            }


        },
        error: function () {
            alert('Error al enviar');
        }
    })
}

//botones
function botones() {
    $('button, .boton, .boton-linea').on('touchstart', function (e) {
        $(e.currentTarget).addClass('boton-activo');
    });


    $('button, .boton, .boton-linea').on('touchend', function (e) {
        $(e.currentTarget).removeClass('boton-activo');
    })
}

//botones del menu (SAMSUNG)
function botonesMenu() {
    $('.button').on('touchstart', function (e) {
        $(e.currentTarget).addClass('button-active');
    });

    $('.button').on('touchend', function (e) {
        $(e.currentTarget).removeClass('button-active');
    })
}


//loguearse en la app
function loginApp() {
    var mail = $('#mail').val();
    var pass = $('#pass').val();
    var urlLogin = urlServer + '/usuarios_app/validate_bis';

    $.ajax({
        url: urlLogin,
        method: 'POST',
        data: {
            mail: mail,
            pass: pass
        },

        beforeSend: function () {
            enviando();
        },

        success: function (data) {
            var e = eval('(' + data + ')');
            console.log(e);

            cargandoRemove();
            console.log('Login: ' + data);

            if (e.result == 1) {
                //login ok
                window.localStorage.setItem('login', '1');
                //nombre y apellido
                window.localStorage.setItem('nombreUser', e.nombre);
                window.localStorage.setItem('apellidoUser', e.apellido);

                //remover el registrado
                window.localStorage.removeItem('registrado');

                //mostrar el menu
                $('#name').show();

                //avisa que entro
                aviso('Bienvenido ' + window.localStorage.getItem('nombreUser') + ' ' + window.localStorage.getItem('apellidoUser'));

                //cerrar la ventana
                setTimeout(function () {
                    cerrarSecundario();
                }, 800)

            } else {
                aviso('Datos de acceso incorrecto')
            }
        }
    })
}

//modificar datos
function modificar() {
    window.localStorage.removeItem('registrado');
    $('#confirm').hide();
    $('#registroV').show();
}

///cerrar la sesión
function logout() {
    window.localStorage.removeItem('login');
    window.localStorage.removeItem('nombreUser');
    window.localStorage.removeItem('apellidoUser');
    $('#name').hide();
}

//guardar el numero de tarjeta
function guardarTarjeta() {
    var numeroT = $('#numero').val();
    //ver la cantidad guardad

    //verificar que no ponga vacio
    if (numeroT == '') {
        aviso('Ingrese un numero de tarjeta');

    } else {
        //verificar la cantidad
        if (numeroT.length < 7) {
            aviso('ingrese todos los dígitos de la tarjeta');

        } else {
            //si pone bien
            var count = 0;
            for (i = 0; i < localStorage.length; i++) {
                //si existe sumo
                if (localStorage.getItem("tarjeta-" + i) != null) {
                    //verificar si el numero exite
                    if (localStorage.getItem("tarjeta-" + i) == numeroT) {
                        aviso('Este numero de tarjeta ya se encuentra guardado');
                        return false;
                    } else {
                        //añado
                        count++;
                    }
                    //console.log(i);
                }
            }
            console.log('Cantidad: ' + count);

            //sumar 1 a la cantidad
            var n = (count + 1);
            var nombreStorage = 'tarjeta-' + n;

            //crear el storage
            window.localStorage.setItem(nombreStorage, numeroT);
            aviso('Número de tarjeta guardado');

            setTimeout(function(){
                verNumeros();;
            },1000)
        }
    }


}

//asignar el valor al campos
function asignar(numero) {
    $('#numero').val('').val(numero);
    $('#numeros-cargados').hide();
    $('#guardado').show();
}

//borrar el numero de tarjeta
function borrarNumero(item) {
    window.localStorage.removeItem(item);
    $('#' + item).remove();
    $('#B-' + item).remove();
}

//ver los numeros de tarjeta
function verNumeros() {
    var count = 0;
    var content = '';
    var item;
    var nombreItem;

    for (i = 0; i < localStorage.length; i++) {
        if (localStorage.getItem("tarjeta-" + i) != null) {
            nombreItem = "tarjeta-" + i;
            item = window.localStorage.getItem("tarjeta-" + i);
            console.log("tarjeta-" + i + '-->' + item);

            content += '<button id="' + nombreItem + '" type="button" class="numero-tarjeta" onclick="asignar(' + item + ')"><i class="fa fa-asterisk"></i> Tarjeta ' + item + '</button>' +
            '<button id="B-' + nombreItem + '" type="button" class="borrar-numero" onclick="borrarNumero(\'' + nombreItem + '\')"><i class="fa fa-trash"></i></button>' +
            '<div class="clear"></div>';

            count++;
        }
    }

    if (count == 0) {
        aviso('No tiene numeros cargados')
    } else {
        //mostrar
        //$('#guardado').hide();

        //mostrar
        $('#numeros-cargados').show();

        //poner los botones
        $('#numeros-cargados').html(content + '<button type="button" onclick="cerrate(\'#numeros-cargados\')"><i class="fa fa-close"></i>Cerrar</button>');
    }
}

function parq() {
    setTimeout(function () {
        cerrarSecundario();
        cerrarSubs();
    }, 1500)
}

