var api = (function () {

    var tokenStore = window.localStorage;

    function getStorage() {
        return tokenStore;
    }

    function getToken() {
        if (!tokenStore["user.token"]) {
            return null;
        }

        return tokenStore["user.token"];
    }

    function getUserData() {
        if (!tokenStore["user.data"]) {
            return null;
        }

        return $.parseJSON(tokenStore["user.data"]);
    }

    function authenticate(token, data) {
        tokenStore["user.token"] = token;
        tokenStore["user.data"] = JSON.stringify(data);
    }

    function isAuthenticated() {
        return tokenStore["user.token"] != null;
    }

    function logout() {
        tokenStore.clear();
    }

    return {
        isAuthenticated: isAuthenticated,
        authenticate: authenticate,
        getStorage: getStorage,
        logout: logout,
        getUserData: getUserData,
        getToken: getToken
    }
}())