$.ajaxSetup({
    xhr: function () {
        return new window.XMLHttpRequest({
            mozSystem: true
        });
    }
});

var app = {

    /**
     * Screen transition effect, whenever Jquery mobile are used
     * See http://demos.jquerymobile.com/1.2.0/docs/pages/page-transitions.html
     */
    DEFAULT_TRANSITION_TYPE: "slide",

    /**
     * On the main view, how much pages the we show to the user to slide between
     */
    TOTAL_START_PAGES: 3,

    BARDDO_BASE_URL: "http://barddo.com",

    /**
     * Default app constructor
     */
    initialize: function () {
        console.log(">>> Initializing app");

        // Jquery Mobile Configuration
        $.mobile.pageContainer = $('#app');

        // Setting default page transition to slide
        $.mobile.defaultPageTransition = this.DEFAULT_TRANSITION_TYPE;

        this.bindEvents();
        this.setUp();
        this.initFastClick();
    },

    bindEvents: function () {
        console.log(">>> Binding events!");

        if (platform.isWeb) {
            $(document).ready(this.onDeviceReady);
        } else {
            document.addEventListener('deviceready', this.onDeviceReady, false);
        }

        $(window).on('orientationchange', doOnOrientationChange);
        $(window).on('resize', doOnResize);

        $(document).on("pageinit", "#work-detail-page", function (event) {
            $("#work-detail").html(Handlebars.templates.loading({}));
        });

        $(document).delegate("#work-detail-page", "pageshow", function () {
            var work_id = $.url().param("id");
            if (work_id) {
                loadWorkDetail(api.getToken(), work_id);
            }
        });
    },

    setUp: function () {
        doOnOrientationChange();

        /**
         * Custom home screen smooth swipe manager
         * @type {Swiper}
         */
        window.swiper = new Swiper('.swiper-container', {
            moveStartThreshold: 10,
            initialSlide: 1,
            touchRatio: 1.4,
            grabCursor: false,
            shortSwipes: false,
            cssWidthAndHeight: true,
            resistance: "100%"

            /*,

             onTouchStart: function () {
             if (window.swiper.activeIndex != 1) {
             return;
             }

             if ($("#footer").is(':visible')) {
             $("#footer").slideUp();
             }
             },

             onTouchEnd: function () {
             if (window.swiper.activeIndex != 1) {
             return;
             }

             if ($("#footer").is(':visible')) {
             return;
             }

             $("#footer").slideDown();
             }*/
        })

        /**
         * Navigation buttons
         */
        $(".slide-to-right").on("tap", function (e) {
            window.swiper.swipeNext();
            e.stopPropagation();
            e.preventDefault();

        });

        $(".slide-to-left").on("tap", function (e) {
            window.swiper.swipePrev();
            e.stopPropagation();
            e.preventDefault();
        });
    },

    /**
     * Remove touch delay introduced by JQM
     */
    initFastClick: function () {
        window.addEventListener('load', function () {
            FastClick.attach(document.body);
        }, false);
    },

    /**
     * Main code after devide ready event
     */
    onDeviceReady: function () {
        console.log(">>> Device ready!");

        //
        // Facebook authentication button setup
        //
        function loginFailed() {
            $("#loginPanel").show();
            $.mobile.loading("hide");
        }

        $("#loginWithFacebookButton").on("click", function () {
            console.log("Trying facebook login...");

            $("#loginPanel").hide();

            $.mobile.loading("show", {
                text: 'Please Wait...',
                textVisible: true,
                theme: 'c',
                html: ""
            });

            facebook_login(
                function (fb_token) {
                    var barddoUrl = app.BARDDO_BASE_URL + "/api/token/register/facebook/?access_token=" + fb_token;
                    $.get(barddoUrl, function (data) {

                        $.mobile.loading("hide");

                        if (data["status"] == "OK") {
                            api.authenticate(data["token"], data);

                            loadProfileData(data["token"], data);
                            $("#authenticatedPanel").show();
                        } else {
                            $("#loginPanel").show();
                            alert("Erro autenticando no barddo");
                        }
                    })
                        .fail(function () {
                            if (platform.isWeb()) {
                                alert("Sorry, but we couldn't authenticate you to the Barddo server!");
                                loginFailed();
                            } else {
                                navigator.notification.alert(
                                    'Oops! ;(',  // message
                                    loginFailed,         // callback
                                    "Sorry, but we couldn't authenticate you to the Barddo server!",            // title
                                    'Okay!'                  // buttonName
                                );
                            }
                        });
                },

                function (error) {
                    if (platform.isWeb()) {
                        alert("Sorry, but we couldn't authenticate you to the Facebook server!");
                        loginFailed();
                    } else {
                        navigator.notification.alert(
                            'Oops! ;(',  // message
                            loginFailed,         // callback
                            "Sorry, but we couldn't authenticate you to the Facebook server!",            // title
                            'Okay!'                  // buttonName
                        );
                    }
                });
        });

        //
        // User logout button
        //
        $("#logoutButton, #logoutErrorButton").on("click", function () {
            api.logout();
            $("#loginPanel").show();
            $("#authenticatedPanel").hide();
        });

        bindWorkSearch();

        loadWorks(api.getToken(), api.getUserData());

        if (api.isAuthenticated()) {

            loadProfileData(api.getToken(), api.getUserData());

            $("#loginPanel").hide();
            $("#authenticatedPanel").show();
        }


    }
};


function loadWorkDetail(token, work_id) {
    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/work/' + work_id + '/?format=json',
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#work-detail").html("");

            var templateData = {
                'work_id': data['id'],
                'title': data['title'],
                'author': data['author'],
                'cover': data['cover'],
                'total_pages': data['pages_count'],
                'summary': data['summary'],
                'publish_date': data['publish_date']
            }

            $("#work-detail").append(Handlebars.templates.workDetail(templateData));

            // Force JQM to parse ajax loaded itens
            $("#work-detail").trigger("create");

            $("time").each(function () {
                var $this = $(this);
                var timeString = $this.attr("datetime");
                $this.text(moment(timeString).fromNow());
            });

        },

        error: function (jqXHR, textStatus, errorThrown) {
            alert('Error loading works: ' + errorThrown);
        },
        beforeSend: setHeader
    });

    function setHeader(xhr) {
        if (token != null) {
            xhr.setRequestHeader('Authorization', 'Token ' + token);
        }
    }
}

function bindWorkSearch() {
    //
    // Search textinput setup
    //
    console.log("Seting up search box");

    $("#searchAgain").on("click", function () {
        $(".searchError").hide();
        var query = $('#searchWorkInput').val();
        if (query.length > 0) {
            searchWork(query);
        }
    });

    $('#search-form').submit(function (e) {
        e.stopPropagation();
        e.preventDefault();
        var query = $('#searchWorkInput').val();
        if (query.length > 0) {
            searchWork(query);
        }
    });

    $('#searchWorkInput').on("keyup", function () {
        delay(function () {
            var query = $('#searchWorkInput').val();
            if (query.length > 2) {
                searchWork(query);
            }
        }, 1000);
    });
}

function searchWork(query) {
    $.mobile.loading("show", {
        text: 'Searching...',
        textVisible: true,
        theme: 'c',
        html: ""
    });

    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/search-work/?format=json&q=' + query,
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#work-search-result-panel").html("");

            data.forEach(function (item) {
                var templateData = {
                    'work_id': item['id'],
                    'title': item['title'],
                    'author': item['author'],
                    'cover': item['cover']
                }

                $("#work-search-result-panel").append(Handlebars.templates.searchItem(templateData));
            });

            $.mobile.loading("hide");

            $("#search-page .fit").fitText(1.2, { minFontSize: '10px', maxFontSize: '35px' });
        },

        error: function (jqXHR, textStatus, errorThrown) {
            $.mobile.loading("hide");
            $(".searchError").show();
        }
    });
}

/**
 * Load every work on main page
 * @param token user api access token
 * @param data custom data to be used on request
 */
function loadWorks(token, data) {
    console.log(">>> Loading front page works");
    $(".tab-trend").html(Handlebars.templates.loading({}));
    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/works/?format=json',
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#trending-works").html("");
            $("#new-works").html("");
            $("#rising-works").html("");

            data['trending'].forEach(function (item) {
                var templateData = {
                    'work_id': item['id'],
                    'title': item['title'],
                    'author': item['author'],
                    'cover': item['cover'],
                    'liked': (item['liked'] ? "voted" : "")
                }

                $("#trending-works").append(Handlebars.templates.workItem(templateData));
            });

            // Fix
            var normalHeight = 0;
            setTimeout(function () {
                normalHeight = $("#rising-works .card-wrapper:first").height();
                $("#rising-works .card-wrapper").css('min-height', (normalHeight + 2) + 'px');
            }, 1000);

            data['rising'].forEach(function (item) {
                var templateData = {
                    'work_id': item['id'],
                    'title': item['title'],
                    'author': item['author'],
                    'cover': item['cover'],
                    'liked': (item['liked'] ? "voted" : "")
                }

                $("#rising-works").append(Handlebars.templates.workItem(templateData));
            });

            // Fix
            setTimeout(function () {
                normalHeight = $("#rising-works .card-wrapper:first").height();
                $("#rising-works .card-wrapper").css('min-height', (normalHeight + 2) + 'px');
            }, 1000);

            data['new'].forEach(function (item) {
                var templateData = {
                    'work_id': item['id'],
                    'title': item['title'],
                    'author': item['author'],
                    'cover': item['cover'],
                    'liked': (item['liked'] ? "voted" : "")
                }

                $("#new-works").append(Handlebars.templates.workItem(templateData));
            });

            // Fix
            setTimeout(function () {
                var normalHeight = $("#trending-works .card-wrapper:first").height();
                $("#trending-works .card-wrapper").css('min-height', (normalHeight + 2) + 'px');
            }, 1000);

            $(".fit").fitText(1.2, { minFontSize: '12px', maxFontSize: '35px' });
        },

        error: function (jqXHR, textStatus, errorThrown) {
            $("#trending-works").html(Handlebars.templates.indexError({})).trigger("create");
            $("#new-works").html(Handlebars.templates.indexError({})).trigger("create");
            $("#rising-works").html(Handlebars.templates.indexError({})).trigger("create");
        },

        beforeSend: setHeader
    });

    function setHeader(xhr) {
        if (token != null) {
            xhr.setRequestHeader('Authorization', 'Token ' + token);
        }
    }
}

function loadProfileData(token, data) {
    // Basic Fields
    $("#profile_avatar").attr("src", data["avatar"]);
    $("#profile_name").text(data["name"]);
    $("#profile_email").text(data["email"]);

    // Try to update fields
    $("#notifications").html(Handlebars.templates.loading({}));
    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/feed/?format=json',
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#notifications").html("");

            data.forEach(function (item) {
                var templateData = {
                    'avatar': item['picture'],
                    'created': item['created'],
                    'message': item['message']
                }

                $("#notifications").append(Handlebars.templates.profileFeed(templateData));
            });

            $("time").each(function () {
                var $this = $(this);
                var timeString = $this.attr("datetime");
                $this.text(moment(timeString).fromNow());
            });
        },

        error: function (error) {
            $(".profile-hide").hide();
            $(".profileError").show();
        },
        beforeSend: setHeader
    });

    $("#friends").html(Handlebars.templates.loading({}));
    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/friends/?format=json',
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#friends").html("");

            data.forEach(function (item) {
                var templateData = {
                    'user_id': item['id'],
                    'name': item['name'],
                    'avatar': item['picture']
                }

                $("#friends").append(Handlebars.templates.profileFriends(templateData));
            });
        },

        error: function (error) {
            $(".profile-hide").hide();
            $(".profileError").show();
        },

        beforeSend: setHeader
    });

    $("#favorites").html(Handlebars.templates.loading({}));
    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/favorites/?format=json',
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#favorites").html("");

            data.forEach(function (item) {
                var templateData = {
                    'work_id': item['id'],
                    'title': item['title'],
                    'author': item['author'],
                    'cover': item['cover']
                }

                $("#favorites").append(Handlebars.templates.profileWorks(templateData));
            });
        },

        error: function (error) {
            $(".profile-hide").hide();
            $(".profileError").show();
        },
        beforeSend: setHeader
    });

    function setHeader(xhr) {
        xhr.setRequestHeader('Authorization', 'Token ' + token);
    }

}

/**
 * Since we are using a custom way to handle our base pages, we need to handle each
 * page width and height by hand to assert that they will render properly.
 *
 * This method must be called whenever screen coordinates change. ie: orientation change
 */
function updatePagesWidth() {
    // Pages Wrapper
    var $wrapper = $(".swiper-wrapper");
    $wrapper.width(window.innerWidth * app.TOTAL_START_PAGES);
    $wrapper.height(window.innerHeight).css("max-height", window.innerHeight + "px");

    // Pages
    var $pages = $(".swiper-slide");
    $pages.width(window.innerWidth);
    $pages.height(window.innerHeight).css("max-height", window.innerHeight + "px");

    // Fixed footer by hand, after we determine the main page height
    $("#footer").css("max-width", (window.innerWidth) + "px").css("left", window.innerWidth);
}

/***
 * Event listener called whenever there's a screen orientation change
 */
function doOnOrientationChange() {
    console.log(">>> Orientation change");
    updatePagesWidth();
}

/***
 * Event listener called whenever there's a screen size change
 */
function doOnResize() {
    updatePagesWidth();
}