var app = {

    /**
     * Screen transition effect, whenever Jquery mobile are used
     * See http://demos.jquerymobile.com/1.2.0/docs/pages/page-transitions.html
     */
    DEFAULT_TRANSITION_TYPE: "slide",

    BARDDO_BASE_URL: "http://barddo.com",

    /**
     * Default app constructor
     */
    initialize: function () {
        console.log(">>> Initializing app");

        // Jquery Mobile Configuration
        $.mobile.pageContainer = $('#app');

        // Setting default page transition to slide
        $.mobile.defaultPageTransition = this.DEFAULT_TRANSITION_TYPE;
        $.event.special.swipe.durationThreshold = 400;
        $.event.special.swipe.horizontalDistanceThreshold = 200;

        $("#back-to-index").on("click", onBackKeyDown);

        this.bindEvents();
        this.setUp();
        this.initFastClick();
    },

    bindEvents: function () {
        console.log(">>> Binding events!");

        if (platform.isWeb()) {
            $(document).ready(this.onDeviceReady);
        } else {
            document.addEventListener('deviceready', this.onDeviceReady, false);
        }

        $(window).on('orientationchange', doOnOrientationChange);
        $(window).on('resize', doOnResize);

        document.addEventListener("backbutton", onBackKeyDown, false);

        document.addEventListener('touchmove', function (e) {
            e.preventDefault();
        }, false);


    },

    setUp: function () {
        doOnOrientationChange();
    },

    /**
     * Remove touch delay introduced by JQM
     */
    initFastClick: function () {
        window.addEventListener('load', function () {
            FastClick.attach(document.body);
        }, false);
    },

    /**
     * Main code after devide ready event
     */
    onDeviceReady: function () {
        console.log(">>> Device ready!");

        //  put class="doubleTap" on the elements you need to double tap
        $(".content").on("tap", function () {
            $(".ui-header, .ui-footer").slideToggle();
        });

        $('.toolbar-prev').on('click', function (e) {
            swiper.swipePrev();
            //e.preventDefault();
            e.stopPropagation();
        });

        $('.toolbar-next').on('click', function (e) {
            swiper.swipeNext();
            //e.preventDefault();
            e.stopPropagation();
        });

        setTimeout(function () {
            $(".ui-header, .ui-footer").slideToggle();
        }, 500);

        var work_id = $.url().param("id");
        var total_pages = $.url().param("pages");
        if (work_id) {
            loadWorkPages(api.getToken(), work_id, total_pages);
        }
    }
};


(function ($) {
    $.fn.doubleTap = function (doubleTapCallback) {
        return this.each(function () {
            var elm = this;
            var lastTap = 0;
            $(elm).bind('vmousedown', function (e) {
                var now = (new Date()).valueOf();
                var diff = (now - lastTap);
                lastTap = now;
                if (diff < 250) {
                    if ($.isFunction(doubleTapCallback)) {
                        doubleTapCallback.call(elm);
                    }
                }
            });
        });
    }
})(jQuery);

function onBackKeyDown() {
    window.location.href = "index.html";
}

var swiper = undefined;

var scroller = undefined;

var _enableZoom = (function () {

    var lastSlide = undefined;

    return function (swiper) {
        // Destroy old scroller manager, if any
        if (scroller !== undefined) {
            $(scroller.wrapper).unbind('touchend');
            scroller.destroy();
        }

        lastSlide = swiper.activeSlide();

        scroller = new IScroll(lastSlide, {
            freeScroll: true,
            scrollY: true,
            scrollX: true,
            bounce: false,

            hideScrollbar: true,
            zoom: true,
            mouseWheel: true,
            wheelAction: 'zoom',
            zoomMax: 3,
            zoomMin: 1,
            zoomStart: 1
        });

        // So Swiper will not swipe/slide when zooming is enabled
        scroller.on("zoomEnd", function () {
            var slide = $(this.wrapper);

            if (this.scale == 1) { // On minimal scroll, there's no need to avoid swipe
                slide.removeClass('swiper-no-swiping');
            } else if (!slide.hasClass('swiper-no-swiping')) {
                slide.addClass('swiper-no-swiping');
            }
        });


        // Since the images are inside of the swiper slide it
        // got a huge left offset, but the offset isn't really
        // part of the page/image since the page is completely
        // shown within the viewable area of the viewport. So
        // simply remove the wrapperOffsetLeft from the
        // calculation and be happy.
        //
        // touchstart: When pinch-zooming
        // touchend: When double-tap zooming
        scroller.on("zoomStart", function (e) {
            if (e.type === 'touchstart') {
                this.originX = Math.abs(e.touches[0].pageX + e.touches[1].pageX) / 2 - this.x;
            } else if (e.type === 'touchend') {
                this.wrapperOffset.left = 0;
            }
        });

        scroller.on("horizontalBounce", function () {
            var slide = $(this.wrapper);

            if (this.horizontalBounceDelta >= 13) {
                slide.removeClass('swiper-no-swiping');
                swiper.swipePrev();
            } else if (this.horizontalBounceDelta <= -13) {
                slide.removeClass('swiper-no-swiping');
                swiper.swipeNext();
            }
        });

        $(scroller.wrapper).bind('touchend', function (event) {

        });

        $(scroller.wrapper).bind('touchmove', function (event) {
        });


    };
})();


function loadWorkPages(token, work_id, total_pages) {
    $(".swiper-container").width(window.innerWidth).height(window.innerHeight);
    $(".swiper-wrapper").width(window.innerWidth).height(window.innerHeight);


    $.ajax({
        url: app.BARDDO_BASE_URL + '/api/work/' + work_id + '/?format=json',
        type: 'GET',
        dataType: 'json',

        success: function (data) {
            $("#pages-container").html("");

            for (var x = 0; x < total_pages; x++) {
                var templateData = {
                    'url': app.BARDDO_BASE_URL + '/api/work/' + work_id + '/page/' + x + '/',
                    'page': x
                }

                Handlebars.templates.workPage(templateData)
                $("#pages-container").append(Handlebars.templates.workPage(templateData));
            }

            // Once loaded, dispatch swiper events
            swiper = new Swiper('.swiper-container', {
                calculateHeight: true,
                cssWidthAndHeight: false,
                noSwiping: true, // So swiping can be disabled with a class
                onSlideChangeEnd: _enableZoom,
                onFirstInit: _enableZoom,
                followFinger: false,
                onSlideChangeStart: function (s) {
                    if (scroller) {
                        scroller.zoom(1, 0, 0, 200);
                    }
                }
            });

            updatePagesWidth();
        },

        error: function (jqXHR, textStatus, errorThrown) {
            alert('Error loading works: ' + errorThrown);
        },

        beforeSend: setHeader
    });

    function setHeader(xhr) {
        if (token != null) {
            xhr.setRequestHeader('Authorization', 'Token ' + token);
        }
    }
}

/**
 * Since we are using a custom way to handle our base pages, we need to handle each
 * page width and height by hand to assert that they will render properly.
 *
 * This method must be called whenever screen coordinates change. ie: orientation change
 */
function updatePagesWidth() {
    $(".swiper-container").width(window.innerWidth).height(window.innerHeight);
    $(".swiper-wrapper").width(window.innerWidth).height(window.innerHeight);

    $(".swiper-slide").css("max-height", window.innerHeight).height(window.innerHeight);


    window.swiper.resizeFix();
    _enableZoom(window.swiper);
}

/***
 * Event listener called whenever there's a screen orientation change
 */
function doOnOrientationChange() {
    console.log(">>> Orientation change");
    updatePagesWidth();
}

/***
 * Event listener called whenever there's a screen size change
 */
function doOnResize() {
    updatePagesWidth();
}