$.templates("feedItemTemplate", '<div class="feed-item">\
    <div class="user-avatar">\
        {{:avatar}}\
    </div>\
    <div class="detail">\
        <div class="message">{{:message}}</div>\
            <div class="time">\
                <span class="ui-icon ui-icon-flat-time ui-icon-shadow">&nbsp;</span>\
                <time datetime="{{:created}}" pubdate>{{:created}}</time>\
            </div>\
        </div>\
    </div>\
</div>');

$.templates("friendsItemTemplate", '<div class="friend-item">\
    <a href="{{:user_id}}">\
        <div class="user-avatar">\
            <img src="{{:avatar}}" alt="Friend Avatar">\
        </div>\
        <div class="name">{{:name}}</div>\
    </a>\
</div>');

$.templates("favoritesItemTemplate", '<div class="favorite-item">\
    <div class="card-wrapper">\
        <a href="work_detail.html?id={{:work_id}}" data-transition="none">\
            <div class="work-card">\
                <img src="{{:cover}}"/>\
                <div class="card-info">\
                    <p class="title fit">{{:title}}</p>\
                    <p class="author">\
                        <i class="ui-icon ui-icon-flat-man"></i>\
                        {{:author}}\
                    </p>\
                </div>\
            </div>\
        </a>\
    </div>\
</div>');

$.templates("workItemTemplate", '<div class="card-wrapper">\
    <a href="work_detail.html?id={{:work_id}}" data-transition="none">\
        <div class="work-card">\
            <img src="{{:cover}}"/>\
            <div class="card-info">\
                <p class="title fit">{{:title}}</p>\
                <p class="author">\
                    <i class="ui-icon ui-icon-flat-man"></i>\
                    {{:author}}\
                </p>\
            </div>\
            <div class="card-votes">\
                <i class="ui-icon ui-icon-flat-heart {{:liked}}"></i>\
            </div>\
        </div>\
    </a>\
</div>');

$.templates("workSearchItemTemplate", '<div class="card-wrapper">\
    <a href="work_detail.html?id={{:work_id}}" data-transition="none">\
        <div class="work-card">\
            <img src="{{:cover}}"/>\
            <div class="card-info">\
                <p class="title fit">{{:title}}</p>\
                <p class="author">\
                    <i class="ui-icon ui-icon-flat-man"></i>\
                    {{:author}}\
                </p>\
            </div>\
        </div>\
    </a>\
</div>');

$.templates("loadingTemplate", '<div class="loading-panel">\
    <img src="img/loader-big.gif" />\
</div>');

$.templates("workDetailTemplate", '<div class="work-cover">\
    <a href="reader.html?id={{:work_id}}&pages={{:total_pages}}" rel="external">\
        <div class="overlay">\
            <div class="details">\
                <div class="title">{{:title}}</div>\
                <div class="author"><span class="ui-icon ui-icon-flat-man">&nbsp;</span>&nbsp;{{:author}}</div>\
                <div class="publish">\
                    <span class="ui-icon ui-icon-flat-time ui-icon-shadow">&nbsp;</span>&nbsp;\
                    <time datetime="{{:publish_date}}">{{:publish_date}}</time>\
                </div>\
            </div>\
            <div class="tip">\
                Touch to read\
            </div>\
        </div>\
        <img src="{{:cover}}"/>\
    </a>\
</div>\
<div class="detail-table">\
    <div class="line">\
        <div class="label">\
            Summary:\
        </div>\
        <div class="data">\
            {{:summary}}\
        </div>\
    </div>\
</div>\
<fieldset class="ui-grid-a detail-buttons">\
    <div class="ui-block-a left">\
        <button data-icon="flat-heart" data-theme="f">Like</button>\
    </div>\
    <div class="ui-block-b right">\
        <button data-icon="fa-share-square flat" data-theme="b">Share</button>\
    </div>\
</fieldset>');