var App = Stapes.subclass({
	constructor: function() {
		var self = this;
		this.sectionMain  = new MainSection(this);
		this.sectionEdit = new EditSection(this);

		this.on('change:edit', function(edit) {
			if (edit) {
				self.sectionEdit.el.style.display = 'block';
				self.sectionMain.el.style.display = 'none';
				self.sectionEdit.render();
			} else {
				self.sectionEdit.el.style.display = 'none';
				self.sectionMain.el.style.display = 'block';
				self.sectionMain.load();
				self.sectionMain.render();
			}
		});
		this.set('edit', false);
	}
});

var MainSection = Stapes.subclass({
	constructor: function(app) {
		var self = this;
		this.app = app;
		this.el = document.querySelector('#view-main');
		this.header = this.el.querySelector('header');
		this.article = this.el.querySelector('article');

		this.on('change', this.render, this);
		$(this.el.querySelector('.btn-edit')).on('touchstart', function() {
			var colors = self.map(function(bar) {
				return bar.get('color');
			});
			app.set('colors', colors);
			app.set('edit', true);
		});
		$(this.el.querySelector('.btn-add')).on('touchstart', function() {
			self.addBar();
		});
		this.addBar();
	},
	load: function() {
		var colors = this.app.get('colors');
		this.remove(function() { return true; });
		var bars = []
		for (var i in colors) {
			var c = colors[i];
			var bar = new ColorBar(this, c);
			bars.push(bar);
		}
		this.push(bars);
	},
	render: function() {
		var height = this.el.clientHeight - this.header.clientHeight;
		var size = this.size();
		var itemHeight;
		if (this.editing && size > 1) {
			itemHeight = height / 2 / (this.size() - 1);
		} else {
			itemHeight = height / this.size();
		}
		this.article.innerHTML = '';
		this.each(function(c) {
			if (c.editing && size > 1) {
				this.article.appendChild(c.render(height/2));
			} else {
				this.article.appendChild(c.render(itemHeight));
			}
		}, this);
	},
	addBar: function() {
		this.push(new ColorBar(this, 'cccccc'));
	}
});

var EditSection = Stapes.subclass({
	constructor: function(app) {
		var self = this;
		this.app = app;
		this.el = document.querySelector('#view-edit');
		$(this.el.querySelector('.btn-done')).on('touchstart', function() {
			var colors = self.map(function(bar) {
				return bar.get('color');
			});
			app.set('colors', colors);
			app.set('edit', false);
		});
		$(this.el.querySelector('.btn-close')).on('touchstart', function() {
			app.set('edit', false);
		});
		this.app.on('change:edit', function(edit) {
			if (edit) {
				self.load();
			}
		});
		this.on('change', this.render, this);
	},
	load: function() {
		var colors = this.app.get('colors');
		this.remove(function() { return true; });
		var bars = []
		for (var i in colors) {
			var c = colors[i];
			var bar = new EditableColorBar(this, c);
			bars.push(bar);
		}
		this.push(bars);
	},
	render: function() {
		this.header = this.el.querySelector('header');
		this.article = this.el.querySelector('article');
		var height = this.el.clientHeight - this.header.clientHeight;
		height = height / this.size();
		this.article.innerHTML = '';
		this.each(function(bar) {
			this.article.appendChild(bar.render(height));
		});
	}
});

var ColorBar = Stapes.subclass({
	constructor: function(scheme, c) {
		var self = this;
		this.el = document.createElement('div');
		this.el.setAttribute('class', 'bar');

		this.on('change', this.render, this);
		this.set({scheme: scheme, color: c});

		this.handleStart = this.handleStart.bind(this);
		this.handleMove = this.handleMove.bind(this);
		this.handleEnd = this.handleEnd.bind(this);

		$(this.el).on('touchstart', this.handleStart);
		$(this.el).on('touchend', this.handleEnd);
	},
	handleStart: function(e) {
		e.preventDefault();
		$(this.el).on('touchmove', this.handleMove);
		$(e.target).on('touchmove', this.handleMove);
		this.handleMove(e);
		this.editing = true;
		this.get('scheme').editing = true;
		this.get('scheme').render();
	},
	handleEnd: function(e) {
		e.preventDefault();
		$(e.target).off('touchmove', this.handleMove);
		$(this.el).off('touchmove', this.handleMove);
		this.editing = false;
		this.get('scheme').editing = false;
		this.get('scheme').render();
	},
	handleMove: function(e) {
		e.preventDefault();
		var x = (e.clientX || e.touches[0].pageX) - this.el.offsetLeft;
		var y = (e.clientY || e.touches[0].pageY) - this.el.offsetTop;
		var w = this.el.clientWidth;
		var h = this.el.clientHeight;
		var c = hsl2rgb(x / w * 360, 100, y/h*100);
		var rgb = (c.r*256*256 + c.g*256+c.b);
		var c = rgb.toString(16);
		var s = ("00000" + c).slice(-6);
		this.set('color', s);
	},
	render: function(h) {
		if (h) {
			this.el.style.lineHeight = h + 'px';
			this.el.style.height = h + 'px';
		}
		this.el.style.backgroundColor = '#' + this.get('color');
		this.el.innerHTML = '<div class="label">#' + this.get('color') + '</div>';
		$(this.el.querySelector('.label')).on('touchstart', this.handleStart);
		$(this.el.querySelector('.label')).on('touchend', this.handleEnd);
		return this.el;
	}
});

var EditableColorBar = Stapes.subclass({
	constructor: function(editor, c) {
		var self = this;
		this.editor = editor;
		this.set({color: c});
		this.el = document.createElement('div');
		this.el.setAttribute('class', 'bar');
	},
	render: function(h) {
		var self = this;
		if (h) {
			this.el.style.lineHeight = h + 'px';
			this.el.style.height = h + 'px';
		}
		this.el.style.backgroundColor = '#' + this.get('color');
		//this.el.textContent = '#' + this.get('color');
		this.el.innerHTML = '<button class="btn-remove">Delete</button>';
		$(this.el.querySelector('.btn-remove')).on('touchstart', function() {
			self.editor.remove(function(item) {
				return (item == self);
			});
		});
		return this.el;
	}
});

$(function() {
	var app = new App();
});
