const MAXFLOAT=Math.pow(2,255);
const MINFLOAT=Math.pow(2,-256);
const NLIN=24;
const RNDA=1103515245;
const RNDC=12345;
const RNDM=0x7fffffff;
const RNDMASK=0x3fffffff;
var mon=['JAN','FEB','MAR','APR','MAY','JUN',
	 'JUL','AUG','SEP','OCT','NOV','DEC'];
var prgname="FOO";
var user="000000";
var vars={};
var tabs={};
var tabdim={};
var funcs={};
var data=[];
var prg=[];
var txt='';
var lines=[''];
var cmd='';
var chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ=+*-^/",.()<> ';
var error;
var prompt=false;
var running=false;
var rand=123456;

function elm(id){
    return document.getElementById(id);
}

function keydown(e){
    var ch;
    if(!running){
	e=e||window.event;
	if(!e.ctrlKey){
	    if(13==e.keyCode) //nl
		submit();
	    else if(8==e.keyCode){ //bs
		if(cmd.length>0)
		    cmd=cmd.substr(0,cmd.length-1);
	    } else if('DeadCircumflex'==e.key)
		cmd+='^';
	    elm('cmd').innerHTML=cmd.replace(/</,'&lt;');
	}
    }
}//keydown

function keyinput(e){
    var ch;
    e=e||window.event;
    ch=elm('cinput').value.toUpperCase();
    if(running){
	if('S'==ch)
	    running=false;
	elm('cinput').value='';
    }else{
	if('0'<=ch && '9'>=ch)
	    cmd+=ch;
	else if(-1!=chars.search('\\'+ch))
	    cmd+=ch;
	elm('cmd').innerHTML=cmd.replace(/</,'&lt;');
	elm('cinput').value='';
    }
}//keyinput

function submit(){
    display(cmd);
    elm('cmd').innerHTML='';
    if(prompt)
	prompt(cmd);
    else{
	if(cmd.trimLeft().match(/^(LIS|STO|SAV|UNS|CAT|NEW|OLD|SCR|REN|HEL|BYE|GOO|EXP)/))
	    dtss(cmd);
	else if('RUN'==cmd){
	    prg=prg.sort(function(a,b)
			 {return parseInt(a[0][0])-parseInt(b[0][0])});
	    run();
	}else{
	    prepars(cmd);
	}
    }
    cmd='';
}//submit

function display(line,nl){
    var cursor='<span id="cmd"></span><span id="cursor">&#9608;</span>';
    var txt='';
    var ln=lines.length-1;
    line=line.replace(/</,'&lt;');
    if('undefined'==typeof nl) nl=true;
    if('>'==lines[ln][lines[ln].length-1])
	lines.push(line);
    else{
	if(75>lines[ln].length)
	    lines[ln]+=line;
	else{
	    lines[ln]+='<br>';
	    lines.push(line);
	}
    }
    ln=lines.length-1;
    if(80<lines[ln].length)
	lines[ln]=lines[ln].substr(0,80);
    if(nl)
	lines[ln]+='<br>';
    
    while(NLIN<lines.length)
	lines.shift();
    for(var i=0;i<lines.length;i++)
	txt+=lines[i];
    elm('output').innerHTML=txt.replace(/ /g,'&nbsp;')+cursor;
}//display


function expr(txt,lno){
    var i,j;
    var opstk=['0'];
    var oplist=[];
    var split;
    var toknxt=1; // operand=1, operator=2, paran=3
    var tmp;
    var aux;

    while(''!=txt){
	if(split=txt.match(/^(SIN|COS|TAN|ATN|EXP|ABS|LOG|SQR|INT|RND)/)){
	    if(1!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    opstk.unshift('fun',split[0]);
	    txt=txt.slice(3);
	    toknxt=3;
	}else if(split=txt.match(/^FN([A-Z])/)){
	    if(1!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    opstk.unshift('fun',split[1]);
	    txt=txt.slice(3);
	    toknxt=3;
	}else if(split=txt.match(/^([A-Z])\((.*)/)){ //[^),]+)\)/)){
	    if(1!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    tmp='';
	    aux=0;
	    for(i=0,j=0;i<split[2].length&&!(0==j&&')'==split[2][i]);i++){
		if('('==split[2][i]) j++;
		if(')'==split[2][i]) j--;
		if(','==split[2][i] && 0==j){
		    if(0!=aux){
			display('ILLEGAL FORMULA IN '+lno);
			return false;
		    }
		    if(!(aux=expr(tmp,lno)))
			return false;
		    oplist=oplist.concat(aux);
		    tmp='';
		    aux=1;
		}else
		    tmp+=split[2][i];
	    }
	    if(!(j=expr(tmp,lno)))
		return false;
	    oplist=oplist.concat(j);
	    if(!aux)
		oplist.push('list',split[1]);
	    else
	    oplist.push('tab',split[1]);
	    txt=txt.slice(split[1].length+i+2);
	    toknxt=2;
	}else if(split=txt.match(/^[A-Z][0-9]?/)){
	    if(1!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    oplist.push('var',split[0]);
	    txt=txt.slice(split[0].length);
	    toknxt=2;
	}else if(1==toknxt && '-'==txt[0]){
	    oplist.push('val','-1');
	    opstk.unshift('*');
	    txt=txt.slice(1);
	    if(''==txt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	}else if('+'==txt[0] || '-'==txt[0]){
	    if(2!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    while('*'==opstk[0]||'/'==opstk[0]||'^'==opstk[0]||
		  '+'==opstk[0]||'-'==opstk[0])
		oplist.push(opstk.shift());
	    opstk.unshift(txt[0]);
	    txt=txt.slice(1);
	    toknxt=1;
	}else if(split=txt.match(/^[-]?[0-9]*\.?[0-9]+(E[0-9]+)?/)){
	    if(1!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    if((-1==split[0].indexOf('.')&&-1==split[0].indexOf('E'))&&
	       9<split[0].replace('-','').length){
		display('ILLEGAL CONSTANT IN '+lno);
		return false;
	    }
	    oplist.push('val',split[0]);
	    txt=txt.slice(split[0].length);
	    toknxt=2;
	}else if('^'==txt[0]){
	    if(2!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    opstk.unshift(txt[0]);
	    txt=txt.slice(1);
	    toknxt=1;
	}else if('*'==txt[0] || '/'==txt[0]){
	    if(2!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    while(opstk[0]=='*'||opstk[0]=='/'||opstk[0]=='^')
		oplist.push(opstk.shift());
	    opstk.unshift(txt[0]);
	    txt=txt.slice(1);
	    toknxt=1;
	}else if('('==txt[0]){
	    if(1!=toknxt && 3!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    opstk.unshift('(');
	    txt=txt.slice(1);
	    toknxt=1;
	}else if(')'==txt[0]){
	    if(2!=toknxt){
		display('ILLEGAL FORMULA IN '+lno);
		return false;
	    }
	    while('('!=opstk[0]){
		if(opstk[0]=='0'){
		    display('ILLEGAL FORMULA '+lno);
		    return false;
		}
		oplist.push(opstk.shift());
	    }
	    opstk.shift();
	    if('fun'==opstk[0]){
		opstk.shift();
		oplist.push('fun', opstk.shift());
	    }
	    txt=txt.slice(1);
	    toknxt=2;
	}
    }
    while('0'!=opstk[0])
	oplist.push(opstk.shift());

    return oplist;
}//expr


function evaluate(list,lno){
    var stack=[];
    var i=0;
    var x,y,w;

    while(i<list.length){
	if('var'==list[i]){
	    i++;
	    if('undefined'==typeof vars[list[i]])
		vars[list[i]]=0;
	    stack.push(vars[list[i]]);
	}else if('val'==list[i]){
	    i++;
	    stack.push(parseFloat(list[i]));
	}else if('list'==list[i]){
	    i++;
	    w=list[i];
	    x=stack.pop();
	    if((tabdim[w]&&tabdim[w]<x)||(!tabdim[w]&&10<x)||1>x||
	       Math.round(x)!=x){
		display('SUBSCRIPT ERROR IN '+lno);
		return '!';
	    }
	    if(tabs[w]&&tabs[w][x])
		stack.push(tabs[w][x]);
	    else
		stack.push(0);
	}else if('tab'==list[i]){
	    i++;
	    w=list[i];
	    y=stack.pop();
	    x=stack.pop();
	    if((tabdim[w]&&tabdim[w][1]&&tabdim[w][0]<x)||
	       (tabdim[w]&&tabdim[w][1]&&tabdim[w][1]<y)||
	       (!tabdim[w]&&(10<x||10<y))||Math.round(x)!=x||Math.round(y)!=y){
		display('SUBSCRIPT ERROR IN '+lno);
		return '!';
	    }
	    if(tabs[w]&&tabs[w][x]&&tabs[w][x][y])
		stack.push(tabs[w][x][y]);
	    else
		stack.push(0);
	}else if('fun'==list[i]){
	    i++;
	    if('SIN'==list[i]){
		x=stack.pop();
		stack.push(Math.sin(x));
	    }else if('COS'==list[i]){
		x=stack.pop();
		stack.push(Math.cos(x));
	    }else if('TAN'==list[i]){
		x=stack.pop();
		stack.push(Math.tan(x));
	    }else if('ATN'==list[i]){
		x=stack.pop();
		stack.push(Math.atan(x));
	    }else if('EXP'==list[i]){
		x=stack.pop();
		stack.push(Math.exp(x));
	    }else if('ABS'==list[i]){
		x=stack.pop();
		stack.push(Math.abs(x));
	    }else if('LOG'==list[i]){
		x=stack.pop();
		if(0>x){
		    display('LOG OF A NEGATIVE NUMBER IN '+lno);
		    x=-x;
		}
		if(0==x){
		    display('LOG OF ZERO IN '+lno);
		    stack.push(-MAXFLOAT);
		}else
		    stack.push(Math.log(x));
	    }else if('SQR'==list[i]){
		x=stack.pop();
		if(0>x){
		    display('SQUARE ROOT OF A NEGATIVE NUMBER IN '+lno);
		    x=-x;
		}
		stack.push(Math.sqrt(x));
	    }else if('INT'==list[i]){
		x=stack.pop();
		if(0>x)
		    stack.push(Math.ceil(x));
		else
		    stack.push(Math.floor(x));
	    }else if('RND'==list[i]){
		stack.pop();
		rand=(rand*RNDA+RNDC)&RNDM;
		stack.push((rand&RNDMASK)*1.0/RNDMASK);
	    }else if('A'<=list[i] && 'Z'>=list[i]){
		if(!funcs[list[i]]){
		    display('UNDEFINED FUNCTION IN '+lno);
		    return '!';
		}
		vars['@']=stack.pop();
		if('!'==(x=evaluate(funcs[list[i]],lno)))
		    return '!';
		stack.push(x);
	    }else{
		display('ILLEGAL FORMULA IN '+lno);
		return '!';
	    }
	}else if('*'==list[i]){
	    x=stack.pop();
	    y=stack.pop();
	    x*=y;
	    if(Infinity==x||MAXFLOAT<x){
		display('OVERFLOW IN '+lno);
		stack.push(MAXFLOAT);
	    }else if(-Infinity==x||-MAXFLOAT>x){
		display('OVERFLOW IN '+lno);
		stack.push(MAXFLOAT);
	    }else if(MINFLOAT>x&&0<x){
		display('UNDERFLOW IN '+lno);
		stack.push(0);
	    }else if(-MINFLOAT<x&&0>x){
		display('UNDERFLOW IN '+lno);
		stack.push(0);
	    }else
		stack.push(x);
	}else if('/'==list[i]){
	    x=stack.pop();
	    y=stack.pop();
	    if(0==x){
		display('DIVISION BY ZERO IN '+lno);
		stack.push(MAXFLOAT);
	    }else{
		x=y/x;
		if(Infinity==x||MAXFLOAT<x){
		    display('OVERFLOW IN '+lno);
		    stack.push(MAXFLOAT);
		}else if(-Infinity==x||-MAXFLOAT>x){
		    display('OVERFLOW IN '+lno);
		    stack.push(MAXFLOAT);
		}else if(MINFLOAT>x&&0<x){
		    display('UNDERFLOW IN '+lno);
		    stack.push(0);
		}else if(-MINFLOAT<x&&0>x){
		    display('UNDERFLOW IN '+lno);
		    stack.push(0);
		}else
		    stack.push(x);
	    }
	}else if('+'==list[i]){
	    x=stack.pop();
	    y=stack.pop();
	    x+=y;
	    if(Infinity==x||MAXFLOAT<x){
		display('OVERFLOW IN '+lno);
		stack.push(MAXFLOAT);
	    }else if(-Infinity==x||-MAXFLOAT>x){
		display('OVERFLOW IN '+lno);
		stack.push(MAXFLOAT);
	    }else if(MINFLOAT>x&&0<x){
		display('UNDERFLOW IN '+lno);
		stack.push(0);
	    }else if(-MINFLOAT<x&&0>x){
		display('UNDERFLOW IN '+lno);
		stack.push(0);
	    }else
		stack.push(x);
	}else if('-'==list[i]){
	    x=stack.pop();
	    y=stack.pop();
	    x=y-x;
	    if(Infinity==x||MAXFLOAT<x){
		display('OVERFLOW IN '+lno);
		stack.push(MAXFLOAT);
	    }else if(-Infinity==x||-MAXFLOAT>x){
		display('OVERFLOW IN '+lno);
		stack.push(MAXFLOAT);
	    }else if(MINFLOAT>x&&0<x){
		display('UNDERFLOW IN '+lno);
		stack.push(0);
	    }else if(-MINFLOAT<x&&0>x){
		display('UNDERFLOW IN '+lno);
		stack.push(0);
	    }else
		stack.push(x);
	}else if('^'==list[i]){
	    x=stack.pop();
	    y=stack.pop();
	    if(0==y && 0>x){
		display('ZERO TO A NEGATIVE POWER IN '+lno);
		stack.push(MAXFLOAT);
	    }else{
		x=Math.pow(Math.abs(y),x);
		if(Infinity==x||MAXFLOAT<x){
		    display('OVERFLOW IN '+lno);
		    stack.push(MAXFLOAT);
		}else if(MINFLOAT>x&&0<x){
		    display('UNDERFLOW IN '+lno);
		    stack.push(0);
		}else
		    stack.push(x);
	    }
	}
	i++;
    }
    return stack.pop();
}//evaluate

function prepars(txt){
    var i;
    var no;
    var lnr=-1;
    var split=txt.replace(/ /g,'').match(/^([0-9]+)(.+)?/);
    if(!split){
	display('WHAT?');
	return false;
    }
    no=parseInt(split[1])
    if(!no || 1>no || 99999<no){
	display('ILLEGAL LINE NUMBER');
	return false;
    }
    for(i=0;i<prg.length;i++)
	if(prg[i][0][0]==no){
	    lnr=i;
	    break;
	}
    if(!split[2] && 0<=lnr)
	prg.splice(lnr,1);
    else if(0<=lnr)
	prg[lnr]=[[no,txt],split[2]];
    else
	prg.push([[no,txt],split[2]]);
    return true;
} // prepars


function pars(){
    var i,j;
    var lin=[];
    var split;
    var ilist,jlist;
    var lno;
    var tmp;

    for(i=0;i<prg.length;i++){
	lin=[];
	lno=prg[i][0][0];
	split=prg[i][1].match(/(LET|PRINT|END|READ|DATA|GOTO|IF|FOR|NEXT|GOSUB|RETURN|DEF|DIM|REM|STOP)?(.+)?/);

	if(!split){
	    display('ILLEGAL INSTRUCTION IN '+lno);
	    error=true;
	}
//IF
	else if('IF'==split[1]){
	    if(!split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    split=split[2].match(/(.+)(<|>|<>|<=|>=|=)(.+)THEN([0-9]+)/);
	    if(!split){
		display('ILLEGAL RELATION IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='if';
	    if(!(lin[1]=expr(split[1],lno)))
		error=true;
	    lin[2]=split[2];
	    if(!(lin[3]=expr(split[3],lno)))
		error=true;
	    lin[4]=parseInt(split[4]);
	    prg[i][2]=lin;
//LET
	}else if('LET'==split[1]){
	    if(!split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    split=split[2].match(/^([A-Z].*)=(.+)/);
	    if(!split){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='let';
	    if(split[1].match(/^[A-Z][0-9]?$/))
		lin[1]=['skal',split[1]];
	    else if(tmp=split[1].match(/^([A-Z])\(([^,]+)\)$/)){
		if(!(ilist=expr(tmp[2],lno))){
		    error=true;
		    continue;
		}
		lin[1]=['list',tmp[1],ilist];
	    }else if(tmp=split[1].match(/^([A-Z])\((.+),(.+)\)$/)){
		if(!(ilist=expr(tmp[2],lno))){
		    error=true;
		    continue;
		}
		if(!(jlist=expr(tmp[3],lno))){
		    error=true;
		    continue;
		}
		lin[1]=['tab',tmp[1],ilist,jlist];
	    }else{
		error=true;
		continue;
	    }
	    if(!(lin[2]=expr(split[2],lno))){
		error=true;
		continue;
	    }
	    prg[i][2]=lin;
//FOR
	}else if('FOR'==split[1]){
	    if(!split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    split=split[2].match(/(.+)=(.+)TO(.+)/);
	    if(!split || !split[3]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='for';
	    if(!split[1].match(/^[A-Z][0-9]?$/)){
		display('ILLEGAL VARIABLE IN '+prg[i][0][0]);
		error=true;
		continue;
	    }
	    lin[1]=split[1];
	    if(!(lin[2]=expr(split[2],lno))){
		error=true;
		continue;
	    }
	    lin[3]=split[3];
	    lin[4]=['val','1'];
	    if(split=split[3].match(/(.+)STEP(.+)/)){
		if(!(lin[3]=expr(split[1],lno))){
		    error=true;
		    continue;
		}
		if(!(lin[4]=expr(split[2],lno))){
		    error=true;
		    continue;
		}
	    }else
		if(!(lin[3]=expr(lin[3],lno))){
		    error=true;
		    continue;
		}
	    prg[i][2]=lin;
//NEXT
	}else if('NEXT'==split[1]){
	    if(!split[2]){
		display('ILLEGAL VARIABLE IN '+lno);
		error=true;
		continue;
	    }
	    if(!split[2].match(/^[A-Z][0-9]?$/)){
		display('ILLEGAL VARIABLE IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='next';
	    lin[1]=split[2];
	    prg[i][2]=lin;
//GOTO
	}else if('GOTO'==split[1]){
	    if(!split[2]){
		display('ILLEGAL NUMBER IN '+lno);
		error=true;
		continue;
	    }
	    if(!split[2].match(/^[0-9]+$/)){
		display('ILLEGAL NUMBER IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='goto';
	    lin[1]=parseInt(split[2]);
	    prg[i][2]=lin;
//PRINT
	}else if('PRINT'==split[1]){
	    split=prg[i][0][1].match(/([ 0-9]*P *R *I *N *T *)(.*)/);
	    if(!split[2])
		split[2]='';
	    split[2]=split[2].trimRight();
	    if(','==split[2][split[2].length-1])
		lin[0]='println';
	    else
		lin[0]='print';
	    split=split[2]; //[1];
	    while(split){
		split=split.match(/^([^"]*)("[^"]*")?(.*)/);
		if(split[0]==split[3]){
		    display('ILLEGAL FORMAT IN '+lno);
		    error=true;
		    break;
		}
		tmp=[split[1].replace(/ /g,''),0];
		for(j=0;j<tmp[0].length;j++){
		    if('('==tmp[0][j])
			tmp[1]++;
		    else if(')'==tmp[0][j])
			tmp[1]--;
		    else if(','==tmp[0][j]&&0==tmp[1]){
			tmp.push(tmp[0].substr(0,j));
			tmp[0]=tmp[0].substr(j+1);
			j=-1;
		    }
		}
		tmp.push(tmp[0]);
		tmp.shift();
		tmp.shift();
		for(j=0;j<tmp.length;j++){
		    if(''!=tmp[j]){
			if(!(ilist=expr(tmp[j],lno)))
			    error=true;
			lin.push(ilist);
		    }
		}
		if(split[2]){
		    lin.push(split[2]);
		    if(split[3] && ','!=split[3][0])
			lin.push('');
		}
		split=split[3];
	    }
	    prg[i][2]=lin;
//READ
	}else if('READ'==split[1]){
	    if(!split[2]){
		display('ILLEGAL VARIABLE IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='read';
	    split=split[2].split(',');
	    for(j=0;j<split.length;j++){
		if(!split[j].match(/^[A-Z][0-9]?$/)){
		    display('ILLEGAL VARIABLE IN '+lno);
		    error=true;
		    continue;
		}
	    }
	    lin[1]=split;
	    prg[i][2]=lin;
//DATA
	}else if('DATA'==split[1]){
	    if(!split[2]){
		split[2]='';
		continue;
	    }
	    lin[0]='data';
	    split=split[2].split(',');
	    lin[1]=split;
	    prg[i][2]=lin;
//REM
	}else if('REM'==split[1]){
	    lin[0]='rem';
	    prg[i][2]=lin;
//GOSUB
	}else if('GOSUB'==split[1]){
	    if(!split[2]){
		display('ILLEGAL NUMBER IN '+lno);
		error=true;
		continue;
	    }
	    if(!split[2].match(/^[0-9]+$/)){
		display('ILLEGAL NUMBER IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='gosub';
	    lin[1]=parseInt(split[2]);
	    prg[i][2]=lin;
//RETURN
	}else if('RETURN'==split[1]){
	    if(split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='return';
	    prg[i][2]=lin;
//DEF
	}else if('DEF'==split[1]){
	    if(!split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    split=split[2].match(/^FN([A-Z])\(([A-Z][0-9]?)\)=(.*)/);
	    if(!split){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]=split[1];
	    lin[1]=split[2];
	    if(!(ilist=expr(split[3],lno))){
		error=true;
		continue;
	    }
	    for(j=0;j<ilist.length;j++){
		if(ilist[j]==lin[1])
		    ilist[j]='@';
	    }
	    funcs[lin[0]]=ilist;
	    prg[i][2]=['def'];
//DIM
	}else if('DIM'==split[1]){
	    if(!split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    if(!(split=split[2].match(/^([A-Z])\(([0-9]+(,[0-9]+)?)\)$/))){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    tmp=split[1];
	    tabdim[tmp]=[];
	    split=split[2].split(',');
	    if(1!=split.length && 2!=split.length){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    for(j=0;j<split.length;j++){
		tabdim[tmp].push(split[j]); //ilist);
	    }
	    prg[i][2]=['dim'];
//END
	}else if('END'==split[1]){
	    if(split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='end';
	    prg[i][2]=lin;
//STOP
	}else if('STOP'==split[1]){
	    if(split[2]){
		display('INCORRECT FORMAT IN '+lno);
		error=true;
		continue;
	    }
	    lin[0]='stop';
	    prg[i][2]=lin;
	}else{
	    display('ILLEGAL INSTRUCTION IN '+lno);
	    error=true;
	}
    }
}//pars


function link(){
    var i,j,k;
    var end=false;

    read=0;
    data=[];
    for(i=0;i<prg.length;i++){
	if(!prg[i][2]);
	else if('goto'==prg[i][2][0]){
	    k=prg[i][2][1];
	    for(j=0;j<prg.length;j++)
		if(prg[j][0][0]==k)
		    break;
	    if(j==prg.length){
		display('UNDEFINED NUMBER');
		error=true;
	    }
	    prg[i][2][1]=j;
	}else if('if'==prg[i][2][0]){
	    k=prg[i][2][4];
	    for(j=0;j<prg.length;j++)
		if(prg[j][0][0]==k)
		    break;
	    if(j==prg.length){
		display('UNDEFINED NUMBER');
		error=true;
	    }
	    prg[i][2][4]=j;
	}else if('for'==prg[i][2][0]){
	    for(j=i+1;j<prg.length;j++)
		if(prg[j][2] && 'next'==prg[j][2][0]){
		    if(prg[i][2][1]==prg[j][2][1])
			break;
		}
	    if(prg.length==j){
		display('FOR WITHOUT NEXT');
		error=true;
	    }
	}else if('next'==prg[i][2][0]){
	    k=prg[i][2][1];
	    for(j=i-1;j>=0;j--)
		if(prg[j][2] && prg[j][2][1]==k)
		    break;
	    if(j<0){
		display('NOT MATCHED WITH FOR IN '+prg[i][0][0]);
		error=true;
	    }
	    prg[i][2][1]=j;
	}else if('end'==prg[i][2][0]){
	    if(i!=prg.length-1){
		display('END IS NOT LAST');
		error=true;
		end=true;
	    }
	}else if('data'==prg[i][2][0]){
	    for(j=0;j<prg[i][2][1].length;j++)
		data.push(parseFloat(prg[i][2][1][j]));
	}else if('read'==prg[i][2][0]){
	    read=1;
	}else if('gosub'==prg[i][2][0]){
	    k=prg[i][2][1];
	    for(j=0;j<prg.length;j++)
		if(prg[j][0][0]==k)
		    break;
	    if(j==prg.length){
		display('UNDEFINED NUMBER');
		error=true;
	    }
	    prg[i][2][1]=j;
	}
    }
    if(prg.length>0&&(prg[prg.length-1][2]&&'end'!=prg[prg.length-1][2][0])&&!end){
	display('NO END INSTRUCTION');
	error=true;
    }
    if(read && 0==data.length){
	display('NO DATA');
	error=true;
    }
}//link

var g;
var runint;

function runpace(){
    if(!g.next())
	clearInterval(runint);
}

function run(){
    g=intrun();
    runint=setInterval(runpace,20);
}

function intrun(){
    var i,j;
    var p;
    var didx=0;
    var txt;
    var num;
    var stack=[];
    var ilist;
    var x,y;
    var t0=new Date();
    var t1;
    var step=10;

    txt=''+t0.getMinutes();
    if(1==txt.length)
	txt='0'+txt;
    txt='USER NO. '+user+'   PROBLEM NAME: '+prgname+'    '+
	t0.getDate()+'. '+mon[t0.getMonth()]+' '+t0.getFullYear()+
	'    TIME: '+t0.getHours()+':'+txt;

    display('');
    display(txt);
    display('');
    error=false;
    vars={};
    tabs={};
    tabdim={};
    funcs={};
    data=[];
    pars();
    link();
    rand=0.5;
    running=true;
    if(!error){
	for(i=0;i<prg.length;i++){
	    step--;
	    if(!step){
		yield(true);
		step=10;
	    }
	    if(!running) break;
	    p=prg[i][2];
	    if('stop'==p[0])
		break;
	    else if('let'==p[0]){
		if('!'==(num=evaluate(p[2],prg[i][0][0])))
		    break;
		if('skal'==p[1][0]){
		    vars[p[1][1]]=num;
		}else if('list'==p[1][0]){
		    if('!'==(x=evaluate(p[1][2],prg[i][0][0])))
			break;
		    if((tabdim[p[1][1]]&&
			x>tabdim[p[1][1]])||
		       (!tabdim[p[1][1]]&&x>10||1>x)||Math.round(x)!=x){
			display('SUBSCRIPT ERROR IN '+prg[i][0][0]);
			break;
		    }
		    if(!tabs[p[1][1]])
			tabs[p[1][1]]=[];
		    tabs[p[1][1]][x]=num;
		}else if('tab'==p[1][0]){
		    if('!'==(x=evaluate(p[1][2],prg[i][0][0])))
			break;
		    if('!'==(y=evaluate(p[1][3],prg[i][0][0])))
			break;
		    if((tabdim[p[1][1][0]]&&
			x>tabdim[p[1][1][0]])||
		       (tabdim[p[1][1][1]]&&
			y>tabdim[p[1][1][1]])||x>10||y>10||1>x||1>y||
		       Math.round(x)!=x||Math.round(y)!=y){
			display('SUBSCRIPT ERROR IN '+prg[i][0][0]);
			break;
		    }
		    if(!tabs[p[1][1]]){
			tabs[p[1][1]]=[];
			tabs[p[1][1]][x]=[];
		    }
		    tabs[p[1][1]][x][y]=num;
		}
	    }else if('print'==p[0]||'println'==p[0]){
		txt='';
		for(j=1;j<p.length;j++){
		    if(60<txt.length){
			display(txt);
			txt='';
		    }
		    if(''!=p[j])
			while(txt.length%15) txt+=' ';
		    else
			j++;
		    if(p[j][0]=='"')
			txt+=p[j].replace(/"/g,'')+' ';
		    else{
			if('!'==(x=evaluate(p[j],prg[i][0][0])))
			    break;
			if(0.1>Math.abs(x)){
			    if(x.toFixed(6)==x)
				num=x+'';
			    else
				num=x.toExponential(5);
			}else if(x.toFixed(0)==x && 1e9>x){
			    num=x.toFixed(0);
			}else
			    num=x.toPrecision(6);
			if(0<num.indexOf('.')){
			    if(num==x)
				num=(num+'').replace(/^-0\./,'-\.').
				replace(/0*$/,'').replace(/\.$/,'').
				replace(/^0\./,'\.').replace(/0*e/,' E');
			    else
				num=(num+'').replace(/^-0\./,'-\.').
				replace(/0*$/,'').replace(/\.$/,'').
				replace(/^0\./,'\.').replace(/e/,' E');
			}
			if(''==num) num='0';
			txt+=num+' ';
		    }
		}
		if('print'==p[0])
		    display(txt);
		else{
		    while(txt.length%15) txt+=' ';
		    display(txt,false);
		}
	    }else if('goto'==p[0])
		i=p[1]-1;
	    else if('read'==p[0]){
		if(didx==data.length){
		    display('');
		    display('OUT OF DATA IN '+prg[i][0][0]);
		    break;
		}
		for(j=0;j<p[1].length;j++)
		    vars[p[1][j]]=data[didx++];
	    }else if('if'==p[0]){
		if('!'==(x=evaluate(p[1],prg[i][0][0])))
		    break;
		if('!'==(y=evaluate(p[3],prg[i][0][0])))
		    break;
		j=p[2];
		if(('<'==j && x<y)||('>'==j&&x>y)||('='==j&&x==y)||
		   ('<>'==j&&x!=y)||('<='==j&&x<=y)||('>='==j&&x>=y))
		    i=p[4]-1;
	    }else if('for'==p[0]){
		if('!'==(x=evaluate(p[2],prg[i][0][0])))
		    break;
		vars[p[1]]=x;
	    }else if('next'==p[0]){
		j=p[1];
		if('!'==(x=evaluate(prg[j][2][4],prg[j][0][0])))
		    break;
		if('!'==(y=evaluate(prg[j][2][3],prg[j][0][0])))
		    break;
		if((0<x&&vars[prg[j][2][1]]+x<=y)||
		   (0>x&&vars[prg[j][2][1]]+x>=y)){
		    vars[prg[j][2][1]]+=x;
		    i=j;
		}
	    }else if('gosub'==p[0]){
		stack.push(i);
		i=p[1]-1;
	    }else if('return'==p[0]){
		if(0==stack.length){
		    display('ILLEGAL RETURN');
		    break;
		}else
		    i=stack.pop();
	    }
	}
    }
    running=false;
    t1=new Date;
    x=Math.floor((t1.getTime()-t0.getTime())/1000);
    display('');
    display('');
    display('TIME: '+x+' SECS.');
    display('');
    yield(false);
}//run

function dtss_old(cmd){
    var txt;
    if(''!=cmd){
	txt=window.localStorage.getItem(cmd);
	if(null==txt){
	    display('PROGRAM NOT SAVED--'+cmd);
	}else{
	    prg=[];
	    prgname=cmd;
	    txt=txt.split('\n');
	    for(i=0;i<txt.length;i++)
		if(''!=txt[i]) prepars(txt[i]);
	}
	display('READY');
	display('');
	prompt=false;
    }else
	display('OLD PROBLEM NAME--',false);
}

function dtss_new(cmd){
    if(''!=cmd){
	prgname=cmd;
	prg=[];
	prompt=false;
	display('READY');
	display('');
    }else
	display('NEW PROBLEM NAME--',false);
}

function dtss_ren(cmd){
    if(''!=cmd){
	prgname=cmd;
	prompt=false;
	display('READY');
	display('');
    }else
	display('NEW PROBLEM NAME--',false);
}

function dtss_newold(cmd){
    if('NEW'==cmd){
	display('NEW PROBLEM NAME--',false);
	prompt=dtss_new;
    }else if('OLD'==cmd){
	display('OLD PROBLEM NAME--',false);
	prompt=dtss_old;
    }else
	display('NEW OR OLD--',false);
}

function dtss_hel(cmd){
    if(''==cmd){
	display('USER NO.--',false);
    }else if(cmd.match(/[A-Z0-9][0-9][0-9][0-9][0-9][0-9]/)){
	user=cmd;
	display('SYSTEM--BASIC');
	display('NEW OR OLD--',false);
	prompt=dtss_newold;
    }else{
	display('USER NUMBERS MUST BE EITHER SIX NUMBERS');
	display('OR A LETTER FOLLOWED BY FIVE NUMBERS');
	display('USER NO.--',false);
    }
}


function dtss(cmd){
    var i,j;
    var txt=cmd;
    var args;
    var t;

    cmd=cmd.trim();
    cmd=cmd.replace(/  /g,' ').split(' ');
    if(3<cmd[0].length)
	cmd[0]=cmd[0].substring(0,3);
    if('LIS'==cmd[0]){
	if(0==prg.length){
	    display('');
	    display('NO PROGRAM.');
	    return;
	}
	j=0;
	t=1e5;
	if(cmd=txt.match(/LIS[T]--([0-9]+) *([0-9]*)/)){
	    j=parseInt(cmd[1]);
	    if(''!=cmd[2])
		t=parseInt(cmd[2]);
	}
	prg=prg.sort(function(a,b){return parseInt(a[0][0])-parseInt(b[0][0])});
	for(var i=0;i<prg.length;i++){
	    if(prg[i][0][0]>=j && prg[i][0][0]<=t)
		display(prg[i][0][1]);
	}
    }else if('SAV'==cmd[0]){
	txt='';
	for(i=0;i<prg.length;i++)
	    txt+=prg[i][0][1]+'\n';
	window.localStorage.setItem(prgname,txt);
	display('READY');
	display('');
    }else if('OLD'==cmd[0]){
	cmd.shift();
	if(0<cmd.length)
	    dtss_old(cmd.join(' '));
	else{
	    display('OLD PROGRAM NAME--',false);
	    prompt=dtss_old;
	}
    }else if('NEW'==cmd[0]){
	cmd.shift();
	if(0<cmd.length)
	    dtss_new(cmd.join(' '));
	else{
	    display('NEW PROGRAM NAME--',false);
	    prompt=dtss_new;
	}
    }else if('SCR'==cmd[0]){
	prg=[];
    }else if('CAT'==cmd[0]){
	display('');
	t=new Date();
	txt=''+t.getMinutes();
	if(1==txt.length)
	    txt='0'+txt;
	txt='USER NO. '+user+'    SAVED PROGRAMS   '+t.getDate()+'. '+
	    mon[t.getMonth()]+' '+t.getFullYear()+
	'    TIME: '+t.getHours()+':'+txt;
	display(txt);
	display('');
	txt='';
	j=window.localStorage.length;
	for(i=0;i<j;i++){
	    txt+=window.localStorage.key(i)+'  ';
	    if(50<txt.length){
		display(txt);
		txt='';
	    }
	}
	if(''!=txt)
	    display(txt);
	display('');
    }else if('UNS'==cmd[0]){
	window.localStorage.removeItem(prgname);
	display('');
	display('READY.');
    }else if('REN'==cmd[0]){
	cmd.shift();
	if(0<cmd.length)
	    dtss_ren(cmd.join(' '));
	else{
	    display('RENAME PROGRAM NAME--',false);
	    prompt=dtss_ren;
	}
    }else if('STO'==cmd[0]){
	display('');
	display('STOP.');
	display('READY');
    }else if('HEL'==cmd[0]){
	display('USER NO.--',false);
	prompt=dtss_hel;
    }else if('BYE'==cmd[0]||'GOO'==cmd[0]){
	display('');
	display('HELLO');
	dtss('HELLO');
    }else if('EXP'==cmd[0]){
	if(cmd[1])
	    help(cmd[1]);
	else
	    help('');
    }
}

function help(cmd){
    var txt=cmd.replace(/ /g,'');
    if(''==txt){
	display('');
	display('DARTMOUTH TIME SHARING SYSTEM (DTSS) AND BASIC SIMULATOR');
	display('FOR INFO ABOUT DTSS COMMANDS TYPE EXP DTSS');
	display('FOR INFO ABOUT BASIC COMMANDS TYPE EXP BASIC');
	display('');
    }else if('DTSS'==txt){
	display('COMMANDS ARE');
	display('HELLO BYE GOODBYE SAVE RENAME NEW OLD SCRATCH CATALOG LIST UNSAVE RUN');
	display('ONLY THE FIRST THREE LETTERS ARE SIGNIFICANT');
	display('FOR INFO ABOUT A COMMAND TYPE EXP COMMAND');
    }else if('RUN'==txt){
	display('RUN WILL COMPILE AND RUN THE CURRENT PROGRAM');
    }else if('RENAME'==txt){
	display('RENAME CHANGES THE NAME OF THE CURRENT PROGRAM');
	display('IF GIVEN WITHOUT A NAME IT WILL PROMPT ONE');
    }else if('NEW'==txt){
	display('NEW DISCARD THE CURRENT PROGRAM AND STARTS A NEW WITH A NEW NAME');
    }else if('SCRATCH'==txt){
	display('SCRATCH ERASES THE PROGRAM BUT KEEPS THE NAME');
    }else if('UNSAVE'==txt){
	display('UNSAVE WILL DELETE THE CURRENT PROGRAM FROM THE DISK');
    }else if('SAVE'==txt){
	display('SAVE WILL SAVE THE CURRENT PROGRAM TO DISK');
    }else if('OLD'==txt){
	display('OLD WILL FETCH A PROGRAM FROM THE DISK');
    }else if('CATALOG'==txt){
	display('CATALOG WILL LIST THE PROGRAMS ON THE DISK');
    }else if('LIST'==txt){
	display('LIST WILL LIST THE CURRENT PROGRAM');
	display('LIST--XX WILL ONLY LIST THE LINES STARTING AT LINE XX');
	display('LIST--XX YY WILL ONLY LIST LINES FROM XX TO YY');
    }else if('HELLO'==txt){
	display('HELLO WILL LOG A NEW USER IN');
	display('IN THE SIMULATOR IT WILL ONLY CHANGE THE USER NO');
    }else if('BYE'==txt||'GOODBYE'==txt){
	display('BYE AND GOODBYE WILL LOG A USER OUT');
    }else if('BASIC'==txt){
	display('THE FORMAT FOR A BASIC LINE IS');
	display('LINE-NO INSTRUCTION <ARGUMENTS>');
	display('INSTRUCTIONS ARE');
	display('LET FOR NEXT IF GOTO READ DATA PRINT');
	display('GOSUB RETURN DEF DIM REM END STOP');
	display('FOR INFO ABOUT AN INSTRUCTION TYPE EXP INST');
    }else if('LET'==txt){
	display('LINE-NO LET VAR=EXPRESSION');
    }else if('FOR'==txt){
	display('LINE-NO FOR VAR=EXPR TO EXPR <STEP EXPR>');
	display('REPEATS LINES UNTIL A NEXT INSTRUCTION WITH SAME VAR');
    }else if('NEXT'==txt){
	display('LINE-NO NEXT VAR');
    }else if('IF'==txt){
	display('LINE-NO IF EXPR RELOP EXPR THEN LINE-NO');
	display('WHERE RELOP IS ONE OF < > = <= >= <>');
    }else if('GOTO'==txt){
	display('LINE-NO GOTO LINE-NO');
    }else if('READ'==txt){
	display('LINE-NO READ VAR-LIST');
    }else if('DATA'==txt){
	display('LINE-NO DATA NUMBER-LIST');
    }else if('PRINT'==txt){
	display('LINE-NO PRINT ARG-LIST');
	display('ARGS CAN BE "TEXT", NUMBERS, OR EXPRESSIONS DIVIDED BY ,');
    }else if('GOSUB'==txt){
	display('LINE-NO GOSUB LINE-NO');
    }else if('RETURN'==txt){
	display('LINE-NO RETURN');
    }else if('DEF'==txt){
	display('LINE-NO DEF NAME(VAR)=EXPRESSION');
	display('WHERE NAME IS FN FOLLOWED BY A LETTER');
    }else if('DIM'==txt){
	display('LINE-NO DIM VAR(NUMBER)');
	display('OR');
	display('LINE-NO DIM VAR(NUMBER,NUMBER)');
    }else if('REM'==txt){
	display('LINE-NO REM ARBITRARY COMMENT TEXT');
    }else if('END'==txt){
	display('LINE-NO END');
	display('HAS TO BE LAST LINE IN PROGRAM');
    }else if('STOP'==txt){
	display('LINE-NO STOP');
	display('STOPS PROGRAM. CAN BE ANYWHERE IN PROGRAM');
    }else{
	display('WHAT?');
    }
}

function infocus(){
    setTimeout(function(){elm('cinput').focus()},100);
}

elm('cinput').focus();
elm('cinput').addEventListener('blur', infocus);
elm('cinput').addEventListener('input', keyinput);
elm('cinput').addEventListener('keydown', keydown);

display('HELLO');
dtss('HELLO');
