var ctx = null;
var staebchenB = 6;
var bundL = 86;
var buende = 24;
var noteMap = {
	"C": 0,
	"C#": 1,
	"D": 2,
	"D#": 3,
	"E": 4,
	"F": 5,
	"F#": 6,
	"G": 7,
	"G#": 8,
	"A": 9,
	"A#": 10,
	"H": 11
};
var noteArray = [
	'C', 
	'C#', 
	'D', // 2
	'D#', 
	'E', // 4
	'F', 
	'F#',
	'G', // 7
	'G#',
	'A', // 9
	'A#',
	'H'
];
var strings = null;
var numberOfStrings = 4;

window.onload = function() {
	var T = getStorage("_MY_TUNINGX");
	if (T === undefined) {
		T = '{ "T": ["E","A","D","G"] }';
	}
	setTuning(T);
	var cvs = document.getElementById('griffbrett');
	var selector = document.getElementById("selectTuning");
	renderGriffbrett(cvs.getContext('2d'));
	selector.addEventListener("change", function(){
			setTuning(this.children[this.selectedIndex].value); }.bind(selector)
	, false); //ffOS
	cvs.addEventListener("touchstart", function(evt) { 
		handleMousedown(cvs, evt.touches[0]); console.log("FirefoxOS touch"); 
		}, false); //ffOS
};


function setTuning(T) {
	console.log("Set tuning... ", T);
	if (T.length <= 0) {
		console.log("Nothing to select");
		return;
	}
	setStorage("_MY_TUNINGX", T);
	if (typeof T == "string") {
		T = JSON.parse(T);
	}
	T = T.T;
	T.reverse();
	strings = [noteMap[T[0]], noteMap[T[1]], noteMap[T[2]], noteMap[T[3]]];
	for (var i = 0; i < numberOfStrings; i++) {
		document.getElementById("string"+(i+1)).innerHTML = noteArray[strings[i]];
	}
	console.log("Tunig set!");
	if (ctx != null) {
		renderGriffbrett();
		document.getElementById("note").innerHTML = "";
		document.getElementById("info").innerHTML = "";
	}
}


function renderGriffbrett(theCtx, showNotes) {
	if (theCtx !== undefined) {
		ctx = theCtx;
	}
	// Zeichnen des BG:
	ctx.fillStyle ='#F9E1BF';
	ctx.fillRect(0,0,1600,160);
	// Zeichne aller Stbchen und Punkte...
	for (var i = 0, l = bundL; i <= buende; i++, l--) {
		var x = l*i;
		var objGradient = ctx.createLinearGradient(x, 0, x+8, 0);
	    objGradient.addColorStop(0, 'silver');
	    objGradient.addColorStop(1, 'black');
	    ctx.fillStyle = objGradient;
		ctx.fillRect(x,0,staebchenB,160);
		var xn = (l-1)*(i+1);
		var dotX = (x+xn)/2 + 3;
		switch (i) {
			case 2:
			case 4:
			case 6: 
			case 8:
			case 14:
			case 16:
			case 18:
			case 20:
				ctx.fillStyle = "black";
				ctx.beginPath();
				ctx.arc(dotX,79,10,0,2*Math.PI);
				ctx.fill();
				break;
				
			case 11:
			case 23:
				ctx.fillStyle = "black";
				ctx.beginPath();
				ctx.arc(dotX,40,10,0,2*Math.PI);
				ctx.arc(dotX,120,10,0,2*Math.PI);
				ctx.fill();
				break;
				
			default:
				ctx.fillStyle = "black";
				ctx.font = "bold 16px Arial";
				ctx.fillText(i+1+"", dotX-5,86);
			  	break;
		}
	}
	// Ende...
	image = new Image();
	image.src = "img/Schlagbrett.png";
	ctx.drawImage(image, 1500,0);
	ctx.save();
	// Zeichnen der Saiten (4):
	for (var i = 2, h = 18; i < 6; i++, h=h+36+i) {
		var objGradient = ctx.createLinearGradient(0,h,0,h+i);
	    objGradient.addColorStop(0, 'grey');
	    objGradient.addColorStop(0.5, 'silver');
	    objGradient.addColorStop(1, 'grey');
	    ctx.shadowColor = 'black';
	    ctx.shadowBlur = 3;
	    ctx.shadowOffsetY = -1;
	    ctx.fillStyle = objGradient;
		ctx.fillRect(0,h,1980,i);
	}
	ctx.restore();
}


function getMousePos(canvas, evt) {
    var rect = canvas.getBoundingClientRect();
    return {
      x: evt.clientX - rect.left,
      y: evt.clientY - rect.top
    };
  }


function handleMousedown (inSender, mouseEvent) {
	renderGriffbrett();
	ctx.fillStyle = "red";
	ctx.beginPath();
	var p = getMousePos(inSender, mouseEvent);
	var text = "(";
	var kx = p.x;
	var ky = p.y;
	var saite = -1;
	var bund = -1;
	// Bund herausfinden:
	for (var i = 0, l = bundL; i < buende; i++, l--) {
		var border1 = l*i;
		var border2 = (l-1)*(i+1);
		if (p.x >= border1 && p.x < border2 && i < buende) {
			bund = i+1;
			text += "Fret "+bund+", ";
			kx = (border1+border2)/2 +3;
		}
	}
	// Saite herausfinden
	for (var i = 1, j = 40; i <= 4; i++, j=i*40) {
		var border1 = j-40;
		var border2 = j;
		if (p.y >= border1 && p.y < border2) {
			saite = i-1;
			text += noteArray[strings[saite]]+"-String";
			ky = (border1+border2)/2;
		}
	}
	// Note herausfinden:
	var base = noteMap[noteArray[strings[saite]]];
	var n = base;
	for (var i = 0; i < bund; i++, n++) {
		if (n >= noteArray.length-1) {
			n = -1;
		}
	}
	var theNote = noteArray[n];
	if (theNote !== undefined) {
		// Zeichne Punkt auf Griffbrett:
		ctx.arc(kx,ky,7,0,2*Math.PI);
		ctx.fill();
		ctx.restore();
		document.getElementById("note").innerHTML = theNote;
		document.getElementById("info").innerHTML = text+")";
	}
}