

getStorage = function(name) {
  try {
    var result;
  	if(typeof name === "string") {
  		result = localStorage.getItem(name);
  	}
  	if(typeof result === "string"){
      var r;
      try {
        r = JSON.parse(result);
      } catch (e) {
        r = result;
      }   
  		return r;
  	} else if(typeof result === "object" && result !== null) {
  		enyo.log("OBJECT: " + result);
  		throw "ERROR [Storage.get]: getItem returned an object. Should be a string.";
  	} else if(typeof result === "undefined" || result === null) {
  		return undefined;
  	}
  } catch (e) {
    // IE makes trouble
    enyo.log(e);
  }
};


setStorage = function(name, obj) {
  try {
    if(typeof name === "string") {
  		if(typeof obj === "object") {
  			localStorage.setItem(name, JSON.stringify(obj));
  		}
  		else if(typeof obj === "string" || typeof obj === "boolean") {
  			localStorage.setItem(name, obj);
  		}
  	}
  } catch (e) {
    // IE makes trouble
    enyo.log(e);  
  }
};


