$(document).ready(function() {
	var top, bottom, arrow;
	top = localStorage.getItem('topColor');		
	if (top === null) {
			top = '#0f0';
		}		
	bottom = localStorage.getItem('bottomColor');
	if (bottom === null) {
			bottom = '#f00';
		}		
	arrow = localStorage.getItem('arrowColor');		
	if (arrow === null) {
			arrow = '#00f';
		}
	localStorage.setItem('topColor',top);
	localStorage.setItem('bottomColor',bottom);
	localStorage.setItem('arrowColor',arrow);		
	BatteryImage('batteryCanvas1');	
	Arrow('pointerCanvas1');
	arrow1Color();
	BatteryStatus();
	BatteryImage('batteryCanvas2');
	Arrow('pointerCanvas2');
	arrow2Color();
});

function Color(c) {
	if (c == 1) {
		localStorage.setItem('topColor','#f00');
		} else if (c == 2) {
		localStorage.setItem('topColor','#ff0');
		} else if (c == 3) {
		localStorage.setItem('topColor','#0f0');
		} else if (c == 4) {
		localStorage.setItem('topColor','#0ff');
		} else if (c == 5) {
		localStorage.setItem('topColor','#00f');
	}	
	if (c == 6) {
		localStorage.setItem('bottomColor','#f00');
		} else if (c == 7) {
		localStorage.setItem('bottomColor','#ff0');
		} else if (c == 8) {
		localStorage.setItem('bottomColor','#0f0');
		} else if (c == 9) {
		localStorage.setItem('bottomColor','#0ff');
		} else if (c == 10) {
		localStorage.setItem('bottomColor','#00f');
	}
}

function BatteryImage(batteryCanvas) {
	var top, bottom;	
	top = localStorage.getItem('topColor');
	bottom = localStorage.getItem('bottomColor');		
	var canvas = document.getElementById(batteryCanvas);
	var context = canvas.getContext('2d');
	context.rect(0, 0, canvas.width, canvas.height);    
	var grd = context.createLinearGradient(50, 0, 50, 120);    
	grd.addColorStop(0, top);   
	grd.addColorStop(1, bottom);
	context.fillStyle = grd;
	context.fill();    
}

function Arrow(pointerCanvas) {
	 var battery = navigator.battery || navigator.mozBattery || navigator.webkitBattery;
	 function updatePointerStatus() {
	  	var pointer = Math.round((1-battery.level)*200);																 				
	  	document.getElementById(pointerCanvas).style.marginTop = (pointer.toString() + "px"); 	 
	 }				    
	 battery.addEventListener("levelchange", updatePointerStatus);
	 updatePointerStatus(); 			
}

function arrowColorNew(a) {
	if (a == 1) {
		localStorage.setItem('arrowColor','#f00');
		$('#p2Color').css('border-right-color','#f00');
	} else if (a == 2) {
		localStorage.setItem('arrowColor','#e80');
		$('#p2Color').css('border-right-color','#e80');
	} else if (a == 3) {
		localStorage.setItem('arrowColor','#099');
		$('#p2Color').css('border-right-color','#099');
	} else if (a == 4) {
		localStorage.setItem('arrowColor','#c0c');
		$('#p2Color').css('border-right-color','#c0c');
	} else if (a == 5) {
		localStorage.setItem('arrowColor','#00f');
		$('#p2Color').css('border-right-color','#00f');
	}
}

function arrow1Color() {
	var arrow;	
	arrow = localStorage.getItem('arrowColor');
	document.getElementById('p1Color').style.borderRightColor = arrow;
}

function arrow2Color() {
	var arrow;	
	arrow = localStorage.getItem('arrowColor');
	document.getElementById('p2Color').style.borderRightColor = arrow;
}

function BatteryStatus() {
	var top, bottom;	
	top = localStorage.getItem('topColor');
	bottom = localStorage.getItem('bottomColor');
	var battery = navigator.battery || navigator.mozBattery || navigator.webkitBattery;
		function updateBatteryStatus() {	
			var level = (Math.round(battery.level*100));
			document.getElementById('batteryData').innerHTML = (level + " %");
			if (battery.charging) {
				BatteryChargingStatus('batteryChargingCanvas','top',"+ + + +");
				BatteryChargingStatus('batteryNotChargingCanvas',"#ccc"," - - - -");
  			}	
 			else {
				BatteryChargingStatus('batteryChargingCanvas',"#ccc","+ + + +");
				BatteryChargingStatus('batteryNotChargingCanvas','bottom'," - - - -");	
			}
		}
	battery.addEventListener("chargingchange", updateBatteryStatus);
	battery.addEventListener("levelchange", updateBatteryStatus);
	updateBatteryStatus();		
}
	 	  
function BatteryChargingStatus(canvas,col,str) { 
	var color;
	if (col == 'top') {
		color = localStorage.getItem('topColor');		
	} else 
	if (col == 'bottom') {
		color = localStorage.getItem('bottomColor');	
	} else {	
		color = col;
	}	
    var canvas = document.getElementById(canvas);    
    var context = canvas.getContext('2d');
    context.fillStyle = (color);
    context.fillRect(0, 0, canvas.width, canvas.height); 
	context.font = "bold 100px Arial, sans-serif";
	context.fillStyle = "#000";
	context.fillText(str, 10, 110);
}
 

