//var debug = new debugObject(true);

jQuery.fn.center = function () {
    this.css("position","absolute");
    this.css("top", Math.max(0, (($(window).height() - $(this).height()) / 2) +  $(window).scrollTop()) + "px");
    this.css("left", Math.max(0, (($(window).width() - $(this).width()) / 2) + $(window).scrollLeft()) + "px");
    return this;
}

//Translation.getLang(); //load and initialized Transaltion app see locale.js

/*var settings = {
	localStorageName : 'batteryFXOS',
	options: {
		'level':'5',
		'chargingTime': '',
		'dischargingTime': '',
		'lastUpdate': ''
	},
	load: function() {
		var value = localStorage.getItem(this.localStorageName);
		if (!this.isEmpty(JSON.parse(value))) this.options = value && JSON.parse(value);
	},
	save: function() {
		localStorage.setItem(this.localStorageName, JSON.stringify(this.options));
	},
	clear: function(clearAll=false) { 
		localStorage.clear(this.localStorageName);
		if (clearAll) this.options = null;
	},
	isEmpty :function(obj) {
		for(var prop in obj) {
			if(obj.hasOwnProperty(prop))
				return false;
		}
		return true;
	}
}*/

var discharging =  new Array();
discharging['start'] ='';
discharging['end'] = '';
discharging['interval'] = 352.5265; //noraml discarge interval 1% in seconds


function secondsToTime(secs) {
	var hours = Math.floor(secs / (60 * 60));
   
	var divisor_for_minutes = secs % (60 * 60);
	var minutes = Math.floor(divisor_for_minutes / 60);
 
	var divisor_for_seconds = divisor_for_minutes % 60;
	var seconds = Math.ceil(divisor_for_seconds);
   
	var obj = {
		"h": hours,
		"m": minutes,
		"s": seconds
	};
	return obj;
}
var battery = navigator.battery || navigator.mozBattery || navigator.webkitBattery;	

  
function Fnchargingchange() {
	//debug.log('chargingchange');
	displayBatteryStats();
}

function Fnchargingtimechange() {
	//debug.log('chargingtimechange');
	displayBatteryStats();
}

function Fndischargingtimechange() {
	//debug.log('dischargingtimechange');
	displayBatteryStats();
}

function Fnlevelchange() {
	//debug.log('levelchange');
	
	discharging['end'] = (new Date()).getTime();
	discharging['interval'] = (discharging['end']-discharging['start'] )/1000;
	discharging['start'] =(new Date()).getTime();
	//debug.log('Descargando... ' + discharging['interval']);
	//debug.log('consumiendo porciento 1 hora...' + (3600 / discharging['interval'])/10);
	displayBatteryStats();
}	  


function displayBatteryStats() {
	var batteryLevelPercent = Math.floor(battery.level * 100);
	
	if (battery.charging) {
		
		//debug.log('Cargando batterylevel:' + battery.level);
		$('#lblLevel').removeClass().addClass('iconCharging');
		reamaningLevel = 100 -batteryLevelPercent;
		remaningTime = (561.206 * reamaningLevel); //seconds charging 1% 561.206
		remaningTime = secondsToTime(remaningTime);
		$('#lbl2').text('Charging timeleft');
		$('#lbl3').text('Status battery');
		if (battery.level<1) $('#lblHourlyConsumption').text('Charging...'); else $('#lblHourlyConsumption').text('Full charge');
		$('#lblRemaningTime').text(remaningTime.h + 'h ' + remaningTime.m + 'm');
	} else {
		//debug.log('Descargando batterylevel:' + battery.level);
		$('#lblLevel').removeClass();
		reamaningLevel = batteryLevelPercent;
		//debug.log('remaningLevel' + reamaningLevel);
		
		remaningTime = (discharging['interval'] * reamaningLevel); //seconds charging 1% 270.106
		//debug.log('remaningTime' + remaningTime);
		remaningTime = secondsToTime(remaningTime);		
		//debug.dir(remaningTime);
		var consumption = (3600 / discharging['interval'])/10;
		if (consumption<1) consumption = 1;
		$('#lbl2').text('Remaning time');
		$('#lbl3').text('Hourly consumption');
		$('#lblHourlyConsumption').text( '~' + Math.floor(consumption)+ '% / hour');		
		$('#lblRemaningTime').text(remaningTime.h + 'h ' + remaningTime.m + 'm');
		
		if (battery.level <= 0.1) $('#lblLevel').removeClass().addClass('iconCaution');
	}
	
	
	$('#lblLevel').text(batteryLevelPercent + '%');
	$('#batteryLevel').css('width',batteryLevelPercent + '%');
	if (battery.level < 1) $('#batteryLevel').css('background-color','#00ACED'); //color blue normal
	if (battery.level < 0.3) $('#batteryLevel').css('background-color','#D96D00'); //color orange
	if (battery.level <= 0.1) $('#batteryLevel').css('background-color','#D93600'); //color red
	if (battery.level >= 0.95) $('#batteryLevel').css('background-color','#36D900'); //color lima
	
	
	//mostrar tiempos
	consumption = consumptionPercent('standby',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblStandbyTime').text(time.h +'h ' + time.m +'m');
	
	consumption = consumptionPercent('talk',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblTalkTime').text(time.h +'h ' + time.m +'m');	
	
	consumption = consumptionPercent('game',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblGameTime').text(time.h +'h ' + time.m +'m');	


	consumption = consumptionPercent('web',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblWebTime').text(time.h +'h ' + time.m +'m');	
	
	consumption = consumptionPercent('gps',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblGPSTime').text(time.h +'h ' + time.m +'m');	
	
	consumption = consumptionPercent('music',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblAudioTime').text(time.h +'h ' + time.m +'m');	
	
	consumption = consumptionPercent('video',batteryLevelPercent);
	time = secondsToTime(consumption);
	$('#lblVideoTime').text(time.h +'h ' + time.m +'m');	
	

	//debug.dir(battery);
	
	tiempo = Infinity;
	if (battery.chargingTime !== Infinity) tiempo = battery.chargingTime;
	if (battery.dischargingTime !== Infinity) tiempo = battery.dischargingTime;

	if (tiempo !== Infinity) {
		tiempoStr = secondsToTime(tiempo);
		//debug.dir(battery);
		$('#labelTime').html('+' + tiempoStr['h'] + ':' +tiempoStr['m']);
	}

	level = battery.level;
	level = Math.ceil(level *10)*10;
	$("#imgPercent").removeAttr('class');
	$('#imgPercent').addClass('imgBattery' + level + 'percent');

}

		
function consumptionPercent(type,level) {
	var sec;
	if (type =='music') {
		consumption = Math.floor((level*10) / 2);//percent
	} else if(type == 'video') {
		consumption = Math.floor((level*10) / 3);//percent
	} else if(type == 'gps') {
		consumption = Math.floor((level*10) / 3.2);//percent
	} else if(type == 'game') {
		consumption = Math.floor((level*10) / 4);//percent
	} else if(type == 'web') {
		consumption = Math.floor((level*10) / 2.2);//percent
	} else if(type == 'talk') {
		consumption = Math.floor((level*10) / 2.90);//percent
	} else if(type == 'standby') {
		consumption = Math.floor((level*10) / 0.09);//percent
	}
	return consumption*60; //return in seconds
}


		
$(document).ready(function() {
	

	//debug.log('start debug');
	
	//settings.save();
	//settings.load();

	
	if (battery) {
		discharging['start'] =(new Date()).getTime();
		
        displayBatteryStats();
        battery.addEventListener("chargingchange", Fnchargingchange, false);
        battery.addEventListener("chargingtimechange", Fnchargingtimechange, false);
        battery.addEventListener("dischargingtimechange", Fndischargingtimechange, false);
        battery.addEventListener("levelchange", Fnlevelchange, false);
      } else {
		$('#content').hide();
		$('#noSuportBattery').show();
    	}
  
  	$('#btnExit').click(function(e) {
		e.preventDefault();
		window.close();
	});	
  

	$('#btnSettings').click(function(e) {
		e.preventDefault();
		var openSettings = new MozActivity({
			name : "configure",
			data : {
				target : "device"
				}
		  });			
	});	
  
  
  
});

(function($) {
	$(document).ready(function() {
		$.slidebars();
	});
}) (jQuery);
  
