// Check battery
	var checkBattery = document.querySelector(".check-battery"),
	batteryDisplay = document.querySelector("#battery-display");
	if (checkBattery && batteryDisplay) {
		checkBattery.onclick = function () {
		    var battery = navigator.battery,
		        batteryLevel = Math.round(battery.level * 100),
		        charging = battery.charging,
		        chargingTime = parseInt(battery.chargingTime / 60, 10),
		        dischargingTime = parseInt(battery.dischargingTime / 60, 10),
		        batteryInfo;

		    batteryInfo = "<strong>Battery level:</strong> " + batteryLevel + " %<br>";
		    batteryInfo += "<strong>Battery charging:</strong> " + charging + "<br>";
		    if(charging === true) {
		    	batteryInfo += "<strong>Battery charging time:</strong> " + chargingTime + "<br>";
		    } else {
		    	batteryInfo += "<strong>Battery discharging time:</strong> " + dischargingTime;
		    }
		    batteryDisplay.innerHTML = batteryInfo;
		    batteryDisplay.style.display = "block";
		};
	}
        $(function() {
          var $topLoader = $("#topLoader").percentageLoader({width: 200, height: 200, controllable : false, progress : 0.0, onProgressUpdate : function(val) {
              $topLoader.setValue(batteryLevel + '%');
            }});

          var topLoaderRunning = false;
          $("#animateButton").click(function() {
            if (topLoaderRunning) {
              return;
            }
            topLoaderRunning = true;
            $topLoader.setProgress(0);
            $topLoader.setValue('0kb');
	    var battery = navigator.battery;
	    batteryLevel = Math.round(battery.level * 100);
            var kb = 0;
            var totalKb = batteryLevel;
            
            var animateFunc = function() {
              kb += 17;
              $topLoader.setProgress(totalKb / 100);
              $topLoader.setValue(batteryLevel + '%');
              
              if (kb < totalKb) {
                setTimeout(animateFunc, 25);
              } else {
                topLoaderRunning = false;
              }
            }
            
            setTimeout(animateFunc, 25);
            
          });
        });      

