/*
battery = {
	MAX_SIZE_HISTORY : 120,
	history : [],
	init : function() {

	},

}

*/
function Polygon () {
    var pointList = [];
    this.node = document.createElementNS('http://www.w3.org/2000/svg','polygon');
    function build (arg) {
        var res = [];
        for (var i=0,l=arg.length;i<l;i++) {
            res.push(arg[i].join(','));
        }
        return res.join(' ');
    }
    this.attribute = function (key,val) {
        if (val === undefined) {
          return node.getAttribute(key);
        }
        this.node.setAttribute(key,val);
    };
    this.getPoint = function (i) {
      return pointList[i];
    };
    this.setPoint = function (i,x,y) {
        pointList[i] = [x,y];
        this.attribute('points',build(pointList));
    };
    this.points = function () {
      for (var i=0,l=arguments.length;i<l;i+=2) {
          pointList.push([arguments[i],arguments[i+1]]);
      }
      this.attribute('points',build(pointList));
    };
    // initialize 'points':
    this.points.apply(this,arguments);
}
var polygon = new Polygon(0,0, 20,60, 30,80);
//Polygon.style="fill:url(#gradient)";

//localStorage.removeItem("batteryHistory");
var batteryHistory = [];
console.log("inicio", localStorage.getItem("batteryHistory"));
if (localStorage.getItem("batteryHistory")) {
  batteryHistory = JSON.parse(localStorage.getItem("batteryHistory"));
  //localStorage.setItem("batteryHistory", JSON.stringify([]));
}



window.onload = function() {
  var titulo = document.querySelector("#titulo");



  var battery = navigator.battery || navigator.msBattery || navigator.mozBattery || navigator.webkitBattery || navigator.oBattery;  //var REFERSH_TIME = 1000;
  var REFERSH_TIME = 300000;
  var MAX_SIZE_HISTORY = Math.round(86400000 / REFERSH_TIME); /* Un día */
  var panel_width = 100;
  var panel_height = 100;



 // console.log (batteryHistory);


  var bBatteryLevelRandom = false;
  var foo_contador = 0;

  function updateBatteryStatus() {
    //var batteryHistory = getBatteryHistory();
    var chargeLevel,
      chargingTime,
      dischargingTime;
    if (bBatteryLevelRandom) {
      chargeLevel = Math.random();
      chargeLevel = Math.round(chargeLevel*3)/3;
    }
    else {
      chargeLevel = battery.level;
    }
    chargingTime = battery.chargingTime;
    dischargingTime = battery.dischargingTime;
    if (!isFinite(chargingTime) || chargingTime === 0) {
      chargingTime = null;
    }
    if (!isFinite(dischargingTime) || dischargingTime === 0) {
      dischargingTime = null;
    }

    addStatusToHistorial(Date.now(), chargeLevel);
   

    
    var puntos = document.getElementById("puntos");
    while (puntos.firstChild) {
      puntos.removeChild(puntos.firstChild);
    }
    var x, y;
    var huecoEntrePuntos = Math.round(batteryHistory.length / 10);
    for(n=0; n<batteryHistory.length; n++) {
      x = getX(batteryHistory[n].timestamp)*100;
      y = (1-batteryHistory[n].level)*100;
      polygon.setPoint(n, x, y);
      //console.log(n, x, y);

      if((n % huecoEntrePuntos) === 0) {
        console.log(n);
        // Pintar cada huecoEntrePuntos
        var punto = document.createElementNS('http://www.w3.org/2000/svg','circle');
        punto.setAttribute("cx", x);
        punto.setAttribute("cy", y);
        punto.setAttribute("r", 1);

        puntos.appendChild(punto);
      }
    }
    polygon.setPoint(n, 100, 100);
    polygon.setPoint(n+1, 0, 100);
    //polygon.points(160,210, 270,330, 100,260, 100,100, 0,100);

   
   

   
  }

  function addStatusToHistorial(newTimestamp, newLevel) {
    
    var historyLength = batteryHistory.length;
    
    if (historyLength > 1 && batteryHistory[historyLength-1].level == newLevel && batteryHistory[historyLength-2].level == newLevel) {
      
      batteryHistory[historyLength-1].timestamp = newTimestamp;
      
    }
    else {
      if (batteryHistory.length > MAX_SIZE_HISTORY) {
        batteryHistory.shift();
      }
      batteryHistory.push({'timestamp': newTimestamp, 'level': newLevel});
      //console.log("añado",{'timestamp': newTimestamp, 'level': newLevel});
    }
    localStorage.setItem("batteryHistory", JSON.stringify(batteryHistory));

    //console.log (batteryHistory.length);
  }
  function getBatteryHistory() {
    return JSON.parse(localStorage.getItem("batteryHistory"));
  }

  
  function getX(timestamp) {
    
    var batteryHistory = getBatteryHistory();
    var
      firstTS = batteryHistory[0].timestamp,
      lastTS = batteryHistory[batteryHistory.length-1].timestamp;
    // Normalize to start into 0
    lastTS = lastTS - firstTS;
    timestamp = timestamp - firstTS;
    firstTS = 0;

    return timestamp/lastTS;
  }

  battery.addEventListener("chargingchange", updateBatteryStatus);
  battery.addEventListener("levelchange", updateBatteryStatus);
  titulo.addEventListener("click", function() {
    updateBatteryStatus();
    titulo.classList.toggle("seleccionado");
    
  });

  
  var timeoutID = window.setInterval(updateBatteryStatus, REFERSH_TIME);
  updateBatteryStatus();

  //polygon.setPoint(1, 20,90); // set point and automatically re-build points
  //polygon.points(160,210, 270,330, 100,360, 100,100, 0,100); // set everything
  console.log(polygon.node); // refer to the actual SVG element
  document.getElementById("svg_grafica").appendChild(polygon.node);
          //console.log(titulo);
var msg = "Battery status: " + Math.round(chargeLevel * 100) + "%";

};
