function firefoxPickImage(onOK) {
	var pick = new MozActivity({
		name: "pick",
		data: {
			type: ["image/png", "image/jpg", "image/jpeg"]
		 }
	});

	pick.onsuccess = function () { 
		var src = window.URL.createObjectURL(this.result.blob);
		var img = new Image();
		img.onload = function(e) {
			onOK(img);
		}
		img.src = src;
	};
}

function pcPickImage(onOK) {
	var reader = new FileReader();
	var input = document.createElement("input");
	
	input.type = "file";
	input.onchange = function(e) {
		var file = this.files[0];
		if(file && file.type.indexOf("image") >= 0) {
			reader.readAsDataURL(file);
			reader.onload = function(){
				var img = new Image();
				img.src = this.result;
				img.onload = function(){
					onOK(img);
				}
			}
		}
		else {
			alert("Not An Image File!");
		}
	}
	input.click();

	return;
}

function pickImage(onOK) {
	if(isAndroid()) {	
		var image = new Image();
		image.onload = function() {
			onOK(image);
		}
		image.src = "http://www.drawapp8.com/drawapp8/images/common/default_image.png";
	}
	else if(isTizen()) {
		tizenOpenGallery(function(image) {
			onOK(image);
		});
	}
	else if(isFirefoxOS()) {
		firefoxPickImage(function(image) {
			onOK(image);
		}, function() {
		});
	}
	else if(!isMobile()) {
		pcPickImage(function(image) {
			onOK(image);
		});
	}

}

function firefoxShareImage(blob) {
	var sharingImage = new MozActivity({
		name: "share",
		data: {
			type: "image/*",
			number: 1,
			blobs: [blob]
			}
	});
}

