$.mobile.defaultPageTransition="none";
$.mobile.page.prototype.options.domCache=false;
$.mobile.page.prototype.options.backBtnText = "Назад";
$.mobile.dialog.prototype.options.closeBtnText = "Закрыть";

$(function(){
	$.ajaxSetup({crossDomain: true});
	highdpi_init();
	filterBind();
	myBackBtn();

	$( document ).bind('pagechange', function(){
		highdpi_init();
		filterBind();
		myBackBtn();
	});

	$('div[data-cache=never]').live('pagehide', function (event, ui) {
		$(this).remove();
	});
	$('a[type=submit][data-offer]').live('click', function() {
		var send = {
			distr: $(this).data('offer'),
			art: $(this).data('art'),
			count: $('#count-' + $(this).data('offer')).val()
		};
		$.post('http://becost.ru/m/basket/add', send, function( data ){
			if( data == 'OK' ) {
				alert('Позиция добавлена в корзину!');
			}
			else if ( data == 'BAD' ) {
				alert('Позиция уже в корзине!');
			}
			else {
				$.mobile.changePage('/m/auth/');
			}
		});
		return false;
	});

	$('input.count').live('change', function(){
		if( parseInt( $(this).val() ) > parseInt( $(this).attr('max') ) )
		{
			$(this).val( $(this).attr('max') );
			alert('В наличии только ' + $(this).attr('max') + ' шт.');
		}
		return false;
	});
	
	$('a[class=active]').click();
});

function highdpi_init() {
	if(jQuery('.replace-2x').css('font-size') == "1px") {
		var els = jQuery(".replace-2x").get();
		for(var i = 0; i < els.length; i++) {
			if( $(els[i]).data('redy-replace') != 'true' )
			{
				var src = els[i].src
				src = src.replace(".png", "@2x.png");
				els[i].src = src;
				$(els[i]).data('redy-replace', 'true');
			}
		}
	}
}

function filterBind()
{
	if( $('#filter-form').length == 0 ) { return; }

	var manufSelect = $('#filter-form select[name=manuf]');
	var manufVal;
	var yearSelect = $('#filter-form select[name=year]');
	var yearVal;
	var modelSelect = $('#filter-form select[name=model]');
	var modelVal;
	var typeSelect = $('#filter-form select[name=type]');
	var typeVal;
	var filterBtn = $('#filter-form button[name=filter]');
	var lastModelType;

	/* Марка */
	manufSelect.change(function(){
		yearSelect.html('<option value=""></option>').selectmenu('disable').selectmenu('refresh');
		modelSelect.html('<option value=""></option>').selectmenu('disable').selectmenu('refresh');
		typeSelect.html('<option value=""></option>').selectmenu('disable').selectmenu('refresh');
		filterBtn.button('disable');
		manufVal = $(this).val();
		if( $(this).val() != '' )
		{
			$.mobile.showPageLoadingMsg();
			$.post('http://becost.ru/catalog/year-ajax', {manufid: manufVal}, function( data ) {
				for( var i in data )
				{
					yearSelect.append( $('<option>').attr('value', data[ i ]).text( data[ i ] ) );
				}
				yearSelect.selectmenu('enable');
				$.mobile.hidePageLoadingMsg();
			}, 'json');
		}
	});
	/* Год */
	yearSelect.change(function(){
		modelSelect.html('<option value=""></option>').selectmenu('disable').selectmenu('refresh');
		typeSelect.html('<option value=""></option>').selectmenu('disable').selectmenu('refresh');
		filterBtn.button('disable');
		yearVal = $(this).val();
		if( $(this).val() != '' )
		{
			$.mobile.showPageLoadingMsg();
			$.post('http://becost.ru/catalog/models-ajax', {manufid: manufVal, year: yearVal}, function( data ) {
				lastModelType = data;
				for( var i in data )
				{
					modelSelect.append( $('<option>').attr('value', i ).text( data[ i ].mtitle ) );
				}
				modelSelect.selectmenu('enable');
				$.mobile.hidePageLoadingMsg();
			}, 'json');
		}
	});
	/* Модель */
	modelSelect.change(function(){
		typeSelect.html('<option value=""></option>').selectmenu('disable').selectmenu('refresh');
		filterBtn.button('disable');
		modelVal = $(this).val();
		if( $(this).val() != '' )
		{
			for( var i in lastModelType[ modelVal ].types )
			{
				var tl = lastModelType[ modelVal ].types[ i ].ttitle +
						( lastModelType[ modelVal ].types[ i ].tfrom ? ' с '+lastModelType[ modelVal ].types[ i ].tfrom : '' ) +
						( lastModelType[ modelVal ].types[ i ].ttill ? ' по '+lastModelType[ modelVal ].types[ i ].ttill : '' );
				typeSelect.append( $('<option>').attr('value', i).text( tl ) );
			}
			typeSelect.selectmenu('enable');
		}
	});
	/* Модификация */
	typeSelect.change(function(){
		filterBtn.button('enable');
	});
}

function myBackBtn()
{
	$(':jqmData(url*=ui-page)').find(':jqmData(role=header)')
		.prepend('<a data-rel="back" data-icon="home" data-role="button" href="/m/" class="my-back-button ui-btn-left ui-btn ui-btn-icon-left ui-btn-corner-all ui-shadow ui-btn-up-b" data-theme="b"><span class="ui-btn-inner ui-btn-corner-all"><span class="ui-btn-text">Назад</span><span class="ui-icon ui-icon-arrow-l ui-icon-shadow"></span></span></a>');
	$('.my-back-button').button();
}

function delBasketItem( obj )
{
	$( obj ).prev().val(0);
	$( obj ).parent().parent().hide(100);
	$('.basket-form').submit();
}
