
// This uses require.js to structure javascript:
// http://requirejs.org/docs/api.html#define

define(function(require) {
    var latitude = NaN;
    var longitude = NaN;
    var latitude_somesecondsago = NaN;
    var longitude_somesecondsago = NaN;
    var accuracy_somesecondsago = NaN;
    var counter_not_moving = 0;
    var wpid = NaN;
    var hasLocalStorage = 'localStorage' in window;
    var stored_locations = [];
    var destination_settings_shown = false;    
    var general_settings_shown = false;
    var headingangle_act_round = 0;    
    var angle_diff_old = 0;
    var canvas_width = 100;
    var settings;
    var timeOfLastRefresh = 0;
    var change_ignored_for_seconds = 0;
    var distance_somesecondsago = NaN;
    var timeout_id = NaN;
    var isFirstGPSEvent = true;
    var headingangle_req = NaN;
    //
    // methods processing UI events
    //

    function on_settings_changed(e)
    {
        settings = new Object();

        if (document.getElementById('settings_show_debug').checked)
        {
            settings.show_debug = true;
        }
        else
        {
            settings.show_debug = false;
        }

        if (document.getElementById('settings_miles').checked)
        {
            settings.miles = true;
        }
        else
        {
            settings.miles = false;
        }


        if (settings.show_debug == false)
        {
            document.getElementById('debug_info').style.display="none";
        }
        else
        {
            document.getElementById('debug_info').style.display="inline";
        }

        if (hasLocalStorage)
        {
            try
            {
                localStorage.setItem('settings2', JSON.stringify(settings));
            }
            catch(e)    
            {
                console.error("Parsing error: ", e);
            }
        }
    }

    // Settings button 
    document.getElementById('btn_settings').addEventListener('click', function(e)
    {
        general_settings_shown = true;

        document.getElementById('div_settings').style.height= window.innerHeight - 50 + 'px';

        document.getElementById('lbl_messages').style.display="none";
        document.getElementById('btn_settings').style.display="none";
        document.getElementById('btn_back').style.display="inline";
        document.getElementById('div_container').style.display="none";
        document.getElementById('div_settings').style.display="inline";
       // document.getElementById('input_location_desc').value = "";

        drawList();

        return false;
    });

    window.addEventListener('close', function(e)
    {

/*
            if ("Notification" in window) {
                // Firefox OS 1.1 and higher
                if (Notification.permission !== 'denied') {
                    Notification.requestPermission(function (permission) {
                        if(!('permission' in Notification)) {
                            Notification.permission = permission;
                        }
                    });
                }

                if (Notification.permission === "granted") {
                    var notification = new Notification("See this", {
                        body : "This is a notification"
                    });    
                }
            } 
            else {
 // window.alert("test");
   //     window.navigator.vibrate([200, 100, 200]);


                // Firefox OS 1.0
                var notification = navigator.mozNotification.createNotification(
                    "See this",
                    "This is a notification"
                );
                notification.show();
            }
 
*/


/*
            if ("Notification" in window) {
                // Firefox OS 1.1 and higher
                if (Notification.permission !== 'denied') {
                    Notification.requestPermission(function (permission) {
                        if(!('permission' in Notification)) {
                            Notification.permission = permission;
                        }
                    });
                }

                if (Notification.permission === "granted") {
                    var notification = new Notification("See this", {
                        body : "This is a notification"
                    });    
                }
            } 
            else {


                // Firefox OS 1.0
                var notification = navigator.mozNotification.createNotification(
                    "See this",
                    "This is a notification"
                );
                notification.show();
            }
 */
        if (!isNaN(wpid))
        {
            navigator.geolocation.clearWatch(wpid);            
            wpid = NaN;
        }
            
    });

    document.addEventListener('visibilitychange', function()
    {
        if (document.hidden)
        {
            if (!isNaN(wpid))
            {
                navigator.geolocation.clearWatch(wpid);            
                wpid = NaN;
            }
        }
        else
        {
            screen.mozLockOrientation("portrait-primary"); 

            var geo_options = 
            {
                enableHighAccuracy: true,
                maximumAge: 5000,
                timeout: 10000
            }
            if (!isNaN(wpid))
            {
                navigator.geolocation.clearWatch(wpid);            
                wpid = NaN;
            }

            wpid = navigator.geolocation.watchPosition(geolocation_success, geolocation_error, geo_options);

            document.getElementById('dist').style.color = "LightGray"

            var centerOfCanvas = canvas_width / 2;
            var rad = canvas_width / 2 - 2;
            var cont = document.getElementById('can_arrow').getContext("2d");

            cont.beginPath();
            cont.strokeStyle = "#FFFFFF";
            cont.moveTo(centerOfCanvas,centerOfCanvas);
            cont.lineWidth = 4;
            cont.lineTo(centerOfCanvas + (rad-4)*Math.sin(angle_diff_old), centerOfCanvas - (rad-4)*Math.cos(angle_diff_old));
            cont.stroke();
        }
    });

    window.addEventListener('resize', function()
    {
        if (general_settings_shown)
        {
            document.getElementById('div_settings').style.height= window.innerHeight - 50 + 'px';
        }

        if (destination_settings_shown)
        {
            document.getElementById('div_settings_current_destination').style.height = window.innerHeight - 50 + 'px';
        }
    });

    document.getElementById('btn_delete').addEventListener('click', function(e)
    {
        document.getElementById('input_location_description').value = "";
        document.getElementById('input_location_latitude').value = "";
        document.getElementById('input_location_longitude').value = "";
        document.getElementById('textbox_location_notes').value = "";
    });    

    document.getElementById('btn_store').addEventListener('click', function(e)
    {
        if ((hasLocalStorage) && !isNaN(latitude) && !isNaN(longitude) && accuracy_somesecondsago < 80)
        {
            var lts = new Object();
            lts.latitude = latitude;
            lts.longitude = longitude;
            lts.description = document.getElementById('input_location_desc').value;
            lts.notes = "";
                
            if (stored_locations == null)
            {
                stored_locations = [];
            }
    
            if (hasLocalStorage)
            {
                try
                {
                    stored_locations.push(lts);
                    localStorage.setItem('destinations2', JSON.stringify(stored_locations));
                }
                catch(e)    
                {
                    console.error("Parsing error: ", e);
                }
            }

            drawList();
        }
        else
        {
            window.alert("Could not store location.\n Accuracy might be insufficient.");
        }
    });

     // back button on settings page 
    document.getElementById('btn_back').addEventListener('click', function(e)
    {
        if (destination_settings_shown == false)
        {
            general_settings_shown = false;
            document.getElementById('btn_settings').style.display="inline";
            document.getElementById('btn_back').style.display="none";
            document.getElementById('div_container').style.display="inline";
            document.getElementById('div_settings').style.display="none";
            document.getElementById('lbl_messages').style.display="table-cell";

            document.getElementById('input_location_desc').value = "";

            canvas_width = screen.width - screen.width / 2;
            if (hasLocalStorage)
            {
                try
                {
                    var jsonstr = localStorage.getItem('destinations2');                     
                    stored_locations = JSON.parse(jsonstr);
                }
                catch(e)    
                {
                }
            }
          
            if (!isNaN(latitude) && !isNaN(longitude))
            {
                calculate_and_write_distance(accuracy_somesecondsago);
            }
        }
        else
        {
            destination_settings_shown = false;
            general_settings_shown = true;
            document.getElementById('div_settings').style.display="inline";
            document.getElementById('div_settings_current_destination').style.display="none";
            document.getElementById('btn_apply').style.display="none";
            document.getElementById('btn_apply').disabled = false;

            drawList();
        }

        return false;
    });


    document.getElementById('btn_apply').addEventListener('click', function(e)
    {
        if ((document.getElementById('input_location_latitude').value != "") || (document.getElementById('input_location_longitude').value != "") || (document.getElementById('input_location_description').value) != "")
        {
            stored_locations[stored_locations.length - 1].latitude = document.getElementById('input_location_latitude').value;
            stored_locations[stored_locations.length - 1].longitude = document.getElementById('input_location_longitude').value;
            stored_locations[stored_locations.length - 1].description = document.getElementById('input_location_description').value;
            stored_locations[stored_locations.length - 1].notes = document.getElementById('textbox_location_notes').value;
        }
        else
        {
            stored_locations.splice(stored_locations.length - 1, 1);
            drawList();
        }
        document.getElementById('btn_apply').disabled = true;
        
        if (hasLocalStorage)
        {
            try
            {
                localStorage.setItem('destinations2', JSON.stringify(stored_locations));
            }
            catch(e)    
            {
                console.error("Parsing error: ", e);
            }
        }
    });

    document.getElementById('location_list').addEventListener('click', function(e)
    {
        if (e.target.className == 'tdofTab')
        {
            var target = e.target;
            var tartr = target.parentNode;
            var entirelistelts = tartr.parentNode.parentNode;
            var childNodes = entirelistelts.rows;

            for (var i=childNodes.length-1; i>=0; i--)
            {
                if (childNodes[i] == target.parentNode)
                {
                    if (i==0)
                    {
                        document.getElementById('input_location_latitude').value = stored_locations[stored_locations.length - 1].latitude;
                        document.getElementById('input_location_longitude').value = stored_locations[stored_locations.length - 1].longitude;
                        document.getElementById('input_location_description').value = stored_locations[stored_locations.length - 1].description;
                        document.getElementById('textbox_location_notes').value = stored_locations[stored_locations.length - 1].notes;
                        document.getElementById('div_settings').style.display="none";
                        document.getElementById('div_settings_current_destination').style.height = window.innerHeight - 50 + 'px';
                        document.getElementById('div_settings_current_destination').style.display="block";
                        document.getElementById('btn_apply').style.display="inline";
                        destination_settings_shown = true;
                    }
                    else
                    {
                        var store = stored_locations[(childNodes.length -1) - i];
                        for (var j = (childNodes.length - 1) - i; j <= stored_locations.length - 2; j++)
                        {
                            stored_locations[j] = stored_locations[j+1];
                        }
                                
                        stored_locations[stored_locations.length - 1] = store;

                        drawList();
                    }
                }
            }

            if (hasLocalStorage)
            {
                try
                {
                    localStorage.setItem('destinations2', JSON.stringify(stored_locations));
                }
                catch(e)    
                {
                    console.error("Parsing error: ", e);
                }
            }
        }
    });

    screen.addEventListener("mozorientationchange", function (e)
    {
        e.preventDefault();       
        screen.mozLockOrientation("portrait-primary"); 
    });

    //
    // GPS and timer events
    //

    function geolocation_error()
    {
        document.getElementById('latitude').innerHTML = "-";
        document.getElementById('longitude').innerHTML = "-";
        document.getElementById('dist').style.color = "LightGray"
        document.getElementById('lbl_messages').innerHTML = "No GPS";

                var centerOfCanvas = canvas_width / 2;
                var rad = canvas_width / 2 - 2;
                var cont = document.getElementById('can_arrow').getContext("2d");
                cont.beginPath();
                cont.strokeStyle = "#FFFFFF";
                cont.moveTo(centerOfCanvas,centerOfCanvas);
                cont.lineWidth = 5;
                cont.lineTo(centerOfCanvas + (rad-4)*Math.sin(angle_diff_old), centerOfCanvas - (rad-4)*Math.cos(angle_diff_old));
                cont.stroke();

    }

    // Calculates offset to position one second ago
    function on_trigger_update_angle(speed, accuracy)
    {
        if (!isNaN(latitude) && !isNaN(longitude))
        {
            if (isNaN(accuracy_somesecondsago) || (accuracy < 10) || (change_ignored_for_seconds > 0) || (Math.abs(accuracy_somesecondsago - accuracy) < accuracy_somesecondsago/5))
            {
                accuracy_somesecondsago = accuracy;
                change_ignored_for_seconds = 0;
                if (!(isNaN(latitude_somesecondsago) || isNaN(longitude_somesecondsago)))
            {
                    if ((headingangle_act_round != 0)
                    && (stored_locations.length > 0))
                    {
                        counter_not_moving = 0;
                        var lat2 = latitude_somesecondsago * (Math.PI / 180); // TODO

                        var dLat_req = (stored_locations[stored_locations.length-1].latitude - latitude_somesecondsago) * (Math.PI / 180);
                        var dLon_req = (stored_locations[stored_locations.length-1].longitude - longitude_somesecondsago) * (Math.PI / 180);
                        var lat1_req = latitude_somesecondsago * (Math.PI / 180);
                        var lat2_req = stored_locations[stored_locations.length-1].latitude * (Math.PI / 180);

                        var y = Math.sin(dLon_req) * Math.cos(lat2_req);
                        var x = Math.cos(lat1_req) * Math.sin(lat2_req) - Math.sin(lat1_req) * Math.cos(lat2_req) * Math.cos(dLon_req);
    
                        headingangle_req = Math.atan2(y, x);


// TODO löschen. Nur versuchsweise hier hinkopiert um herauszufinden, ob sich die Req - Anzeige nach wie vor nicht bewegt. Damit kann man womöglich die Exception eingrenzen...
          // latitude_somesecondsago = latitude;
            //            longitude_somesecondsago = longitude;



                        document.getElementById('lbl_req').innerHTML = Math.round(headingangle_req * (180 / Math.PI)) + String.fromCharCode(176); 

// TODO knallt dadrin womöglich eine Exception?, wegen der req - Anzeige, die sich nicht bewegt. gemalt wird ja noch.
                       if (!isNaN(latitude_somesecondsago) && !isNaN(longitude_somesecondsago))
                       {
                           draw_direction();
                       }


                        latitude_somesecondsago = latitude;
                        longitude_somesecondsago = longitude;
                    }
                    else
                    {
                        counter_not_moving = counter_not_moving + 1;

                        document.getElementById('speed').innerHTML = "0 m/s " + "(" + counter_not_moving + ")";
               
                        var centerOfCanvas = canvas_width / 2;
                        var rad = canvas_width / 2 - 2;


                        var cont = document.getElementById('can_arrow').getContext("2d");
                        cont.beginPath();
                        cont.strokeStyle = "#FFFFFF";
                        cont.moveTo(centerOfCanvas,centerOfCanvas);
                        cont.lineWidth = 5;
                        cont.lineTo(centerOfCanvas + (rad-4)*Math.sin(angle_diff_old), centerOfCanvas - (rad-4)*Math.cos(angle_diff_old));
                        cont.stroke();

                        latitude_somesecondsago = latitude;
                        longitude_somesecondsago = longitude;
                    }
                }
                else
                {
                    latitude_somesecondsago = latitude;
                    longitude_somesecondsago = longitude;
                }
            }
            else
            {
                accuracy_somesecondsago = accuracy;
                change_ignored_for_seconds = 1;
            }
        }
    }

    function geolocation_success(position)
    {
    //  if (!(position === undefined) && !(position.coords.latitude === undefined) && !(position.coords.longitude === undefined)) 
      if (!isFirstGPSEvent)
      {
        latitude = position.coords.latitude;
        longitude = position.coords.longitude;
        headingangle_act_round = position.coords.heading;

        document.getElementById('btn_store').removeAttribute("disabled");

        if (headingangle_act_round > 180)
        {
            headingangle_act_round = headingangle_act_round - 360;
        }

        // removed this choice (decimal)
        //if (settings.decimal)
        if (true)
        {
            document.getElementById('latitude').innerHTML = latitude;
            document.getElementById('longitude').innerHTML = longitude;
        }
        else
        {
            var degree_latitude = Math.floor(latitude);
            var degree_longitude = Math.floor(longitude);
            var minute_latitude = Math.floor((latitude - degree_latitude) * 60);
            var minute_longitude = Math.floor((longitude - degree_longitude) * 60);
            var second_latitude = Math.floor((latitude - degree_latitude - minute_latitude/60) * 3600);
            var second_longitude = Math.floor((longitude - degree_longitude - minute_longitude/60) * 3600);

            document.getElementById('latitude').innerHTML = degree_latitude + String.fromCharCode(176) + " " + minute_latitude + "' " + second_latitude + "''";
            document.getElementById('longitude').innerHTML = degree_longitude + String.fromCharCode(176) + " " + minute_latitude + "' " + second_latitude + "''";
        }            
        document.getElementById('prec').innerHTML = Math.round(position.coords.accuracy) + " m";        
        if (position.coords.speed != 0)
        {
           document.getElementById('speed').innerHTML = position.coords.speed + " m/s";
        }
        else
        {
           document.getElementById('speed').innerHTML = "0 m/s " + "(" + counter_not_moving + ")";
        }

        if (headingangle_act_round != 0)
        {
            document.getElementById('lbl_act').innerHTML = Math.round(headingangle_act_round) + String.fromCharCode(176);
        }
        else
        {

            document.getElementById('lbl_act').innerHTML = "-";
        }

        var timenow = Date.now();
 

        if (timenow-timeOfLastRefresh > 1000)
        {
            timeOfLastRefresh=timenow;
            calculate_and_write_distance(position.coords.accuracy);

            if (position.coords.accuracy < 100)
            {
                on_trigger_update_angle(position.coords.speed, position.coords.accuracy);
            }

            if (!isNaN(timeout_id))
            {
            window.clearTimeout(timeout_id);
            timeout_id = window.setTimeout(function(e)
            {
                 // exclusively called if no subesquent GPS event is fired
                 // suppose user is in a building...
                document.getElementById('dist').style.color = "LightGray"
                document.getElementById('lbl_messages').innerHTML = "No GPS";

                var centerOfCanvas = canvas_width / 2;
                var rad = canvas_width / 2 - 2;
                var cont = document.getElementById('can_arrow').getContext("2d");
                cont.beginPath();
                cont.strokeStyle = "#FFFFFF";
                cont.moveTo(centerOfCanvas,centerOfCanvas);
                cont.lineWidth = 5;
                cont.lineTo(centerOfCanvas + (rad-4)*Math.sin(angle_diff_old), centerOfCanvas - (rad-4)*Math.cos(angle_diff_old));
                cont.stroke();
            }, 
            5000);
            }
        }
   
      }
      else
      {
          isFirstGPSEvent = false;
      }
    }

    //
    // auxiliary functions
    //

    function drawList()
    {
        if (stored_locations != null)
        {
            document.getElementById('location_list').innerHTML = "";              

            if (stored_locations.length > 0)
            {
              document.getElementById('location_list').innerHTML += '<tr class="secondpagetr"><td id="tdfirst" class="tdofTab">' + stored_locations[stored_locations.length-1].description + '</td>' + '</tr>';
              for (var i=stored_locations.length-2; i>=0; i--)
              {
                  document.getElementById('location_list').innerHTML += '<tr class="secondpagetr"><td class="tdofTab">' + stored_locations[i].description + '</td>' + '</tr>';
              }
            }
        }
    }
    
    function draw_direction()
    {

                        var angle_distance_degree = (headingangle_req - headingangle_act_round * (Math.PI / 180)) * (180 / Math.PI);
                        var angle_distance = headingangle_req - headingangle_act_round * (Math.PI / 180); 

                        if (angle_distance_degree > 180)
                        {
                            angle_distance_degree = -(360 - angle_distance_degree);
                        }

                        if (angle_distance_degree < -180)
                        {
                            angle_distance_degree = angle_distance_degree + 360;
                        }

                        var centerOfCanvas = canvas_width / 2;
                        var rad = canvas_width / 2 - 2;

                        var cont = document.getElementById('can_arrow').getContext("2d");
                        cont.beginPath();

                        cont.strokeStyle = "#000000";
                        cont.lineWidth = 3;
                        cont.arc(centerOfCanvas,centerOfCanvas,rad,0,2*Math.PI);
                        cont.stroke();

                        cont.beginPath();
                        cont.strokeStyle = "#FFFFFF";
                        cont.moveTo(centerOfCanvas,centerOfCanvas);
                        cont.lineWidth = 5;
                        cont.lineTo(centerOfCanvas + (rad-4)*Math.sin(angle_diff_old), centerOfCanvas - (rad-4)*Math.cos(angle_diff_old));
                        cont.stroke();
                    
                        if (isNaN(distance_somesecondsago) || (distance_somesecondsago > 10))
                        {
                            cont.beginPath();
                            cont.strokeStyle = "#FF0000";
                            cont.moveTo(centerOfCanvas, centerOfCanvas);
                            cont.lineWidth = 3;
                            cont.lineTo(centerOfCanvas + (rad-5)*Math.sin(angle_distance), centerOfCanvas - (rad-5)*Math.cos(angle_distance));
                            cont.stroke();
                        }

                        angle_diff_old = angle_distance;
    }



    function calculate_and_write_distance(accuracy)
    {
        if (stored_locations.length > 0)
        {
            var R = 6371000; // diameter m
            var dLat = (latitude - stored_locations[stored_locations.length-1].latitude) * (Math.PI / 180);
            var dLon = (longitude - stored_locations[stored_locations.length-1].longitude) * (Math.PI / 180);
            var lat1 = stored_locations[stored_locations.length-1].latitude * (Math.PI / 180);
            var lat2 = latitude * (Math.PI / 180);

            var a = Math.sin(dLat/2) * Math.sin(dLat/2) + 
                    Math.sin(dLon/2) * Math.sin(dLon/2) * Math.cos(lat1) * Math.cos(lat2);
            var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));

            var dist = Math.round(R * c);
 
            if (accuracy < 80)
            {
                document.getElementById('dist').style.color = "black"   
                document.getElementById('lbl_messages').innerHTML = "";
            }
            else if (isNaN(accuracy))
            {
                document.getElementById('lbl_messages').innerHTML = "No GPS";
            }
            else
            {
                document.getElementById('dist').style.color = "LightGray"
                document.getElementById('lbl_messages').innerHTML = "Insufficient accuracy";
                var centerOfCanvas = canvas_width / 2;
                var rad = canvas_width / 2 - 2;
                var cont = document.getElementById('can_arrow').getContext("2d");
                cont.beginPath();
                cont.strokeStyle = "#FFFFFF";
                cont.moveTo(centerOfCanvas,centerOfCanvas);
                cont.lineWidth = 5;
                cont.lineTo(centerOfCanvas + (rad-4)*Math.sin(angle_diff_old), centerOfCanvas - (rad-4)*Math.cos(angle_diff_old));
                cont.stroke();
            }
               
            if ((settings.miles == false) && (dist < 10000))
            {
                document.getElementById('dist').innerHTML = String(dist).concat(" m") ;
            }
            else if ((settings.miles == false) && (dist >= 10000))
            {
                document.getElementById('dist').innerHTML = String(dist/1000).concat(" km");
            }
            else
            {
                var ft = dist * 3.28084;

                if ((settings.miles) && (ft < 5280))
                {
                    document.getElementById('dist').innerHTML = (String(Math.round(ft))).concat(" ft");
                }
                if ((settings.miles) && (ft >= 5280))
                {
                    ft = Math.round(ft);
                    var mi = Math.floor(ft / 5280);
                    var remainingft = ft % 5280;

                   document.getElementById('dist').innerHTML = (String(mi).concat(" mi ")).concat(String(remainingft)).concat(" ft ");
                }
            }

            distance_somesecondsago = dist;
        }
    }

    //
    // initialization
    //
    screen.mozLockOrientation("portrait-primary"); 
    document.getElementById('settings_show_debug').addEventListener('change', on_settings_changed);
    document.getElementById('settings_miles').addEventListener('change', on_settings_changed);

    canvas_width = screen.width - screen.width / 2;

    document.getElementById('can_arrow').width = canvas_width;
    document.getElementById('can_arrow').height = canvas_width;

    var geo_options = 
    {
        enableHighAccuracy: true,
        maximumAge: 5000,
        timeout: 10000
    }
     
    var centerOfCanvas = canvas_width / 2;
    var rad = canvas_width / 2 - 2;

    var cont = document.getElementById('can_arrow').getContext("2d");

    cont.beginPath();
    cont.strokeStyle = "#000000";
    cont.lineWidth = 3;
    cont.arc(centerOfCanvas,centerOfCanvas,rad,0,2*Math.PI);
    cont.stroke();

    wpid = navigator.geolocation.watchPosition(geolocation_success, geolocation_error, geo_options);

    if (hasLocalStorage)
    {
        try
        {
            stored_locations = JSON.parse(localStorage.getItem('destinations2'));
            settings = JSON.parse(localStorage.getItem('settings2'));
        }
        catch(e)    
        {
                    // initial usage
                    if (hasLocalStorage)
                    {
           // TODO            
                    }

        }

        // in case of initial usage, show default stored location
        if (stored_locations == null)
        {
           document.getElementById('input_location_desc').value = "Please enter description";
           
           var lts = new Object();

           if (isNaN(latitude) || isNaN(longitude))
           {

           lts.latitude = 90;
           lts.longitude = 0;
           
           }
           else
           {
               lts.latitude = latitude;
               lts.longitude = longitude;

           }

           lts.description = "Initial location: North pole. Store your location or click to edit.";
           lts.notes = "";

           stored_locations = [];
    
           try
           {
               stored_locations.push(lts);
               localStorage.setItem('destinations2', JSON.stringify(stored_locations));
           }
           catch(e)    
           {
               console.error("Parsing error: ", e);
           } 
        }

        if (settings != null)
        {
            document.getElementById('settings_show_debug').checked = settings.show_debug;
            document.getElementById('settings_miles').checked = settings.miles;
 
            if (settings.show_debug == false)
            {
                document.getElementById('debug_info').style.display="none";
            }
        }
        else
        {
            document.getElementById('debug_info').style.display="none";
        }
    }

    
    document.getElementById('head_or_id').style.display="inline";

    document.getElementById('div_container').style.display="inline";
});
