define(function () {
    var Atto = require('Atto'),
        config = require('config');
        require('jquery');
        require('smoothZoom');

    Atto.define({
        name: 'guide-header',
        title: null,
        backButton: null,
        backbuttonNotificationName: null,
        items: null,
        render: function atto_header() {
            var title = this.props.title || null,
                backButton = this.props.backButton || false,
                backbuttonNotificationName = this.props.backbuttonNotificationName || null,
                data = this.props.data || null;
                header = $('<header class="header">'),
                left = $('<div class="header-left">'),
                right = $('<div class="header-right">');
        
            if (backButton) {
                var a = $('<a class="header-back-button"> &lt; Back </a>');
                if (backbuttonNotificationName) {
                    a.click(function () {
                       Atto.post(backbuttonNotificationName); 
                    });
                }
                left.append(a);
            }
            header.append(left);
            if (title) {
                if (title.length > 19) {
                    title = title.substring(0, 16).trim() + '...';
                }
                header.append('<div class="header-title">' + title + '</div>');
            }
            if (data && data.position) {
                var link = $('<a class="header-back-button"> Map </a>');
                var wraper = document.createElement('div');
                link.on('click', function () {
                    var gmaps = $(Atto.create('google-maps', {
                        data: data,
                    }).render());
                   
                    gmaps.attr('data-direction', 'top');
                    gmaps.addClass('show');
                    $(document.body).append(gmaps);
                });
                // wraper.appendChild(button);
                // body.appendChild(wraper);
                right.append(link);
                header.append(right);
            }
            // header.append('<div class="header-right">' + title + '</div>');
            return header;
        }
    });

    Atto.define({
        name: 'guide-list',

        render: function () {
            var section = document.createElement('section'),
                div = document.createElement('div'),
                $this = this;
        
            section.setAttribute('data-direction', 'left');
            section.id = 'attractions-list';
            section.appendChild(Atto.create('guide-header', this.settings.call(this).header).render());

            div.className = 'list-items';
            // component/extend component should implement addItems method
            this.addItems(div);
            div.addEventListener('click', function (e) {
                element = $(e.target);
                if (!element.hasClass('list-item')) {
                    element = element.parents('.list-item');
                    if (element.size() === 0) {
                        return;
                    }
                }
                $this.rowClick(element.attr('data-select-item'));
            });
            section.appendChild(div);

            return section;
        },
        newRow: function (index) {
            var row = document.createElement('div');
            row.className = 'list-item';
            row.setAttribute('data-select-item', index);
        
            return row;
        }
    });

    Atto.define({
       name: 'attractions-list',
       extend: 'guide-list',
       settings: function () {
           if (this.compSettings) {
               return this.compSettings;
           }
           return this.compSettings = {
               header: {
                   title: 'Attractions',
                   backButton: true,
                   backbuttonNotificationName: 'attractions-list-back-button-click'
               }
           };
       },
       render: function () {
           Atto.observer('attractions-list-back-button-click', this.headerBackButtonAction, this);
           return Atto.get('guide-list').render.call(this);
       },
       addItems: function (element) {
           var items = config.attractions;
           var $this = this;
           items.forEach(function (item, index, arr) {
               var div = document.createElement('div'),
                   row;
               div.className = 'list-item-title';
               div.innerHTML = item.name;
           
               var imgDiv = document.createElement('div');
               var img = document.createElement('img');
               img.setAttribute('src', item.img_small);
               imgDiv.className = 'list-item-img';
               imgDiv.appendChild(img);
           
               row = $this.newRow(index);
               row.appendChild(imgDiv);
               row.appendChild(div);
           
               element.appendChild(row);
           });
           Atto.observer('attractions-details-list-back-button-click', this.detailsHeaderBackButtonAction, this);
       },
       headerBackButtonAction: function () {
           var home = this.props.home,
               el = $(this.element);
           home.attr('data-direction', 'right');
           el.attr('data-direction', 'right');
           home.removeClass('hide');
           home.addClass('show');
           el.removeClass('show');
           el.addClass('hide');
       },
       rowClick: function (index) {
           var item = config.attractions[index],
               element,
               details;

           if (item) {
               details = $(Atto.create('details', {
                   data: item,
                   notificationName: 'attractions-details-list-back-button-click'
               }).render());
               $(document.body).append(details);
               details.attr('data-direction', 'left');
               details.addClass('show');
               element = $(this.element);
               element.attr('data-direction', 'left');
               element.removeClass('show');
               element.addClass('hide');
               this.details = details;
           }
       },
       detailsHeaderBackButtonAction: function () {
            var element = $(this.element),
               details = this.details;

            element.attr('data-direction', 'right');
            element.removeClass('hide');
            element.addClass('show');
            details.attr('data-direction', 'right');
            details.removeClass('show');
            details.addClass('hide');
        
            setTimeout(function () {
                details.remove(); // transitionend does not work
            }, 1000);
       }
    });

    Atto.define({
        name: 'details',
        events: {
            render: function () {
                $(this.element).find('a').on('click', function (e) {
                    e.preventDefault();
                    var url = $(e.target).attr('href');
                    if (url) {
                        console.log(url);
                        var activity = new MozActivity({
                            name: 'view',
                            data: {
                                type: 'url',
                                url: url
                            }
                        });
                    }
                });
            }
        },
        render: function () {
            var section,
                body,
                description,
                img,
                button,
                $this= this;
            
            section = document.createElement('section');
            section.setAttribute('data-direction', 'left');
            section.id = 'details';

            section.appendChild(Atto.create('guide-header', {
                   title: this.props.data.name,
                   data: this.props.data,
                   backButton: true,
                   backbuttonNotificationName: this.props.notificationName
               }).render());
           
            body = document.createElement('div');
            body.className = 'details-body';

            img = document.createElement('img');
            img.className = 'details-img';
            img.src = this.props.data.img;
            
            body.appendChild(img);
            description = document.createElement('p');
            description.className = 'details-descrition';
            description.innerHTML = this.props.data.description;
            body.appendChild(description);
        
            section.appendChild(body);
            return section;
        }
    });
    
    Atto.define({
       name: 'nightlife-list',
       extend: 'guide-list',
       settings: function () {
           if (this.compSettings) {
               return this.compSettings;
           }
           return this.compSettings = {
               header: {
                   title: 'Nightlife',
                   backButton: true,
                   backbuttonNotificationName: 'nightlife-list-back-button-click'
               }
           };
       },
       render: function () {
           Atto.observer('nightlife-list-back-button-click', this.headerBackButtonAction, this);
           return Atto.get('guide-list').render.call(this);
       },
       addItems: function (element) {
           var items = config.nightlife;
           var $this = this;
           items.forEach(function (item, index, arr) {
               var div = document.createElement('div'),
                   row;
               div.className = 'list-item-title';
               div.innerHTML = item.name;
           
               var imgDiv = document.createElement('div');
               var img = document.createElement('img');
               img.setAttribute('src', item.img_small);
               imgDiv.className = 'list-item-img';
               imgDiv.appendChild(img);
           
               row = $this.newRow(index);
               row.appendChild(imgDiv);
               row.appendChild(div);
           
               element.appendChild(row);
           });
           Atto.observer('nightlife-details-list-back-button-click', this.detailsHeaderBackButtonAction, this);
       },
       headerBackButtonAction: function () {
           var home = this.props.home,
               el = $(this.element);
           home.attr('data-direction', 'right');
           el.attr('data-direction', 'right');
           home.removeClass('hide');
           home.addClass('show');
           el.removeClass('show');
           el.addClass('hide');
       },
       rowClick: function (index) {
           var item = config.nightlife[index],
               element,
               details;

           if (item) {
               details = $(Atto.create('details', {
                   data: item,
                   notificationName: 'nightlife-details-list-back-button-click'
               }).render());
               $(document.body).append(details);
               details.attr('data-direction', 'left');
               details.addClass('show');
               element = $(this.element);
               element.attr('data-direction', 'left');
               element.removeClass('show');
               element.addClass('hide');
               this.details = details;
           }
       },
       detailsHeaderBackButtonAction: function () {
            var element = $(this.element),
               details = this.details;

            element.attr('data-direction', 'right');
            element.removeClass('hide');
            element.addClass('show');
            details.attr('data-direction', 'right');
            details.removeClass('show');
            details.addClass('hide');
        
            setTimeout(function () {
                details.remove(); // transitionend does not work
            }, 1000);
       }
    });
    
    Atto.define({
        name: 'public-transport-map',
        events: {
            render: function () {
                setTimeout(function (){
        			$('#img_public_transport').smoothZoom({
                        width:'100%',
                        height:'93%',
                        responsive:true,
                        responsive_maintain_ratio:true,
        				zoom_BUTTONS_SHOW: false,
        				pan_BUTTONS_SHOW: false,
						zoom_MAX: '100',
        				zoom_OUT_TO_FIT: false
        			});
                    
                });
            }
        },
        render: function () {
            var section = document.createElement('section'),
                img = document.createElement('img'),
                $this = this;
        
            section.setAttribute('data-direction', 'left');
            section.id = 'section_public_transport_map';
            
            section.appendChild(Atto.create('guide-header', {
                title: 'Public Transportation',
                backButton: true,
                backbuttonNotificationName: 'public-transport-map-back-button-click'
            }).render());
            
			$('#img_public_transport').smoothZoom({
				width: '100%',
				height: '100%',
				responsive: true
			});
            img.id = 'img_public_transport';
            img.setAttribute('src', 'img/public_transport_day.jpg');
            
            section.appendChild(img);
            Atto.observer('public-transport-map-back-button-click', this.headerBackButtonAction, this);   
            return section;
        },
        headerBackButtonAction: function () {
            var home = this.props.home,
                el = $(this.element);
            home.attr('data-direction', 'right');
            el.attr('data-direction', 'right');
            home.removeClass('hide');
            home.addClass('show');
            el.removeClass('show');
            el.addClass('hide');
        },
    });
    
    // shopping
    Atto.define({
       name: 'shopping-list',
       extend: 'guide-list',
       settings: function () {
           if (this.compSettings) {
               return this.compSettings;
           }
           return this.compSettings = {
               header: {
                   title: 'Shopping',
                   backButton: true,
                   backbuttonNotificationName: 'shopping-list-back-button-click'
               }
           };
       },
       render: function () {
           Atto.observer('shopping-list-back-button-click', this.headerBackButtonAction, this);
           return Atto.get('guide-list').render.call(this);
       },
       addItems: function (element) {
           var items = config.shopping;
           var $this = this;
           items.forEach(function (item, index, arr) {
               var div = document.createElement('div'),
                   row;
               div.className = 'list-item-title';
               div.innerHTML = item.name;
           
               var imgDiv = document.createElement('div');
               var img = document.createElement('img');
               img.setAttribute('src', item.img_small);
               imgDiv.className = 'list-item-img';
               imgDiv.appendChild(img);
           
               row = $this.newRow(index);
               row.appendChild(imgDiv);
               row.appendChild(div);
           
               element.appendChild(row);
           });
           Atto.observer('shopping-details-list-back-button-click', this.detailsHeaderBackButtonAction, this);
       },
       headerBackButtonAction: function () {
           var home = this.props.home,
               el = $(this.element);
           home.attr('data-direction', 'right');
           el.attr('data-direction', 'right');
           home.removeClass('hide');
           home.addClass('show');
           el.removeClass('show');
           el.addClass('hide');
       },
       rowClick: function (index) {
           var item = config.shopping[index],
               element,
               details;

           if (item) {
               details = $(Atto.create('details', {
                   data: item,
                   notificationName: 'shopping-details-list-back-button-click'
               }).render());
               $(document.body).append(details);
               details.attr('data-direction', 'left');
               details.addClass('show');
               element = $(this.element);
               element.attr('data-direction', 'left');
               element.removeClass('show');
               element.addClass('hide');
               this.details = details;
           }
       },
       detailsHeaderBackButtonAction: function () {
            var element = $(this.element),
               details = this.details;

            element.attr('data-direction', 'right');
            element.removeClass('hide');
            element.addClass('show');
            details.attr('data-direction', 'right');
            details.removeClass('show');
            details.addClass('hide');
        
            setTimeout(function () {
                details.remove(); // transitionend does not work
            }, 1000);
       }
    });
    
    Atto.define({
        name: 'google-maps',
        events: {
            render: function () {
                var $this= this;
                setTimeout(function () {
                     $this.initializeMaps();
                }, 500);
            }
        },
        render: function () {
            var section = document.createElement('section'),
                img = document.createElement('img'),
                $this = this;
        
            section.setAttribute('data-direction', 'top');
            section.id = 'google-maps';
            section.appendChild(Atto.create('guide-header', {
                title: this.props.data.name,
                backButton: true,
                backbuttonNotificationName: 'google-maps-map-back-button-click'
            }).render());
            var div = document.createElement('div');
            div.id = 'google-maps-canvas';
            this.target = div;
            section.appendChild(div);

            Atto.observer('google-maps-map-back-button-click', this.headerBackButtonAction, this);

            return section;
        },
        headerBackButtonAction: function () {
            var element = $(this.element);

            element.attr('data-direction', 'bottom');
            element.removeClass('show');
            element.addClass('hide');
        
            setTimeout(function () {
                element.remove(); // transitionend does not work
            }, 1000);
        },
        initializeMaps: function () {
            var position = this.props.data.position,
                parliament = new google.maps.LatLng(position.lat, position.lng),
                map,
                mapOptions = {
                    zoom: 15,
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    center: parliament
                };

            map = new google.maps.Map(this.target, mapOptions);

            this.marker = new google.maps.Marker({
                map: map,
                draggable: true,
                animation: google.maps.Animation.DROP,
                position: parliament
            });
            google.maps.event.addListener(this.marker, 'click', this.toggleBounce);
        },
        toggleBounce: function () {

            if (this.marker.getAnimation() != null) {
                this.marker.setAnimation(null);
            } else {
                this.marker.setAnimation(google.maps.Animation.BOUNCE);
            }
        }
    });
});