define(function () {
    return {
        attractions: [
            {
                name: 'Belgrade Fortress',
                img: 'img/large/belgrade_fortress.jpg',
                img_small: 'img/small/belgrade_fortress.png',
                description: 'Built on the strategically convenient location on the confluence of Sava and Danube rivers <a href="http://www.beogradskatvrdjava.co.rs/">Belgrade Fortress</a> has witnessed turbulent historical events. Today it consists of Lower Town (Donji Grad), Upper Town (Gornji Grad) and Kalemegdan Park. Although the first settlements in Kalemegdan are dating from Neolithic period, Fortress was built gradually from the 1st to 18 century. On this crossroad of East and West were interlocked Romans, Byzantines and Huns. It was medieval capital of the Serbian country and Austrian-Ottoman artillery fortification. Today many Belgraders and tourist enjoys park\'s numerous winding walking paths, shaded benches, picturesque fountains, statues, astonishing historical architecture and incredible river views. In this area are also situated two orthodox churches – of Ruzica and Sveta Petka. The most popular symbol of Belgrade is the Statue of the Victor or Statue of Victory (Pobednik), a monument erected in 1928 to commemorate the Kingdom of Serbia\'s war victories over the Ottoman Empire in First Balkan War and Austria-Hungary in the First World War. The statue holds a falcon, on watch for the new threats on the horizon, in one hand, and a sword of war, ready to counter these threats in the other and it\'s looking forward across the confluence of the Sava and the Danube, (You can rent audio guide in Souvenir shop in Inner Stambol Gate.)',
                position: {
                    lat: 44.825028,
                    lng: 20.450703
                }
            },
            {
                name: 'Knez Mihailova Street',
                img: 'img/large/Knez_Mihailova_Street.jpeg',
                img_small: 'img/small/Knez_Mihailova_Street.png',
                description: 'Knez Mihailova Street is the main pedestrian zone and a commom meeting point for Belgraders. It is believed that in the time of Romans it were a centre of Singidunum, and later at the time of the Turks there were streets with gardens, fountains and mosques. Today it is the street with remarkable buildings built in the 70-es years of 19.century, caffeis, shops and restaurants. This colorful street will delight you with its charm and cheerful atmosphere. The street is home to Serbian Academy of Sciences and Arts (SANU), Instituto Cervantes, Goethe-Institut, Alliance française, as well as many other leading shops and several cafes and restaurants.. Thousands of people stroll along the street every day as it is the shortest path from Terazije to Kalemegdan Park and fortress.',
                position: {
                    lat: 44.817753,
                    lng: 20.456969
                }

            },
            {
                name: 'Republic Square',
                img: 'img/large/republic_square.jpg',
                img_small: 'img/small/republic_square.png',
                description: 'Republic Square is one of the busiest places in Belgrade. On one side, the square extends to the Knez Mihailova street, the pedestrian zone and one of the main commercial sections of Belgrade. It is surrounded by Belgrade\'s most recognizable public buildings, including the National Museum, the National Theatre. The square is dominated by the statue of Prince Mihailo Obrenovic (1823-1868 Prince of Serbia), the son of Prince Miloš and Princess Ljubica.',
                position: {
                    lat: 44.816105,
                    lng: 20.459927
                }
            },
            {
                name: 'Skadarlija',
                img: 'img/large/skadarlija.jpg',
                img_small: 'img/small/skadarlija.png',
                description: 'Famous bohemian quarter, located in the Old Town, arose during the early 19th century, it was the place of gathering of poets and writers. There are lot of well-known restaurants with typical national cousine, hotels, art galleries, antique and souvenir shops, and the Sebilj fountain. The famous Serbian poet and painter Đura Jakšić lived and died in Skadarlija.',
                position: {
                    lat: 44.817859,
                    lng: 20.46435
                }
            },
            {
                name: 'Residence of Princess Ljubica (Konak Kneginje Ljubice)',
                img: 'img/large/Konak_Kneginje_Ljubice.jpg',
                img_small: 'img/small/Konak_Kneginje_Ljubice.png',
                description: 'Residence of Princess Ljubica was built in 1831, during the governance of Knez Milos Obrenovic. The building was constructed under oriental influence, but the individual elements of the interior decoration and façade indicated the influence of Western and Central Europe. <br> <a href="http://www.mgb.org.rs/">www.mgb.org.rs</a>',
                position: {
                    lat: 44.817144,
                    lng: 20.452162
                }
            },
            {
                name: 'Cathedral Church of St. Michael the Archangel (Saborna Crkva)',
                img: 'img/large/Saborna_crkva_Beograd.jpg',
                img_small: 'img/small/Saborna_crkva_Beograd.png',
                description: 'The new Cathedral Church was built on orders by Prince Miloš Obrenović, in 19. century, in a classicist style with elements of baroque. The church treasury is particularly valuable, guarding old icons and richly decorated gold artefacts from the period between the 17th and 20th century.',
                position: {
                    lat: 44.817989,
                    lng: 20.451996
                }
            },
            {
                name: 'Parliament (Skupština)',
                img: 'img/large/narodna_skupstina.jpg',
                img_small: 'img/small/narodna_skupstina.png',
                description: 'The construction of the National Assembly began in 1907, with King Peter I laying the foundation stone and the building was finally constructed in 1936. It has luxurious interior decoration. The monumental sculptural group “Black Horses at Play” was set up in front of the main entrance, the work of the famous sculptor Toma Rosandić.',
                position: {
                    lat: 44.811679,
                    lng: 20.465831
                }
            },
            {
                name: 'City Hall (Gradska skupština)',
                img: 'img/large/gradska skupstina.jpg',
                img_small: 'img/small/gradska skupstina.png',
                description: 'Stari Dvor (meaning Old Palace), was the royal residence of the Obrenović dynasty. It was constructed in 19th century .Today it houses the City Assembly of Belgrade. The palace is located on the corner of Kralja Milana and Dragoslava Jovanovića streets in Belgrade, Serbia.',
                position: {
                    lat: 44.810964,
                    lng: 20.46272
                }
            },
            {
                name: 'St. Mark\'s Church (Crkva Svetog Marka)',
                img: 'img/large/St_Marks_Church.jpg',
                img_small: 'img/small/St_Marks_Church.png',
                description: 'The St. Mark’s Church is located in Tašmajdan Park. It is an orthodox churh, built in 20. century in Serbian- Byzantine style. In the churh lies several tomb of important Serbian figures - the marble tomb of Emperor Stefan Dušan, Metropolitan Teodosije, Bishop Viktor of Niš Viktor, Bishop Gavrilo Popović of Šabac, and Bishop Mojsije of Timok, and also interred here are King Alexander Obrenović and Queen Draga, Ana Jovana Obrenović, Princes Milan M. Obrenović and Sergije M. Obrenović, and the grave of the patron endower of the old church, Lazar Panča. The church treasury is presently located in a room on the south side and contains a rich collection of icons and precious artifacts. The icons are primarily the work of our eminent painters and icon painters of the 19th and 20th centuries: Steva Todorović, Nikola Marković, Dimitrije Posniković, Vladimir Vojnović, Pavle Čortanović, Lukijan Bibić, Vasa Pomorišac, Đorđe Popović, Olga Krdžalić and others. <br> <a href="http://www.crkvasvetogmarka.rs/">www.crkvasvetogmarka.rs</a>',
                position: {
                    lat: 44.810613,
                    lng: 20.468856
                }
            },
            {
                name: 'Slavija Square',
                img: 'img/large/Slavija_Square.jpg',
                img_small: 'img/small/Slavija_Square.png',
                description: 'Slavija is the largest roundabout square in Belgrade downtown, and one of the busiest traffic junctions. Surrounded by several office buildings and hotels (the biggest one is Slavija hotel), it hosts first ever Mc Donald restaurant in Eastern Europe. Central isle is dominated by monument of Dimitrije Tucovic (founder of the Social Democratic Party of Serbia in 1903).',
                position: {
                    lat: 44.802179,
                    lng: 20.466346
                }
            },
            {
                name: 'Temple of St. Sava (Hram Svetog Save)',
                img: 'img/large/Temple_of_St_Sava.jpg',
                img_small: 'img/small/Temple_of_St_Sava.png',
                description: 'The Temple of St. Sava is the biggest orthodox temple in Serbia, the biggest temple on Balkan and one of the biggest churches in the world. It is situated on eastern part of Svetosavski square, on Vracarski Plato. The temple is dedicated to Saint Sava, the founder of the Serbian Orthodox Church and important figure in medieval Serbia. Saint Sava, whose name on the birth was Rastko Nemanjić, was a son of a great Serbian ruler Stefan Nemanja, and he was the founder of the monastery Hilandar at Wholy Mountin in Greece. In 1219, afeter he won authonomy from the Byzantine Empire, he founded the Serbian Orthodox Churh. Saint Sava is considered as a Serbian teacher, saint and patron of schools and educational institutions. The temple is built on the site, where, acording to the tradition, and by order of Sinan Pasha, in the year 1594, were tranfered the relics of the first Serbian Archbishop Saint Sava from the monastery Milesevo there to be burned. Masonry of the temple began in 1936, by project of architect Bogdan Nestorović and Alexander Deroka, but due to World War II, and then the new communist authorities masonry was suspended. Construction were continued in 1985. with the architect Branko Pesic as the chief architect, but soon Yugoslavia fel apart, and construction stopped due to civil war and economic sanctions. Restoration works started at 2000 and in 2003 exterior was completely finished. The interior of the temple is still under construction. Construction was financed entirely by voluntary contributions. The Temple is built in Serbian- Byzantin style. Height of the top of the dome is 70 m, while the main gold plated cross is another 12 m, which gives the temple an overall height of 82 m. The temple is stretching in the east-west 91 m, and in the north-south 81 m. The church can accommodate 10,000 worshipers. Under the floor of the temple is built treasury and crypt of Saint Sava, and the grave church of Saint Lazar. Saint Sava Temple is also known for its polyphonic bells that sounds every hour, so we recommend that you plan your visit right then to hear their interesting sound. <br> <a href="http://www.hramsvetogsave.com">www.hramsvetogsave.com</a>',
                position: {
                    lat: 44.798114,
                    lng: 20.469028
                }
            },
            {
                name: 'Tašmajdan Park',
                img: 'img/large/Tasmajdan_Park.jpg',
                img_small: 'img/small/Tasmajdan_Park.png',
                description: 'The word tašmajdan means rock quarry or rocky field in Turkish. Tašmajdan Park or simply just Taš, is one of the largest and most beautiful parks in the heart of Belgrade, located in the municipality of Palilula. A cascade musical fountain is set in the central part of the park. The rhythm of jets of water and lighting effects are coordinated to the rhythm of music. The park is fully equipped with new benches and lighting. At Tašmajdan and around it, there are today the St. Mark\'s Church, the Main Post Office, the Sport Center "Tašmajdan", the "Madera" restaurant “Poslednja šansa” restaurant etc.',
                position: {
                    lat: 44.809609,
                    lng: 20.467851
                }
            },
            {
                name: 'Zemun',
                img: 'img/large/zemun.jpg',
                img_small: 'img/small/zemun.png',
                description: 'Zemun was a separate town until 1945, when it becomes the municipality within the city of Belgrade. The Zemun Fortress is the oldest building in Zemun. The current remains are from the 15th century. The Millenium Tower stands at the centre of the fortification. It was erected by the Hungarian authorities in 1896 and was renewed in 1962. It is also known as the tower of Sibinjanin Janko (John Hunyadi).',
                position: {
                    lat: 44.845643,
                    lng: 20.409799
                }
            },
            {
                name: 'Residence of Knez Milos (Milošev konak)',
                img: 'img/large/Milosev-konak.jpg',
                img_small: 'img/small/Milosev-konak.png',
                description: 'Residence of Prince Miloš (Milošev konak) is situated in a beautiful Topčider Park and it was built in 1831. Prince\'s residence was built in the Ottoman residential style. Although not too high, with interior decoration they imitated splendor and luxury of original Turkish houses in its time it was one of the most impressive buildings. In front of the Residence there is stunning sycamore tree, more than 160 years old. Today, Residence of Prince Miloš is a museum, which houses an exhibition about the Second Serbian rising, which was led against the Turks by Miloš Obrenović. Near to the residence is situated the Churh of St. Petar and Pavle. <br> <a href="http://www.imus.org.rs/">www.imus.org.rs</a>',
                position: {
                    lat: 44.780495,
                    lng: 20.442421
                }
            },
            {
                name: 'Avala',
                img: 'img/large/avala.jpg',
                img_small: 'img/small/avala.png',
                description: 'Avala is a mountain in Serbia, which is located 17 kilometers south-east of Belgrade downtown, on the road to Kragujevac and provides a great panoramic view of Belgrade, Vojvodina and Šumadija. With its 511 meters above sea level, clean air and magic wood Avala is ideal spot for walks and relaxation. There are several monuments in Avala. The most famous is Monument to the Unknown Hero - dedicated to the unknown Serbian soldiers from World War I. It was sculptured by Ivan Meštrović in the form of mausoleum with 8 caryatides (columns shaped like female figures, in this case each one representing a woman from a different historical region of Yugoslavia). The Monument to the Russian War Veterans is located below the Monument to the Unknown Hero and it was dedicated to the Russian veterans who died tragically in the crash of the Russian airplane in 1964. There is also the Memorial Park, dedicated to the victims of the World War II. Another monument was built on the northeastern slopes of Avala in Beli Potok to commemorate Vasa Čarapić, one of the leaders of the First Serbian Uprising in 1804 and liberator of Belgrade from the Turks. The first mountain lodge in Serbia, Mitrovićev Dom, which is now protected as a cultural monument, was built on Avala. Hotel Avala, is now also a heritage site. A television tower was built on the lower peak of Avala in 1965, and it was the tallest structure in the former Yugoslavia and the Balkans. It was destroyed during the NATO bombing campaign of 1999. It was rebuilt and brought back into service in 2010, now 205 m high with a restaurant at a height of 120 m. Today Avala Tower provides beautiful view of Sumadija and the whole Belgrade.',
                position: {
                    lat: 44.689128,
                    lng: 20.516042
                }
            },
            {
                name: 'Theaters',
                img: 'img/large/narodno_pozoriste.jpg',
                img_small: 'img/small/narodno_pozoriste.png',
                description: 'Belgrade is the cosmopolitan city, the city of culture and art. It is a city with lot of theaters, gallerias, festivals and cultural events. The theatre season lasts from October to June. Every September theaters open their curtains for BITEF, the world-renowned Belgrade International Theatre Festival with guests from the most interesting troupes and theatres of today.<br><br><p><p>National Theatre - classical repertoire, drama, opera,ballet<br /> Francuska 3, tel. 3281-333, <a href="http://www.narodnopozoriste.co.rs">www.narodnopozoriste.co.rs</a></p> <p>Yugoslav Drama Theatre<br /> Kralja Milana 50, tel. 306-1900<br /> <a href="http://www.jdp.co.rs">www.jdp.co.rs</a></p> <p>Atelje 212<br /> Svetogorska 21, tel. 324-7342<br /> <a href="http://www.atelje212.rs">www.atelje212.rs</a></p> <p>Belgrade Drama Theatre<br /> Mileševska 64a, tel. 2433-686<br /> <a href="http://www.bdp.rs">www.bdp.rs</a></p> <p>BITEF Theatre - alternative theatre projects<br /> Skver Mire Trailović 1, tel. 322-0608, <br /> <a href="http://www.bitef.rs">www.bitef.rs</a><br /> <br /> Theatre on Terazije<br /> Terazije 29, tel. 330-2650, <a href="http://www.pozoristeterazije.com">www.pozoristeterazije.com</a><br /> (musicals and comedies)</p> <p>Boško Buha - children\'s theatre, evening performance for adults<br /> Trg Republike 3, tel. 2632-855<br /> <a href="http://www.buha-theater.com">www.buha-theater.com</a><br /> </p> <p>DADOV - youth and alternative theatre<br /> Desanke Maksimović 6/I, tel. 324-3643<br /> <a href="http://www.dadov.rs">www.dadov.rs</a></p> <p>Duško Radović - children\'s theatre, evening adult performance of satirical plays<br /> Aberdareva 1, tel. 323-2072<br /> <a href="http://www.malopozoriste.co.rs">www.malopozoriste.co.rs</a></p> <p>Madlenianum - opera and theatre<br /> Zemun, Glavna 32, tel. 316-2533<br /> <a href="http://www.madlenianum.rs">www.madlenianum.rs</a></p>',
                position: {
                    lat: 44.817045,
                    lng: 20.460962
                }
            }
        ],
        nightlife: [
            {
                name: 'Skadarlija',
                img: 'img/large/skardarlija_night.jpg',
                img_small: 'img/small/skardarlija_night.png',
                description: 'This old bohemian quarter offers lots of restaurants and ant traditional Serbian kafanas  with national food and live music. The concept of eating in Serbian kafana was introduced in 19th century when the menu consisted mostly of simply snacks, such as ćevapčići. Some of Belgrade’s kafanast originate from 19th and early 20th century like the famous “?” (Question Mark),  as well as Skadarlija bohemian spots Tri šešira (Three Hats), Kod dva bela goluba (The Two White Pigeons\'), Šešir moj (This Hat of Mine), Zlatni bokal (Golden Jug), and Ima dana (There\'s Time). It\'s the same with places that became popular in mid-20th century like Šumatovac, Pod lipom (Under the Lime Tree), and Grmeč in Makedonska Street (the so-called "Bermuda triangle"), Manjež, as well as later establishments like Madera, Kod Ive (Ivo\'s), and Klub književnika (the Writers Club).',
                position: {
                    lat: 44.817859,
                    lng: 20.46435
                }
                //location: 'Skadarlija is located less than 300 metres (330 yd) north-west of Terazije, central Belgrade. It begins right below the Republic Square and stretches along the short, winding Skadarska Street. One of the most famous streets in Belgrade, it is less than 400 metres (440 yd) long. It connects the Despot Stefan Boulevard with the Dušanova Street, near the Bajloni open green market and the Mira Trailović Square, where it extends into the neighborhood of Dorćol.'
            },
            {
                name: 'Zemunski kej',
                img: 'img/large/kej.jpg',
                img_small: 'img/small/kej.png',
                description: 'Zemun Quay is located on the left side of the Danube. The main walkway, Kej oslobođenja (Quay of Liberation) begins below the Gardoš hill. The promenade is extending parallel to the street Kej oslobođenja. The path continues around the confluence, and makes one continuous pedestrian area toward the Old Fairgrounds (Staro sajmište). In the street Kej oslobođenja in Zemun and nearby streets, you will find verity of restaurants and traditional Serbian kafanas. You should make a reservation in advance.',
                position: {
                    lat: 44.848886,
                    lng: 20.408153
                }
            },
            {
                name: 'Zemun Gardoš',
                img: 'img/large/gaqrdos_night.jpg',
                img_small: 'img/small/gaqrdos_night.png',
                description: '"God created the world in six days and then he went up to the Gardos and got drunk." It is a sentence that proudly recite old Zemun bohemians, that  young people all around Belgrade eagerly accepted. Lively bohemian debate at the restaurant tables is replaced with the all-night joy of  the young people listening old traditional Serbian and Gypsy music, in small inns like “Tri kuma debela “(Three fat godfather),” Kod bake” (At  grandmother’s,) “Ona, a ne neka druga ”(Her and not someone else).  Gardoš is not only known for “tamburaši”, . In the restaurant „Tri lađara”("Three Boatmen")  was born Yugoslavian jazz.',
                position: {
                    lat: 44.848886,
                    lng: 20.408153
                }
            },
            {
                name: 'Strahinjića Bana Street',
                img: 'img/large/strahinjica.jpg',
                img_small: 'img/small/strahinjica.png',
                description: 'Strahinjića Bana Street is a famous street in Dorćol that houses around twenty cafes, restaurants and bars, always filled with loud and cheerful Belgraders. If you like to be in the epicentre of city life, Strahinjića Bana is the place for you.',
                position: {
                    lat: 44.822136,
                    lng: 20.460466
                }
            },
            {
                name: 'Floating river clubs (Splavovi)',
                img: 'img/large/splavovi-u-Beogradu.jpg',
                img_small: 'img/small/splavovi-u-Beogradu.png',
                description: 'The most recognizable nightlife feature of Belgrade is floating river clubs or barges (called “splav” or “splavovi”) that are spread around the banks of the Sava and Danube rivers. In summer, Belgraders take full advantage of the city\'s watery location. In New Belgrade, a row of floating restaurants line the banks of the Danube, starting at the Hotel Jugoslavija. The Sava\'s right bank is the place to head for if you fancy a night clubbing on the water.  At Zemunski kej there are clubs with Serbian popular music (splav Amsterdam, Acapulco, Jimmy’s at Zemunski kej) and with foreign music (clubs on the Sava river like Sound, Freestyler…) .Very nice part of Sava it\'s in New Belgrade and i\'s called Savski Kej (quay). It\'s real hedonistic place during the summer, with lots of boats and weekend cottages. ',
                position: {
                    lat: 44.827942,
                    lng: 20.422812
                }
            },
            {
                name: 'Kafana Tri šešira',
                img: 'img/large/tri_sesira.jpg',
                img_small: 'img/small/tri_sesira.png',
                description: 'Music: tambura players, specific starogradska music (roughly translated as Old Town Music)<br><br>Prices: above average<br><br>Character: restaurant, national dishes, hot and cold appetizers, soups, and traditional specialties from the grill, wide selection of local spirits and rakija.<br><br>Address: Skadarska 29.<br><br>Tel: +381 11 3247501.',
                position: {
                    lat: 44.817939,
                    lng: 20.464498
                }
            },
            {
                name: 'Dva bela goluba',
                img: 'img/large/dva_bela_goluba.jpg',
                img_small: 'img/small/dva_bela_goluba.png',
                description: 'Music: old traditional Serbian.<br><br>Prices: average or little bit above.<br><br>Character: restaurant, traditional dishes of Serbian cuisine and a wide selection of dishes from international cuisine.<br><br>Location: Bulevar Despota Stefana 3<br><br>Tel: +381 11 3239079, +381 65 3187726',
                position: {
                    lat: 44.816877,
                    lng: 20.408153
                }
            },
            {
                name: 'Splav Amsterdam',
                img: 'img/large/splav-amsterdam.jpg',
                img_small: 'img/small/splav-amsterdam.png',
                description: 'Music: different every night, generally rnb, pop, live music.<br><br>Prices: the drinks are priced a little bit above average, the place is great for food as well.<br><br>Type of people: for different generations, but mostly above 20.<br><br>Location: Dunavski Kej, Danube Riverside (near Hotel Jugoslavija),<br><br>New Belgrade Tel: +381 11 3194971',
                position: {
                    lat: 44.827942,
                    lng: 20.422812
                }
            },
            {
                name: 'Splav Acapulco',
                img: 'img/large/acapulco-splav.jpg',
                img_small: 'img/small/acapulco-splav.png',
                description: 'Music: different every night, live music, folk, ex Yugoslavia pop.<br><br>Prices: the drinks are priced a little bit above average.<br><br>Type of people: for everybody<br><br>Location: Dunavski Kej, Danube Riverside (near Hotel Jugoslavija), New Belgrade<br><br>Tel: +381 63 7784760',
                position: {
                    lat: 44.827942,
                    lng: 20.422812
                }
            },
            {
                name: 'Splav Amfora',
                img: 'img/large/splav-amfora.jpg',
                img_small: 'img/small/splav-amfora.png',
                description: 'Music: pop<br><br>Prices: a little bit above average<br><br>Type of people: everybody<br><br>Character: cafe - ideal for chilling out<br><br>Location: Dunavski Kej, Danube Riverside (near Hotel Jugoslavija),New Belgrade<br><br>Tel: +381 11 2699789',
                position: {
                    lat: 44.827942,
                    lng: 20.422812
                }
            },
            {
                name: 'Splav Bibis',
                img: 'img/large/splav-bibis.jpg',
                img_small: 'img/small/splav-bibis.png',
                description: 'Music: different every night, rnb, pop, no folk<br><br>Prices: the drinks are priced a little bit above average.<br><br>Type of people: for different generations<br><br>Character: cafe - ideal during the day as well, great for food as well<br><br>Location: Dunavski Kej, Danube Riverside (near Hotel Jugoslavija), New Belgrade<br><br>Tel: +381 11 3192150',
                position: {
                    lat: 44.827942,
                    lng: 20.422812
                }
            },
            {
                name: 'Splav Monza',
                img: 'img/large/splav-monza.jpg',
                img_small: 'img/small/splav-monza.png',
                description: 'Music: pop, house, acid jazz...<br><br>Type of people: for different generations<br><br>Prices: average<br><br>Character: restaurant - ideal for dining and quick drinks, great food<br><br>Location: Dunavski Kej, Danube Riverside (near Hotel Jugoslavija), New Belgrade<br><br>Tel: +381 11 3190712',
                position: {
                    lat: 44.847396,
                    lng: 20.414314
                }
            },
            {
                name: 'Splav Blaywatch',
                img: 'img/large/splav-blaywatch.jpg',
                img_small: 'img/small/splav-blaywatch.png',
                description: 'Music: rnb, pop, live music but also folk.<br><br>Prices: the drinks are expensive<br><br>Type of people: for younger people under 20<br><br>Character: night club<br><br>Location: Dunavski Kej, Danube Riverside (near Hotel Jugoslavija), New Belgrade<br><br>Tel: +381 11 319 1228',
                position: {
                    lat: 44.847396,
                    lng: 20.414314
                }
            },
            {
                name: 'Splav Sound',
                img: 'img/large/splav-sound.jpg',
                img_small: 'img/small/splav-sound.png',
                description: 'Music: non commercial house.<br><br>Prices: the drinks are priced above average.<br><br>Type of people: everyone, people above 25<br><br>Character: nightclub, great place if you are into all night long partying.<br><br>Location: Brodarska BB, Sava riverside, near Stari savski most (Old Sava bridge), New Belgrade<br><br>Tel: +381 63 807 18 53',
                position: {
                    lat: 44.848886,
                    lng: 20.408153
                }
            },
            {
                name: 'Splav Freestyler',
                img: 'img/large/splav-freestyler.jpg',
                img_small: 'img/small/splav-freestyler.png',
                description: 'Music: commercial house<br><br>Prices: above average<br><br>Type of people: everybody, but mostly for younger people<br><br>Character: nightclub, all night long partying, go-go dancers.<br><br><a href="http://www.freestyler.rs">freestyler.rs</a><br><br>Location: Brodarska BB, Sava riverside, near Stari savski most (Old Sava bridge), New Belgrade<br><br>Tel: +381 62 800 20 20',
                position: {
                    lat: 44.848886,
                    lng: 20.408153
                }
            },
            {
                name: 'Splav Povetarac',
                img: 'img/large/splav-povetarac.jpg',
                img_small: 'img/small/splav-povetarac.png',
                description: 'Music: mainstream music, funk, reggae, drum and bass, rap, rock<br><br>Prices: average<br><br>Type of people: everybody<br><br>Character: old tank which anchored for several decades transformed into high-capacity club that is the only one which is open every day of the year<br><br>Location: Brodarska BB, Sava riverside, near Stari savski most (Old Sava bridge), New Belgrade<br><br>Tel: +381 63 33 33 44',
                position: {
                    lat: 44.807898,
                    lng: 20.444784
                }
            },
            {
                name: 'Splav Exile',
                img: 'img/large/splav-exile.jpg',
                img_small: 'img/small/splav-exile.png',
                description: 'Music: techno, commercial house.<br><br>Prices: the drinks are priced above average<br><br>Type of people: urban young people<br><br>Character: nightclub, all night long partying<br><br>Location: Savski kej bb, Sava riverside, near Stari savski most, New Belgrade',
                position: {
                    lat: 44.809548,
                    lng: 20.445514
                }
            },
            {
                name: 'Splav Cruise',
                img: 'img/large/splav-cruise.jpg',
                img_small: 'img/small/splav-cruise.png',
                description: 'Music: main stream house<br><br>Prices: the drinks are priced a little bit above average<br><br>Type of people: everybody<br><br>Character: cocktail bar, great food but even better cocktails<br><br><a href="http://www.cruise.rs">www.cruise.rs</a><br><br>Location: Block 70, Savski kej BB, New Belgrade<br><br>Tel: +381 11 21 57 510',
                position: {
                    lat: 44.777156,
                    lng: 20.448289
                }
            },
            {
                name: 'Splav Hua Hua',
                img: 'img/large/huahua-splav.jpg',
                img_small: 'img/small/huahua-splav.png',
                description: 'Music: different every night, mostly traditional, folk, turbofolk<br><br>Prices: the drinks are priced a little bit above average<br><br>Type of people: for everybody<br><br>Character: nightclub, afterpaty<br><br>Location: Ada Cigalija, Sava riverside<br><br>Tel: +381 63 239373',
                position: {
                    lat: 44.818772,
                    lng: 20.44517
                }
            },
            {
                name: 'Splav Plastic Jam',
                img: 'img/large/plastic-jam-splav.jpg',
                img_small: 'img/small/plastic-jam-splav.png',
                description: 'Music: progressive house, rnb<br><br>Prices: average<br><br>Type of people: everybody<br><br>Character: nightclub<br><br>Location: Sava riverside, near Brankov most, Tadeuša Košćuškog BB5, Old Town',
                position: {
                    lat: 44.81877,
                    lng: 20.44517
                }
            },
            {
                name: 'Club Magacin',
                img: 'img/large/club-magacin.jpg',
                img_small: 'img/small/club-magacin.png',
                description: 'Music: pop and folk music, DJ’s, house music<br><br>Prices: above average<br><br>Type of people: everybody, only older than 21<br><br>Character: nightclub<br><br><a href="http://www.clubmagacin.com">www.clubmagacin.com</a><br><br>Location: Sava port, Beton hala',
                position: {
                    lat: 44.820074,
                    lng: 20.447976
                }
            },
            {
                name: 'Club Mr Stefan Braun',
                img: 'img/large/club-braun.jpg',
                img_small: 'img/small/club-braun.png',
                description: 'Music: house, r’n’b, hip hop, 90s<br><br>Prices: above average<br><br>Type of people: everybody, mostly young people around 20is<br><br>Character: nightclub<br><br><a href="http://www.mrstefanbraun.rs">www.mrstefanbraun.rs</a><br><br>Location: Nemanjina Street 4, ninth floor<br><br>Tel: +381 65 5566456',
                position: {
                    lat: 44.792435,
                    lng: 20.427449
                }
            },
            {
                name: 'Club Time Out',
                img: 'img/large/club-timeout.jpg',
                img_small: 'img/small/club-timeout.png',
                description: 'Ada Ciganlija, Makiška strana, lokal 6,<br><br><a href="http://www.clubtimeout.rs">clubtimeout.rs</a><br><br>381 65 68 68 68 8; +381 60 366 355 6',
                position: {
                    lat: 44.782427,
                    lng: 20.389606
                }
            },
            {
                name: 'Red shoes caffe',
                img: 'img/large/club-red-shoes.jpg',
                img_small: 'img/small/club-red-shoes.png',
                description: 'Ada Ciganlija, Makiška strana, lokal 7<br><br>+381 64 110 38 66<br><br><a href="http://www.redshoescafe.rs">www.redshoescafe.rs</a>',
                position: {
                    lat: 44.782371895409014,
                    lng: 20.38965095433923
                }
            },
            {
                name: 'Sunset caffe',
                img: 'img/large/club-sunset.jpg',
                img_small: 'img/small/club-sunset.png',
                description: 'Ada Ciganlija, Makiška strana, lokal 9<br><br><a href="http://www.sunset.rs">www.sunset.rs</a><br><br>+381 63 807-3210',
                position: {
                    lat: 44.782139,
                    lng: 20.389316
                }
            },
            {
                name: 'Big Dill Jazz Club',
                img: 'img/large/jazz.jpg',
                img_small: 'img/small/jazz.png',
                description: 'If you\'re a jazz fan you will find excellent jazz clubs in Belgrade. Although there are not that many jazz clubs in Belgrade, still you can hear great live Jazz performance in many, not strictly Jazz clubs.<br><br>Resavska 32, Belgrade<br><br>+381 11 3231302',
                position: {
                    lat: 44.8047087,
                    lng: 20.4620978
                }
            },
            {
                name: 'Club Havana',
                img: 'img/large/club-havana.jpg',
                img_small: 'img/small/club-havana.png',
                description: 'Latin music is very popular in Belgrade, so all fans of this kind of music have the opportunity to dance along with its favorite Latin rhythms.<br><br>Nikole Spasića 1<br><br>+381 64 01 333 00',
                position: {
                    lat: 44.8182626,
                    lng: 20.4544052
                }
            }
        ],
        shopping: [
            {
                name: 'Knez Mihailova Street',
                img: 'img/large/Knez_Mihailova_Street.jpeg',
                img_small: 'img/small/Knez_Mihailova_Street.png',
                description: 'Until couple of years ago, Knez Mihailova was the main shopping zone of the city. Although now Belgradians predominantly shop in shopping malls, there is something special about shopping in Knez Mihailova. While strolling down the hectic street you can visit shops of famous brands like Gap, Max Mara, Zara, Diesel, Miss Sixty, Springfield... There are also few bookstores. During the shopping you can take a coffee break in numerous cafes and snack bars.',
                position: {
                    lat: 44.817813,
                    lng: 20.456905
                }
            },
            {
                name: 'UŠĆE Shopping Center',
                img: 'img/large/Usce_Shopping_Center.jpg',
                img_small: 'img/small/Usce_Shopping_Center.png',
                description: 'UŠĆE Shopping Center is the biggest shopping center in Serbia. 137 various shops, restaurants, bars, game room, a supermarket, a multiplex cinema, bowling and lottery games are located on six levels and 50,000 square meters of commercial space. After shopping, you can freshen up in one of the cozy cafes or restaurants and enjoy various dishes and outstanding service. It is open seven days in a week from10 a.m. to 10 p.m. and it has a free parking space. <br><br>Bus lines: 15, 16, 65, 71, 72, 75, 77, 78, 83, 84, 95, 704, 706, 707, E1, E6. Tram lines: 7, 7L, 9, 13 <br>Address: Bulevar Mihajla Pupina 4,<br>New Belgrade <br><a href="http://www.usceshoppingcenter.com/">www.usceshoppingcenter.com</a>',
                position: {
                    lat: 44.815464,
                    lng: 20.437137
                }
            },
            {
                name: 'Delta City',
                img: 'img/large/Delta_City.jpg',
                img_small: 'img/small/Delta_City.png',
                description: 'Delta City is situated in New Belgrade, on the corner of Jurija Gagarina Street and Dr.Agostina Neta Street. In its beautiful and modern ambient, numerous visitors may find fun during working days, on weekends and holidays – seven days in a week, from 10 a.m. till 10 p.m.  Complex includes free parking space. <br><br>Buses lines: 60, 68, 73, 94, 95, E1, E6. Tram lines: 7, 7L, 9,11. <br>Street: Jurija Gagarina 16,<br>New Belgrade <br><a href="http://www.deltacity.rs/">www.deltacity.rs</a>',
                position: {
                    lat: 44.805407,
                    lng: 20.405139
                }
            },
            {
                name: 'Fashion Park Outlet Center Inđija',
                img: 'img/large/Fashion_Park_Outlet_Center_Indjija.jpg',
                img_small: 'img/small/Fashion_Park_Outlet_Center_Indjija.png',
                description: 'Inđija je located 42 km from Belgrade (E-75 Highway: Belgrade-Novi Sad, M22/1 Freeway Belgrade-Novi Sad-Subotica and E-70 Highway: Belgrade-Zagreb), and 36 km from Novi Sad (M22/1 Freeway and E-75 Highway: Belgrade-Novi Sad-Budapest). You can reach Inđija Outlet Center by bus, there is bus station "Lasta" (Sonje Marinković bb) or by train, railway lines Belgrade-Novi Sad-Subotica-Budapest and Belgrade–Zagreb-Ljubljana are passing through Inđija (Railway station in Inđija: Železnička 9). Fashion Park Outlet Center offers famous global brands at 30 to 70% discount prices. Fashion Park Outlet Center offers you top quality footwear, apparel, jeans and fashion accessories, along with selected restaurants, cafés and amusement park. Fashion Park Outlet Center is open daily between 10 a.m. and 9 p.m. and offers 1.200 free parking spaces.<br><br>Address: Vojvode Putnika bb<br>22320 Inđija<br><a href="http://www.fashionparkoutlet.rs/">www.fashionparkoutlet.rs</a>',
                position: {
                    lat: 45.069171,
                    lng: 20.135962
                }
            },
            {
                name: 'Markets (Pijace)',
                img: 'img/large/pijaca_zeleni_venac.jpg',
                img_small: 'img/small/pijaca_zeleni_venac.png',
                description: 'What make Belgrade so special are also Belgrade’s markets. Belgradians love to purchase food, fruits and vegetables at vibrant and colourful markets. In addition to fruits and vegetables, you can buy cheese, eggs, honey, meat and fish there. Everything you buy there is organic. Markets are open from 6-19h. The biggest markets in Belgrade are Bajloni’s market (Bajlonjeva pijaca), Kalenic’s market (Kalenićeva pijaca), Cvetko’s market (Cvetkova pijaca), Đeram market (Đeram pijaca), Zeleni Venac market (pijaca Zeleni venac). <br><a href="http://www.bgpijace.rs">www.bgpijace.rs</a>',
            },
            {
                name: 'Stadium Shopping Center',
                img: 'img/large/Stadium_Shopping_Center.jpg',
                img_small: 'img/small/Stadium_Shopping_Center.png',
                description: 'It’s the fourth building in Europe on whose roof is located entire football field with stands that can accommodate 5,000 spectators. Stadium Shopping Center was built in accordance with modern standards of UEFA. Retail part of the center is 28,000 square meters where you can find the best known international and domestic brands, famous restaurants and various entertainment facilities. With two levels of underground parking with 800 places, mostly retail and football stadium, this shopping center is one of the largest in the old part of the city. On the third floor next to the wellness center on the area of 1,220 square meters, is located in an exclusive area with terrace offering amazing views of the entire city.<br><a href="http://stadionsc.rs/">www.stadionsc.rs</a>',
                position: {
                    lat: 44.774909,
                    lng: 20.490027
                }
            }
        ]
,    }
})