// Path Drawing Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Path Drawing Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the hero reaches the goal.
//             MUSIC: Loops in the background.
//			   OBSTACLE_HIT: Plays when the path enters the hotspot of an obstacle.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//     bumpers
//         Properties:
//             top: Y location of the bumper on the top 
//             bottom: Y location of the bumper on the bottom in relation to the bottom of the screen
//             left: X location of the bumper on the left
//             right: X location of the bumper on the right in relation to the right side of the screen
//             hudWidth: Width of the rectangle in the top right hand corner of the screen.
//             hudHeight: Height of the rectangle in the top right hand corner of the screen.
//         
// Round Properties
//
//     pathColor: The color (in hex e.g. #ff0000 for red) of the path drawn.
//     background
//         Properties:
//            filename: Filename of the background image.
//     hero
//         Properties:
//             startX: Start x position of the hero.
//             startY: Start y position of the hero.
//             speed: Number of pixels the hero moves each frame when moving along the path.
//         Available States:
//             DEFAULT: Only currently supported state.
//     goal
//         Available States:
//             DEFAULT: Initial state of the goal.
//             GOAL: Displayed when the hero reaches the goal.
//     groups (Array): An array of obstacle groups. One set of obstacles will be randomly chosen each round.
//         obstacles
//             Available States:
//                 DEFAULT: Only currently supported state.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "mozilla_thumb_256x256_BertsPigeonPath.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-pathDrawing-bernice.jpg",
	audioEnabled: true,
	audioFilename: "audio-pathDrawing-bernice.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "payoff",
				startTime: 4,
				duration: 1.1
			},
			{
				name: "music", 
				startTime: 16,
				duration: 25.6,
				loop: true
			}
		]
	},
	bumpers: {
		top: 20,
		bottom: -20,
		left: 20,
		right: -20,
		hudWidth: 100,
		hudHeight: 90
	},
	hint: {
		color: "#ffea00",
		speed: 5,
		width: 30, //width of the line itself. Makes the dots get bigger
		dashWidth: 1, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 50 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 0,
						duration: 3.3
					}
				]
			},
			pathColor: "#98ca4c",
			background: {
				filename: "Background-Bert-Pigeon.png"
			},
			hero: { //the object being moved down the path
				type: "Hero",
				startX: 110,
				startY: 232,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Pigeon.png",
						offsetX: -50, //starting position of the object
						offsetY: -100,
						hotspots: [
							{ x: -100, y: -140, width: 200, height: 200 } //hotspot position and size
						]
					}, {
						type: "Move",
						filename: "bernice_walkcycle_spritesheet_152x128.png",
						offsetX: -50, 
						offsetY: -100,
						numFrames: 14,
						loop: true
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 805,
				startY: 260,
				states: [
					{
						type: "Default",
						filename: "Bert.png",
						hotspots: [
							{ x: 60, y: 0, width: 140, height: 100 },
							{ x: 0, y: 100, width: 320, height: 340 },
							{ x: -120, y: 160, width: 320, height: 240 }
						]
					}, {
						type: "Goal",
						filename: "bernice_payoff_lv1_spritesheet_350x465.png",
						offsetX: -126,
						offsetY: -9,
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{}]
		},
		{ //Round 2
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 6,
						duration: 5.5
					}
				]
			},
			pathColor: "#98ca4c",
			background: {
				filename: "Background-Bert-Pigeon.png"
			},
			hero: { //the object being moved down the path
				type: "Hero",
				startX: 110,
				startY: 232,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Pigeon.png",
						offsetX: -50, //starting position of the object
						offsetY: -100,
						hotspots: [
							{ x: -100, y: -140, width: 200, height: 200 } //hotspot position and size
						]
					}, {
						type: "Move",
						filename: "bernice_walkcycle_spritesheet_152x128.png",
						offsetX: -50, 
						offsetY: -100,
						numFrames: 14,
						loop: true
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 805,
				startY: 260,
				states: [
					{
						type: "Default",
						filename: "Bert.png",
						hotspots: [
							{ x: 60, y: 0, width: 140, height: 100 },
							{ x: 0, y: 100, width: 320, height: 340 },
							{ x: -120, y: 160, width: 320, height: 240 }
						]
					}, {
						type: "Goal",
						filename: "bernice_payoff_lv2_spritesheet_350x465.png",
						offsetX: -126,
						offsetY: -9,
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [ //randomly chooses from 1 of the 3 obstacles below
					{
						type: "Obstacle",
						startX: 200, //these x,y positions can be obtained from the original AI or PSD file using the top left corner as point of reference
						startY: 200,
						states: [
							{
								type: "Default",
								filename: "Bike.png",
								hotspots: [
									{ x: 80, y: 10, width: 160, height: 70 },
									{ x: 0, y: 80, width: 316, height: 130 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 380,
						startY: 280,
						states: [
							{
								type: "Default",
								filename: "Picnic-Basket.png"
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 450,
						startY: 280,
						states: [
							{
								type: "Default",
								filename: "Picnic-Basket.png"
							}
						]
					}
				]
			}]
		},
		{ //Round 3
			pathColor: "#98ca4c",
			background: {
				filename: "Background-Bert-Pigeon.png"
			},
			hero: { //the object being moved down the path
				type: "Hero",
				startX: 110,
				startY: 232,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Pigeon.png",
						offsetX: -50, //starting position of the object
						offsetY: -100,
						hotspots: [
							{ x: -100, y: -140, width: 200, height: 200 } //hotspot position and size
						]
					}, {
						type: "Move",
						filename: "bernice_walkcycle_spritesheet_152x128.png",
						offsetX: -50, 
						offsetY: -100,
						numFrames: 14,
						loop: true
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 805,
				startY: 260,
				states: [
					{
						type: "Default",
						filename: "Bert.png",
						hotspots: [
							{ x: 60, y: 0, width: 140, height: 100 },
							{ x: 0, y: 100, width: 320, height: 340 },
							{ x: -120, y: 160, width: 320, height: 240 }
						]
					}, {
						type: "Goal",
						filename: "bernice_payoff_lv3_spritesheet_350x465.png",
						offsetX: -126,
						offsetY: -9,
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 32,
						startY: 422,
						states: [
							{
								type: "Default",
								filename: "Tricycle.png",
								hotspots: [
									{ x: 90, y: 0, width: 60, height: 60 },
									{ x: 0, y: 60, width: 200, height: 120 }
								]
							}
						]
					},
					{
						type: "Obstacle",
						startX: 500,
						startY: 231,
						states: [
							{
								type: "Default",
								filename: "Basketball.png"
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 600,
						startY: 240,
						states: [
							{
								type: "Default",
								filename: "Skateboard.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 32,
						startY: 422,
						states: [
							{
								type: "Default",
								filename: "Tricycle.png",
								hotspots: [
									{ x: 90, y: 0, width: 60, height: 60 },
									{ x: 0, y: 60, width: 200, height: 120 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 322,
						startY: 480,
						states: [
							{
								type: "Default",
								filename: "Skateboard.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 453,
						startY: 131,
						states: [
							{
								type: "Default",
								filename: "Basketball.png"
							}
						]
					}
				]
			}]
		},
		{ //Round 4
			pathColor: "#98ca4c",
			background: {
				filename: "Background-Bert-Pigeon.png"
			},
			hero: { //the object being moved down the path
				type: "Hero",
				startX: 110,
				startY: 232,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Pigeon.png",
						offsetX: -50, //starting position of the object
						offsetY: -100,
						hotspots: [
							{ x: -100, y: -140, width: 200, height: 200 } //hotspot position and size
						]
					}, {
						type: "Move",
						filename: "bernice_walkcycle_spritesheet_152x128.png",
						offsetX: -50, 
						offsetY: -100,
						numFrames: 14,
						loop: true
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 805,
				startY: 260,
				states: [
					{
						type: "Default",
						filename: "Bert.png",
						hotspots: [
							{ x: 60, y: 0, width: 140, height: 100 },
							{ x: 0, y: 100, width: 320, height: 340 },
							{ x: -120, y: 160, width: 320, height: 240 }
						]
					}, {
						type: "Goal",
						filename: "bernice_payoff_lv4_spritesheet_375x465.png",
						offsetX: -126,
						offsetY: -9,
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 753,
						startY: 130,
						states: [
							{
								type: "Default",
								filename: "Soccer-Ball.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 322,
						startY: 224,
						states: [
							{
								type: "Default",
								filename: "Trash-Can.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 38,
						startY: 475,
						states: [
							{
								type: "Default",
								filename: "Umbrella.png",
								hotspots: [
									{ x: 0, y: 0, width: 100, height: 90 },
									{ x: 0, y: 90, width: 160, height: 50 }
								]
							}
						]
					}
				]
			},
			{
				obstacles: [
					{
						type: "Obstacle",
						startX: 484,
						startY: 374,
						states: [
							{
								type: "Default",
								filename: "Fire-Hydrant.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 753,
						startY: 130,
						states: [
							{
								type: "Default",
								filename: "Soccer-Ball.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 38,
						startY: 475,
						states: [
							{
								type: "Default",
								filename: "Umbrella.png",
								hotspots: [
									{ x: 0, y: 0, width: 100, height: 90 },
									{ x: 0, y: 90, width: 160, height: 50 }
								]
							}
						]
					}
				]
			},
			{
				obstacles: [
					{
						type: "Obstacle",
						startX: 484,
						startY: 374,
						states: [
							{
								type: "Default",
								filename: "Fire-Hydrant.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 753,
						startY: 130,
						states: [
							{
								type: "Default",
								filename: "Soccer-Ball.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 122,
						startY: 424,
						states: [
							{
								type: "Default",
								filename: "Trash-Can.png"
							}
						]
					}
				]
			}]
		},
		{ //Round 5
			pathColor: "#98ca4c",
			background: {
				filename: "Background-Bert-Pigeon.png"
			},
			hero: { //the object being moved down the path
				type: "Hero",
				startX: 110,
				startY: 232,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Pigeon.png",
						offsetX: -50, //starting position of the object
						offsetY: -100,
						hotspots: [
							{ x: -100, y: -140, width: 200, height: 200 } //hotspot position and size
						]
					}, {
						type: "Move",
						filename: "bernice_walkcycle_spritesheet_152x128.png",
						offsetX: -50, 
						offsetY: -100,
						numFrames: 14,
						loop: true
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 805,
				startY: 260,
				states: [
					{
						type: "Default",
						filename: "Bert.png",
						hotspots: [
							{ x: 60, y: 0, width: 140, height: 100 },
							{ x: 0, y: 100, width: 320, height: 340 },
							{ x: -120, y: 160, width: 320, height: 240 }
						]
					}, {
						type: "Goal",
						filename: "bernice_payoff_lv5_spritesheet_375x465.png",
						offsetX: -126,
						offsetY: -9,
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 702,
						startY: 120,
						states: [
							{
								type: "Default",
								filename: "Basketball.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 30,
						startY: 290,
						states: [
							{
								type: "Default",
								filename: "Trash-Can.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 200,
						startY: 451,
						states: [
							{
								type: "Default",
								filename: "Tricycle.png",
								hotspots: [
									{ x: 90, y: 0, width: 60, height: 60 },
									{ x: 0, y: 60, width: 200, height: 120 }
								]
							}
						]
					},
					{
						type: "Obstacle",
						startX: 496,
						startY: 370,
						states: [
							{
								type: "Default",
								filename: "Umbrella-2.png",
								hotspots: [
									{ x: 0, y: 10, width: 160, height: 70 },
									{ x: 80, y: 80, width: 40, height: 100 }
								]
							}
						]
					}
				]
			},
			{
				obstacles: [
					{
						type: "Obstacle",
						startX: 702,
						startY: 120,
						states: [
							{
								type: "Default",
								filename: "Basketball.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 391,
						startY: 275,
						states: [
							{
								type: "Default",
								filename: "Skateboard-2.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 30,
						startY: 290,
						states: [
							{
								type: "Default",
								filename: "Trash-Can.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 230,
						startY: 470,
						states: [
							{
								type: "Default",
								filename: "Tricycle.png",
								hotspots: [
									{ x: 90, y: 0, width: 60, height: 60 },
									{ x: 0, y: 60, width: 200, height: 120 }
								]
							}
						]
					}
				]
			},
			{
				obstacles: [
					{
						type: "Obstacle",
						startX: 702,
						startY: 120,
						states: [
							{
								type: "Default",
								filename: "Basketball.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 391,
						startY: 275,
						states: [
							{
								type: "Default",
								filename: "Skateboard-2.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 30,
						startY: 290,
						states: [
							{
								type: "Default",
								filename: "Trash-Can.png"
							}
						]
					},
					{
						type: "Obstacle",
						startX: 296,
						startY: 490,
						states: [
							{
								type: "Default",
								filename: "Umbrella-2.png",
								hotspots: [
									{ x: 0, y: 10, width: 160, height: 70 },
									{ x: 80, y: 80, width: 40, height: 100 }
								]
							}
						]
					}
				]
			}]
		}
	]
};