//precision highp float;
precision mediump float;
//precision lowp float;

#include <PhotoshopMath.incl.fshader>

uniform sampler2D image;
uniform sampler2D texture;
varying vec2 src_position;  // from the vertex shader
uniform float amount;
uniform int blend_mode;

void main()
{

	vec3 image_color   = texture2D(image, src_position).xyz;
	vec3 texture_color = texture2D(texture, src_position).xyz;
	vec3 color;

	color = mix(image_color, BlendSoftLight(image_color, texture_color), amount);

	// Final
	gl_FragColor = vec4(color, 1.0);
}