/**
 * @filter         Vignette
 * @description    Adds a simulated lens edge darkening effect.
 * @param size     0 to 1 (0 for center of frame, 1 for edge of frame)
 * @param amount   0 to 1 (0 for no effect, 1 for maximum lens darkening)
 */

//precision highp float;
precision mediump float;
//precision lowp float;

uniform sampler2D image;

varying vec2 src_position;

uniform float size;
uniform float amount;

void main() {
    vec4 color = texture2D(image, src_position);
    
    float dist = distance(src_position, vec2(0.5, 0.5));

    if (amount > 0.0) {
    	/* whiten */
        color.rgb += 1.0 - smoothstep(0.8, size * 0.799, dist * (amount + size));
    } else {
    	/* darken */
        color.rgb *= smoothstep(-0.8, size * 0.799, dist * (amount + size));
    }
    
    gl_FragColor = color;
}