this.inputColor = 0;
this.step = 1;

window.addEventListener("load", function() {
	var lock = window.navigator.requestWakeLock('screen');
	startup();
  changeColor();
});

//String.prototype.replaceAt=function(index, character) {
//    return this.substr(0, index) + character + this.substr(index+character.length);
//}

function startup() {
  var el = document.getElementsByTagName("body")[0];
	var clickEvent = ('ontouchstart' in window ? 'touchend' : 'click');
  el.addEventListener(clickEvent, onScreenTouch, false);
}

function onScreenTouch() {
	var el = document.getElementsByTagName("body")[0];
	el.preventDefault();
	document.getElementsByTagName("body")[0].style.backgroundColor = hexToStrColor(this.inputColor);
}

function hexToStrColor(inputColor) {
		var newColor = inputColor.toString(16);
    newColor = '#' + (new Array(7-newColor.length).join(0)) + newColor;

    if(/^#[0-9a-f]{6}$/i.test(newColor)){
      return newColor;
    }
}

function nextColor() {
  this.inputColor = parseInt(this.inputColor.toString(16), 16);
  if(!isNaN(this.step) && !isNaN(this.inputColor)){ 
		
    this.inputColor += this.step;    
    return hexToStrColor(this.inputColor);
  }
  return this.inputColor;
};

function changeColor() {
	this.inputColor = parseInt('000000', 16);
	function go() {
		try {
			var newColor = nextColor();
			if(newColor == '#ff0000'){
				this.inputColor = parseInt('000000', 16);
				this.step = 1;
			}
			document.getElementsByTagName("body")[0].style.backgroundColor = newColor;
			if(this.inputColor == 256){
				this.step = 256;
			} else if (this.inputColor == 65536){
				this.step = 65536;
			}

			if(this.inputColor < 16842751){
				setTimeout(go,27);
			}
		} catch (e){
			console.log('Error is' + e);
		}
	}
	go();
};