angular.module('bhoganti')

    .controller('BrandCtrl', ['$scope', '$routeParams', 'Backend', 'SelectedTab', 'Status', function($scope, $routeParams, Backend, SelectedTab, Status) {
        SelectedTab.activate('brand');

        $scope.items = [];
        var busy = false;
        var pageNumber = 0;
        var numberOfComments = 0;
        var limit_of_comments = 0;

        // view brand
        var brandId = $routeParams.brandId;

        if (typeof brandId != 'undefined') {
            Backend.viewBrand(brandId).then(function (brand) {
                $scope.brand = brand;
            });

            Backend.paginationInfo(brandId).then(function (pagination) {
                numberOfComments = pagination.total;
                limit_of_comments = pagination.limit;
            });

            Backend.showComments(brandId, pageNumber).then(function (comments) {
                $scope.comments = comments;
                pageNumber++;
            });
        }

        $scope.brands = [];
        $scope.comments = [];

        var searchTimer;
        $scope.progressActivity = false;
        $scope.brandSuggests = [];
        $scope.noSearchResults = false;

        $scope.searchBrand = function(delay) {
            clearTimeout(searchTimer);

            if (typeof $scope.keyword == 'undefined') {
                $scope.progressActivity = false;
                $scope.brandSuggests = [];
                $scope.noSearchResults = false;

                return;
            }

            searchTimer = setTimeout(function() {
                $scope.progressActivity = true;
                $scope.brandSuggests = [];
                $scope.noSearchResults = false;

                Backend.searchBrand($scope.keyword).then(function(brands) {
                    $scope.progressActivity = false;
                    $scope.brandSuggests = brands;

                    if (brands.length == 0) {
                        $scope.noSearchResults = true;
                    }
                });
            }, delay ? 600 : 0);
        };

        $scope.showBrandsAverageRating = function(brandId){
            if (typeof brandId != 'undefined') {
                Backend.viewBrand(brandId).then(function (brand) {
                    $scope.brand = brand;
                });
            }
        };

        var noMoreCommentsFlag = false;
        $scope.showBrand = function(brandId) {
            $scope.brandSuggests = [];

            if (typeof brandId != 'undefined') {

                if (numberOfComments - ( pageNumber * limit_of_comments ) > 0){

                    if (busy) {
                        return;
                    }

                    busy = true;
                    Status.show('Loading Data...');

                    Backend.showComments(brandId, pageNumber).then(function (comments) {
                        var newComments = comments;
                        for (var i = 0;  i < newComments.length; i++){
                            $scope.comments.push(newComments[i]);
                        }
                        busy = false;
                        pageNumber++;
                    });
                } else if (!noMoreCommentsFlag) {
                    noMoreCommentsFlag = true;
                    Status.show('No more comments to show...');
                }
            }
        };

    }])

    .directive('whenScrolled', function() {
        return function(scope, elm, attr) {
            var raw = elm[0];

            elm.bind('scroll', function() {
                if (raw.scrollTop + raw.offsetHeight >= raw.scrollHeight) {
                    scope.$apply(attr.whenScrolled);
                }
            });
        };
    })

;
