angular.module('bhoganti')

    .controller('CommentCtrl', ['$scope', '$location', 'Backend', 'SelectedTab', 'Status', function($scope, $location, Backend, SelectedTab, Status) {
        SelectedTab.activate('comment');

        $scope.hasBackgroundActivity = false;

        $scope.device = {
            uid: localStorage.getItem('uid'),
            username: localStorage.getItem('username')
        };

        $scope.brand = {
            name: ''
        };

        $scope.comment = {
            rating: 3,
            text: '',
            is_anonymous: true
        };

        var searchTimer;
        $scope.brandSuggests = [];
        $scope.searchBrand = function() {
            clearTimeout(searchTimer);

            if ($scope.brand.name == '') {
                $scope.hasBackgroundActivity = false;
                $scope.brandSuggests = [];

                return;
            }

            searchTimer = setTimeout(function() {
                $scope.hasBackgroundActivity = true;
                $scope.brandSuggests = [];

                Backend.searchBrand($scope.brand.name).then(function(brands) {
                    $scope.hasBackgroundActivity = false;
                    $scope.brandSuggests = brands;
                });
            }, 600);
        };

        $scope.selectBrand = function(name) {
            $scope.brand.name = name;
            $scope.brandSuggests = [];
        };

        $scope.postComment = function(){
            if (!$scope.brand.name) {
                Status.show('Please enter a brand name');
                return;
            }

            if (!$scope.comment.text) {
                Status.show('Please enter a comment');
                return;
            }

            $scope.hasBackgroundActivity = true;
            Backend.createComment($scope.device, $scope.brand, $scope.comment)
                .then(function(resp) {
                    $scope.hasBackgroundActivity = false;
                    if (!$scope.comment.is_anonymous) {
                        localStorage.setItem('username', $scope.device.username);
                    }

                    Status.show('আপনার ভোগান্তি সফলভাবে পোষ্ট করা হয়েছে ');

                    $location.path('/brand/'+ resp.brand.id);
                }, function(resp) {
                    $scope.hasBackgroundActivity = false;
                    Status.show(resp.data.message);
                })
            ;
        }
    }])

;
