angular.module('bhoganti')

    .controller('CompareCtrl', ['$scope', 'Backend', 'BrandComparisons', 'SelectedTab', function($scope, Backend, BrandComparisons, SelectedTab) {
        SelectedTab.activate('compare');

        var brandIds = [];
        $scope.brands = BrandComparisons;

        var searchTimer;
        $scope.progressActivity = false;
        $scope.brandSuggests = [];
        $scope.noSearchResults = false;

        $scope.searchBrand = function(delay) {
            clearTimeout(searchTimer);

            if (typeof $scope.keyword == 'undefined') {
                $scope.progressActivity = false;
                $scope.brandSuggests = [];
                $scope.noSearchResults = false;

                return;
            }

            searchTimer = setTimeout(function() {
                $scope.progressActivity = true;
                $scope.brandSuggests = [];
                $scope.noSearchResults = false;

                Backend.searchBrand($scope.keyword).then(function(brands) {
                    $scope.progressActivity = false;
                    $scope.brandSuggests = brands;

                    if (brands.length == 0) {
                        $scope.noSearchResults = true;
                    }
                });
            }, delay ? 600 : 0);
        };

        $scope.addBrand = function(brand) {
            $scope.brandSuggests = [];

            if (brandIds.indexOf(brand.id) > -1) {
                return;
            }

            if ($scope.brands.length == 3) {
                brandIds.pop();
                $scope.brands.pop();
            }

            brandIds.unshift(brand.id);
            $scope.brands.unshift(brand);
        };

        $scope.removeBrand = function(brand) {
            var index = brandIds.indexOf(brand.id);

            brandIds.splice(index, 1);
            $scope.brands.splice(index, 1);
        }
    }])

;
