angular.module('bhoganti')

    .controller('SplashCtrl', ['$scope', '$location', '$timeout', 'Backend', function($scope, $location, $timeout, Backend) {
        var isRegistered;

        if (localStorage.getItem('uid')) {
            isRegistered = true;
        } else {
            Backend.registerDevice().then(function(device) {
                localStorage.setItem('uid', device.uid);
                localStorage.setItem('username', device.username);

                isRegistered = true;
            });
        }

        var redirect = function() {
            if (isRegistered) {
                $location.path('/comment');
            } else {
                $timeout(function() {
                    redirect();
                }, 200);
            }
        };

        $timeout(function() {
            redirect();
        }, 3000);
    }])

;
