angular.module('bhoganti', ['ngRoute', 'ngAnimate'])

    .config(['$routeProvider', function($routeProvider) {
        $routeProvider
            .when('/', {
                controller: 'SplashCtrl',
                templateUrl: "tpl/splash.html"
            })
            .when('/comment', {
                controller: 'CommentCtrl',
                templateUrl: "tpl/comment.html"
            })
            .when('/compare', {
                controller: 'CompareCtrl',
                templateUrl: "tpl/compare.html"
            })
            .when('/brand', {
                controller: 'BrandCtrl',
                templateUrl: "tpl/brand.html"
            })
            .when('/brand/:brandId', {
                controller: 'BrandCtrl',
                templateUrl: "tpl/brand.html"
            })
            .otherwise({
                redirectTo: '/comment'
            })
        ;
    }])

    .config(['$compileProvider', function($compileProvider) {
        $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|app):/);
    }])

    .filter('translateNumber', function() {
        return function(input) {
            return input
                .replace('0', '০', 'g')
                .replace('1', '১', 'g')
                .replace('2', '২', 'g')
                .replace('3', '৩', 'g')
                .replace('4', '৪', 'g')
                .replace('5', '৫', 'g')
                .replace('6', '৬', 'g')
                .replace('7', '৭', 'g')
                .replace('8', '৮', 'g')
                .replace('9', '৯', 'g')
            ;
        }
    })

    .run(['$rootScope', function($rootScope) {
        $rootScope.slide = function(transition) {
            $rootScope.transitionClass = 'slide-'+ transition;
        };
    }])

    .factory('BrandComparisons', function() {
        return [];
    })

    .factory('SelectedTab', function() {
        return {};
    })

    .factory('Status', function() {
        return {};
    })

    .service('Backend', ['$http', 'config', function($http, config) {
        return {
            registerDevice: function() {
                return $http
                    .get(config.appBaseUrl + '/api/device/register')
                    .then(function(resp) {
                        return resp.data.data;
                    })
                ;
            },

            createComment: function(device, brand, comment) {
                return $http
                    .post(config.appBaseUrl +'/api/comment/create', {
                        device: device,
                        brand: brand,
                        comment: comment
                    })
                    .then(function(resp) {
                        return resp.data.data;
                    })
                ;
            },

            searchBrand: function(keyword) {
                return $http
                    .get(config.appBaseUrl +'/api/brand/search?keyword='+ keyword)
                    .then(function(resp) {
                        return resp.data.data.brands;
                    })
                ;
            },

            viewBrand: function(brandId) {
                return $http
                    .get(config.appBaseUrl +'/api/brand/'+ brandId +'/view')
                    .then(function(resp) {
                        return resp.data.data;
                    })
                ;
            },

            showComments: function(brandId, page) {
                return $http
                    .get(config.appBaseUrl +'/api/brand/'+ brandId +'/comments?page=' + page)
                    .then(function(resp) {
                        return resp.data.data.comments;
                    })
                ;
            },

            paginationInfo: function(brandId) {
                return $http
                    .get(config.appBaseUrl +'/api/brand/'+ brandId +'/comments')
                    .then(function(resp) {
                        return resp.data.data.pagination;
                    })
                ;
            }
        };
    }])

;
