/**
 * This loads hardcoded data for testing purposes.
 * @returns Storage
 */
function loadTestdata() {
  var s = new RAMStorage();

  var abraham = new Person();
  abraham.id = "P1";
  abraham.name = "Abraham";
  abraham.descr = "Founding father of Isreal";
  s.add(abraham);
  var sarah = new Person();
  sarah.id = "P2";
  sarah.name = "Sarah";
  s.add(sarah);
  var isaac = new Person();
  isaac.id = "P3";
  isaac.name = "Isaac";
  isaac.descr = "One of the founding fathers of Isreal.\nsjödfg hösdfhg ösljdkg öksjdhg kjösdhf gkjsdhfgkjahgökjh sdgfh seflgasldfg alskj fljakösdgf lkjasgdf lkajsgdf lkjashd fökjash dfk jöa shdkföjhaskldjf haslökdjf haksjd hfalkjs dhfakjs hfdakjs hdfakj shdf öakjsh paw4euhf uahrg öarhg ökjashg ökajsg hakjs ghöakjfhg ökajfg öakjhf göajfhg öakjhfg ökja shfdgökjahsöfdg haöfg höafg höajg höajk ghöajhfgöaj hfgöjash dfögh asödfjg haöfjg höajfg höasjfdg öadjfhgöadhf göaljg höahgö ahfg öajdfhgö ah fdgö ahfd göahfd göajhfg öajhf göhafdögj ahfög haöfdg haöfg höadhg aöfdg haöjf ghöahfg öafjg höahfg öajdf hgöag hdfgsh bkdgh sdfg";
  s.add(isaac);
  var isaacPromised = new Event();
  isaacPromised.id = "E1";
  isaacPromised.name = "Jehovah promises a son for Abraham";
  isaacPromised.descr = "Jehovah promises to bless all nations through Abraham's seed. Although Abraham grows very old, Jehovah upholds his promise. Abraham believes in it, despite the circumstances and lack of physical indications.";
  isaacPromised.time = new Date(-2600, 1, 1);
  s.add(isaacPromised);
  var isaacBorn = new Event();
  isaacBorn.id = "E2";
  isaacBorn.name = "Isaac is born";
  isaacBorn.descr = "Although Sarah is very old, probably 90 years or more, she has a healthy son. She is very happy, because she had been sad about her childlessness since many years. More importantly, Jehovah has kept his promise.";
  isaacBorn.time = new Date(-2500, 1, 1);
  s.add(isaacBorn);
  var isaacSacrified = new Event();
  isaacSacrified.id = "E3";
  isaacSacrified.name = "Abraham is willing to sacrifice Isaac";
  isaacSacrified.descr = "This is Abraham's only son with Sarah, and he is a teenager, so Abraham must be very affectionate of him. Also, Jehovah had promised to bless all nations through him, so how would this fulfill when Isaac is dead? During the 3 day journey through the desert, Abraham must have had time to reflect on this, and find excuses not to do this, but he didn't question Jehovah's wish. Instead, he faithfully proceeded to execute it, fully trusting in Jehovah not only that he would be able to fulfill the promises nevertheless, but also that this is the morally right action. His trust in Jehovah despite his emotions is extraordinary.";
  isaacSacrified.time = new Date(-2480, 5, 8);
  s.add(isaacSacrified);
  var heb11 = new BibleText();
  heb11.id = "S1";
  heb11.name = "Heb. 11:17";
  heb11.quote = "Durch Glauben brachte Abraham, als er auf die Probe gestellt wurde, Isaak so gut wie als Opfer dar, und der Mann, der die Verheißungen gern empfangen hatte, versuchte, [seinen] einziggezeugten [Sohn] als Opfer darzubringen)";
  s.add(heb11);
  var rom4 = new BibleText();
  rom4.id = "S2";
  rom4.name = "Rom. 4:3";
  rom4.quote = "Abraham setzte Glauben in Jehova, und es wurde ihm als Gerechtigkeit angerechnet";
  s.add(rom4);

  abraham.relations = [
    { subj : abraham, obj : sarah, type: "married" },
    { subj : abraham, obj : isaac, type: "child" },
    { subj : abraham, obj : heb11, type: "source" },
    { subj : abraham, obj : rom4, type: "source" },
    { subj : abraham, obj : isaacPromised, type: "event" },
    { subj : abraham, obj : isaacBorn, type: "event" },
    { subj : abraham, obj : isaacSacrified, type: "event" },
  ];
  sarah.relations = [
    { subj : sarah, obj : abraham, type: "married" },
    { subj : sarah, obj : isaac, type: "child" },
    { subj : sarah, obj : isaacBorn, type: "event" },
  ];
  isaac.relations = [
    { subj : isaac, obj : abraham, type: "father" },
    { subj : isaac, obj : sarah, type: "mother" },
    { subj : isaac, obj : isaacPromised, type: "event" },
    { subj : isaac, obj : isaacBorn, type: "event" },
    { subj : isaac, obj : isaacSacrified, type: "event" },
  ];
  isaacPromised.relations = [
    { subj : isaacPromised, obj : abraham, type: "person" },
    { subj : isaacPromised, obj : isaac, type: "person" },
  ];
  isaacBorn.relations = [
    { subj : isaacBorn, obj : abraham, type: "person" },
    { subj : isaacBorn, obj : sarah, type: "person" },
    { subj : isaacBorn, obj : isaac, type: "person" },
  ];
  isaacSacrified.relations = [
    { subj : isaacSacrified, obj : abraham, type: "person" },
    { subj : isaacSacrified, obj : isaac, type: "person" },
  ];

  return s;
}
