﻿'use strict';

/**
 * Simple function to render some text on a element
*/
function write (el, text) {
    if(!('textContent' in el)) {
        el.innerText = text;
    } else {
        el.textContent = text;
    }
}

var onDeviceReady = function () {
	Phonon.Navigator().start('home');
}

var book = '';
var isCordova = typeof window.cordova !== 'undefined' ? true : false;

if(isCordova) {
	document.addEventListener('deviceready', onDeviceReady, false);
} else {
	window.addEventListener('load', onDeviceReady, false);
}

Phonon.Navigator({
	defaultPage: 'home',
	templatePath: 'content',
	pageAnimations: true
});

/**
 * This page is synchronous
*/
Phonon.Navigator().on({page: 'home', template: 'home', asynchronous: false}, function(activity) {

	activity.onCreate(function(self, el, req) {
		console.log('home: onCreate');
	});

	activity.onReady(function(self, el, req) {
		console.log('home: onReady');
	});

	activity.onTransitionEnd(function() {
		console.log('home: onTransitionEnd');
	});

	activity.onQuit(function(self) {
		console.log('home: onQuit');
	});

	activity.onHidden(function(el) {
		console.log('home: onHidden');
	});
});

/**
 * This page is asynchronous which means that you must
 * call runReady() inside the onCreate callback
 * and startTransition() inside the onReady callback manually after asynchronous tasks are done
*/
Phonon.Navigator().on({page: 'page-two', template: 'page-two', asynchronous: true}, function(activity) {

	var handler = function(evt) {
		evt.preventDefault();
		Phonon.Navigator().changePage('home');
	};

	activity.onCreate(function(self, el, req) {
		var els = el.querySelectorAll('.back-index');
		els[0].addEventListener('click', handler);
		console.log('page-two: onCreate');
		self.runReady();
	});

	activity.onReady(function(self, el, req) {
		console.log('page-two: onReady');
		setTimeout(function() {
		    var res = el.querySelector('.result');
			var tit = el.querySelector('.name-title');
		    if(req.myParam != undefined){
						var rawFile = new XMLHttpRequest();
						rawFile.open("GET", 'content/index'+req.myParam+'.html', false);
						rawFile.onreadystatechange = function ()
						{
							if(rawFile.readyState === 4)
							{
							if(rawFile.status === 200 || rawFile.status == 0)
							{
								var allText = rawFile.responseText;
								//alert(allText);
								book = req.seParam;
								tit.innerHTML = book;
								res.innerHTML = allText;
								//write(res, );
							}
							}
						}
						rawFile.send(null);
		    }
		    self.startTransition();
		}, 250);
	});

	activity.onTransitionEnd(function() {
		console.log('page-two: onTransitionEnd');
	});

	activity.onQuit(function(self) {
		console.log('page-two: onQuit');
	});

	activity.onHidden(function(el) {
		console.log('page-two: onHidden');
	});

}, 'page-two/:myParam/:seParam');

Phonon.Navigator().on({page: 'page-tree', template: 'page-tree', asynchronous: true}, function(activity) {

	activity.onCreate(function(self, el, req) {
	    console.log('page-tree: onCreate');
	    self.runReady();
		
	});

	activity.onReady(function(self, el, req) {
		console.log('page-tree: onReady');
		setTimeout(function() {
		    var chap = el.querySelector('.resbook');
		    var tit  = el.querySelector('.title-up');
			var rawFile = new XMLHttpRequest();
			rawFile.open("GET", 'content/'+req.myParam+'.html', false);
			rawFile.onreadystatechange = function ()
			{
			    if(rawFile.readyState === 4)
			    {
				if(rawFile.status === 200 || rawFile.status == 0)
				{
				    var allText = rawFile.responseText;
				    //alert(allText);
					var cap = req.seParam; 
					tit.innerHTML  = book+'<span class="subtitle">Capítulo '+cap+'</span>';
				    chap.innerHTML = allText;
				    //write(res, );
				}				
			    }
			}
			rawFile.send(null);
		    self.startTransition();
		}, 250);
	});

	activity.onTransitionEnd(function() {
		console.log('page-tree: onTransitionEnd');
	});

	activity.onQuit(function(self) {
		console.log('page-tree: onQuit');
		self.quit();
	});

	activity.onHidden(function(el) {
		console.log('page-tree: onHidden');
	});

}, 'page-tree/:myParam/:seParam');