define([], function(){
	/* GeoLocator object
	get data from GPS and call updateCallback.
	call disable()/enable() to stop/restart calling callback.*/
	var GeoLocator = function(updateCallback, errorCallback) {
		
		this._enabled = false;
		this._watcher = 0;
		
		this._updateCallback = updateCallback;
		this._errorCallback = errorCallback;
		
	};	
	
	GeoLocator.prototype.onGeoCurrentPosition = function(event) {
		if (this._enabled) {
			this._updateCallback(event);
		}
	};
		
	GeoLocator.prototype.onGeoError = function(error) {
		switch(error.code){
			case error.PERMISSION_DENIED:
			  console.error("User denied the request for Geolocation.");
			  break;
			case error.POSITION_UNAVAILABLE:
			  console.error("Location information is unavailable.");
			  break;
			case error.TIMEOUT:
			  //console.error("The request to get user location timed out.");
			  break;
			case error.UNKNOWN_ERROR:
			  console.error("An unknown error occurred.");
			  break;
		}
		
		this._errorCallback(error);
	};
	
	GeoLocator.prototype.start = function(){
			if (navigator.geolocation)    {
				//, maximumAge:0, enableHighAccuracy:true
				this._watcher = navigator.geolocation.watchPosition(
					this.onGeoCurrentPosition.bind(this), 
					this.onGeoError.bind(this),
					{timeout:5000}
				);
				this._enabled = true; 
			} else {
				alert("This browser don't support geolocation");
				this._enabled = false; 
			}	
	};
	
	GeoLocator.prototype.disable = function(){ 
		if (this._enabled) {
			this._enabled = false; 
			navigator.geolocation.clearWatch(this._watcher);
		}
	};
	GeoLocator.prototype.enable = function(){ 
		if (!this._enabled) {
			this.start();
		}
	};
	
	

	return GeoLocator;
});