// Roller Coaster Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Roller Coaster Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             PAYOFF: Played after the path is traced.
//             MUSIC: Loops in the background.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     rider: Character that will traverse the path upon round completion.
//         Available States:
//             INTRO: Initial state of the bubble.
//             RIDE: Displayed when the rider is moving along the path.
//     dataPoints (Array): Array of objects that describe the points which define the shape.
//         Example:
//             dataPoints: [ 
//			    	{ 
//                      i: 0,
//                      x: 329,
//                      y: 594
//                  }, {
//                      i: 1,
//                      x: 329,
//                      y: 192
//                  }
//             ]
//     hintPaths (Array): Array of objects that describe the hint paths by the using the index 'i' values of the dataPoints.
//          Example:
//              hintPaths: [
//				    [ 0, 1, 2 ],
//                  [ 3, 4 ]
//			    ]
//     successPath (Array): Array of index 'i' values of the dataPoints that describe the path the rider will traverse on sucess.
//          Example:
//              successPath: [ 0, 1, 2, 1, 3, 1, 4 ]
//     targetItems: Items that are activated by touch.  Target items are not visible until activated. Once all target items are activated the round is complete.
//     payoff: View that is displayed while the rider is moving along the path after the round is complete.

WM.config = {
	//showOnlyThisRound: 15,
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -96
		}
	},
	gameIcon: "mozilla_thumb_256x256_BigBirdsAlphabetTrack.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-rollerCoaster-lowercase.jpg",
	audioEnabled: true,
	audioFilename: "audio-rollerCoaster-lowercaseLetters.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "music", 
				startTime: 200,
				duration: 17.18,
				loop: true
			}
		]
	},
	hint: {
		color: "#ffea00",
		speed: 10,
		width: 5, //width of the line itself. Makes the dots get bigger
		dashWidth: 10, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 10 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 0,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 4,
						duration: 2.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO", //poof animation
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE", //ride animation
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10, //can find this on the stage of the .fla file
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ //points in the object where the coaster and dots changes direction. Make these up based on x y coordinates in Fireworks
				{ i: 0, x: 637, y: 240 }, 
				{ i: 1, x: 637, y: 522 }, 
				{ i: 2, x: 637, y: 279 }, 
				{ i: 3, x: 619, y: 263 }, 
				{ i: 4, x: 605, y: 255 }, 
				{ i: 5, x: 597, y: 251 }, 
				{ i: 6, x: 585, y: 245 }, 
				{ i: 7, x: 571, y: 241 }, 
				{ i: 8, x: 551, y: 239 }, 
				{ i: 9, x: 533, y: 239 }, 
				{ i: 10, x: 515, y: 239 }, 
				{ i: 11, x: 495, y: 245 }, 
				{ i: 12, x: 479, y: 251 }, 
				{ i: 13, x: 463, y: 259 }, 
				{ i: 14, x: 451, y: 267 }, 
				{ i: 15, x: 441, y: 275 }, 
				{ i: 16, x: 431, y: 287 }, 
				{ i: 17, x: 425, y: 297 }, 
				{ i: 18, x: 415, y: 311 }, 
				{ i: 19, x: 411, y: 323 }, 
				{ i: 20, x: 407, y: 331 }, 
				{ i: 21, x: 401, y: 347 }, 
				{ i: 22, x: 401, y: 359 }, 
				{ i: 23, x: 399, y: 369 }, 
				{ i: 24, x: 399, y: 381 }, 
				{ i: 25, x: 399, y: 395 }, 
				{ i: 26, x: 401, y: 409 }, 
				{ i: 27, x: 405, y: 421 }, 
				{ i: 28, x: 409, y: 433 }, 
				{ i: 29, x: 415, y: 445 }, 
				{ i: 30, x: 419, y: 455 }, 
				{ i: 31, x: 425, y: 463 }, 
				{ i: 32, x: 433, y: 475 }, 
				{ i: 33, x: 441, y: 483 }, 
				{ i: 34, x: 449, y: 489 }, 
				{ i: 35, x: 459, y: 497 }, 
				{ i: 36, x: 467, y: 505 }, 
				{ i: 37, x: 479, y: 507 }, 
				{ i: 38, x: 487, y: 513 }, 
				{ i: 39, x: 495, y: 517 }, 
				{ i: 40, x: 505, y: 519 }, 
				{ i: 41, x: 517, y: 519 }, 
				{ i: 42, x: 527, y: 521 }, 
				{ i: 43, x: 535, y: 523 }, 
				{ i: 44, x: 545, y: 523 }, 
				{ i: 45, x: 555, y: 521 }, 
				{ i: 46, x: 565, y: 519 }, 
				{ i: 47, x: 573, y: 519 }, 
				{ i: 48, x: 583, y: 516 }, 
				{ i: 49, x: 593, y: 509 }, 
				{ i: 50, x: 605, y: 507 }, 
				{ i: 51, x: 615, y: 503 }, 
				{ i: 52, x: 637, y: 489 },
				{ i: 53, x: 637, y: 240 },
				{ i: 54, x: 637, y: 522 }
							
			],
			hintPaths: [ //these are the dotted line points
				[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52],
				[0, 1]
				
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ], //this is the payoff rollercoaster ride path
			targetItems: [
				{ filename: "lowercase-a-01.png", x: 623, y: 217 },
				{ filename: "lowercase-a-02.png", x: 623, y: 275 },
				{ filename: "lowercase-a-03.png", x: 623, y: 332 },
				{ filename: "lowercase-a-04.png", x: 623, y: 371 },
				{ filename: "lowercase-a-05.png", x: 623, y: 414 },
				{ filename: "lowercase-a-06.png", x: 623, y: 457 },
				{ filename: "lowercase-a-07.png", x: 623, y: 494 },
				{ filename: "lowercase-a-08.png", x: 582, y: 217 },
				{ filename: "lowercase-a-09.png", x: 541, y: 188 },
				{ filename: "lowercase-a-10.png", x: 500, y: 188 },
				{ filename: "lowercase-a-11.png", x: 462, y: 217 },
				{ filename: "lowercase-a-12.png", x: 374, y: 240 },
				{ filename: "lowercase-a-13.png", x: 374, y: 345 },
				{ filename: "lowercase-a-14.png", x: 374, y: 407 },
				{ filename: "lowercase-a-15.png", x: 391, y: 450 },
				{ filename: "lowercase-a-16.png", x: 481, y: 450 },
				{ filename: "lowercase-a-17.png", x: 531, y: 450 },
				{ filename: "lowercase-a-18.png", x: 582, y: 414 }
				
			],
			payoff: { filename: "lowercase-a-payoff.png", x: 0, y: 0 }
		}, { //Round 2
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 7,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 10,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 440, y: 208 }, 
				{ i: 1, x: 440, y: 582 },
				{ i: 2, x: 442, y: 430 }, { i: 3, x: 457, y: 410 }, { i: 4, x: 472, y: 396 }, { i: 5, x: 488, y: 387 }, { i: 6, x: 504, y: 380 }, { i: 7, x: 521, y: 377 }, { i: 8, x: 536, y: 376 }, { i: 9, x: 555, y: 379 }, { i: 10, x: 576, y: 385 }, { i: 11, x: 593, y: 395 }, { i: 12, x: 606, y: 407 }, { i: 13, x: 621, y: 425 }, { i: 14, x: 628, y: 442 }, { i: 15, x: 634, y: 460 }, { i: 16, x: 636, y: 479 }, { i: 17, x: 635, y: 498 }, { i: 18, x: 629, y: 518 }, { i: 19, x: 619, y: 537 }, { i: 20, x: 606, y: 553 }, { i: 21, x: 589, y: 567 }, { i: 22, x: 571, y: 576 }, { i: 23, x: 548, y: 582 }, { i: 24, x: 525, y: 582 }, { i: 25, x: 505, y: 580 }, { i: 26, x: 490, y: 575 }, { i: 27, x: 471, y: 564 }, { i: 28, x: 457, y: 550 }, { i: 29, x: 442, y: 530 }
			],
			hintPaths: [
				[0, 1],
				[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29],
			targetItems: [
				{ filename: "lowercase-b-01.png", x: 359, y: 181 },
				{ filename: "lowercase-b-02.png", x: 359, y: 252 },
				{ filename: "lowercase-b-03.png", x: 359, y: 330 },
				{ filename: "lowercase-b-04.png", x: 359, y: 397 },
				{ filename: "lowercase-b-05.png", x: 359, y: 469 },
				{ filename: "lowercase-b-06.png", x: 359, y: 540 },
				{ filename: "lowercase-b-07.png", x: 445, y: 363 },
				{ filename: "lowercase-b-08.png", x: 445, y: 469 },
				{ filename: "lowercase-b-09.png", x: 505, y: 363 },
				{ filename: "lowercase-b-10.png", x: 505, y: 469 },
				{ filename: "lowercase-b-11.png", x: 576, y: 363 },
				{ filename: "lowercase-b-12.png", x: 576, y: 469 }
	
			],
			payoff: { filename: "lowercase-b-payoff.png", x: 0, y: 0 }
		},{ //Round 3
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 15,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 19,
						duration: 2.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 661, y: 305 }, 
				{ i: 1, x: 638, y: 278 }, 
				{ i: 2, x: 612, y: 258 }, 
				{ i: 3, x: 580, y: 242 }, 
				{ i: 4, x: 542, y: 238 }, 
				{ i: 5, x: 506, y: 244 }, 
				{ i: 6, x: 470, y: 260 }, 
				{ i: 7, x: 444, y: 282 }, 
				{ i: 8, x: 424, y: 310 }, 
				{ i: 9, x: 412, y: 340 }, 
				{ i: 10, x: 408, y: 370 }, 
				{ i: 11, x: 412, y: 410 }, 
				{ i: 12, x: 422, y: 440 }, 
				{ i: 13, x: 438, y: 466 }, 
				{ i: 14, x: 454, y: 488 }, 
				{ i: 15, x: 484, y: 504 }, 
				{ i: 16, x: 502, y: 512 }, 
				{ i: 17, x: 532, y: 520 }, 
				{ i: 18, x: 562, y: 518 }, 
				{ i: 19, x: 588, y: 512 }, 
				{ i: 20, x: 607, y: 502 }, 
				{ i: 21, x: 640, y: 478 }, 
				{ i: 22, x: 660, y: 456 }
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, ]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, ],
			targetItems: [
				{ filename: "lowercase-c-01.png", x: 633, y: 244 },
				{ filename: "lowercase-c-02.png", x: 577, y: 216 },
				{ filename: "lowercase-c-03.png", x: 512, y: 191 },
				{ filename: "lowercase-c-04.png", x: 469, y: 209 },
				{ filename: "lowercase-c-05.png", x: 381, y: 231 },
				{ filename: "lowercase-c-06.png", x: 381, y: 335 },
				{ filename: "lowercase-c-07.png", x: 381, y: 405 },
				{ filename: "lowercase-c-08.png", x: 397, y: 446 },
				{ filename: "lowercase-c-09.png", x: 491, y: 446 },
				{ filename: "lowercase-c-10.png", x: 545, y: 446 },
				{ filename: "lowercase-c-11.png", x: 598, y: 412 },
				{ filename: "lowercase-c-12.png", x: 644, y: 412 }
				
			],
			payoff: { filename: "lowercase-c-payoff.png", x: 0, y: 0 }
		}, { //Round 4
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 23,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 27,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 593, y: 420 }, { i: 1, x: 579, y: 404 }, { i: 2, x: 564, y: 393 }, { i: 3, x: 550, y: 386 }, { i: 4, x: 532, y: 380 }, { i: 5, x: 514, y: 378 }, { i: 6, x: 492, y: 379 }, { i: 7, x: 472, y: 385 }, { i: 8, x: 453, y: 394 }, { i: 9, x: 438, y: 408 }, { i: 10, x: 426, y: 421 }, { i: 11, x: 417, y: 438 }, { i: 12, x: 411, y: 455 }, { i: 13, x: 407, y: 473 }, { i: 14, x: 408, y: 492 }, { i: 15, x: 411, y: 508 }, { i: 16, x: 417, y: 524 }, { i: 17, x: 425, y: 538 }, { i: 18, x: 435, y: 552 }, { i: 19, x: 446, y: 561 }, { i: 20, x: 462, y: 572 }, { i: 21, x: 480, y: 579 }, { i: 22, x: 501, y: 584 }, { i: 23, x: 520, y: 583 }, { i: 24, x: 537, y: 581 }, { i: 25, x: 554, y: 574 }, { i: 26, x: 570, y: 566 }, { i: 27, x: 585, y: 554 }, { i: 28, x: 593, y: 543 }, { i: 29, x: 603, y: 204 }, { i: 30, x: 603, y: 585 }	
				],
			hintPaths: [
				[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28],
				[29, 30]
							
				
			],
			successPath: [29, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30],
			targetItems: [
				{ filename: "lowercase-d-01.png", x: 597, y: 181 },
				{ filename: "lowercase-d-02.png", x: 597, y: 289 },
				{ filename: "lowercase-d-03.png", x: 597, y: 362 },
				{ filename: "lowercase-d-04.png", x: 597, y: 436 },
				{ filename: "lowercase-d-05.png", x: 597, y: 505 },
				{ filename: "lowercase-d-06.png", x: 540, y: 362 },
				{ filename: "lowercase-d-07.png", x: 540, y: 471 },
				{ filename: "lowercase-d-08.png", x: 469, y: 362 },
				{ filename: "lowercase-d-09.png", x: 469, y: 471 },
				{ filename: "lowercase-d-10.png", x: 396, y: 362 },
				{ filename: "lowercase-d-11.png", x: 396, y: 471 }
			],
			payoff: { filename: "lowercase-d-payoff.png", x: 0 , y: 0 }
		},{ //Round 5
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 30,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 34,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 407, y: 358 }, 
				 { i: 1, x: 690, y: 358 }, 
				 { i: 2, x: 688, y: 335 }, 
				 { i: 3, x: 682, y: 307 }, 
				 { i: 4, x: 672, y: 285 }, 
				 { i: 5, x: 660, y: 263 }, 
				 { i: 6, x: 650, y: 253 }, 
				 { i: 7, x: 636, y: 241 }, 
				 { i: 8, x: 618, y: 227 }, 
				 { i: 9, x: 596, y: 217 }, 
				 { i: 10, x: 574, y: 213 }, 
				 { i: 11, x: 552, y: 211 }, 
				 { i: 12, x: 528, y: 215 }, 
				 { i: 13, x: 508, y: 219 }, 
				 { i: 14, x: 486, y: 225 },
				 { i: 15, x: 464, y: 239 }, 
				 { i: 16, x: 446, y: 257 }, 
				 { i: 17, x: 428, y: 279 }, 
				 { i: 18, x: 416, y: 307 }, 
				 { i: 19, x: 408, y: 333 },
				 { i: 20, x: 406, y: 359 },
				 { i: 21, x: 410, y: 379 }, 
				 { i: 22, x: 414, y: 395 }, 
				 { i: 23, x: 422, y: 421 }, 
				 { i: 24, x: 430, y: 441 }, 
				 { i: 25, x: 438, y: 451 },
				 { i: 26, x: 448, y: 463 }, 
				 { i: 27, x: 458, y: 475 }, 
				 { i: 28, x: 472, y: 487 }, 
				 { i: 29, x: 488, y: 497 }, 
				 { i: 30, x: 502, y: 503 }, 
				 { i: 31, x: 522, y: 511 }, 
				 { i: 32, x: 540, y: 513 }, 
				 { i: 33, x: 556, y: 515 }, 
				 { i: 34, x: 576, y: 515 }, 
				 { i: 35, x: 596, y: 511 }, 
				 { i: 36, x: 614, y: 503 }, 
				 { i: 37, x: 631, y: 492 }, 
				 { i: 38, x: 644, y: 488 },
				 { i: 39, x: 660, y: 476 }, 
				 { i: 40, x: 674, y: 454 }, 
				 { i: 41, x: 684, y: 442 }
			
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41 ],
				
				
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41 ],
			targetItems: [
				{ filename: "lowercase-e-01.png", x: 630, y: 401 },
				{ filename: "lowercase-e-02.png", x: 585, y: 418 },
				{ filename: "lowercase-e-03.png", x: 536, y: 418 },
				{ filename: "lowercase-e-04.png", x: 487, y: 401 },
				{ filename: "lowercase-e-05.png", x: 392, y: 418 },
				{ filename: "lowercase-e-06.png", x: 378, y: 371 },
				{ filename: "lowercase-e-07.png", x: 372, y: 310 },
				{ filename: "lowercase-e-08.png", x: 487, y: 310 },
				{ filename: "lowercase-e-09.png", x: 549, y: 310 },
				{ filename: "lowercase-e-10.png", x: 613, y: 310 },
				{ filename: "lowercase-e-11.png", x: 581, y: 277 },
				{ filename: "lowercase-e-12.png", x: 585, y: 177 },
				{ filename: "lowercase-e-13.png", x: 527, y: 177 },
				{ filename: "lowercase-e-14.png", x: 407, y: 188 },
				{ filename: "lowercase-e-15.png", x: 386, y: 277 }
					
		
			],
			payoff: { filename: "lowercase-e-payoff.png", x: 0 , y: 0  }
		},{ //Round 6
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 38,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 42,
						duration: 2.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 627, y: 254 }, { i: 1, x: 614, y: 238 }, { i: 2, x: 600, y: 224 }, { i: 3, x: 584, y: 214 }, { i: 4, x: 567, y: 207 }, { i: 5, x: 547, y: 203 }, { i: 6, x: 529, y: 205 }, { i: 7, x: 510, y: 211 }, { i: 8, x: 495, y: 220 }, { i: 9, x: 481, y: 233 }, { i: 10, x: 472, y: 247 }, { i: 11, x: 466, y: 265 }, { i: 12, x: 463, y: 287 }, { i: 13, x: 463, y: 385 }, { i: 14, x: 463, y: 583 }, { i: 15, x: 385, y: 392 }, { i: 16, x: 538, y: 392 }			
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14],
				[15, 16]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 13, 15, 16],
			targetItems: [
				{ filename: "lowercase-f-01.png", x: 406, y: 506 },
				{ filename: "lowercase-f-02.png", x: 406, y: 419 },
				{ filename: "lowercase-f-03.png", x: 374, y: 360 },
				{ filename: "lowercase-f-04.png", x: 483, y: 360 },
				{ filename: "lowercase-f-05.png", x: 449, y: 360 },
				{ filename: "lowercase-f-06.png", x: 411, y: 288 },
				{ filename: "lowercase-f-07.png", x: 411, y: 236 },
				{ filename: "lowercase-f-08.png", x: 411, y: 145 },
				{ filename: "lowercase-f-09.png", x: 522, y: 145 },
				{ filename: "lowercase-f-10.png", x: 576, y: 145 }
						
			],
			payoff: { filename: "lowercase-f-payoff.png", x: 0, y: 0  }
		},{ //Round 7
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 46,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 50,
						duration: 2.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 611, y: 201 }, { i: 1, x: 596, y: 187 }, { i: 2, x: 580, y: 176 }, { i: 3, x: 561, y: 169 }, { i: 4, x: 535, y: 164 }, { i: 5, x: 507, y: 166 }, { i: 6, x: 484, y: 174 }, { i: 7, x: 462, y: 190 }, { i: 8, x: 445, y: 207 }, { i: 9, x: 434, y: 228 }, { i: 10, x: 428, y: 250 }, { i: 11, x: 428, y: 270 }, { i: 12, x: 429, y: 288 }, { i: 13, x: 436, y: 309 }, { i: 14, x: 448, y: 328 }, { i: 15, x: 460, y: 342 }, { i: 16, x: 477, y: 356 }, { i: 17, x: 499, y: 365 }, { i: 18, x: 519, y: 369 }, { i: 19, x: 540, y: 369 }, { i: 20, x: 559, y: 366 }, { i: 21, x: 580, y: 357 }, { i: 22, x: 597, y: 345 }, { i: 23, x: 607, y: 335 }, { i: 24, x: 621, y: 165 }, { i: 25, x: 621, y: 469 }, { i: 26, x: 616, y: 484 }, { i: 27, x: 610, y: 497 }, { i: 28, x: 602, y: 508 }, { i: 29, x: 590, y: 521 }, { i: 30, x: 576, y: 530 }, { i: 31, x: 558, y: 539 }, { i: 32, x: 537, y: 543 }, { i: 33, x: 513, y: 544 }, { i: 34, x: 492, y: 541 }, { i: 35, x: 472, y: 533 }, { i: 36, x: 458, y: 526 }, { i: 37, x: 445, y: 517 }, { i: 38, x: 434, y: 506 }
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23], 
				[24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38]
				
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38],
			targetItems: [
				{ filename: "lowercase-g-01.png", x: 613, y: 145 },
				{ filename: "lowercase-g-02.png", x: 613, y: 215 },
				{ filename: "lowercase-g-03.png", x: 613, y: 288 },
				{ filename: "lowercase-g-04.png", x: 540, y: 145 },
				{ filename: "lowercase-g-05.png", x: 540, y: 270 },
				{ filename: "lowercase-g-06.png", x: 468, y: 145 },
				{ filename: "lowercase-g-07.png", x: 396, y: 145 },
				{ filename: "lowercase-g-08.png", x: 396, y: 270 },
				{ filename: "lowercase-g-09.png", x: 468, y: 270 },
				{ filename: "lowercase-g-10.png", x: 576, y: 384 },
				{ filename: "lowercase-g-11.png", x: 576, y: 432 },
				{ filename: "lowercase-g-12.png", x: 540, y: 484 },
				{ filename: "lowercase-g-13.png", x: 468, y: 484 },
				{ filename: "lowercase-g-14.png", x: 375, y: 484 }
		
			],
			payoff: { filename: "lowercase-g-payoff.png", x: 0, y: 0  }
		},{ //Round 8
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 54,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 58,
						duration: 2.2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 430, y: 203 }, { i: 1, x: 430, y: 583 }, { i: 2, x: 430, y: 438 }, { i: 3, x: 441, y: 425 }, { i: 4, x: 454, y: 410 }, { i: 5, x: 471, y: 400 }, { i: 6, x: 493, y: 392 }, { i: 7, x: 514, y: 388 }, { i: 8, x: 536, y: 389 }, { i: 9, x: 556, y: 392 }, { i: 10, x: 576, y: 399 }, { i: 11, x: 592, y: 413 }, { i: 12, x: 604, y: 430 }, { i: 13, x: 611, y: 449 }, { i: 14, x: 611, y: 583 }
			],
			hintPaths: [
				[0, 1],
				[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]			
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14],
			targetItems: [
				{ filename: "lowercase-h-01.png", x: 397, y: 181 },
				{ filename: "lowercase-h-02.png", x: 397, y: 253 },
				{ filename: "lowercase-h-03.png", x: 397, y: 324 },
				{ filename: "lowercase-h-04.png", x: 397, y: 368 },
				{ filename: "lowercase-h-05.png", x: 397, y: 442 },
				{ filename: "lowercase-h-06.png", x: 397, y: 482 },
				{ filename: "lowercase-h-07.png", x: 397, y: 539 },
				{ filename: "lowercase-h-08.png", x: 468, y: 368 },
				{ filename: "lowercase-h-09.png", x: 522, y: 368 },
				{ filename: "lowercase-h-10.png", x: 569, y: 368 },
				{ filename: "lowercase-h-11.png", x: 569, y: 442 },
				{ filename: "lowercase-h-12.png", x: 569, y: 482 },
				{ filename: "lowercase-h-13.png", x: 569, y: 539 }
					
			],
			payoff: { filename: "lowercase-h-payoff.png", x: 0, y: 0 }
		},{ //Round 9
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 61,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 65,
						duration: 2.2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 527, y: 335 },
				{ i: 1, x: 527, y: 590 },
				{ i: 2, x: 527, y: 200 },
				{ i: 3, x: 527, y: 220 } 	
			],
			hintPaths: [
				[0, 1],
				[2, 3]
			
			],
			successPath: [2, 3, 0, 1],
			targetItems: [
				{ filename: "lowercase-i-01.png", x: 489, y: 181 },
				{ filename: "lowercase-i-02.png", x: 489, y: 324 },
				{ filename: "lowercase-i-03.png", x: 489, y: 432 },
				{ filename: "lowercase-i-04.png", x: 489, y: 504 }
		
			],
			payoff: { filename: "lowercase-i-payoff.png", x: 0, y: 0 }
		},{ //Round 10
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 68,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 72,
						duration: 2.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 589, y: 257 }, { i: 1, x: 590, y: 484 }, { i: 2, x: 587, y: 506 }, { i: 3, x: 579, y: 522 }, { i: 4, x: 565, y: 536 }, { i: 5, x: 549, y: 547 }, { i: 6, x: 530, y: 555 }, { i: 7, x: 507, y: 558 }, { i: 8, x: 486, y: 556 }, { i: 9, x: 465, y: 551 }, { i: 10, x: 446, y: 543 }, { i: 11, x: 428, y: 532 }, { i: 12, x: 413, y: 517 }, { i: 13, x: 588, y: 162 }, { i: 14, x: 589, y: 185 } 
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
				[13, 14]
			],
			successPath: [14, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
			targetItems: [
				{ filename: "lowercase-j-01.png", x: 521, y: 145 },
				{ filename: "lowercase-j-02.png", x: 521, y: 234 },
				{ filename: "lowercase-j-03.png", x: 521, y: 288 },
				{ filename: "lowercase-j-04.png", x: 521, y: 360 },
				{ filename: "lowercase-j-05.png", x: 521, y: 414 },
				{ filename: "lowercase-j-06.png", x: 521, y: 477 },
				{ filename: "lowercase-j-07.png", x: 471, y: 477 },
				{ filename: "lowercase-j-08.png", x: 359, y: 477 }
		
			],
			payoff: { filename: "lowercase-j-payoff.png", x: 0 , y: 0  }
		},{ //Round 11
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 76,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 80,
						duration: 2.2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 431, y: 178 }, { i: 1, x: 431, y: 585 }, { i: 2, x: 431, y: 473 }, { i: 3, x: 582, y: 364 }, { i: 4, x: 445, y: 458 }, { i: 5, x: 445, y: 482 }, { i: 6, x: 620, y: 585 }
			],
			hintPaths: [
				[0, 1],
				[3, 4],
				[5, 6]
			],
			successPath: [0, 1, 2, 4, 3, 4, 5, 6],
			targetItems: [
				{ filename: "lowercase-k-01.png", x: 380, y: 145 },
				{ filename: "lowercase-k-02.png", x: 380, y: 216 },
				{ filename: "lowercase-k-03.png", x: 380, y: 272 },
				{ filename: "lowercase-k-04.png", x: 380, y: 350 },
				{ filename: "lowercase-k-05.png", x: 380, y: 394 },
				{ filename: "lowercase-k-06.png", x: 380, y: 469 },
				{ filename: "lowercase-k-07.png", x: 380, y: 554 },
				{ filename: "lowercase-k-08.png", x: 454, y: 350 },
				{ filename: "lowercase-k-09.png", x: 504, y: 350 },
				{ filename: "lowercase-k-10.png", x: 541, y: 350 },
				{ filename: "lowercase-k-11.png", x: 454, y: 469 },
				{ filename: "lowercase-k-12.png", x: 504, y: 485 },
				{ filename: "lowercase-k-13.png", x: 541, y: 504 }
		
			],
			payoff: { filename: "lowercase-k-payoff.png", x: 0 , y: 0 }
		}, { //Round 12
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 84,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 88,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 519, y: 177 }, { i: 1, x: 519, y: 586 } 
			],
			hintPaths: [
				[ 0, 1, ]
			],
			successPath: [ 0, 1, ],
			targetItems: [
				{ filename: "lowercase-l-01.png", x: 469, y: 145 },
				{ filename: "lowercase-l-02.png", x: 469, y: 216 },
				{ filename: "lowercase-l-03.png", x: 469, y: 287 },
				{ filename: "lowercase-l-04.png", x: 469, y: 343 },
				{ filename: "lowercase-l-05.png", x: 469, y: 398 },
				{ filename: "lowercase-l-06.png", x: 469, y: 460 },
				{ filename: "lowercase-l-07.png", x: 469, y: 522 }
			],
			payoff: { filename: "lowercase-l-payoff.png", x: 0, y: 0 } 
			},{ //Round 13
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 91,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 95,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 293, y: 239 }, 
				{ i: 1, x: 293, y: 523 }, 
				{ i: 2, x: 293, y: 303 }, 
				{ i: 3, x: 308, y: 275 }, 
				{ i: 4, x: 320, y: 263 }, 
				{ i: 5, x: 334, y: 255 }, 
				{ i: 6, x: 348, y: 247 }, 
				{ i: 7, x: 364, y: 243 }, 
				{ i: 8, x: 384, y: 239 }, 
				{ i: 9, x: 404, y: 237 }, 
				{ i: 10, x: 420, y: 239 }, 
				{ i: 11, x: 439, y: 240 }, 
				{ i: 12, x: 462, y: 245 }, 
				{ i: 13, x: 478, y: 253 }, 
				{ i: 14, x: 498, y: 265 }, 
				{ i: 15, x: 510, y: 277 }, 
				{ i: 16, x: 524, y: 297 }, 
				{ i: 17, x: 524, y: 519 }, 
				{ i: 18, x: 524, y: 297 }, 
				{ i: 19, x: 538, y: 281 }, 
				{ i: 20, x: 552, y: 267 }, 
				{ i: 21, x: 574, y: 255 }, 
				{ i: 22, x: 592, y: 247 }, 
				{ i: 23, x: 616, y: 239 }, 
				{ i: 24, x: 638, y: 237 }, 
				{ i: 25, x: 658, y: 237 }, 
				{ i: 26, x: 678, y: 241 }, 
				{ i: 27, x: 700, y: 245 }, 
				{ i: 28, x: 722, y: 255 }, 
				{ i: 29, x: 740, y: 269 }, 
				{ i: 30, x: 750, y: 281 }, 
				{ i: 31, x: 756, y: 303 }, 
				{ i: 32, x: 756, y: 520 }
				
				
			],
			hintPaths: [
				[0, 1 ],
				[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ,20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ,20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 ],
			targetItems: [
				{ filename: "lowercase-m-01.png", x: 265, y: 219 },
				{ filename: "lowercase-m-02.png", x: 265, y: 290 },
				{ filename: "lowercase-m-03.png", x: 265, y: 332 },
				{ filename: "lowercase-m-04.png", x: 265, y: 370 },
				{ filename: "lowercase-m-05.png", x: 265, y: 411 },
				{ filename: "lowercase-m-06.png", x: 265, y: 452 },
				{ filename: "lowercase-m-07.png", x: 265, y: 496 },
				{ filename: "lowercase-m-08.png", x: 351, y: 219 },
				{ filename: "lowercase-m-09.png", x: 402, y: 219 },
				{ filename: "lowercase-m-10.png", x: 445, y: 219 },
				{ filename: "lowercase-m-11.png", x: 482, y: 239 },
				{ filename: "lowercase-m-12.png", x: 482, y: 311 },
				{ filename: "lowercase-m-13.png", x: 482, y: 360 },
				{ filename: "lowercase-m-14.png", x: 482, y: 402 },
				{ filename: "lowercase-m-15.png", x: 482, y: 441 },
				{ filename: "lowercase-m-16.png", x: 482, y: 481 },
				{ filename: "lowercase-m-17.png", x: 569, y: 219 },
				{ filename: "lowercase-m-18.png", x: 611, y: 219 },
				{ filename: "lowercase-m-19.png", x: 653, y: 219 },
				{ filename: "lowercase-m-20.png", x: 702, y: 219 },
				{ filename: "lowercase-m-21.png", x: 702, y: 290 },
				{ filename: "lowercase-m-22.png", x: 702, y: 332 },
				{ filename: "lowercase-m-23.png", x: 702, y: 370 },
				{ filename: "lowercase-m-24.png", x: 702, y: 411 },
				{ filename: "lowercase-m-25.png", x: 702, y: 452 },
				{ filename: "lowercase-m-26.png", x: 702, y: 492 }
		
			],
			payoff: { filename: "lowercase-m-payoff.png", x: 0, y: 0 }
		},{ //Round 14
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 99,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 103,
						duration: 2.2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 412, y: 240 }, 
				 { i: 1, x: 412, y: 523 }, 
				 { i: 2, x: 412, y: 299 }, 
				 { i: 3, x: 423, y: 277 }, 
				 { i: 4, x: 433, y: 267 }, 
				 { i: 5, x: 449, y: 255 }, 
				 { i: 6, x: 467, y: 247 }, 
				 { i: 7, x: 489, y: 241 }, 
				 { i: 8, x: 507, y: 237 }, 
				 { i: 9, x: 527, y: 237 }, 
				 { i: 10, x: 545, y: 237 }, 
				 { i: 11, x: 561, y: 239 }, 
				 { i: 12, x: 579, y: 245 }, 
				 { i: 13, x: 601, y: 255 }, 
				 { i: 14, x: 619, y: 269 }, 
				 { i: 15, x: 635, y: 287 }, 
				 { i: 16, x: 641, y: 311 }, 
				 { i: 17, x: 641, y: 339 }, 
				 { i: 18, x: 641, y: 375 }, 
				 { i: 19, x: 641, y: 433 }, 
				 { i: 20, x: 641, y: 523 }
			],
			hintPaths: [
				[0, 1 ],
				[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 ],
		
			targetItems: [
				{ filename: "lowercase-n-01.png", x: 405, y: 230 },
				{ filename: "lowercase-n-02.png", x: 446, y: 230 },
				{ filename: "lowercase-n-03.png", x: 493, y: 230 },
				{ filename: "lowercase-n-04.png", x: 524, y: 230 },
				{ filename: "lowercase-n-05.png", x: 555, y: 230 },
				{ filename: "lowercase-n-06.png", x: 585, y: 230 },
				{ filename: "lowercase-n-07.png", x: 405, y: 289 },
				{ filename: "lowercase-n-08.png", x: 405, y: 314 },
				{ filename: "lowercase-n-09.png", x: 405, y: 339 },
				{ filename: "lowercase-n-10.png", x: 405, y: 364 },
				{ filename: "lowercase-n-11.png", x: 405, y: 389 },
				{ filename: "lowercase-n-12.png", x: 405, y: 414 },
				{ filename: "lowercase-n-13.png", x: 405, y: 439 },
				{ filename: "lowercase-n-14.png", x: 405, y: 464 },
				{ filename: "lowercase-n-15.png", x: 405, y: 489 },
				{ filename: "lowercase-n-16.png", x: 593, y: 289 },
				{ filename: "lowercase-n-17.png", x: 609, y: 314 },
				{ filename: "lowercase-n-18.png", x: 609, y: 339 },
				{ filename: "lowercase-n-19.png", x: 609, y: 364 },
				{ filename: "lowercase-n-20.png", x: 609, y: 389 },
				{ filename: "lowercase-n-21.png", x: 609, y: 414 },
				{ filename: "lowercase-n-22.png", x: 609, y: 439 },
				{ filename: "lowercase-n-23.png", x: 609, y: 464 },
				{ filename: "lowercase-n-24.png", x: 609, y: 489 }
		
			],
			payoff: { filename: "lowercase-n-payoff.png", x: 0, y: 0 }
		},{ //Round 15
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 107,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 111,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 523, y: 235 }, 
				 { i: 1, x: 491, y: 239 }, 
				 { i: 2, x: 459, y: 249 }, 
				 { i: 3, x: 437, y: 265 }, 
				 { i: 4, x: 417, y: 281 }, 
				 { i: 5, x: 401, y: 305 }, 
				 { i: 6, x: 387, y: 331 }, 
				 { i: 7, x: 381, y: 357 }, 
				 { i: 8, x: 379, y: 385 }, 
				 { i: 9, x: 381, y: 413 }, 
				 { i: 10, x: 391, y: 441 }, 
				 { i: 11, x: 405, y: 463 }, 
				 { i: 12, x: 419, y: 483 },
				 { i: 13, x: 441, y: 501 }, 
				 { i: 14, x: 463, y: 515 }, 
				 { i: 15, x: 493, y: 525 }, 
				 { i: 16, x: 525, y: 529 }, 
				 { i: 17, x: 551, y: 527 }, 
				 { i: 18, x: 583, y: 519 }, 
				 { i: 19, x: 615, y: 501 }, 
				 { i: 20, x: 643, y: 475 }, 
				 { i: 21, x: 659, y: 445 }, 
				 { i: 22, x: 671, y: 407 }, 
				 { i: 23, x: 673, y: 361 }, 
				 { i: 24, x: 665, y: 331 }, 
				 { i: 25, x: 647, y: 295 }, 
				 { i: 26, x: 627, y: 275 }, 
				 { i: 27, x: 595, y: 251 }, 
				 { i: 28, x: 567, y: 239 }, 
				 { i: 29, x: 523, y: 235 }
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ],
			
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ],
			targetItems: [
				{ filename: "lowercase-o-01.png", x: 368, y: 256 },
				{ filename: "lowercase-o-02.png", x: 431, y: 227 },
				{ filename: "lowercase-o-03.png", x: 468, y: 227 },
				{ filename: "lowercase-o-04.png", x: 504, y: 227 },
				{ filename: "lowercase-o-05.png", x: 540, y: 227 },
				{ filename: "lowercase-o-06.png", x: 576, y: 227 },
				{ filename: "lowercase-o-07.png", x: 612, y: 246 },
				{ filename: "lowercase-o-08.png", x: 576, y: 327 },
				{ filename: "lowercase-o-09.png", x: 576, y: 360 },
				{ filename: "lowercase-o-10.png", x: 576, y: 396 },
				{ filename: "lowercase-o-11.png", x: 612, y: 431 },
				{ filename: "lowercase-o-12.png", x: 576, y: 431 },
				{ filename: "lowercase-o-13.png", x: 540, y: 431 },
				{ filename: "lowercase-o-14.png", x: 504, y: 431 },
				{ filename: "lowercase-o-15.png", x: 468, y: 431 },
				{ filename: "lowercase-o-16.png", x: 395, y: 468 },
				{ filename: "lowercase-o-17.png", x: 368, y: 431 },
				{ filename: "lowercase-o-18.png", x: 368, y: 396 },
				{ filename: "lowercase-o-19.png", x: 368, y: 360 }
		
			],
			payoff: { filename: "lowercase-o-payoff.png", x: 0 , y: 0  }
		},{ //Round 16
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 115,
						duration: 3.1
					},
					{
						name: "payoff",
						startTime: 119,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 444, y: 204 }, { i: 1, x: 445, y: 585 }, { i: 2, x: 444, y: 259 }, { i: 3, x: 456, y: 244 }, { i: 4, x: 470, y: 229 }, { i: 5, x: 484, y: 219 }, { i: 6, x: 499, y: 211 }, { i: 7, x: 520, y: 206 }, { i: 8, x: 541, y: 204 }, { i: 9, x: 561, y: 206 }, { i: 10, x: 578, y: 212 }, { i: 11, x: 596, y: 221 }, { i: 12, x: 611, y: 234 }, { i: 13, x: 622, y: 246 }, { i: 14, x: 632, y: 266 }, { i: 15, x: 639, y: 285 }, { i: 16, x: 641, y: 307 }, { i: 17, x: 639, y: 329 }, { i: 18, x: 633, y: 348 }, { i: 19, x: 624, y: 364 }, { i: 20, x: 611, y: 380 }, { i: 21, x: 595, y: 393 }, { i: 22, x: 580, y: 401 }, { i: 23, x: 564, y: 407 }, { i: 24, x: 547, y: 410 }, { i: 25, x: 529, y: 409 }, { i: 26, x: 514, y: 407 }, { i: 27, x: 500, y: 403 }, { i: 28, x: 488, y: 397 }, { i: 29, x: 475, y: 390 }, { i: 30, x: 465, y: 381 }, { i: 31, x: 455, y: 368 }
			],
			hintPaths: [
				[0, 1],
				[3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31],
			targetItems: [
				{ filename: "lowercase-p-01.png", x: 359, y: 181 },
				{ filename: "lowercase-p-02.png", x: 359, y: 271 },
				{ filename: "lowercase-p-03.png", x: 359, y: 345 },
				{ filename: "lowercase-p-04.png", x: 359, y: 418 },
				{ filename: "lowercase-p-05.png", x: 359, y: 489 },
				{ filename: "lowercase-p-06.png", x: 359, y: 540 },
				{ filename: "lowercase-p-07.png", x: 454, y: 181 },
				{ filename: "lowercase-p-08.png", x: 505, y: 181 },
				{ filename: "lowercase-p-09.png", x: 565, y: 181 },
				{ filename: "lowercase-p-10.png", x: 565, y: 271 },
				{ filename: "lowercase-p-11.png", x: 565, y: 345 },
				/*{ filename: "lowercase-p-12.png", x: 454, y: 271 },*/
				{ filename: "lowercase-p-13.png", x: 454, y: 345 },
				{ filename: "lowercase-p-14.png", x: 505, y: 345 }
			],
			payoff: { filename: "lowercase-p-payoff.png", x: 0, y: 0 }
		},{ //Round 17
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 123,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 127,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 572, y: 194 }, { i: 1, x: 567, y: 190 }, { i: 2, x: 555, y: 180 }, { i: 3, x: 541, y: 173 }, { i: 4, x: 525, y: 167 }, { i: 5, x: 506, y: 164 }, { i: 6, x: 489, y: 164 }, { i: 7, x: 468, y: 167 }, { i: 8, x: 453, y: 173 }, { i: 9, x: 439, y: 182 }, { i: 10, x: 424, y: 194 }, { i: 11, x: 413, y: 207 }, { i: 12, x: 403, y: 223 }, { i: 13, x: 397, y: 239 }, { i: 14, x: 394, y: 258 }, { i: 15, x: 395, y: 278 }, { i: 16, x: 398, y: 295 }, { i: 17, x: 404, y: 313 }, { i: 18, x: 415, y: 329 }, { i: 19, x: 427, y: 343 }, { i: 20, x: 442, y: 354 }, { i: 21, x: 457, y: 363 }, { i: 22, x: 475, y: 368 }, { i: 23, x: 495, y: 371 }, { i: 24, x: 513, y: 370 }, { i: 25, x: 529, y: 367 }, { i: 26, x: 545, y: 360 }, { i: 27, x: 560, y: 350 }, { i: 28, x: 578, y: 334 }, { i: 29, x: 589, y: 320 }, { i: 30, x: 589, y: 165 }, { i: 31, x: 588, y: 513 }, { i: 32, x: 594, y: 530 }, { i: 33, x: 604, y: 546 }, { i: 34, x: 616, y: 560 }, { i: 35, x: 631, y: 570 }, { i: 36, x: 645, y: 577 }, { i: 37, x: 659, y: 582 }, { i: 38, x: 674, y: 584 }, { i: 39, x: 690, y: 583 }, { i: 40, x: 707, y: 580 }, { i: 41, x: 723, y: 574 }, { i: 42, x: 739, y: 566 }, { i: 43, x: 751, y: 556 }, { i: 44, x: 757, y: 549 } 
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28],
				[30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44],
			targetItems: [
				{ filename: "lowercase-q-01.png", x: 685, y: 504 },
				{ filename: "lowercase-q-02.png", x: 642, y: 504 },
				{ filename: "lowercase-q-03.png", x: 572, y: 504 },
				{ filename: "lowercase-q-04.png", x: 572, y: 441 },
				{ filename: "lowercase-q-05.png", x: 572, y: 384 },
				{ filename: "lowercase-q-06.png", x: 572, y: 312 },
				{ filename: "lowercase-q-07.png", x: 572, y: 251 },
				{ filename: "lowercase-q-08.png", x: 572, y: 144 },
				{ filename: "lowercase-q-09.png", x: 503, y: 144 },
				{ filename: "lowercase-q-10.png", x: 503, y: 251 },
				{ filename: "lowercase-q-11.png", x: 436, y: 144 },
				{ filename: "lowercase-q-12.png", x: 436, y: 251 },
				{ filename: "lowercase-q-13.png", x: 374, y: 251 },
				{ filename: "lowercase-q-14.png", x: 374, y: 144 }
			],
			payoff: { filename: "lowercase-q-payoff.png", x: 0, y: 0 }
		},{ //Round 18
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 130,
						duration: 3.1
					},
					{
						name: "payoff",
						startTime: 134,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 429, y: 237 }, 
				 { i: 1, x: 429, y: 525 }, 
				 { i: 2, x: 429, y: 292 }, 
				 { i: 3, x: 436, y: 294 }, 
				 { i: 4, x: 447, y: 278 }, 
				 { i: 5, x: 457, y: 272 }, 
				 { i: 6, x: 473, y: 262 }, 
				 { i: 7, x: 485, y: 256 }, 
				 { i: 8, x: 503, y: 248 }, 
				 { i: 9, x: 513, y: 246 }, 
				 { i: 10, x: 527, y: 244 }, 
				 { i: 11, x: 537, y: 240 }, 
				 { i: 12, x: 549, y: 242 }, 
				 { i: 13, x: 567, y: 242 }, 
				 { i: 14, x: 581, y: 248 },
				 { i: 15, x: 597, y: 254 }, 
				 { i: 16, x: 613, y: 262 }, 
				 { i: 17, x: 625, y: 270 }, 
				 { i: 18, x: 643, y: 280 }, 
				 { i: 19, x: 655, y: 292 }
				
				
			],
			hintPaths: [
				[0, 1 ],
				[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19  ],
			targetItems: [
				{ filename: "lowercase-r-01.png", x: 396, y: 230 },
				{ filename: "lowercase-r-02.png", x: 396, y: 264 },
				{ filename: "lowercase-r-03.png", x: 396, y: 298 },
				{ filename: "lowercase-r-04.png", x: 396, y: 332 },
				{ filename: "lowercase-r-05.png", x: 396, y: 366 },
				{ filename: "lowercase-r-06.png", x: 396, y: 400 },
				{ filename: "lowercase-r-07.png", x: 396, y: 434 },
				{ filename: "lowercase-r-08.png", x: 396, y: 464 },
				{ filename: "lowercase-r-09.png", x: 396, y: 499 },
				{ filename: "lowercase-r-10.png", x: 436, y: 251 },
				{ filename: "lowercase-r-11.png", x: 470, y: 230 },
				{ filename: "lowercase-r-12.png", x: 504, y: 230 },
				{ filename: "lowercase-r-13.png", x: 542, y: 230 },
				{ filename: "lowercase-r-14.png", x: 579, y: 230 },
				{ filename: "lowercase-r-15.png", x: 615, y: 243 }
		
			],
			payoff: { filename: "lowercase-r-payoff.png", x: 0, y: 0 }
		},{ //Round 19
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 138,
						duration: 3.1
					},
					{
						name: "payoff",
						startTime: 142,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 635, y: 279 }, 
				{ i: 1, x: 600, y: 254 }, 
				{ i: 2, x: 584, y: 246 }, 
				{ i: 3, x: 566, y: 242 }, 
				{ i: 4, x: 548, y: 238 }, 
				{ i: 5, x: 528, y: 238 }, 
				{ i: 6, x: 512, y: 238 }, 
				{ i: 7, x: 498, y: 242 }, 
				{ i: 8, x: 480, y: 250 }, 
				{ i: 9, x: 464, y: 262 }, 
				{ i: 10, x: 454, y: 274 }, 
				{ i: 11, x: 448, y: 292 }, 
				{ i: 12, x: 448, y: 306 }, 
				{ i: 13, x: 452, y: 320 }, 
				{ i: 14, x: 458, y: 330 }, 
				{ i: 15, x: 466, y: 342 }, 
				{ i: 16, x: 478, y: 350 }, 
				{ i: 17, x: 514, y: 362 }, 
				{ i: 18, x: 541, y: 369 }, 
				{ i: 19, x: 560, y: 372 }, 
				{ i: 20, x: 588, y: 380 }, 
				{ i: 21, x: 608, y: 390 }, 
				{ i: 22, x: 626, y: 398 }, 
				{ i: 23, x: 636, y: 406 }, 
				{ i: 24, x: 646, y: 428 }, 
				{ i: 25, x: 650, y: 450 }, 
				{ i: 26, x: 646, y: 468 }, 
				{ i: 27, x: 638, y: 486 }, 
				{ i: 28, x: 628, y: 496 }, 
				{ i: 29, x: 618, y: 506 }, 
				{ i: 30, x: 600, y: 512 }, 
				{ i: 31, x: 580, y: 518 }, 
				{ i: 32, x: 560, y: 518 }, 
				{ i: 33, x: 538, y: 520 }, 
				{ i: 34, x: 518, y: 516 }, 
				{ i: 35, x: 504, y: 512 }, 
				{ i: 36, x: 464, y: 492 },
				{ i: 37, x: 447, y: 480 },
				{ i: 38, x: 430, y: 470 }, 
				{ i: 39, x: 420, y: 458 }
					
				
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 ],
		
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 ],
			targetItems: [
				{ filename: "lowercase-s-01.png", x: 558, y: 194 },
				{ filename: "lowercase-s-02.png", x: 512, y: 194 },
				{ filename: "lowercase-s-03.png", x: 467, y: 194 },
				{ filename: "lowercase-s-04.png", x: 394, y: 203 },
				{ filename: "lowercase-s-05.png", x: 404, y: 304 },
				{ filename: "lowercase-s-06.png", x: 467, y: 309 },
				{ filename: "lowercase-s-07.png", x: 512, y: 320 },
				{ filename: "lowercase-s-08.png", x: 558, y: 329 },
				{ filename: "lowercase-s-09.png", x: 558, y: 384 },
				{ filename: "lowercase-s-10.png", x: 575, y: 425 },
				{ filename: "lowercase-s-11.png", x: 629, y: 455 },
				{ filename: "lowercase-s-12.png", x: 589, y: 455 },
				{ filename: "lowercase-s-13.png", x: 550, y: 455 },
				{ filename: "lowercase-s-14.png", x: 507, y: 455 },
				{ filename: "lowercase-s-15.png", x: 461, y: 434 },
				{ filename: "lowercase-s-16.png", x: 389, y: 415 }
		
			],
			payoff: { filename: "lowercase-s-payoff.png", x: 0, y: 0 }
		},{ //Round 20
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 146,
						duration: 3.3
					},
					{
						name: "payoff",
						startTime: 150,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 526, y: 177 }, 
				{ i: 1, x: 526, y: 585 }, 
				{ i: 2, x: 526, y: 383 }, 
				{ i: 3, x: 440, y: 383 }, 
				{ i: 4, x: 608, y: 383 } 
			],
			hintPaths: [
				[0, 1],
				[3, 4]
			],
			successPath: [0, 1, 2, 3, 2, 4],
			targetItems: [
				{ filename: "lowercase-t-01.png", x: 480, y: 146 },
				{ filename: "lowercase-t-02.png", x: 480, y: 205 },
				{ filename: "lowercase-t-03.png", x: 480, y: 265 },
				{ filename: "lowercase-t-04.png", x: 480, y: 307 },
				{ filename: "lowercase-t-05.png", x: 426, y: 344 },
				{ filename: "lowercase-t-06.png", x: 480, y: 344 },
				{ filename: "lowercase-t-07.png", x: 575, y: 344 },
				{ filename: "lowercase-t-08.png", x: 480, y: 420 },
				{ filename: "lowercase-t-09.png", x: 480, y: 474 },
				{ filename: "lowercase-t-10.png", x: 480, y: 539 }
			],
			payoff: { filename: "lowercase-t-payoff.png", x: 0, y: 0 }
		},{ //Round 21
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 153,
						duration: 3.2
					},
					{
						name: "payoff",
						startTime: 157,
						duration: 2 
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 412, y: 248 }, 
				 { i: 1, x: 412, y: 442 }, 
				 { i: 2, x: 415, y: 457 }, 
				 { i: 3, x: 423, y: 471 }, 
				 { i: 4, x: 431, y: 485 }, 
				 { i: 5, x: 445, y: 499 }, 
				 { i: 6, x: 467, y: 511 }, 
				 { i: 7, x: 487, y: 519 }, 
				 { i: 8, x: 513, y: 523 }, 
				 { i: 9, x: 535, y: 523 }, 
				 { i: 10, x: 559, y: 521 }, 
				 { i: 11, x: 587, y: 513 },
				 { i: 12, x: 609, y: 501 }, 
				 { i: 13, x: 627, y: 487 }, 
				 { i: 14, x: 641, y: 471 }, 
				 { i: 15, x: 641, y: 248 }, 
				 { i: 16, x: 641, y: 522 }
			],
			hintPaths: [
				[0, 1 , 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 ],
				[14, 16 ]
				
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16  ],
			targetItems: [
				{ filename: "lowercase-u-01.png", x: 403, y: 228 },
				{ filename: "lowercase-u-02.png", x: 403, y: 271 },
				{ filename: "lowercase-u-03.png", x: 403, y: 314 },
				{ filename: "lowercase-u-04.png", x: 403, y: 357 },
				{ filename: "lowercase-u-05.png", x: 403, y: 400 },
				{ filename: "lowercase-u-06.png", x: 403, y: 435 },
				{ filename: "lowercase-u-07.png", x: 444, y: 435 },
				{ filename: "lowercase-u-08.png", x: 485, y: 469 },
				{ filename: "lowercase-u-09.png", x: 526, y: 469 },
				{ filename: "lowercase-u-10.png", x: 567, y: 435 },
				{ filename: "lowercase-u-11.png", x: 608, y: 470 },
				{ filename: "lowercase-u-12.png", x: 608, y: 435 },
				{ filename: "lowercase-u-13.png", x: 608, y: 400 },
                { filename: "lowercase-u-14.png", x: 608, y: 357 },
				{ filename: "lowercase-u-15.png", x: 608, y: 314 },
				{ filename: "lowercase-u-16.png", x: 608, y: 271 },
                { filename: "lowercase-u-17.png", x: 608, y: 228 }
							
			],
			payoff: { filename: "lowercase-u-payoff.png", x: 0 , y: 0 }
		},{ //Round 22
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 161,
						duration: 3.1
					},
					{
						name: "payoff",
						startTime: 165,
						duration: 2.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 394, y: 245 }, 
				{ i: 1, x: 526, y: 525 },
				{ i: 2, x: 654, y: 245 } 
			],
			hintPaths: [
				[0, 1, 2 ],
				
			],
			successPath: [0, 1, 2 ],
			targetItems: [
				{ filename: "lowercase-v-01.png", x: 378, y: 228 },
				{ filename: "lowercase-v-02.png", x: 395, y: 269 },
				{ filename: "lowercase-v-03.png", x: 414, y: 310 },
				{ filename: "lowercase-v-04.png", x: 431, y: 351 },
				{ filename: "lowercase-v-05.png", x: 452, y: 387 },
				{ filename: "lowercase-v-06.png", x: 452, y: 429 },
				{ filename: "lowercase-v-07.png", x: 486, y: 468 },
				{ filename: "lowercase-v-08.png", x: 526, y: 468 },
				{ filename: "lowercase-v-09.png", x: 526, y: 429 },
				{ filename: "lowercase-v-10.png", x: 526, y: 387 },
				{ filename: "lowercase-v-11.png", x: 550, y: 351 },
				{ filename: "lowercase-v-12.png", x: 569, y: 310 },
				{ filename: "lowercase-v-13.png", x: 584, y: 269 },
				{ filename: "lowercase-v-14.png", x: 605, y: 228 }

			],
			payoff: { filename: "lowercase-v-payoff.png", x: 0, y: 0 }
		},{ //Round 23
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 169,
						duration: 3.1
					},
					{
						name: "payoff",
						startTime: 173,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 323, y: 273 }, 
				{ i: 1, x: 428, y: 519 }, 
				{ i: 2, x: 528, y: 294 },
				{ i: 3, x: 632, y: 519 },
				{ i: 4, x: 740, y: 266 }
			
				
			],
			hintPaths: [
				[0, 1, 2, 3, 4 ],
				
			],
			successPath: [0, 1, 2, 3, 4 ],
			targetItems: [
				{ filename: "lowercase-w-01.png", x: 295, y: 231 },
				{ filename: "lowercase-w-02.png", x: 310, y: 272 },
				{ filename: "lowercase-w-03.png", x: 328, y: 313 },
				{ filename: "lowercase-w-04.png", x: 345, y: 354 },
				{ filename: "lowercase-w-05.png", x: 357, y: 394 },
				{ filename: "lowercase-w-06.png", x: 357, y: 432 },
				{ filename: "lowercase-w-07.png", x: 389, y: 471 },
				{ filename: "lowercase-w-08.png", x: 429, y: 471 },
				{ filename: "lowercase-w-09.png", x: 429, y: 432 },
				{ filename: "lowercase-w-10.png", x: 429, y: 394 },
				{ filename: "lowercase-w-11.png", x: 453, y: 354 },
				{ filename: "lowercase-w-12.png", x: 472, y: 228 },
				{ filename: "lowercase-w-13.png", x: 528, y: 228 },
				{ filename: "lowercase-w-14.png", x: 543, y: 354 },
				{ filename: "lowercase-w-15.png", x: 563, y: 394 },
				{ filename: "lowercase-w-16.png", x: 563, y: 432 },
				{ filename: "lowercase-w-17.png", x: 591, y: 471 },
				{ filename: "lowercase-w-18.png", x: 631, y: 471 },
				{ filename: "lowercase-w-19.png", x: 631, y: 432 },
				{ filename: "lowercase-w-20.png", x: 631, y: 394 },
				{ filename: "lowercase-w-21.png", x: 655, y: 354 },
				{ filename: "lowercase-w-22.png", x: 668, y: 313 },
				{ filename: "lowercase-w-23.png", x: 689, y: 272 },
				{ filename: "lowercase-w-24.png", x: 703, y: 231 }
							
				
			],
			payoff: { filename: "lowercase-w-payoff.png", x: 0 , y: 0  }
		},{ //Round 24
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 177,
						duration: 3.3
					},
					{
						name: "payoff",
						startTime: 181,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 397, y: 238 }, 
				{ i: 1, x: 665, y: 523 }, 
				{ i: 2, x: 653, y: 238 }, 
				{ i: 3, x: 381, y: 523 },
				{ i: 4, x: 523, y: 373 }
						
				
			],
			hintPaths: [
				[0, 4, 1 ],
				[2, 4, 3 ]
			],
			successPath: [0, 1, 4, 2, 3 ],
			targetItems: [
				{ filename: "lowercase-x-01.png", x: 326, y: 225 },
				{ filename: "lowercase-x-02.png", x: 365, y: 261 },
				{ filename: "lowercase-x-03.png", x: 402, y: 297 },
				{ filename: "lowercase-x-04.png", x: 426, y: 333 },
				{ filename: "lowercase-x-05.png", x: 523, y: 372 },
				{ filename: "lowercase-x-06.png", x: 547, y: 411 },
				{ filename: "lowercase-x-07.png", x: 581, y: 447 },
				{ filename: "lowercase-x-08.png", x: 615, y: 486 },
				{ filename: "lowercase-x-09.png", x: 615, y: 225 },
				{ filename: "lowercase-x-10.png", x: 581, y: 261 },
				{ filename: "lowercase-x-11.png", x: 547, y: 297 },
				{ filename: "lowercase-x-12.png", x: 523, y: 333 },
				{ filename: "lowercase-x-13.png", x: 426, y: 372 },
				{ filename: "lowercase-x-14.png", x: 402, y: 411 },
				{ filename: "lowercase-x-15.png", x: 365, y: 447 },
				{ filename: "lowercase-x-16.png", x: 326, y: 486 }
				
			],
			payoff: { filename: "lowercase-x-payoff.png", x: 0, y: 0 }
		},{ //Round 25
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 185,
						duration: 3.5
					},
					{
						name: "payoff",
						startTime: 189,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-3.png",
						numFrames: 34,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 441, y: 205 }, { i: 1, x: 516, y: 370 }, { i: 2, x: 522, y: 384 }, { i: 3, x: 596, y: 205 }, { i: 4, x: 439, y: 584 }
			],
			hintPaths: [
				[0, 1],
				[3, 4]
			],
			successPath: [0, 1, 2, 3, 4],
			targetItems: [
				{ filename: "lowercase-y-01.png", x: 401, y: 177 },
				{ filename: "lowercase-y-02.png", x: 416, y: 243 },
				{ filename: "lowercase-y-03.png", x: 422, y: 280 },
				{ filename: "lowercase-y-04.png", x: 444, y: 308 },
				{ filename: "lowercase-y-05.png", x: 457, y: 350 },
				{ filename: "lowercase-y-06.png", x: 482, y: 411 },
				{ filename: "lowercase-y-07.png", x: 457, y: 462 },
				{ filename: "lowercase-y-08.png", x: 438, y: 496 },
				{ filename: "lowercase-y-09.png", x: 422, y: 543 },
				{ filename: "lowercase-y-10.png", x: 571, y: 177 },
				{ filename: "lowercase-y-11.png", x: 540, y: 243 },
				{ filename: "lowercase-y-12.png", x: 521, y: 280 },
				{ filename: "lowercase-y-13.png", x: 521, y: 308 },
				{ filename: "lowercase-y-14.png", x: 521, y: 350 }
			],
			payoff: { filename: "lowercase-y-payoff.png", x: 0 , y: 0  }
		},{ //Round 26
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 192,
						duration: 3.5
					},
					{
						name: "payoff",
						startTime: 196,
						duration: 2.7
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "BigBird-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "BigBird-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -55,
						offsetY: -190
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 465, y: 237 }, 
				{ i: 1, x: 652, y: 237 }, 
				{ i: 2, x: 453, y: 501 },  
				{ i: 3, x: 633, y: 501 }
							
				
			],
			hintPaths: [
				[0, 1, 2, 3 ],
				
			],
			successPath: [0, 1, 2, 3 ],
			targetItems: [
				{ filename: "lowercase-z-01.png", x: 422, y: 228 },
				{ filename: "lowercase-z-02.png", x: 468, y: 228 },
				{ filename: "lowercase-z-03.png", x: 514, y: 228 },
				{ filename: "lowercase-z-04.png", x: 560, y: 228 },
				{ filename: "lowercase-z-05.png", x: 606, y: 228 },
				{ filename: "lowercase-z-06.png", x: 557, y: 266 },
				{ filename: "lowercase-z-07.png", x: 529, y: 304 },
				{ filename: "lowercase-z-08.png", x: 499, y: 342 },
				{ filename: "lowercase-z-09.png", x: 474, y: 380 },
				{ filename: "lowercase-z-10.png", x: 446, y: 418 },
				{ filename: "lowercase-z-11.png", x: 416, y: 456 },
				{ filename: "lowercase-z-12.png", x: 393, y: 492 },
				{ filename: "lowercase-z-13.png", x: 479, y: 492 },
				{ filename: "lowercase-z-14.png", x: 529, y: 492 },
				{ filename: "lowercase-z-15.png", x: 583, y: 492 }
			],
			payoff: { filename: "lowercase-z-payoff.png", x:0 , y: 0 }
		}
	]
}