(function app() {
	'use strict';

	function ready() {
		if (!navigator.onLine) {
			return;
		}

		var url = 'http://www.bing.com';
		location.replace(url);
	}

	// Called on start and on every offline/online event
	function onlineCheck() {
		if (navigator.onLine) {
			document.documentElement.classList.remove('is-offline');
			ready();
		} else {
			document.documentElement.classList.add('is-offline');
		}
	}

	// Called on load to ensure splashscreen
	window.addEventListener('load', function() {
		window.addEventListener('online', onlineCheck);
		window.addEventListener('offline', onlineCheck);
		onlineCheck();
	});
}());
