var fBirds = {};
var fBirdCalls = {};
var fBirdCallsTitles = {};

fBirds[1] = "Blackbird";
fBirds[2] = "European Turtle Dove";
fBirds[3] = "Hooded Crow";
fBirds[4] = "Magpie";
fBirds[5] = "Mourning Dove";
fBirds[6] = "Song Thrush";


var callCounter = 0;

// Black bird
callCounter = 0;
var blackBirdMP3s = {};
var blackBirdMP3Titles = {}

blackBirdMP3s[callCounter] = "/calls/call_black_bird_call_1.mp3";
blackBirdMP3Titles[callCounter] = "Call #1";
callCounter++;

blackBirdMP3s[callCounter] = "/calls/call_black_bird_call_2.mp3";
blackBirdMP3Titles[callCounter] = "Call #2";
callCounter++;

blackBirdMP3s[callCounter] = "/calls/call_black_bird_call_3.mp3";
blackBirdMP3Titles[callCounter] = "Call #3";
callCounter++;

blackBirdMP3s[callCounter] = "/calls/call_black_bird_call_agitated.mp3";
blackBirdMP3Titles[callCounter] = "Agitated";
callCounter++;

blackBirdMP3s[callCounter] = "/calls/call_black_bird_evening_alarm.mp3";
blackBirdMP3Titles[callCounter] = "Evening Alarm";
callCounter++;

fBirdCalls[1] = blackBirdMP3s;
fBirdCallsTitles[1] = blackBirdMP3Titles;

// European Turtle Dove
callCounter = 0;
var europeanTurtleDoveMP3s = {};
var europeanTurtleDoveMP3Titles = {}

europeanTurtleDoveMP3s[callCounter] = "/calls/call_european_turtle_dove_call_1.mp3";
europeanTurtleDoveMP3Titles[callCounter] = "Call #1";
callCounter++;

fBirdCalls[2] = europeanTurtleDoveMP3s;
fBirdCallsTitles[2] = europeanTurtleDoveMP3Titles;

// Hooded Crow
callCounter = 0;
var hoodedCrowMP3s = {};
var hoodedCrowMP3Titles = {};

hoodedCrowMP3s[callCounter] = "/calls/call_hooded_crow_call.mp3";
hoodedCrowMP3Titles[callCounter] = "Call #1";
callCounter++;

hoodedCrowMP3s[callCounter] = "/calls/call_hooded_crow_crows_in_distress.mp3";
hoodedCrowMP3Titles[callCounter] = "Crows in distress #1";
callCounter++;

hoodedCrowMP3s[callCounter] = "/calls/call_hooded_crow_crows_in_distress_2.mp3";
hoodedCrowMP3Titles[callCounter] = "Crows in distress #2";
callCounter++;

hoodedCrowMP3s[callCounter] = "/calls/call_hooded_crow_several_calls.mp3";
hoodedCrowMP3Titles[callCounter] = "Several Calls";
callCounter++;

fBirdCalls[3] = hoodedCrowMP3s;
fBirdCallsTitles[3] = hoodedCrowMP3Titles;

// Magpie
callCounter = 0;
var magpieMP3s = {};
var magpieMP3Titles = {};

magpieMP3s[callCounter] = "/calls/call_magpie_call_1.mp3";
magpieMP3Titles[callCounter] = "Call #1";
callCounter++;

magpieMP3s[callCounter] = "/calls/call_magpie_call_2.mp3";
magpieMP3Titles[callCounter] = "Call #2";
callCounter++;

fBirdCalls[4] = magpieMP3s;
fBirdCallsTitles[4] = magpieMP3Titles;

// Mourning Dove
callCounter = 0;
var mourningDoveMP3s = {};
var mourningDoveMP3Titles = {};

mourningDoveMP3s[callCounter] = "/calls/call_mourning_dove_distress_call.mp3";
mourningDoveMP3Titles[callCounter] = "Distress Call";
callCounter++;

mourningDoveMP3s[callCounter] = "/calls/call_mourning_dove_song.mp3";
mourningDoveMP3Titles[callCounter] = "Song #1";
callCounter++;

mourningDoveMP3s[callCounter] = "/calls/call_mourning_dove_wing_whistle_from_flushed_bird.mp3";
mourningDoveMP3Titles[callCounter] = "Wing Whistle";
callCounter++;

fBirdCalls[5] = mourningDoveMP3s;
fBirdCallsTitles[5] = mourningDoveMP3Titles;

// Song Thrush
callCounter = 0;
var songThrushMP3s = {};
var songThrushTitles = {};

songThrushMP3s[callCounter] = "/calls/call_song_thrush_call_1.mp3";
songThrushTitles[callCounter] = "Call #1";
callCounter++;

songThrushMP3s[callCounter] = "/calls/call_song_thrush_call_2.mp3";
songThrushTitles[callCounter] = "Call #2";
callCounter++;

songThrushMP3s[callCounter] = "/calls/call_song_thrush_call_3.mp3";
songThrushTitles[callCounter] = "Call #3";
callCounter++;

fBirdCalls[6] = songThrushMP3s;
fBirdCallsTitles[6] = songThrushTitles;


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function CreateBirdsTable()
{
	var mainMenu = document.getElementById("MainMenu");
		
	var birdsIds = Object.keys(fBirds);
		
	for(var i=1; i <=birdsIds.length; i++)
	{
		var outPut = "";
		var birdTitle = fBirds[i];
		outPut = '<div class="BirdTitle">' + birdTitle + "</div>";
		
		try
		{
			// Get bird calls

			var birdCallsCount = Object.keys(fBirdCalls[i]).length;

			for(var x=0; x<birdCallsCount; x++)
			{
				var callTitle = fBirdCallsTitles[i][x];
				var callMP3 = fBirdCalls[i][x];
				var id = i +"_" + x;
				outPut += '<div class="BirdCall" id="BirdCall_'+id+'" onclick="PlaySound('+i+','+x+')">' + callTitle+"</div>";
			}
		}
		catch(e)
		{
		}
		
				
		mainMenu.innerHTML +=outPut;
	}
}

var fCurrentPlayingCall_BirdID = 0;
var fCurrentPlayingCall_CallID = 0;
var fCurrentPlayingCall = null;

function PlaySound(birdID,callID)
{
	StopPlayingSound ();
	
	var birdCallElements = document.getElementsByClassName("BirdCall");
	for(var i=0; i<birdCallElements.length; i++)
	{
			birdCallElements[i].style.background = "white";
	}
	
	if(fCurrentPlayingCall_BirdID == birdID && fCurrentPlayingCall_CallID==callID)
	{
		fCurrentPlayingCall_BirdID  = -1;
		 fCurrentPlayingCall_CallID = -1;
		return;
	}
	
	var id = "BirdCall_"+birdID+"_"+callID;
	document.getElementById(id).style.background = "blue";
	
	var mp3 = fBirdCalls[birdID][callID];
		
	fCurrentPlayingCall_BirdID = birdID;
	fCurrentPlayingCall_CallID = callID;
	
	// Play new call
	fCurrentPlayingCall = new Audio(mp3);
	fCurrentPlayingCall.play();
	
}


function StopPlayingSound()
{
	try
	{
		fCurrentPlayingCall.pause();
	}
	catch(Ex)
	{
		//alert(Ex);
	}
}




