
//======================================================== FASTCLICK
         function FastButton(element, handler) {
            this.element = element;
            this.handler = handler;
            element.addEventListener('touchstart', this, false);
         };
         FastButton.prototype.handleEvent = function(event) {
            switch (event.type) {
               case 'touchstart': this.onTouchStart(event); break;
               case 'touchmove': this.onTouchMove(event); break;
               case 'touchend': this.onClick(event); break;
               case 'click': this.onClick(event); break;
            }
         };
         FastButton.prototype.onTouchStart = function(event) {
			//event.stopPropagation();
            this.element.addEventListener('touchend', this, false);
            document.body.addEventListener('touchmove', this, false);
            this.startX = event.touches[0].clientX;
            this.startY = event.touches[0].clientY;
			//isMoving = false;
         };
         FastButton.prototype.onTouchMove = function(event) {
            if(Math.abs(event.touches[0].clientX - this.startX) > 10 || Math.abs(event.touches[0].clientY - this.startY) > 10) {
               this.reset();
            }
         };
         FastButton.prototype.onClick = function(event) {
			event.stopPropagation();
            this.reset();
            this.handler(event);
            if(event.type == 'touchend') {
               preventGhostClick(this.startX, this.startY);
            }
         };
         FastButton.prototype.reset = function() {
            this.element.removeEventListener('touchend', this, false);
            document.body.removeEventListener('touchmove', this, false);			
         };
         function preventGhostClick(x, y) {
            coordinates.push(x, y);
            window.setTimeout(gpop, 2500);
         };
         function gpop() {
            coordinates.splice(0, 2);
         };
         function gonClick(event) {
            for(var i = 0; i < coordinates.length; i += 2) {
               var x = coordinates[i];
               var y = coordinates[i + 1];
               if(Math.abs(event.clientX - x) < 25 && Math.abs(event.clientY - y) < 25) {
                  event.stopPropagation();
                  event.preventDefault();
               }
            }
         };
         document.addEventListener('click', gonClick, true);
         var coordinates = [];
         function initFastButtons() {
			new FastButton(document.getElementById("fastclick"), goSomewhere);
         };
         function goSomewhere() {
			var theTarget = document.elementFromPoint(this.startX, this.startY);
			if(theTarget.nodeType == 3) theTarget = theTarget.parentNode;
			
			var theParent = theTarget;
			
			// Set button style back to normal
			while (theParent.tagName !== "LI") {										// Keep looking for the parent element until we hit the LI. That takes care of both buttons and list items
				if (theParent.tagName === "FORM" || theParent.tagName === "BODY" ) {
					break;
				}
				theParent = theParent.parentNode;
				if (theParent.className.indexOf("ui-btn-down-a") !== -1) {				// If the button class A is a button down, then
					theParent.className = theParent.className.replace("ui-btn-down-a","ui-btn-up-a");	// Make it button up.
				}
				if (theParent.className.indexOf("ui-btn-down-d") !== -1) {				// If the button class D is a button down, then
					theParent.className = theParent.className.replace("ui-btn-down-d","ui-btn-up-d");	// Make it button up.
				}
			}
			// Slash set button style
						
			var theEvent = document.createEvent('MouseEvents');
			theEvent.initEvent('click', true, true);
			theTarget.dispatchEvent(theEvent);
         };
//========================================================
