// load I18N bundles
var I18N = "$.i18n";
var HREF_LANG_PARAM = "?lang=";

$('.ui-link-inherit').live('click', function(event){
	event.preventDefault();
	event.stopImmediatePropagation();
	event.stopPropagation(); 
   //do your magic
    window.location.href=$(this).attr("href");
});
$(document).bind('mobileinit', function(){
	$.mobile.defaultPageTransition  = 'none';
	$.mobile.defaultDialogTransition  = 'none';
	$.mobile.useFastClick  = true;
});

jQuery(document).ready(function() {
	loadBundles();
});
	 
function loadBundles() {
	var page= location.pathname.substring(location.pathname.lastIndexOf("/") + 1);
	if(page=="index.html") path = "./assets/lang/";
	else path = "./../assets/lang/";
	lang=getLanguage();
	jQuery.i18n.properties({
		name:'birziklapp',
		path:path,
		mode:'map',
		language:lang,
		callback: function() {
			$('.i18n:contains('+I18N+')').each(function() {
			  if ($(this).text().indexOf(I18N) !=-1) {
			  	var str = $(this).text().trim();
			  	str = jQuery.i18n.prop(str.substring(I18N.length+2, str.length-2));
			  	$(this).text(str);
			  }
			});
		}
	});
}

function getParameter(name){
	var searchString = window.location.search.substring(1);
	var params = searchString.split("&");
	
	for(i=0;i<params.length;i++){
		val = params[i].split("=");
		if(val[0]==name){
			return unescape(val[1]);
		}
	}
	return null;
}

function getLanguage(){
	lang=getBalioa('Hizkuntza');
	if(lang=='CAST') return lang='es_ES';
	else return lang='eu_ES';
}
